/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.dbTarget.db.changemgr.emo.docaccess;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.SXMLPrefixResolver;
import oracle.sysman.dbTarget.db.changemgr.emo.docaccess.XMLAccessor;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.parser.v2.XSLProcessor;
import oracle.xml.parser.v2.XSLStylesheet;
import org.apache.log4j.Category;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CMXMLUtils {
    public static final String SXML_NS_PREFIX = "sxml";
    private static SXMLPrefixResolver s_resolver = new SXMLPrefixResolver();
    static final char PLATFORM_FILE_SEPARATOR_CHAR = System.getProperty("file.separator").charAt(0);
    static final boolean FILE_SEP_NOT_FRONTSLASH = PLATFORM_FILE_SEPARATOR_CHAR != '/';
    private static final Category s_log = Category.getInstance(CMXMLUtils.class);

    public static String getTextNodeValue(Document doc, String xpath) {
        String value;
        block4: {
            if (doc == null || xpath == null || (xpath = xpath.trim()).length() == 0) {
                return null;
            }
            value = null;
            try {
                NodeList childNodes;
                Node node = ((XMLDocument)doc).selectSingleNode(xpath, (NSResolver)s_resolver);
                if (node != null && node.getNodeType() == 1 && (childNodes = node.getChildNodes()) != null && childNodes.getLength() > 0) {
                    value = childNodes.item(0).getNodeValue();
                }
            }
            catch (XSLException e) {
                if (!s_log.isDebugEnabled()) break block4;
                s_log.debug((Object)("XSLException: " + e.getMessage()));
            }
        }
        return value;
    }

    public static String getRelativeTextNodeValue(XMLNode n, String xpath) {
        String value;
        block4: {
            if (n == null) {
                return null;
            }
            Object node = null;
            value = null;
            try {
                NodeList childNodes;
                node = xpath == null || (xpath = xpath.trim()).length() == 0 ? n : n.selectSingleNode(xpath, (NSResolver)s_resolver);
                if (node != null && node.getNodeType() == 1 && (childNodes = node.getChildNodes()) != null && childNodes.getLength() > 0) {
                    value = childNodes.item(0).getNodeValue();
                }
            }
            catch (XSLException e) {
                if (!s_log.isDebugEnabled()) break block4;
                s_log.debug((Object)("XSLException: " + e.getMessage()));
            }
        }
        return value;
    }

    public static void setTextNodeValue(Document doc, String xpath, String newValue) {
        block4: {
            if (doc == null || xpath == null || (xpath = xpath.trim()).length() == 0) {
                return;
            }
            try {
                NodeList childNodes;
                Node theNode = ((XMLDocument)doc).selectSingleNode(xpath, (NSResolver)s_resolver);
                if (theNode != null && theNode.getNodeType() == 1 && (childNodes = theNode.getChildNodes()) != null && childNodes.getLength() > 0) {
                    childNodes.item(0).setNodeValue(newValue);
                }
            }
            catch (XSLException e) {
                if (!s_log.isDebugEnabled()) break block4;
                s_log.debug((Object)("XSLException: " + e.getMessage()));
            }
        }
    }

    public static void setRelativeTextNodeValue(XMLNode n, String xpath, String newValue) {
        block4: {
            if (n == null) {
                return;
            }
            Object node = null;
            try {
                NodeList childNodes;
                node = xpath == null || (xpath = xpath.trim()).length() == 0 ? n : n.selectSingleNode(xpath, (NSResolver)s_resolver);
                if (node != null && node.getNodeType() == 1 && (childNodes = node.getChildNodes()) != null && childNodes.getLength() > 0) {
                    childNodes.item(0).setNodeValue(newValue);
                }
            }
            catch (XSLException e) {
                if (!s_log.isDebugEnabled()) break block4;
                s_log.debug((Object)("XSLException: " + e.getMessage()));
            }
        }
    }

    public static String selectTextValue(XMLNode n, String xpath) {
        String value;
        block4: {
            if (n == null || xpath == null || (xpath = xpath.trim()).length() == 0) {
                return null;
            }
            value = null;
            try {
                NodeList childNodes;
                Node node = n.selectSingleNode(xpath, (NSResolver)s_resolver);
                if (node != null && node.getNodeType() == 1 && (childNodes = node.getChildNodes()) != null && childNodes.getLength() > 0) {
                    value = childNodes.item(0).getNodeValue();
                }
            }
            catch (XSLException e) {
                if (!s_log.isDebugEnabled()) break block4;
                s_log.debug((Object)("XSLException: " + e.getMessage()));
            }
        }
        return value;
    }

    public static String[] selectTextValues(XMLNode n, String xpath) {
        String[] values;
        block5: {
            if (n == null || xpath == null || (xpath = xpath.trim()).length() == 0) {
                return null;
            }
            values = null;
            try {
                NodeList nodeList = n.selectNodes(xpath, (NSResolver)s_resolver);
                if (nodeList.getLength() > 0) {
                    values = new String[nodeList.getLength()];
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        NodeList childNodes;
                        Node node = nodeList.item(i);
                        if (node == null || node.getNodeType() != 1 || (childNodes = node.getChildNodes()) == null || childNodes.getLength() <= 0) continue;
                        values[i] = childNodes.item(0).getNodeValue();
                    }
                }
            }
            catch (XSLException e) {
                if (!s_log.isDebugEnabled()) break block5;
                s_log.debug((Object)("XSLException: " + e.getMessage()));
            }
        }
        return values;
    }

    public static NodeList selectNodes(XMLNode n, String xpath) {
        NodeList nodes;
        block3: {
            if (n == null || xpath == null || (xpath = xpath.trim()).length() == 0) {
                return null;
            }
            nodes = null;
            try {
                nodes = n.selectNodes(xpath, (NSResolver)s_resolver);
            }
            catch (XSLException e) {
                if (!s_log.isDebugEnabled()) break block3;
                s_log.debug((Object)("XSLException: " + e.getMessage()));
            }
        }
        return nodes;
    }

    public static Node getPINode(Document doc, String xpath) {
        block4: {
            try {
                Node node = ((XMLDocument)doc).selectSingleNode(xpath, (NSResolver)s_resolver);
                if (node != null) {
                    NodeList childNodes = node.getChildNodes();
                    Node child = null;
                    int l = childNodes.getLength();
                    for (int i = 0; i < l; ++i) {
                        child = childNodes.item(i);
                        if (child == null || child.getNodeType() != 7) continue;
                        return child;
                    }
                }
            }
            catch (Throwable t) {
                if (!s_log.isDebugEnabled()) break block4;
                t.printStackTrace();
            }
        }
        return null;
    }

    public static boolean nodeExists(XMLNode n, String xpath) {
        boolean exists;
        block3: {
            exists = false;
            if (n != null && xpath != null && (xpath = xpath.trim()).length() > 0) {
                try {
                    Node node = n.selectSingleNode(xpath, (NSResolver)s_resolver);
                    exists = node != null;
                }
                catch (XSLException e) {
                    if (!s_log.isDebugEnabled()) break block3;
                    s_log.debug((Object)("XSLException: " + e.getMessage()));
                }
            }
        }
        return exists;
    }

    public static XMLNode getNode(XMLNode sn, String xpath) {
        XMLNode n;
        block3: {
            n = null;
            if (sn != null && xpath != null && (xpath = xpath.trim()).length() > 0) {
                try {
                    n = (XMLNode)sn.selectSingleNode(xpath, (NSResolver)s_resolver);
                }
                catch (XSLException e) {
                    if (!s_log.isDebugEnabled()) break block3;
                    s_log.debug((Object)("XSLException: " + e.getMessage()));
                }
            }
        }
        return n;
    }

    public static boolean removeNode(XMLNode sn, String xpath) {
        XMLNode parent;
        XMLNode node;
        boolean didRemove = false;
        XMLNode xMLNode = node = xpath != null ? CMXMLUtils.getNode(sn, xpath) : sn;
        if (node != null && (parent = (XMLNode)node.getParentNode()) != null) {
            try {
                parent.removeChild((Node)node);
                didRemove = true;
            }
            catch (DOMException de) {
                System.out.println("Unable to remove node: not allowed.");
            }
        }
        return didRemove;
    }

    public static XMLNode createNode(XMLNode baseNode, String path, String nodeName, String textValue) {
        XMLNode parentNode;
        if (nodeName == null) {
            nodeName = CMXMLUtils.lastElement(path);
        }
        XMLNode xMLNode = parentNode = (path = CMXMLUtils.stripLastElement(path)) != null ? CMXMLUtils.getNode(baseNode, path) : baseNode;
        if (parentNode == null) {
            parentNode = CMXMLUtils.createNode(baseNode, path, null, null);
        }
        XMLElement newNode = null;
        if (parentNode != null) {
            XMLDocument doc = (XMLDocument)parentNode.getOwnerDocument();
            newNode = (XMLElement)doc.createElementNS(doc.getFirstChild().getNamespaceURI(), "sxml:" + nodeName);
            if (textValue != null) {
                newNode.addText(textValue);
            }
            parentNode.appendChild((Node)newNode);
        }
        return newNode;
    }

    private static String lastElement(String path) {
        int lastColonPos;
        String lastElement = null;
        if (path != null && (lastColonPos = path.lastIndexOf(58)) > -1) {
            lastElement = path.substring(lastColonPos + 1);
        }
        return lastElement;
    }

    private static String stripLastElement(String path) {
        int lastSlashPos;
        String strippedPath = null;
        if (path != null && (lastSlashPos = path.lastIndexOf(47)) > -1) {
            strippedPath = path.substring(0, lastSlashPos);
        }
        return strippedPath;
    }

    public static Document parseXMLDocument(Reader characterStream) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        return CMXMLUtils.parseXMLDocument(characterStream, true, false);
    }

    public static Document parseXMLDocument(Reader characterStream, boolean ignoreWhitespace, boolean validate) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        XMLDocument parsedDocument;
        block5: {
            DOMParser parser = null;
            parsedDocument = null;
            try {
                parser = new DOMParser();
                if (ignoreWhitespace) {
                    parser.setValidationMode(validate);
                }
                parser.setPreserveWhitespace(!ignoreWhitespace);
                parser.parse(new InputSource(characterStream));
                parsedDocument = parser.getDocument();
            }
            catch (Exception e) {
                s_log.error((Object)("Caught an exception trying to parse XML document: " + e.getMessage()));
                CMXMLUtils.formatParseException(e);
                if (e instanceof ParserConfigurationException) {
                    throw (ParserConfigurationException)e;
                }
                if (e instanceof SAXException) {
                    throw (SAXException)e;
                }
                if (!(e instanceof IOException)) break block5;
                throw (IOException)e;
            }
        }
        return parsedDocument;
    }

    public static Document parseXMLDocument(InputStream xmlIs) {
        return CMXMLUtils.parseXMLDocument(xmlIs, false);
    }

    public static Document parseXMLDocument(InputStream xmlIs, boolean ignoreWS) {
        DOMParser parser = null;
        XMLDocument parsedDocument = null;
        try {
            parser = new DOMParser();
            parser.setPreserveWhitespace(!ignoreWS);
            parser.parse(xmlIs);
            parsedDocument = parser.getDocument();
        }
        catch (Exception e) {
            s_log.error((Object)("Caught exception trying to parse XML document: " + e.getMessage()));
            CMXMLUtils.formatParseException(e);
        }
        return parsedDocument;
    }

    public static String processMDXML(XMLDocument xml, String xslfile) throws Throwable {
        return CMXMLUtils.processMDXML(xml, xslfile, null);
    }

    public static String processMDXML(XMLDocument xml, String xslfile, String dbVersion) throws Throwable {
        return CMXMLUtils.processMDXML(xml, xslfile, dbVersion, 0);
    }

    public static String processMDXML(XMLDocument xml, String xslfile, String dbVersion, int params) throws Throwable {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            DOMParser parser = new DOMParser();
            parser.setPreserveWhitespace(true);
            URL xslURL = CMXMLUtils.createURL(xslfile);
            parser.parse(xslURL);
            XMLDocument xsldoc = parser.getDocument();
            XSLProcessor processor = new XSLProcessor();
            processor.setBaseURL(xslURL);
            processor.showWarnings(true);
            processor.setErrorStream((OutputStream)System.err);
            XMLAccessor.setTransformParams(processor, params, dbVersion);
            XSLStylesheet sst = processor.newXSLStylesheet(xsldoc);
            processor.processXSL(sst, xml, (OutputStream)bos);
        }
        catch (Exception e) {
            if (e instanceof XSLException) {
                System.out.println("Caught XSLException in processMDXML:");
                XSLException xe = (XSLException)((Object)e);
                for (int i = 0; i < xe.getNumMessages(); ++i) {
                    System.out.println(" Message " + i + ": " + xe.formatErrorMessage(i));
                    System.out.println("  at line " + xe.getLineNumber(i) + ", column " + xe.getColumnNumber(i));
                }
            } else {
                CMXMLUtils.formatParseException(e);
            }
            throw e;
        }
        return bos.toString("UTF-8");
    }

    public static URL getResource(ServletContext context, String path) {
        if (FILE_SEP_NOT_FRONTSLASH) {
            path = path.replace(PLATFORM_FILE_SEPARATOR_CHAR, '/');
        }
        try {
            return context.getResource(path);
        }
        catch (MalformedURLException mue) {
            s_log.error((Object)("Cannot getResource for path: " + path), (Throwable)mue);
            return null;
        }
    }

    public static URL createURL(String fileName) {
        return CMXMLUtils.createURL(fileName, false);
    }

    public static URL createURL(String fileName, boolean useSystemResource) {
        URL url;
        block11: {
            url = null;
            if (!useSystemResource) {
                try {
                    url = new URL(fileName);
                }
                catch (MalformedURLException ex) {
                    File f = new File(fileName);
                    try {
                        String path = f.getAbsolutePath();
                        String fs = System.getProperty("file.separator");
                        if (fs.length() == 1) {
                            char sep = fs.charAt(0);
                            if (sep != '/') {
                                path = path.replace(sep, '/');
                            }
                            if (path.charAt(0) != '/') {
                                path = '/' + path;
                            }
                        }
                        path = "file://" + path;
                        url = new URL(path);
                        break block11;
                    }
                    catch (MalformedURLException e) {
                        if (s_log.isDebugEnabled()) {
                            s_log.debug((Object)("Cannot create url for: " + fileName));
                        }
                        break block11;
                    }
                }
            }
            try {
                url = Class.forName("oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMXMLUtils").getClassLoader().getResource(fileName);
            }
            catch (ClassNotFoundException cnfe) {
                s_log.debug((Object)"ClassNotFoundException: oracle.sysman.dbTarget.db.changemgr.emo.docaccess.CMXMLUtils", (Throwable)cnfe);
            }
        }
        return url;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: CMXMLUtils xslfile xmlfile");
            System.exit(1);
        }
        try {
            DOMParser parser = new DOMParser();
            parser.setPreserveWhitespace(true);
            URL xslURL = CMXMLUtils.createURL(args[0]);
            parser.parse(xslURL);
            XMLDocument xsldoc = parser.getDocument();
            URL xmlURL = CMXMLUtils.createURL(args[1]);
            parser.parse(xmlURL);
            XMLDocument xml = parser.getDocument();
            XSLProcessor processor = new XSLProcessor();
            processor.setBaseURL(xslURL);
            XSLStylesheet xsl = processor.newXSLStylesheet(xsldoc);
            processor.showWarnings(true);
            processor.setErrorStream((OutputStream)System.err);
            processor.processXSL(xsl, xml, (OutputStream)System.out);
        }
        catch (Exception e) {
            CMXMLUtils.formatParseException(e);
        }
    }

    static void formatParseException(Exception e) {
        if (e instanceof XMLParseException && s_log.isDebugEnabled()) {
            XMLParseException xpe = (XMLParseException)e;
            s_log.debug((Object)("Caught XMLParseException: " + e.getMessage()));
            for (int i = 0; i < xpe.getNumMessages(); ++i) {
                s_log.debug((Object)(" Message " + i + ": " + xpe.formatErrorMessage(i)));
                s_log.debug((Object)("  at line " + xpe.getLineNumber(i) + ", column " + xpe.getColumnNumber(i)));
            }
            s_log.debug((Object)" Trace:", (Throwable)xpe);
        }
    }

    public static SXMLPrefixResolver getSXMLResolver() {
        return s_resolver;
    }
}

