/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.shapes;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import oracle.dss.util.shapes.DrawableObject;
import oracle.dss.util.shapes.Path;

public class DrawableObjectXMLGenerator {
    public static String generateXMLFromShape(Shape shp) {
        StringBuffer buf = new StringBuffer(2000);
        PathIterator pathIterator = shp.getPathIterator(null);
        while (!pathIterator.isDone()) {
            double[] points = new double[6];
            int windingRule = pathIterator.currentSegment(points);
            if (windingRule == 0) {
                buf.append("M");
                buf.append(String.valueOf(points[0]));
                buf.append(",");
                buf.append(String.valueOf(points[1]));
            } else if (windingRule == 1) {
                buf.append("L");
                buf.append(String.valueOf(points[0]));
                buf.append(",");
                buf.append(String.valueOf(points[1]));
            } else if (windingRule == 4) {
                buf.append("Z");
            }
            buf.append(" ");
            pathIterator.next();
        }
        return buf.toString();
    }

    public static String generateXML(DrawableObject drawObject) {
        if (drawObject instanceof Path) {
            Shape shp = drawObject.getShape();
            return DrawableObjectXMLGenerator.generateXMLFromShape(shp);
        }
        return null;
    }
}

