/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.shapes;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.xml.sax.Attributes;

public class CommonShapeUtils {
    public static Shape processShape(String qName, Attributes atts) {
        Shape s = null;
        if (qName.equals("path")) {
            s = CommonShapeUtils.processPath(atts);
        } else if (qName.equals("rect")) {
            s = CommonShapeUtils.processRect(atts);
        } else if (qName.equals("circle") || qName.equals("ellipse")) {
            s = CommonShapeUtils.processCircleOrEllipse(atts);
        } else if (qName.equals("line")) {
            s = CommonShapeUtils.processLine(atts);
        } else if (qName.equals("polyline")) {
            s = CommonShapeUtils.processPolyline(atts);
        } else if (qName.equals("polygon")) {
            s = CommonShapeUtils.processPolygon(atts);
        } else if (qName.equals("text")) {
            s = CommonShapeUtils.processText(atts);
        }
        return s;
    }

    public static float parseValue(String s) {
        if (s == null) {
            return new Float(0.0f).floatValue();
        }
        s = s.replaceAll("px", "");
        float val = Float.valueOf(s).floatValue();
        return val;
    }

    public static Shape processText(Attributes atts) {
        float x = CommonShapeUtils.parseValue(atts.getValue("x"));
        float y = CommonShapeUtils.parseValue(atts.getValue("y"));
        return new Rectangle2D.Double(x, y, 0.0, 0.0);
    }

    public static Shape processRect(Attributes atts) {
        RectangularShape rect = null;
        float x = CommonShapeUtils.parseValue(atts.getValue("x"));
        float y = CommonShapeUtils.parseValue(atts.getValue("y"));
        float w = CommonShapeUtils.parseValue(atts.getValue("width"));
        float h = CommonShapeUtils.parseValue(atts.getValue("height"));
        if (atts.getValue("rx") != null && atts.getValue("ry") != null) {
            float rx = CommonShapeUtils.parseValue(atts.getValue("rx"));
            float ry = CommonShapeUtils.parseValue(atts.getValue("ry"));
            rect = new RoundRectangle2D.Double(x, y, w, h, rx, ry);
        } else {
            rect = new Rectangle2D.Double(x, y, w, h);
        }
        return rect;
    }

    public static Ellipse2D processCircleOrEllipse(Attributes atts) {
        Ellipse2D.Double oval = null;
        float cx = CommonShapeUtils.parseValue(atts.getValue("cx"));
        float cy = CommonShapeUtils.parseValue(atts.getValue("cy"));
        if (atts.getValue("r") != null) {
            float r = CommonShapeUtils.parseValue(atts.getValue("r"));
            oval = new Ellipse2D.Double(cx - r, cy - r, 2.0f * r, 2.0f * r);
        } else if (atts.getValue("rx") != null && atts.getValue("ry") != null) {
            float rx = CommonShapeUtils.parseValue(atts.getValue("rx"));
            float ry = CommonShapeUtils.parseValue(atts.getValue("ry"));
            oval = new Ellipse2D.Double(cx - rx, cy - ry, 2.0f * rx, 2.0f * ry);
        }
        return oval;
    }

    public static Line2D processLine(Attributes atts) {
        float x1 = CommonShapeUtils.parseValue(atts.getValue("x1"));
        float y1 = CommonShapeUtils.parseValue(atts.getValue("y1"));
        float x2 = CommonShapeUtils.parseValue(atts.getValue("x2"));
        float y2 = CommonShapeUtils.parseValue(atts.getValue("y2"));
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        return line;
    }

    public static GeneralPath processPolyline(Attributes atts) {
        GeneralPath path = new GeneralPath();
        if (atts.getValue("points") != null) {
            String[] points = atts.getValue("points").split("\\s+");
            String[] coords = points[0].split(",");
            float x = CommonShapeUtils.parseValue(coords[0]);
            float y = CommonShapeUtils.parseValue(coords[1]);
            path.moveTo(x, y);
            for (int i = 1; i < points.length; ++i) {
                if (points[i].length() <= 0) continue;
                coords = points[i].split(",");
                x = CommonShapeUtils.parseValue(coords[0]);
                y = CommonShapeUtils.parseValue(coords[1]);
                path.lineTo(x, y);
            }
        }
        return path;
    }

    public static Polygon processPolygon(Attributes atts) {
        Polygon polygon = new Polygon();
        if (atts.getValue("points") != null) {
            String[] points = atts.getValue("points").split("\\s+");
            for (int i = 0; i < points.length; ++i) {
                if (points[i].length() <= 0) continue;
                String[] coords = points[i].split(",");
                int x = (int)CommonShapeUtils.parseValue(coords[0]);
                int y = (int)CommonShapeUtils.parseValue(coords[1]);
                polygon.addPoint(x, y);
            }
        }
        return polygon;
    }

    public static GeneralPath processPath(Attributes atts) {
        GeneralPath path = new GeneralPath();
        String pathData = atts.getValue("d");
        String commands = pathData.replaceAll("[^a-zA-Z]", "");
        String[] coords = pathData.split("[a-zA-Z]");
        float currX = 0.0f;
        float currY = 0.0f;
        Point2D prevCubicControlPoint = null;
        Point2D prevQuadControlPoint = null;
        for (int i = 0; i < commands.length(); ++i) {
            float y;
            float y1;
            float x1;
            float y2;
            float x;
            int j;
            char command = commands.charAt(i);
            boolean isRelative = false;
            if (Character.isLowerCase(command)) {
                isRelative = true;
            }
            String[] points = null;
            if (i + 1 < coords.length) {
                points = coords[i + 1].trim().split("[,\\s]+");
            }
            if (command == 'M' || command == 'm') {
                for (j = 0; j < points.length; j += 2) {
                    x = CommonShapeUtils.parseValue(points[j]);
                    y2 = CommonShapeUtils.parseValue(points[j + 1]);
                    if (isRelative) {
                        x += currX;
                        y2 += currY;
                    }
                    currX = x;
                    currY = y2;
                    path.moveTo(x, y2);
                }
            } else if (command == 'L' || command == 'l') {
                for (j = 0; j < points.length; j += 2) {
                    x = CommonShapeUtils.parseValue(points[j]);
                    y2 = CommonShapeUtils.parseValue(points[j + 1]);
                    if (isRelative) {
                        x += currX;
                        y2 += currY;
                    }
                    currX = x;
                    currY = y2;
                    path.lineTo(x, y2);
                }
            } else if (command == 'H' || command == 'h') {
                for (j = 0; j < points.length; ++j) {
                    x = CommonShapeUtils.parseValue(points[j]);
                    y2 = currY;
                    if (isRelative) {
                        x += currX;
                    }
                    currX = x;
                    path.lineTo(x, y2);
                }
            } else if (command == 'V' || command == 'v') {
                for (j = 0; j < points.length; ++j) {
                    x = currX;
                    y2 = CommonShapeUtils.parseValue(points[j]);
                    if (isRelative) {
                        y2 += currY;
                    }
                    currY = y2;
                    path.lineTo(x, y2);
                }
            } else if (command == 'C' || command == 'c') {
                for (j = 0; j < points.length; j += 6) {
                    x1 = CommonShapeUtils.parseValue(points[j]);
                    y1 = CommonShapeUtils.parseValue(points[j + 1]);
                    float x2 = CommonShapeUtils.parseValue(points[j + 2]);
                    float y22 = CommonShapeUtils.parseValue(points[j + 3]);
                    float x3 = CommonShapeUtils.parseValue(points[j + 4]);
                    float y3 = CommonShapeUtils.parseValue(points[j + 5]);
                    if (isRelative) {
                        x1 += currX;
                        y1 += currY;
                        x2 += currX;
                        y22 += currY;
                        x3 += currX;
                        y3 += currY;
                    }
                    currX = x3;
                    currY = y3;
                    prevCubicControlPoint = new Point2D.Double(x2, y22);
                    path.curveTo(x1, y1, x2, y22, x3, y3);
                }
            } else if (command == 'S' || command == 's') {
                for (j = 0; j < points.length; j += 4) {
                    float x2 = CommonShapeUtils.parseValue(points[j]);
                    float y23 = CommonShapeUtils.parseValue(points[j + 1]);
                    float x4 = CommonShapeUtils.parseValue(points[j + 2]);
                    y = CommonShapeUtils.parseValue(points[j + 3]);
                    float x12 = currX;
                    float y12 = currY;
                    if (prevCubicControlPoint != null) {
                        x12 = (float)((double)currX + ((double)currX - prevCubicControlPoint.getX()));
                        y12 = (float)((double)currY + ((double)currY - prevCubicControlPoint.getY()));
                    }
                    if (isRelative) {
                        x2 += currX;
                        y23 += currY;
                        x4 += currX;
                        y += currY;
                    }
                    currX = x4;
                    currY = y;
                    prevCubicControlPoint = new Point2D.Double(x2, y23);
                    path.curveTo(x12, y12, x2, y23, x4, y);
                }
            } else if (command == 'Q' || command == 'q') {
                for (j = 0; j < points.length; j += 4) {
                    x1 = CommonShapeUtils.parseValue(points[j]);
                    y1 = CommonShapeUtils.parseValue(points[j + 1]);
                    float x5 = CommonShapeUtils.parseValue(points[j + 2]);
                    y = CommonShapeUtils.parseValue(points[j + 3]);
                    if (isRelative) {
                        x1 += currX;
                        y1 += currY;
                        x5 += currX;
                        y += currY;
                    }
                    currX = x5;
                    currY = y;
                    prevQuadControlPoint = new Point2D.Double(x1, y1);
                    path.quadTo(x1, y1, x5, y);
                }
            } else if (command == 'T' || command == 't') {
                for (j = 0; j < points.length; j += 2) {
                    x = CommonShapeUtils.parseValue(points[j]);
                    y2 = CommonShapeUtils.parseValue(points[j + 1]);
                    float x13 = currX;
                    float y13 = currY;
                    if (prevQuadControlPoint != null) {
                        x13 = (float)((double)currX + ((double)currX - prevQuadControlPoint.getX()));
                        y13 = (float)((double)currY + ((double)currY - prevQuadControlPoint.getY()));
                    }
                    if (isRelative) {
                        x += currX;
                        y2 += currY;
                    }
                    currX = x;
                    currY = y2;
                    prevQuadControlPoint = new Point2D.Double(x13, y13);
                    path.quadTo(x13, y13, x, y2);
                }
            } else if (command == 'A' || command == 'a') {
                for (j = 0; j < points.length; j += 7) {
                    Rectangle2D.Double bounds;
                    Arc2D.Double arc;
                    double cyPrime;
                    double cxPrime;
                    float rx = CommonShapeUtils.parseValue(points[j]);
                    float ry = CommonShapeUtils.parseValue(points[j + 1]);
                    double x_axis_rot = Math.toRadians(CommonShapeUtils.parseValue(points[j + 2]));
                    float large_arc_flag = CommonShapeUtils.parseValue(points[j + 3]);
                    float sweep_flag = CommonShapeUtils.parseValue(points[j + 4]);
                    float x6 = CommonShapeUtils.parseValue(points[j + 5]);
                    float y4 = CommonShapeUtils.parseValue(points[j + 6]);
                    if (isRelative) {
                        rx += currX;
                        ry += currY;
                        x6 += currX;
                        y4 += currY;
                    }
                    if (x6 == currX && y4 == currY) continue;
                    if (rx == 0.0f || ry == 0.0f) {
                        currX = x6;
                        currY = y4;
                        path.lineTo(x6, y4);
                        continue;
                    }
                    if (rx < 0.0f) {
                        rx *= -1.0f;
                    }
                    if (ry < 0.0f) {
                        ry *= -1.0f;
                    }
                    if (x_axis_rot > 360.0) {
                        x_axis_rot %= 360.0;
                    }
                    if (large_arc_flag != 0.0f) {
                        large_arc_flag = 1.0f;
                    }
                    if (sweep_flag != 0.0f) {
                        sweep_flag = 1.0f;
                    }
                    double tempA = (currX - x6) / 2.0f;
                    double tempB = (currY - y4) / 2.0f;
                    double x1Prime = Math.cos(x_axis_rot) * tempA + Math.sin(x_axis_rot) * tempB;
                    double y1Prime = -1.0 * Math.sin(x_axis_rot) * tempA + Math.cos(x_axis_rot) * tempB;
                    tempA = (double)rx * y1Prime / (double)ry;
                    tempB = -1.0 * ((double)ry * x1Prime) / (double)rx;
                    double tempC = Math.sqrt(Math.max((Math.pow(rx, 2.0) * Math.pow(ry, 2.0) - Math.pow(rx, 2.0) * Math.pow(y1Prime, 2.0) - Math.pow(ry, 2.0) * Math.pow(x1Prime, 2.0)) / (Math.pow(rx, 2.0) * Math.pow(y1Prime, 2.0) + Math.pow(ry, 2.0) * Math.pow(x1Prime, 2.0)), 0.0));
                    if (large_arc_flag != sweep_flag) {
                        cxPrime = tempC * tempA;
                        cyPrime = tempC * tempB;
                    } else {
                        cxPrime = -1.0 * tempC * tempA;
                        cyPrime = -1.0 * tempC * tempB;
                    }
                    tempA = (currX + x6) / 2.0f;
                    tempB = (currY + y4) / 2.0f;
                    double cx = Math.cos(x_axis_rot) * cxPrime - Math.sin(x_axis_rot) * cyPrime + tempA;
                    double cy = Math.sin(x_axis_rot) * cxPrime + Math.cos(x_axis_rot) * cyPrime + tempB;
                    double ux = 1.0;
                    double uy = 0.0;
                    double vx = (x1Prime - cxPrime) / (double)rx;
                    double vy = (y1Prime - cyPrime) / (double)ry;
                    double lengthU = Math.sqrt(Math.pow(ux, 2.0) + Math.pow(uy, 2.0));
                    double lengthV = Math.sqrt(Math.pow(vx, 2.0) + Math.pow(vy, 2.0));
                    double angleStart = Math.toDegrees(Math.acos((ux * vx + uy * vy) / (lengthU * lengthV)));
                    if (ux * vy - uy * vx < 0.0) {
                        angleStart *= -1.0;
                    }
                    ux = (x1Prime - cxPrime) / (double)rx;
                    uy = (y1Prime - cyPrime) / (double)ry;
                    vx = (-1.0 * x1Prime - cxPrime) / (double)rx;
                    vy = (-1.0 * y1Prime - cyPrime) / (double)ry;
                    lengthU = Math.sqrt(Math.pow(ux, 2.0) + Math.pow(uy, 2.0));
                    lengthV = Math.sqrt(Math.pow(vx, 2.0) + Math.pow(vy, 2.0));
                    double angleExtent = Math.toDegrees(Math.acos((ux * vx + uy * vy) / (lengthU * lengthV))) % 360.0;
                    if (ux * vy - uy * vx < 0.0) {
                        angleExtent *= -1.0;
                    }
                    if (sweep_flag == 0.0f && angleExtent < 0.0 || sweep_flag == 1.0f && angleExtent > 0.0) {
                        angleExtent *= -1.0;
                    }
                    if (((RectangularShape)(arc = new Arc2D.Double(bounds = new Rectangle2D.Double(cx - (double)rx, cy - (double)ry, 2.0f * rx, 2.0f * ry), angleStart, angleExtent, 0))).getX() >= 0.0 && ((RectangularShape)arc).getY() >= 0.0) {
                        path.append(arc, true);
                    }
                    currX = x6;
                    currY = y4;
                }
            } else if (command == 'Z' || command == 'z') {
                path.closePath();
            }
            if (command != 'C' && command != 'c' && command != 'S' && command != 's') {
                prevCubicControlPoint = null;
            }
            if (command == 'Q' || command == 'q' || command == 'T' || command == 't') continue;
            prevQuadControlPoint = null;
        }
        return path;
    }
}

