/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table.gui;

import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Vector;
import oracle.dss.gridView.ConditionElement;
import oracle.dss.gridView.UIGridView;
import oracle.dss.gridView.gui.RulesPanel;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.QDRDiscriminator;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRMember;
import oracle.dss.util.help.HelpContext;

public class TableRulesPanel
extends RulesPanel
implements HelpContext {
    private static final long serialVersionUID = 1L;
    protected String m_strHelpContextID;
    protected boolean m_bHelpEnabled;

    public TableRulesPanel() {
    }

    public TableRulesPanel(UIGridView gridView, String header, boolean isDefault) {
        this(gridView, header);
    }

    public TableRulesPanel(UIGridView gridView, String header) {
        this(gridView, header != null);
    }

    public TableRulesPanel(UIGridView gridView, boolean header) {
        super(gridView, header);
        this.m_isTable = true;
        this._init();
    }

    public TableRulesPanel(UIGridView gridView, Discriminator disc, Vector data, boolean[] selected, String header, boolean isDefault) {
        this(gridView, disc, header);
    }

    public TableRulesPanel(UIGridView gridView, Discriminator disc, String header) {
        this(gridView, disc, header != null);
    }

    public TableRulesPanel(UIGridView gridView, Discriminator disc, boolean header) {
        super(gridView, disc, null, header);
        this.m_isTable = true;
        this._init();
    }

    @Override
    public void setDataAccess(DataAccess access) {
        super.setDataAccess(access);
        this.m_conditions = null;
        this.setDefaultConditions();
        if (this.conditionList != null) {
            this.conditionList.setListData(this.m_conditions);
            this.conditionList.setSelectedIndex(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_editButton) {
            int idx = this.conditionList.getSelectedIndex();
            if (idx == -1) {
                return;
            }
            String dimension = this.conditionList.getDimension(idx);
            Object memberData = this.conditionList.getMemberData(idx);
            Vector members = new Vector();
            if (memberData == null) {
                members = null;
            } else if (memberData instanceof Vector) {
                members = (Vector)memberData;
            } else {
                members.addElement(memberData);
            }
            if (dimension != null) {
                RulesPanel.DimensionDialog dialog = this.createDimensionDialog(this.rBundle.getString("Select Members"), dimension, members, idx, true, true);
                dialog.show();
            }
        }
    }

    @Override
    public Discriminator getDiscriminator() {
        Vector target = new Vector();
        Vector pairs = new Vector();
        if (this.m_qdrDisc == null) {
            this.m_qdrDisc = new QDRDiscriminator();
        }
        if (this.m_isHeaderFormat) {
            this.m_qdrDisc = this.m_memberPanel.getDiscriminator();
            return this.m_qdrDisc;
        }
        for (int i = 0; i < this.conditionList.getListSize(); ++i) {
            String dimension = this.conditionList.getDimension(i);
            QDRMember member = this.m_qdrDisc.getQDR().getDimMember(dimension);
            if (!this.conditionList.isChanged(i)) continue;
            Object data = this.conditionList.getMemberData(i);
            if (data != null) {
                member = data instanceof Vector ? new QDRMember(3, data) : new QDRMember(0, data);
                this.m_qdrDisc.getQDR().addDimMemberPair(dimension, member);
                continue;
            }
            this.m_qdrDisc.getQDR().removeDimMemberPair(dimension);
        }
        if (this.m_entireRowButton.isSelected()) {
            this.m_qdrDisc.getQDR().setTarget(null);
        } else {
            Object[] selectedItems = this.m_selectedCellsList.getSelectedValues();
            try {
                for (int i = 0; i < this.dataAccess.getEdgeCount(); ++i) {
                    int layerCount = this.dataAccess.getLayerCount(i);
                    block5: for (int j = 0; j < layerCount; ++j) {
                        Object dimObj = this.dataAccess.getLayerMetadata(i, j, this.dimLabelType);
                        for (int k = 0; k < selectedItems.length; ++k) {
                            if (!dimObj.equals(selectedItems[k])) continue;
                            selectedItems[k] = this.dataAccess.getLayerMetadata(i, j, "layerName");
                            continue block5;
                        }
                    }
                }
            }
            catch (EdgeOutOfRangeException e) {
            }
            catch (LayerOutOfRangeException e) {
                // empty catch block
            }
            if (selectedItems.length > 0) {
                if (selectedItems.length == 1) {
                    this.m_qdrDisc.getQDR().setTarget(new QDRMember(selectedItems[0].toString()));
                } else {
                    Vector<Object> data = new Vector<Object>();
                    for (int i = 0; i < selectedItems.length; ++i) {
                        data.addElement(selectedItems[i]);
                    }
                    this.m_qdrDisc.getQDR().setTarget(new QDRMember(3, data));
                }
            } else {
                this.m_qdrDisc.getQDR().setTarget(null);
            }
        }
        return this.m_qdrDisc;
    }

    public String getHelpContextID() {
        if (this.m_isHeaderFormat) {
            return this.getClass().getName() + "_" + "Header";
        }
        return this.getClass().getName() + "_" + "Databody";
    }

    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    protected boolean initHeader() {
        this.m_conditions = new Vector();
        int[] edges = new int[]{0, 2};
        Object m_qdr = null;
        try {
            for (int i = 0; i < edges.length; ++i) {
                int layerCount = this.dataAccess.getLayerCount(edges[i]);
                for (int j = 0; j < layerCount; ++j) {
                    String dimension = this.dataAccess.getLayerMetadata(edges[i], j, "layerName").toString();
                    String member = this.dataAccess.getMemberMetadata(edges[i], j, 0, this.memberLabelType).toString();
                    this.m_conditions.addElement(new ConditionElement(dimension, member));
                }
            }
        }
        catch (DataException e) {
            return false;
        }
        return true;
    }

    @Override
    protected void setDefaultConditions() {
        this.m_conditions = new Vector();
        int[] edges = new int[]{0, 2};
        try {
            for (int i = 0; i < edges.length; ++i) {
                int layerCount = this.dataAccess.getLayerCount(edges[i]);
                for (int j = 0; j < layerCount; ++j) {
                    String dimension = this.dataAccess.getLayerMetadata(edges[i], j, "layerName").toString();
                    this.m_conditions.addElement(new ConditionElement(dimension, (String)null));
                }
            }
        }
        catch (EdgeOutOfRangeException e) {
        }
        catch (LayerOutOfRangeException e) {
            // empty catch block
        }
        QDR m_qdr = new QDR();
        this.m_qdrDisc = new QDRDiscriminator(m_qdr, 4);
    }

    @Override
    protected void initFromDisc(Discriminator disc, ConditionElement valueCondition) {
        this.m_qdrDisc = (QDRDiscriminator)disc;
        this.m_conditions = new Vector();
        int[] edges = new int[]{0, 2};
        QDR m_qdr = this.m_qdrDisc.getQDR();
        try {
            for (int i = 0; i < edges.length; ++i) {
                int layerCount = this.dataAccess.getLayerCount(edges[i]);
                for (int j = 0; j < layerCount; ++j) {
                    QDRMember member;
                    Object dimObj = this.dataAccess.getLayerMetadata(edges[i], j, "layerName");
                    String dimension = null;
                    if (dimObj != null) {
                        dimension = dimObj.toString();
                    }
                    if ((member = m_qdr.getDimMember(dimension)) == null) {
                        this.m_conditions.addElement(new ConditionElement(dimension, (Object)null));
                        continue;
                    }
                    this.m_conditions.addElement(new ConditionElement(dimension, member.getData()));
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    protected String printCondition(ConditionElement element) {
        String condition = null;
        String dimension = element.getDimension();
        if (element.getType() == 0) {
            condition = element.getData() == null ? this.getLayerLabel(dimension) + ": " + this.rBundle.getString("Any") : this.getLayerLabel(dimension) + ": " + this.getMemberLabel(dimension, element.getData().toString());
        } else if (element.getType() == 1) {
            condition = this.getLayerLabel(dimension) + ": ";
            Vector data = (Vector)element.getData();
            if (data != null) {
                for (int i = 0; i < data.size(); ++i) {
                    if (i != 0) {
                        condition = condition + ", ";
                    }
                    condition = condition + this.getMemberLabel(dimension, data.elementAt(i).toString());
                }
            }
        }
        return condition;
    }

    @Override
    protected String getMemberLabel(String dimension, String member) {
        if (dimension == null || member == null) {
            return null;
        }
        try {
            for (int i = 0; i < this.dataAccess.getEdgeCount(); ++i) {
                if (i == 1) continue;
                int layerCount = this.dataAccess.getLayerCount(i);
                int endslice = this.dataAccess.getEdgeExtent(i);
                for (int j = 0; j < layerCount; ++j) {
                    Object dimObj = this.dataAccess.getLayerMetadata(i, j, "layerName");
                    String dim = null;
                    if (dimObj != null) {
                        dim = dimObj.toString();
                    }
                    if (!dimension.equals(dim)) continue;
                    if (i == 2) {
                        List list = this.dataAccess.getCorrespondingMemberMetadata(i, j, new String[]{member}, new String[]{this.memberLabelType}, true);
                        if (list != null) {
                            if (list != null && list.size() > 0 && list.get(0) != null && ((Object[])list.get(0)).length > 0) {
                                return (String)((Object[])list.get(0))[0];
                            }
                            return member;
                        }
                        for (int startslice = 0; startslice != endslice; startslice += this.dataAccess.getMemberExtent(i, j, startslice)) {
                            if (this.dataAccess.getMemberStartLayer(i, j, startslice) != j) continue;
                            Object objValue = this.dataAccess.getMemberMetadata(i, j, startslice, "value");
                            String value = null;
                            if (objValue != null) {
                                value = objValue.toString();
                            }
                            if (value == null || !value.equals(member)) continue;
                            objValue = this.dataAccess.getMemberMetadata(i, j, startslice, this.memberLabelType);
                            if (objValue != null) {
                                value = objValue.toString();
                            }
                            if (value == null) {
                                return member;
                            }
                            return value;
                        }
                        continue;
                    }
                    if (i != 0) continue;
                    for (int k = 0; k < this.dataAccess.getEdgeExtent(1); ++k) {
                        Object val = this.dataAccess.getValue(k, j, "value");
                        if (val == null || !val.toString().equals(member)) continue;
                        return this.dataAccess.getValue(k, j, "dataValue").toString();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return member;
    }
}

