/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.ConditionElement;
import oracle.dss.dataView.gui.BaseConditionalFormatPanel;
import oracle.dss.gridView.UIFormat;
import oracle.dss.gridView.gui.GridviewConditionalFormatPanel;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.QDRDiscriminator;
import oracle.dss.table.Table;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRMember;

public class TableConditionalFormatPanel
extends GridviewConditionalFormatPanel {
    private static final long serialVersionUID = 1L;
    protected JRadioButton m_entireRowButton;
    protected JRadioButton m_selectedCellsButton;
    protected JButton m_advanced;
    protected JList m_selectedCellsList;
    protected Component m_rigidArea;
    protected boolean m_detail = true;
    protected BaseConditionalFormatPanel.CustomGluePanel m_advancedPanel;

    public TableConditionalFormatPanel(Table table) {
        this(table, null);
    }

    public TableConditionalFormatPanel(Table table, UIFormat format) {
        super(table, format);
    }

    @Override
    public void constructPanel() {
        this.m_isTable = true;
        super.constructPanel();
        this.m_advanced = new JButton(this.grBundle.getString("Show Advanced >>"));
        String translatedText = this.grBundle.getString("EntireRow");
        this.m_entireRowButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_entireRowButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = this.grBundle.getString("SelectedCells");
        this.m_selectedCellsButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_selectedCellsButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_selectedCellsButton.setAlignmentX(0.0f);
        this.m_selectedCellsButton.setMaximumSize(this.m_selectedCellsButton.getPreferredSize());
        this.m_selectedCellsButton.setMinimumSize(this.m_selectedCellsButton.getPreferredSize());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_entireRowButton);
        buttonGroup.add(this.m_selectedCellsButton);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.add(this.m_selectedCellsButton);
        buttonPanel.add(this.m_entireRowButton);
        buttonPanel.add(Box.createVerticalGlue());
        this.m_selectedCellsList = new JList();
        QDR m_qdr = null;
        Vector<Integer> selectedIndices = new Vector<Integer>();
        Vector<String> data = new Vector<String>();
        if (this.m_qdrDisc != null) {
            m_qdr = this.m_qdrDisc.getQDR();
        }
        if (m_qdr != null && m_qdr.getTarget() == null) {
            this.m_entireRowButton.setSelected(true);
        } else {
            this.m_selectedCellsButton.setSelected(true);
        }
        this.m_entireRowButton.addItemListener(this);
        this.m_selectedCellsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (TableConditionalFormatPanel.this.m_selectedCellsList.getSelectedIndices().length > 0) {
                    TableConditionalFormatPanel.this.m_selectedCellsButton.setSelected(true);
                }
            }
        });
        try {
            for (int i = 0; i < this.m_dataAccess.getEdgeCount(); ++i) {
                if (i == 1) continue;
                int layerCount = this.m_dataAccess.getLayerCount(i);
                for (int j = 0; j < layerCount; ++j) {
                    Object dimObj = this.m_dataAccess.getLayerMetadata(i, j, this.m_dimLabelType);
                    Object dimension = this.m_dataAccess.getLayerMetadata(i, j, "layerName");
                    data.addElement(dimObj.toString());
                    if (m_qdr == null || m_qdr.getTarget() == null || (m_qdr.getTarget().getType() != 3 || ((Vector)m_qdr.getTarget().getData()).indexOf(dimension) == -1) && (m_qdr.getTarget().getType() != 0 || !m_qdr.getTarget().getData().equals(dimension))) continue;
                    selectedIndices.addElement(new Integer(data.size() - 1));
                }
            }
        }
        catch (EdgeOutOfRangeException e) {
        }
        catch (LayerOutOfRangeException e) {
            // empty catch block
        }
        this.m_selectedCellsList.setListData(data.toArray());
        int[] indices = new int[selectedIndices.size()];
        for (int i = 0; i < selectedIndices.size(); ++i) {
            indices[i] = (Integer)selectedIndices.elementAt(i);
        }
        this.m_selectedCellsList.setSelectedIndices(indices);
        JScrollPane selectedCellsListPane = new JScrollPane(this.m_selectedCellsList);
        selectedCellsListPane.setVerticalScrollBarPolicy(20);
        selectedCellsListPane.setHorizontalScrollBarPolicy(30);
        selectedCellsListPane.setAlignmentX(0.0f);
        if (this.m_selectedCellsList.getModel().getSize() > 4) {
            selectedCellsListPane.setPreferredSize(new Dimension(selectedCellsListPane.getPreferredSize().width + 20, 80));
        } else {
            selectedCellsListPane.setPreferredSize(new Dimension(selectedCellsListPane.getPreferredSize().width, 80));
        }
        selectedCellsListPane.setMaximumSize(selectedCellsListPane.getPreferredSize());
        selectedCellsListPane.setMinimumSize(selectedCellsListPane.getPreferredSize());
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BoxLayout(listPanel, 1));
        listPanel.add(selectedCellsListPane);
        listPanel.add(Box.createVerticalGlue());
        this.m_advancedPanel = new BaseConditionalFormatPanel.CustomGluePanel();
        this.m_advancedPanel.setLayout(new BoxLayout(this.m_advancedPanel, 0));
        this.m_advancedPanel.addWithGlue(new JLabel(this.grBundle.getString("Highlight")));
        this.m_advancedPanel.addWithGlue(buttonPanel);
        this.m_advancedPanel.addWithGlue(listPanel);
        this.m_rigidArea = Box.createRigidArea(new Dimension(0, 4));
        this.m_applyToPanel.add(Box.createRigidArea(new Dimension(0, 4)));
        this.m_applyToPanel.add(this.m_advanced);
        this.m_advanced.setAlignmentX(0.0f);
        this.m_advanced.addActionListener(this);
    }

    @Override
    protected void setDefaultConditions() {
        this.m_dimensionVector = new Vector();
        this.m_memberVector = new Vector();
        this.m_conditions = new Vector();
        int[] edges = new int[]{0, 2};
        try {
            for (int i = 0; i < edges.length; ++i) {
                int layerCount = this.m_dataAccess.getLayerCount(edges[i]);
                for (int j = 0; j < layerCount; ++j) {
                    String dimension = this.m_dataAccess.getLayerMetadata(edges[i], j, "layerName").toString();
                    this.m_conditions.addElement(new ConditionElement(dimension, (String)null));
                    this.m_dimensionVector.addElement(dimension);
                    this.m_memberVector.addElement(this.rBundle.getString("<Any>"));
                }
            }
        }
        catch (EdgeOutOfRangeException e) {
        }
        catch (LayerOutOfRangeException e) {
            // empty catch block
        }
        QDR m_qdr = new QDR();
        this.m_qdrDisc = new QDRDiscriminator(m_qdr, 4);
    }

    @Override
    protected void initFromDisc(Discriminator disc, ConditionElement valueCondition) {
        this.m_qdrDisc = (QDRDiscriminator)disc;
        this.m_dimensionVector = new Vector();
        this.m_memberVector = new Vector();
        this.m_conditions = new Vector();
        int[] edges = new int[]{0, 2};
        QDR m_qdr = this.m_qdrDisc.getQDR();
        try {
            for (int i = 0; i < edges.length; ++i) {
                int layerCount = this.m_dataAccess.getLayerCount(edges[i]);
                for (int j = 0; j < layerCount; ++j) {
                    QDRMember member;
                    Object dimObj = this.m_dataAccess.getLayerMetadata(edges[i], j, "layerName");
                    String dimension = null;
                    if (dimObj != null) {
                        dimension = dimObj.toString();
                    }
                    if ((member = m_qdr.getDimMember(dimension)) == null) {
                        this.m_dimensionVector.addElement(dimension);
                        this.m_memberVector.addElement(this.rBundle.getString("<Any>"));
                        this.m_conditions.addElement(new ConditionElement(dimension, (Object)null));
                        continue;
                    }
                    this.m_dimensionVector.addElement(dimension);
                    this.m_memberVector.addElement(member.getData());
                    this.m_conditions.addElement(new ConditionElement(dimension, member.getData()));
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (valueCondition != null) {
            this.m_valueCondition = valueCondition;
        }
    }

    @Override
    public Discriminator getDiscriminator() {
        Vector target = new Vector();
        Vector pairs = new Vector();
        if (this.m_qdrDisc == null) {
            this.m_qdrDisc = new QDRDiscriminator();
        }
        for (int i = 0; i < this.m_conditions.size(); ++i) {
            String dimension = ((ConditionElement)this.m_conditions.elementAt(i)).getDimension();
            QDRMember member = this.m_qdrDisc.getQDR().getDimMember(dimension);
            Object data = ((ConditionElement)this.m_conditions.elementAt(i)).getData();
            if (data != null) {
                member = data instanceof Vector ? new QDRMember(3, data) : new QDRMember(0, data);
                this.m_qdrDisc.getQDR().addDimMemberPair(dimension, member);
                continue;
            }
            this.m_qdrDisc.getQDR().removeDimMemberPair(dimension);
        }
        if (this.m_entireRowButton.isSelected()) {
            this.m_qdrDisc.getQDR().setTarget(null);
        } else {
            Object[] selectedItems = this.m_selectedCellsList.getSelectedValues();
            try {
                for (int i = 0; i < this.m_dataAccess.getEdgeCount(); ++i) {
                    int layerCount = this.m_dataAccess.getLayerCount(i);
                    block5: for (int j = 0; j < layerCount; ++j) {
                        Object dimObj = this.m_dataAccess.getLayerMetadata(i, j, this.m_dimLabelType);
                        for (int k = 0; k < selectedItems.length; ++k) {
                            if (!dimObj.equals(selectedItems[k])) continue;
                            selectedItems[k] = this.m_dataAccess.getLayerMetadata(i, j, "layerName");
                            continue block5;
                        }
                    }
                }
            }
            catch (EdgeOutOfRangeException e) {
            }
            catch (LayerOutOfRangeException e) {
                // empty catch block
            }
            if (selectedItems.length > 0) {
                if (selectedItems.length == 1) {
                    this.m_qdrDisc.getQDR().setTarget(new QDRMember(selectedItems[0].toString()));
                } else {
                    Vector<Object> data = new Vector<Object>();
                    for (int i = 0; i < selectedItems.length; ++i) {
                        data.addElement(selectedItems[i]);
                    }
                    this.m_qdrDisc.getQDR().setTarget(new QDRMember(3, data));
                }
            } else {
                this.m_qdrDisc.getQDR().setTarget(null);
            }
        }
        return this.m_qdrDisc;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.m_advanced) {
            if (this.m_detail) {
                this.m_advanced.setText(this.grBundle.getString("<< Hide Advanced"));
                this.m_applyToPanel.add(this.m_rigidArea);
                this.m_applyToPanel.add(this.m_advancedPanel);
                this.m_advancedPanel.setAlignmentX(0.0f);
                this.m_detail = false;
            } else {
                this.m_advanced.setText(this.grBundle.getString("Show Advanced >>"));
                this.m_applyToPanel.remove(this.m_rigidArea);
                this.m_applyToPanel.remove(this.m_advancedPanel);
                this.m_detail = true;
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.m_entireRowButton && this.m_entireRowButton.isSelected()) {
            this.m_selectedCellsList.setSelectedIndices(new int[0]);
        }
    }
}

