/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.util.Enumeration;
import java.util.Vector;
import oracle.dss.dataView.BaseTitleAttributes;
import oracle.dss.dataView.Manager;
import oracle.dss.gridView.GridViewCommon;
import oracle.dss.gridView.GridViewDatabodyAttributes;
import oracle.dss.gridView.GridViewHeaderAttributes;
import oracle.dss.gridView.GridViewXML;
import oracle.dss.gridView.UIFormat;
import oracle.dss.gridView.managers.GridViewDatabodyRuleStyles;
import oracle.dss.gridView.managers.GridViewHeaderRuleStyles;
import oracle.dss.gridView.managers.GridViewRuleFormatter;
import oracle.dss.pagingControl.PagingControlAttributes;
import oracle.dss.table.TableAttributes;
import oracle.dss.table.TableCommon;
import oracle.dss.table.TableDefaultValues;
import oracle.dss.table.managers.TableRuleSizing;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class TableXML
extends GridViewXML {
    public static final String m_version = "3.2.0.21";
    public static final String a_incrementalFetchEnabled = "incrementalFetchEnabled";
    public static final String a_fetchMessage = "fetchMessage";
    public static final String a_fetchIncrement = "fetchIncrement";
    protected boolean d_incrementalFetchEnabled;
    protected String d_fetchMessage;
    protected int d_fetchIncrement;
    private TableAttributes _table;

    public TableXML(TableAttributes table) {
        super(table);
        this._table = table;
        this.initDefaults(new TableDefaultValues());
    }

    protected void initDefaults(TableDefaultValues tdv) {
        super.initDefaults(tdv);
        this.d_incrementalFetchEnabled = tdv.isIncrementalFetchEnabled();
        this.d_fetchMessage = tdv.getFetchMessage();
        this.d_fetchIncrement = tdv.getFetchIncrement();
    }

    public void setXML(ObjectNode node, int reset) {
        ObjectNode viewFormatNode;
        ContainerNode UIFormatsNode;
        ObjectNode sizingRules;
        ObjectNode rowHeader;
        ContainerNode headerRuleStyles;
        ContainerNode graphicImagesPaths;
        ContainerNode ruleFormat;
        ContainerNode drillImagesPaths;
        ObjectNode title;
        ObjectNode subtitle;
        ObjectNode footnote;
        ContainerNode databodyRuleStyles;
        ObjectNode tableDatabody;
        ObjectNode columnHeader;
        PropertyNode pNode = node.getProperty("version");
        String version = m_version;
        if (pNode != null) {
            version = pNode.getValueAsString();
        }
        super.setXML(node);
        pNode = node.getProperty(a_incrementalFetchEnabled);
        if (pNode != null) {
            this._table.setIncrementalFetchEnabled(pNode.getValueAsBoolean());
        }
        if ((pNode = node.getProperty(a_fetchMessage)) != null) {
            this._table.setFetchMessage(pNode.getValueAsString());
        }
        if ((pNode = node.getProperty(a_fetchIncrement)) != null) {
            this._table.setFetchIncrement(pNode.getValueAsInteger());
        }
        if ((columnHeader = node.getPropertyValueAsObjectNode("ColumnHeader", true)) != null) {
            ((GridViewHeaderAttributes)this._table.getComponentFromID(10)).setXML(columnHeader, version, reset);
        }
        if ((tableDatabody = node.getPropertyValueAsObjectNode("Databody", true)) != null) {
            ((GridViewDatabodyAttributes)this._table.getComponentFromID(9)).setXML(tableDatabody, version, reset);
        }
        if ((databodyRuleStyles = node.getContainer("DatabodyStyleManager")) != null) {
            if (this._table.getGridViewDatabodyStyleManager() == null) {
                this._table.setGridViewDatabodyStyleManager(new GridViewDatabodyRuleStyles());
            }
            if (this._table.getGridViewDatabodyStyleManager() instanceof GridViewDatabodyRuleStyles) {
                ((GridViewDatabodyRuleStyles)this._table.getGridViewDatabodyStyleManager()).setContext(this.m_context);
                ((GridViewDatabodyRuleStyles)this._table.getGridViewDatabodyStyleManager()).setXML(databodyRuleStyles, (GridViewCommon)((Object)this._table), version, reset);
            }
        }
        if ((footnote = node.getPropertyValueAsObjectNode("DataviewFootnote", true)) != null) {
            ((BaseTitleAttributes)this._table.getComponentFromID(8)).setXML(footnote, version, reset);
        }
        if ((subtitle = node.getPropertyValueAsObjectNode("DataviewSubtitle", true)) != null) {
            ((BaseTitleAttributes)this._table.getComponentFromID(7)).setXML(subtitle, version, reset);
        }
        if ((title = node.getPropertyValueAsObjectNode("DataviewTitle", true)) != null) {
            ((BaseTitleAttributes)this._table.getComponentFromID(6)).setXML(title, version, reset);
        }
        if ((drillImagesPaths = node.getContainer("DrillImagesPaths")) != null) {
            Enumeration e = drillImagesPaths.getContainedObject("ImagePath");
            while (e.hasMoreElements()) {
                ObjectNode imagePathNode = (ObjectNode)e.nextElement();
                PropertyNode indexNode = imagePathNode.getProperty("index");
                PropertyNode pathNode = imagePathNode.getProperty("path");
                String path = pathNode.getValueAsString();
                if (path == null || path.length() <= 0) continue;
                int index = indexNode.getValueAsInteger();
                this._table.setDrillImagePath(index, path);
            }
        }
        if ((ruleFormat = node.getContainer("FormatManager")) != null) {
            if (this._table.getGridViewFormatManager() == null) {
                this._table.setGridViewFormatManager(new GridViewRuleFormatter());
            }
            if (this._table.getGridViewFormatManager() instanceof GridViewRuleFormatter) {
                ((GridViewRuleFormatter)this._table.getGridViewFormatManager()).setContext(this.m_context);
                ((GridViewRuleFormatter)this._table.getGridViewFormatManager()).setXML(ruleFormat, (GridViewCommon)((Object)this._table), version, reset);
            }
        }
        if ((graphicImagesPaths = node.getContainer("GraphicImagesPaths")) != null) {
            Enumeration e = graphicImagesPaths.getContainedObject("ImagePath");
            while (e.hasMoreElements()) {
                ObjectNode imagePathNode = (ObjectNode)e.nextElement();
                PropertyNode indexNode = imagePathNode.getProperty("index");
                PropertyNode pathNode = imagePathNode.getProperty("path");
                String path = pathNode.getValueAsString();
                if (path == null || path.length() <= 0) continue;
                int index = indexNode.getValueAsInteger();
                this._table.setGraphicImagePath(index, path);
            }
        }
        if ((headerRuleStyles = node.getContainer("HeaderStyleManager")) != null) {
            if (this._table.getGridViewHeaderStyleManager() == null) {
                this._table.setGridViewHeaderStyleManager(new GridViewHeaderRuleStyles());
            }
            if (this._table.getGridViewHeaderStyleManager() instanceof GridViewHeaderRuleStyles) {
                ((GridViewHeaderRuleStyles)this._table.getGridViewHeaderStyleManager()).setContext(this.m_context);
                ((GridViewHeaderRuleStyles)this._table.getGridViewHeaderStyleManager()).setXML(headerRuleStyles, (GridViewCommon)((Object)this._table), version, reset);
            }
        }
        try {
            String invisibleColumn = node.getPropertyValueAsString("InvisibleColumns");
            this._table.setRowOrColumnVisible(true, invisibleColumn);
            String invisibleRow = node.getPropertyValueAsString("InvisibleRows");
            this._table.setRowOrColumnVisible(false, invisibleRow);
        }
        catch (NoSuchPropertyException e) {
            // empty catch block
        }
        ObjectNode pagingControl = node.getPropertyValueAsObjectNode("PageHeader", true);
        if (pagingControl != null) {
            ((PagingControlAttributes)this._table.getComponentFromID(5)).setObjectNode(pagingControl, version, reset);
        }
        if ((rowHeader = node.getPropertyValueAsObjectNode("RowHeader", true)) != null) {
            ((GridViewHeaderAttributes)this._table.getComponentFromID(11)).setXML(rowHeader, version, reset);
        }
        if ((sizingRules = node.getPropertyValueAsObjectNode("SizingManager", true)) != null) {
            if (this._table.getTableSizingManager() == null) {
                this._table.setTableSizingManager(new TableRuleSizing((TableCommon)((Object)this._table)));
            }
            if (this._table.getTableSizingManager() instanceof TableRuleSizing) {
                ((TableRuleSizing)this._table.getTableSizingManager()).setContext(this.m_context);
                ((TableRuleSizing)this._table.getTableSizingManager()).setXML(sizingRules);
            }
        }
        if ((pNode = node.getProperty("formatCount")) != null) {
            this._table.setUIFormatCount(pNode.getValueAsInteger());
        }
        if ((pNode = node.getProperty("toolbarFormatCount")) != null) {
            this._table.setToolbarUIFormatCount(pNode.getValueAsInteger());
        }
        if ((UIFormatsNode = node.getContainer("UIFormats")) != null) {
            Enumeration e = UIFormatsNode.getContainedObject();
            Vector<UIFormat> formats = new Vector<UIFormat>();
            while (e.hasMoreElements()) {
                ObjectNode objectNode = (ObjectNode)e.nextElement();
                UIFormat format = new UIFormat();
                format.setContext(this.m_context);
                format.setXML(objectNode);
                formats.addElement(format);
            }
            this._table.setUIFormats(formats);
            if (this._table instanceof GridViewCommon && ((GridViewCommon)((Object)this._table)).getFormatModel() != null) {
                ((GridViewCommon)((Object)this._table)).getFormatModel().setUIFormats(false);
            }
        }
        if (this._table.getViewFormat() != null && (viewFormatNode = node.getPropertyValueAsObjectNode("ViewFormat", true)) != null) {
            this._table.getViewFormat().setXML(viewFormatNode, version, reset);
        }
    }

    public ObjectNode getObjectNode(boolean allProperties) {
        ObjectNode viewFormatNode;
        ObjectNode rowHeaderNode;
        ObjectNode pagingControl;
        int ival;
        String tmp;
        int size;
        ObjectNode titleNode;
        ObjectNode subtitleNode;
        ObjectNode footnoteNode;
        Manager ruleManager;
        ObjectNode tableDataBodyNode;
        ObjectNode columnHeaderNode;
        ObjectNode node = new ObjectNode("Table");
        node.addProperty("version", m_version);
        super.getObjectNode(node, allProperties);
        if (allProperties || this._table.isIncrementalFetchEnabled() != this.d_incrementalFetchEnabled) {
            node.addProperty(a_incrementalFetchEnabled, this._table.isIncrementalFetchEnabled());
        }
        if (allProperties || !this.d_fetchMessage.equals(this._table.getFetchMessage())) {
            node.addProperty(a_fetchMessage, this._table.getFetchMessage());
        }
        if (allProperties || this._table.getFetchIncrement() != this.d_fetchIncrement) {
            node.addProperty(a_fetchIncrement, this._table.getFetchIncrement());
        }
        if ((columnHeaderNode = ((GridViewHeaderAttributes)this._table.getComponentFromID(10)).getXML(allProperties)) != null) {
            node.addProperty(columnHeaderNode);
        }
        if ((tableDataBodyNode = ((GridViewDatabodyAttributes)this._table.getComponentFromID(9)).getXML(allProperties)) != null) {
            node.addProperty(tableDataBodyNode);
        }
        if ((ruleManager = this._table.getGridViewDatabodyStyleManager()) != null && ruleManager instanceof GridViewDatabodyRuleStyles) {
            ((GridViewDatabodyRuleStyles)ruleManager).setContext(this.m_context);
            ObjectNode styleManagerNode = ((GridViewDatabodyRuleStyles)ruleManager).getXML(allProperties, (GridViewCommon)((Object)this._table));
            if (styleManagerNode != null) {
                node.addProperty(styleManagerNode);
            }
        }
        if ((footnoteNode = ((BaseTitleAttributes)this._table.getComponentFromID(8)).getXML(allProperties)) != null) {
            node.addProperty(footnoteNode);
        }
        if ((subtitleNode = ((BaseTitleAttributes)this._table.getComponentFromID(7)).getXML(allProperties)) != null) {
            node.addProperty(subtitleNode);
        }
        if ((titleNode = ((BaseTitleAttributes)this._table.getComponentFromID(6)).getXML(allProperties)) != null) {
            node.addProperty(titleNode);
        }
        ContainerNode drillImagesPathsNode = new ContainerNode("DrillImagesPaths");
        boolean bDrillImagesPathsNodeExists = false;
        int drillImageCount = this._table.getDrillImageCount();
        for (int i = 1; i < drillImageCount; ++i) {
            String path;
            ObjectNode imagePathNode = new ObjectNode("ImagePath");
            if (imagePathNode == null || (path = this._table.getDrillImagePath(i)) == null || path.length() <= 0) continue;
            imagePathNode.addProperty("index", i);
            imagePathNode.addProperty("path", path);
            bDrillImagesPathsNodeExists = true;
            drillImagesPathsNode.addContainedObject((BaseNode)imagePathNode);
        }
        if (bDrillImagesPathsNodeExists) {
            node.addContainer(drillImagesPathsNode);
        }
        if ((ruleManager = this._table.getGridViewFormatManager()) != null && ruleManager instanceof GridViewRuleFormatter) {
            ((GridViewRuleFormatter)ruleManager).setContext(this.m_context);
            ObjectNode formatManagerNode = ((GridViewRuleFormatter)ruleManager).getXML(allProperties, (GridViewCommon)((Object)this._table));
            if (formatManagerNode != null) {
                node.addProperty(formatManagerNode);
            }
        }
        ContainerNode graphicImagesPathsNode = new ContainerNode("GraphicImagesPaths");
        boolean bGraphicImagesPathsNodeExists = false;
        int graphicImageCount = this._table.getGraphicImageCount();
        for (int i = 0; i < graphicImageCount; ++i) {
            String path;
            ObjectNode imagePathNode = new ObjectNode("ImagePath");
            if (imagePathNode == null || (path = this._table.getGraphicImagePath(i)) == null || path.length() <= 0) continue;
            imagePathNode.addProperty("index", i);
            imagePathNode.addProperty("path", path);
            bGraphicImagesPathsNodeExists = true;
            graphicImagesPathsNode.addContainedObject((BaseNode)imagePathNode);
        }
        if (bGraphicImagesPathsNodeExists) {
            node.addContainer(graphicImagesPathsNode);
        }
        if ((ruleManager = this._table.getGridViewHeaderStyleManager()) != null && ruleManager instanceof GridViewHeaderRuleStyles) {
            ((GridViewHeaderRuleStyles)ruleManager).setContext(this.m_context);
            ObjectNode styleManagerNode = ((GridViewHeaderRuleStyles)ruleManager).getXML(allProperties, (GridViewCommon)((Object)this._table));
            if (styleManagerNode != null) {
                node.addProperty(styleManagerNode);
            }
        }
        int n = size = this._table.getInvisibleColumn() == null ? 0 : this._table.getInvisibleColumn().size();
        if (size > 0) {
            tmp = "";
            for (int j = 0; j < size; ++j) {
                ival = (Integer)this._table.getInvisibleColumn().elementAt(j);
                tmp = tmp == "" ? tmp + ival : tmp + " " + ival;
            }
            node.addProperty("InvisibleColumns", tmp, false);
        }
        int n2 = size = this._table.getInvisibleRow() == null ? 0 : this._table.getInvisibleRow().size();
        if (size > 0) {
            tmp = "";
            for (int j = 0; j < size; ++j) {
                ival = (Integer)this._table.getInvisibleRow().elementAt(j);
                tmp = tmp == "" ? tmp + ival : tmp + " " + ival;
            }
            node.addProperty("InvisibleRows", tmp, false);
        }
        if ((pagingControl = ((PagingControlAttributes)this._table.getComponentFromID(5)).getObjectNode(allProperties)) != null) {
            node.addProperty(pagingControl);
        }
        if ((rowHeaderNode = ((GridViewHeaderAttributes)this._table.getComponentFromID(11)).getXML(allProperties)) != null) {
            node.addProperty(rowHeaderNode);
        }
        if ((ruleManager = this._table.getTableSizingManager()) != null && ruleManager instanceof TableRuleSizing) {
            ((TableRuleSizing)ruleManager).setContext(this.m_context);
            ObjectNode sizingManagerNode = ((TableRuleSizing)ruleManager).getXML(allProperties);
            if (sizingManagerNode != null) {
                node.addProperty(sizingManagerNode);
            }
        }
        if (this._table.getUIFormatCount() != this.d_formatCount) {
            node.addProperty("formatCount", this._table.getUIFormatCount());
        }
        if (this._table.getToolbarUIFormatCount() != this.d_toolbarFormatCount) {
            node.addProperty("toolbarFormatCount", this._table.getToolbarUIFormatCount());
        }
        if (this._table.getUIFormats() != null) {
            ContainerNode UIFormatsNode = new ContainerNode("UIFormats");
            int formatCount = this._table.getUIFormats().size();
            for (int i = 0; i < formatCount; ++i) {
                UIFormat format = (UIFormat)this._table.getUIFormats().elementAt(i);
                format.setContext(this.m_context);
                ObjectNode formatNode = format.getObjectNode(false);
                if (formatNode == null) continue;
                UIFormatsNode.addContainedObject((BaseNode)formatNode);
            }
            node.addContainer(UIFormatsNode);
        }
        if (this._table.getViewFormat() != null && (viewFormatNode = this._table.getViewFormat().getXML(allProperties)) != null) {
            node.addProperty(viewFormatNode);
        }
        return node;
    }

    public void resetTableXML(int reset) {
        if (reset == 1 || reset == 2) {
            this.initDefaults(new TableDefaultValues());
        }
        this._table.setIncrementalFetchEnabled(this.d_incrementalFetchEnabled);
        this._table.setFetchMessage(this.d_fetchMessage);
        this._table.setFetchIncrement(this.d_fetchIncrement);
        this._table.setZoomFactor(this.d_zoomFactor);
    }
}

