/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.util.EventListener;
import oracle.dss.gridView.GridViewModelAdapter;
import oracle.dss.table.ColHeaderData;
import oracle.dss.table.IncrementalFetchEvent;
import oracle.dss.table.RelationalDataSource;
import oracle.dss.table.RowHeaderData;
import oracle.dss.table.Table;
import oracle.dss.table.TableControllerActions;
import oracle.dss.table.TableData;
import oracle.dss.table.TableDataListener;
import oracle.dss.table.TableDefaultValues;
import oracle.dss.table.TableModel;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataMap;
import oracle.dss.util.DataSource;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.MetadataMap;

public class TableModelAdapter
extends GridViewModelAdapter
implements TableModel,
TableControllerActions,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final String m_method_setfetchincrement = "setFetchIncrement (int r)";
    private static final String m_method_incrementalfetchgesturehappened = "incrementalFetchGestureHappened(Object source, int rowCount, int fetchIncrement)";
    private static final String m_method_setsupporteddatalayerflags = "setSupportedDataLayerFlags ()";
    private static final String m_method_setFetchMessage = "setFetchMessage";
    protected RowHeaderData rowHeaderData = null;
    protected ColHeaderData colHeaderData = null;
    protected TableData dataSource = null;
    protected Table table = null;
    protected boolean m_bIncrementalFetchEnabled = TableDefaultValues.isIncrementalFetchEnabled();
    protected String m_sFetchMessage = TableDefaultValues.getFetchMessage();
    protected int m_iFetchIncrement = TableDefaultValues.getFetchIncrement();

    public TableModelAdapter(Table t) {
        super(t);
        this.table = t;
    }

    @Override
    public void setDataSource(DataSource ds) {
        super.setDataSource(ds);
        if (this.dataDirectorFactory != null && this.dataDirectorFactory instanceof DataSource) {
            this.setDataDirector((DataDirector)this.dataDirectorFactory.createRelationalDataDirector());
        }
    }

    @Override
    protected DataSource createDefaultDataSource() {
        return new RelationalDataSource();
    }

    @Override
    public void setDataDirector(DataDirector dd) {
        if (this.table != null && this.table.getTable() != null && this.table.getTable().isIncrementalFetchRowVisible()) {
            this.table.getTable().removeIncrementalFetchRow();
            this.table.getTable().setIncrementalFetchRowVisible(false);
        }
        super.setDataDirector(dd);
    }

    @Override
    protected void setSupportedDataLayerFlags() {
        super.setSupportedDataLayerFlags();
        DataMap dataMap = this.getDataDirector().getSupportedDataMap();
        boolean typeSupported = false;
        if (dataMap != null) {
            typeSupported = dataMap.contains((Object)"dataGroupSort");
        }
        this.table.setDataGroupsortSupported(typeSupported);
        typeSupported = false;
        if (dataMap != null) {
            typeSupported = dataMap.contains((Object)"value");
        }
        this.table.setDataNameSupported(typeSupported);
        typeSupported = false;
        LayerMetadataMap layerMap = this.getDataDirector().getSupportedLayerMetadataMap();
        if (layerMap != null) {
            typeSupported = layerMap.contains((Object)"dimCanPivot");
        }
        this.table.setLayerMetaCanPivotSupported(typeSupported);
    }

    @Override
    public ColHeaderData getColumnDataSource() {
        return this.colHeaderData;
    }

    @Override
    public RowHeaderData getRowDataSource() {
        return this.rowHeaderData;
    }

    @Override
    public TableData getTableDataSource() {
        return this.dataSource;
    }

    @Override
    public void newRowDataSource() {
        this.rowHeaderData = new RowHeaderData(this.table);
    }

    @Override
    public void newColDataSource() {
        this.colHeaderData = new ColHeaderData(this.table);
    }

    @Override
    public void newDataSource() {
        try {
            this.dataSource = new TableData(this, this.table);
            super.setGridViewDataSource(this.dataSource);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setIncrementalFetchEnabled(boolean b) {
        if (b == this.m_bIncrementalFetchEnabled) {
            return;
        }
        this.m_bIncrementalFetchEnabled = b;
        if (!b) {
            if (this.table.getTable() != null && this.table.getTable().isIncrementalFetchRowVisible()) {
                boolean success = !this.table.getTable().removeIncrementalFetchRow();
                this.table.getTable().setIncrementalFetchRowVisible(success);
            }
        } else if (this.table.getTable() != null) {
            boolean success = this.table.getTable().addIncrementalFetchRow();
            this.table.getTable().setIncrementalFetchRowVisible(success);
        }
        this.table.repaint();
    }

    @Override
    public boolean isIncrementalFetchEnabled() {
        return this.m_bIncrementalFetchEnabled;
    }

    @Override
    public void setFetchMessage(String s) {
        if (s == null) {
            this.table.getErrorHandler().log("invalid fetchMessage", this.getClass().getName(), m_method_setFetchMessage);
            return;
        }
        this.m_sFetchMessage = s;
        if (this.m_bIncrementalFetchEnabled && this.table != null && this.table.getTable() != null && this.table.getTable().isIncrementalFetchRowVisible()) {
            this.table.getTable().setFetchMessageInBottomRow(this.m_sFetchMessage);
        }
    }

    @Override
    public String getFetchMessage() {
        return this.m_sFetchMessage;
    }

    @Override
    public void setFetchIncrement(int i) {
        if (i < 0) {
            this.table.getErrorHandler().log("invalid number of rows to fetch", this.getClass().getName(), m_method_setfetchincrement);
        } else {
            this.m_iFetchIncrement = i;
        }
    }

    @Override
    public int getFetchIncrement() {
        return this.m_iFetchIncrement;
    }

    @Override
    public void addTableDataListener(TableDataListener l) {
        this.addGridViewDataListener(l);
        this.listenerList.add(TableDataListener.class, l);
    }

    @Override
    public void removeTableDataListener(TableDataListener l) {
        this.removeGridViewDataListener(l);
        this.listenerList.remove(TableDataListener.class, l);
    }

    @Override
    public boolean incrementalFetchGestureHappened(Object source, int rowCount, int fetchIncrement) {
        if (rowCount < 0) {
            this.table.getErrorHandler().log("invalid rowCount", this.getClass().getName(), m_method_incrementalfetchgesturehappened);
            return false;
        }
        if (fetchIncrement < 0) {
            this.table.getErrorHandler().log("invalid fetch increment", this.getClass().getName(), m_method_incrementalfetchgesturehappened);
            return false;
        }
        IncrementalFetchEvent e = new IncrementalFetchEvent(source, rowCount, fetchIncrement);
        this.fireviewIncrementalFetchRequesting(e);
        if (e.isConsumed()) {
            return false;
        }
        this.fireviewIncrementalFetchRequested(e);
        return true;
    }

    @Override
    public TableControllerActions getTableControllerActions() {
        return this;
    }

    @Override
    public LayerMetadataMap getLayerMetadataMap(int edge) {
        String[] types = new String[]{"layerName", "layerLabel", "dimMediumName", "dimShortName", "dimCanPivot", "viewStyle"};
        return new LayerMetadataMap(types);
    }

    @Override
    public MetadataMap getMetadataMap(int edge) {
        String[] types = new String[]{"label", "mediumName", "shortName", "drillState", "viewStyle", "value"};
        return new MetadataMap(types);
    }

    @Override
    public DataMap getDataMap() {
        String[] types = new String[]{"dataValue", "dataFormattedValue", "dataRatio", "dataViewFormat", "dataViewStyle", "dataGroupSort", "dataAnnotation", "dataIsTotal", "dataType"};
        return new DataMap(types);
    }

    protected void fireviewIncrementalFetchRequested(IncrementalFetchEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableDataListener.class) continue;
            ((TableDataListener)listeners[i + 1]).viewIncrementalFetchRequested(e);
        }
    }

    protected void fireviewIncrementalFetchRequesting(IncrementalFetchEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableDataListener.class) continue;
            ((TableDataListener)listeners[i + 1]).viewIncrementalFetchRequesting(e);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        TableModelAdapter cma = new TableModelAdapter(this.table);
        Object[] o = this.listenerList.getListenerList();
        for (int l = 2; l < o.length; l += 2) {
            cma.listenerList.add((Class)o[l], (EventListener)o[l + 1]);
        }
        return cma;
    }
}

