/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.StandardHeaderKeyHandler;
import oracle.dss.table.RowHeader;
import oracle.dss.table.Table;
import oracle.dss.table.TableEdgeComponentInfo;
import oracle.dss.table.TableHeader;
import oracle.dss.table.TableHeaderCell;
import oracle.dss.table.TableSpreadTable;
import oracle.dss.util.ComponentInfo;

public class TableHeaderKeyHandler
extends StandardHeaderKeyHandler {
    protected Table m_table = null;

    public TableHeaderKeyHandler(Table tbl) {
        this.m_table = tbl;
    }

    public void handleKeyEvent(Header header, KeyEvent e) {
        if (this.m_table.getTable() != null && header instanceof RowHeader && this.m_table.isIncrementalFetchEnabled() && this.m_table.getTable().isIncrementalFetchRowVisible() && header.getFocusItem() == this.m_table.getTableModel().getTableDataSource().getRowCount() - 1) {
            if (e.getKeyCode() == 40 && e.getID() != 402) {
                TableHeader tableHeader = (TableHeader)header;
                int layer = tableHeader.getFocusItem();
                int edge = tableHeader.isHorizontal() ? 0 : 1;
                TableEdgeComponentInfo focusCell = new TableEdgeComponentInfo(edge, layer);
                tableHeader.setIncFetchFocusCell((ComponentInfo)focusCell);
                e.consume();
                this.m_table.getTableModel().getTableControllerActions().incrementalFetchGestureHappened(header, this.m_table.getTableModel().getTableDataSource().getRowCount() - 1, this.m_table.getFetchIncrement());
            } else {
                super.handleKeyEvent(header, e);
            }
        } else {
            if (header instanceof TableHeader) {
                TableHeader tableHeader = (TableHeader)header;
                if (this.m_table.isEnabled() && this.m_table.isDrillingEnabled()) {
                    int item = tableHeader.getFocusItem();
                    Object oCell = tableHeader.getModel().getData(item);
                    if (oCell != null && oCell instanceof TableHeaderCell) {
                        boolean controlOrAltDown;
                        TableHeaderCell cell = (TableHeaderCell)oCell;
                        int column = 0;
                        int row = 0;
                        if (tableHeader.getOrientation() == 0) {
                            column = item;
                        } else {
                            row = item;
                        }
                        int drillState = cell.getDrillState();
                        boolean drillable = drillState == 1;
                        boolean collapsable = drillState == 2;
                        boolean bl = controlOrAltDown = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 4 ? e.isControlDown() : e.isAltDown();
                        if (drillable && controlOrAltDown && e.getKeyCode() == 40 && e.getID() != 402) {
                            ((TableSpreadTable)this.m_table.getGridViewTable()).fireHeaderCellDrillRequest(tableHeader.getOrientation(), column, row);
                            e.consume();
                        } else if (collapsable && controlOrAltDown && e.getKeyCode() == 38 && e.getID() != 402) {
                            ((TableSpreadTable)this.m_table.getGridViewTable()).fireCollapse(tableHeader.getOrientation(), column, row);
                            e.consume();
                        }
                    }
                }
            }
            if (!e.isConsumed()) {
                super.handleKeyEvent(header, e);
            }
        }
    }
}

