/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import oracle.dss.gridView.HeaderCell;
import oracle.dss.table.Table;
import oracle.dss.table.TableEdgeComponentInfo;
import oracle.dss.table.TableModel;
import oracle.dss.util.DataException;

public abstract class TableHeaderCell
extends HeaderCell {
    private static final long serialVersionUID = 1L;
    protected TableModel m_model = null;
    protected transient TableEdgeComponentInfo info = new TableEdgeComponentInfo(0, 0);
    protected Table m_table = null;

    public TableHeaderCell(Table table, int layer) {
        super(table, layer, 1, 0, 1);
        this.m_model = table.getTableModel();
        this.m_table = table;
    }

    @Override
    public Object getData() {
        try {
            String memberLabelType;
            this.info.setEdgeDepth(this.getEdge(), this.m_layer);
            Object value = this.m_model.getMetadataCache().get((Object)this.info);
            if (value == null && this.m_table.isMemberMetadataLabelTypeSupported(memberLabelType = this.m_table.getMemberMetadataLabelType(this.getEdge()))) {
                Object metadataValue = null;
                metadataValue = this.m_table.getMetadataFromDataAccess(this.getEdge(), this.m_layer, this.m_slice, memberLabelType, this.m_model.getDataAccess());
                if (metadataValue == null) {
                    metadataValue = new String("");
                }
                value = this.m_model.getGridViewFormatManager().formatMetadataValue(this.m_table, metadataValue, this.getEdge(), this.m_layer, 0, null);
                this.m_model.getMetadataCache().put(this.info.clone(), value);
            }
            return value;
        }
        catch (DataException e) {
            this.m_model.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getData");
            return null;
        }
    }

    int getIndex() {
        return this.m_layer;
    }
}

