/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.beans.BeanInfo;
import java.beans.PropertyVetoException;
import java.text.MessageFormat;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.elaf.oracle.OracleEWTPivotHeaderUI;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderKeyHandler;
import oracle.bali.ewt.header.HeaderSelectionManager;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.OneDModelListener;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.util.ImmInsets;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.dataView.managers.ViewStyleCallback;
import oracle.dss.gridView.GridViewHeader;
import oracle.dss.gridView.GridViewHeaderAttributes;
import oracle.dss.gridView.GridViewHeaderXML;
import oracle.dss.table.HeaderPainter;
import oracle.dss.table.RowHeader;
import oracle.dss.table.Table;
import oracle.dss.table.TableEdgeComponentInfo;
import oracle.dss.table.TableHeaderCell;
import oracle.dss.table.TableHeaderInputHandler;
import oracle.dss.table.TableHeaderKeyHandler;
import oracle.dss.table.TableTips;
import oracle.dss.util.ComponentInfo;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.EdgeComponentInfo;
import oracle.dss.util.xml.ObjectNode;

public abstract class TableHeader
extends Header
implements GridViewHeader,
ViewStyleCallback,
GridViewHeaderAttributes {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    protected Table table = null;
    private transient Hashtable metadataCache = null;
    protected HeaderAppMgr ham = null;
    protected ViewStyle defaultViewStyle = null;
    private Image blankImage = null;
    private Image unscaledBlankImage = null;
    protected transient DataComponentInfo info = new DataComponentInfo(0, 0);
    protected TableTips tips = null;
    protected boolean armed = false;
    protected int headerItem = -1;
    private boolean[] m_appliedStylesFlags = null;
    private ResourceBundle rBundle = null;
    private static final String m_method_styleChanged = "styleChanged(int attributeId, String attributeName, Object oldValue, Object newValue)";
    private static final String m_method_updateforpropset = "updateforPropset (BitSet bs)";
    private static final String m_method_paint = "paint (Graphics g)";
    private static final String m_method_isdrillout = "isDrillOut(int index, int x, int y)";
    private static final String m_method_isdrill = "isDrill(int index, int x, int y)";
    private static final String m_method_getGraphicImage = "Image getGraphicImage(int index, boolean scaled)";
    private GridViewHeaderXML _viewHeaderXML;
    private ComponentInfo incFetchFocusCell = null;

    public TableHeader(OneDModel ds, int orientation) {
        super(ds, orientation);
        this.defaultViewStyle = new ViewStyle((DataviewCommon)this.table, this.getDefaultAppearance());
        this.defaultViewStyle.setViewStyleCallback(this);
        this._viewHeaderXML = new GridViewHeaderXML(this);
    }

    public void init(Table t) {
        this.table = t;
        this.updateResourceBundle(this.table.getLocale());
        this.metadataCache = new Hashtable();
        this.setPainter((Painter)new HeaderPainter(this));
        this.setKeepHeaderCellsVisible(true);
        this.ham = new HeaderAppMgr(t);
        this.setHeaderSelectionManager((HeaderSelectionManager)new GeneralHeaderSelectionManager(2));
        TableHeaderInputHandler tblhandler = new TableHeaderInputHandler(this.table);
        this.setItemInputHandler(tblhandler);
        TableHeaderKeyHandler keyhandler = new TableHeaderKeyHandler(this.table);
        this.setHeaderKeyHandler((HeaderKeyHandler)keyhandler);
        this.defaultViewStyle.setView(this.table);
    }

    public void setPainter(Painter painter) {
        this.setDefaultPainter(painter);
    }

    public Painter getPainter() {
        return this.getDefaultPainter();
    }

    @Override
    public ViewStyle getViewStyle() {
        return this.defaultViewStyle;
    }

    @Override
    public void setViewStyle(ViewStyle vs) {
        if (vs == null) {
            this.table.getErrorHandler().log("invalid ViewStyle", this.getClass().getName(), "setViewStyle");
            return;
        }
        ViewStyle oldval = this.defaultViewStyle;
        this.defaultViewStyle = new ViewStyle((DataviewCommon)this.table, vs);
        this.defaultViewStyle.setViewStyleCallback(this);
        this.updateForPropSet(ViewStyle.createDifferencesBitSet(oldval, this.defaultViewStyle));
        if (!this.isHorizontal()) {
            this.table.setDefaultCornerComponentColor(this.defaultViewStyle.getBackground());
        }
        this.table.firePropertyChange(this, "ViewStyle", oldval, this.defaultViewStyle);
    }

    @Override
    public void styleChanged(int attributeId, String attributeName, Object oldValue, Object newValue) {
        if (attributeId < 0 || attributeId > 37) {
            this.table.getErrorHandler().log("invalid view style attribute", this.getClass().getName(), m_method_styleChanged);
            return;
        }
        this.updateForPropSet(ViewStyle.createDifferencesBitSet(attributeId));
        this.table.firePropertyChange(this, attributeName, oldValue, newValue);
    }

    protected void updateForPropSet(BitSet bs) {
        this.propSet();
        if (bs == null) {
            this.table.getErrorHandler().log("invalid bit set", this.getClass().getName(), m_method_updateforpropset);
            return;
        }
        if (bs.get(0) && !this.isHorizontal()) {
            this.table.setDefaultCornerComponentColor(this.getViewStyle().getBackground());
        }
        if (bs.get(3) || bs.get(4) || bs.get(6) || bs.get(26) || bs.get(28) || bs.get(8) || bs.get(18)) {
            if (this.isHorizontal()) {
                this.table.updateColumnWidth();
            } else {
                this.table.updateRowHeaderWidths();
            }
        }
        if (bs.get(1) || bs.get(3) || bs.get(4) || bs.get(5) || bs.get(6) || bs.get(27) || bs.get(26) || bs.get(28) || bs.get(25) || bs.get(8) || bs.get(7) || bs.get(16) || bs.get(18)) {
            if (this.isHorizontal()) {
                this.table.updateColumnHeaderRowHeights();
            } else {
                this.table.updateRowHeights();
            }
        }
        this.table.repaint();
    }

    protected void setZoomFactor(int zoom) {
        this.createBlankImage();
        this.clearAppliedStylesFlags();
    }

    protected boolean isDrill(int index, int x, int y) {
        if (index < 0) {
            this.table.getErrorHandler().log("invalid index", this.getClass().getName(), m_method_isdrill);
            return false;
        }
        boolean drill = false;
        Image image = this.getDrillImage(index);
        if (image == this.blankImage) {
            return drill;
        }
        if (image != null) {
            int xMax;
            int xMin;
            int width = image.getWidth((ImageObserver)((Object)this));
            int height = image.getHeight((ImageObserver)((Object)this));
            ViewStyle app = this.getStyle(index);
            ImmInsets insets = app.getInsets();
            ImmInsets borderInsets = this.getHeaderItemBorderPainter().getInsets(this.getItemPaintContext(index));
            int cellHeight = 0;
            cellHeight = this.isHorizontal() ? this.table.getTable().getColumnHeaderHeight() : this.table.getTable().getRowHeight(index);
            float align = this.getItemPaintContext(index).getInteriorAlignmentY();
            boolean l2r = true;
            if (l2r) {
                xMin = insets.left;
                xMax = insets.left + width;
            } else {
                int colWidth = 0;
                colWidth = this.isHorizontal() ? this.getItemSize(index) : this.getWidth();
                xMin = colWidth - insets.right - width;
                xMax = colWidth - insets.right;
            }
            Font f = app.getFont();
            int fontSize = 0;
            if (f == null) {
                f = this.getFont();
            }
            if (f != null) {
                fontSize = this.getFontMetrics(f).getHeight();
            }
            if (cellHeight < fontSize) {
                cellHeight = fontSize;
            }
            y = (int)((float)y - ((float)(cellHeight - insets.top - insets.bottom - borderInsets.top - borderInsets.bottom - fontSize) * align + (float)((fontSize - height) / 2)));
            y = y - insets.top - borderInsets.top;
            drill = x >= xMin && x <= xMax && y >= 0 && y <= height;
        }
        return drill;
    }

    protected boolean isDrillOut(int index, int x, int y) {
        if (index < 0) {
            this.table.getErrorHandler().log("invalid index", this.getClass().getName(), m_method_isdrillout);
            return false;
        }
        boolean drillOut = false;
        Image image = this.getDrillImage(index);
        Image gImage = this.getGraphicImage(index);
        int width = 0;
        if (!(this.isHorizontal() && image == this.blankImage || image == null)) {
            width = image.getWidth((ImageObserver)((Object)this)) + 1;
        }
        ViewStyle app = this.getStyle(index);
        ImmInsets insets = app.getInsets();
        ImmInsets borderInsets = this.getHeaderItemBorderPainter().getInsets(this.getItemPaintContext(index));
        if (gImage != null) {
            int xMax;
            int xMin;
            int gWidth = gImage.getWidth((ImageObserver)((Object)this));
            int gHeight = gImage.getHeight((ImageObserver)((Object)this));
            int cellHeight = 0;
            cellHeight = this.isHorizontal() ? this.table.getTable().getColumnHeaderHeight() : this.table.getTable().getRowHeight(index);
            float align = this.getItemPaintContext(index).getInteriorAlignmentY();
            boolean l2r = true;
            if (l2r) {
                xMin = width + insets.left;
                xMax = width + insets.left + gWidth;
            } else {
                int colWidth = 0;
                colWidth = this.isHorizontal() ? this.getItemSize(index) : this.getWidth();
                xMin = colWidth - insets.right - width - gWidth;
                xMax = colWidth - insets.right - width;
            }
            Font f = app.getFont();
            int fontSize = 0;
            if (f == null) {
                f = this.getFont();
            }
            if (f != null) {
                fontSize = this.getFontMetrics(f).getHeight();
            }
            if (cellHeight < fontSize) {
                cellHeight = fontSize;
            }
            y = (int)((float)y - ((float)(cellHeight - insets.top - insets.bottom - borderInsets.top - borderInsets.bottom - fontSize) * align + (float)((fontSize - gHeight) / 2)));
            y = y - insets.top - borderInsets.top;
            drillOut = x >= xMin && x <= xMax && y >= 0 && y <= gHeight;
        }
        return drillOut;
    }

    @Override
    public BeanInfo getBeanInfo() {
        return null;
    }

    public void setKeepHeaderCellsVisible(boolean keepHeaderCellsVisible) {
        this.repaint();
    }

    public boolean isKeepHeaderCellsVisible() {
        return true;
    }

    public boolean isHorizontal() {
        return this.getOrientation() == 0;
    }

    @Override
    public void clearCache() {
        this.clearAppliedStylesFlags();
        if (this.metadataCache != null) {
            this.metadataCache.clear();
        }
    }

    protected void clearAppliedStylesFlags() {
        this.m_appliedStylesFlags = null;
    }

    protected void clearAppliedStyleFlag(int item) {
        if (this.m_appliedStylesFlags != null && item >= 0 && item < this.m_appliedStylesFlags.length) {
            this.m_appliedStylesFlags[item] = false;
        }
    }

    Image getScaledBlankImage() {
        if (!this.table.isImagesScaled()) {
            return this.getBlankImage();
        }
        if (this.blankImage == null) {
            this.createBlankImage();
        }
        return this.blankImage;
    }

    Image getBlankImage() {
        if (this.unscaledBlankImage == null) {
            this.createUnscaledBlankImage();
        }
        return this.unscaledBlankImage;
    }

    private HeaderPainter _getHeaderPainter() {
        return (HeaderPainter)this.getDefaultPainter();
    }

    protected void propSet() {
        this.table.getTableModel().getGridViewHeaderStyleManager().metadataStyleChanged();
        this.clearCache();
    }

    @Override
    public Appearance getDefaultAppearance() {
        Appearance app = ((Appearance)UIManager.get("Header.DefaultAppearance")).copy();
        app.setForeground(UIManager.getColor(LookAndFeel.CONTROL_TEXT));
        app.setBackground(UIManager.getColor(LookAndFeel.CONTROL));
        if (this.isHorizontal()) {
            app.setHorizontalJustify(3);
        } else {
            app.setHorizontalJustify(1);
        }
        app.setVerticalJustify(1);
        return app;
    }

    @Override
    public ComponentInfo getCellFocus() {
        Component focusCellComponent = this.table.getTable().getGlobalFocusCellComponent();
        if (focusCellComponent != null && (this.isHorizontal() && focusCellComponent == this.table.getTable().getColumnHeader() || !this.isHorizontal() && focusCellComponent == this.table.getTable().getRowHeader())) {
            int layer;
            int edge;
            Cell globalFocusCell = this.table.getTable().getGlobalFocusCell();
            if (this.isHorizontal()) {
                edge = 0;
                layer = globalFocusCell.column;
            } else {
                edge = 1;
                layer = globalFocusCell.row;
            }
            return new TableEdgeComponentInfo(edge, layer);
        }
        return null;
    }

    @Override
    public void setCellFocus(ComponentInfo focusedCell) {
        if (focusedCell instanceof EdgeComponentInfo) {
            EdgeComponentInfo ecInfo = (EdgeComponentInfo)focusedCell;
            final int headerItem = ecInfo.getDepth();
            if (this.getIncFetchFocusCell() == null) {
                if (this.isHorizontal()) {
                    this.table.getTable().setGlobalFocusCell(new Cell(headerItem, -1), (Component)this.table.getTable().getColumnHeader());
                } else {
                    this.table.getTable().setGlobalFocusCell(new Cell(-1, headerItem), (Component)this.table.getTable().getRowHeader());
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (TableHeader.this.isHorizontal()) {
                            TableHeader.this.table.getTable().setGlobalFocusCell(new Cell(headerItem, -1), (Component)TableHeader.this.table.getTable().getColumnHeader());
                        } else {
                            TableHeader.this.table.getTable().setGlobalFocusCell(new Cell(-1, headerItem), (Component)TableHeader.this.table.getTable().getRowHeader());
                        }
                    }
                });
            }
            OneDSelection selection = this.getSelection();
            if (!selection.contains(headerItem)) {
                try {
                    this.deselectAll();
                    OneDSelection sel = new OneDSelection(headerItem);
                    this.setSelection(sel);
                }
                catch (PropertyVetoException ex) {
                    // empty catch block
                }
            }
            if (this.isHorizontal()) {
                this.table.getTableDatabody().scrollColumnIntoView(ecInfo.getDepth());
            } else {
                this.table.getTableDatabody().scrollRowIntoView(ecInfo.getDepth());
            }
            if (this.table.isFocusRequestedForCell()) {
                this.requestFocus();
            }
        }
    }

    protected Image getGraphicImage(int index) {
        return this.getGraphicImage(index, true);
    }

    protected Image getGraphicImage(int index, boolean scaled) {
        boolean bl = scaled = scaled && this.table.isImagesScaled();
        if (index < 0) {
            this.table.getErrorHandler().log("invalid index", this.getClass().getName(), m_method_getGraphicImage);
            return null;
        }
        int imageIndex = this.getStyle(index).getGraphicImageIndex();
        if (imageIndex >= 0 && imageIndex < this.table.getGraphicImageCount()) {
            if (scaled) {
                return this.table.getScaledGraphicImage(imageIndex);
            }
            return this.table.getGraphicImage(imageIndex);
        }
        return null;
    }

    protected boolean isDrilledOrDrillable(int index) {
        if (this instanceof RowHeader) {
            return true;
        }
        boolean drilledOrDrillable = true;
        TableHeaderCell cell = (TableHeaderCell)this.getModel().getData(index);
        if (cell == null) {
            drilledOrDrillable = false;
        } else {
            int drillState = cell.getDrillState();
            switch (drillState) {
                case 0: {
                    drilledOrDrillable = false;
                }
            }
        }
        return drilledOrDrillable;
    }

    protected Image getDrillImage(int index) {
        return this.getDrillImage(index, true);
    }

    protected Image getDrillImage(int index, boolean scaled) {
        boolean bl = scaled = scaled && this.table.isImagesScaled();
        if (!this.table.isDrillingEnabled() || !this.table.isEnabled() || !this.isDrilledOrDrillable(index) || this.table.isPrintOrPreviewMode()) {
            return null;
        }
        if (this.blankImage == null) {
            this.createBlankImage();
        }
        if (this.unscaledBlankImage == null) {
            this.createUnscaledBlankImage();
        }
        TableHeaderCell cell = (TableHeaderCell)this.getModel().getData(index);
        int drillState = cell.getDrillState();
        switch (drillState) {
            case 0: {
                if (scaled) {
                    return this.blankImage;
                }
                return this.unscaledBlankImage;
            }
        }
        if (scaled) {
            return this.table.getScaledDrillImage(drillState);
        }
        return this.table.getDrillImage(drillState);
    }

    protected abstract int getEdge();

    protected abstract int getDepth(int var1, int var2);

    protected abstract int getIndex(int var1, int var2);

    protected HeaderPainter getHeaderPainter() {
        return (HeaderPainter)this.getDefaultPainter();
    }

    protected void setItemPaintState(boolean armed, int item) {
        this.headerItem = item;
        this.armed = armed;
    }

    protected int getItemPaintState(int baseState, int item) {
        if (item == this.headerItem && this.armed) {
            baseState = 2 | baseState;
        }
        return baseState;
    }

    Image getDrillImage() {
        return ((OracleEWTPivotHeaderUI)OracleEWTPivotHeaderUI.createUI((JComponent)((Object)this))).getDrillImage((JComponent)((Object)this));
    }

    Image getDrilledImage() {
        return ((OracleEWTPivotHeaderUI)OracleEWTPivotHeaderUI.createUI((JComponent)((Object)this))).getDrilledImage((JComponent)((Object)this));
    }

    ViewStyle getStyle(int index) {
        ViewStyle style = (ViewStyle)this.metadataCache.get(this.info);
        if (style == null) {
            Object dataObj = this.getModel().getData(index);
            if (dataObj != null && dataObj instanceof TableHeaderCell) {
                dataObj = ((TableHeaderCell)dataObj).getData();
            }
            if ((style = this.table.getHeaderStyleFromManager(this.getEdge(), index, 0, dataObj, this.defaultViewStyle)) == null) {
                style = (ViewStyle)this.defaultViewStyle.clone();
            }
            this.metadataCache.put(this.info.clone(), style);
        }
        style.setView(this.table);
        if (this.table.getZoomFactor() != 100) {
            style = style.scaleStyle(style.getFont());
            style.setView(this.table);
        }
        style.setReadingDirection(this.getReadingDirectionForLocale(this.table.getLocale()));
        return style;
    }

    public void refreshHeaderStyle() {
        this.refreshHeaderStyle(0, this.getItemCount() - 1);
    }

    protected void refreshHeaderStyle(int startItem, int endItem) {
        if (startItem == -1 && endItem == -1) {
            return;
        }
        if (this.m_appliedStylesFlags == null) {
            int flagCount = this.getItemCount();
            if (!this.isHorizontal()) {
                ++flagCount;
            }
            this.m_appliedStylesFlags = new boolean[flagCount];
            for (int i = 0; i < this.m_appliedStylesFlags.length; ++i) {
                this.m_appliedStylesFlags[i] = false;
            }
        }
        for (int i = startItem; i <= endItem; ++i) {
            try {
                if (this.m_appliedStylesFlags[i]) continue;
                this.setItemAppearance(i, this.getStyle(i));
                this.m_appliedStylesFlags[i] = true;
                continue;
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
        }
    }

    private void _checkHeaderStyles() {
        int firstItemOnScreen = this.getFirstItemOnScreen();
        if (firstItemOnScreen < 0) {
            return;
        }
        int onScreenItemCount = this.getOnScreenItemCount();
        if (onScreenItemCount < 1) {
            return;
        }
        int lastItemOnScreen = firstItemOnScreen + onScreenItemCount - 1;
        this.refreshHeaderStyle(firstItemOnScreen, lastItemOnScreen);
    }

    protected void paintCanvasInterior(Graphics g) {
        this._checkHeaderStyles();
        super.paintCanvasInterior(g);
    }

    protected void scrollItemIntoView(int item) {
        if (this.table != null) {
            this.table.setDuringScroll(true);
        }
        super.scrollItemIntoView(item);
        if (this.table != null) {
            this.table.setDuringScroll(false);
        }
    }

    protected void resetCursor() {
    }

    private void createBlankImage() {
        Image realImage = null;
        realImage = this.table.getScaledDrillImage(1);
        int imageWidth = 0;
        int imageHeight = 0;
        if (realImage != null) {
            imageWidth = realImage.getWidth(null);
            imageHeight = realImage.getHeight(null);
        }
        realImage = this.table.getScaledDrillImage(2);
        int newWidth = 0;
        int newHeight = 0;
        if (realImage != null) {
            newWidth = realImage.getWidth(null);
            newHeight = realImage.getHeight(null);
        }
        if (newWidth > imageWidth) {
            imageWidth = newWidth;
        }
        if (newHeight > imageHeight) {
            imageHeight = newHeight;
        }
        int[] pixels = new int[imageWidth * imageHeight];
        this.blankImage = this.createImage(new MemoryImageSource(imageWidth, imageHeight, pixels, 0, imageWidth));
    }

    private void createUnscaledBlankImage() {
        Image realImage = null;
        realImage = this.table.getDrillImage(1);
        int imageWidth = 0;
        int imageHeight = 0;
        if (realImage != null) {
            imageWidth = realImage.getWidth(null);
            imageHeight = realImage.getHeight(null);
        }
        realImage = this.table.getDrillImage(2);
        int newWidth = 0;
        int newHeight = 0;
        if (realImage != null) {
            newWidth = realImage.getWidth(null);
            newHeight = realImage.getHeight(null);
        }
        if (newWidth > imageWidth) {
            imageWidth = newWidth;
        }
        if (newHeight > imageHeight) {
            imageHeight = newHeight;
        }
        int[] pixels = new int[imageWidth * imageHeight];
        this.unscaledBlankImage = this.createImage(new MemoryImageSource(imageWidth, imageHeight, pixels, 0, imageWidth));
    }

    void clearUnscaledBlankImage() {
        this.unscaledBlankImage = null;
    }

    void clearScaledBlankImage() {
        this.blankImage = null;
    }

    @Override
    public void setXML(ObjectNode node, String version, int reset) {
        this._viewHeaderXML.setXML(node, version, reset);
        if (!this.isHorizontal()) {
            this.table.setDefaultCornerComponentColor(this.defaultViewStyle.getBackground());
        }
    }

    @Override
    public ObjectNode getXML(boolean allProperties) {
        return this._viewHeaderXML.getXML(allProperties);
    }

    protected void resetToDefault(int reset) {
        this.defaultViewStyle.resetToDefault(reset);
        this.propSet();
        if (!this.isHorizontal() && reset != 0) {
            this.table.setDefaultCornerComponentColor(this.defaultViewStyle.getBackground());
        }
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.table.resource.TableBundle", loc) : ResourceBundle.getBundle("oracle.dss.table.resource.TableBundle");
    }

    private int getReadingDirectionForLocale(Locale loc) {
        String language;
        if (loc == null) {
            loc = Locale.getDefault();
        }
        if ((language = loc.getLanguage()).equals("ar") || language.equals("he") || language.equals("iw")) {
            return 2;
        }
        return 1;
    }

    protected Header.AccessibleHeader createAccessibleHeader() {
        return new TableAccessibleHeader();
    }

    protected ComponentInfo getIncFetchFocusCell() {
        return this.incFetchFocusCell;
    }

    protected void setIncFetchFocusCell(ComponentInfo focusCell) {
        this.incFetchFocusCell = focusCell;
    }

    public class TableAccessibleHeader
    extends Header.AccessibleHeader {
        private static final long serialVersionUID = 1L;

        public TableAccessibleHeader() {
            super((Header)TableHeader.this);
        }

        protected String getAccessibleName(int index, Object data) {
            String name = null;
            name = data instanceof TableHeaderCell ? (String)((TableHeaderCell)data).getData() : super.getAccessibleName(index, data);
            return name;
        }

        public String getAccessibleName(int index) {
            Object data = TableHeader.this.getModel().getData(index);
            String name = this.getAccessibleName(index, data);
            Image im = TableHeader.this.getGraphicImage(index);
            if (im != null) {
                name = MessageFormat.format(TableHeader.this.rBundle.getString("Graphic Image"), name);
            }
            if (data instanceof TableHeaderCell) {
                int drillState = ((TableHeaderCell)data).getDrillState();
                switch (drillState) {
                    case 1: {
                        name = MessageFormat.format(TableHeader.this.rBundle.getString("is drillable"), name);
                        break;
                    }
                    case 2: {
                        name = MessageFormat.format(TableHeader.this.rBundle.getString("is collapsable"), name);
                        break;
                    }
                }
            }
            return this.getAccessibleNameForTable(index, data, name);
        }
    }

    private class HeaderAppMgr
    implements AppearanceManager {
        public HeaderAppMgr(Table ct) {
        }

        public void updateUI() {
        }

        public Appearance getCellPaintingAppearance(int index) {
            return this.getCellPaintingAppearance(index, 0);
        }

        public Appearance getCellPaintingAppearance(int column, int row) {
            return TableHeader.this.getStyle(column);
        }

        public void setGrid(Grid grid) {
        }

        public TwoDModelListener getTwoDModelListener() {
            return null;
        }

        public OneDModelListener getOneDModelListener() {
            return null;
        }

        public ViewStyle getDefaultStyle() {
            return TableHeader.this.defaultViewStyle;
        }
    }
}

