/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.util.Vector;
import oracle.dss.dataView.ColumnComponentHandle;
import oracle.dss.dataView.ColumnRangeComponentHandle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.DataRangeComponentHandle;
import oracle.dss.dataView.RowComponentHandle;
import oracle.dss.dataView.RowRangeComponentHandle;
import oracle.dss.gridView.GridViewCommon;
import oracle.dss.pagingControl.PageItemComponentHandle;
import oracle.dss.rules.discriminator.CompositeDiscriminator;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.QDRDiscriminator;
import oracle.dss.util.ColumnComponentInfo;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.ComponentInfo;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MemberListAccess;
import oracle.dss.util.PageItemComponentInfo;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRMember;
import oracle.dss.util.RowComponentInfo;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public class TableFormatUtil {
    private QDRDiscriminator m_qdrDisc;
    private CompositeDiscriminator m_compDisc;
    private GridViewCommon m_table;
    private DataAccess dataAccess;
    private MemberListAccess memberAccess;
    private ComponentHandle componentHandle;
    private QDR m_qdr;
    private static final String dimNameType = "layerName";
    private static final String memberNameType = "value";
    private static final String memberLabelType = "shortName";
    private static final String VALUE = "DefaultTableValue";

    public TableFormatUtil(GridViewCommon gridview, ComponentHandle component) throws DataException {
        this.m_table = gridview;
        this.dataAccess = gridview.getModel().getDataAccess();
        this.componentHandle = component;
        this.initFromSelection();
    }

    public Discriminator getDiscriminator() {
        if (this.m_compDisc != null) {
            return this.m_compDisc;
        }
        return this.m_qdrDisc;
    }

    private boolean initFromSelection() throws EdgeOutOfRangeException, LayerOutOfRangeException, RowOutOfRangeException, ColumnOutOfRangeException, SliceOutOfRangeException {
        if (this.componentHandle == null) {
            return false;
        }
        if (this.componentHandle.getID() == 13) {
            this.m_qdrDisc = new QDRDiscriminator(new QDR(), 4);
        } else if (this.componentHandle instanceof DataComponentHandle) {
            ComponentInfo ci = this.componentHandle.getComponentInfo();
            int row = ((DataComponentInfo)ci).getRow();
            int col = ((DataComponentInfo)ci).getColumn();
            this.m_qdr = ci.getQDR(this.dataAccess, 0);
            this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
        } else if (this.componentHandle instanceof DataRangeComponentHandle) {
            int i;
            int row;
            int i2;
            DataComponentInfo[] ci = ((DataRangeComponentHandle)this.componentHandle).getLocationList();
            int col = this.dataAccess.getEdgeExtent(0);
            Vector[] cols = new Vector[col];
            Vector<Integer> rows = new Vector<Integer>();
            int column = -1;
            if (ci.length == this.dataAccess.getEdgeExtent(1)) {
                column = ci[0].getColumn();
            }
            boolean[] colSelected = new boolean[col];
            for (i2 = 0; i2 < ci.length; ++i2) {
                row = ci[i2].getRow();
                if (column != -1 && ci[i2].getColumn() != column) {
                    column = -1;
                }
                if (i2 == 0 || row != (Integer)rows.lastElement()) {
                    rows.addElement(new Integer(row));
                }
                colSelected[ci[i2].getColumn()] = true;
            }
            for (i2 = 0; i2 < rows.size(); ++i2) {
                row = (Integer)rows.elementAt(i2);
                for (int j = 0; j < col; ++j) {
                    Object val = this.dataAccess.getValue(row, j, "dataValue");
                    if (cols[j] != null) {
                        Object oldval = cols[j].lastElement();
                        if (val.equals(oldval)) continue;
                        cols[j].addElement(val);
                        continue;
                    }
                    cols[j] = new Vector();
                    cols[j].addElement(val);
                }
            }
            if (column != -1) {
                this.m_qdr = this.dataAccess.getSliceQDR(0, column, 0);
                this.m_qdr.setTarget(new QDRMember(this.dataAccess.getLayerMetadata(0, column, dimNameType).toString()));
                this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
            } else if (rows.size() > 1) {
                Vector data = new Vector();
                for (i = 0; i < ci.length; ++i) {
                    if (this.m_qdrDisc == null) {
                        this.m_qdrDisc = new QDRDiscriminator(ci[i].getQDR(this.dataAccess, 0), 4);
                        continue;
                    }
                    QDRDiscriminator disc = new QDRDiscriminator(ci[i].getQDR(this.dataAccess, 0), 4);
                    this.m_compDisc = this.m_compDisc == null ? new CompositeDiscriminator((Discriminator)this.m_qdrDisc, (Discriminator)disc, 1) : new CompositeDiscriminator((Discriminator)this.m_compDisc, (Discriminator)disc, 1);
                }
            } else {
                this.m_qdr = this.dataAccess.getSliceQDR(1, ci[0].getRow(), 0);
                Vector<String> data = new Vector<String>();
                for (i = 0; i < ci.length; ++i) {
                    data.addElement(this.dataAccess.getLayerMetadata(0, ci[i].getColumn(), dimNameType).toString());
                }
                if (data.size() > 1) {
                    this.m_qdr.setTarget(new QDRMember(3, data));
                } else {
                    this.m_qdr.setTarget(new QDRMember(0, data.elementAt(0)));
                }
                this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
            }
        } else if (this.componentHandle instanceof ColumnComponentHandle) {
            ColumnComponentInfo ci = (ColumnComponentInfo)this.componentHandle.getComponentInfo();
            int cols = this.dataAccess.getEdgeExtent(0);
            int col = ci.getColumn();
            this.m_qdr = ci.getQDR(this.dataAccess, 0);
            this.m_qdr.setTarget(new QDRMember(this.dataAccess.getLayerMetadata(0, col, dimNameType).toString()));
            this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
        } else if (this.componentHandle instanceof ColumnRangeComponentHandle) {
            ColumnComponentInfo[] ci = ((ColumnRangeComponentHandle)this.componentHandle).getLocationList();
            int col = this.dataAccess.getEdgeExtent(0);
            boolean[] cols = new boolean[col];
            for (int i = 0; i < ci.length; ++i) {
                cols[ci[i].getColumn()] = true;
            }
            Vector<String> data = new Vector<String>();
            for (int i = 0; i < col; ++i) {
                String dim = this.dataAccess.getLayerMetadata(0, i, dimNameType).toString();
                if (!cols[i]) continue;
                data.addElement(dim);
            }
            this.m_qdr = new QDR();
            if (data instanceof Vector) {
                this.m_qdr.setTarget(new QDRMember(3, data));
            } else {
                this.m_qdr.setTarget(new QDRMember(0, data));
            }
            this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
        } else if (this.componentHandle instanceof RowComponentHandle) {
            ComponentInfo ci = this.componentHandle.getComponentInfo();
            int col = this.dataAccess.getEdgeExtent(0);
            int row = ((RowComponentInfo)ci).getRow();
            Vector<String> data = new Vector<String>();
            for (int i = 0; i < col; ++i) {
                String dimension = this.dataAccess.getLayerMetadata(0, i, dimNameType).toString();
                data.addElement(dimension);
            }
            this.m_qdr = ci.getQDR(this.dataAccess, 0);
            if (data.size() > 1) {
                this.m_qdr.setTarget(new QDRMember(3, data));
            } else {
                this.m_qdr.setTarget(new QDRMember(0, data.elementAt(0)));
            }
            this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
        } else if (this.componentHandle instanceof RowRangeComponentHandle) {
            int i;
            RowComponentInfo[] ci = ((RowRangeComponentHandle)this.componentHandle).getLocationList();
            int col = this.dataAccess.getEdgeExtent(0);
            Vector[] cols = new Vector[col];
            Vector<String> data = new Vector<String>();
            for (i = 0; i < ci.length; ++i) {
                int row = ci[i].getRow();
                for (int j = 0; j < col; ++j) {
                    Object val = this.dataAccess.getValue(row, j, "dataValue");
                    if (cols[j] != null) {
                        Object oldval = cols[j].lastElement();
                        if (val.equals(oldval)) continue;
                        cols[j].addElement(val);
                        continue;
                    }
                    cols[j] = new Vector();
                    cols[j].addElement(val);
                }
            }
            for (i = 0; i < col; ++i) {
                String dimension = this.dataAccess.getLayerMetadata(0, i, dimNameType).toString();
                data.addElement(dimension);
            }
            for (i = 0; i < ci.length; ++i) {
                if (this.m_qdrDisc == null) {
                    this.m_qdr = ci[i].getQDR(this.dataAccess, 0);
                    if (data.size() > 1) {
                        this.m_qdr.setTarget(new QDRMember(3, data));
                    } else {
                        this.m_qdr.setTarget(new QDRMember(0, data.elementAt(0)));
                    }
                    this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
                    continue;
                }
                this.m_qdr = ci[i].getQDR(this.dataAccess, 0);
                if (data.size() > 1) {
                    this.m_qdr.setTarget(new QDRMember(3, data));
                } else {
                    this.m_qdr.setTarget(new QDRMember(0, data.elementAt(0)));
                }
                QDRDiscriminator disc = new QDRDiscriminator(this.m_qdr, 4);
                this.m_compDisc = this.m_compDisc == null ? new CompositeDiscriminator((Discriminator)this.m_qdrDisc, (Discriminator)disc, 1) : new CompositeDiscriminator((Discriminator)this.m_compDisc, (Discriminator)disc, 1);
            }
        } else if (this.componentHandle instanceof PageItemComponentHandle) {
            PageItemComponentInfo ci = (PageItemComponentInfo)this.componentHandle.getComponentInfo();
            String dimension = this.dataAccess.getLayerMetadata(2, ci.getPageItem(), dimNameType).toString();
            this.m_qdr = ci.getQDR(this.dataAccess, 0);
            this.m_qdr.setTarget(new QDRMember(dimension));
            this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
        } else {
            return false;
        }
        return true;
    }

    private Vector getDimValues(int col) {
        try {
            Vector<Object> members = new Vector<Object>();
            Object[] values = null;
            if (this.memberAccess != null) {
                values = this.memberAccess.getAllMembers(0, col, "dataValue");
            }
            for (int i = 0; i < this.dataAccess.getEdgeExtent(1); ++i) {
                Object member = values == null || values.length < i ? this.dataAccess.getValue(i, col, "dataValue") : values[i];
                if (members.indexOf(member) != -1) continue;
                members.addElement(member);
            }
            return members;
        }
        catch (RowOutOfRangeException e) {
            return null;
        }
        catch (ColumnOutOfRangeException e) {
            return null;
        }
        catch (EdgeOutOfRangeException e) {
            return null;
        }
        catch (LayerOutOfRangeException e) {
            return null;
        }
    }

    private Vector getDimValues(String dimension, String type) {
        if (dimension == null) {
            return null;
        }
        try {
            Vector<Object> members = new Vector<Object>();
            int m_dimEdge = -1;
            int m_dimDepth = -1;
            for (int i = 0; i < this.dataAccess.getEdgeCount(); ++i) {
                int layerCount = this.dataAccess.getLayerCount(i);
                for (int j = 0; j < layerCount; ++j) {
                    String dim = this.dataAccess.getLayerMetadata(i, j, dimNameType).toString();
                    if (dim == null || !dimension.equals(dim)) continue;
                    if (i == 2) {
                        int memberCount = this.dataAccess.getMemberExtent(i, j, 0);
                        for (int k = 0; k < memberCount; ++k) {
                            members.addElement(this.dataAccess.getMemberMetadata(i, j, k, memberNameType));
                        }
                        return members;
                    }
                    if (i == 0) {
                        return this.getDimValues(j);
                    }
                    members.addElement(this.dataAccess.getMemberMetadata(i, j, 0, memberNameType));
                    return members;
                }
            }
        }
        catch (EdgeOutOfRangeException e) {
        }
        catch (LayerOutOfRangeException e) {
        }
        catch (SliceOutOfRangeException sliceOutOfRangeException) {
            // empty catch block
        }
        return null;
    }
}

