/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.awt.event.MouseEvent;
import oracle.bali.ewt.grid.Grid;
import oracle.dss.gridView.GridViewDatabodyInputHandler;
import oracle.dss.table.Table;
import oracle.dss.table.TableDatabody;
import oracle.dss.util.ComponentInfo;
import oracle.dss.util.DataComponentInfo;

public class TableDatabodyInputHandler
extends GridViewDatabodyInputHandler {
    protected Table m_table = null;
    private static final String m_method_mousePressed = "mousePressed(MouseEvent e, Grid grid, int column, int row)";

    public TableDatabodyInputHandler(Table t) {
        super(t);
        this.m_table = t;
    }

    @Override
    public void mousePressed(MouseEvent e, Grid grid, int column, int row) {
        if (column < 0) {
            this.m_table.getErrorHandler().log("invalid column value", ((Object)((Object)this)).getClass().getName(), m_method_mousePressed);
            return;
        }
        if (row < 0) {
            this.m_table.getErrorHandler().log("invalid row value", ((Object)((Object)this)).getClass().getName(), m_method_mousePressed);
            return;
        }
        boolean bIncrementalFetch = false;
        if (this.m_table.getTable() != null && this.m_table.isIncrementalFetchEnabled() && this.m_table.getTable().isIncrementalFetchRowVisible() && row >= this.m_table.getTableModel().getTableDataSource().getRowCount() - 1) {
            bIncrementalFetch = true;
            TableDatabody databody = (TableDatabody)grid;
            DataComponentInfo focusCell = new DataComponentInfo(row, column);
            databody.setIncFetchFocusCell((ComponentInfo)focusCell);
            e.consume();
            this.m_table.getTableModel().getTableControllerActions().incrementalFetchGestureHappened(grid, this.m_table.getTableModel().getTableDataSource().getRowCount() - 1, this.m_table.getFetchIncrement());
        }
        if (!bIncrementalFetch) {
            super.mousePressed(e, grid, column, row);
        }
    }
}

