/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.beans.BeanInfo;
import java.text.MessageFormat;
import java.util.BitSet;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridKeyHandler;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.grid.bigCell.BigCellPainter;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.util.ImmInsets;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.dataView.managers.ViewStyleCallback;
import oracle.dss.gridView.GridViewAppearanceMgr;
import oracle.dss.gridView.GridViewData;
import oracle.dss.gridView.GridViewDatabody;
import oracle.dss.gridView.GridViewDatabodyAttributes;
import oracle.dss.gridView.GridViewDatabodyXML;
import oracle.dss.gridView.GridViewTextPainter;
import oracle.dss.gridView.GridlinePainter;
import oracle.dss.table.Table;
import oracle.dss.table.TableAppearanceMgr;
import oracle.dss.table.TableData;
import oracle.dss.table.TableDatabodyInputHandler;
import oracle.dss.table.TableDatabodyKeyHandler;
import oracle.dss.table.TableTips;
import oracle.dss.util.ComponentInfo;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.DataException;
import oracle.dss.util.WaitData;
import oracle.dss.util.xml.ObjectNode;

public class TableDatabody
extends Grid
implements GridViewDatabody,
ViewStyleCallback,
GridViewDatabodyAttributes {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    protected Table table = null;
    protected GridViewAppearanceMgr appearanceMgr = null;
    protected TableTips tips = null;
    protected ViewStyle defaultViewStyle = null;
    private ResourceBundle gBundle = null;
    private ResourceBundle rBundle = null;
    private static final String m_method_stylechanged = "styleChanged(int attributeId, String attributeName, Object oldValue, Object newValue)";
    private static final String m_method_updateforpropset = "updateforpropset(BitSet bs)";
    private static final String m_method_getgraphicimage = "getGraphicImage(int column, int row)";
    private static final String m_method_getgraphicbarratio = "getGraphicBarRatio(int column, int row)";
    private static final String m_method_isdrillout = "isDrillOut(int column, int row, int x, int y)";
    private static final String m_method_isAnnotation = "isAnnotation(int column, int row, int x, int y)";
    private GridViewDatabodyXML _viewDatabodyXML = new GridViewDatabodyXML(this);
    private ComponentInfo incFetchFocusCell = null;

    public TableDatabody(TableData model) {
        super((TwoDModel)model);
    }

    public void init(Table t) {
        this.table = t;
        this.updateResourceBundle(this.table.getLocale());
        this.appearanceMgr = new TableAppearanceMgr(this.table, this);
        this.setAppearanceManager(this.appearanceMgr);
        BigCellPainter bigCellPainter = new BigCellPainter((Painter)new GridViewTextPainter(this.table));
        this.setPainter((Painter)bigCellPainter);
        this.setHorizontalSeparatorPainter((Painter)new GridlinePainter(true, false));
        this.setVerticalSeparatorPainter((Painter)new GridlinePainter(false, false));
        this.setSelectionTransparent(true);
        this.setDrawSelectionBorder(true);
        this.setHorizontalSeparatorsVisible(false);
        this.setVerticalSeparatorsVisible(false);
        this.setBigCellHorizontalSeparatorsVisible(true);
        this.setBigCellVerticalSeparatorsVisible(true);
        this.defaultViewStyle = new ViewStyle((DataviewCommon)this.table, this.getDefaultAppearance());
        this.defaultViewStyle.setViewStyleCallback(this);
        this.appearanceMgr.setAppearance(this.defaultViewStyle);
        this.setGridSelectionManager((GridSelectionManager)new GeneralGridSelectionManager(2, 2, 2));
        TableDatabodyInputHandler tdbhandler = new TableDatabodyInputHandler(this.table);
        this.setDefaultInputHandler(tdbhandler);
        TableDatabodyKeyHandler keyhandler = new TableDatabodyKeyHandler(this.table);
        this.setGridKeyHandler((GridKeyHandler)keyhandler);
    }

    public TableData getTableData() {
        return (TableData)this.getModel();
    }

    @Override
    public GridViewData getGridViewData() {
        return (GridViewData)this.getModel();
    }

    @Override
    public ComponentInfo getCellFocus() {
        Component focusCellComponent = this.table.getTable().getGlobalFocusCellComponent();
        if (focusCellComponent != null && focusCellComponent == this.table.getTable().getGrid()) {
            Cell globalFocusCell = this.table.getTable().getGlobalFocusCell();
            return new DataComponentInfo(globalFocusCell.row, globalFocusCell.column);
        }
        return null;
    }

    @Override
    public void setCellFocus(ComponentInfo focusedCell) {
        if (focusedCell == null) {
            this.table.getTable().setGlobalFocusCell(null, null);
        }
        if (focusedCell instanceof DataComponentInfo) {
            DataComponentInfo dci = (DataComponentInfo)focusedCell;
            this.table.getTable().setGlobalFocusCell(new Cell(dci.getColumn(), dci.getRow()), (Component)this.table.getTable().getGrid());
            this.scrollCellIntoView(dci.getColumn(), dci.getRow());
            if (this.table.isFocusRequestedForCell()) {
                this.requestFocus();
            }
        }
    }

    public boolean getBigCellHorizontalSeparatorsVisible() {
        if (this.getPainter() instanceof BigCellPainter) {
            return ((BigCellPainter)this.getPainter()).getHorizontalSeparatorsVisible();
        }
        return false;
    }

    public void setBigCellHorizontalSeparatorsVisible(boolean visible) {
        if (this.getPainter() instanceof BigCellPainter) {
            ((BigCellPainter)this.getPainter()).setHorizontalSeparatorsVisible(visible);
            this.repaintInterior();
        }
    }

    public boolean getBigCellVerticalSeparatorsVisible() {
        if (this.getPainter() instanceof BigCellPainter) {
            return ((BigCellPainter)this.getPainter()).getVerticalSeparatorsVisible();
        }
        return false;
    }

    public void setBigCellVerticalSeparatorsVisible(boolean visible) {
        if (this.getPainter() instanceof BigCellPainter) {
            ((BigCellPainter)this.getPainter()).setVerticalSeparatorsVisible(visible);
            this.repaintInterior();
        }
    }

    @Override
    public int getID() {
        return 9;
    }

    @Override
    public String getComponentName() {
        return this.table.getNameFromID(9);
    }

    @Override
    public BeanInfo getBeanInfo() {
        return null;
    }

    public void setPainter(Painter painter) {
        this.setDefaultPainter(painter);
    }

    public Painter getPainter() {
        return this.getDefaultPainter();
    }

    @Override
    public void setVisible(boolean visible) {
        boolean old = this.isVisible();
        super.setVisible(visible);
        this.table.firePropertyChange(this, "Visible", new Boolean(old), new Boolean(visible));
    }

    @Override
    public boolean isVisible() {
        return super.isVisible();
    }

    @Override
    public ViewStyle getViewStyle() {
        return this.defaultViewStyle;
    }

    @Override
    public void setViewStyle(ViewStyle vs) {
        if (vs == null) {
            this.table.getErrorHandler().log("invalid ViewStyle", this.getClass().getName(), "setViewStyle");
            return;
        }
        ViewStyle oldval = this.defaultViewStyle;
        this.defaultViewStyle = new ViewStyle((DataviewCommon)this.table, vs);
        this.defaultViewStyle.setViewStyleCallback(this);
        this.updateForPropSet(ViewStyle.createDifferencesBitSet(oldval, this.defaultViewStyle));
        this.table.firePropertyChange(this, "ViewStyle", oldval, this.defaultViewStyle);
    }

    protected void propSet() {
        this.table.getTableModel().getGridViewDatabodyStyleManager().dataStyleChanged();
        this.clearCache();
    }

    @Override
    public void styleChanged(int attributeId, String attributeName, Object oldValue, Object newValue) {
        if (attributeId < 0 || attributeId > 37) {
            this.table.getErrorHandler().log("invalid view style attribute", this.getClass().getName(), m_method_stylechanged);
            return;
        }
        this.updateForPropSet(ViewStyle.createDifferencesBitSet(attributeId));
        this.table.firePropertyChange(this, attributeName, oldValue, newValue);
    }

    protected void updateForPropSet(BitSet bs) {
        this.propSet();
        if (bs == null) {
            this.table.getErrorHandler().log("invalid bitset", this.getClass().getName(), m_method_updateforpropset);
            return;
        }
        if (bs.get(1) || bs.get(3) || bs.get(4) || bs.get(5) || bs.get(6) || bs.get(27) || bs.get(26) || bs.get(28) || bs.get(25) || bs.get(7) || bs.get(8) || bs.get(36) || bs.get(16) || bs.get(18)) {
            this.table.updateRowHeights();
        }
        if (bs.get(3) || bs.get(4) || bs.get(6) || bs.get(26) || bs.get(28) || bs.get(8) || bs.get(37) || bs.get(18)) {
            this.table.updateColumnWidth();
        }
        if ((bs.get(32) || bs.get(33)) && this.appearanceMgr != null) {
            GridViewAppearanceMgr appMgr = (GridViewAppearanceMgr)this.getAppearanceManager();
            ViewStyle app = appMgr.getAppearance();
            if (bs.get(32)) {
                app.setEditBackground(this.defaultViewStyle.getEditBackground());
            }
            if (bs.get(33)) {
                app.setEditForeground(this.defaultViewStyle.getEditForeground());
            }
            appMgr.setAppearance(app);
        }
        this.table.repaint();
    }

    @Override
    public boolean isDrillOut(int column, int row, int x, int y) {
        if (column < 0) {
            this.table.getErrorHandler().log("invalid column value", this.getClass().getName(), m_method_isdrillout);
            return false;
        }
        if (row < 0) {
            this.table.getErrorHandler().log("invalid row value", this.getClass().getName(), m_method_isdrillout);
            return false;
        }
        boolean drillOut = false;
        Image image = this.getGraphicImage(column, row);
        int rowHeight = this.getRowHeight(row);
        float align = this.getCellPaintContext(column, row).getInteriorAlignmentY();
        int width = 0;
        int height = 0;
        if (image != null) {
            int xMax;
            int xMin;
            width = image.getWidth((ImageObserver)((Object)this));
            height = image.getHeight((ImageObserver)((Object)this));
            GridViewAppearanceMgr appMgr = (GridViewAppearanceMgr)this.getAppearanceManager();
            ViewStyle app = appMgr.getCellAppearance(column, row);
            ImmInsets insets = app.getInsets();
            boolean l2r = true;
            if (l2r) {
                xMin = insets.left;
                xMax = insets.left + width;
            } else {
                int colWidth = this.getColumnWidth(column);
                xMin = colWidth - insets.right - width;
                xMax = colWidth - insets.right;
            }
            Font f = app.getFont();
            int fontSize = 0;
            if (f == null) {
                f = this.getFont();
            }
            if (f != null) {
                fontSize = this.getFontMetrics(f).getHeight();
            }
            if (rowHeight < fontSize) {
                rowHeight = fontSize;
            }
            y = (int)((float)y - ((float)(rowHeight - insets.top - insets.bottom - fontSize) * align + (float)((fontSize - height) / 2)));
            drillOut = x >= xMin && x <= xMax && (y -= insets.top) >= 0 && y <= height;
        }
        return drillOut;
    }

    @Override
    public Image getGraphicImage(int column, int row) {
        return this.getGraphicImage(column, row, true);
    }

    public Image getGraphicImage(int column, int row, boolean scaled) {
        boolean bl = scaled = scaled && this.table.isImagesScaled();
        if (column < 0) {
            this.table.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getgraphicimage);
            return null;
        }
        if (row < 0) {
            this.table.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_getgraphicimage);
            return null;
        }
        int index = -1;
        if (!(this.table.isIncrementalFetchEnabled() && (this.table.getTable().isIncrementalFetchRowVisible() && row >= this.getTableData().getRowCount() - 1 || !this.table.getTable().isIncrementalFetchRowVisible() && row >= this.getTableData().getRowCount()))) {
            int modelCol = this.table.getTableModel().getDataFromTableCol(column);
            int modelRow = this.table.getTableModel().getDataFromTableRow(row);
            int groupSortData = this.getTableData().getGroupSortData(modelCol, modelRow);
            if (this.table.isPrintOrPreviewMode()) {
                if (this.table.getFirstPrintedRow() == row) {
                    if (groupSortData == 2 || groupSortData == 3) {
                        this.table.getTable().m_calculatedRowHeights[row] = -1;
                    }
                    index = this.appearanceMgr.getCellAppearance(column, row).getGraphicImageIndex();
                } else if (groupSortData != 2 && groupSortData != 3) {
                    index = this.appearanceMgr.getCellAppearance(column, row).getGraphicImageIndex();
                }
            } else {
                if (this.table.getWaitDataForRow(row) != null) {
                    return null;
                }
                if (groupSortData == 2 || groupSortData == 3) {
                    return null;
                }
                index = this.appearanceMgr.getCellAppearance(column, row).getGraphicImageIndex();
            }
        }
        if (index >= 0 && index < this.table.getGraphicImageCount()) {
            if (scaled) {
                return this.table.getScaledGraphicImage(index);
            }
            return this.table.getGraphicImage(index);
        }
        return null;
    }

    @Override
    public void clearCache() {
        if (this.appearanceMgr != null) {
            this.appearanceMgr.clearCache();
        }
    }

    @Override
    public Appearance getDefaultAppearance() {
        Appearance app = ((Appearance)UIManager.get("Grid.DefaultAppearance")).copy();
        ImmInsets insets = app.getInsets();
        int top = 0;
        int bottom = 0;
        int right = 0;
        int left = 0;
        left = insets.left < 3 ? 3 : insets.left;
        right = insets.right < 3 ? 3 : insets.right;
        top = insets.top < 3 ? 3 : insets.top;
        bottom = insets.bottom < 3 ? 3 : insets.bottom;
        ImmInsets newInsets = new ImmInsets(top, left, bottom, right);
        app.setInsets(newInsets);
        app.setBackground(Color.white);
        if (app.getForeground() == null) {
            app.setForeground(Color.black);
        }
        app.setHorizontalJustify(2);
        app.setVerticalJustify(1);
        return app;
    }

    @Override
    public float getGraphicBarRatio(int column, int row) {
        if (column < 0) {
            this.table.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getgraphicbarratio);
            return 0.0f;
        }
        if (row < 0) {
            this.table.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_getgraphicbarratio);
            return 0.0f;
        }
        float f = 0.0f;
        if (!(this.table.isIncrementalFetchEnabled() && (this.table.getTable().isIncrementalFetchRowVisible() && row >= this.getTableData().getRowCount() - 1 || !this.table.getTable().isIncrementalFetchRowVisible() && row >= this.getTableData().getRowCount()))) {
            try {
                int modelCol = this.table.getTableModel().getDataFromTableCol(column);
                int modelRow = this.table.getTableModel().getDataFromTableRow(row);
                int groupSortData = this.getTableData().getGroupSortData(modelCol, modelRow);
                Object object = null;
                if (this.table.isPrintOrPreviewMode()) {
                    if (this.table.getFirstPrintedRow() == row) {
                        if (this.table.isDataRatioSupported()) {
                            object = this.table.getTableModel().getDataAccess().getValue(modelRow, modelCol, "dataRatio");
                        }
                    } else if (groupSortData != 2 && groupSortData != 3 && this.table.isDataRatioSupported()) {
                        object = this.table.getTableModel().getDataAccess().getValue(modelRow, modelCol, "dataRatio");
                    }
                } else {
                    if (this.table.getWaitDataForRow(row) != null) {
                        return 0.0f;
                    }
                    if (this.table.isDataRatioSupported() && (object = this.table.getTableModel().getDataAccess().getValue(modelRow, modelCol, "dataRatio")) instanceof WaitData) {
                        this.table.setWaitDataForRow(row, (WaitData)object);
                        return 0.0f;
                    }
                    if (groupSortData == 2 || groupSortData == 3) {
                        return 0.0f;
                    }
                }
                if (object instanceof Float) {
                    f = ((Float)object).floatValue();
                }
            }
            catch (DataException e) {
                this.table.getErrorHandler().error((Throwable)e, this.getClass().getName(), "getGraphicBarRatio");
                return 0.0f;
            }
        }
        return f;
    }

    protected Table getTable() {
        return this.table;
    }

    @Override
    public void setXML(ObjectNode node, String version, int reset) {
        this._viewDatabodyXML.setXML(node, version, reset);
    }

    @Override
    public ObjectNode getXML(boolean allProperties) {
        return this._viewDatabodyXML.getXML(allProperties);
    }

    void setCellEditingAllowed(boolean b) {
        this.repaintInterior();
    }

    protected void resetToDefault(int reset) {
        this._viewDatabodyXML.resetToDefault();
        this.defaultViewStyle.resetToDefault(reset);
        this.appearanceMgr.setAppearance(this.defaultViewStyle);
        this.propSet();
    }

    private void updateResourceBundle(Locale loc) {
        if (loc != null) {
            this.gBundle = ResourceBundle.getBundle("oracle.dss.gridView.resource.GridViewBundle", loc);
            this.rBundle = ResourceBundle.getBundle("oracle.dss.table.resource.TableBundle", loc);
        } else {
            this.gBundle = ResourceBundle.getBundle("oracle.dss.gridView.resource.GridViewBundle");
            this.rBundle = ResourceBundle.getBundle("oracle.dss.table.resource.TableBundle");
        }
    }

    @Override
    public boolean isAnnotation(int column, int row, int x, int y) {
        if (column < 0) {
            this.table.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_isAnnotation);
            return false;
        }
        if (row < 0) {
            this.table.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_isAnnotation);
            return false;
        }
        if (!this.table.isAnnotationIconVisible()) {
            return false;
        }
        boolean bAnnotation = false;
        boolean bInAnnotationImage = false;
        bAnnotation = this.table.getGridViewModel().getGridViewDataSource().getAnnotation(column, row) != null;
        int width = 0;
        int height = 0;
        if (bAnnotation) {
            int xMax;
            int xMin;
            Image image = this.table.getAnnotationImage();
            int rowHeight = this.getRowHeight(row);
            float align = this.getCellPaintContext(column, row).getInteriorAlignmentY();
            width = image.getWidth((ImageObserver)((Object)this));
            height = image.getHeight((ImageObserver)((Object)this));
            GridViewAppearanceMgr appMgr = (GridViewAppearanceMgr)this.getAppearanceManager();
            ViewStyle app = appMgr.getCellAppearance(column, row);
            ImmInsets insets = app.getInsets();
            boolean l2r = true;
            if (!l2r) {
                int colWidth = this.getColumnWidth(column);
                xMin = colWidth - insets.right - width;
                xMax = colWidth - insets.right;
                if (this.getGraphicImage(column, row) != null) {
                    xMin -= this.getGraphicImage(column, row).getWidth((ImageObserver)((Object)this));
                    xMax -= this.getGraphicImage(column, row).getWidth((ImageObserver)((Object)this));
                }
            } else {
                xMin = insets.left;
                xMax = insets.left + width;
                if (this.getGraphicImage(column, row) != null) {
                    xMin += this.getGraphicImage(column, row).getWidth((ImageObserver)((Object)this)) + 1;
                    xMax += this.getGraphicImage(column, row).getWidth((ImageObserver)((Object)this)) + 1;
                }
            }
            Font f = app.getFont();
            int fontSize = 0;
            if (f == null) {
                f = this.getFont();
            }
            if (f != null) {
                fontSize = this.getFontMetrics(f).getHeight();
            }
            if (rowHeight < fontSize) {
                rowHeight = fontSize;
            }
            y = (int)((float)y - ((float)(rowHeight - insets.top - insets.bottom - fontSize) * align + (float)((fontSize - height) / 2)));
            bInAnnotationImage = x >= xMin && x <= xMax && (y -= insets.top) >= 0 && y <= height;
        }
        return bInAnnotationImage;
    }

    public void scrollColumnIntoView(int column) {
        if (this.table != null) {
            this.table.setDuringScroll(true);
        }
        super.scrollColumnIntoView(column);
        if (this.table != null) {
            this.table.setDuringScroll(false);
        }
    }

    public void scrollRowIntoView(int row) {
        if (this.table != null) {
            this.table.setDuringScroll(true);
        }
        super.scrollRowIntoView(row);
        if (this.table != null) {
            this.table.setDuringScroll(false);
        }
    }

    public void scrollCellIntoView(int column, int row) {
        if (this.table != null) {
            this.table.setDuringScroll(true);
        }
        super.scrollCellIntoView(column, row);
        if (this.table != null) {
            this.table.setDuringScroll(false);
        }
    }

    protected Grid.AccessibleGrid createAccessibleGrid() {
        return new TableAccessibleGrid();
    }

    protected ComponentInfo getIncFetchFocusCell() {
        return this.incFetchFocusCell;
    }

    protected void setIncFetchFocusCell(ComponentInfo focusCell) {
        this.incFetchFocusCell = focusCell;
    }

    protected class TableAccessibleGrid
    extends Grid.AccessibleGrid {
        private static final long serialVersionUID = 1L;

        public TableAccessibleGrid() {
            super((Grid)TableDatabody.this);
        }

        protected String getAccessibleName(int column, int row, Object data) {
            Object annotation;
            boolean bAnnotation;
            String accessibleName = super.getAccessibleName(column, row, data);
            boolean bNameStarting = true;
            Image im = TableDatabody.this.getGraphicImage(column, row);
            if (im != null) {
                accessibleName = MessageFormat.format(TableDatabody.this.rBundle.getString("Graphic Image"), accessibleName);
                bNameStarting = false;
            }
            boolean graphicBarVisible = false;
            boolean horizontalPageBreak = false;
            Appearance appearance = TableDatabody.this.getAppearanceManager().getCellPaintingAppearance(column, row);
            if (appearance instanceof ViewStyle) {
                graphicBarVisible = ((ViewStyle)appearance).isGraphicBarVisible();
                horizontalPageBreak = ((ViewStyle)appearance).isHPageBreak();
            }
            if (graphicBarVisible) {
                accessibleName = im != null ? MessageFormat.format(TableDatabody.this.rBundle.getString("Bar 1"), accessibleName) : MessageFormat.format(TableDatabody.this.rBundle.getString("Bar 2"), accessibleName);
                bNameStarting = false;
            }
            boolean bl = bAnnotation = (annotation = TableDatabody.this.table.getGridViewModel().getGridViewDataSource().getAnnotation(column, row)) != null;
            if (bAnnotation) {
                accessibleName = !bNameStarting ? MessageFormat.format(TableDatabody.this.gBundle.getString("annotation 1"), accessibleName) : MessageFormat.format(TableDatabody.this.gBundle.getString("annotation 2"), accessibleName);
            }
            if (horizontalPageBreak) {
                accessibleName = MessageFormat.format(TableDatabody.this.rBundle.getString("horiz break"), accessibleName);
            }
            return accessibleName;
        }
    }
}

