/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.EventListener;
import javax.swing.JTextPane;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.pivot.CollapseEvent;
import oracle.bali.ewt.pivot.CollapseListener;
import oracle.bali.ewt.pivot.DrillEvent;
import oracle.bali.ewt.pivot.DrillListener;
import oracle.bali.ewt.pivot.PageItem;
import oracle.bali.ewt.pivot.PagingPivotEvent;
import oracle.bali.ewt.pivot.PagingPivotListener;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.CellRange;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dss.dataView.BaseTitle;
import oracle.dss.dataView.ColumnComponentHandle;
import oracle.dss.dataView.ColumnRangeComponentHandle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.NonDataComponentHandle;
import oracle.dss.dataView.RowComponentHandle;
import oracle.dss.dataView.RowRangeComponentHandle;
import oracle.dss.dataView.ViewComponent;
import oracle.dss.gridView.GridViewControllerAdapter;
import oracle.dss.pagingControl.PageItemComponentHandle;
import oracle.dss.pagingControl.PagingComponent;
import oracle.dss.table.ColHeader;
import oracle.dss.table.RowHeader;
import oracle.dss.table.Table;
import oracle.dss.table.TableController;
import oracle.dss.table.TableDatabody;
import oracle.dss.table.TableHeader;
import oracle.dss.table.TableSizingManager;
import oracle.dss.table.TableSpreadTable;
import oracle.dss.table.TableTips;
import oracle.dss.table.TableUtils;
import oracle.dss.table.managers.TableRuleSizing;
import oracle.dss.util.ColumnComponentInfo;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.RowComponentInfo;

public class TableControllerAdapter
extends GridViewControllerAdapter
implements TableController,
CollapseListener,
DrillListener,
PagingPivotListener {
    private static final long serialVersionUID = 1L;
    protected TableSizingManager tableSizingManager = null;
    private Table table = null;
    private static final String m_method_unselectGridView = "unselectGridView()";

    public TableControllerAdapter(Table v) {
        super(v);
        this.table = v;
        TableSpreadTable tst = this.table.getTable();
        tst.addDrillListener(this);
        tst.addCollapseListener(this);
        tst.addPivotListener(this);
        v.getPagingControl().getPagingComponent().addPivotListener(this);
        tst.getTableDatabody().addFocusListener(this);
        tst.getGrid().addMouseMotionListener((MouseMotionListener)this);
        this.table.getTableRowHeader().addMouseMotionListener(this);
        this.table.getTableColumnHeader().addMouseMotionListener(this);
        tst.getCornerComponent("UPPER_LEFT_CORNER").addMouseMotionListener(this);
        tst.getGrid().addMouseListener((MouseListener)this);
        this.table.getTableRowHeader().addMouseListener(this);
        this.table.getTableColumnHeader().addMouseListener(this);
        tst.getCornerComponent("UPPER_LEFT_CORNER").addMouseListener(this);
        tst.getGrid().addKeyListener((KeyListener)this);
        this.table.getTableRowHeader().addKeyListener(this);
        this.table.getTableColumnHeader().addKeyListener(this);
        tst.getCornerComponent("UPPER_LEFT_CORNER").addKeyListener(this);
        this.setTableSizingManager(new TableRuleSizing(this.table));
        this.table.getTableDatabody().setToolTipManager(new TableTips(this.table, this, 12));
        this.table.getTableRowHeader().setToolTipManager(new TableTips(this.table, this, 11));
        this.table.getTableColumnHeader().setToolTipManager(new TableTips(this.table, this, 10));
    }

    public void collapse(CollapseEvent e) {
        if (!this.table.getTableModel().isDrillingEnabled() || !this.table.isEnabled()) {
            return;
        }
        if (this.table.isMetadataDrillSupported()) {
            try {
                int drillState = (Integer)this.table.getTableModel().getDataAccess().getMemberMetadata(this._getEdge(e), this._getDepth(e), this._getIndex(e), "drillState");
                if (this.table.getTableModel().getControllerActions().canDrill(this.table, this._getEdge(e), this._getDepth(e), this._getIndex(e), 0)) {
                    this.table.getTable().fireDrillEvent(e.getOrientation(), e.getColumn(), e.getRow(), new Integer(drillState));
                }
            }
            catch (DataException exception) {
                this.table.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "collapse");
            }
        }
    }

    public void headerCellDrillRequest(DrillEvent e) {
        if (this.table.isMetadataDrillSupported()) {
            try {
                int drillState = (Integer)this.table.getTableModel().getDataAccess().getMemberMetadata(this._getEdge(e), this._getDepth(e), this._getIndex(e), "drillState");
                if (this.table.getTableModel().getControllerActions().canDrill(this.table, this._getEdge(e), this._getDepth(e), this._getIndex(e), 0)) {
                    this.table.getTable().fireDrillEvent(e.getOrientation(), e.getColumn(), e.getRow(), new Integer(drillState));
                }
            }
            catch (DataException exception) {
                this.table.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "headerCellDrillRequest");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pivot(PagingPivotEvent e) {
        try {
            int sourceIndex = e.getSourceIndex();
            int destIndex = e.getDestinationIndex();
            int sourceEdge = this._getSourceEdge(e);
            int destEdge = this._getDestEdge(e);
            int flags = 0;
            if (sourceEdge == destEdge) {
                flags = destIndex > sourceIndex ? 3 : 2;
            } else {
                int layerCount = this.table.getTableModel().getDataAccess().getLayerCount(destEdge);
                if (destIndex == 0 && layerCount == 0) {
                    flags = 4;
                } else if (destIndex >= layerCount) {
                    --destIndex;
                    flags = 3;
                } else {
                    flags = 2;
                }
            }
            this.setCursor(WindowUtils.getWindow((Component)this.table), this.getCursorType(2));
            if (this.table.getTableModel().getControllerActions().canPivot(this.table, sourceEdge, destEdge, sourceIndex, destIndex, flags)) {
                this.table.getTableModel().getControllerActions().pivotGestureHappened(this.table, sourceEdge, destEdge, sourceIndex, destIndex, flags);
            }
        }
        catch (DataException exception) {
            this.table.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "pivot");
        }
        finally {
            this.setCursor(WindowUtils.getWindow((Component)this.table), this.getCursorType(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swap(PagingPivotEvent e) {
        try {
            int sourceDepth = 0;
            int destDepth = 0;
            sourceDepth = e.getSourceIndex();
            destDepth = e.getDestinationIndex();
            this.setCursor(WindowUtils.getWindow((Component)this.table), this.getCursorType(2));
            if (this.table.getTableModel().getControllerActions().canPivot(this.table, this._getSourceEdge(e), this._getDestEdge(e), sourceDepth, destDepth, 1)) {
                this.table.getTableModel().getControllerActions().pivotGestureHappened(this.table, this._getSourceEdge(e), this._getDestEdge(e), sourceDepth, destDepth, 1);
            }
        }
        catch (DataException exception) {
            this.table.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "swap");
        }
        finally {
            this.setCursor(WindowUtils.getWindow((Component)this.table), this.getCursorType(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void headerCellDrill(DrillEvent e) {
        if (!this.table.getTableModel().isDrillingEnabled() || !this.table.isEnabled()) {
            return;
        }
        try {
            this.setCursor(WindowUtils.getWindow((Component)this.table), this.getCursorType(2));
            this.table.getTableModel().getControllerActions().drillGestureHappened(this.table, this._getEdge(e), this._getDepth(e), this._getIndex(e), 0);
        }
        catch (DataException exception) {
            this.table.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "headerCellDrill");
        }
        finally {
            this.setCursor(WindowUtils.getWindow((Component)this.table), this.getCursorType(0));
        }
    }

    @Override
    public void focusCellChanged(TableEvent e) {
        if (e.getSource() == this.table.getTableRowHeader()) {
            this.processViewFocusEvent(new FocusEvent((Component)e.getSource(), 1004), TableUtils.createRangeComponent(this.table, 11, this.table.getNameFromID(11), e.getSource(), e.getRow(), null, false));
        } else if (e.getSource() == this.table.getTableColumnHeader()) {
            this.processViewFocusEvent(new FocusEvent((Component)e.getSource(), 1004), TableUtils.createRangeComponent(this.table, 10, this.table.getNameFromID(10), e.getSource(), e.getColumn(), null, false));
        } else {
            this.processViewFocusEvent(new FocusEvent((Component)this.table.getTable().getGrid(), 1004), TableUtils.createDataComponent(this.table, 12, this.table.getNameFromID(12), e.getSource(), e.getRow(), e.getColumn(), null, false));
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) throws PropertyVetoException {
        if (e.getSource() instanceof PagingComponent) {
            if (!this.inSetSelectedObject) {
                return;
            }
            if (e.getPropertyName() == "selectedIndex") {
                PagingComponent dpc = (PagingComponent)e.getSource();
                PageItem pi = dpc.getSelectedItem();
                int index = dpc.getIndex(pi);
                PageItemComponentHandle pic = new PageItemComponentHandle(4, "PageItem", dpc, index);
                if (index == -1) {
                    return;
                }
                if (this.gridViewSelectionManager.canSelectComponents(this.table) && this.gridViewSelectionManager.canSelectComponent(this.table, pic) && this.fireComponentSelecting(this.table, pic) && this.setSelectedObject(pic, false)) {
                    return;
                }
                throw new PropertyVetoException("Crosstab", e);
            }
            return;
        }
        if (e.getPropertyName().equals("selection")) {
            if (this.selectingCells) {
                return;
            }
            Object source = e.getSource();
            if (source == this.table.getTableColumnHeader()) {
                OneDSelection sel = (OneDSelection)e.getNewValue();
                if (sel.isEmpty()) {
                    return;
                }
                Cell cell = new Cell(sel.getSingleItem(), 0);
                ComponentHandle c = TableUtils.createRangeComponent(this.table, 10, this.table.getNameFromID(10), this.table.getTableColumnHeader(), cell.column, sel.getRanges(), true);
                if (this.gridViewSelectionManager.canSelectComponent(this.table, c) && this.fireComponentSelecting(this.table, c) && this.setSelectedObject(c, true)) {
                    return;
                }
                throw new PropertyVetoException("Table", e);
            }
            if (source == this.table.getTableRowHeader()) {
                OneDSelection sel = (OneDSelection)e.getNewValue();
                if (sel.isEmpty()) {
                    return;
                }
                Cell cell = new Cell(0, sel.getSingleItem());
                ComponentHandle c = TableUtils.createRangeComponent(this.table, 11, this.table.getNameFromID(11), this.table.getTableRowHeader(), cell.row, sel.getRanges(), true);
                if (this.gridViewSelectionManager.canSelectComponent(this.table, c) && this.fireComponentSelecting(this.table, c) && this.setSelectedObject(c, true)) {
                    return;
                }
                throw new PropertyVetoException("Table", e);
            }
            if (source == this.table.getTableDatabody()) {
                TwoDSelection sel2 = (TwoDSelection)e.getNewValue();
                if (sel2.isEmpty()) {
                    return;
                }
                OneDSelection cs = sel2.getColumnSelection();
                OneDSelection rs = sel2.getRowSelection();
                if (!cs.isEmpty()) {
                    ComponentHandle c = TableUtils.createRangeComponent(this.table, 14, this.table.getNameFromID(14), this.table.getTableColumnHeader(), cs.getSingleItem(), cs.getRanges(), true);
                    if (this.gridViewSelectionManager.canSelectComponents(this.table) && this.gridViewSelectionManager.canSelectComponent(this.table, c)) {
                        if (c instanceof ColumnRangeComponentHandle) {
                            boolean fireSelect = true;
                            ColumnRangeComponentHandle crcid = (ColumnRangeComponentHandle)c;
                            ColumnComponentInfo[] cci = crcid.getLocationList();
                            for (int i = 0; i < cci.length; ++i) {
                                if (this.gridViewSelectionManager.canSelectColumn(this.table.getTableModel().getDataFromTableCol(cci[i].getColumn()))) continue;
                                fireSelect = false;
                                break;
                            }
                            if (this.fireComponentSelecting(this.table, c) && this.setSelectedObject(c, true)) {
                                return;
                            }
                        } else if (c instanceof ColumnComponentHandle && this.gridViewSelectionManager.canSelectColumn(this.table.getTableModel().getDataFromTableCol(((ColumnComponentHandle)c).getColumn())) && this.fireComponentSelecting(this.table, c) && this.setSelectedObject(c, true)) {
                            return;
                        }
                    }
                    throw new PropertyVetoException("Table", e);
                }
                if (!rs.isEmpty()) {
                    ComponentHandle c = TableUtils.createRangeComponent(this.table, 15, this.table.getNameFromID(15), this.table.getTableRowHeader(), rs.getSingleItem(), rs.getRanges(), true);
                    if (this.gridViewSelectionManager.canSelectComponents(this.table) && this.gridViewSelectionManager.canSelectComponent(this.table, c)) {
                        if (c instanceof RowRangeComponentHandle) {
                            boolean fireSelect = true;
                            RowRangeComponentHandle rrcid = (RowRangeComponentHandle)c;
                            RowComponentInfo[] rci = rrcid.getLocationList();
                            for (int i = 0; i < rci.length; ++i) {
                                if (this.gridViewSelectionManager.canSelectRow(this.table.getTableModel().getDataFromTableRow(rci[i].getRow()))) continue;
                                fireSelect = false;
                                break;
                            }
                            if (this.fireComponentSelecting(this.table, c) && this.setSelectedObject(c, true)) {
                                return;
                            }
                        } else if (c instanceof RowComponentHandle && this.gridViewSelectionManager.canSelectRow(this.table.getTableModel().getDataFromTableRow(((RowComponentHandle)c).getRow())) && this.fireComponentSelecting(this.table, c) && this.setSelectedObject(c, true)) {
                            return;
                        }
                    }
                    throw new PropertyVetoException("Table", e);
                }
                ComponentHandle c = TableUtils.createDataComponent(this.table, 12, this.table.getNameFromID(12), (Object)this.table.getTableDatabody(), sel2.getSingleCell().row, sel2.getSingleCell().column, sel2.getCellRanges(), true);
                if (this.gridViewSelectionManager.canSelectComponents(this.table) && this.gridViewSelectionManager.canSelectComponent(this.table, c)) {
                    boolean canSelect;
                    if (c instanceof DataComponentHandle) {
                        canSelect = this.gridViewSelectionManager.canSelectCell(this.table.getTableModel().getDataFromTableRow(((DataComponentHandle)c).getRow()), this.table.getTableModel().getDataFromTableCol(((DataComponentHandle)c).getColumn()));
                    } else {
                        CellRange[] ranges = sel2.getCellRanges();
                        CellRange lastRange = ranges[ranges.length - 1];
                        Cell cell = lastRange.getUpperLimit();
                        canSelect = this.gridViewSelectionManager.canSelectCell(this.table.getTableModel().getDataFromTableRow(cell.row), this.table.getTableModel().getDataFromTableCol(cell.column));
                    }
                    if (canSelect && this.fireComponentSelecting(this.table, c)) {
                        if (!this.clickDragSelection && this.setSelectedObject(c, true)) {
                            return;
                        }
                        return;
                    }
                }
                throw new PropertyVetoException("Table", e);
            }
        }
    }

    @Override
    public void columnResized(TableEvent e) {
        super.columnResized(e);
        TableDatabody db = this.table.getTableDatabody();
        this.tableSizingManager.setPreferredColumnWidth(e.getColumn(), DataviewUtils.scaleDownByZoom(db.getColumnWidth(e.getColumn()), this.table.getZoomFactor()));
    }

    @Override
    public void rowResized(TableEvent e) {
        super.rowResized(e);
        TableDatabody db = this.table.getTableDatabody();
        this.tableSizingManager.setPreferredRowHeight(e.getRow(), DataviewUtils.scaleDownByZoom(db.getRowHeight(e.getRow()), this.table.getZoomFactor()));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int itemSize;
        int itemPos;
        this.mouseEvent = e;
        ComponentHandle c = this.getComponentFromGrid(e.getSource(), e.getX(), e.getY(), false);
        if (!this.table.isEnabled()) {
            this.processViewMouseEvent(e, c);
            return;
        }
        if (c.getID() == 14 && this.inResize && e.getClickCount() == this.AUTOFIT_CLICKS) {
            ColumnComponentHandle cch = (ColumnComponentHandle)c;
            int column = cch.getColumn();
            try {
                itemPos = ((Header)e.getSource()).getItemPosition(column);
                itemSize = ((Header)e.getSource()).getItemSize(column);
                int xLoc = e.getX();
                if (xLoc - itemPos < itemPos + itemSize - xLoc && column != this.table.getTableModel().getDataAccess().getEdgeExtent(0)) {
                    --column;
                }
            }
            catch (EdgeOutOfRangeException exception) {
                this.table.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "mouseClicked");
            }
            this.table.doubleClickAutoFitColumnWidth(column);
            this.inResize = false;
            e.consume();
        }
        if (c.getID() == 15 && this.inResize && e.getClickCount() == this.AUTOFIT_CLICKS) {
            RowComponentHandle rch = (RowComponentHandle)c;
            int row = rch.getRow();
            try {
                itemPos = ((Header)e.getSource()).getItemPosition(row);
                itemSize = ((Header)e.getSource()).getItemSize(row);
                int yLoc = e.getY();
                if (yLoc - itemPos < itemPos + itemSize - yLoc && row != this.table.getTableModel().getDataAccess().getEdgeExtent(1)) {
                    --row;
                }
            }
            catch (EdgeOutOfRangeException exception) {
                this.table.getErrorHandler().error((Throwable)exception, this.getClass().getName(), "mouseClicked");
            }
            this.table.autoFitRowHeight(row);
            this.inResize = false;
            e.consume();
        }
        this.processViewMouseEvent(e, c);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseEvent = e;
        ComponentHandle c = this.getComponentFromGrid(e.getSource(), e.getX(), e.getY(), false);
        if (this.table.isEnabled() && c.getID() == 13) {
            this.table.getTable().requestFocus();
            if (this.table.getTable().isColumnHeaderVisible() && this.table.getTable().isRowHeaderVisible() && this.table.getTable().isSelectAllEnabled()) {
                try {
                    this.table.getTable().getGrid().selectAll();
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                e.consume();
            }
        }
        super.mousePressed(e);
    }

    @Override
    public void setTableSizingManager(TableSizingManager m) {
        this.setGridViewSizingManager(m);
        this.tableSizingManager = m;
        this.table.doSizing();
    }

    @Override
    public TableSizingManager getTableSizingManager() {
        return this.tableSizingManager;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        TableSpreadTable pt = this.table.getTable();
        pt.removeDrillListener(this);
        pt.removeCollapseListener(this);
        pt.removePivotListener(this);
        pt.getTableDatabody().removeFocusListener(this);
        pt.getGrid().removeMouseMotionListener((MouseMotionListener)this);
        pt.getColumnHeader().removeMouseMotionListener((MouseMotionListener)this);
        pt.getRowHeader().removeMouseMotionListener((MouseMotionListener)this);
        pt.getCornerComponent("UPPER_LEFT_CORNER").removeMouseMotionListener(this);
        pt.getGrid().removeMouseListener((MouseListener)this);
        pt.getColumnHeader().removeMouseListener((MouseListener)this);
        pt.getRowHeader().removeMouseListener((MouseListener)this);
        pt.getCornerComponent("UPPER_LEFT_CORNER").removeMouseListener(this);
        pt.getGrid().removeKeyListener((KeyListener)this);
        pt.getColumnHeader().removeKeyListener((KeyListener)this);
        pt.getRowHeader().removeKeyListener((KeyListener)this);
        pt.getCornerComponent("UPPER_LEFT_CORNER").removeKeyListener(this);
    }

    @Override
    public Object cloneForNewView(Table v) {
        TableControllerAdapter cca = new TableControllerAdapter(v);
        Object[] o = this.listenerList.getListenerList();
        for (int l = 0; l < o.length; l += 2) {
            cca.listenerList.add((Class)o[l], (EventListener)o[l + 1]);
        }
        return cca;
    }

    @Override
    protected boolean fireSizingEvent(ComponentHandle comp) {
        this.sizingComponent = comp;
        return this.fireComponentSizing(this.table, comp);
    }

    @Override
    protected MouseEvent getMouseEvent() {
        return super.getMouseEvent();
    }

    @Override
    protected ComponentHandle getComponentFromGrid(Object source, int x, int y, boolean useSelState) {
        boolean DBHighlight = false;
        int row = -1;
        int column = -1;
        if (source instanceof PageItem) {
            return this.createComponentFromPageItem(source);
        }
        if (source instanceof Grid || source instanceof TableDatabody) {
            Grid g = (Grid)source;
            TableDatabody pg = null;
            if (source instanceof TableDatabody) {
                pg = (TableDatabody)source;
            }
            Point p = g.convertOuterToCanvas(x, y);
            column = g.getColumnAt(p.x);
            row = g.getRowAt(p.y);
            if (row == -1 || column == -1) {
                return this.getNonDataComponent(pg);
            }
            return TableUtils.createDataComponent(this.table, 12, this.table.getNameFromID(12), (Object)new Cell(column, row), row, column, this.table.getTable().getSelection().getCellRanges(), useSelState);
        }
        if (source instanceof TableHeader) {
            if (source instanceof RowHeader) {
                row = ((Header)source).getItemAt(x, y);
                if (row == -1) {
                    return this.getNonDataComponent((ViewComponent)source);
                }
                return TableUtils.createRangeComponent(this.table, 15, this.table.getNameFromID(15), source, row, this.table.getTableRowHeader().getSelection().getRanges(), useSelState);
            }
            if (source instanceof ColHeader) {
                column = ((Header)source).getItemAt(x, y);
                if (column == -1) {
                    return this.getNonDataComponent((ViewComponent)source);
                }
                return TableUtils.createRangeComponent(this.table, 14, this.table.getNameFromID(14), source, column, this.table.getTableColumnHeader().getSelection().getRanges(), useSelState);
            }
        } else {
            JTextPane textPane;
            if (source instanceof ViewComponent) {
                return this.getNonDataComponent((ViewComponent)source);
            }
            if (source == this.table.getTable().getCornerComponent("UPPER_LEFT_CORNER")) {
                return new NonDataComponentHandle(13, this.table.getNameFromID(13), this.table);
            }
            if (source instanceof JTextPane && (textPane = (JTextPane)source).getParent() instanceof BaseTitle) {
                return this.getNonDataComponent((ViewComponent)((Object)textPane.getParent()));
            }
        }
        return new NonDataComponentHandle(21, "Table", source);
    }

    @Override
    protected ComponentHandle getComponentFromGrid(Object source, boolean useSelState) {
        int row = -1;
        int column = -1;
        if (source instanceof PageItem) {
            return this.createComponentFromPageItem(source);
        }
        if (source instanceof Grid) {
            Cell cell;
            Grid g = (Grid)source;
            TableDatabody pg = null;
            if (source instanceof TableDatabody) {
                pg = (TableDatabody)source;
            }
            if ((cell = g.getFocusCell()) != null) {
                column = g.getFocusCell().column;
                row = g.getFocusCell().row;
            }
            if (row == -1 || column == -1) {
                return this.getNonDataComponent(pg);
            }
            return TableUtils.createDataComponent(this.table, 12, this.table.getNameFromID(12), (Object)new Cell(column, row), row, column, this.table.getTable().getSelection().getCellRanges(), useSelState);
        }
        if (source instanceof TableHeader) {
            if (source instanceof RowHeader) {
                if (this.mouseEvent != null) {
                    row = ((Header)source).getItemAt(this.mouseEvent.getX(), this.mouseEvent.getY());
                }
                if (row == -1) {
                    return this.getNonDataComponent((ViewComponent)source);
                }
                return TableUtils.createRangeComponent(this.table, 15, this.table.getNameFromID(15), source, row, this.table.getTableRowHeader().getSelection().getRanges(), useSelState);
            }
            if (source instanceof ColHeader) {
                if (this.mouseEvent != null) {
                    column = ((Header)source).getItemAt(this.mouseEvent.getX(), this.mouseEvent.getY());
                }
                if (column == -1) {
                    return this.getNonDataComponent((ViewComponent)source);
                }
                return TableUtils.createRangeComponent(this.table, 14, this.table.getNameFromID(14), source, column, this.table.getTableColumnHeader().getSelection().getRanges(), useSelState);
            }
        } else {
            JTextPane textPane;
            if (source instanceof ViewComponent) {
                return this.getNonDataComponent((ViewComponent)source);
            }
            if (source == this.table.getTable().getCornerComponent("UPPER_LEFT_CORNER")) {
                return new NonDataComponentHandle(13, this.table.getNameFromID(13), this.table);
            }
            if (source instanceof JTextPane && (textPane = (JTextPane)source).getParent() instanceof BaseTitle) {
                return this.getNonDataComponent((ViewComponent)((Object)textPane.getParent()));
            }
        }
        return new NonDataComponentHandle(21, "Table", source);
    }

    @Override
    protected void unselectGridView() {
        boolean oldSelecting = this.selectingCells;
        this.setSelectingCells(true);
        try {
            this.table.getTable().deselectAll();
        }
        catch (PropertyVetoException pve) {
            this.table.getErrorHandler().log("can't deselect all", this.getClass().getName(), m_method_unselectGridView);
        }
        this.setSelectingCells(oldSelecting);
    }

    private int _getEdge(DrillEvent e) {
        return e.getOrientation() == 0 ? 0 : 1;
    }

    private int _getEdge(CollapseEvent e) {
        return e.getOrientation() == 0 ? 0 : 1;
    }

    private int _getSourceEdge(PagingPivotEvent e) {
        Object o = e.getSource();
        if (o instanceof TableHeader) {
            return ((TableHeader)o).getEdge();
        }
        if (o instanceof PagingComponent) {
            return ((PagingComponent)o).getEdge();
        }
        return -1;
    }

    private int _getDestEdge(PagingPivotEvent e) {
        Object o = e.getDestination();
        if (o instanceof TableHeader) {
            return ((TableHeader)o).getEdge();
        }
        if (o instanceof PagingComponent) {
            return ((PagingComponent)o).getEdge();
        }
        return -1;
    }

    private int _getDepth(DrillEvent e) {
        return e.getOrientation() == 0 ? e.getColumn() : e.getRow();
    }

    private int _getDepth(CollapseEvent e) {
        return e.getOrientation() == 0 ? e.getColumn() : e.getRow();
    }

    private int _getIndex(DrillEvent e) {
        return e.getOrientation() == 0 ? e.getRow() : e.getColumn();
    }

    private int _getIndex(CollapseEvent e) {
        return e.getOrientation() == 0 ? e.getRow() : e.getColumn();
    }
}

