/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.io.IOException;
import oracle.bali.ewt.dnd.DragGestureEvent;
import oracle.bali.ewt.dnd.DragGestureListener;
import oracle.bali.ewt.dnd.DragSource;
import oracle.bali.ewt.dnd.DragSourceDragEvent;
import oracle.bali.ewt.dnd.DragSourceDropEvent;
import oracle.bali.ewt.dnd.DragSourceEvent;
import oracle.bali.ewt.dnd.DragSourceListener;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.pivot.PivotTransfer;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.datatransfer.TransferUtils;
import oracle.dss.table.ColHeader;
import oracle.dss.table.Table;
import oracle.dss.table.TableSpreadTable;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataException;

class ColHeaderDragDropAdapter
implements DropTargetListener,
DragSourceListener,
DragGestureListener {
    private Table _table;
    private TableSpreadTable _spreadTable;
    private ColHeader _header;

    public ColHeaderDragDropAdapter(Table t, ColHeader header) {
        this._table = t;
        this._spreadTable = t.getTable();
        this._header = header;
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer((Component)((Object)this._header), 2, (DragGestureListener)this);
        DropTarget dummy = new DropTarget((Component)((Object)this._header), (DropTargetListener)this);
    }

    public void dragEnter(DropTargetDragEvent e) {
    }

    public void dragOver(DropTargetDragEvent e) {
        if (!this._acceptDrag(e)) {
            e.rejectDrag();
            return;
        }
        boolean isSwap = this._header.isSwap(e.getLocation());
        int index = this._getIndex(e.getLocation(), isSwap);
        this._setDropLocation(index, isSwap);
        this._header.checkScroller(e);
    }

    public void dragScroll(DropTargetDragEvent e) {
    }

    public void dragExit(DropTargetEvent e) {
        this._setDropLocation(-1, false);
        this._header.clearLastSwapDropIndex();
        this._header.cancelScroller();
    }

    public void dropActionChanged(DropTargetDragEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drop(DropTargetDropEvent e) {
        e.acceptDrop(1);
        this._setDropLocation(-1, false);
        this._header.clearLastSwapDropIndex();
        this._header.cancelScroller();
        Transferable transfer = e.getTransferable();
        Object data = null;
        try {
            data = transfer.getTransferData(PivotTransfer.DATA_FLAVOR);
        }
        catch (UnsupportedFlavorException ufe) {
            data = null;
        }
        catch (IOException ioe) {
            data = null;
        }
        boolean success = false;
        if (data != null && data instanceof PivotTransfer) {
            PivotTransfer pTransfer = (PivotTransfer)data;
            Object source = pTransfer.getSource();
            int sourceIndex = pTransfer.getIndex();
            boolean isSwap = this._header.isSwap(e.getLocation());
            ColHeader destination = this._header;
            int destinationIndex = this._getIndex(e.getLocation(), isSwap);
            if (source == destination) {
                if (sourceIndex != destinationIndex) {
                    DataDirector dd = this._table.getTableModel().getDataDirector();
                    if (isSwap) {
                        int y;
                        int x;
                        if (sourceIndex < destinationIndex) {
                            x = sourceIndex;
                            y = destinationIndex;
                        } else {
                            x = destinationIndex;
                            y = sourceIndex;
                        }
                        try {
                            this.setCursor(WindowUtils.getWindow((Component)this._table), this._table.getTableController().getCursorType(2));
                            this._table.getTableModel().getGridViewControllerActions().reorderGestureHappened(this._table, 0, x, y, -1, -1, 1);
                        }
                        catch (DataException de) {
                            this._table.getErrorHandler().error((Throwable)de, this.getClass().getName(), "drop");
                        }
                        finally {
                            this.setCursor(WindowUtils.getWindow((Component)this._table), this._table.getTableController().getCursorType(0));
                        }
                    } else {
                        try {
                            this.setCursor(WindowUtils.getWindow((Component)this._table), this._table.getTableController().getCursorType(2));
                            this._table.getTableModel().getGridViewControllerActions().reorderGestureHappened(this._table, 0, sourceIndex, destinationIndex, -1, -1, 2);
                        }
                        catch (DataException de) {
                            this._table.getErrorHandler().error((Throwable)de, this.getClass().getName(), "drop");
                        }
                        finally {
                            this.setCursor(WindowUtils.getWindow((Component)this._table), this._table.getTableController().getCursorType(0));
                        }
                    }
                }
            } else if (!isSwap) {
                this._spreadTable.firePivotEvent(source, sourceIndex, destination, destinationIndex);
            } else {
                this._spreadTable.fireSwapEvent(source, sourceIndex, destination, destinationIndex);
            }
            success = true;
        }
        e.dropComplete(success);
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        if (this._header.getGeometryManager().isResizing()) {
            return;
        }
        if (this._header.getItemCount() == 0) {
            return;
        }
        Point origin = e.getDragOrigin();
        int index = this._header.getItemAt(origin.x, origin.y);
        if (index == -1) {
            return;
        }
        if (!this._canPivot(index)) {
            return;
        }
        origin.x = this._header.getItemPosition(index) - origin.x;
        origin.y = -origin.y;
        Image dragImage = null;
        this._header.setDragItem(index, true);
        e.startDrag(null, dragImage, origin, PivotTransfer.createTransferable((Object)this._header, (int)index), (DragSourceListener)this);
        Object[] events = e.toArray();
        Object toConsume = events[events.length - 1];
        if (toConsume instanceof InputEvent) {
            ((InputEvent)toConsume).consume();
        }
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragDropEnd(DragSourceDropEvent e) {
        this._header.setDragItem(-1, e.getDropSuccess());
    }

    private boolean _acceptDrag(DropTargetDragEvent dtde) {
        if (!this._header.isEnabled()) {
            return false;
        }
        DataFlavor[] flavors = dtde.getCurrentDataFlavors();
        if (flavors == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!TransferUtils.supportsDataFlavor((DataFlavor)flavors[i], (DataFlavor)PivotTransfer.DATA_FLAVOR)) continue;
            return true;
        }
        return false;
    }

    void _setDropLocation(int index, boolean isSwap) {
        this._header.setDropLocation(index, isSwap);
    }

    private int _getIndex(Point p, boolean isSwap) {
        int index = -1;
        boolean l2r = this._spreadTable.getActualReadingDirection() == 1;
        p = this._header.convertOuterToCanvas(p.x, p.y);
        index = this._header.getItemAt(p.x, p.y);
        if (!isSwap) {
            if (index == -1) {
                int count = this._header.getItemCount();
                index = count == 0 ? 0 : this._getPrevPivotableIndex(count - 1) + 1;
            } else if ((index = this._getPrevPivotableIndex(index)) == -1) {
                index = 0;
            } else {
                int position = this._header.getItemPosition(index);
                int size = this._header.getItemSize(index);
                if (l2r) {
                    if (p.x > position + size / 2) {
                        ++index;
                    }
                } else if (p.x < position + size / 2) {
                    ++index;
                }
            }
        }
        return index;
    }

    private void setCursor(Component component, Cursor c) {
        component.setCursor(c);
        if (component instanceof Container) {
            Container cont = (Container)component;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                this.setCursor(cont.getComponent(i), c);
            }
        }
    }

    private boolean _canPivot(int index) {
        boolean bPivotSupported = true;
        int iPivotSupported = this._header.getCanPivot(index);
        if (iPivotSupported == 0) {
            bPivotSupported = false;
        }
        return bPivotSupported;
    }

    private int _getPrevPivotableIndex(int index) {
        for (int i = index; i >= 0; --i) {
            if (!this._canPivot(i)) continue;
            return i;
        }
        return -1;
    }
}

