/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.table;

import java.io.Serializable;
import oracle.dss.table.HeaderData;
import oracle.dss.table.Table;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;

public class ColHeaderData
extends HeaderData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int[] m_cacheCanPivot = null;
    private static final int NOT_CACHED = -1;
    private static final String m_method_getCanPivot = "protected int getCanPivot(int index)";

    ColHeaderData(Table t) {
        super(t);
        this.addItems(0, this.getColumnCount());
    }

    @Override
    protected boolean isRowHeader() {
        return false;
    }

    public int getColumnCount() {
        try {
            return this.dataAccess.getEdgeExtent(0);
        }
        catch (EdgeOutOfRangeException e) {
            return 0;
        }
    }

    public int getRowCount() {
        return 0;
    }

    @Override
    protected Object calculateCell(int index) {
        return this.calculateCell(index, 0);
    }

    protected int getCanPivot(int index) {
        if (this.m_cacheCanPivot == null) {
            this.m_cacheCanPivot = new int[this.getColumnCount()];
            for (int i = 0; i < this.m_cacheCanPivot.length; ++i) {
                this.m_cacheCanPivot[i] = -1;
            }
        }
        if (this.m_cacheCanPivot[index] != -1) {
            return this.m_cacheCanPivot[index];
        }
        int iPivotSupported = 1;
        if (this.table.isLayerMetaCanPivotSupported()) {
            try {
                Object oPivotSupported = this.table.getModel().getDataAccess().getLayerMetadata(0, index, "dimCanPivot");
                if (oPivotSupported != null && oPivotSupported instanceof Integer) {
                    iPivotSupported = (Integer)oPivotSupported;
                }
            }
            catch (EdgeOutOfRangeException eoore) {
                this.table.getErrorHandler().log("edge out of range when getting LAYER_METADATA_CANPIVOT", this.getClass().getName(), m_method_getCanPivot);
            }
            catch (LayerOutOfRangeException loore) {
                this.table.getErrorHandler().log("layer out of range when getting LAYER_METADATA_CANPIVOT", this.getClass().getName(), m_method_getCanPivot);
            }
        }
        this.m_cacheCanPivot[index] = iPivotSupported;
        return iPivotSupported;
    }
}

