/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.share.util.IntegerUtils;
import oracle.dss.gridView.ASFormatModel;
import oracle.dss.gridView.GridViewCommon;
import oracle.dss.gridView.GridViewFormatUtils;
import oracle.dss.gridView.UIFormat;
import oracle.dss.gridView.UIGridView;
import oracle.dss.gridView.gui.FormatsPanel;
import oracle.dss.gridView.gui.RulesPanel;
import oracle.dss.gridView.gui.StoplightColorDialog;
import oracle.dss.rules.discriminator.CompositeDiscriminator;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.QDRDiscriminator;
import oracle.dss.util.DataAccess;
import oracle.dss.util.LayoutAccess;
import oracle.dss.util.LayoutContext;
import oracle.dss.util.QDR;
import oracle.dss.util.help.HelpContext;

public class StoplightPanel
extends JPanel
implements KeyListener,
ActionListener,
ItemListener {
    private static final long serialVersionUID = 1L;
    private Dialog m_parent;
    private UIGridView m_gridView;
    private ResourceBundle m_bundle;
    private JTextField m_formatTextField;
    private JComboBox m_measureBox;
    private JButton m_cellsButton;
    private NumberTextField m_unacceptTextField;
    private ColorPanel m_unacceptColor;
    private JLabel m_acceptTextField;
    private ColorPanel m_acceptColor;
    private NumberTextField m_desireTextField;
    private ColorPanel m_desireColor;
    private JButton m_editButton;
    private JLabel m_rangeLabel;
    private DefaultComboBoxModel m_model;
    private DescriptionTextPanel m_descTextPanel;
    private DescriptionColorPanel m_descColorPanel;
    private UIFormat m_uiFormat;
    private String m_measureDim;
    private Vector m_measureVector;
    private FormatsPanel m_formatsPanel;
    private HelpProvider m_helpProvider;
    private Color m_goodColor;
    private Color m_badColor;
    private Color m_warningColor;
    private NumberFormat m_numberFormat;
    private Discriminator m_selectionDisc;
    private boolean m_editMode;
    private ImageIcon m_stopIcon;

    public StoplightPanel(Dialog parent, UIGridView gridView) {
        this.m_parent = parent;
        this.m_gridView = gridView;
        if (gridView.getFormatModel() == null) {
            gridView.setFormatModel(new ASFormatModel(gridView));
        }
        this._initialize(gridView);
    }

    public StoplightPanel(Dialog parent, UIGridView gridView, UIFormat format) {
        this.m_parent = parent;
        this.m_gridView = gridView;
        this.m_uiFormat = format;
        if (gridView.getFormatModel() == null) {
            gridView.setFormatModel(new ASFormatModel(gridView));
        }
        this._initialize(gridView);
    }

    public StoplightPanel(Dialog parent, UIGridView gridView, UIFormat format, Color badColor, Color warningColor, Color goodColor) {
        this.m_parent = parent;
        this.m_gridView = gridView;
        this.m_uiFormat = format;
        if (gridView.getFormatModel() == null) {
            gridView.setFormatModel(new ASFormatModel(gridView));
        }
        this.m_goodColor = goodColor;
        this.m_badColor = badColor;
        this.m_warningColor = warningColor;
        this._initialize(gridView);
    }

    private void _initialize(UIGridView gridView) {
        if (gridView.getLocale() != null) {
            this.setLocale(gridView.getLocale());
        } else {
            this.updateResourceBundle(null);
        }
        this.m_numberFormat = gridView.getLocale() != null ? NumberFormat.getInstance(gridView.getLocale()) : NumberFormat.getInstance();
        this.m_numberFormat.setGroupingUsed(false);
        JPanel _mainPanel = new JPanel();
        _mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 3, 2);
        c.fill = 2;
        c.ipadx = 0;
        c.ipady = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 6;
        c.gridheight = 1;
        JLabel _optionsLabel = new JLabel();
        this.setLabelText(_optionsLabel, this.m_bundle.getString("STOPLIGHT.SPECIFYOPTIONS"));
        _mainPanel.add((Component)_optionsLabel, c);
        c.gridy = 1;
        c.gridwidth = 1;
        JLabel _formatLabel = new JLabel();
        this.setLabelText(_formatLabel, this.m_bundle.getString("STOPLIGHT.FORMATNAME"));
        _mainPanel.add((Component)_formatLabel, c);
        c.gridx = 1;
        c.gridwidth = 5;
        c.weightx = 10.0;
        c.insets = new Insets(2, 2, 5, 2);
        this.m_formatTextField = new JTextField();
        this.m_formatTextField.setName("StoplightFormatName");
        this.m_formatTextField.setEnabled(true);
        _formatLabel.setLabelFor(this.m_formatTextField);
        _mainPanel.add((Component)this.m_formatTextField, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 6;
        c.weightx = 0.0;
        JLabel _cellsFormatLabel = new JLabel();
        this.setLabelText(_cellsFormatLabel, this.m_bundle.getString("STOPLIGHT.SPECIFYCELLS"));
        _mainPanel.add((Component)_cellsFormatLabel, c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(0, 2, 10, 2);
        JLabel _applyFormatLabel = new JLabel();
        this.setLabelText(_applyFormatLabel, this.m_bundle.getString("STOPLIGHT.APPLYFORMAT"));
        _mainPanel.add((Component)_applyFormatLabel, c);
        this.m_model = this.createModel();
        this.m_measureBox = new JComboBox(this.m_model);
        this.m_measureBox.setName("ApplyFormatTo");
        c.gridx = 1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        _mainPanel.add((Component)this.m_measureBox, c);
        c.gridx = 4;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.m_cellsButton = new JButton();
        this.m_cellsButton.setName("CellsButton");
        this.m_cellsButton.setAlignmentX(0.0f);
        this.m_cellsButton.setActionCommand("SPECIFYCELLS");
        this.m_cellsButton.addActionListener(this);
        this.setButtonText(this.m_cellsButton, this.m_bundle.getString("STOPLIGHT.SPECIFY"));
        this.m_cellsButton.setEnabled(false);
        _mainPanel.add((Component)this.m_cellsButton, c);
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 7;
        c.insets = new Insets(2, 2, 3, 2);
        JLabel _rangeLabel = new JLabel();
        this.setLabelText(_rangeLabel, this.m_bundle.getString("STOPLIGHT.SPECIFYTHRESHOLDS"));
        _mainPanel.add((Component)_rangeLabel, c);
        c.gridy = 8;
        c.gridwidth = 1;
        c.weightx = 0.0;
        JLabel _unacceptLabel = new JLabel();
        this.setLabelText(_unacceptLabel, this.m_bundle.getString("STOPLIGHT.UNACCEPTABLE"));
        _mainPanel.add((Component)_unacceptLabel, c);
        c.gridx = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        this.m_unacceptTextField = new NumberTextField();
        this.m_unacceptTextField.setName("UnacceptableData");
        this.m_unacceptTextField.setDataType(Double.class);
        this.m_unacceptTextField.setSigned(true);
        this.m_unacceptTextField.setHorizontalAlignment(4);
        this.m_unacceptTextField.setDecimal(true);
        this.m_unacceptTextField.addKeyListener((KeyListener)this);
        _unacceptLabel.setLabelFor((Component)this.m_unacceptTextField);
        if (gridView.getLocale() != null) {
            this.m_unacceptTextField.setLocale(gridView.getLocale());
        }
        _mainPanel.add((Component)this.m_unacceptTextField, c);
        c.gridx = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        String tooltiptext = this.m_bundle.getString("STOPLIGHT.COLORPALETTETOOLTIP");
        this.m_unacceptColor = new ColorPanel(this.m_badColor, StringUtils.stripMnemonic((String)this.m_bundle.getString("STOPLIGHT.UNACCEPTABLE")), tooltiptext);
        _mainPanel.add((Component)this.m_unacceptColor, c);
        c.gridx = 0;
        c.gridy = 10;
        c.gridwidth = 1;
        JLabel _acceptLabel = new JLabel();
        this.setLabelText(_acceptLabel, this.m_bundle.getString("STOPLIGHT.ACCEPTABLE"));
        _mainPanel.add((Component)_acceptLabel, c);
        c.gridx = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        this.m_acceptTextField = new JLabel(this.m_bundle.getString("STOPLIGHT.BETWEENINIT"));
        this.m_acceptTextField.setHorizontalAlignment(4);
        _acceptLabel.setLabelFor(this.m_acceptTextField);
        _mainPanel.add((Component)this.m_acceptTextField, c);
        c.gridx = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.m_acceptColor = new ColorPanel(this.m_warningColor, StringUtils.stripMnemonic((String)this.m_bundle.getString("STOPLIGHT.ACCEPTABLE")), tooltiptext);
        _mainPanel.add((Component)this.m_acceptColor, c);
        c.gridx = 0;
        c.gridy = 11;
        c.gridwidth = 1;
        JLabel _desireLabel = new JLabel();
        this.setLabelText(_desireLabel, this.m_bundle.getString("STOPLIGHT.DESIRABLE"));
        _mainPanel.add((Component)_desireLabel, c);
        c.gridx = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        this.m_desireTextField = new NumberTextField();
        this.m_desireTextField.setName("DesirableData");
        this.m_desireTextField.setHorizontalAlignment(4);
        this.m_desireTextField.setSigned(true);
        this.m_desireTextField.setDataType(Double.class);
        this.m_desireTextField.setDecimal(true);
        this.m_desireTextField.addKeyListener((KeyListener)this);
        _desireLabel.setLabelFor((Component)this.m_desireTextField);
        if (gridView.getLocale() != null) {
            this.m_desireTextField.setLocale(gridView.getLocale());
        }
        _mainPanel.add((Component)this.m_desireTextField, c);
        c.gridx = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.m_desireColor = new ColorPanel(this.m_goodColor, StringUtils.stripMnemonic((String)this.m_bundle.getString("STOPLIGHT.DESIRABLE")), tooltiptext);
        _mainPanel.add((Component)this.m_desireColor, c);
        c.gridx = 4;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.m_editButton = new JButton();
        this.m_editButton.setName("EditColors");
        this.m_editButton.setActionCommand("EDITCOLORS");
        this.m_editButton.addActionListener(this);
        this.setButtonText(this.m_editButton, this.m_bundle.getString("STOPLIGHT.EDITCOLOR"));
        _mainPanel.add((Component)this.m_editButton, c);
        c.gridx = 0;
        c.gridy = 12;
        c.gridwidth = 1;
        JLabel _descLabel = new JLabel();
        this.setLabelText(_descLabel, this.m_bundle.getString("STOPLIGHT.DESCRIPTION"));
        _mainPanel.add((Component)_descLabel, c);
        this.m_descTextPanel = new DescriptionTextPanel(this.m_bundle.getString("STOPLIGHT.UNACCEPT"), this.m_bundle.getString("STOPLIGHT.DESIRE"), this.m_bundle.getString("STOPLIGHT.ACCEPT"));
        this.m_descColorPanel = new DescriptionColorPanel(this.m_unacceptColor.getColor(), this.m_acceptColor.getColor(), this.m_desireColor.getColor());
        c.gridx = 0;
        c.gridy = 13;
        c.gridwidth = 7;
        c.gridheight = 2;
        c.weightx = 1.0;
        JPanel _descPanel = new JPanel();
        _descPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        _descPanel.setLayout(new GridLayout(3, 1));
        _descPanel.add(this.m_descTextPanel);
        _descPanel.add(this.m_descColorPanel);
        _descPanel.add(Box.createVerticalStrut(1));
        _mainPanel.add((Component)_descPanel, c);
        c.gridy = 14;
        c.weighty = 1.0;
        c.fill = 1;
        _mainPanel.add(Box.createVerticalGlue(), c);
        this.setLayout(new BorderLayout());
        this.add((Component)_mainPanel, "Center");
        this.m_unacceptTextField.setPreferredSize(new Dimension(this.m_acceptTextField.getPreferredSize().width, this.m_unacceptTextField.getPreferredSize().height));
        this.m_desireTextField.setPreferredSize(new Dimension(this.m_acceptTextField.getPreferredSize().width, this.m_desireTextField.getPreferredSize().height));
        if (this.m_uiFormat != null) {
            this.m_editMode = true;
            if (this.m_uiFormat.getDiscriminator() != null) {
                Discriminator disc = this.m_uiFormat.getDiscriminator();
                if (disc instanceof CompositeDiscriminator && ((CompositeDiscriminator)disc).getCondOperator() == 0) {
                    disc = ((CompositeDiscriminator)disc).getRight();
                }
                if (disc instanceof CompositeDiscriminator && ((CompositeDiscriminator)disc).getCondOperator() == 0) {
                    disc = ((CompositeDiscriminator)disc).getLeft();
                }
                if (disc != null && disc instanceof QDRDiscriminator) {
                    this.m_cellsButton.setEnabled(true);
                    QDR qdr = ((QDRDiscriminator)disc).getQDR();
                    if (qdr != null) {
                        if (qdr.size() == 0) {
                            this.m_measureBox.setSelectedIndex(0);
                        } else if (qdr.size() == 1 && qdr.getDimMember(this.m_measureDim) != null) {
                            this.m_measureBox.setSelectedIndex(this.m_measureVector.indexOf(qdr.getDimMember(this.m_measureDim).getData().toString()) + 2);
                        } else {
                            this.m_measureBox.setSelectedIndex(1);
                        }
                    }
                } else {
                    this.m_cellsButton.setEnabled(false);
                }
            } else {
                this.m_measureBox.setSelectedIndex(0);
                this.m_cellsButton.setEnabled(true);
            }
            if (this.m_uiFormat.getValueCondition() != null) {
                Double val = (Double)this.m_uiFormat.getValueCondition().getGoodThreshold();
                this.m_desireTextField.setText(this.m_numberFormat.format(val));
                val = (Double)this.m_uiFormat.getValueCondition().getBadThreshold();
                this.m_unacceptTextField.setText(this.m_numberFormat.format(val));
                this.updateAcceptTextField();
                this.m_descTextPanel.setUnacceptable(this.m_unacceptTextField.getText(), this.m_unacceptTextField.getNumber());
                this.m_descTextPanel.setDesirable(this.m_desireTextField.getText(), this.m_desireTextField.getNumber());
            }
        } else {
            this.m_editMode = false;
            this.m_uiFormat = gridView.getFormatModel().createStoplightFormat();
            this.m_cellsButton.setEnabled(true);
            if (this.m_measureBox.getItemCount() > 2) {
                this.m_measureBox.setSelectedIndex(2);
                QDRDiscriminator qdrDisc = new QDRDiscriminator(new QDR(this.m_measureDim, this.m_measureDim, this.m_measureVector.elementAt(this.m_measureBox.getSelectedIndex() - 2).toString()), 4);
                this.m_uiFormat.setDiscriminator((Discriminator)qdrDisc);
            }
        }
        this.m_formatTextField.setText(this.m_uiFormat.getName());
        this.m_measureBox.addItemListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (this.m_measureBox.getSelectedIndex() > 1) {
            QDRDiscriminator qdrDisc = new QDRDiscriminator(new QDR(this.m_measureDim, this.m_measureDim, this.m_measureVector.elementAt(this.m_measureBox.getSelectedIndex() - 2).toString()), 4);
            this.m_uiFormat.setDiscriminator((Discriminator)qdrDisc);
        } else if (this.m_measureBox.getSelectedIndex() == 0 || this.m_uiFormat.getDiscriminator() == null) {
            QDRDiscriminator qdrDisc = new QDRDiscriminator(new QDR(this.m_measureDim), 4);
            this.m_uiFormat.setDiscriminator((Discriminator)qdrDisc);
        } else {
            this.m_uiFormat.setDiscriminator(this.m_selectionDisc);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof JButton) {
            String _cmd = evt.getActionCommand();
            if ("EDITCOLORS".equals(_cmd)) {
                StoplightColorDialog _dialog = new StoplightColorDialog(this.m_parent, this.m_gridView, this.m_unacceptColor.getColor(), this.m_acceptColor.getColor(), this.m_desireColor.getColor());
                _dialog.setHelpProvider(this.m_helpProvider);
                boolean _flag = _dialog.runDialog();
                if (_flag) {
                    this.m_unacceptColor.setColor(_dialog.getUnacceptableColor());
                    this.m_acceptColor.setColor(_dialog.getAcceptableColor());
                    this.m_desireColor.setColor(_dialog.getDesirableColor());
                    this.m_descColorPanel.setUnacceptColor(_dialog.getUnacceptableColor());
                    this.m_descColorPanel.setAcceptColor(_dialog.getAcceptableColor());
                    this.m_descColorPanel.setDesireColor(_dialog.getDesirableColor());
                }
            } else if ("SPECIFYCELLS".equals(_cmd)) {
                RulesPanel _panel = this.m_formatsPanel.getStoplightRulesPanel(this.m_gridView, this.m_uiFormat.getDiscriminator());
                _panel.hideValueCondition();
                _panel.setHelpProvider(this.m_helpProvider);
                String _title = this.m_bundle.getString("STOPLIGHT.SPECIFYCELLSTITLE");
                StoplightCellsDialog _dialog = new StoplightCellsDialog(this.m_parent, _title, 7);
                _dialog.setResizable(true);
                _dialog.setContent(_panel);
                _dialog.setHelpProvider(this.m_helpProvider);
                boolean _flag = _dialog.runDialog();
                if (_flag) {
                    Discriminator disc = _panel.getDiscriminator();
                    this.m_uiFormat.setDiscriminator(disc);
                    QDR qdr = ((QDRDiscriminator)disc).getQDR();
                    if (qdr != null) {
                        if (qdr.size() == 0) {
                            this.m_measureBox.setSelectedIndex(0);
                        } else if (qdr.size() == 1 && qdr.getDimMember(this.m_measureDim) != null && qdr.getDimMember(this.m_measureDim).getType() == 0) {
                            this.m_measureBox.setSelectedIndex(this.m_measureVector.indexOf(qdr.getDimMember(this.m_measureDim).getData().toString()) + 2);
                        } else {
                            this.m_selectionDisc = disc;
                            this.m_measureBox.setSelectedIndex(1);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent evt) {
        Object _src = evt.getSource();
        if (_src == this.m_unacceptTextField) {
            String _unacceptText = this.m_unacceptTextField.getText();
            Number _unacceptNum = this.m_unacceptTextField.getNumber();
            this.updateAcceptTextField();
            this.m_descTextPanel.setUnacceptable(_unacceptText, _unacceptNum);
            this.m_descTextPanel.getParent().validate();
            this.m_descTextPanel.getParent().repaint();
        } else if (_src == this.m_desireTextField) {
            String _desireText = this.m_desireTextField.getText();
            Number _desireNum = this.m_desireTextField.getNumber();
            this.updateAcceptTextField();
            this.m_descTextPanel.setDesirable(_desireText, _desireNum);
            this.m_descTextPanel.getParent().validate();
            this.m_descTextPanel.getParent().repaint();
        }
    }

    private void updateAcceptTextField() {
        String _desireText;
        String _unacceptText = this.m_unacceptTextField.getText();
        if (_unacceptText.equals(_desireText = this.m_desireTextField.getText())) {
            this.m_acceptTextField.setVisible(false);
        } else {
            int _req;
            Number _unacceptNum = null;
            Number _desireNum = null;
            if (!this.m_acceptTextField.isVisible()) {
                this.m_acceptTextField.setVisible(true);
            }
            if (_unacceptText.equals("")) {
                _unacceptText = this.m_bundle.getString("STOPLIGHT.UNACCEPT");
            } else {
                _unacceptNum = this.m_unacceptTextField.getNumber();
            }
            if (_desireText.equals("")) {
                _desireText = this.m_bundle.getString("STOPLIGHT.DESIRE");
            } else {
                _desireNum = this.m_desireTextField.getNumber();
            }
            if (_unacceptNum != null && _desireNum != null && _unacceptNum.doubleValue() > _desireNum.doubleValue()) {
                String _temp = _unacceptText;
                _unacceptText = _desireText;
                _desireText = _temp;
            }
            String _text = MessageFormat.format(this.m_bundle.getString("STOPLIGHT.BETWEEN"), _unacceptText, _desireText);
            this.m_acceptTextField.setToolTipText(_text);
            int _width = this.m_acceptTextField.getWidth();
            if (_width == 0) {
                _width = SwingUtilities.computeStringWidth(this.m_acceptTextField.getFontMetrics(this.m_acceptTextField.getFont()), this.m_acceptTextField.getText());
            }
            if (_width < (_req = SwingUtilities.computeStringWidth(this.m_acceptTextField.getFontMetrics(this.m_acceptTextField.getFont()), _text))) {
                int _per;
                _text = _unacceptText + " - " + _desireText;
                _req = SwingUtilities.computeStringWidth(this.m_acceptTextField.getFontMetrics(this.m_acceptTextField.getFont()), _text);
                if (_width < _req && (_per = _width / (_req / _text.length())) > 3) {
                    _text = _text.substring(0, _per - 3) + "...";
                }
            }
            this.m_acceptTextField.setText(_text);
        }
        this.m_acceptTextField.validate();
    }

    @Override
    public void keyPressed(KeyEvent evt) {
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }

    private void setButtonText(AbstractButton button, String text) {
        button.setText(StringUtils.stripMnemonic((String)text));
        button.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
    }

    private void setLabelText(JLabel label, String text) {
        int _index = StringUtils.getMnemonicIndex((String)text);
        String _text = StringUtils.stripMnemonic((String)text);
        if (_index > -1) {
            char _char = text.charAt(_index + 1);
            label.setDisplayedMnemonic(_char);
        }
        label.setText(_text);
    }

    private DefaultComboBoxModel createModel() {
        DefaultComboBoxModel<String> _model;
        block10: {
            block9: {
                _model = new DefaultComboBoxModel<String>();
                _model.addElement(this.m_bundle.getString("STOPLIGHT.ALLDATA"));
                _model.addElement(this.m_bundle.getString("STOPLIGHT.SELECTED"));
                try {
                    QDR qdr = this.m_gridView.getModel().getDataAccess().getValueQDR(0, 0, 0);
                    if (qdr != null) {
                        this.m_measureDim = qdr.getMeasureDim();
                    }
                    if (this.m_measureDim != null && this.m_measureDim.equals("")) {
                        this.m_measureDim = null;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.m_gridView.getViewType() != 0) break block9;
                if (this.m_measureDim == null) break block10;
                this.m_measureVector = this.getDimMembers(this.m_measureDim, "value");
                Vector measures = this.getDimMembers(this.m_measureDim, "shortName");
                if (measures == null) break block10;
                for (int i = 0; i < measures.size(); ++i) {
                    String _measure = measures.elementAt(i).toString();
                    if (_measure == null) continue;
                    _model.addElement(_measure);
                }
                break block10;
            }
            if (this.m_gridView.getDataSource() instanceof LayoutContext) {
                LayoutAccess access = ((LayoutContext)this.m_gridView.getDataSource()).createLayoutAccess();
                String[] measures = access.getMeasures("value");
                String[] measureLabels = access.getMeasures("shortName");
                this.m_measureVector = new Vector();
                for (int i = 0; i < measures.length; ++i) {
                    _model.addElement(measureLabels[i]);
                    this.m_measureVector.add(measures[i]);
                }
            } else {
                List list = GridViewFormatUtils.getMeasures(this.m_gridView.getModel().getDataAccess(), "value");
                List list1 = GridViewFormatUtils.getMeasures(this.m_gridView.getModel().getDataAccess(), "shortName");
                this.m_measureVector = new Vector();
                for (int i = 0; i < list.size(); ++i) {
                    _model.addElement((String)list.get(i));
                    this.m_measureVector.add(list1.get(i));
                }
            }
        }
        return _model;
    }

    protected Vector getDimMembers(String dimension, String type) {
        if (dimension == null) {
            return null;
        }
        try {
            Vector<Object> members = new Vector<Object>();
            DataAccess dataAccess = this.m_gridView.getModel().getDataAccess();
            List list = dataAccess.getUniqueMemberMetadata(dimension, new String[]{type}, 0, -1);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i) == null || ((Object[])list.get(i)).length <= 0) continue;
                    members.addElement(((Object[])list.get(i))[0]);
                }
                return members;
            }
            for (int i = 0; i < dataAccess.getEdgeCount(); ++i) {
                int layerCount = dataAccess.getLayerCount(i);
                int endslice = dataAccess.getEdgeExtent(i);
                for (int j = 0; j < layerCount; ++j) {
                    Object dimObj = dataAccess.getLayerMetadata(i, j, "layerName");
                    String dim = null;
                    if (dimObj != null) {
                        dim = dimObj.toString();
                    }
                    if (dim == null || !dimension.equals(dim)) continue;
                    for (int startslice = 0; startslice != endslice; startslice += dataAccess.getMemberExtent(i, j, startslice)) {
                        if (dataAccess.getMemberStartLayer(i, j, startslice) != j) continue;
                        Object objValue = dataAccess.getMemberMetadata(i, j, startslice, type);
                        String value = null;
                        if (objValue != null) {
                            value = objValue.toString();
                        }
                        if (value == null || members.indexOf(value) != -1) continue;
                        members.addElement(value);
                    }
                }
            }
            if (members.size() > 0) {
                return members;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected void setFormatsPanel(FormatsPanel panel) {
        this.m_formatsPanel = panel;
        this.m_selectionDisc = this.m_formatsPanel.getSelectionDisc();
    }

    public void cleanup() {
    }

    private void updateResourceBundle(Locale loc) {
        this.m_bundle = loc != null ? ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle");
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
        this.m_numberFormat = loc != null ? NumberFormat.getInstance(loc) : NumberFormat.getInstance();
        this.m_numberFormat.setGroupingUsed(false);
        if (this.m_acceptTextField != null) {
            this.m_acceptTextField.setLocale(loc);
            this.m_desireTextField.setLocale(loc);
            this.m_unacceptTextField.setLocale(loc);
        }
    }

    public String getUnacceptableThreshold() {
        return this.m_unacceptTextField.getText();
    }

    public String getDesirableThreshold() {
        return this.m_desireTextField.getText();
    }

    void setDesirableGreaterThanThreshold(boolean flag) {
        this.m_uiFormat.setDesirableGreaterThanThreshold(flag);
    }

    public Color getUnacceptableColor() {
        return this.m_unacceptColor.getColor();
    }

    public Color getAcceptableColor() {
        return this.m_acceptColor.getColor();
    }

    public Color getDesirableColor() {
        return this.m_desireColor.getColor();
    }

    public UIFormat getUIFormat() {
        this.m_uiFormat.setName(this.m_formatTextField.getText());
        if (this.m_unacceptTextField.getText().equals("+") || this.m_unacceptTextField.getText().equals("-")) {
            this.m_unacceptTextField.setText("0");
        }
        if (this.m_desireTextField.getText().equals("+") || this.m_desireTextField.getText().equals("-")) {
            this.m_desireTextField.setText("0");
        }
        if (this.m_unacceptTextField.getText() != null && this.m_unacceptTextField.getText().startsWith("+")) {
            this.m_unacceptTextField.setText(this.m_unacceptTextField.getText().substring(1, this.m_unacceptTextField.getText().length()));
        }
        if (this.m_desireTextField.getText() != null && this.m_desireTextField.getText().startsWith("+")) {
            this.m_desireTextField.setText(this.m_desireTextField.getText().substring(1, this.m_desireTextField.getText().length()));
        }
        if (this.m_gridView.getFormatModel().isValidNumber(this.m_unacceptTextField.getText()) && this.m_gridView.getFormatModel().isValidNumber(this.m_desireTextField.getText())) {
            this.m_uiFormat.getValueCondition().setBadThreshold(this.m_unacceptTextField.getNumber());
            this.m_uiFormat.getValueCondition().setGoodThreshold(this.m_desireTextField.getNumber());
        } else if (this.m_gridView.getFormatModel().isValidDate(this.m_unacceptTextField.getText()) && this.m_gridView.getFormatModel().isValidDate(this.m_desireTextField.getText())) {
            this.m_uiFormat.getValueCondition().setBadThreshold(this.m_gridView.getFormatModel().toDate(this.m_unacceptTextField.getText()));
            this.m_uiFormat.getValueCondition().setGoodThreshold(this.m_gridView.getFormatModel().toDate(this.m_desireTextField.getText()));
        }
        return this.m_uiFormat;
    }

    public boolean apply() {
        if (this.m_formatTextField.getText().equals("")) {
            return false;
        }
        String _badValue = this.m_unacceptTextField.getText();
        String _goodValue = this.m_desireTextField.getText();
        if (_badValue != null && _badValue.startsWith("+")) {
            _badValue = _badValue.substring(1, _badValue.length());
        }
        if (_goodValue != null && _goodValue.startsWith("+")) {
            _goodValue = _goodValue.substring(1, _goodValue.length());
        }
        if ((_badValue == null || _badValue.equals("")) && (_goodValue == null || _goodValue.equals(""))) {
            JOptionPane.showMessageDialog(this.m_parent, this.m_bundle.getString("STOPLIGHT.MISSINGVALUE") + "\n\n" + this.m_bundle.getString("STOPLIGHT.MISSINGVALUEU") + "\n" + this.m_bundle.getString("STOPLIGHT.MISSINGVALUED"), this.m_bundle.getString("STOPLIGHT.MISSINGTITLE"), 0, this.getStopIcon());
            this.m_unacceptTextField.requestFocus();
            return false;
        }
        if (_badValue == null || _badValue.equals("")) {
            JOptionPane.showMessageDialog(this.m_parent, this.m_bundle.getString("STOPLIGHT.MISSINGVALUE") + "\n\n" + this.m_bundle.getString("STOPLIGHT.MISSINGVALUEU"), this.m_bundle.getString("STOPLIGHT.MISSINGTITLE"), 0, this.getStopIcon());
            this.m_unacceptTextField.requestFocus();
            return false;
        }
        if (_goodValue == null || _goodValue.equals("")) {
            JOptionPane.showMessageDialog(this.m_parent, this.m_bundle.getString("STOPLIGHT.MISSINGVALUE") + "\n\n" + this.m_bundle.getString("STOPLIGHT.MISSINGVALUED"), this.m_bundle.getString("STOPLIGHT.MISSINGTITLE"), 0, this.getStopIcon());
            this.m_desireTextField.requestFocus();
            return false;
        }
        return true;
    }

    public void applyStoplightFormat() {
        this.m_gridView.setBadColor(GridViewFormatUtils.getColorValue(this.m_unacceptColor.getColor()));
        this.m_gridView.setWarningColor(GridViewFormatUtils.getColorValue(this.m_acceptColor.getColor()));
        this.m_gridView.setGoodColor(GridViewFormatUtils.getColorValue(this.m_desireColor.getColor()));
        this.m_uiFormat.setName(this.m_formatTextField.getText());
        String _badValue = this.m_unacceptTextField.getText();
        String _goodValue = this.m_desireTextField.getText();
        if (_badValue != null && _badValue.startsWith("+")) {
            _badValue = _badValue.substring(1, _badValue.length());
        }
        if (_goodValue != null && _goodValue.startsWith("+")) {
            _goodValue = _goodValue.substring(1, _goodValue.length());
        }
        if (this.m_measureBox.getSelectedIndex() > 1) {
            String _measID = this.m_measureVector.elementAt(this.m_measureBox.getSelectedIndex() - 2).toString();
            GridViewFormatUtils.applyStoplightFormat((GridViewCommon)this.m_gridView, this.m_uiFormat, _badValue, _goodValue, _measID);
        } else if (this.m_measureBox.getSelectedIndex() == 0) {
            GridViewFormatUtils.applyStoplightFormat((GridViewCommon)this.m_gridView, this.m_uiFormat, _badValue, _goodValue, null);
        } else if (this.m_measureBox.getSelectedIndex() == 1) {
            GridViewFormatUtils.applyStoplightFormat((GridViewCommon)this.m_gridView, this.m_uiFormat, _badValue, _goodValue, true);
        }
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    private ImageIcon getStopIcon() {
        if (this.m_stopIcon == null) {
            this.m_stopIcon = new ImageIcon(ImageUtils.getImageResource(StoplightPanel.class, (String)"images/stop.gif"));
        }
        return this.m_stopIcon;
    }

    class StoplightCellsDialog
    extends JEWTDialog
    implements HelpContext {
        private static final long serialVersionUID = 1L;
        private String m_strHelpContextID;

        public StoplightCellsDialog(Dialog m_parent, String _title, int defaultButton) {
            super(m_parent, _title, defaultButton);
        }

        public String getHelpContextID() {
            return ((Object)((Object)this)).getClass().getName();
        }

        public void setHelpContextID(String strHelpContextID) {
            this.m_strHelpContextID = strHelpContextID;
            HelpUtils.setHelpID((JComponent)((JComponent)this.getContent()), (String)this.getHelpContextID());
        }

        public void setHelpProvider(HelpProvider helpProvider) {
            StoplightPanel.this.m_helpProvider = helpProvider;
            HelpUtils.setHelpProvider((JComponent)((JComponent)this.getContent()), (HelpProvider)StoplightPanel.this.m_helpProvider);
        }

        public HelpProvider getHelpProvider() {
            return StoplightPanel.this.m_helpProvider;
        }
    }

    class ColorPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private Color m_color;
        private String m_text;
        private String m_tooltiptext;

        public ColorPanel(Color color, String text, String tooltiptext) {
            this.m_color = color;
            this.m_text = text;
            this.m_tooltiptext = tooltiptext;
            this.setPreferredSize(new Dimension(20, 20));
            this.setMinimumSize(new Dimension(20, 20));
            this.setMaximumSize(new Dimension(20, 20));
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public void setColor(Color color) {
            this.m_color = color;
            this.repaint();
        }

        public Color getColor() {
            return this.m_color;
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            MessageFormat messageformat = new MessageFormat(this.m_tooltiptext);
            Object[] aobj = new Object[]{IntegerUtils.getInteger((int)this.m_color.getRed()), IntegerUtils.getInteger((int)this.m_color.getGreen()), IntegerUtils.getInteger((int)this.m_color.getBlue())};
            String s1 = messageformat.format(aobj);
            return this.m_text + " " + s1;
        }

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(Color.black);
            g.drawRect(0, 0, 19, 19);
            g.setColor(this.m_color);
            g.fillRect(1, 1, 18, 18);
        }
    }

    class DescriptionColorPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private Color m_unacceptColor;
        private Color m_acceptColor;
        private Color m_desireColor;

        public DescriptionColorPanel(Color unaccept, Color accept, Color desire) {
            this.m_unacceptColor = unaccept;
            this.m_acceptColor = accept;
            this.m_desireColor = desire;
        }

        public void setUnacceptColor(Color color) {
            this.m_unacceptColor = color;
        }

        public void setAcceptColor(Color color) {
            this.m_acceptColor = color;
        }

        public void setDesireColor(Color color) {
            this.m_desireColor = color;
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            int _width = (int)(this.getSize().getWidth() - 20.0) / 4;
            g.setColor(Color.black);
            g.drawRect(9, 3, _width * 4 + 2, 6);
            if (StoplightPanel.this.m_acceptTextField.isVisible()) {
                g.setColor(this.m_unacceptColor);
                g.fillRect(10, 4, _width, 5);
                g.setColor(this.m_acceptColor);
                g.fillRect(10 + _width, 4, _width * 2, 5);
                g.setColor(this.m_desireColor);
                g.fillRect(10 + _width * 3, 4, _width + 2, 5);
                g.setColor(Color.black);
                g.drawLine(9, 1, 9, 9);
                g.drawLine(10 + _width, 1, 10 + _width, 9);
                g.drawLine(10 + _width * 3, 1, 10 + _width * 3, 9);
                g.drawLine(11 + _width * 4, 1, 11 + _width * 4, 9);
            } else {
                g.setColor(this.m_unacceptColor);
                g.fillRect(10, 4, _width * 2 + 1, 5);
                g.setColor(this.m_desireColor);
                g.fillRect(10 + (_width * 2 + 1), 4, _width * 2 + 1, 5);
                g.setColor(Color.black);
                g.drawLine(9, 1, 9, 9);
                g.drawLine(10 + _width * 2, 1, 10 + _width * 2, 9);
                g.drawLine(11 + _width * 4, 1, 11 + _width * 4, 9);
            }
        }
    }

    class DescriptionTextPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private String m_defUnacceptText;
        private String m_defDesireText;
        private String m_unacceptText;
        private String m_desireText;
        private Number m_unacceptNum;
        private Number m_desireNum;
        private String m_acceptText;
        private boolean m_default = true;

        public DescriptionTextPanel(String unaccept, String desire, String accept) {
            this.m_defUnacceptText = unaccept;
            this.m_defDesireText = desire;
            this.m_unacceptText = unaccept;
            this.m_desireText = desire;
            this.m_acceptText = accept;
            this.m_default = true;
        }

        public void setUnacceptable(String text, Number num) {
            if (text == null || text.equals("")) {
                this.m_unacceptText = this.m_defUnacceptText;
                this.m_default = true;
            } else {
                this.m_unacceptText = text;
                if (!this.m_desireText.equals(this.m_defDesireText)) {
                    this.m_default = false;
                }
            }
            this.m_unacceptNum = num;
        }

        public void setDesirable(String text, Number num) {
            if (text == null || text.equals("")) {
                this.m_desireText = this.m_defDesireText;
                this.m_default = true;
            } else {
                this.m_desireText = text;
                if (!this.m_unacceptText.equals(this.m_defUnacceptText)) {
                    this.m_default = false;
                }
            }
            this.m_desireNum = num;
        }

        @Override
        public int getHeight() {
            return this.getFontMetrics(this.getFont()).getHeight();
        }

        @Override
        public void paintComponent(Graphics g) {
            int _per;
            int _req;
            int _width;
            String _unacceptText = this.m_unacceptText;
            String _acceptText = this.m_acceptText;
            String _desireText = this.m_desireText;
            if (!this.m_default) {
                if (this.m_unacceptNum != null && this.m_desireNum != null && this.m_unacceptNum.doubleValue() > this.m_desireNum.doubleValue()) {
                    _unacceptText = ">=" + this.m_unacceptText;
                    _acceptText = MessageFormat.format(StoplightPanel.this.m_bundle.getString("STOPLIGHT.BETWEEN"), this.m_desireText, this.m_unacceptText);
                    _desireText = "<=" + this.m_desireText;
                } else {
                    _unacceptText = "<=" + this.m_unacceptText;
                    _acceptText = MessageFormat.format(StoplightPanel.this.m_bundle.getString("STOPLIGHT.BETWEEN"), this.m_unacceptText, this.m_desireText);
                    _desireText = ">=" + this.m_desireText;
                }
                if (this.m_unacceptNum != null && this.m_desireNum != null && this.m_unacceptNum.doubleValue() == this.m_desireNum.doubleValue()) {
                    if (StoplightPanel.this.m_uiFormat.isDesirableGreaterThanThreshold()) {
                        _unacceptText = ">=" + this.m_unacceptText;
                        _acceptText = "";
                        _desireText = "<" + this.m_desireText;
                    } else {
                        _unacceptText = ">" + this.m_unacceptText;
                        _acceptText = "";
                        _desireText = "<=" + this.m_desireText;
                    }
                }
            }
            if ((_width = (int)(this.getSize().getWidth() - 20.0) / 4) < (_req = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), _unacceptText)) && (_per = _width / (_req / _unacceptText.length())) > 3) {
                _unacceptText = _unacceptText.substring(0, _per - 3) + "...";
            }
            if (_width * 2 < (_req = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), _acceptText))) {
                _acceptText = this.m_unacceptNum != null && this.m_desireNum != null && this.m_unacceptNum.doubleValue() > this.m_desireNum.doubleValue() ? this.m_desireText + " - " + this.m_unacceptText : this.m_unacceptText + " - " + this.m_desireText;
                _req = SwingUtilities.computeStringWidth(StoplightPanel.this.m_acceptTextField.getFontMetrics(this.getFont()), _acceptText);
                if (_width * 2 < _req && (_per = _width * 2 / (_req / _acceptText.length())) > 3) {
                    _acceptText = _acceptText.substring(0, _per - 3) + "...";
                }
            }
            if (_width < (_req = SwingUtilities.computeStringWidth(this.getFontMetrics(this.getFont()), _desireText)) && (_per = _width / (_req / _desireText.length())) > 3) {
                _desireText = _desireText.substring(0, _per - 3) + "...";
            }
            g.setColor(Color.black);
            int _unacceptTextWidth = this.getFontMetrics(this.getFont()).stringWidth(_unacceptText);
            int _acceptTextWidth = this.getFontMetrics(this.getFont()).stringWidth(_acceptText);
            int _desireTextWidth = this.getFontMetrics(this.getFont()).stringWidth(_desireText);
            if (StoplightPanel.this.m_acceptTextField.isVisible()) {
                if (_unacceptTextWidth < _width) {
                    g.drawString(_unacceptText, 10 + (_width - _unacceptTextWidth) / 2, 10);
                } else {
                    g.drawString(_unacceptText, 10, 10);
                }
                if (_acceptTextWidth < _width * 2) {
                    g.drawString(_acceptText, 10 + _width + (_width * 2 - _acceptTextWidth) / 2, 10);
                } else {
                    g.drawString(_acceptText, 10 + _width, 10);
                }
                if (_desireTextWidth < _width + 1) {
                    g.drawString(_desireText, 10 + _width * 3 + (_width + 1 - _desireTextWidth) / 2, 10);
                } else {
                    g.drawString(_desireText, 10 + _width * 3, 10);
                }
            } else {
                if (_unacceptTextWidth < _width * 2 + 1) {
                    g.drawString(_unacceptText, 10 + (_width * 2 + 1 - _unacceptTextWidth) / 2, 10);
                } else {
                    g.drawString(_unacceptText, 10, 10);
                }
                if (_desireTextWidth < _width * 2 + 1) {
                    g.drawString(_desireText, 10 + (_width * 2 + 1) + (_width * 2 + 1 - _desireTextWidth) / 2, 10);
                } else {
                    g.drawString(_desireText, 10 + (_width * 2 + 1), 10);
                }
            }
        }
    }
}

