/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.UIGridView;
import oracle.dss.gridView.gui.LineWidthIncludingNoneForHeader;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.gui.BIColorChoice;
import oracle.dss.util.gui.FontButton;
import oracle.dss.util.help.HelpContext;

public class HeaderFormatGeneralPanel
extends JPanel
implements ItemListener,
PropertyChangeListener,
HelpContext {
    private static final long serialVersionUID = 1L;
    private ResourceBundle rBundle = null;
    private boolean isSetFocus = true;
    private String m_applicationName;
    private JLabel m_formatNameLabel;
    private JTextField m_formatNameTextField;
    private BIColorChoice m_backgroundColorChoice;
    private BIColorChoice m_outlineColorChoice;
    private LineWidthIncludingNoneForHeader m_outlineWidth;
    private JLabel m_outlineLabel;
    private BIColorChoice m_leftColorChoice;
    private LineWidthIncludingNoneForHeader m_leftWidth;
    private JLabel m_leftLabel;
    private BIColorChoice m_rightColorChoice;
    private LineWidthIncludingNoneForHeader m_rightWidth;
    private JLabel m_rightLabel;
    private BIColorChoice m_topColorChoice;
    private LineWidthIncludingNoneForHeader m_topWidth;
    private JLabel m_topLabel;
    private BIColorChoice m_bottomColorChoice;
    private LineWidthIncludingNoneForHeader m_bottomWidth;
    private JLabel m_bottomLabel;
    private JLabel m_backgroundColorLabel;
    private JLabel m_dataBarColorLabel;
    private JPanel m_backgroundPanel;
    private JPanel m_bordersPanel;
    private int oldOutlineWidth = -1;
    private int oldLeftLineWidth = -1;
    private int oldRightLineWidth = -1;
    private int oldTopLineWidth = -1;
    private int oldBottomLineWidth = -1;
    private boolean m_outlineWidthChanged = false;
    private boolean m_leftLineWidthChanged = false;
    private boolean m_rightLineWidthChanged = false;
    private boolean m_topLineWidthChanged = false;
    private boolean m_bottomLineWidthChanged = false;
    private UIGridView m_gridView;
    private boolean _flag = true;
    private ViewStyle m_gridViewStyle = null;
    private Locale m_locale = null;
    private JPanel backgroundColorPanel;
    private JPanel bordersOutlinePanel;
    private JPanel bordersLeftAndTopPanel;
    private JPanel bordersRightAndBottomPanel;
    private boolean m_bSuperCalled = true;
    private boolean _flag1 = true;
    private boolean m_backgroundColorChoiceChanged = false;
    private int panelWidth;
    private JPanel formatNamePanel;
    protected boolean m_bHelpEnabled;
    protected ErrorHandler m_eh = null;
    protected String m_strHelpContextID;
    public static final String PROPERTY_BACKGROUND_COLOR = "BackgroundColor";
    public static final String PROPERTY_HEADER_DIMENSION = "HeaderDimension";
    public static final String PROPERTY_OUTLINE_WIDTH = "OutLineWidth";
    public static final String PROPERTY_OUTLINE_COLOR = "OutlineColor";
    public static final String PROPERTY_LEFT_LINE_WIDTH = "LeftLineWidth";
    public static final String PROPERTY_LEFT_LINE_COLOR = "LeftLineColor";
    public static final String PROPERTY_TOP_LINE_WIDTH = "TopLineWidth";
    public static final String PROPERTY_TOP_LINE_COLOR = "TopLineColor";
    public static final String PROPERTY_RIGHT_LINE_WIDTH = "RightLineWidth";
    public static final String PROPERTY_RIGHT_LINE_COLOR = "RightLineColor";
    public static final String PROPERTY_BOTTOM_LINE_WIDTH = "BottomLineWidth";
    public static final String PROPERTY_BOTTOM_LINE_COLOR = "BottomLineColor";

    public HeaderFormatGeneralPanel(ViewStyle gridViewStyle, UIGridView gridView) {
        this.m_gridView = gridView;
        this.setLocale(null);
        this._initialize(gridViewStyle);
    }

    public HeaderFormatGeneralPanel(ViewStyle gridViewStyle, UIGridView gridView, boolean isDefault) {
        this.m_gridView = gridView;
        this.setLocale(null);
        this._initialize(gridViewStyle);
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.m_eh = eh;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }

    public void setCustomColorsEnabled(boolean enabled) {
        this.m_backgroundColorChoice.setCustomColorsEnabled(enabled);
        this.m_outlineColorChoice.setCustomColorsEnabled(enabled);
        this.m_leftColorChoice.setCustomColorsEnabled(enabled);
        this.m_rightColorChoice.setCustomColorsEnabled(enabled);
        this.m_topColorChoice.setCustomColorsEnabled(enabled);
        this.m_bottomColorChoice.setCustomColorsEnabled(enabled);
    }

    private void _initialize(ViewStyle gridViewStyle) {
        this.m_gridViewStyle = gridViewStyle;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.formatNamePanel = new JPanel();
        this.formatNamePanel.setLayout(new BoxLayout(this.formatNamePanel, 0));
        this.formatNamePanel.setAlignmentX(0.0f);
        String translatedText = this.rBundle.getString("Format name");
        this.m_formatNameTextField = new JTextField();
        this.m_formatNameTextField.setName("FormatName");
        this.m_formatNameLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_formatNameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_formatNameLabel.setLabelFor(this.m_formatNameTextField);
        this.formatNamePanel.add(this.m_formatNameLabel);
        this.formatNamePanel.add(Box.createHorizontalStrut(5));
        this.formatNamePanel.add(this.m_formatNameTextField);
        this.m_backgroundPanel = new JPanel();
        this.m_backgroundPanel.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(this.rBundle.getString("Background")), BorderFactory.createEmptyBorder(0, 1, 0, 0)));
        this.m_backgroundPanel.setLayout(new BoxLayout(this.m_backgroundPanel, 1));
        this.m_backgroundPanel.setAlignmentX(0.0f);
        this.backgroundColorPanel = new JPanel();
        this.backgroundColorPanel.setLayout(new BoxLayout(this.backgroundColorPanel, 0));
        this.backgroundColorPanel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("Color");
        this.m_backgroundColorChoice = new BIColorChoice();
        this.m_backgroundColorChoice.setName("BackgroundColorChoice");
        this.m_backgroundColorChoice.setLocale(this.m_locale);
        this.m_backgroundColorChoice.setTransparentAllowed(true);
        this.m_backgroundColorLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_backgroundColorLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_backgroundColorLabel.setLabelFor((Component)this.m_backgroundColorChoice);
        this.backgroundColorPanel.add(Box.createHorizontalStrut(15));
        this.backgroundColorPanel.add(this.m_backgroundColorLabel);
        this.backgroundColorPanel.add((Component)this.m_backgroundColorChoice);
        this.m_backgroundPanel.add(this.backgroundColorPanel);
        this.m_bordersPanel = new JPanel();
        this.m_bordersPanel.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(this.rBundle.getString("Borders")), BorderFactory.createEmptyBorder(0, 1, 0, 0)));
        this.m_bordersPanel.setLayout(new BoxLayout(this.m_bordersPanel, 1));
        this.m_bordersPanel.setAlignmentX(0.0f);
        this.bordersOutlinePanel = new JPanel();
        this.bordersOutlinePanel.setLayout(new BoxLayout(this.bordersOutlinePanel, 0));
        this.bordersOutlinePanel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("Outline");
        this.m_outlineColorChoice = new BIColorChoice();
        this.m_outlineColorChoice.setName("OutlineBorderColorChoice");
        this.m_outlineWidth = new LineWidthIncludingNoneForHeader();
        this.m_outlineWidth.setName("OutlineBorderWidthCombo");
        this.m_outlineWidth.setLocale(this.m_locale);
        this.m_outlineWidth.setBackground(Color.white);
        this.m_outlineLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_outlineLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_outlineLabel.setLabelFor(this.m_outlineWidth);
        this.bordersOutlinePanel.add(Box.createHorizontalStrut(15));
        this.bordersOutlinePanel.add(this.m_outlineLabel);
        this.bordersOutlinePanel.add(Box.createHorizontalStrut(5));
        this.bordersOutlinePanel.add(this.m_outlineWidth);
        this.bordersOutlinePanel.add(Box.createHorizontalStrut(5));
        this.bordersOutlinePanel.add((Component)this.m_outlineColorChoice);
        this.bordersLeftAndTopPanel = new JPanel();
        this.bordersLeftAndTopPanel.setLayout(new BoxLayout(this.bordersLeftAndTopPanel, 0));
        this.bordersLeftAndTopPanel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("Left");
        this.m_leftColorChoice = new BIColorChoice();
        this.m_leftColorChoice.setName("LeftBorderColorChoice");
        this.m_leftWidth = new LineWidthIncludingNoneForHeader();
        this.m_leftWidth.setName("LeftBorderWidthCombo");
        this.m_leftWidth.setLocale(this.m_locale);
        this.m_leftWidth.setBackground(Color.white);
        this.m_leftLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_leftLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_leftLabel.setLabelFor(this.m_leftWidth);
        translatedText = this.rBundle.getString("Top");
        this.m_topColorChoice = new BIColorChoice();
        this.m_topColorChoice.setName("TopBorderColorChoice");
        this.m_topWidth = new LineWidthIncludingNoneForHeader();
        this.m_topWidth.setName("TopBorderWidthCombo");
        this.m_topWidth.setLocale(this.m_locale);
        this.m_topWidth.setBackground(Color.white);
        this.m_topLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_topLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_topLabel.setLabelFor(this.m_topWidth);
        this.bordersLeftAndTopPanel.add(Box.createHorizontalStrut(15));
        this.bordersLeftAndTopPanel.add(this.m_leftLabel);
        this.bordersLeftAndTopPanel.add(Box.createHorizontalStrut(5));
        this.bordersLeftAndTopPanel.add(this.m_leftWidth);
        this.bordersLeftAndTopPanel.add(Box.createHorizontalStrut(5));
        this.bordersLeftAndTopPanel.add((Component)this.m_leftColorChoice);
        this.bordersLeftAndTopPanel.add(Box.createHorizontalStrut(15));
        this.bordersLeftAndTopPanel.add(this.m_topLabel);
        this.bordersLeftAndTopPanel.add(Box.createHorizontalStrut(5));
        this.bordersLeftAndTopPanel.add(this.m_topWidth);
        this.bordersLeftAndTopPanel.add(Box.createHorizontalStrut(5));
        this.bordersLeftAndTopPanel.add((Component)this.m_topColorChoice);
        this.bordersRightAndBottomPanel = new JPanel();
        this.bordersRightAndBottomPanel.setLayout(new BoxLayout(this.bordersRightAndBottomPanel, 0));
        this.bordersRightAndBottomPanel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("Right");
        this.m_rightColorChoice = new BIColorChoice();
        this.m_rightColorChoice.setName("RightBorderColorChoice");
        this.m_rightWidth = new LineWidthIncludingNoneForHeader();
        this.m_rightWidth.setName("RightBorderWidthCombo");
        this.m_rightWidth.setLocale(this.m_locale);
        this.m_rightWidth.setBackground(Color.white);
        this.m_rightLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_rightLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_rightLabel.setLabelFor(this.m_rightWidth);
        translatedText = this.rBundle.getString("Bottom");
        this.m_bottomColorChoice = new BIColorChoice();
        this.m_bottomColorChoice.setName("BottomBorderColorChoice");
        this.m_bottomWidth = new LineWidthIncludingNoneForHeader();
        this.m_bottomWidth.setName("BottomBorderWidthCombo");
        this.m_bottomWidth.setLocale(this.m_locale);
        this.m_bottomWidth.setBackground(Color.white);
        this.m_bottomWidth.setPreferredSize(this.m_outlineWidth.getMaximumSize());
        this.m_bottomWidth.setMinimumSize(this.m_outlineWidth.getMaximumSize());
        this.m_bottomWidth.setMaximumSize(this.m_outlineWidth.getMaximumSize());
        this.m_bottomLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_bottomLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_bottomLabel.setLabelFor(this.m_bottomWidth);
        this.bordersRightAndBottomPanel.add(Box.createHorizontalStrut(15));
        this.bordersRightAndBottomPanel.add(this.m_rightLabel);
        this.bordersRightAndBottomPanel.add(Box.createHorizontalStrut(5));
        this.bordersRightAndBottomPanel.add(this.m_rightWidth);
        this.bordersRightAndBottomPanel.add(Box.createHorizontalStrut(5));
        this.bordersRightAndBottomPanel.add((Component)this.m_rightColorChoice);
        this.bordersRightAndBottomPanel.add(Box.createHorizontalStrut(15));
        this.bordersRightAndBottomPanel.add(this.m_bottomLabel);
        this.bordersRightAndBottomPanel.add(Box.createHorizontalStrut(5));
        this.bordersRightAndBottomPanel.add(this.m_bottomWidth);
        this.bordersRightAndBottomPanel.add(Box.createHorizontalStrut(5));
        this.bordersRightAndBottomPanel.add((Component)this.m_bottomColorChoice);
        this.m_bordersPanel.add(this.bordersOutlinePanel);
        this.m_bordersPanel.add(Box.createVerticalStrut(5));
        this.m_bordersPanel.add(this.bordersLeftAndTopPanel);
        this.m_bordersPanel.add(this.bordersRightAndBottomPanel);
        this.add(Box.createVerticalStrut(5));
        this.add(this.formatNamePanel);
        this.add(Box.createVerticalStrut(10));
        this.add(this.m_backgroundPanel);
        this.add(Box.createVerticalStrut(10));
        this.add(this.m_bordersPanel);
        this.m_backgroundColorChoice.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_outlineColorChoice.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_outlineWidth.addItemListener(this);
        this.m_leftColorChoice.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_leftWidth.addItemListener(this);
        this.m_rightColorChoice.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_rightWidth.addItemListener(this);
        this.m_topColorChoice.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_topWidth.addItemListener(this);
        this.m_bottomColorChoice.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_bottomWidth.addItemListener(this);
        this._flag = false;
        this._init(gridViewStyle);
        this._flag = true;
        this.m_backgroundColorChoiceChanged = false;
        this.calculatePanelSize();
    }

    protected void updateResourceBundle(Locale loc) {
        if (loc != null) {
            this.rBundle = ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle", loc);
            this.updateTextUsingCorrectLocale();
        } else {
            this.rBundle = ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle");
        }
    }

    private void updateTextUsingCorrectLocale() {
        this.m_formatNameLabel.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("Format name")));
        String translatedText = this.rBundle.getString("Color");
        this.m_backgroundColorLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this.m_backgroundColorLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.backgroundColorPanel.revalidate();
        this.m_backgroundPanel.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(this.rBundle.getString("Background")), BorderFactory.createEmptyBorder(0, 1, 0, 0)));
        this.m_bordersPanel.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(this.rBundle.getString("Borders")), BorderFactory.createEmptyBorder(0, 1, 0, 0)));
        translatedText = this.rBundle.getString("Outline");
        this.m_outlineLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this.m_outlineLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = this.rBundle.getString("Left");
        this.m_leftLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this.m_leftLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = this.rBundle.getString("Top");
        this.m_topLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this.m_topLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = this.rBundle.getString("Right");
        this.m_rightLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this.m_rightLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = this.rBundle.getString("Bottom");
        this.m_bottomLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this.m_bottomLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        int outlineWidth = this.getToolkit().getFontMetrics(this.m_outlineLabel.getFont()).stringWidth(this.m_outlineLabel.getText());
        int leftWidth = this.getToolkit().getFontMetrics(this.m_leftLabel.getFont()).stringWidth(this.m_leftLabel.getText());
        int rightWidth = this.getToolkit().getFontMetrics(this.m_rightLabel.getFont()).stringWidth(this.m_rightLabel.getText());
        int width = outlineWidth;
        if (leftWidth > width) {
            width = leftWidth;
        }
        if (rightWidth > width) {
            width = rightWidth;
        }
        this.m_outlineLabel.setPreferredSize(new Dimension(width, this.m_outlineLabel.getPreferredSize().height));
        this.m_outlineLabel.setMinimumSize(this.m_outlineLabel.getPreferredSize());
        this.m_outlineLabel.setMaximumSize(this.m_outlineLabel.getPreferredSize());
        this.m_leftLabel.setPreferredSize(new Dimension(width, this.m_leftLabel.getPreferredSize().height));
        this.m_leftLabel.setMinimumSize(this.m_leftLabel.getPreferredSize());
        this.m_leftLabel.setMaximumSize(this.m_leftLabel.getPreferredSize());
        this.m_rightLabel.setPreferredSize(new Dimension(width, this.m_rightLabel.getPreferredSize().height));
        this.m_rightLabel.setMinimumSize(this.m_rightLabel.getPreferredSize());
        this.m_rightLabel.setMaximumSize(this.m_rightLabel.getPreferredSize());
        int topWidth = this.getToolkit().getFontMetrics(this.m_topLabel.getFont()).stringWidth(this.m_topLabel.getText());
        int bottomWidth = this.getToolkit().getFontMetrics(this.m_bottomLabel.getFont()).stringWidth(this.m_bottomLabel.getText());
        width = topWidth;
        if (bottomWidth > width) {
            width = bottomWidth;
        }
        this.m_topLabel.setPreferredSize(new Dimension(width, this.m_topLabel.getPreferredSize().height));
        this.m_topLabel.setMinimumSize(new Dimension(width, this.m_topLabel.getPreferredSize().height));
        this.m_topLabel.setMaximumSize(new Dimension(width, this.m_topLabel.getPreferredSize().height));
        this.m_bottomLabel.setPreferredSize(new Dimension(width, this.m_bottomLabel.getPreferredSize().height));
        this.m_bottomLabel.setMinimumSize(new Dimension(width, this.m_bottomLabel.getPreferredSize().height));
        this.m_bottomLabel.setMaximumSize(new Dimension(width, this.m_bottomLabel.getPreferredSize().height));
        this.m_outlineWidth.setLocale(this.getLocale());
        this.m_leftWidth.setLocale(this.getLocale());
        this.m_rightWidth.setLocale(this.getLocale());
        this.m_topWidth.setLocale(this.getLocale());
        this.m_bottomWidth.setLocale(this.getLocale());
        this.m_outlineWidth.revalidate();
        this.m_leftWidth.revalidate();
        this.m_rightWidth.revalidate();
        this.m_topWidth.revalidate();
        this.m_bottomWidth.revalidate();
        this.bordersOutlinePanel.revalidate();
        this.bordersRightAndBottomPanel.revalidate();
        this.bordersLeftAndTopPanel.revalidate();
        this.m_bordersPanel.setPreferredSize(new Dimension(Math.max(this.bordersRightAndBottomPanel.getPreferredSize().width, this.bordersOutlinePanel.getPreferredSize().width) + 15, this.m_bordersPanel.getPreferredSize().height));
    }

    private void _init(ViewStyle gridViewStyle) {
        if (gridViewStyle == null) {
            return;
        }
        Color color = gridViewStyle.getBackground();
        if (color != null) {
            if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_backgroundColorChoice.getColorPalette(), (Color)color)) {
                this.m_backgroundColorChoice.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_backgroundColorChoice.getColorPalette(), (Color)color, (boolean)false));
            }
        }
        this.m_backgroundColorChoice.setSelectedColor(color);
        color = gridViewStyle.getBorderColor(15);
        if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_outlineColorChoice.getColorPalette(), (Color)color)) {
            this.m_outlineColorChoice.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_outlineColorChoice.getColorPalette(), (Color)color, (boolean)false));
        }
        this.m_outlineColorChoice.setSelectedColor(color);
        color = gridViewStyle.getBorderColor(2);
        if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_leftColorChoice.getColorPalette(), (Color)color)) {
            this.m_leftColorChoice.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_leftColorChoice.getColorPalette(), (Color)color, (boolean)false));
        }
        this.m_leftColorChoice.setSelectedColor(color);
        if (gridViewStyle.getBorderStyle(2) == 0) {
            this.m_leftWidth.setLineWidth(0);
        } else if (gridViewStyle.getBorderStyle(2) == 3) {
            this.m_leftWidth.setLineWidth(5);
        } else if (gridViewStyle.getBorderStyle(2) == 2) {
            this.m_leftWidth.setLineWidth(6);
        } else if (gridViewStyle.getBorderStyle(2) == 4) {
            this.m_leftWidth.setLineWidth(7);
        } else if (gridViewStyle.getBorderStyle(2) == 5) {
            this.m_leftWidth.setLineWidth(8);
        } else if (gridViewStyle.getBorderStyle(2) == 6) {
            this.m_leftWidth.setLineWidth(9);
        } else {
            this.m_leftWidth.setLineWidth(gridViewStyle.getBorderWidth(2));
            this.m_leftLineWidthChanged = true;
        }
        color = gridViewStyle.getBorderColor(8);
        if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_rightColorChoice.getColorPalette(), (Color)color)) {
            this.m_rightColorChoice.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_rightColorChoice.getColorPalette(), (Color)color, (boolean)false));
        }
        this.m_rightColorChoice.setSelectedColor(color);
        if (gridViewStyle.getBorderStyle(8) == 0) {
            this.m_rightWidth.setLineWidth(0);
        } else if (gridViewStyle.getBorderStyle(8) == 3) {
            this.m_rightWidth.setLineWidth(5);
        } else if (gridViewStyle.getBorderStyle(8) == 2) {
            this.m_rightWidth.setLineWidth(6);
        } else if (gridViewStyle.getBorderStyle(8) == 4) {
            this.m_rightWidth.setLineWidth(7);
        } else if (gridViewStyle.getBorderStyle(8) == 5) {
            this.m_rightWidth.setLineWidth(8);
        } else if (gridViewStyle.getBorderStyle(8) == 6) {
            this.m_rightWidth.setLineWidth(9);
        } else {
            this.m_rightWidth.setLineWidth(gridViewStyle.getBorderWidth(8));
            this.m_rightLineWidthChanged = true;
        }
        color = gridViewStyle.getBorderColor(1);
        if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_topColorChoice.getColorPalette(), (Color)color)) {
            this.m_topColorChoice.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_topColorChoice.getColorPalette(), (Color)color, (boolean)false));
        }
        this.m_topColorChoice.setSelectedColor(color);
        if (gridViewStyle.getBorderStyle(1) == 0) {
            this.m_topWidth.setLineWidth(0);
        } else if (gridViewStyle.getBorderStyle(1) == 3) {
            this.m_topWidth.setLineWidth(5);
        } else if (gridViewStyle.getBorderStyle(1) == 2) {
            this.m_topWidth.setLineWidth(6);
        } else if (gridViewStyle.getBorderStyle(1) == 4) {
            this.m_topWidth.setLineWidth(7);
        } else if (gridViewStyle.getBorderStyle(1) == 5) {
            this.m_topWidth.setLineWidth(8);
        } else if (gridViewStyle.getBorderStyle(1) == 6) {
            this.m_topWidth.setLineWidth(9);
        } else {
            this.m_topWidth.setLineWidth(gridViewStyle.getBorderWidth(1));
            this.m_topLineWidthChanged = true;
        }
        color = gridViewStyle.getBorderColor(4);
        if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_bottomColorChoice.getColorPalette(), (Color)color)) {
            this.m_bottomColorChoice.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_bottomColorChoice.getColorPalette(), (Color)color, (boolean)false));
        }
        this.m_bottomColorChoice.setSelectedColor(color);
        if (gridViewStyle.getBorderStyle(4) == 0) {
            this.m_bottomWidth.setLineWidth(0);
        } else if (gridViewStyle.getBorderStyle(4) == 3) {
            this.m_bottomWidth.setLineWidth(5);
        } else if (gridViewStyle.getBorderStyle(4) == 2) {
            this.m_bottomWidth.setLineWidth(6);
        } else if (gridViewStyle.getBorderStyle(4) == 4) {
            this.m_bottomWidth.setLineWidth(7);
        } else if (gridViewStyle.getBorderStyle(4) == 5) {
            this.m_bottomWidth.setLineWidth(8);
        } else if (gridViewStyle.getBorderStyle(4) == 6) {
            this.m_bottomWidth.setLineWidth(9);
        } else {
            this.m_bottomWidth.setLineWidth(gridViewStyle.getBorderWidth(4));
            this.m_bottomLineWidthChanged = true;
        }
        if (this.m_leftWidth.getLineWidth() == this.m_rightWidth.getLineWidth() && this.m_rightWidth.getLineWidth() == this.m_topWidth.getLineWidth() && this.m_topWidth.getLineWidth() == this.m_bottomWidth.getLineWidth()) {
            if (gridViewStyle.getBorderStyle(15) == 0) {
                this.m_outlineWidth.setLineWidth(0);
            } else if (gridViewStyle.getBorderStyle(15) == 3) {
                this.m_outlineWidth.setLineWidth(5);
            } else if (gridViewStyle.getBorderStyle(15) == 2) {
                this.m_outlineWidth.setLineWidth(6);
            } else if (gridViewStyle.getBorderStyle(15) == 4) {
                this.m_outlineWidth.setLineWidth(7);
            } else if (gridViewStyle.getBorderStyle(15) == 5) {
                this.m_outlineWidth.setLineWidth(8);
            } else if (gridViewStyle.getBorderStyle(15) == 6) {
                this.m_outlineWidth.setLineWidth(9);
            } else {
                this.m_outlineWidth.setLineWidth(gridViewStyle.getBorderWidth(15));
            }
        } else {
            this.m_outlineWidth.setLineWidth(-1);
        }
    }

    @Override
    public void setLocale(Locale loc) {
        this.m_locale = loc != null ? loc : Locale.getDefault();
        super.setLocale(this.m_locale);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(loc);
        if (this.m_backgroundColorChoice != null) {
            this.m_backgroundColorChoice.setLocale(loc);
        }
        this.calculatePanelSize();
    }

    public void setFormatName(String name) {
        this.m_formatNameTextField.setText(name);
    }

    public void setFormatName(String name, boolean editable) {
        this.m_formatNameTextField.setText(name);
        this.m_formatNameTextField.setEnabled(editable);
    }

    public String getFormatName() {
        return this.m_formatNameTextField.getText();
    }

    public void setBackgroundColor(Color color) {
        if (color != null) {
            if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_backgroundColorChoice.getColorPalette(), (Color)color)) {
                this.m_backgroundColorChoice.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_backgroundColorChoice.getColorPalette(), (Color)color, (boolean)false));
            }
        }
        this.m_backgroundColorChoice.setSelectedColor(color);
    }

    public Color getBackgroundColor() {
        return this.m_backgroundColorChoice.getSelectedColor();
    }

    public void setSelectedDimension(String dimensionName) {
    }

    public String getSelectedDimension() {
        return null;
    }

    public void setOutlineWidth(int width) {
        this.m_outlineWidth.setSelectedIndex(width);
    }

    public int getOutlineWidth() {
        return this.m_outlineWidth.getSelectedIndex();
    }

    private void setOutlineStyle(JComboBox lineWidth, int style) {
        if (style == 0) {
            lineWidth.setSelectedIndex(0);
        }
        if (style == 3) {
            lineWidth.setSelectedIndex(5);
        }
        if (style == 2) {
            lineWidth.setSelectedIndex(6);
        }
        if (style == 4) {
            lineWidth.setSelectedIndex(7);
        }
        if (style == 5) {
            lineWidth.setSelectedIndex(8);
        }
        if (style == 6) {
            lineWidth.setSelectedIndex(9);
        }
    }

    private int getOutlineStyle(JComboBox lineWidth) {
        if (lineWidth.getSelectedIndex() == 0) {
            return 0;
        }
        if (lineWidth.getSelectedIndex() == 5) {
            return 3;
        }
        if (lineWidth.getSelectedIndex() == 6) {
            return 2;
        }
        if (lineWidth.getSelectedIndex() == 7) {
            return 4;
        }
        if (lineWidth.getSelectedIndex() == 8) {
            return 5;
        }
        if (lineWidth.getSelectedIndex() == 9) {
            return 6;
        }
        return 1;
    }

    public String getHelpContextID() {
        return this.getClass().getName();
    }

    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setOutlineStyle(int style) {
        this.setOutlineStyle(this.m_outlineWidth, style);
    }

    public int getOutlineStyle() {
        return this.getOutlineStyle(this.m_outlineWidth);
    }

    public void setOutlineColor(Color color) {
        if (color != null) {
            if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_outlineColorChoice.getColorPalette(), (Color)color)) {
                this.m_outlineColorChoice.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_outlineColorChoice.getColorPalette(), (Color)color, (boolean)false));
            }
        }
        this.m_outlineColorChoice.setSelectedColor(color);
    }

    public Color getOutlineColor() {
        return this.m_outlineColorChoice.getSelectedColor();
    }

    public void setTopWidth(int width) {
        this.m_topWidth.setSelectedIndex(width);
    }

    public int getTopWidth() {
        return this.m_topWidth.getSelectedIndex();
    }

    public void setTopStyle(int style) {
        this.setOutlineStyle(this.m_topWidth, style);
    }

    public int getTopStyle() {
        return this.getOutlineStyle(this.m_topWidth);
    }

    public void setLeftWidth(int width) {
        this.m_leftWidth.setSelectedIndex(width);
    }

    public int getLeftWidth() {
        return this.m_leftWidth.getSelectedIndex();
    }

    public void setLeftStyle(int style) {
        this.setOutlineStyle(this.m_leftWidth, style);
    }

    public int getLeftStyle() {
        return this.getOutlineStyle(this.m_leftWidth);
    }

    public void setBottomWidth(int width) {
        this.m_bottomWidth.setSelectedIndex(width);
    }

    public int getBottomWidth() {
        return this.m_bottomWidth.getSelectedIndex();
    }

    public void setBottomStyle(int style) {
        this.setOutlineStyle(this.m_bottomWidth, style);
    }

    public int getBottomStyle() {
        return this.getOutlineStyle(this.m_bottomWidth);
    }

    public void setRightWidth(int width) {
        this.m_rightWidth.setSelectedIndex(width);
    }

    public int getRightWidth() {
        return this.m_rightWidth.getSelectedIndex();
    }

    public void setRightStyle(int style) {
        this.setOutlineStyle(this.m_rightWidth, style);
    }

    public int getRightStyle() {
        return this.getOutlineStyle(this.m_rightWidth);
    }

    public void setTopColor(Color color) {
        if (color != null) {
            if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_topColorChoice.getColorPalette(), (Color)color)) {
                this.m_topColorChoice.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_topColorChoice.getColorPalette(), (Color)color, (boolean)false));
            }
        }
        this.m_topColorChoice.setSelectedColor(color);
    }

    public Color getTopColor() {
        return this.m_topColorChoice.getSelectedColor();
    }

    public void setLeftColor(Color color) {
        if (color != null) {
            if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_leftColorChoice.getColorPalette(), (Color)color)) {
                this.m_leftColorChoice.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_leftColorChoice.getColorPalette(), (Color)color, (boolean)false));
            }
        }
        this.m_leftColorChoice.setSelectedColor(color);
    }

    public Color getLeftColor() {
        return this.m_leftColorChoice.getSelectedColor();
    }

    public void setBottomColor(Color color) {
        if (color != null) {
            if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_bottomColorChoice.getColorPalette(), (Color)color)) {
                this.m_bottomColorChoice.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_bottomColorChoice.getColorPalette(), (Color)color, (boolean)false));
            }
        }
        this.m_bottomColorChoice.setSelectedColor(color);
    }

    public Color getBottomColor() {
        return this.m_bottomColorChoice.getSelectedColor();
    }

    public void setRightColor(Color color) {
        if (color != null) {
            if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_rightColorChoice.getColorPalette(), (Color)color)) {
                this.m_rightColorChoice.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_rightColorChoice.getColorPalette(), (Color)color, (boolean)false));
            }
        }
        this.m_rightColorChoice.setSelectedColor(color);
    }

    public Color getRightColor() {
        return this.m_rightColorChoice.getSelectedColor();
    }

    public boolean apply(ViewStyle gridViewStyle) {
        if (gridViewStyle == null) {
            return true;
        }
        if (this.m_backgroundColorChoiceChanged) {
            Color selColor = this.m_backgroundColorChoice.getSelectedColor();
            if (gridViewStyle.getBackground() != null && selColor == null) {
                gridViewStyle.setBackground(null);
            } else if (gridViewStyle.getBackground() == null && selColor != null) {
                gridViewStyle.setBackground(this.m_backgroundColorChoice.getSelectedColor());
            } else if (!(gridViewStyle.getBackground() == null || selColor == null || gridViewStyle.getBackground().getRGB() == selColor.getRGB() && gridViewStyle.isBackgroundUsed())) {
                gridViewStyle.setBackground(selColor);
            }
        }
        if (this.m_outlineColorChoice.getSelectedColor() != null && gridViewStyle.getBorderColor(15).getRGB() != this.m_outlineColorChoice.getSelectedColor().getRGB()) {
            gridViewStyle.setBorderColor(15, this.m_outlineColorChoice.getSelectedColor());
        }
        if (this.m_outlineWidth.getSelectedIndex() > 0 && this.m_outlineWidth.getSelectedIndex() < 5) {
            gridViewStyle.setBorderWidth(15, this.m_outlineWidth.getSelectedIndex());
            if (this.m_outlineWidthChanged && gridViewStyle.getBorderStyle(15) != 1) {
                gridViewStyle.setBorderStyle(15, 1);
            }
        } else if (this.m_outlineWidth.getSelectedIndex() == 0 && gridViewStyle.getBorderStyle(15) != 0) {
            gridViewStyle.setBorderStyle(15, 0);
        } else if (this.m_outlineWidth.getSelectedIndex() >= 5) {
            if (this.m_outlineWidth.getSelectedIndex() == 5 && gridViewStyle.getBorderStyle(15) != 3) {
                gridViewStyle.setBorderStyle(15, 3);
            } else if (this.m_outlineWidth.getSelectedIndex() == 6 && gridViewStyle.getBorderStyle(15) != 2) {
                gridViewStyle.setBorderStyle(15, 2);
            } else if (this.m_outlineWidth.getSelectedIndex() == 7 && gridViewStyle.getBorderStyle(15) != 4) {
                gridViewStyle.setBorderStyle(15, 4);
            } else if (this.m_outlineWidth.getSelectedIndex() == 8 && gridViewStyle.getBorderStyle(15) != 5) {
                gridViewStyle.setBorderStyle(15, 5);
            } else if (this.m_outlineWidth.getSelectedIndex() == 9 && gridViewStyle.getBorderStyle(15) != 6) {
                gridViewStyle.setBorderStyle(15, 6);
            }
            if (gridViewStyle.getBorderWidth(15) != 1) {
                gridViewStyle.setBorderWidth(15, 1);
            }
        }
        if (this.m_leftColorChoice.getSelectedColor() != null && gridViewStyle.getBorderColor(2).getRGB() != this.m_leftColorChoice.getSelectedColor().getRGB()) {
            gridViewStyle.setBorderColor(2, this.m_leftColorChoice.getSelectedColor());
        }
        if (this.m_leftWidth.getSelectedIndex() > 0 && this.m_leftWidth.getSelectedIndex() < 5) {
            if (gridViewStyle.getBorderWidth(2) != this.m_leftWidth.getSelectedIndex()) {
                gridViewStyle.setBorderWidth(2, this.m_leftWidth.getSelectedIndex());
            }
            if (this.m_leftLineWidthChanged && gridViewStyle.getBorderStyle(2) != 1) {
                gridViewStyle.setBorderStyle(2, 1);
            }
        } else if (this.m_leftWidth.getSelectedIndex() == 0 && gridViewStyle.getBorderStyle(2) != 0) {
            gridViewStyle.setBorderStyle(2, 0);
        } else if (this.m_leftWidth.getSelectedIndex() >= 5) {
            if (this.m_leftWidth.getSelectedIndex() == 5 && gridViewStyle.getBorderStyle(2) != 3) {
                gridViewStyle.setBorderStyle(2, 3);
            } else if (this.m_leftWidth.getSelectedIndex() == 6 && gridViewStyle.getBorderStyle(2) != 2) {
                gridViewStyle.setBorderStyle(2, 2);
            } else if (this.m_leftWidth.getSelectedIndex() == 7 && gridViewStyle.getBorderStyle(2) != 4) {
                gridViewStyle.setBorderStyle(2, 4);
            } else if (this.m_leftWidth.getSelectedIndex() == 8 && gridViewStyle.getBorderStyle(2) != 5) {
                gridViewStyle.setBorderStyle(2, 5);
            } else if (this.m_leftWidth.getSelectedIndex() == 9 && gridViewStyle.getBorderStyle(2) != 6) {
                gridViewStyle.setBorderStyle(2, 6);
            }
            if (gridViewStyle.getBorderWidth(2) != 1) {
                gridViewStyle.setBorderWidth(2, 1);
            }
        }
        if (this.m_topColorChoice.getSelectedColor() != null && gridViewStyle.getBorderColor(1).getRGB() != this.m_topColorChoice.getSelectedColor().getRGB()) {
            gridViewStyle.setBorderColor(1, this.m_topColorChoice.getSelectedColor());
        }
        if (this.m_topWidth.getSelectedIndex() > 0 && this.m_topWidth.getSelectedIndex() < 5) {
            if (gridViewStyle.getBorderWidth(1) != this.m_topWidth.getSelectedIndex()) {
                gridViewStyle.setBorderWidth(1, this.m_topWidth.getSelectedIndex());
            }
            if (this.m_topLineWidthChanged && gridViewStyle.getBorderStyle(1) != 1) {
                gridViewStyle.setBorderStyle(1, 1);
            }
        } else if (this.m_topWidth.getSelectedIndex() == 0 && gridViewStyle.getBorderStyle(1) != 0) {
            gridViewStyle.setBorderStyle(1, 0);
        } else if (this.m_topWidth.getSelectedIndex() >= 5) {
            if (this.m_topWidth.getSelectedIndex() == 5 && gridViewStyle.getBorderStyle(1) != 3) {
                gridViewStyle.setBorderStyle(1, 3);
            } else if (this.m_topWidth.getSelectedIndex() == 6 && gridViewStyle.getBorderStyle(1) != 2) {
                gridViewStyle.setBorderStyle(1, 2);
            } else if (this.m_topWidth.getSelectedIndex() == 7 && gridViewStyle.getBorderStyle(1) != 4) {
                gridViewStyle.setBorderStyle(1, 4);
            } else if (this.m_topWidth.getSelectedIndex() == 8 && gridViewStyle.getBorderStyle(1) != 5) {
                gridViewStyle.setBorderStyle(1, 5);
            } else if (this.m_topWidth.getSelectedIndex() == 9 && gridViewStyle.getBorderStyle(1) != 6) {
                gridViewStyle.setBorderStyle(1, 6);
            }
            if (gridViewStyle.getBorderWidth(1) != 1) {
                gridViewStyle.setBorderWidth(1, 1);
            }
        }
        if (this.m_bottomColorChoice.getSelectedColor() != null && gridViewStyle.getBorderColor(4).getRGB() != this.m_bottomColorChoice.getSelectedColor().getRGB()) {
            gridViewStyle.setBorderColor(4, this.m_bottomColorChoice.getSelectedColor());
        }
        if (this.m_bottomWidth.getSelectedIndex() > 0 && this.m_bottomWidth.getSelectedIndex() < 5) {
            if (gridViewStyle.getBorderWidth(4) != this.m_bottomWidth.getSelectedIndex()) {
                gridViewStyle.setBorderWidth(4, this.m_bottomWidth.getSelectedIndex());
            }
            if (this.m_bottomLineWidthChanged && gridViewStyle.getBorderStyle(4) != 1) {
                gridViewStyle.setBorderStyle(4, 1);
            }
        } else if (this.m_bottomWidth.getSelectedIndex() == 0 && gridViewStyle.getBorderStyle(4) != 0) {
            gridViewStyle.setBorderStyle(4, 0);
        } else if (this.m_bottomWidth.getSelectedIndex() >= 5) {
            if (this.m_bottomWidth.getSelectedIndex() == 5 && gridViewStyle.getBorderStyle(4) != 3) {
                gridViewStyle.setBorderStyle(4, 3);
            } else if (this.m_bottomWidth.getSelectedIndex() == 6 && gridViewStyle.getBorderStyle(4) != 2) {
                gridViewStyle.setBorderStyle(4, 2);
            } else if (this.m_bottomWidth.getSelectedIndex() == 7 && gridViewStyle.getBorderStyle(4) != 4) {
                gridViewStyle.setBorderStyle(4, 4);
            } else if (this.m_bottomWidth.getSelectedIndex() == 8 && gridViewStyle.getBorderStyle(4) != 5) {
                gridViewStyle.setBorderStyle(4, 5);
            } else if (this.m_bottomWidth.getSelectedIndex() == 9 && gridViewStyle.getBorderStyle(4) != 6) {
                gridViewStyle.setBorderStyle(4, 6);
            }
            if (gridViewStyle.getBorderWidth(4) != 1) {
                gridViewStyle.setBorderWidth(4, 1);
            }
        }
        if (this.m_rightColorChoice.getSelectedColor() != null && gridViewStyle.getBorderColor(8).getRGB() != this.m_rightColorChoice.getSelectedColor().getRGB()) {
            gridViewStyle.setBorderColor(8, this.m_rightColorChoice.getSelectedColor());
        }
        if (this.m_rightWidth.getSelectedIndex() > 0 && this.m_rightWidth.getSelectedIndex() < 5) {
            if (gridViewStyle.getBorderWidth(8) != this.m_rightWidth.getSelectedIndex()) {
                gridViewStyle.setBorderWidth(8, this.m_rightWidth.getSelectedIndex());
            }
            if (this.m_rightLineWidthChanged && gridViewStyle.getBorderStyle(8) != 1) {
                gridViewStyle.setBorderStyle(8, 1);
            }
        } else if (this.m_rightWidth.getSelectedIndex() == 0 && gridViewStyle.getBorderStyle(8) != 0) {
            gridViewStyle.setBorderStyle(8, 0);
        } else if (this.m_rightWidth.getSelectedIndex() >= 5) {
            if (this.m_rightWidth.getSelectedIndex() == 5 && gridViewStyle.getBorderStyle(8) != 3) {
                gridViewStyle.setBorderStyle(8, 3);
            } else if (this.m_rightWidth.getSelectedIndex() == 6 && gridViewStyle.getBorderStyle(8) != 2) {
                gridViewStyle.setBorderStyle(8, 2);
            } else if (this.m_rightWidth.getSelectedIndex() == 7 && gridViewStyle.getBorderStyle(8) != 4) {
                gridViewStyle.setBorderStyle(8, 4);
            } else if (this.m_rightWidth.getSelectedIndex() == 8 && gridViewStyle.getBorderStyle(8) != 5) {
                gridViewStyle.setBorderStyle(8, 5);
            } else if (this.m_rightWidth.getSelectedIndex() == 9 && gridViewStyle.getBorderStyle(8) != 6) {
                gridViewStyle.setBorderStyle(8, 6);
            }
            if (gridViewStyle.getBorderWidth(8) != 1) {
                gridViewStyle.setBorderWidth(8, 1);
            }
        }
        return true;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.panelWidth, super.getPreferredSize().height);
    }

    public void setApplicationName(String name) {
        this.m_applicationName = name;
    }

    public String getApplicationName() {
        return this.m_applicationName;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (!this._flag) {
            return;
        }
        if (e.getSource() == this.m_outlineWidth) {
            if (this.oldOutlineWidth != this.m_outlineWidth.getLineWidth() && this.m_outlineWidth.getSelectedIndex() >= 0) {
                this.firePropertyChange(PROPERTY_OUTLINE_WIDTH, new Integer(this.oldOutlineWidth), new Integer(this.m_outlineWidth.getLineWidth()));
                this.oldOutlineWidth = this.m_outlineWidth.getLineWidth();
                this.m_topWidth.setSelectedIndex(this.m_outlineWidth.getSelectedIndex());
                this.m_leftWidth.setSelectedIndex(this.m_outlineWidth.getSelectedIndex());
                this.m_bottomWidth.setSelectedIndex(this.m_outlineWidth.getSelectedIndex());
                this.m_rightWidth.setSelectedIndex(this.m_outlineWidth.getSelectedIndex());
                this.m_outlineWidthChanged = true;
            }
        } else if (e.getSource() == this.m_leftWidth) {
            if (this.oldLeftLineWidth != this.m_leftWidth.getLineWidth()) {
                this.firePropertyChange(PROPERTY_LEFT_LINE_WIDTH, new Integer(this.oldLeftLineWidth), new Integer(this.m_leftWidth.getLineWidth()));
                this.oldLeftLineWidth = this.m_leftWidth.getLineWidth();
                this.m_leftLineWidthChanged = true;
                if (this.m_outlineWidth.getSelectedIndex() != this.m_leftWidth.getSelectedIndex() && this.m_outlineWidth.getLineWidth() != -1) {
                    this.m_outlineWidth.setSelectedIndex(-1);
                }
            }
        } else if (e.getSource() == this.m_rightWidth) {
            if (this.oldRightLineWidth != this.m_rightWidth.getLineWidth()) {
                this.firePropertyChange(PROPERTY_RIGHT_LINE_WIDTH, new Integer(this.oldRightLineWidth), new Integer(this.m_rightWidth.getLineWidth()));
                this.oldRightLineWidth = this.m_rightWidth.getLineWidth();
                this.m_rightLineWidthChanged = true;
                if (this.m_outlineWidth.getSelectedIndex() != this.m_rightWidth.getSelectedIndex() && this.m_outlineWidth.getLineWidth() != -1) {
                    this.m_outlineWidth.setSelectedIndex(-1);
                }
            }
        } else if (e.getSource() == this.m_topWidth) {
            if (this.oldTopLineWidth != this.m_topWidth.getLineWidth()) {
                this.firePropertyChange(PROPERTY_TOP_LINE_WIDTH, new Integer(this.oldTopLineWidth), new Integer(this.m_topWidth.getLineWidth()));
                this.oldTopLineWidth = this.m_topWidth.getLineWidth();
                this.m_topLineWidthChanged = true;
                if (this.m_outlineWidth.getSelectedIndex() != this.m_topWidth.getSelectedIndex() && this.m_outlineWidth.getLineWidth() != -1) {
                    this.m_outlineWidth.setSelectedIndex(-1);
                }
            }
        } else if (e.getSource() == this.m_bottomWidth && this.oldBottomLineWidth != this.m_bottomWidth.getLineWidth()) {
            this.firePropertyChange(PROPERTY_BOTTOM_LINE_WIDTH, new Integer(this.oldBottomLineWidth), new Integer(this.m_bottomWidth.getLineWidth()));
            this.oldBottomLineWidth = this.m_bottomWidth.getLineWidth();
            this.m_bottomLineWidthChanged = true;
            if (this.m_outlineWidth.getSelectedIndex() != this.m_bottomWidth.getSelectedIndex() && this.m_outlineWidth.getLineWidth() != -1) {
                this.m_outlineWidth.setSelectedIndex(-1);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == "fontBackgroundColor" && e.getSource() != this.m_backgroundColorChoice) {
            this._flag1 = false;
            this.m_backgroundColorChoice.setSelectedColor((Color)e.getNewValue());
            this._flag1 = true;
        } else if (e.getSource() == this.m_backgroundColorChoice && e.getPropertyName().equals("selectedColor")) {
            if (this._flag1) {
                this.firePropertyChange(PROPERTY_BACKGROUND_COLOR, e.getOldValue(), e.getNewValue());
                this.m_backgroundColorChoiceChanged = true;
            }
        } else if (e.getSource() == this.m_outlineColorChoice && e.getPropertyName().equals("selectedColor")) {
            if (this.m_outlineColorChoice.getSelectedColor() != null) {
                this.firePropertyChange(PROPERTY_OUTLINE_COLOR, e.getOldValue(), e.getNewValue());
                this.m_outlineWidth.setCellColor(this.m_outlineColorChoice.getSelectedColor());
                this.m_topColorChoice.setSelectedColor(this.m_outlineColorChoice.getSelectedColor());
                this.m_leftColorChoice.setSelectedColor(this.m_outlineColorChoice.getSelectedColor());
                this.m_bottomColorChoice.setSelectedColor(this.m_outlineColorChoice.getSelectedColor());
                this.m_rightColorChoice.setSelectedColor(this.m_outlineColorChoice.getSelectedColor());
                this.m_outlineWidth.repaint();
            } else {
                this.m_outlineWidth.setCellColor(Color.black);
            }
        } else if (e.getSource() == this.m_leftColorChoice && e.getPropertyName().equals("selectedColor")) {
            this.firePropertyChange(PROPERTY_LEFT_LINE_COLOR, e.getOldValue(), e.getNewValue());
            this.m_leftWidth.setCellColor(this.m_leftColorChoice.getSelectedColor());
            this.m_leftWidth.repaint();
            if (this.m_leftColorChoice.getSelectedColor() != this.m_outlineColorChoice.getSelectedColor() && this.m_outlineColorChoice.getSelectedColor() != null) {
                this.m_outlineColorChoice.setSelectedColor(null);
            }
        } else if (e.getSource() == this.m_rightColorChoice && e.getPropertyName().equals("selectedColor")) {
            this.firePropertyChange(PROPERTY_RIGHT_LINE_COLOR, e.getOldValue(), e.getNewValue());
            this.m_rightWidth.setCellColor(this.m_rightColorChoice.getSelectedColor());
            this.m_rightWidth.repaint();
            if (this.m_rightColorChoice.getSelectedColor() != this.m_outlineColorChoice.getSelectedColor() && this.m_outlineColorChoice.getSelectedColor() != null) {
                this.m_outlineColorChoice.setSelectedColor(null);
            }
        } else if (e.getSource() == this.m_topColorChoice && e.getPropertyName().equals("selectedColor")) {
            this.firePropertyChange(PROPERTY_TOP_LINE_COLOR, e.getOldValue(), e.getNewValue());
            this.m_topWidth.setCellColor(this.m_topColorChoice.getSelectedColor());
            this.m_topWidth.repaint();
            if (this.m_topColorChoice.getSelectedColor() != this.m_outlineColorChoice.getSelectedColor() && this.m_outlineColorChoice.getSelectedColor() != null) {
                this.m_outlineColorChoice.setSelectedColor(null);
            }
        } else if (e.getSource() == this.m_bottomColorChoice && e.getPropertyName().equals("selectedColor")) {
            this.firePropertyChange(PROPERTY_BOTTOM_LINE_COLOR, e.getOldValue(), e.getNewValue());
            this.m_bottomWidth.setCellColor(this.m_bottomColorChoice.getSelectedColor());
            this.m_bottomWidth.repaint();
            if (this.m_bottomColorChoice.getSelectedColor() != this.m_outlineColorChoice.getSelectedColor() && this.m_outlineColorChoice.getSelectedColor() != null) {
                this.m_outlineColorChoice.setSelectedColor(null);
            }
        }
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void cleanUp() {
        this._flag = false;
        this.bordersOutlinePanel.remove(this.m_outlineWidth);
        this.m_outlineLabel.setLabelFor(null);
        this.m_outlineWidth.cleanUp();
        this.m_outlineWidth = null;
        this.bordersLeftAndTopPanel.remove(this.m_leftWidth);
        this.m_leftLabel.setLabelFor(null);
        this.m_leftWidth.cleanUp();
        this.m_leftWidth = null;
        this.bordersRightAndBottomPanel.remove(this.m_rightWidth);
        this.m_rightLabel.setLabelFor(null);
        this.m_rightWidth.cleanUp();
        this.m_rightWidth = null;
        this.bordersLeftAndTopPanel.remove(this.m_topWidth);
        this.m_topLabel.setLabelFor(null);
        this.m_topWidth.cleanUp();
        this.m_topWidth = null;
        this.bordersRightAndBottomPanel.remove(this.m_bottomWidth);
        this.m_bottomLabel.setLabelFor(null);
        this.m_bottomWidth.cleanUp();
        this.m_bottomWidth = null;
    }

    private void calculatePanelSize() {
        if (this.m_outlineLabel == null) {
            return;
        }
        int outlineWidth = this.getToolkit().getFontMetrics(this.m_outlineLabel.getFont()).stringWidth(this.m_outlineLabel.getText());
        int leftWidth = this.getToolkit().getFontMetrics(this.m_leftLabel.getFont()).stringWidth(this.m_leftLabel.getText());
        int rightWidth = this.getToolkit().getFontMetrics(this.m_rightLabel.getFont()).stringWidth(this.m_rightLabel.getText());
        int width = outlineWidth;
        if (leftWidth > width) {
            width = leftWidth;
        }
        if (rightWidth > width) {
            width = rightWidth;
        }
        this.m_outlineLabel.setPreferredSize(new Dimension(width, this.m_outlineLabel.getPreferredSize().height));
        this.m_outlineLabel.setMinimumSize(this.m_outlineLabel.getPreferredSize());
        this.m_outlineLabel.setMaximumSize(this.m_outlineLabel.getPreferredSize());
        this.m_leftLabel.setPreferredSize(new Dimension(width, this.m_leftLabel.getPreferredSize().height));
        this.m_leftLabel.setMinimumSize(this.m_leftLabel.getPreferredSize());
        this.m_leftLabel.setMaximumSize(this.m_leftLabel.getPreferredSize());
        this.m_rightLabel.setPreferredSize(new Dimension(width, this.m_rightLabel.getPreferredSize().height));
        this.m_rightLabel.setMinimumSize(this.m_rightLabel.getPreferredSize());
        this.m_rightLabel.setMaximumSize(this.m_rightLabel.getPreferredSize());
        int topWidth = this.getToolkit().getFontMetrics(this.m_topLabel.getFont()).stringWidth(this.m_topLabel.getText());
        int bottomWidth = this.getToolkit().getFontMetrics(this.m_bottomLabel.getFont()).stringWidth(this.m_bottomLabel.getText());
        width = topWidth;
        if (bottomWidth > width) {
            width = bottomWidth;
        }
        this.m_topLabel.setPreferredSize(new Dimension(width, this.m_topLabel.getPreferredSize().height));
        this.m_topLabel.setMinimumSize(new Dimension(width, this.m_topLabel.getPreferredSize().height));
        this.m_topLabel.setMaximumSize(new Dimension(width, this.m_topLabel.getPreferredSize().height));
        this.m_bottomLabel.setPreferredSize(new Dimension(width, this.m_bottomLabel.getPreferredSize().height));
        this.m_bottomLabel.setMinimumSize(new Dimension(width, this.m_bottomLabel.getPreferredSize().height));
        this.m_bottomLabel.setMaximumSize(new Dimension(width, this.m_bottomLabel.getPreferredSize().height));
        this.backgroundColorPanel.setMinimumSize(this.backgroundColorPanel.getPreferredSize());
        this.backgroundColorPanel.setMaximumSize(this.backgroundColorPanel.getPreferredSize());
        this.bordersRightAndBottomPanel.setMinimumSize(this.bordersRightAndBottomPanel.getPreferredSize());
        this.bordersRightAndBottomPanel.setMaximumSize(this.bordersRightAndBottomPanel.getPreferredSize());
        this.bordersLeftAndTopPanel.setMinimumSize(this.bordersLeftAndTopPanel.getPreferredSize());
        this.bordersLeftAndTopPanel.setMaximumSize(this.bordersLeftAndTopPanel.getPreferredSize());
        this.bordersOutlinePanel.setMinimumSize(this.bordersOutlinePanel.getPreferredSize());
        this.bordersOutlinePanel.setMaximumSize(this.bordersOutlinePanel.getPreferredSize());
        this.panelWidth = Math.max(this.m_bordersPanel.getPreferredSize().width, this.m_backgroundPanel.getPreferredSize().width);
        this.m_backgroundPanel.setPreferredSize(new Dimension(this.panelWidth, this.m_backgroundPanel.getPreferredSize().height));
        this.m_backgroundPanel.setMinimumSize(this.m_backgroundPanel.getPreferredSize());
        this.m_backgroundPanel.setMaximumSize(this.m_backgroundPanel.getPreferredSize());
        this.m_bordersPanel.setPreferredSize(new Dimension(this.panelWidth, this.m_bordersPanel.getPreferredSize().height));
        this.m_bordersPanel.setMinimumSize(this.m_bordersPanel.getPreferredSize());
        this.m_bordersPanel.setMaximumSize(this.m_bordersPanel.getPreferredSize());
        this.formatNamePanel.setPreferredSize(new Dimension(this.panelWidth, this.formatNamePanel.getPreferredSize().height));
        this.formatNamePanel.setMinimumSize(this.formatNamePanel.getPreferredSize());
        this.formatNamePanel.setMaximumSize(this.formatNamePanel.getPreferredSize());
        this.panelWidth += 20;
    }
}

