/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.awt.Color;
import java.awt.Image;
import java.beans.BeanInfo;
import java.beans.VetoableChangeListener;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.painter.Painter;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerActions;
import oracle.dss.dataView.DataListener;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.DataviewDefaultValues;
import oracle.dss.dataView.Model;
import oracle.dss.dataView.ModelListener;
import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.dataView.TokenSubstitutionAdapter;
import oracle.dss.dataView.UIDataviewAdapter;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.FormatModel;
import oracle.dss.gridView.GridViewCommon;
import oracle.dss.gridView.GridViewData;
import oracle.dss.gridView.GridViewDatabody;
import oracle.dss.gridView.GridViewDatabodyStyleManager;
import oracle.dss.gridView.GridViewDefaultValues;
import oracle.dss.gridView.GridViewExcelHTMLExport;
import oracle.dss.gridView.GridViewFormatManager;
import oracle.dss.gridView.GridViewHeader;
import oracle.dss.gridView.GridViewHeaderStyleManager;
import oracle.dss.gridView.GridViewSizingManager;
import oracle.dss.gridView.UIGridView;
import oracle.dss.pagingControl.ViewPagingControl;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.Rule;
import oracle.dss.rules.RuleBundle;
import oracle.dss.util.ComponentInfo;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataChangedEvent;
import oracle.dss.util.DataDirector;
import oracle.dss.util.DataSource;
import oracle.dss.util.DefaultErrorHandler;
import oracle.dss.util.ErrorHandler;

public abstract class UIGridViewAdapter
extends UIDataviewAdapter
implements UIGridView {
    protected MyDatabody m_databody;
    protected MyPagingControl m_pagingControl;
    protected Image m_image = null;
    protected boolean m_grid3D;
    protected boolean m_hGridVisible;
    protected boolean m_vGridVisible;
    protected Color m_gridColor;
    protected Color m_vGridColor;
    protected Color m_hGridColor;
    protected TokenSubstitution m_token = null;
    protected MyHeader m_rowHeader;
    protected MyHeader m_colHeader;
    protected GridViewHeaderStyleManager m_headerStyleManager;
    protected GridViewDatabodyStyleManager m_databodyStyleManager;
    protected GridViewFormatManager m_viewFormatManager;
    protected Model m_model = null;
    protected ResourceBundle rBundle = null;
    protected FormatModel m_formatModel = null;
    protected int m_scope;
    private boolean m_colHeaderVisible;
    private boolean m_rowHeaderVisible;
    private String[] m_layerMetadataLabelTypes = null;
    private String[] m_memberMetadataLabelTypes = null;
    protected int m_formatCount = 0;
    protected int m_toolbarFormatCount = 0;
    protected Vector m_UIFormats = null;
    protected ViewFormat m_viewFormat = null;
    protected String m_badColor = GridViewDefaultValues.getBadColor();
    protected String m_warningColor = GridViewDefaultValues.getWarningColor();
    protected String m_goodColor = GridViewDefaultValues.getGoodColor();
    protected boolean m_isHideData = GridViewDefaultValues.isHideData();
    private static final String m_method_setLocale = "setLocale (Locale loc)";
    private static final String m_method_getMemberMetadataLabelType = "public String getMemberMetadataLabelType(int edge)";
    private static final String m_method_getLayerMetadataLabelType = "public String getLayerMetadataLabelType(int edge)";

    public UIGridViewAdapter() {
        this.initUIGridViewAdapter();
    }

    public UIGridViewAdapter(UIGridView gridView) {
        this();
        this.initFromGridView(gridView);
    }

    protected void initUIGridViewAdapter() {
        this._initDefaults();
        this.m_databody = new MyDatabody();
        this.m_pagingControl = new MyPagingControl();
        this.m_pagingControl.setViewStyle(new ViewStyle());
        this.m_rowHeader = new MyHeader();
        this.m_colHeader = new MyHeader();
        this.m_headerStyleManager = new MyHeaderStyleManager();
        this.m_databodyStyleManager = new MyDatabodyStyleManager();
        this.m_viewFormatManager = new MyViewFormatManager();
        this.m_model = new MyModel();
        this.m_token = new TokenSubstitutionAdapter(this);
        this.m_errorHandler = new DefaultErrorHandler();
    }

    private void _initDefaults() {
        this.m_grid3D = GridViewDefaultValues.isGrid3D();
        this.m_hGridVisible = GridViewDefaultValues.isHGridVisible();
        this.m_vGridVisible = GridViewDefaultValues.isVGridVisible();
        this.m_gridColor = new Color(GridViewDefaultValues.getGridColor());
        this.m_vGridColor = new Color(GridViewDefaultValues.getGridColor());
        this.m_hGridColor = new Color(GridViewDefaultValues.getGridColor());
        this.m_colHeaderVisible = GridViewDefaultValues.isColumnHeaderVisible();
        this.m_rowHeaderVisible = GridViewDefaultValues.isRowHeaderVisible();
        this.m_formatCount = GridViewDefaultValues.getUIFormatCount();
        this.m_toolbarFormatCount = GridViewDefaultValues.getToolbarUIFormatCount();
        this.m_scope = GridViewDefaultValues.getAutoFitScope();
        this.m_memberMetadataLabelTypes = new String[3];
        this.m_layerMetadataLabelTypes = new String[3];
        for (int edge = 0; edge < 3; ++edge) {
            this.m_memberMetadataLabelTypes[edge] = DataviewDefaultValues.getMemberMetadataLabelType(edge);
            this.m_layerMetadataLabelTypes[edge] = DataviewDefaultValues.getLayerMetadataLabelType(edge);
        }
    }

    @Override
    public void setAutoFitScope(int scope) {
        this.m_scope = scope;
    }

    @Override
    public int getAutoFitScope() {
        return this.m_scope;
    }

    @Override
    public void dataAndMetadataStyleChanged() {
    }

    @Override
    public void dataStyleAndFormatAndMetadataStyleChanged() {
    }

    @Override
    public void setBackgroundImage(Image image) {
        this.m_image = image;
    }

    @Override
    public Image getBackgroundImage() {
        return this.m_image;
    }

    @Override
    public void setGrid3D(boolean b) {
        this.m_grid3D = b;
    }

    @Override
    public boolean isGrid3D() {
        return this.m_grid3D;
    }

    @Override
    public void setGridColor(Color color) {
        this.m_gridColor = color;
    }

    @Override
    public Color getGridColor() {
        return this.m_gridColor;
    }

    @Override
    public void setVGridColor(Color color) {
        this.m_vGridColor = color;
    }

    @Override
    public void setHGridColor(Color color) {
        this.m_hGridColor = color;
    }

    @Override
    public Color getVGridColor() {
        return this.m_vGridColor;
    }

    @Override
    public Color getHGridColor() {
        return this.m_hGridColor;
    }

    @Override
    public void setHGridVisible(boolean b) {
        this.m_hGridVisible = b;
    }

    @Override
    public boolean isHGridVisible() {
        return this.m_hGridVisible;
    }

    @Override
    public void setVGridVisible(boolean b) {
        this.m_vGridVisible = b;
    }

    @Override
    public boolean isVGridVisible() {
        return this.m_vGridVisible;
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        try {
            this.rBundle = locale != null ? ResourceBundle.getBundle("oracle.dss.gridView.resource.GridViewBundle", locale) : ResourceBundle.getBundle("oracle.dss.gridView.resource.GridViewBundle");
        }
        catch (MissingResourceException e) {
            this.getErrorHandler().error((Throwable)e, this.getClass().getName(), m_method_setLocale);
            this.rBundle = null;
        }
    }

    @Override
    public GridViewDatabody getDatabody() {
        return this.m_databody;
    }

    @Override
    public GridViewHeader getColumnHeader() {
        return this.m_colHeader;
    }

    @Override
    public GridViewHeader getRowHeader() {
        return this.m_rowHeader;
    }

    @Override
    public ViewPagingControl getPagingControl() {
        return this.m_pagingControl;
    }

    @Override
    public void setColumnHeaderVisible(boolean visible) {
        this.m_colHeaderVisible = visible;
    }

    @Override
    public boolean isColumnHeaderVisible() {
        return this.m_colHeaderVisible;
    }

    @Override
    public void setRowHeaderVisible(boolean visible) {
        this.m_rowHeaderVisible = visible;
    }

    @Override
    public boolean isRowHeaderVisible() {
        return this.m_rowHeaderVisible;
    }

    @Override
    public GridViewHeaderStyleManager getGridViewHeaderStyleManager() {
        return this.m_headerStyleManager;
    }

    @Override
    public GridViewDatabodyStyleManager getGridViewDatabodyStyleManager() {
        return this.m_databodyStyleManager;
    }

    @Override
    public GridViewFormatManager getGridViewFormatManager() {
        return this.m_viewFormatManager;
    }

    @Override
    public Model getModel() {
        return this.m_model;
    }

    @Override
    public ViewFormat getViewFormat() {
        return this.m_viewFormat;
    }

    @Override
    public ViewFormat getComponentViewFormat(ComponentHandle componentHandle) {
        return null;
    }

    @Override
    public ViewStyle getComponentViewStyle(ComponentHandle componentHandle) {
        return null;
    }

    @Override
    public boolean compareComponentViewStyle(ComponentHandle componentHandle, ViewStyle viewStyle) {
        return false;
    }

    @Override
    public boolean compareComponentViewFormat(ComponentHandle componentHandle, ViewFormat viewFormat) {
        return false;
    }

    @Override
    public void applyViewFormat(ComponentHandle componentHandle, ViewFormat viewFormat) {
    }

    @Override
    public void applyViewStyle(ComponentHandle componentHandle, ViewStyle viewStyle) {
    }

    @Override
    public void updateSizes(int type) {
    }

    @Override
    public void doSizing() {
    }

    @Override
    public int getCellMaxHeight() {
        return 0;
    }

    @Override
    public int getCellMinHeight() {
        return 0;
    }

    @Override
    public int getCellMaxWidth() {
        return 0;
    }

    @Override
    public int getCellMinWidth() {
        return 0;
    }

    @Override
    public Object getComponentFromID(int ID) {
        return null;
    }

    @Override
    public void setDefaultCornerComponentColor(Color c) {
    }

    @Override
    public boolean isDataViewStyleSupported() {
        return true;
    }

    @Override
    public boolean isDataFormattedSupported() {
        return true;
    }

    @Override
    public boolean isDataIsTotalSupported() {
        return true;
    }

    @Override
    public boolean isMetadataLongLabelSupported() {
        return true;
    }

    @Override
    public boolean isMetadataMediumLabelSupported() {
        return true;
    }

    @Override
    public boolean isMetadataValueSupported() {
        return true;
    }

    @Override
    public boolean isLayerMetaLongLabelSupported() {
        return true;
    }

    @Override
    public boolean isLayerMetaMediumLabelSupported() {
        return true;
    }

    @Override
    public boolean isLayerMetaNameSupported() {
        return true;
    }

    @Override
    public void setBanding(int banding) {
    }

    @Override
    public int getBanding() {
        return -1;
    }

    @Override
    public void setHTMLColumnSizing(int htmlColumnSizing) {
    }

    @Override
    public int getHTMLColumnSizing() {
        return -1;
    }

    @Override
    public void setHTMLRowBlockSize(int size) {
    }

    @Override
    public int getHTMLRowBlockSize() {
        return -1;
    }

    @Override
    public Integer getHTMLTableCellPadding() {
        return null;
    }

    @Override
    public void setHTMLTableCellPadding(Integer padding) {
    }

    @Override
    public String getHTMLTableWidth() {
        return null;
    }

    @Override
    public void setHTMLTableWidth(String width) {
    }

    @Override
    public void setHTMLTextInputSize(int size) {
    }

    @Override
    public int getHTMLTextInputSize() {
        return -1;
    }

    @Override
    public int getUIFormatCount() {
        return this.m_formatCount;
    }

    @Override
    public void setUIFormatCount(int count) {
        this.m_formatCount = count;
    }

    @Override
    public int getToolbarUIFormatCount() {
        return this.m_toolbarFormatCount;
    }

    @Override
    public void setToolbarUIFormatCount(int count) {
        this.m_toolbarFormatCount = count;
    }

    @Override
    public void setUIFormats(Vector formats) {
        this.m_UIFormats = formats;
    }

    @Override
    public Vector getUIFormats() {
        return this.m_UIFormats;
    }

    @Override
    public String getBadColor() {
        return this.m_badColor;
    }

    @Override
    public void setBadColor(String color) {
        this.m_badColor = color;
    }

    @Override
    public String getWarningColor() {
        return this.m_warningColor;
    }

    @Override
    public void setWarningColor(String color) {
        this.m_warningColor = color;
    }

    @Override
    public String getGoodColor() {
        return this.m_goodColor;
    }

    @Override
    public void setGoodColor(String color) {
        this.m_goodColor = color;
    }

    @Override
    public boolean isHideData() {
        return this.m_isHideData;
    }

    @Override
    public void setHideData(boolean hide) {
        this.m_isHideData = hide;
    }

    @Override
    public FormatModel getFormatModel() {
        return this.m_formatModel;
    }

    @Override
    public void setFormatModel(FormatModel model) {
        this.m_formatModel = model;
    }

    @Override
    public String getMemberMetadataLabelType(int edge) {
        if (!this._isEdgeValid(edge)) {
            this.getErrorHandler().log("invalid edge", this.getClass().getName(), m_method_getMemberMetadataLabelType);
            return null;
        }
        return this.m_memberMetadataLabelTypes[edge];
    }

    @Override
    public String getLayerMetadataLabelType(int edge) {
        if (!this._isEdgeValid(edge)) {
            this.getErrorHandler().log("invalid edge", this.getClass().getName(), m_method_getLayerMetadataLabelType);
            return null;
        }
        return this.m_layerMetadataLabelTypes[edge];
    }

    @Override
    public GridViewSizingManager getGridViewSizingManager() {
        return null;
    }

    @Override
    public Color getCornerComponentColor() {
        return null;
    }

    @Override
    public GridViewExcelHTMLExport getGridViewExcelHTMLExport() {
        return null;
    }

    @Override
    public boolean startExport() {
        return false;
    }

    @Override
    public void endExport() {
    }

    @Override
    public ViewStyle getDatabodyViewStyle() {
        return this.getDatabody().getViewStyle();
    }

    @Override
    public ViewStyle getColumnHeaderViewStyle() {
        return this.getColumnHeader().getViewStyle();
    }

    @Override
    public ViewStyle getRowHeaderViewStyle() {
        return this.getRowHeader().getViewStyle();
    }

    @Override
    public ViewStyle getPagingControlViewStyle() {
        return this.getPagingControl().getViewStyle();
    }

    @Override
    public int getPagingControlPosition() {
        return -1;
    }

    @Override
    public boolean isCellEditingAllowed() {
        return false;
    }

    private boolean _isEdgeValid(int edge) {
        return edge == 0 || edge == 1 || edge == 2;
    }

    public void initFromGridView(UIGridView gridview) {
        super.initFromDataview(gridview);
        this.setHGridVisible(gridview.isHGridVisible());
        this.setVGridVisible(gridview.isVGridVisible());
        this.setGrid3D(gridview.isGrid3D());
        this.setVGridColor(gridview.getVGridColor());
        this.setHGridColor(gridview.getHGridColor());
        this.getDatabody().setViewStyle(gridview.getDatabody().getViewStyle());
        this.setViewFormat(gridview.getViewFormat());
        this.setAutoFitScope(gridview.getAutoFitScope());
        this.setBackgroundImage(gridview.getBackgroundImage());
        this.getPagingControl().setViewStyle(gridview.getPagingControl().getViewStyle());
        this.getRowHeader().setViewStyle(gridview.getRowHeader().getViewStyle());
        this.getColumnHeader().setViewStyle(gridview.getColumnHeader().getViewStyle());
        this.setColumnHeaderVisible(gridview.isColumnHeaderVisible());
        this.setRowHeaderVisible(gridview.isRowHeaderVisible());
        this.m_model.setDataAccess(gridview.getModel().getDataAccess());
        this.m_model.setDataDirector(gridview.getModel().getDataDirector());
        this.m_model.setDataSource(gridview.getModel().getDataSource());
        if (gridview.getGridViewHeaderStyleManager() != null) {
            this.m_headerStyleManager.setUIBundle(this, gridview.getGridViewHeaderStyleManager().getUIBundle());
        }
        if (gridview.getGridViewDatabodyStyleManager() != null) {
            this.m_databodyStyleManager.setUIBundle(this, gridview.getGridViewDatabodyStyleManager().getUIBundle());
        }
        if (gridview.getGridViewFormatManager() != null) {
            this.m_viewFormatManager.setUIBundle(this, gridview.getGridViewFormatManager().getUIBundle());
        }
        this.setFormatModel(gridview.getFormatModel());
        this.setUIFormatCount(gridview.getUIFormatCount());
        this.setToolbarUIFormatCount(gridview.getToolbarUIFormatCount());
        this.setUIFormats(gridview.getUIFormats());
    }

    public void applyToGridView(UIGridView gridview) {
        super.applyToDataview(gridview);
        gridview.setAutoFitScope(0);
        gridview.setHGridVisible(this.isHGridVisible());
        gridview.setVGridVisible(this.isVGridVisible());
        gridview.setGrid3D(this.isGrid3D());
        gridview.setVGridColor(this.getVGridColor());
        gridview.setHGridColor(this.getHGridColor());
        gridview.getDatabody().getViewStyle().merge((Mergeable)this.getDatabody().getViewStyle());
        gridview.getViewFormat().merge((Mergeable)this.getViewFormat());
        gridview.setBackgroundImage(this.getBackgroundImage());
        gridview.getPagingControl().getViewStyle().merge((Mergeable)this.getPagingControl().getViewStyle());
        gridview.getRowHeader().getViewStyle().merge((Mergeable)this.getRowHeader().getViewStyle());
        gridview.getColumnHeader().getViewStyle().merge((Mergeable)this.getColumnHeader().getViewStyle());
        gridview.setColumnHeaderVisible(this.isColumnHeaderVisible());
        gridview.setRowHeaderVisible(this.isRowHeaderVisible());
        gridview.setUIFormatCount(this.getUIFormatCount());
        gridview.setToolbarUIFormatCount(this.getToolbarUIFormatCount());
        gridview.setUIFormats(this.getUIFormats());
        FormatModel model = this.getFormatModel();
        model.setGridView(gridview);
        gridview.setFormatModel(model);
        if (gridview.getGridViewHeaderStyleManager() != null) {
            gridview.getGridViewHeaderStyleManager().setUIBundle(gridview, this.getGridViewHeaderStyleManager().getUIBundle());
        }
        if (gridview.getGridViewDatabodyStyleManager() != null) {
            gridview.getGridViewDatabodyStyleManager().setUIBundle(gridview, this.getGridViewDatabodyStyleManager().getUIBundle());
        }
        if (gridview.getGridViewFormatManager() != null) {
            gridview.getGridViewFormatManager().setUIBundle(gridview, this.getGridViewFormatManager().getUIBundle());
        }
        gridview.setAutoFitScope(this.m_scope);
        gridview.dataAndMetadataStyleChanged();
    }

    protected void setViewFormat(ViewFormat vf) {
        this.m_viewFormat = (ViewFormat)((Object)vf.clone());
    }

    @Override
    public String getIntlGridViewString(String key) {
        return null;
    }

    protected class MyModel
    implements Model {
        private DataAccess dataAccess;
        private DataDirector dataDirector;
        private DataSource dataSource;

        protected MyModel() {
        }

        @Override
        public void addModelListener(ModelListener l) {
        }

        @Override
        public void removeModelListener(ModelListener l) {
        }

        @Override
        public void addDataListener(DataListener l) {
        }

        @Override
        public void removeDataListener(DataListener l) {
        }

        @Override
        public boolean pivotGestureHappened(Object source, int fromEdge, int toEdge, int fromLayer, int toLayer, int flags) {
            return false;
        }

        @Override
        public boolean canPivot(Object source, int fromEdge, int toEdge, int fromLayer, int toLayer, int flags) {
            return false;
        }

        @Override
        public boolean drillGestureHappened(Object source, int edge, int layer, int slice, int flags) {
            return false;
        }

        @Override
        public boolean canDrill(Object source, int edge, int layer, int slice, int flags) {
            return false;
        }

        @Override
        public boolean pageChangeHappened(Object source, int pos) {
            return false;
        }

        @Override
        public boolean pageChangeHappened(Object source, int[] hPos, int maxLayerSpecified) {
            return false;
        }

        @Override
        public void setDataSource(DataSource ds) {
            this.dataSource = ds;
        }

        @Override
        public DataSource getDataSource() {
            return this.dataSource;
        }

        @Override
        public void setDataDirector(DataDirector dd) {
            this.dataDirector = dd;
        }

        @Override
        public DataDirector getDataDirector() {
            return this.dataDirector;
        }

        @Override
        public void setDataAccess(DataAccess dp) {
            this.dataAccess = dp;
        }

        @Override
        public DataAccess getDataAccess() {
            return this.dataAccess;
        }

        @Override
        public void setDrillingEnabled(boolean b) {
        }

        @Override
        public boolean isDrillingEnabled() {
            return false;
        }

        @Override
        public void setErrorHandler(ErrorHandler eh) {
        }

        @Override
        public ErrorHandler getErrorHandler() {
            return null;
        }

        @Override
        public ControllerActions getControllerActions() {
            return null;
        }

        @Override
        public void viewDataChanged(DataChangedEvent e) {
        }
    }

    protected class MyViewFormatManager
    implements GridViewFormatManager {
        private RuleBundle m_UIBundle;

        protected MyViewFormatManager() {
        }

        @Override
        public void valueFormatChanged() {
        }

        @Override
        public void metadataFormatChanged() {
        }

        @Override
        public String formatMetadataValue(GridViewCommon view, Object data, int edge, int depth, int index, ViewFormat vf) {
            return null;
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return null;
        }

        @Override
        public ViewFormat getDataCellViewFormat(GridViewCommon view, int row, int column) {
            return null;
        }

        @Override
        public Object formatDataValue(DataviewCommon view, Object data, int column, int row, int[] pageHPos, ViewFormat vf) {
            return null;
        }

        @Override
        public void setBundles(DataviewCommon view, Vector bundles) {
        }

        @Override
        public Vector getBundles() {
            return null;
        }

        @Override
        public RuleBundle getUIBundle() {
            return this.m_UIBundle;
        }

        @Override
        public void setUIBundle(DataviewCommon view, RuleBundle bundle) {
            this.m_UIBundle = bundle;
        }

        @Override
        public void dataSourceChanged() {
        }
    }

    protected class MyDatabodyStyleManager
    implements GridViewDatabodyStyleManager {
        private RuleBundle m_UIBundle = null;

        protected MyDatabodyStyleManager() {
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return null;
        }

        @Override
        public void setUIBundle(DataviewCommon view, RuleBundle UIBundle2) {
            this.m_UIBundle = UIBundle2;
        }

        @Override
        public RuleBundle getUIBundle() {
            return this.m_UIBundle;
        }

        @Override
        public void setBundles(DataviewCommon view, Vector bundles) {
        }

        @Override
        public Vector getBundles() {
            return null;
        }

        @Override
        public void dataStyleChanged() {
        }

        @Override
        public ViewStyle getDataStyle(GridViewCommon view, Object data, ViewStyle initStyle, int row, int column, int[] pageHPos) {
            return null;
        }

        @Override
        public void dataSourceChanged() {
        }
    }

    protected class MyHeaderStyleManager
    implements GridViewHeaderStyleManager {
        private RuleBundle m_UIBundle = null;

        protected MyHeaderStyleManager() {
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return null;
        }

        public void addRule(Dataview view, Rule rule) {
        }

        @Override
        public void setUIBundle(DataviewCommon view, RuleBundle UIBundle2) {
            this.m_UIBundle = UIBundle2;
        }

        @Override
        public RuleBundle getUIBundle() {
            return this.m_UIBundle;
        }

        @Override
        public void setBundles(DataviewCommon view, Vector bundles) {
        }

        @Override
        public Vector getBundles() {
            return null;
        }

        @Override
        public void metadataStyleChanged() {
        }

        @Override
        public ViewStyle getMetadataStyle(GridViewCommon view, Object metaData, ViewStyle initStyle, int edge, int depth, int index) {
            return null;
        }

        @Override
        public void dataSourceChanged() {
        }
    }

    protected class MyHeader
    implements GridViewHeader {
        private ViewStyle defaultViewStyle = new ViewStyle();

        @Override
        public void clearCache() {
        }

        @Override
        public void addVetoableChangeListener(VetoableChangeListener listener) {
        }

        @Override
        public void removeVetoableChangeListener(VetoableChangeListener listener) {
        }

        @Override
        public int getColumnCount() {
            return 0;
        }

        @Override
        public int getRowCount() {
            return 0;
        }

        @Override
        public Appearance getDefaultAppearance() {
            return null;
        }

        @Override
        public int getID() {
            return -1;
        }

        @Override
        public String getComponentName() {
            return null;
        }

        @Override
        public BeanInfo getBeanInfo() {
            return null;
        }

        @Override
        public ComponentInfo getCellFocus() {
            return null;
        }

        @Override
        public void setCellFocus(ComponentInfo focusedCell) {
        }

        @Override
        public void setViewStyle(ViewStyle viewstyle) {
            this.defaultViewStyle = new ViewStyle(null, viewstyle);
        }

        @Override
        public ViewStyle getViewStyle() {
            return this.defaultViewStyle;
        }
    }

    protected class MyPagingControl
    extends ViewPagingControl {
        private static final long serialVersionUID = 1L;
        private ViewStyle m_viewStyle;

        public MyPagingControl() {
            super((Dataview)null);
        }

        @Override
        public void setViewStyle(ViewStyle vs) {
            this.m_viewStyle = vs;
        }

        @Override
        public ViewStyle getViewStyle() {
            return this.m_viewStyle;
        }
    }

    protected class MyDatabody
    implements GridViewDatabody {
        private ViewStyle defaultViewStyle = new ViewStyle();

        @Override
        public ViewStyle getViewStyle() {
            return this.defaultViewStyle;
        }

        @Override
        public void setViewStyle(ViewStyle vs) {
            ViewStyle oldval = this.defaultViewStyle;
            this.defaultViewStyle = new ViewStyle(null, vs);
        }

        @Override
        public ComponentInfo getCellFocus() {
            return null;
        }

        @Override
        public void setCellFocus(ComponentInfo focusedCell) {
        }

        @Override
        public GridViewData getGridViewData() {
            return null;
        }

        @Override
        public void clearCache() {
        }

        @Override
        public void addVetoableChangeListener(VetoableChangeListener listener) {
        }

        @Override
        public void removeVetoableChangeListener(VetoableChangeListener listener) {
        }

        @Override
        public Image getGraphicImage(int column, int row) {
            return null;
        }

        @Override
        public boolean isDrillOut(int column, int row, int x, int y) {
            return false;
        }

        @Override
        public boolean isAnnotation(int column, int row, int x, int y) {
            return false;
        }

        @Override
        public Appearance getDefaultAppearance() {
            return null;
        }

        @Override
        public float getGraphicBarRatio(int column, int row) {
            return 0.0f;
        }

        @Override
        public int getID() {
            return -1;
        }

        @Override
        public String getComponentName() {
            return null;
        }

        @Override
        public BeanInfo getBeanInfo() {
            return null;
        }

        @Override
        public void setHorizontalSeparatorPainter(Painter painter) {
        }

        @Override
        public Painter getHorizontalSeparatorPainter() {
            return null;
        }

        @Override
        public void setVerticalSeparatorPainter(Painter painter) {
        }

        @Override
        public Painter getVerticalSeparatorPainter() {
            return null;
        }
    }
}

