/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dss.dataView.CSSStyleDefaults;
import oracle.dss.dataView.ColumnComponentHandle;
import oracle.dss.dataView.ColumnRangeComponentHandle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.DataRangeComponentHandle;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.Footnote;
import oracle.dss.dataView.RowComponentHandle;
import oracle.dss.dataView.RowRangeComponentHandle;
import oracle.dss.dataView.Subtitle;
import oracle.dss.dataView.Title;
import oracle.dss.dataView.UIBundle;
import oracle.dss.dataView.managers.Formattable;
import oracle.dss.dataView.managers.Styleable;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.dataView.managers.ViewFormatCallback;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.AutoFitColumnRangeCallback;
import oracle.dss.gridView.AutoFitRowRangeCallback;
import oracle.dss.gridView.CustomAnnotationCallback;
import oracle.dss.gridView.ExportProgressListener;
import oracle.dss.gridView.FormatModel;
import oracle.dss.gridView.GridViewCommon;
import oracle.dss.gridView.GridViewController;
import oracle.dss.gridView.GridViewDataListener;
import oracle.dss.gridView.GridViewDatabody;
import oracle.dss.gridView.GridViewDatabodyStyleManager;
import oracle.dss.gridView.GridViewDefaultValues;
import oracle.dss.gridView.GridViewEdit;
import oracle.dss.gridView.GridViewExcelHTMLExport;
import oracle.dss.gridView.GridViewFormatManager;
import oracle.dss.gridView.GridViewHeader;
import oracle.dss.gridView.GridViewHeaderStyleManager;
import oracle.dss.gridView.GridViewModel;
import oracle.dss.gridView.GridViewSelectionManager;
import oracle.dss.gridView.GridViewSizingManager;
import oracle.dss.gridView.GridViewTable;
import oracle.dss.gridView.GridViewUtils;
import oracle.dss.gridView.GridViewXML;
import oracle.dss.gridView.GridlinePainter;
import oracle.dss.gridView.UIFormat;
import oracle.dss.gridView.UIGridView;
import oracle.dss.gridView.managers.GridViewDatabodyRuleStyles;
import oracle.dss.gridView.managers.GridViewHeaderRuleStyles;
import oracle.dss.gridView.managers.GridViewRuleFormatter;
import oracle.dss.pagingControl.ViewPagingControl;
import oracle.dss.rules.Rule;
import oracle.dss.rules.RuleBundle;
import oracle.dss.util.ColumnComponentInfo;
import oracle.dss.util.ComponentInfo;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataAvailableEvent;
import oracle.dss.util.DataChangedEvent;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.DataException;
import oracle.dss.util.Range;
import oracle.dss.util.RowComponentInfo;

public abstract class GridView
extends Dataview
implements UIGridView,
Formattable,
ViewFormatCallback,
GridViewCommon {
    private static final long serialVersionUID = 1L;
    public static final int DATABODY = 9;
    public static final int COL_HEADER = 10;
    public static final int ROW_HEADER = 11;
    public static final int DATA_CELL = 12;
    public static final int DATABODY_HIGHLIGHTER = 13;
    public static final int DATA_COLUMN = 14;
    public static final int DATA_ROW = 15;
    public static final int DATA_CELL_RANGE = 16;
    public static final int COL_HEADER_RANGE = 17;
    public static final int ROW_HEADER_RANGE = 18;
    public static final int DATA_COLUMN_RANGE = 19;
    public static final int DATA_ROW_RANGE = 20;
    protected static final int GRIDVIEW_END = 21;
    private static boolean DEBUG = false;
    private ResourceBundle localStrings = null;
    private ResourceBundle utilStrings = null;
    public static final int FILL_WITH_HASHMARKS = 0;
    public static final int TRUNCATE_WITHOUT_ELLIPSIS = 1;
    public static final int TRUNCATE_WITH_ELLIPSIS = 2;
    public static final String fill_with_hashmarks = "FILL_WITH_HASHMARKS";
    public static final String truncate_without_ellipsis = "TRUNCATE_WITHOUT_ELLIPSIS";
    public static final String truncate_with_ellipsis = "TRUNCATE_WITH_ELLIPSIS";
    public static final int AUTOFIT_SCOPE_NONE = 0;
    public static final int AUTOFIT_SCOPE_ROW_HEIGHTS = 1;
    public static final int AUTOFIT_SCOPE_COLUMN_WIDTHS = 2;
    public static final int AUTOFIT_SCOPE_COLUMN_HEADER_ROW_HEIGHTS = 4;
    public static final int AUTOFIT_SCOPE_ROW_HEADER_COLUMN_WIDTHS = 8;
    public static final int AUTOFIT_SCOPE_ALL = 255;
    public static final int AUTOFIT_SCOPE_COLWDS_ROWHTS = 3;
    public static final int AUTOFIT_SCOPE_COLWDS_COLHDRROWHTS = 6;
    public static final int AUTOFIT_SCOPE_COLWDS_ROWHDRCOLWDS = 10;
    public static final int AUTOFIT_SCOPE_ROWHTS_COLHDRROWHTS = 5;
    public static final int AUTOFIT_SCOPE_ROWHTS_ROWHDRCOLWDS = 9;
    public static final int AUTOFIT_SCOPE_COLHDRROWHTS_ROWHDRCOLWDS = 12;
    public static final int AUTOFIT_SCOPE_COLWDS_ROWHTS_COLHDRROWHTS = 7;
    public static final int AUTOFIT_SCOPE_COLWDS_ROWHTS_ROWHDRCOLWDS = 11;
    public static final int AUTOFIT_SCOPE_COLWDS_COLHDRROWHTS_ROWHDRCOLWDS = 14;
    public static final int AUTOFIT_SCOPE_ROWHTS_COLHDRROWHTS_ROWHDRCOLWDS = 13;
    public static final String autofit_scope_none = "AUTOFIT_SCOPE_NONE";
    public static final String autofit_scope_row_heights = "AUTOFIT_SCOPE_ROW_HEIGHTS";
    public static final String autofit_scope_column_widths = "AUTOFIT_SCOPE_COLUMN_WIDTHS";
    public static final String autofit_scope_column_header_row_heights = "AUTOFIT_SCOPE_COLUMN_HEADER_ROW_HEIGHTS";
    public static final String autofit_scope_row_header_column_widths = "AUTOFIT_SCOPE_ROW_HEADER_COLUMN_WIDTHS";
    public static final String autofit_scope_all = "AUTOFIT_SCOPE_ALL";
    public static final String autofit_scope_colwds_rowhts = "AUTOFIT_SCOPE_COLWDS_ROWHTS";
    public static final String autofit_scope_colwds_colhdrrowhts = "AUTOFIT_SCOPE_COLWDS_COLHDRROWHTS";
    public static final String autofit_scope_colwds_rowhdrcolwds = "AUTOFIT_SCOPE_COLWDS_ROWHDRCOLWDS";
    public static final String autofit_scope_rowhts_colhdrrowhts = "AUTOFIT_SCOPE_ROWHTS_COLHDRROWHTS";
    public static final String autofit_scope_rowhts_rowhdrcolwds = "AUTOFIT_SCOPE_ROWHTS_ROWHDRCOLWDS";
    public static final String autofit_scope_colhdrrowhts_rowhdrcolwds = "AUTOFIT_SCOPE_COLHDRROWHTS_ROWHDRCOLWDS";
    public static final String autofit_scope_colwds_rowhts_colhdrrowhts = "AUTOFIT_SCOPE_COLWDS_ROWHTS_COLHDRROWHTS";
    public static final String autofit_scope_colwds_rowhts_rowhdrcolwds = "AUTOFIT_SCOPE_COLWDS_ROWHTS_ROWHDRCOLWDS";
    public static final String autofit_scope_colwds_colhdrrowhts_rowhdrcolwds = "AUTOFIT_SCOPE_COLWDS_COLHDRROWHTS_ROWHDRCOLWDS";
    public static final String autofit_scope_rowhts_colhdrrowhts_rowhdrcolwds = "AUTOFIT_SCOPE_ROWHTS_COLHDRROWHTS_ROWHDRCOLWDS";
    protected GridViewModel gridViewModel = null;
    protected GridViewController gridViewController = null;
    protected GridViewEdit editListener = new GridViewEdit(this);
    protected boolean cellEditingAllowed = GridViewDefaultValues.isCellEditingAllowed();
    protected int cellMaxHeight = GridViewDefaultValues.getCellMaxHeight();
    protected int cellMinHeight = GridViewDefaultValues.getCellMinHeight();
    protected int cellMaxWidth = GridViewDefaultValues.getCellMaxWidth();
    protected int cellMinWidth = GridViewDefaultValues.getCellMinWidth();
    protected int m_iAutoFitRowCount = GridViewDefaultValues.getAutoFitRowCount();
    protected int m_iAutoFitColumnCount = GridViewDefaultValues.getAutoFitColumnCount();
    protected AutoFitRowRangeCallback m_autoFitRowRangeCallback = null;
    protected AutoFitColumnRangeCallback m_autoFitColumnRangeCallback = null;
    protected int m_iAutoFitScope = GridViewDefaultValues.getAutoFitScope();
    protected boolean m_bManualRowSizingEnabled = GridViewDefaultValues.isManualRowSizingEnabled();
    protected boolean m_bManualColumnSizingEnabled = GridViewDefaultValues.isManualColumnSizingEnabled();
    protected int zoomFactor = GridViewDefaultValues.getZoomFactor();
    protected boolean updateHeights = true;
    protected boolean m_bResizeForDrillImages = true;
    protected boolean m_bMustReScroll = true;
    protected int m_lDesiredStartColumn = 0;
    protected int m_lDesiredStartRow = 0;
    protected int numericDataFormat = GridViewDefaultValues.getTruncatedNumericDataFormat();
    protected Image offscreenImage = null;
    protected JScrollPane scrollBox = null;
    protected Vector drillImages = null;
    protected Vector m_drillImagePaths = null;
    protected Vector graphicImages = null;
    protected Vector m_graphicImagePaths = null;
    protected Vector scaledDrillImages = null;
    protected Vector scaledGraphicImages = null;
    protected Image m_backgroundImage = null;
    protected String m_backgroundImagePath = GridViewDefaultValues.getBackgroundImagePath();
    protected boolean m_dataFormattedSupported = false;
    protected boolean m_dataRatioSupported = false;
    protected boolean m_dataViewStyleSupported = false;
    protected boolean m_dataAnnotationSupported = false;
    protected boolean m_dataIsTotalSupported = false;
    protected boolean m_metaDrillSupported = false;
    protected Vector invisibleColumn = new Vector();
    protected Vector invisibleRow = new Vector();
    protected int m_banding = GridViewDefaultValues.getBanding();
    protected int m_htmlColumnSizing = GridViewDefaultValues.getHTMLColumnSizing();
    protected int m_htmlRowBlockSize = GridViewDefaultValues.getHTMLRowBlockSize();
    protected int m_htmlColumnBlockSize = GridViewDefaultValues.getHTMLColumnBlockSize();
    protected Integer m_htmlTableCellPadding = GridViewDefaultValues.getHTMLTableCellPadding();
    protected String m_htmlTableWidth = GridViewDefaultValues.getHTMLTableWidth();
    protected int m_htmlTextInputSize = GridViewDefaultValues.getHTMLTextInputSize();
    protected int m_formatCount = 0;
    protected int m_toolbarFormatCount = 0;
    protected Vector m_UIFormats;
    protected FormatModel m_formatModel = null;
    protected String m_badColor = GridViewDefaultValues.getBadColor();
    protected String m_warningColor = GridViewDefaultValues.getWarningColor();
    protected String m_goodColor = GridViewDefaultValues.getGoodColor();
    protected boolean m_isHideData = GridViewDefaultValues.isHideData();
    protected transient String m_baseImageURI = "";
    protected transient Image m_annotationImage = null;
    protected String m_annotationImagePath = GridViewDefaultValues.getAnnotationImagePath();
    protected boolean m_annotationIconVisible = GridViewDefaultValues.isAnnotationIconVisible();
    protected CustomAnnotationCallback m_customAnnotationCallback = null;
    protected boolean m_annotationIconPrinted = GridViewDefaultValues.isAnnotationIconPrinted();
    protected boolean m_dataTypeSupported = false;
    private GridViewExportState m_exportState = null;
    private boolean m_bExporting = false;
    private transient boolean m_bLoadingViewFromPersistence = false;
    protected boolean xmlMode = false;
    protected transient int m_tmpStartColumn = -1;
    protected transient int m_tmpStartRow = -1;
    protected transient boolean m_bFocusRequestedForCell = true;
    private boolean m_bCornerComponentColorUsed = false;
    private boolean m_bImagesScaled = true;
    protected boolean m_bHeaderResizing = false;
    private boolean m_bDuringScroll = false;
    private boolean m_bScrollWaitCursor = false;
    private static final long SCROLL_WAIT_CURSOR_DELAY = 1000L;
    private DataFetchThread m_dataFetchThread = null;
    private DataFetchLock m_dataFetchLock = null;
    protected static final int NUMBER_DATE = 0;
    protected static final int DATE_ONLY = 1;
    protected static final int NUMBER_ONLY = 2;
    private static final String ANNOTATION_IMAGE_PATH = "images/commentind_active.gif";
    public static final String COL_HEADER_NAME = "ColumnHeader";
    public static final String ROW_HEADER_NAME = "RowHeader";
    public static final String DATA_CELL_NAME = "DataCell";
    public static final String DATA_CELL_RANGE_NAME = "DataCellRange";
    public static final String DATABODY_HIGHLIGHTER_NAME = "DatabodyHighlighter";
    public static final String DATA_ROW_NAME = "DataRow";
    public static final String DATA_COLUMN_NAME = "DataColumn";
    public static final String COL_HEADER_RANGE_NAME = "ColumnHeaderRange";
    public static final String ROW_HEADER_RANGE_NAME = "RowHeaderRange";
    public static final String DATABODY_NAME = "Databody";
    public static final String DATA_COLUMN_RANGE_NAME = "DataColumnRange";
    public static final String DATA_ROW_RANGE_NAME = "DataRowRange";
    public static final String INVISIBLE_COLUMNS_NAME = "InvisibleColumns";
    public static final String INVISIBLE_ROWS_NAME = "InvisibleRows";
    public static final String SIZING_MANAGER_NAME = "SizingManager";
    public static final String DRILL_IMAGES_PATHS_NAME = "DrillImagesPaths";
    public static final String GRAPHIC_IMAGES_PATHS_NAME = "GraphicImagesPaths";
    public static final String IMAGE_PATH_NAME = "ImagePath";
    public static final String col_header = "COL_HEADER";
    public static final String row_header = "ROW_HEADER";
    public static final String databody = "DATABODY";
    private static final String m_method_applyCSSStyleDefaults = "static void applyCSSStyleDefaults(GridViewCommon view, CSSStyleDefaults defaults)";
    private static final String m_method_setgridcolor = "setGridColor (Color color)";
    private static final String m_method_setVGridcolor = "setVGridColor (Color color)";
    private static final String m_method_setHGridcolor = "setHGridColor (Color color)";
    private static final String m_method_getGridColor = "getGridColor()";
    private static final String m_method_getVGridColor = "getVGridColor()";
    private static final String m_method_getHGridColor = "getHGridColor()";
    private static final String m_method_isGrid3D = "isGrid3D()";
    private static final String m_method_setcellmaxheight = "setCellMaxHeight (int height)";
    private static final String m_method_setcellmaxwidth = "setCellMaxWidth (int width)";
    private static final String m_method_setcellminheight = "setCellMinHeight (int height)";
    private static final String m_method_setcellminwidth = "setCellMinWidth (int width)";
    private static final String m_method_setgraphicimage = "setGraphicImage(int index, Image image, boolean bSetFromPath)";
    private static final String m_method_settruncatednumericdataformat = "setTruncatedNumericDataFormat (int format)";
    private static final String m_method_setdesiredstartrow = "setDesiredStartRow (int row)";
    private static final String m_method_setdesiredstartcolumn = "setDesiredStartColumn (int column)";
    private static final String m_method_getcolumnwidth = "getColumnWidth(int index)";
    private static final String m_method_getrowheight = "getRowHeight(int index)";
    private static final String m_method_formatChanged = "formatChanged(int attributeId, String attributeName, Object oldValue, Object newValue)";
    private static final String m_method_autoFitRowHeight = "autoFitRowHeight(int row)";
    private static final String m_method_setAutoFitRowCount = "setAutoFitRowCount(int rowCount)";
    private static final String m_method_getAutoFitRowRange = "getAutoFitRowRange(int firstRow)";
    private static final String m_method_setAutoFitColumnCount = "setAutoFitColumnCount(int colCount)";
    private static final String m_method_getAutoFitColumnRange = "getAutoFitColumnRange(int firstCol)";
    private static final String m_method_setAutoFitScope = "setAutoFitScope(int scope)";
    private static final String m_method_setLocale = "setLocale (Locale loc)";
    private static final String m_method_GridView = "GridView()";
    private static final String m_method_setViewFormat = "setViewFormat(ViewFormat vf)";
    private static final String m_method_updateSizes = "updateSizes(int type)";
    private static final String m_method_setBaseImageURI = "void setBaseImageURI(String baseImageURI)";
    private static final String m_method_setImagePath = "Image setImagePath(int index, String path, Vector imagePathsVector)";
    private static final String m_method_getImagePath = "String getImagePath(int index, Vector imagePathsVector)";
    private static final String m_method_setDrillImagePath = "void setDrillImagePath(int index, String path)";
    private static final String m_method_getDrillImagePath = "String getDrillImagePath(int index)";
    private static final String m_method_setBackgroundImagePath = "void setBackgroundImagePath(String path)";
    private static final String m_method_getAnnotationImage = "protected Image getAnnotationImage()";
    private static final String m_method_setAnnotationImagePath = "void setAnnotationImagePath(String path)";

    public GridView() {
        try {
            this.localStrings = this.getLocale() != null ? ResourceBundle.getBundle("oracle.dss.gridView.resource.GridViewBundle", this.getLocale()) : ResourceBundle.getBundle("oracle.dss.gridView.resource.GridViewBundle");
        }
        catch (MissingResourceException e) {
            this.getErrorHandler().error((Throwable)e, this.getClass().getName(), m_method_GridView);
            this.localStrings = null;
        }
        try {
            this.utilStrings = this.getLocale() != null ? ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle", this.getLocale()) : ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle");
        }
        catch (MissingResourceException e) {
            this.getErrorHandler().error((Throwable)e, this.getClass().getName(), m_method_GridView);
            this.utilStrings = null;
        }
        this.pagingControl = new ViewPagingControl(this);
        this.addSubcomponent(this.pagingControl);
        this.pagingControl.setVisible(GridViewDefaultValues.isPagingControlVisible());
        this.positionPagingControl(GridViewDefaultValues.getPagingControlPosition());
        this.drillImages = new Vector();
        this.m_drillImagePaths = new Vector();
        this.graphicImages = new Vector();
        this.m_graphicImagePaths = new Vector();
        this.scaledDrillImages = new Vector();
        this.scaledGraphicImages = new Vector();
        this.m_dataFetchThread = new DataFetchThread();
        this.m_dataFetchLock = new DataFetchLock();
        this.m_dataFetchThread.start();
    }

    public GridViewModel getGridViewModel() {
        return this.gridViewModel;
    }

    public void setGridViewModel(GridViewModel m) {
        super.setModel(m);
        GridViewModel oldModel = this.gridViewModel;
        this.gridViewModel = m;
        this.firePropertyChange(this, "GridViewModel", oldModel, this.gridViewModel);
    }

    public void setGridViewController(GridViewController c) {
        super.setController(c);
        GridViewController oldController = this.gridViewController;
        this.gridViewController = c;
        this.firePropertyChange(this, "GridViewController", oldController, this.gridViewController);
    }

    public GridViewController getGridViewController() {
        return this.gridViewController;
    }

    @Override
    public GridViewFormatManager getGridViewFormatManager() {
        if (this.getGridViewModel() != null) {
            return this.getGridViewModel().getGridViewFormatManager();
        }
        return null;
    }

    public void setGridViewFormatManager(GridViewFormatManager m) {
        if (this.gridViewModel != null) {
            GridViewFormatManager oldFm = this.gridViewModel.getGridViewFormatManager();
            this.gridViewModel.setGridViewFormatManager(m);
            this.firePropertyChange(this, "GridViewFormatManager", oldFm, m);
        }
    }

    public GridViewSelectionManager getGridViewSelectionManager() {
        if (this.getGridViewController() != null) {
            return this.getGridViewController().getGridViewSelectionManager();
        }
        return null;
    }

    @Override
    public GridViewSizingManager getGridViewSizingManager() {
        if (this.getGridViewController() != null) {
            return this.getGridViewController().getGridViewSizingManager();
        }
        return null;
    }

    @Override
    public GridViewHeaderStyleManager getGridViewHeaderStyleManager() {
        if (this.getGridViewModel() != null) {
            return this.getGridViewModel().getGridViewHeaderStyleManager();
        }
        return null;
    }

    @Override
    public GridViewDatabodyStyleManager getGridViewDatabodyStyleManager() {
        if (this.getGridViewModel() != null) {
            return this.getGridViewModel().getGridViewDatabodyStyleManager();
        }
        return null;
    }

    public void setGridViewHeaderStyleManager(GridViewHeaderStyleManager m) {
        if (this.gridViewModel != null) {
            GridViewHeaderStyleManager oldStyle = this.gridViewModel.getGridViewHeaderStyleManager();
            this.gridViewModel.setGridViewHeaderStyleManager(m);
            this.firePropertyChange(this, "GridViewHeaderStyleManager", oldStyle, m);
        }
    }

    public void setGridViewDatabodyStyleManager(GridViewDatabodyStyleManager m) {
        if (this.gridViewModel != null) {
            GridViewDatabodyStyleManager oldStyle = this.gridViewModel.getGridViewDatabodyStyleManager();
            this.gridViewModel.setGridViewDatabodyStyleManager(m);
            this.firePropertyChange(this, "GridViewDatabodyStyleManager", oldStyle, m);
        }
    }

    @Override
    public void dataStyleAndFormatAndMetadataStyleChanged() {
        this.getDatabody().clearCache();
        this.getRowHeader().clearCache();
        this.getColumnHeader().clearCache();
        this.getGridViewModel().clearMetadataCache();
        this.getGridViewModel().getGridViewDataSource().clearCache();
        this.updateRowHeaderWidths();
        this.updateColumnWidth();
        this.updateColumnHeaderRowHeights();
        this.updateRowHeights();
        this.updatePagingControlStyles();
        this.repaint();
    }

    @Override
    public void dataAndMetadataStyleChanged() {
        this.getDatabody().clearCache();
        this.getRowHeader().clearCache();
        this.getColumnHeader().clearCache();
        this.updateRowHeaderWidths();
        this.updateColumnWidth();
        this.updateColumnHeaderRowHeights();
        this.updateRowHeights();
        this.repaint();
        this.updatePagingControlStyles();
    }

    @Override
    public void metadataStyleChanged() {
        this.getRowHeader().clearCache();
        this.getColumnHeader().clearCache();
        this.updateRowHeaderWidths();
        this.updateColumnWidth();
        this.updateColumnHeaderRowHeights();
        this.updateRowHeights();
        this.repaint();
        this.updatePagingControlStyles();
    }

    @Override
    public void dataStyleChanged() {
        this.getDatabody().clearCache();
        this.updateColumnWidth();
        this.updateColumnHeaderRowHeights();
        this.updateRowHeights();
        this.repaint();
        this.updatePagingControlStyles();
    }

    public abstract void updateColumnWidth();

    @Override
    public void dataFormatChanged() {
        this.getGridViewModel().clearMetadataCache();
        this.getGridViewModel().getGridViewDataSource().clearCache();
        this.updateColumnWidth();
        this.updateColumnHeaderRowHeights();
        this.updateRowHeights();
        this.repaint();
    }

    @Override
    protected void metadataLabelTypeChanged() {
        super.metadataLabelTypeChanged();
        this.getGridViewModel().clearMetadataCache();
        this.updateRowHeaderWidths();
        this.updateColumnWidth();
        this.updateColumnHeaderRowHeights();
        this.updateRowHeights();
        this.repaint();
    }

    @Override
    public void setLocale(Locale loc) {
        GridViewFormatManager rf;
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        try {
            this.localStrings = loc != null ? ResourceBundle.getBundle("oracle.dss.gridView.resource.GridViewBundle", loc) : ResourceBundle.getBundle("oracle.dss.gridView.resource.GridViewBundle");
        }
        catch (MissingResourceException e) {
            this.getErrorHandler().error((Throwable)e, this.getClass().getName(), m_method_setLocale);
            this.localStrings = null;
        }
        if (this.getViewFormat() != null) {
            this.getViewFormat().setLocale(loc);
        }
        if (this.getGridViewModel() != null && this.getGridViewModel().getViewFormat() != null) {
            this.getGridViewModel().getViewFormat().setLocale(loc);
        }
        if ((rf = this.getGridViewFormatManager()) != null) {
            rf.valueFormatChanged();
        }
        if (this.getFormatModel() != null) {
            this.getFormatModel().setLocale(loc);
        }
    }

    @Override
    public void setViewFormat(ViewFormat vf) {
        if (vf == null) {
            this.getErrorHandler().log("invalid ViewFormat", this.getClass().getName(), m_method_setViewFormat);
            return;
        }
        if (this.gridViewModel != null) {
            ViewFormat oldVf = this.gridViewModel.getViewFormat();
            this.gridViewModel.setViewFormat(vf);
            this.getGridViewModel().getGridViewFormatManager().valueFormatChanged();
            this.getGridViewModel().getGridViewDataSource().clearCache();
            this.updateColumnWidth();
            this.updateColumnHeaderRowHeights();
            this.updateRowHeights();
            this.repaint();
            this.firePropertyChange(this, "ViewFormat", (Object)oldVf, (Object)vf);
        }
    }

    @Override
    public ViewFormat getViewFormat() {
        if (this.gridViewModel != null) {
            return this.gridViewModel.getViewFormat();
        }
        return null;
    }

    public void formatChanged(int attributeId, String attributeName, Object oldValue, Object newValue) {
        if (attributeId < 0 || attributeId > 37) {
            this.getErrorHandler().log("invalid view style attribute", this.getClass().getName(), m_method_formatChanged);
            return;
        }
        if (this.getGridViewModel() != null) {
            this.getGridViewModel().getGridViewFormatManager().valueFormatChanged();
            this.getGridViewModel().getGridViewDataSource().clearCache();
            this.updateColumnWidth();
            this.updateColumnHeaderRowHeights();
            this.updateRowHeights();
            this.repaint();
            this.firePropertyChange(this, attributeName, oldValue, newValue);
        }
    }

    @Override
    public int getPresentationHeight() {
        return this.getGridViewTable().getBounds().height;
    }

    @Override
    public int getPresentationWidth() {
        return this.getGridViewTable().getBounds().width;
    }

    protected String getUtilBundleString(String key) {
        return this.getIntlString(key, this.utilStrings);
    }

    @Override
    public String getIntlGridViewString(String key) {
        return this.getIntlString(key, this.localStrings);
    }

    @Override
    public ComponentHandle getSelectedObject() {
        return this.gridViewController.getSelectedObject();
    }

    @Override
    public void setVisible(boolean visible) {
        boolean old = this.isVisible();
        super.setVisible(visible);
        this.firePropertyChange(this, "Visible", new Boolean(old), new Boolean(visible));
    }

    @Override
    public boolean isVisible() {
        return super.isVisible();
    }

    protected void setDataTypeSupported(boolean supported) {
        this.m_dataTypeSupported = supported;
    }

    protected boolean isDataTypeSupported() {
        return this.m_dataTypeSupported;
    }

    @Override
    public abstract void setHGridVisible(boolean var1);

    @Override
    public abstract boolean isHGridVisible();

    @Override
    public abstract void setVGridVisible(boolean var1);

    @Override
    public abstract boolean isVGridVisible();

    @Override
    public abstract void setColumnHeaderVisible(boolean var1);

    @Override
    public abstract boolean isColumnHeaderVisible();

    @Override
    public abstract void setRowHeaderVisible(boolean var1);

    @Override
    public abstract boolean isRowHeaderVisible();

    @Override
    public void setGridColor(Color color) {
        Color oldValue;
        if (color == null) {
            this.getErrorHandler().log("invalid color", this.getClass().getName(), m_method_setgridcolor);
            return;
        }
        if (this.getDatabody() != null && (oldValue = this.getGridColor()) != color) {
            Painter painter = null;
            painter = this.getDatabody().getHorizontalSeparatorPainter();
            if (painter != null && painter instanceof GridlinePainter) {
                ((GridlinePainter)painter).setColor(color);
            } else {
                this.getErrorHandler().log("horizontal GridlinePainter not set", this.getClass().getName(), m_method_setgridcolor);
            }
            painter = this.getDatabody().getVerticalSeparatorPainter();
            if (painter != null && painter instanceof GridlinePainter) {
                ((GridlinePainter)painter).setColor(color);
            } else {
                this.getErrorHandler().log("vertical GridlinePainter not set", this.getClass().getName(), m_method_setgridcolor);
            }
            this.repaint();
            this.firePropertyChange(this, "GridColor", oldValue, color);
        }
    }

    @Override
    public Color getGridColor() {
        Color color = null;
        if (this.getDatabody() != null) {
            Painter painter = null;
            painter = this.getDatabody().getHorizontalSeparatorPainter();
            if (painter != null && painter instanceof GridlinePainter) {
                color = ((GridlinePainter)painter).getColor();
            } else {
                this.getErrorHandler().log("horizontal GridlinePainter not set", this.getClass().getName(), m_method_getGridColor);
            }
        }
        return color;
    }

    @Override
    public void setVGridColor(Color color) {
        Painter painter = this.getDatabody().getVerticalSeparatorPainter();
        if (painter != null && painter instanceof GridlinePainter) {
            ((GridlinePainter)painter).setColor(color);
            this.repaint();
        } else {
            this.getErrorHandler().log("vertical GridlinePainter not set", this.getClass().getName(), m_method_setVGridcolor);
        }
    }

    @Override
    public void setHGridColor(Color color) {
        Painter painter = this.getDatabody().getHorizontalSeparatorPainter();
        if (painter != null && painter instanceof GridlinePainter) {
            ((GridlinePainter)painter).setColor(color);
            this.repaint();
        } else {
            this.getErrorHandler().log("horizonal GridlinePainter not set", this.getClass().getName(), m_method_setHGridcolor);
        }
    }

    @Override
    public Color getVGridColor() {
        Color color = null;
        if (this.getDatabody() != null) {
            Painter painter = null;
            painter = this.getDatabody().getVerticalSeparatorPainter();
            if (painter != null && painter instanceof GridlinePainter) {
                color = ((GridlinePainter)painter).getColor();
            } else {
                this.getErrorHandler().log("vertical GridlinePainter not set", this.getClass().getName(), m_method_getVGridColor);
            }
        }
        return color;
    }

    @Override
    public Color getHGridColor() {
        Color color = null;
        if (this.getDatabody() != null) {
            Painter painter = null;
            painter = this.getDatabody().getHorizontalSeparatorPainter();
            if (painter != null && painter instanceof GridlinePainter) {
                color = ((GridlinePainter)painter).getColor();
            } else {
                this.getErrorHandler().log("horizontal GridlinePainter not set", this.getClass().getName(), m_method_getHGridColor);
            }
        }
        return color;
    }

    @Override
    public void setGrid3D(boolean b) {
        boolean oldValue;
        if (this.getDatabody() != null && (oldValue = this.isGrid3D()) != b) {
            this.getDatabody().setHorizontalSeparatorPainter((Painter)new GridlinePainter(true, b));
            this.getDatabody().setVerticalSeparatorPainter((Painter)new GridlinePainter(false, b));
            if (this.updateHeights) {
                this.updateRowHeights();
            }
            this.repaint();
            this.firePropertyChange(this, "Grid3D", new Boolean(oldValue), new Boolean(b));
        }
    }

    @Override
    public boolean isGrid3D() {
        boolean bIs3D = false;
        if (this.getDatabody() != null) {
            Painter painter = null;
            painter = this.getDatabody().getHorizontalSeparatorPainter();
            if (painter != null && painter instanceof GridlinePainter) {
                bIs3D = ((GridlinePainter)painter).is3D();
            } else {
                this.getErrorHandler().log("horizontal GridlinePainter not set", this.getClass().getName(), m_method_isGrid3D);
            }
        }
        return bIs3D;
    }

    public abstract void setZoomFactor(int var1);

    @Override
    public int getZoomFactor() {
        return this.zoomFactor;
    }

    @Override
    public void setBackgroundImage(Image image) {
        this.setBackgroundImage(image, false);
    }

    protected void setBackgroundImage(Image image, boolean bSetFromPath) {
        this.m_backgroundImage = image;
        if (!bSetFromPath) {
            this.m_backgroundImagePath = "";
        }
    }

    @Override
    public Image getBackgroundImage() {
        return this.m_backgroundImage;
    }

    public void setBackgroundImagePath(String path) {
        if (path == null) {
            this.getErrorHandler().log("null path", this.getClass().getName(), m_method_setBackgroundImagePath);
            return;
        }
        Image image = null;
        if (path.equals("")) {
            this.m_backgroundImagePath = path;
            this.setBackgroundImage(image, true);
            return;
        }
        String totalPath = this.getBaseImageURI() + path;
        URL url = null;
        try {
            url = new URL(totalPath);
            image = this.getToolkit().getImage(url);
        }
        catch (MalformedURLException murle) {
            // empty catch block
        }
        if (image == null) {
            image = ImageUtils.getImageResource(GridView.class, (String)totalPath);
        }
        if (image == null) {
            this.getErrorHandler().log("null image", this.getClass().getName(), m_method_setBackgroundImagePath);
            image = ImageUtils.getNotLoadedImage();
            ImageUtils.loadImage((Image)image);
        } else if (!ImageUtils.loadImage((Image)image)) {
            this.getErrorHandler().log("unable to load image", this.getClass().getName(), m_method_setBackgroundImagePath);
            image = ImageUtils.getNotLoadedImage();
            ImageUtils.loadImage((Image)image);
        }
        this.m_backgroundImagePath = path;
        this.setBackgroundImage(image, true);
    }

    public String getBackgroundImagePath() {
        return this.m_backgroundImagePath;
    }

    @Override
    public void paint(Graphics g) {
        if (this.m_stopRepaints) {
            return;
        }
        if (!this.printOrPreviewMode) {
            if (this.mustReScroll()) {
                this.setMustReScroll(false);
                if (this.getDesiredStartColumn() >= 0 && this.getDesiredStartColumn() < this.gridViewModel.getGridViewDataSource().getColumnCount()) {
                    this.getGridViewTable().setFirstColumnOnScreen(this.getDesiredStartColumn());
                }
                if (this.getDesiredStartRow() >= 0 && this.getDesiredStartRow() < this.gridViewModel.getGridViewDataSource().getRowCount()) {
                    this.getGridViewTable().setFirstRowOnScreen(this.getDesiredStartRow());
                }
            }
            super.paint(g);
        } else {
            g.drawImage(this.offscreenImage, 0, 0, null);
        }
    }

    public void setCellMaxHeight(int height) {
        if (height < 0) {
            this.getErrorHandler().log("invalid cell maximum height", this.getClass().getName(), m_method_setcellmaxheight);
            return;
        }
        int old = this.getCellMaxHeight();
        if (height != old) {
            this.cellMaxHeight = height;
            this.firePropertyChange(this, "CellMaxHeight", new Integer(old), new Integer(height));
        }
    }

    @Override
    public int getCellMaxHeight() {
        return this.cellMaxHeight;
    }

    public void setCellMinHeight(int height) {
        if (height < 0) {
            this.getErrorHandler().log("invalid cell minimum height", this.getClass().getName(), m_method_setcellminheight);
            return;
        }
        int old = this.getCellMinHeight();
        if (height != old) {
            this.cellMinHeight = height;
            this.firePropertyChange(this, "CellMinHeight", new Integer(old), new Integer(height));
        }
    }

    @Override
    public int getCellMinHeight() {
        return this.cellMinHeight;
    }

    public void setCellMaxWidth(int width) {
        if (width < 0) {
            this.getErrorHandler().log("invalid cell maximum width", this.getClass().getName(), m_method_setcellmaxwidth);
            return;
        }
        int old = this.getCellMaxWidth();
        if (width != old) {
            this.cellMaxWidth = width;
            this.firePropertyChange(this, "CellMaxWidth", new Integer(old), new Integer(width));
        }
    }

    @Override
    public int getCellMaxWidth() {
        return this.cellMaxWidth;
    }

    public void setCellMinWidth(int width) {
        if (width < 0) {
            this.getErrorHandler().log("invalid cell minimum width", this.getClass().getName(), m_method_setcellminwidth);
            return;
        }
        int old = this.getCellMinWidth();
        if (width != old) {
            this.cellMinWidth = width;
            this.firePropertyChange(this, "CellMinWidth", new Integer(old), new Integer(width));
        }
    }

    @Override
    public int getCellMinWidth() {
        return this.cellMinWidth;
    }

    @Override
    public void setEnabled(boolean enabled) {
        boolean old = this.isEnabled();
        super.setEnabled(enabled);
        this.getGridViewTable().setEnabled(enabled);
        ((Title)this.getDataviewTitle()).setEnabled(enabled);
        ((Subtitle)this.getDataviewSubtitle()).setEnabled(enabled);
        ((Footnote)this.getDataviewFootnote()).setEnabled(enabled);
        this.firePropertyChange(this, "Enabled", new Boolean(old), new Boolean(enabled));
    }

    public int getColumnWidth(int index) {
        if (index < 0) {
            this.getErrorHandler().log("invalid column index", this.getClass().getName(), m_method_getcolumnwidth);
            return 0;
        }
        return this.getGridViewSizingManager().getColumnWidth(index);
    }

    public abstract void setColumnWidth(int var1, int var2);

    public abstract void updateRowHeights();

    public abstract void updateColumnHeaderRowHeights();

    protected abstract void updateRowHeaderWidths();

    public int getRowHeight(int index) {
        if (index < 0) {
            this.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_getrowheight);
            return 0;
        }
        return this.getGridViewSizingManager().getRowHeight(index);
    }

    public abstract void setRowHeight(int var1, int var2);

    public abstract void autoFit();

    public void setAutoFitRowCount(int rowCount) {
        if (rowCount < 1 && rowCount != -1) {
            this.getErrorHandler().log("invalid rowCount", this.getClass().getName(), m_method_setAutoFitRowCount);
            return;
        }
        this.m_iAutoFitRowCount = rowCount;
    }

    public int getAutoFitRowCount() {
        return this.m_iAutoFitRowCount;
    }

    public void setAutoFitColumnCount(int colCount) {
        if (colCount < 1 && colCount != -1) {
            this.getErrorHandler().log("invalid colCount", this.getClass().getName(), m_method_setAutoFitColumnCount);
            return;
        }
        this.m_iAutoFitColumnCount = colCount;
    }

    public int getAutoFitColumnCount() {
        return this.m_iAutoFitColumnCount;
    }

    public void setAutoFitRowRangeCallback(AutoFitRowRangeCallback callback) {
        this.m_autoFitRowRangeCallback = callback;
    }

    public AutoFitRowRangeCallback getAutoFitRowRangeCallback() {
        return this.m_autoFitRowRangeCallback;
    }

    public void setAutoFitColumnRangeCallback(AutoFitColumnRangeCallback callback) {
        this.m_autoFitColumnRangeCallback = callback;
    }

    public AutoFitColumnRangeCallback getAutoFitColumnRangeCallback() {
        return this.m_autoFitColumnRangeCallback;
    }

    @Override
    public void setAutoFitScope(int scope) {
        this.m_iAutoFitScope = (scope & 1) > 0 || (scope & 2) > 0 || (scope & 4) > 0 || (scope & 8) > 0 ? scope : 0;
    }

    @Override
    public int getAutoFitScope() {
        return this.m_iAutoFitScope;
    }

    public static int convertAutoFitScopeToInt(String string) {
        if (string.equals(autofit_scope_none)) {
            return 0;
        }
        if (string.equals(autofit_scope_row_heights)) {
            return 1;
        }
        if (string.equals(autofit_scope_column_widths)) {
            return 2;
        }
        if (string.equals(autofit_scope_column_header_row_heights)) {
            return 4;
        }
        if (string.equals(autofit_scope_row_header_column_widths)) {
            return 8;
        }
        if (string.equals(autofit_scope_all)) {
            return 255;
        }
        if (string.equals(autofit_scope_colwds_rowhts)) {
            return 3;
        }
        if (string.equals(autofit_scope_colwds_colhdrrowhts)) {
            return 6;
        }
        if (string.equals(autofit_scope_colwds_rowhdrcolwds)) {
            return 10;
        }
        if (string.equals(autofit_scope_rowhts_colhdrrowhts)) {
            return 5;
        }
        if (string.equals(autofit_scope_rowhts_rowhdrcolwds)) {
            return 9;
        }
        if (string.equals(autofit_scope_colhdrrowhts_rowhdrcolwds)) {
            return 12;
        }
        if (string.equals(autofit_scope_colwds_rowhts_colhdrrowhts)) {
            return 7;
        }
        if (string.equals(autofit_scope_colwds_rowhts_rowhdrcolwds)) {
            return 11;
        }
        if (string.equals(autofit_scope_colwds_colhdrrowhts_rowhdrcolwds)) {
            return 14;
        }
        if (string.equals(autofit_scope_rowhts_colhdrrowhts_rowhdrcolwds)) {
            return 13;
        }
        return -1;
    }

    public static String convertAutoFitScopeToString(int scope) {
        String string = autofit_scope_none;
        int scope_all = 15;
        switch (scope &= 0xF) {
            case 0: {
                string = autofit_scope_none;
                break;
            }
            case 1: {
                string = autofit_scope_row_heights;
                break;
            }
            case 2: {
                string = autofit_scope_column_widths;
                break;
            }
            case 4: {
                string = autofit_scope_column_header_row_heights;
                break;
            }
            case 8: {
                string = autofit_scope_row_header_column_widths;
                break;
            }
            case 15: {
                string = autofit_scope_all;
                break;
            }
            case 3: {
                string = autofit_scope_colwds_rowhts;
                break;
            }
            case 6: {
                string = autofit_scope_colwds_colhdrrowhts;
                break;
            }
            case 10: {
                string = autofit_scope_colwds_rowhdrcolwds;
                break;
            }
            case 5: {
                string = autofit_scope_rowhts_colhdrrowhts;
                break;
            }
            case 9: {
                string = autofit_scope_rowhts_rowhdrcolwds;
                break;
            }
            case 12: {
                string = autofit_scope_colhdrrowhts_rowhdrcolwds;
                break;
            }
            case 7: {
                string = autofit_scope_colwds_rowhts_colhdrrowhts;
                break;
            }
            case 11: {
                string = autofit_scope_colwds_rowhts_rowhdrcolwds;
                break;
            }
            case 14: {
                string = autofit_scope_colwds_colhdrrowhts_rowhdrcolwds;
                break;
            }
            case 13: {
                string = autofit_scope_rowhts_colhdrrowhts_rowhdrcolwds;
            }
        }
        return string;
    }

    @Override
    public void updateSizes(int type) {
        switch (type) {
            case 2: {
                this.sizeColumnHeaderRowHeights();
                break;
            }
            case 0: {
                this.sizeRowHeights();
                break;
            }
            case 3: {
                this.sizeRowHeaderColumnWidths();
                this.updateRowHeights();
                break;
            }
            case 1: {
                this.sizeColumnWidths();
                this.updateColumnHeaderRowHeights();
                this.updateRowHeights();
                break;
            }
            default: {
                this.getErrorHandler().log("invalid type", this.getClass().getName(), m_method_updateSizes);
                return;
            }
        }
    }

    public void setCustomAnnotationCallback(CustomAnnotationCallback callback) {
        this.m_customAnnotationCallback = callback;
        this.annotationChanged();
    }

    public CustomAnnotationCallback getCustomAnnotationCallback() {
        return this.m_customAnnotationCallback;
    }

    public void setAnnotationIconVisible(boolean bVisible) {
        this.m_annotationIconVisible = bVisible;
        this.annotationChanged();
    }

    public boolean isAnnotationIconVisible() {
        return this.m_annotationIconVisible;
    }

    public void setAnnotationIconPrinted(boolean bPrinted) {
        this.m_annotationIconPrinted = bPrinted;
    }

    public boolean isAnnotationIconPrinted() {
        return this.m_annotationIconPrinted;
    }

    public void setAnnotationImage(Image image) {
        this.m_annotationImage = image;
        this.annotationChanged();
        this.m_annotationImagePath = "";
    }

    public Image getAnnotationImage() {
        if (this.m_annotationImage == null) {
            Image image = ImageUtils.getImageResource(GridView.class, (String)ANNOTATION_IMAGE_PATH);
            if (image == null) {
                this.getErrorHandler().log("null annotation image", this.getClass().getName(), m_method_getAnnotationImage);
                image = ImageUtils.getNotLoadedImage();
                ImageUtils.loadImage((Image)image);
            } else if (!ImageUtils.loadImage((Image)image)) {
                this.getErrorHandler().log("unable to load annotation image", this.getClass().getName(), m_method_getAnnotationImage);
                image = ImageUtils.getNotLoadedImage();
                ImageUtils.loadImage((Image)image);
            }
            this.m_annotationImage = image;
        }
        return this.m_annotationImage;
    }

    public void setAnnotationImagePath(String path) {
        if (path == null) {
            this.getErrorHandler().log("null path", this.getClass().getName(), m_method_setAnnotationImagePath);
            return;
        }
        if (path.equals("")) {
            this.m_annotationImagePath = path;
            this.setAnnotationImage(null);
            return;
        }
        String totalPath = this.getBaseImageURI() + path;
        URL url = null;
        Object image = null;
        try {
            url = new URL(totalPath);
            image = this.getToolkit().getImage(url);
        }
        catch (MalformedURLException murle) {
            // empty catch block
        }
        if (image == null) {
            image = ImageUtils.getImageResource(GridView.class, (String)totalPath);
        }
        if (image.equals(ImageUtils.getNotLoadedImage())) {
            image = null;
            this.getErrorHandler().log("unable to load image", this.getClass().getName(), m_method_setAnnotationImagePath);
        }
        this.setAnnotationImage((Image)image);
        this.m_annotationImagePath = path;
        this.annotationChanged();
    }

    public String getAnnotationImagePath() {
        return this.m_annotationImagePath;
    }

    @Override
    public abstract void doSizing();

    public abstract void sizeColumnHeaderRowHeights();

    public abstract void sizeColumnWidths();

    public abstract void sizeRowHeaderColumnWidths();

    public abstract void sizeRowHeights();

    public abstract void setColumnVisible(int var1, boolean var2);

    public abstract void setRowVisible(int var1, boolean var2);

    public abstract boolean isRowVisible(int var1);

    public abstract boolean isColumnVisible(int var1);

    public void setTruncatedNumericDataFormat(int format) {
        if (format < 0 || format > 2) {
            this.getErrorHandler().log("invalid truncated numeric data format", this.getClass().getName(), m_method_settruncatednumericdataformat);
            return;
        }
        int oldFormat = this.getTruncatedNumericDataFormat();
        this.numericDataFormat = format;
        this.repaint();
        this.firePropertyChange(this, "TruncatedNumericDataFormat", new Integer(oldFormat), new Integer(format));
    }

    public int getTruncatedNumericDataFormat() {
        return this.numericDataFormat;
    }

    @Override
    public abstract GridViewDatabody getDatabody();

    public abstract GridViewTable getGridViewTable();

    @Override
    public abstract GridViewHeader getColumnHeader();

    @Override
    public abstract GridViewHeader getRowHeader();

    public void setGraphicImage(int index, Image image) {
        this.setGraphicImage(index, image, false);
    }

    protected void setGraphicImage(int index, Image image, boolean bSetFromPath) {
        if (index < 0) {
            this.getErrorHandler().log("index is less than 0 ", this.getClass().getName(), m_method_setgraphicimage);
            return;
        }
        if (this.graphicImages == null) {
            this.graphicImages = new Vector();
            if (this.zoomFactor != 100) {
                this.scaledGraphicImages = new Vector();
            }
        }
        if (this.m_graphicImagePaths == null) {
            this.m_graphicImagePaths = new Vector();
        }
        if (index >= this.graphicImages.size()) {
            this.graphicImages.setSize(index + 1);
            if (this.zoomFactor != 100) {
                this.scaledGraphicImages.setSize(index + 1);
            }
        }
        if (index >= this.m_graphicImagePaths.size()) {
            this.m_graphicImagePaths.setSize(index + 1);
        }
        Image oldImage = (Image)this.graphicImages.elementAt(index);
        this.graphicImages.setElementAt(image, index);
        if (this.zoomFactor != 100) {
            if (image != null) {
                Image sImage = image.getScaledInstance(DataviewUtils.scaleByZoom(image.getWidth(null), this.zoomFactor), DataviewUtils.scaleByZoom(image.getHeight(null), this.zoomFactor), 1);
                ImageUtils.loadImage((Image)sImage);
                this.scaledGraphicImages.setElementAt(sImage, index);
            } else {
                this.scaledGraphicImages.setElementAt(null, index);
            }
        }
        if (!bSetFromPath && this.m_graphicImagePaths != null && index < this.m_graphicImagePaths.size()) {
            this.m_graphicImagePaths.setElementAt("", index);
        }
        this.firePropertyChange(this, "GraphicImage", oldImage, image);
        this.updateColumnHeaderRowHeights();
        this.updateRowHeights();
        this.repaint();
    }

    public Image getGraphicImage(int index) {
        if (index < 0 || index >= this.graphicImages.size()) {
            this.getErrorHandler().log("index is less than 0 or greater than the size of graphic images vector", this.getClass().getName(), "getGraphicImage()");
            return null;
        }
        return (Image)this.graphicImages.elementAt(index);
    }

    public void setGraphicImagePath(int index, String path) {
        Image image = null;
        if (this.setImagePath(index, path, this.m_graphicImagePaths, image)) {
            this.setGraphicImage(index, image, true);
        }
    }

    public String getGraphicImagePath(int index) {
        return this.getImagePath(index, this.m_graphicImagePaths);
    }

    public void setBaseImageURI(String baseImageURI) {
        if (baseImageURI == null) {
            this.getErrorHandler().log("null baseImageURI", this.getClass().getName(), m_method_setBaseImageURI);
            return;
        }
        this.m_baseImageURI = baseImageURI;
    }

    public String getBaseImageURI() {
        return this.m_baseImageURI;
    }

    protected boolean setImagePath(int index, String path, Vector imagePathsVector, Image image) {
        if (index < 0) {
            this.getErrorHandler().log("index is less than 0 ", this.getClass().getName(), m_method_setImagePath);
            return false;
        }
        if (path == null) {
            this.getErrorHandler().log("null path", this.getClass().getName(), m_method_setImagePath);
            return false;
        }
        if (imagePathsVector == null) {
            imagePathsVector = new Vector<String>();
        }
        if (index >= imagePathsVector.size()) {
            imagePathsVector.setSize(index + 1);
        }
        image = null;
        if (path.equals("")) {
            imagePathsVector.setElementAt(path, index);
            return true;
        }
        String totalPath = this.getBaseImageURI() + path;
        URL url = null;
        try {
            url = new URL(totalPath);
            image = this.getToolkit().getImage(url);
        }
        catch (MalformedURLException murle) {
            // empty catch block
        }
        if (image == null) {
            image = ImageUtils.getImageResource(GridView.class, (String)totalPath);
        }
        if (image == null) {
            this.getErrorHandler().log("null image", this.getClass().getName(), m_method_setImagePath);
            image = ImageUtils.getNotLoadedImage();
            ImageUtils.loadImage((Image)image);
        } else if (!ImageUtils.loadImage((Image)image)) {
            this.getErrorHandler().log("unable to load image", this.getClass().getName(), m_method_setImagePath);
            image = ImageUtils.getNotLoadedImage();
            ImageUtils.loadImage((Image)image);
        }
        imagePathsVector.setElementAt(path, index);
        return true;
    }

    protected String getImagePath(int index, Vector imagePathsVector) {
        if (index < 0 || index >= imagePathsVector.size()) {
            this.getErrorHandler().log("index is less than 0 or greater than the size of image paths vector", this.getClass().getName(), m_method_getImagePath);
            return null;
        }
        String path = "";
        Object obj = imagePathsVector.elementAt(index);
        if (obj != null && obj instanceof String) {
            path = (String)obj;
        }
        return path;
    }

    public Image getScaledGraphicImage(int index) {
        if (index < 0 || index >= this.graphicImages.size()) {
            this.getErrorHandler().log("index is less than 0 or greater than the size of graphic images vector", this.getClass().getName(), "getScaledGraphicImage()");
            return null;
        }
        if (this.zoomFactor == 100) {
            return (Image)this.graphicImages.elementAt(index);
        }
        return (Image)this.scaledGraphicImages.elementAt(index);
    }

    public int getGraphicImageCount() {
        return this.graphicImages.size();
    }

    public void setDrillImage(int index, Image image) {
        this.setDrillImage(index, image, false);
    }

    protected void setDrillImage(int index, Image image, boolean bSetFromPath) {
        this._setDrillImage(index, image, bSetFromPath);
        this.updateColumnHeaderRowHeights();
        this.updateRowHeights();
        this.repaint();
    }

    protected void _setDrillImage(int index, Image image) {
        this._setDrillImage(index, image, false);
    }

    protected void _setDrillImage(int index, Image image, boolean bSetFromPath) {
        if (index <= 0) {
            this.getErrorHandler().log("index is less than or equal to 0 ", this.getClass().getName(), "_setDrillImage()");
            return;
        }
        if (this.drillImages == null) {
            this.drillImages = new Vector();
            if (this.zoomFactor != 100) {
                this.scaledDrillImages = new Vector();
            }
        }
        if (this.m_drillImagePaths == null) {
            this.m_drillImagePaths = new Vector();
        }
        if (index >= this.drillImages.size()) {
            this.drillImages.setSize(index + 1);
            if (this.zoomFactor != 100) {
                this.scaledDrillImages.setSize(index + 1);
            }
        }
        if (index >= this.m_drillImagePaths.size()) {
            this.m_drillImagePaths.setSize(index + 1);
        }
        Image oldImage = (Image)this.drillImages.elementAt(index);
        if (image == null) {
            if (index == 1) {
                image = this.getDefaultDrillImage();
            } else if (index == 2) {
                image = this.getDefaultDrilledImage();
            }
        }
        this.drillImages.setElementAt(image, index);
        if (this.zoomFactor != 100) {
            if (image != null) {
                Image sImage = image.getScaledInstance(DataviewUtils.scaleByZoom(image.getWidth(null), this.zoomFactor), DataviewUtils.scaleByZoom(image.getHeight(null), this.zoomFactor), 1);
                ImageUtils.loadImage((Image)sImage);
                this.scaledDrillImages.setElementAt(sImage, index);
            } else {
                this.scaledDrillImages.setElementAt(null, index);
            }
        }
        if (!bSetFromPath && this.m_drillImagePaths != null && index < this.m_drillImagePaths.size()) {
            this.m_drillImagePaths.setElementAt("", index);
        }
        this.drillImageChanged();
        this.firePropertyChange(this, "DrillImage", oldImage, image);
    }

    public Image getDrillImage(int index) {
        if (index < 1 || index >= this.drillImages.size()) {
            this.getErrorHandler().log("index is less than 1 or greater than the size of drill images vector", this.getClass().getName(), "getDrillImage()");
            return null;
        }
        return (Image)this.drillImages.elementAt(index);
    }

    protected abstract Image getDefaultDrillImage();

    protected abstract Image getDefaultDrilledImage();

    protected void drillImageChanged() {
        if (this.m_bResizeForDrillImages) {
            this.updateRowHeaderWidths();
            this.updateColumnWidth();
            this.updateColumnHeaderRowHeights();
            this.updateRowHeights();
        }
    }

    public void setDrillImagePath(int index, String path) {
        if (index == 0) {
            this.getErrorHandler().log("index is 0", this.getClass().getName(), m_method_setDrillImagePath);
            return;
        }
        Image image = null;
        if (this.setImagePath(index, path, this.m_drillImagePaths, image)) {
            this.setDrillImage(index, image, true);
        }
    }

    public String getDrillImagePath(int index) {
        if (index == 0) {
            this.getErrorHandler().log("index is 0", this.getClass().getName(), m_method_getDrillImagePath);
            return null;
        }
        return this.getImagePath(index, this.m_drillImagePaths);
    }

    public Image getScaledDrillImage(int index) {
        if (index < 1 || index >= this.drillImages.size()) {
            this.getErrorHandler().log("index is less than 1 or greater than the size of drill images vector", this.getClass().getName(), "getScaledDrillImage()");
            return null;
        }
        if (this.zoomFactor == 100) {
            return (Image)this.drillImages.elementAt(index);
        }
        return (Image)this.scaledDrillImages.elementAt(index);
    }

    public int getDrillImageCount() {
        return this.drillImages.size();
    }

    @Override
    public void setDrillingEnabled(boolean b) {
        boolean bOld = this.isDrillingEnabled();
        super.setDrillingEnabled(b);
        if (!this.xmlMode && bOld != b) {
            this.drillingEnabledToggled();
        }
    }

    protected void drillingEnabledToggled() {
        if (this.isAnythingAutoFit()) {
            this.autoFit();
        }
    }

    @Override
    public void modelDataChanged(DataChangedEvent e) {
        this.freezeRepaints();
        super.modelDataChanged(e);
        this.unfreezeRepaints();
    }

    @Override
    public void modelDataAvailable(DataAvailableEvent e) {
        if (e.getType() == 1) {
            this.m_stopRepaints = true;
            return;
        }
        this.m_stopRepaints = false;
        if (this.getGridViewSizingManager() != null) {
            this.getGridViewSizingManager().dataSourceChanged();
        }
        if (this.getGridViewFormatManager() != null) {
            this.getGridViewFormatManager().dataSourceChanged();
        }
        if (this.getGridViewHeaderStyleManager() != null) {
            this.getGridViewHeaderStyleManager().dataSourceChanged();
        }
        if (this.getGridViewDatabodyStyleManager() != null) {
            this.getGridViewDatabodyStyleManager().dataSourceChanged();
        }
        if (this.getGridViewSelectionManager() != null) {
            this.getGridViewSelectionManager().dataSourceChanged();
        }
        if (this.getRolloverTextManager() != null) {
            this.getRolloverTextManager().dataSourceChanged();
        }
        this.setDesiredStartColumn(0);
        this.setDesiredStartRow(0);
        this.setMustReScroll(true);
        super.modelDataAvailable(e);
    }

    @Override
    public boolean isCellEditingAllowed() {
        return this.cellEditingAllowed;
    }

    public abstract void setCellEditingAllowed(boolean var1);

    public int autoFitColumnWidth(int column) {
        return this.doubleClickAutoFitColumnWidth(column);
    }

    public int doubleClickAutoFitColumnWidth(int column) {
        int width = this.calcAutoFitColumnWidth(column);
        if (width != -1) {
            this.getGridViewSizingManager().setPreferredColumnWidth(column, width);
        }
        return width;
    }

    protected int calcAutoFitColumnWidth(int column) {
        if (column < 0 || column >= this.getGridViewModel().getGridViewDataSource().getColumnCount()) {
            this.getErrorHandler().log("invalid column index", this.getClass().getName(), "protected int calcAutoFitColumnWidth(int column)");
            return -1;
        }
        Range range = this.getAutoFitRowRange();
        int endRow = range.end;
        int startRow = range.begin;
        if (endRow < startRow) {
            this.getErrorHandler().log("invalid row range", this.getClass().getName(), "protected int calcAutoFitColumnWidth(int column)");
            return -1;
        }
        int[] widths = this.calcAutoFitColumnWidths(column, column, startRow, endRow);
        if (this.getAutoFitRowRangeCallback() != null) {
            this.getAutoFitRowRangeCallback().endAutoFit();
        }
        if (widths == null) {
            return -1;
        }
        return widths[0];
    }

    public int autoFitRowHeight(int row) {
        if (row < 0 || row >= this.getGridViewModel().getGridViewDataSource().getRowCount()) {
            this.getErrorHandler().log("invalid row index", this.getClass().getName(), m_method_autoFitRowHeight);
            return -1;
        }
        Range range = this.getAutoFitColumnRange();
        int endCol = range.end;
        int startCol = range.begin;
        if (endCol < startCol) {
            this.getErrorHandler().log("invalid column range", this.getClass().getName(), m_method_autoFitRowHeight);
            return -1;
        }
        int[] heights = this.calcAutoFitRowHeights(startCol, endCol, row, row);
        if (this.getAutoFitColumnRangeCallback() != null) {
            this.getAutoFitColumnRangeCallback().endAutoFit();
        }
        if (heights == null) {
            return -1;
        }
        this.getGridViewSizingManager().setPreferredRowHeight(row, heights[0]);
        return heights[0];
    }

    public void addGridViewDataListener(GridViewDataListener l) {
        if (this.gridViewModel != null) {
            this.gridViewModel.addGridViewDataListener(l);
        }
    }

    public void removeGridViewDataListener(GridViewDataListener l) {
        if (this.gridViewModel != null) {
            this.gridViewModel.removeGridViewDataListener(l);
        }
    }

    public JScrollPane getScrollPane() {
        return this.scrollBox;
    }

    @Override
    protected void resetToDefault(int reset, String version) {
        int j;
        if (reset < 0 || reset > 5) {
            this.getErrorHandler().log("invalid reset argument", this.getClass().getName(), "resetToDefault(int reset)");
            return;
        }
        if (reset == 0) {
            this.getErrorHandler().log("attempt to reset to default with argument of RESET_NONE", this.getClass().getName(), "resetToDefault(int reset)");
            return;
        }
        ((GridViewXML)this.getViewXML()).resetGridViewXML();
        super.resetToDefault(reset, version);
        if (reset == 3 || reset == 1) {
            this.getGridViewDatabodyStyleManager().setUIBundle(this, null);
            this.getGridViewDatabodyStyleManager().setBundles(this, null);
            this.getGridViewHeaderStyleManager().setUIBundle(this, null);
            this.getGridViewHeaderStyleManager().setBundles(this, null);
            this.getGridViewFormatManager().setUIBundle(this, null);
            this.getGridViewFormatManager().setBundles(this, null);
            ViewFormat vf = new ViewFormat();
            this.setViewFormat(vf);
            this.getGridViewSizingManager().reset();
        } else if (reset == 4 || reset == 2) {
            this.setAutoFitColumnRangeCallback(null);
            this.setAutoFitRowRangeCallback(null);
            this.m_customAnnotationCallback = null;
        }
        this.pagingControl.setVisible(false);
        this.m_backgroundImage = null;
        this.m_backgroundImagePath = "";
        this.drillImages = new Vector();
        this.m_drillImagePaths = new Vector();
        this.graphicImages = new Vector();
        this.m_graphicImagePaths = new Vector();
        this.m_annotationImage = null;
        this.m_annotationImagePath = GridViewDefaultValues.getAnnotationImagePath();
        this.m_annotationIconVisible = GridViewDefaultValues.isAnnotationIconVisible();
        this.m_annotationIconPrinted = GridViewDefaultValues.isAnnotationIconPrinted();
        this.scaledDrillImages = new Vector();
        this.scaledGraphicImages = new Vector();
        for (j = 0; j < this.invisibleColumn.size(); ++j) {
            this.setColumnVisible((Integer)this.invisibleColumn.elementAt(j), true);
        }
        for (j = 0; j < this.invisibleRow.size(); ++j) {
            this.setRowVisible((Integer)this.invisibleRow.elementAt(j), true);
        }
        this.invisibleColumn = new Vector();
        this.invisibleRow = new Vector();
    }

    @Override
    protected void setContext() {
        ((GridViewDatabodyRuleStyles)this.getGridViewDatabodyStyleManager()).setContext(this.m_context);
        ((GridViewRuleFormatter)this.getGridViewFormatManager()).setContext(this.m_context);
        ((GridViewHeaderRuleStyles)this.getGridViewHeaderStyleManager()).setContext(this.m_context);
        if (this.getUIFormats() != null) {
            int formatCount = this.getUIFormats().size();
            for (int i = 0; i < formatCount; ++i) {
                UIFormat format = (UIFormat)this.getUIFormats().elementAt(i);
                format.setContext(this.m_context);
            }
        }
    }

    @Override
    public int convertComponentTypeToInteger(String type) {
        int compType = super.convertComponentTypeToInteger(type);
        if (compType != -1) {
            return compType;
        }
        if (type.equals(databody)) {
            return 9;
        }
        if (type.equals(col_header)) {
            return 10;
        }
        if (type.equals(row_header)) {
            return 11;
        }
        return -1;
    }

    @Override
    public String convertComponentTypeToString(int type) {
        String compType = super.convertComponentTypeToString(type);
        if (compType != null) {
            return compType;
        }
        switch (type) {
            case 9: {
                return databody;
            }
            case 10: {
                return col_header;
            }
            case 11: {
                return row_header;
            }
        }
        return null;
    }

    public abstract void setCornerComponentColor(Color var1);

    @Override
    public abstract Color getCornerComponentColor();

    public void setCornerComponentColorUsed(boolean b) {
        this.m_bCornerComponentColorUsed = b;
    }

    public boolean isCornerComponentColorUsed() {
        return this.m_bCornerComponentColorUsed;
    }

    @Override
    public abstract void setDefaultCornerComponentColor(Color var1);

    public abstract void setManualRowSizingEnabled(boolean var1);

    public boolean isManualRowSizingEnabled() {
        return this.m_bManualRowSizingEnabled;
    }

    public abstract void setManualColumnSizingEnabled(boolean var1);

    public boolean isManualColumnSizingEnabled() {
        return this.m_bManualColumnSizingEnabled;
    }

    @Override
    public void setSwapAllowed(boolean swap) {
        if (this.getGridViewTable() != null && this.getPagingControl().getPagingComponent() != null) {
            boolean oldSwapAllowed = this.getGridViewTable().isSwapAllowed();
            this.getGridViewTable().setSwapAllowed(swap);
            this.getPagingControl().getPagingComponent().setSwapAllowed(swap);
            this.firePropertyChange(this, "SwapAllowed", new Boolean(oldSwapAllowed), new Boolean(swap));
        }
    }

    @Override
    public boolean isSwapAllowed() {
        if (this.getGridViewTable() != null) {
            return this.getGridViewTable().isSwapAllowed();
        }
        return false;
    }

    protected boolean mustReScroll() {
        return this.m_bMustReScroll;
    }

    protected void setMustReScroll(boolean b) {
        this.m_bMustReScroll = b;
    }

    @Override
    protected void firePropertyChange(Object obj, String propName, Object oldValue, Object newValue) {
        if (this.boundSupport != null) {
            this.boundSupport.firePropertyChange(propName, oldValue, newValue);
        }
    }

    protected void copyGrid(GridViewDatabody to, GridViewDatabody from) {
        DataviewUtils.copyStyleProperties(to, from);
    }

    protected abstract int[] calcAutoFitColumnWidths(int var1, int var2, int var3, int var4);

    protected abstract int[] calcAutoFitRowHeights(int var1, int var2, int var3, int var4);

    public void setPrintOrPreviewMode(boolean bool) {
        Graphics offg = null;
        if (bool) {
            Dimension size = this.getSize();
            if (this.offscreenImage == null) {
                this.offscreenImage = this.createImage(size.width, size.height);
            }
            if (this.offscreenImage != null) {
                offg = this.offscreenImage.getGraphics();
                offg.setClip(0, 0, size.width, size.height);
                this.paint(offg);
            }
            this.printOrPreviewMode = bool;
        } else {
            this.printOrPreviewMode = bool;
            if (offg != null) {
                offg.dispose();
            }
            this.offscreenImage = null;
        }
    }

    @Override
    public boolean isPrintOrPreviewMode() {
        return this.printOrPreviewMode;
    }

    protected void setDesiredStartRow(int r) {
        if (r < 0) {
            this.getErrorHandler().log("invalid start row", this.getClass().getName(), m_method_setdesiredstartrow);
            return;
        }
        this.m_lDesiredStartRow = r;
    }

    protected int getDesiredStartRow() {
        return this.m_lDesiredStartRow;
    }

    protected void setDesiredStartColumn(int c) {
        if (c < 0) {
            this.getErrorHandler().log("invalid start column", this.getClass().getName(), m_method_setdesiredstartcolumn);
            return;
        }
        this.m_lDesiredStartColumn = c;
    }

    protected int getDesiredStartColumn() {
        return this.m_lDesiredStartColumn;
    }

    public static String toHexString(int value) {
        String hexStr = Integer.toHexString(value & 0xFFFFFF);
        String poundStr = "#";
        StringBuffer buff = new StringBuffer(poundStr);
        buff.append(hexStr);
        return buff.toString();
    }

    public static int hexStringToInt(String str) {
        String noPound = str.substring(1);
        return Integer.parseInt(noPound, 16);
    }

    @Override
    public Object getComponentFromID(int ID) {
        Object comp = super.getComponentFromID(ID);
        if (comp != null) {
            return comp;
        }
        switch (ID) {
            case 9: {
                return this.getDatabody();
            }
            case 10: {
                return this.getColumnHeader();
            }
            case 11: {
                return this.getRowHeader();
            }
            case 12: {
                return new Cell(0, 0);
            }
            case 13: {
                return null;
            }
            case 14: {
                return null;
            }
            case 15: {
                return null;
            }
            case 3: 
            case 4: {
                return this.getPagingControl().getPagingComponent();
            }
            case 5: {
                return this.getPagingControl();
            }
        }
        return null;
    }

    @Override
    protected String getNameFromID(int ID) {
        String name = super.getNameFromID(ID);
        if (name != null) {
            return name;
        }
        switch (ID) {
            case 9: {
                return DATABODY_NAME;
            }
            case 10: {
                return COL_HEADER_NAME;
            }
            case 11: {
                return ROW_HEADER_NAME;
            }
            case 12: {
                return DATA_CELL_NAME;
            }
            case 16: {
                return DATA_CELL_RANGE_NAME;
            }
            case 13: {
                return DATABODY_HIGHLIGHTER_NAME;
            }
            case 14: {
                return DATA_COLUMN_NAME;
            }
            case 15: {
                return DATA_ROW_NAME;
            }
            case 17: {
                return COL_HEADER_RANGE_NAME;
            }
            case 18: {
                return ROW_HEADER_RANGE_NAME;
            }
            case 19: {
                return DATA_COLUMN_RANGE_NAME;
            }
            case 20: {
                return DATA_ROW_RANGE_NAME;
            }
        }
        return null;
    }

    protected Range getAutoFitRowRange() {
        int firstRowOnScreen = 0;
        if (this.getGridViewTable() != null) {
            firstRowOnScreen = this.getGridViewTable().getFirstRowOnScreen();
        }
        if (firstRowOnScreen < 0) {
            firstRowOnScreen = 0;
        }
        return this.getAutoFitRowRange(firstRowOnScreen);
    }

    protected Range getAutoFitRowRange(int firstRow) {
        Range range = null;
        if (firstRow < 0) {
            firstRow = 0;
        }
        int totalRowCount = this.getGridViewModel().getGridViewDataSource().getRowCount();
        if (this.getAutoFitRowRangeCallback() != null) {
            range = this.getAutoFitRowRangeCallback().startAutoFit(firstRow);
            if (range == null) {
                this.getErrorHandler().log("null RowRange", this.getClass().getName(), m_method_getAutoFitRowRange);
            } else {
                if (range.begin < 0) {
                    range.begin = 0;
                }
                if (range.end > totalRowCount - 1) {
                    range.end = totalRowCount - 1;
                }
                return range;
            }
        }
        if (range == null) {
            range = new Range();
            range.begin = firstRow;
            int count = this.getAutoFitRowCount();
            if (count == -1) {
                count = totalRowCount;
            }
            range.end = range.begin + count - 1;
        }
        if (range.end > totalRowCount - 1) {
            int offset = range.end - (totalRowCount - 1);
            range.end = totalRowCount - 1;
            range.begin = range.begin - offset < 0 ? 0 : (range.begin -= offset);
        }
        return range;
    }

    protected Range getAutoFitColumnRange() {
        Object range = null;
        int firstColOnScreen = 0;
        if (this.getGridViewTable() != null) {
            firstColOnScreen = this.getGridViewTable().getFirstColumnOnScreen();
        }
        if (firstColOnScreen < 0) {
            firstColOnScreen = 0;
        }
        return this.getAutoFitColumnRange(firstColOnScreen);
    }

    protected Range getAutoFitColumnRange(int firstCol) {
        Range range = null;
        if (firstCol < 0) {
            firstCol = 0;
        }
        int totalColCount = this.getGridViewModel().getGridViewDataSource().getColumnCount();
        if (this.getAutoFitColumnRangeCallback() != null) {
            range = this.getAutoFitColumnRangeCallback().startAutoFit(firstCol);
            if (range == null) {
                this.getErrorHandler().log("null ColumnRange", this.getClass().getName(), m_method_getAutoFitColumnRange);
            } else {
                if (range.begin < 0) {
                    range.begin = 0;
                }
                if (range.end > totalColCount - 1) {
                    range.end = totalColCount - 1;
                }
                return range;
            }
        }
        if (range == null) {
            range = new Range();
            range.begin = firstCol;
            int count = this.getAutoFitColumnCount();
            if (count == -1) {
                count = totalColCount;
            }
            range.end = range.begin + count - 1;
        }
        if (range.end > totalColCount - 1) {
            int offset = range.end - (totalColCount - 1);
            range.end = totalColCount - 1;
            range.begin = range.begin - offset < 0 ? 0 : (range.begin -= offset);
        }
        return range;
    }

    protected boolean isAnythingAutoFit() {
        return (this.getAutoFitScope() & 1) > 0 || (this.getAutoFitScope() & 2) > 0 || (this.getAutoFitScope() & 4) > 0 || (this.getAutoFitScope() & 8) > 0;
    }

    @Override
    protected void setDataUnformattedSupported(boolean supported) {
        super.setDataUnformattedSupported(supported);
    }

    protected void setDataFormattedSupported(boolean supported) {
        this.m_dataFormattedSupported = supported;
    }

    @Override
    public boolean isDataFormattedSupported() {
        return this.m_dataFormattedSupported;
    }

    protected void setDataRatioSupported(boolean supported) {
        this.m_dataRatioSupported = supported;
    }

    public boolean isDataRatioSupported() {
        return this.m_dataRatioSupported;
    }

    protected void setDataViewStyleSupported(boolean supported) {
        this.m_dataViewStyleSupported = supported;
    }

    @Override
    public boolean isDataViewStyleSupported() {
        return this.m_dataViewStyleSupported;
    }

    protected void setDataViewFormatSupported(boolean supported) {
        this.m_dataViewFormatSupported = supported;
    }

    protected boolean isDataAnnotationSupported() {
        return this.m_dataAnnotationSupported;
    }

    protected void setDataAnnotationSupported(boolean supported) {
        this.m_dataAnnotationSupported = supported;
    }

    @Override
    public boolean isDataIsTotalSupported() {
        return this.m_dataIsTotalSupported;
    }

    protected void setDataIsTotalSupported(boolean supported) {
        this.m_dataIsTotalSupported = supported;
    }

    @Override
    protected void setMetadataLongLabelSupported(boolean supported) {
        super.setMetadataLongLabelSupported(supported);
    }

    @Override
    protected void setMetadataMediumLabelSupported(boolean supported) {
        super.setMetadataMediumLabelSupported(supported);
    }

    @Override
    protected void setMetadataShortLabelSupported(boolean supported) {
        super.setMetadataShortLabelSupported(supported);
    }

    @Override
    protected void setMetadataValueSupported(boolean supported) {
        super.setMetadataValueSupported(supported);
    }

    protected void setMetadataDrillSupported(boolean supported) {
        this.m_metaDrillSupported = supported;
    }

    public boolean isMetadataDrillSupported() {
        return this.m_metaDrillSupported;
    }

    @Override
    protected void setLayerMetaShortLabelSupported(boolean supported) {
        super.setLayerMetaShortLabelSupported(supported);
    }

    @Override
    protected void setLayerMetaMediumLabelSupported(boolean supported) {
        super.setLayerMetaMediumLabelSupported(supported);
    }

    @Override
    protected void setLayerMetaLongLabelSupported(boolean supported) {
        super.setLayerMetaLongLabelSupported(supported);
    }

    @Override
    protected void setLayerMetaNameSupported(boolean supported) {
        super.setLayerMetaNameSupported(supported);
    }

    public void setRowOrColumnVisible(boolean column, String str) {
        if (str != null) {
            boolean doSet = true;
            while (doSet) {
                String tmp = this.getNextNumber(str);
                if (tmp == null) {
                    doSet = false;
                    continue;
                }
                int index = (str = str.trim()).indexOf(" ");
                str = index == -1 ? "" : str.substring(index, str.length());
                if (column) {
                    this.setColumnVisible(new Integer(tmp), false);
                    continue;
                }
                this.setRowVisible(new Integer(tmp), false);
            }
        }
    }

    protected void scaleImages() {
        if (this.zoomFactor != 100) {
            this.scaledDrillImages = new Vector();
            this.scaleImages(this.drillImages, this.scaledDrillImages);
            this.scaledGraphicImages = new Vector();
            this.scaleImages(this.graphicImages, this.scaledGraphicImages);
        }
    }

    protected void scaleImages(Vector originalImages, Vector scaledImages) {
        if (originalImages != null) {
            scaledImages.setSize(originalImages.size());
            for (int i = 0; i < originalImages.size(); ++i) {
                int scaleHeight;
                Image oldImage = (Image)originalImages.elementAt(i);
                if (oldImage == null) continue;
                int scaleWidth = DataviewUtils.scaleByZoom(oldImage.getWidth(null), this.zoomFactor);
                if (scaleWidth <= 0) {
                    scaleWidth = 1;
                }
                if ((scaleHeight = DataviewUtils.scaleByZoom(oldImage.getHeight(null), this.zoomFactor)) <= 0) {
                    scaleHeight = 1;
                }
                Image sImage = oldImage.getScaledInstance(scaleWidth, scaleHeight, 1);
                ImageUtils.loadImage((Image)sImage);
                scaledImages.setElementAt(sImage, i);
            }
        }
    }

    protected void addRule(UIBundle manager, Rule rule) {
        GridView._addRule(this, manager, rule);
    }

    public static void _addRule(GridViewCommon gridView, UIBundle manager, Rule rule) {
        RuleBundle ruleBundle = manager.getUIBundle();
        if (ruleBundle == null) {
            ruleBundle = new RuleBundle();
        }
        ruleBundle.addRule(rule);
        manager.setUIBundle(gridView, ruleBundle);
    }

    private String getNextNumber(String str) {
        int index = (str = str.trim()).indexOf(" ");
        if (index == -1 && str.length() == 0) {
            return null;
        }
        if (index == -1) {
            index = str.length();
        }
        String tmp = str.substring(0, index);
        tmp = tmp.trim();
        return tmp;
    }

    private void annotationChanged() {
        this.updateColumnWidth();
        this.updateRowHeights();
        this.repaint();
    }

    public void setInvisibleColumn(Vector col) {
        this.invisibleColumn = col;
    }

    public Vector getInvisibleColumn() {
        return this.invisibleColumn;
    }

    public void setInvisibleRow(Vector row) {
        this.invisibleRow = row;
    }

    public Vector getInvisibleRow() {
        return this.invisibleRow;
    }

    public static void applyCSSStyleDefaults(GridViewCommon view, CSSStyleDefaults defaults) {
        if (view != null) {
            if (defaults != null) {
                int[] compIDs = defaults.getComponentIDs();
                if (compIDs != null) {
                    Object component = null;
                    for (int index = 0; index < compIDs.length; ++index) {
                        component = view.getComponentFromID(compIDs[index]);
                        if (component != null) {
                            if (component instanceof Styleable) {
                                Styleable styleable = (Styleable)component;
                                ViewStyle viewStyle = (ViewStyle)styleable.getViewStyle().clone();
                                ViewStyle cssDefaults = defaults.getCSSDefaults(compIDs[index]);
                                if (cssDefaults != null) {
                                    viewStyle.mergeDefaults(cssDefaults);
                                    styleable.setViewStyle(viewStyle);
                                    if (compIDs[index] != 11 || !cssDefaults.isBackgroundUsed() || viewStyle.isBackgroundUsed()) continue;
                                    view.setDefaultCornerComponentColor(cssDefaults.getBackground());
                                    continue;
                                }
                                view.getErrorHandler().log("null ViewStyle", view.getClass().getName(), m_method_applyCSSStyleDefaults);
                                continue;
                            }
                            view.getErrorHandler().log("component not a Styleable", view.getClass().getName(), m_method_applyCSSStyleDefaults);
                            continue;
                        }
                        view.getErrorHandler().log("null component", view.getClass().getName(), m_method_applyCSSStyleDefaults);
                    }
                } else {
                    view.getErrorHandler().log("null array of component IDs", view.getClass().getName(), m_method_applyCSSStyleDefaults);
                }
            } else {
                view.getErrorHandler().log("null CSSStyleDefaults object", view.getClass().getName(), m_method_applyCSSStyleDefaults);
            }
        }
    }

    @Override
    public void setBanding(int banding) {
        this.m_banding = banding;
    }

    @Override
    public int getBanding() {
        return this.m_banding;
    }

    @Override
    public void setHTMLColumnSizing(int htmlColumnSizing) {
        this.m_htmlColumnSizing = htmlColumnSizing;
    }

    @Override
    public int getHTMLColumnSizing() {
        return this.m_htmlColumnSizing;
    }

    @Override
    public void setHTMLRowBlockSize(int size) {
        this.m_htmlRowBlockSize = size;
    }

    @Override
    public int getHTMLRowBlockSize() {
        return this.m_htmlRowBlockSize;
    }

    public void setHTMLColumnBlockSize(int size) {
        this.m_htmlColumnBlockSize = size;
    }

    public int getHTMLColumnBlockSize() {
        return this.m_htmlColumnBlockSize;
    }

    @Override
    public Integer getHTMLTableCellPadding() {
        return this.m_htmlTableCellPadding;
    }

    @Override
    public void setHTMLTableCellPadding(Integer padding) {
        this.m_htmlTableCellPadding = padding;
    }

    @Override
    public String getHTMLTableWidth() {
        return this.m_htmlTableWidth;
    }

    @Override
    public void setHTMLTableWidth(String width) {
        this.m_htmlTableWidth = width;
    }

    @Override
    public void setHTMLTextInputSize(int size) {
        this.m_htmlTextInputSize = size;
    }

    @Override
    public int getHTMLTextInputSize() {
        return this.m_htmlTextInputSize;
    }

    @Override
    public int getUIFormatCount() {
        return this.m_formatCount;
    }

    @Override
    public void setUIFormatCount(int count) {
        this.m_formatCount = count;
    }

    @Override
    public int getToolbarUIFormatCount() {
        return this.m_toolbarFormatCount;
    }

    @Override
    public void setToolbarUIFormatCount(int count) {
        this.m_toolbarFormatCount = count;
    }

    @Override
    public void setUIFormats(Vector formats) {
        this.m_UIFormats = formats;
    }

    @Override
    public Vector getUIFormats() {
        return this.m_UIFormats;
    }

    @Override
    public String getBadColor() {
        return this.m_badColor;
    }

    @Override
    public void setBadColor(String color) {
        this.m_badColor = color;
    }

    @Override
    public String getWarningColor() {
        return this.m_warningColor;
    }

    @Override
    public void setWarningColor(String color) {
        this.m_warningColor = color;
    }

    @Override
    public String getGoodColor() {
        return this.m_goodColor;
    }

    @Override
    public void setGoodColor(String color) {
        this.m_goodColor = color;
    }

    @Override
    public boolean isHideData() {
        return this.m_isHideData;
    }

    @Override
    public void setHideData(boolean hide) {
        this.m_isHideData = hide;
    }

    public abstract void setStartRow(int var1);

    public abstract int getStartRow();

    public abstract void setStartColumn(int var1);

    public abstract int getStartColumn();

    public void exportExcelHTML(int pageRange, List pageList, String path, String fileName, PrintWriter writer, int pagesPerSheet, ExportProgressListener listener) throws Exception {
        GridViewExcelHTMLExport exportEngine = this.getGridViewExcelHTMLExport();
        exportEngine.setPath(path);
        exportEngine.setFileName(fileName);
        exportEngine.setExportPageRange(pageRange);
        exportEngine.setPagesPerSheet(pagesPerSheet);
        exportEngine.setExportPageList(pageList);
        if (writer != null) {
            exportEngine.setPrintWriter(writer);
        }
        if (listener != null) {
            exportEngine.addExportProgressListener(listener);
        }
        exportEngine.export();
    }

    @Override
    public boolean startExport() {
        this.m_bExporting = true;
        this.setPrintOrPreviewMode(true);
        this.freezeRepaints();
        boolean bResult = true;
        this.m_exportState = this.createExportState();
        bResult = this.m_exportState != null ? this.saveExportState(this.m_exportState) : false;
        return bResult;
    }

    @Override
    public void endExport() {
        this.m_bExporting = false;
        int firstRowOnScreen = -1;
        int firstColOnScreen = -1;
        if (this.m_exportState != null) {
            firstRowOnScreen = this.m_exportState.getFirstRowOnScreen();
            firstColOnScreen = this.m_exportState.getFirstColOnScreen();
            this.restoreExportState(this.m_exportState);
        }
        this.m_exportState = null;
        this.setPrintOrPreviewMode(false);
        this.resizeViewAfterExport(firstColOnScreen, firstRowOnScreen);
        this.unfreezeRepaints();
        this.repaint();
    }

    protected abstract void resizeViewAfterExport(int var1, int var2);

    public boolean isExporting() {
        return this.m_bExporting;
    }

    protected void freezeRepaints() {
        this.getPagingControl().getPagingComponent().freezeRepaints();
    }

    protected void unfreezeRepaints() {
        this.getPagingControl().getPagingComponent().unfreezeRepaints();
    }

    @Override
    public ViewStyle getDatabodyViewStyle() {
        return this.getDatabody().getViewStyle();
    }

    @Override
    public ViewStyle getColumnHeaderViewStyle() {
        return this.getColumnHeader().getViewStyle();
    }

    @Override
    public ViewStyle getRowHeaderViewStyle() {
        return this.getRowHeader().getViewStyle();
    }

    @Override
    public ViewStyle getPagingControlViewStyle() {
        return this.getPagingControl().getViewStyle();
    }

    protected GridViewExportState createExportState() {
        return new GridViewExportState();
    }

    protected boolean saveExportState(GridViewExportState state) {
        boolean bResult = true;
        try {
            state.setPageHPos(this.getModel().getDataAccess().getEdgeCurrentHPos(2));
        }
        catch (DataException eoore) {
            this.getErrorHandler().log("problem getting current page hPos", this.getClass().getName(), "saveExportState");
            bResult = false;
        }
        state.setSelectedObject(this.getSelectedObject());
        state.setColHeaderCellFocus(this.getColumnHeader().getCellFocus());
        state.setRowHeaderCellFocus(this.getRowHeader().getCellFocus());
        state.setDatabodyCellFocus(this.getDatabody().getCellFocus());
        return bResult;
    }

    protected boolean restoreExportState(GridViewExportState state) {
        boolean bResult = true;
        try {
            int[] currHPos;
            if (state.getPageHPos() != null && !GridViewUtils.equalsHPos(currHPos = this.getModel().getDataAccess().getEdgeCurrentHPos(2), state.getPageHPos())) {
                int maxLayerSpecified = -1;
                maxLayerSpecified = state.getPageHPos().length - 1;
                this.getModel().getDataDirector().changeEdgeCurrentHPos(2, state.getPageHPos(), maxLayerSpecified);
            }
        }
        catch (DataException e) {
            this.getErrorHandler().log("problem changing pages in data source", this.getClass().getName(), "restoreExportState");
            bResult = false;
        }
        this.selectObject(state.getSelectedObject());
        this.setFocusRequestedForCell(false);
        this.getColumnHeader().setCellFocus(state.getColHeaderCellFocus());
        this.getRowHeader().setCellFocus(state.getRowHeaderCellFocus());
        this.getDatabody().setCellFocus(state.getDatabodyCellFocus());
        this.setFocusRequestedForCell(true);
        return bResult;
    }

    private void setFocusRequestedForCell(boolean bRequested) {
        this.m_bFocusRequestedForCell = bRequested;
    }

    protected int isSelectionNumberOrDate(ComponentHandle componentHandle) {
        DataAccess dataAccess = this.getModel().getDataAccess();
        boolean hasDate = false;
        boolean hasNumber = false;
        if (componentHandle instanceof DataRangeComponentHandle) {
            DataComponentInfo[] ci = ((DataRangeComponentHandle)componentHandle).getLocationList();
            for (int i = 0; i < ci.length; ++i) {
                try {
                    Object value = dataAccess.getValue(ci[i].getRow(), ci[i].getColumn(), "dataValue");
                    if (value instanceof java.sql.Date) {
                        hasDate = true;
                    }
                    if (value instanceof Number) {
                        hasNumber = true;
                    }
                }
                catch (Exception eee) {
                    // empty catch block
                }
                if (!hasNumber || !hasDate) {
                    continue;
                }
                break;
            }
        } else if (componentHandle instanceof DataComponentHandle) {
            Object value = null;
            try {
                value = dataAccess.getValue(((DataComponentHandle)componentHandle).getRow(), ((DataComponentHandle)componentHandle).getColumn(), "dataValue");
            }
            catch (Exception eee) {
                // empty catch block
            }
            if (value instanceof java.sql.Date) {
                hasDate = true;
            }
            if (value instanceof Number) {
                hasNumber = true;
            }
        } else if (componentHandle instanceof ColumnComponentHandle) {
            int column = ((ColumnComponentInfo)componentHandle.getComponentInfo()).getColumn();
            try {
                int rowNumber = dataAccess.getEdgeExtent(1);
                for (int i = 0; i < rowNumber; ++i) {
                    try {
                        Object value = dataAccess.getValue(i, column, "dataValue");
                        if (value instanceof java.sql.Date) {
                            hasDate = true;
                        }
                        if (value instanceof Number) {
                            hasNumber = true;
                        }
                    }
                    catch (Exception eee) {
                        // empty catch block
                    }
                    if (hasNumber && hasDate) break;
                }
            }
            catch (Exception data) {}
        } else if (componentHandle instanceof RowComponentHandle) {
            int row = ((RowComponentInfo)componentHandle.getComponentInfo()).getRow();
            try {
                int columnNumber = dataAccess.getEdgeExtent(0);
                for (int i = 0; i < columnNumber; ++i) {
                    try {
                        Object value = dataAccess.getValue(row, i, "dataValue");
                        if (value instanceof java.sql.Date) {
                            hasDate = true;
                        }
                        if (value instanceof Number) {
                            hasNumber = true;
                        }
                    }
                    catch (Exception eee) {
                        // empty catch block
                    }
                    if (hasNumber && hasDate) break;
                }
            }
            catch (Exception data) {}
        } else if (componentHandle instanceof ColumnRangeComponentHandle) {
            ColumnComponentInfo[] ci = ((ColumnRangeComponentHandle)componentHandle).getLocationList();
            block23: for (int columnIndex = 0; columnIndex < ci.length; ++columnIndex) {
                int column = ci[columnIndex].getColumn();
                try {
                    int rowNumber = dataAccess.getEdgeExtent(1);
                    for (int i = 0; i < rowNumber; ++i) {
                        try {
                            Object value = dataAccess.getValue(i, column, "dataValue");
                            if (value instanceof java.sql.Date) {
                                hasDate = true;
                            }
                            if (value instanceof Number) {
                                hasNumber = true;
                            }
                        }
                        catch (Exception eee) {
                            // empty catch block
                        }
                        if (hasNumber && hasDate) continue block23;
                    }
                    continue;
                }
                catch (Exception data) {
                    // empty catch block
                }
            }
        } else if (componentHandle instanceof RowRangeComponentHandle) {
            RowComponentInfo[] ci = ((RowRangeComponentHandle)componentHandle).getLocationList();
            block25: for (int rowIndex = 0; rowIndex < ci.length; ++rowIndex) {
                int row = ci[rowIndex].getRow();
                try {
                    int columnNumber = dataAccess.getEdgeExtent(0);
                    for (int i = 0; i < columnNumber; ++i) {
                        try {
                            Object value = dataAccess.getValue(row, i, "dataValue");
                            if (value instanceof java.sql.Date) {
                                hasDate = true;
                            }
                            if (value instanceof Number) {
                                hasNumber = true;
                            }
                        }
                        catch (Exception eee) {
                            // empty catch block
                        }
                        if (hasNumber && hasDate) continue block25;
                    }
                    continue;
                }
                catch (Exception data) {
                    // empty catch block
                }
            }
        }
        if (hasDate && hasNumber) {
            return 0;
        }
        if (hasDate) {
            return 1;
        }
        return 2;
    }

    protected void setLoadingViewFromPersistence(boolean bLoading) {
        this.m_bLoadingViewFromPersistence = bLoading;
    }

    protected boolean isLoadingViewFromPersistence() {
        return this.m_bLoadingViewFromPersistence;
    }

    @Override
    public FormatModel getFormatModel() {
        return this.m_formatModel;
    }

    @Override
    public void setFormatModel(FormatModel model) {
        this.m_formatModel = model;
    }

    public void setImagesScaled(boolean bScaled) {
        this.m_bImagesScaled = bScaled;
    }

    public boolean isImagesScaled() {
        return this.m_bImagesScaled;
    }

    public void setHeaderResizing(boolean b) {
        this.m_bHeaderResizing = b;
    }

    public boolean isHeaderResizing() {
        return this.m_bHeaderResizing;
    }

    @Override
    public void cleanUp() {
        if (this.m_dataFetchThread != null) {
            this.m_dataFetchThread.stopRunning();
            this.m_dataFetchThread = null;
        }
        super.cleanUp();
    }

    public void setDuringScroll(boolean bDuringScroll) {
        this.m_bDuringScroll = bDuringScroll;
    }

    public boolean isDuringScroll() {
        return this.m_bDuringScroll;
    }

    public void setScrollWaitCursor(boolean bCursor) {
        boolean oldVal = this.m_bScrollWaitCursor;
        this.m_bScrollWaitCursor = bCursor;
        if (oldVal != bCursor) {
            if (bCursor) {
                DataviewUtils.setCursor(WindowUtils.getWindow((Component)this), this.getGridViewController().getCursorType(2));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GridView.this.setScrollWaitCursor(false);
                    }
                });
            } else {
                DataviewUtils.setCursor(WindowUtils.getWindow((Component)this), this.getGridViewController().getCursorType(0));
            }
        }
    }

    public boolean isScrollWaitCursor() {
        return this.m_bScrollWaitCursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueFromDataAccess(int col, int row, String type, DataAccess dataAccess) throws DataException {
        Object object = null;
        if (this.isDuringScroll() && !this.isScrollWaitCursor() && this.m_dataFetchThread != null && Thread.currentThread() != this.m_dataFetchThread) {
            try {
                DataFetchLock dataFetchLock = this.m_dataFetchLock;
                synchronized (dataFetchLock) {
                    this.m_dataFetchLock.init();
                    this.m_dataFetchThread.startDataValueFetch(col, row, type, dataAccess);
                    this.m_dataFetchLock.wait(1000L);
                    if (!this.m_dataFetchLock.isDone()) {
                        this.setScrollWaitCursor(true);
                        this.m_dataFetchLock.wait();
                    }
                    object = this.m_dataFetchLock.getResult();
                }
            }
            catch (InterruptedException ie) {
                object = null;
                this.getErrorHandler().log("thread interrupted while trying to fetch data", this.getClass().getName(), "protected Object getValueFromDataAccess(...)");
                Thread.currentThread().interrupt();
            }
        } else {
            object = dataAccess.getValue(row, col, type);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forceFetchFromDataAccess(int[] startSlice, int[] endSlice, int flag, DataAccess dataAccess) throws DataException {
        boolean result = false;
        if (this.isDuringScroll() && !this.isScrollWaitCursor() && this.m_dataFetchThread != null && Thread.currentThread() != this.m_dataFetchThread) {
            try {
                DataFetchLock dataFetchLock = this.m_dataFetchLock;
                synchronized (dataFetchLock) {
                    Object object;
                    this.m_dataFetchLock.init();
                    this.m_dataFetchThread.startForceFetch(startSlice, endSlice, flag, dataAccess);
                    this.m_dataFetchLock.wait(1000L);
                    if (!this.m_dataFetchLock.isDone()) {
                        this.setScrollWaitCursor(true);
                        this.m_dataFetchLock.wait();
                    }
                    if ((object = this.m_dataFetchLock.getResult()) != null) {
                        result = (Boolean)object;
                    }
                }
            }
            catch (InterruptedException ie) {
                result = false;
                this.getErrorHandler().log("thread interrupted while trying to force fetch", this.getClass().getName(), "public boolean forceFetchFromDataAccess(...)");
                Thread.currentThread().interrupt();
            }
        } else {
            result = dataAccess.forceFetch(startSlice, endSlice, flag);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getMetadataFromDataAccess(int edge, int layer, int slice, String type, DataAccess dataAccess) throws DataException {
        Object object = null;
        if (this.isDuringScroll() && !this.isScrollWaitCursor() && this.m_dataFetchThread != null && Thread.currentThread() != this.m_dataFetchThread) {
            try {
                DataFetchLock dataFetchLock = this.m_dataFetchLock;
                synchronized (dataFetchLock) {
                    this.m_dataFetchLock.init();
                    this.m_dataFetchThread.startMemberMetadataFetch(edge, layer, slice, type, dataAccess);
                    this.m_dataFetchLock.wait(1000L);
                    if (!this.m_dataFetchLock.isDone()) {
                        this.setScrollWaitCursor(true);
                        this.m_dataFetchLock.wait();
                    }
                    object = this.m_dataFetchLock.getResult();
                }
            }
            catch (InterruptedException ie) {
                object = null;
                this.getErrorHandler().log("thread interrupted while trying to fetch data", this.getClass().getName(), "protected Object getMetadataFromDataAccess(...)");
                Thread.currentThread().interrupt();
            }
        } else {
            object = dataAccess.getMemberMetadata(edge, layer, slice, type);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewStyle getHeaderStyleFromManager(int edge, int layer, int slice, Object metadata, ViewStyle initStyle) {
        Object object = null;
        if (this.isDuringScroll() && !this.isScrollWaitCursor() && this.m_dataFetchThread != null && Thread.currentThread() != this.m_dataFetchThread) {
            try {
                DataFetchLock dataFetchLock = this.m_dataFetchLock;
                synchronized (dataFetchLock) {
                    this.m_dataFetchLock.init();
                    this.m_dataFetchThread.startHeaderStyleFetch(edge, layer, slice, metadata, initStyle);
                    this.m_dataFetchLock.wait(1000L);
                    if (!this.m_dataFetchLock.isDone()) {
                        this.setScrollWaitCursor(true);
                        this.m_dataFetchLock.wait();
                    }
                    try {
                        object = this.m_dataFetchLock.getResult();
                    }
                    catch (DataException de) {
                        object = null;
                    }
                }
            }
            catch (InterruptedException ie) {
                object = null;
                this.getErrorHandler().log("thread interrupted while trying to fetch data", this.getClass().getName(), "protected ViewStyle getHeaderStyleFromManager(...)");
                Thread.currentThread().interrupt();
            }
        } else {
            object = this.getGridViewHeaderStyleManager().getMetadataStyle(this, metadata, initStyle, edge, layer, slice);
        }
        if (object instanceof ViewStyle) {
            return object;
        }
        return null;
    }

    protected static Object parseFormattedValue(GridView gridView, Object type, String value, Locale locale) throws ParseException {
        if (type == null) {
            return value;
        }
        if (type.equals("Date")) {
            return GridView.getDateFormat(locale).parse(value);
        }
        if (type.equals("Double") || type.equals("Float") || type.equals("Integer") || type.equals("Long") || type.equals("Short")) {
            return DataviewUtils.toDouble(value, locale, GridView.getNumberFormat(locale));
        }
        if (type.equals("Boolean")) {
            String strTrue = gridView.getUtilBundleString("true").toUpperCase(locale);
            String strValue = value.toUpperCase(locale);
            if (strValue.equals(strTrue)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return value;
    }

    protected static String formatRawValue(GridView gridView, Object value, Locale locale) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            NumberFormat numberformat = GridView.getNumberFormat(locale);
            return numberformat.format(value);
        }
        if (value instanceof Date) {
            return GridView.getDateFormat(locale).format(value);
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return gridView.getUtilBundleString("true");
            }
            return gridView.getUtilBundleString("false");
        }
        return value.toString();
    }

    protected static NumberFormat getNumberFormat(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return NumberFormat.getNumberInstance(locale);
    }

    protected static DateFormat getDateFormat(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        SimpleDateFormat format = null;
        DateFormat fmt = DateFormat.getDateInstance(3, locale);
        format = format instanceof SimpleDateFormat ? (SimpleDateFormat)fmt : new SimpleDateFormat();
        if (locale.getLanguage().compareTo("th") == 0 && locale.getCountry().compareTo("TH") == 0) {
            format.setCalendar(new GregorianCalendar(locale));
        }
        return format;
    }

    static /* synthetic */ DataFetchLock access$000(GridView x0) {
        return x0.m_dataFetchLock;
    }

    protected class GridViewExportState {
        ComponentHandle selectedObj;
        ComponentInfo databodyCellFocus;
        ComponentInfo colHeaderCellFocus;
        ComponentInfo rowHeaderCellFocus;
        int[] hPos;
        public int firstRowOnScreen;
        public int firstColOnScreen;

        protected GridViewExportState() {
        }

        void setSelectedObject(ComponentHandle handle) {
            this.selectedObj = handle;
        }

        ComponentHandle getSelectedObject() {
            return this.selectedObj;
        }

        void setPageHPos(int[] pageHPos) {
            this.hPos = pageHPos;
        }

        int[] getPageHPos() {
            return this.hPos;
        }

        public void setFirstRowOnScreen(int row) {
            this.firstRowOnScreen = row;
        }

        public int getFirstRowOnScreen() {
            return this.firstRowOnScreen;
        }

        public void setFirstColOnScreen(int col) {
            this.firstColOnScreen = col;
        }

        public int getFirstColOnScreen() {
            return this.firstColOnScreen;
        }

        public void setDatabodyCellFocus(ComponentInfo info) {
            this.databodyCellFocus = info;
        }

        public ComponentInfo getDatabodyCellFocus() {
            return this.databodyCellFocus;
        }

        public void setColHeaderCellFocus(ComponentInfo info) {
            this.colHeaderCellFocus = info;
        }

        public ComponentInfo getColHeaderCellFocus() {
            return this.colHeaderCellFocus;
        }

        public void setRowHeaderCellFocus(ComponentInfo info) {
            this.rowHeaderCellFocus = info;
        }

        public ComponentInfo getRowHeaderCellFocus() {
            return this.rowHeaderCellFocus;
        }
    }

    private class DataFetchThread
    extends Thread {
        private int m_col;
        private int m_row;
        private int m_edge;
        private int m_layer;
        private int m_slice;
        private int[] m_startSlice;
        private int[] m_endSlice;
        private int m_forceFetchFlag;
        private String m_type;
        private DataAccess m_da;
        private Object m_metadata;
        private ViewStyle m_initStyle;
        private boolean m_bContinueRunning;
        private Object m_executionLock;
        private int m_mode;
        private static final int MODE_DATA_VALUE = 1;
        private static final int MODE_MEMBER_METADATA = 2;
        private static final int MODE_HEADER_STYLE = 3;
        private static final int MODE_FORCE_FETCH = 4;

        DataFetchThread() {
            super("GridView.DataFetchThread");
            this.m_col = -1;
            this.m_row = -1;
            this.m_edge = 0;
            this.m_layer = -1;
            this.m_slice = -1;
            this.m_startSlice = null;
            this.m_endSlice = null;
            this.m_forceFetchFlag = -1;
            this.m_type = null;
            this.m_da = null;
            this.m_metadata = null;
            this.m_initStyle = null;
            this.m_bContinueRunning = true;
            this.m_executionLock = null;
            this.m_mode = 1;
            this.m_executionLock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void stopRunning() {
            Object object = this.m_executionLock;
            synchronized (object) {
                this.m_bContinueRunning = false;
                this.m_executionLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startDataValueFetch(int col, int row, String type, DataAccess da) {
            Object object = this.m_executionLock;
            synchronized (object) {
                this.m_mode = 1;
                this.m_col = col;
                this.m_row = row;
                this.m_type = type;
                this.m_da = da;
                this.m_edge = -1;
                this.m_layer = -1;
                this.m_slice = -1;
                this.m_executionLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startMemberMetadataFetch(int edge, int layer, int slice, String type, DataAccess da) {
            Object object = this.m_executionLock;
            synchronized (object) {
                this.m_mode = 2;
                this.m_edge = edge;
                this.m_layer = layer;
                this.m_slice = slice;
                this.m_type = type;
                this.m_da = da;
                this.m_col = -1;
                this.m_row = -1;
                this.m_executionLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startHeaderStyleFetch(int edge, int layer, int slice, Object metadata, ViewStyle initStyle) {
            Object object = this.m_executionLock;
            synchronized (object) {
                this.m_mode = 3;
                this.m_metadata = metadata;
                this.m_initStyle = initStyle;
                this.m_edge = edge;
                this.m_layer = layer;
                this.m_slice = slice;
                this.m_col = -1;
                this.m_row = -1;
                this.m_type = null;
                this.m_da = null;
                this.m_executionLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startForceFetch(int[] startSlice, int[] endSlice, int flag, DataAccess da) {
            Object object = this.m_executionLock;
            synchronized (object) {
                this.m_mode = 4;
                this.m_startSlice = startSlice;
                this.m_endSlice = endSlice;
                this.m_forceFetchFlag = flag;
                this.m_da = da;
                this.m_edge = -1;
                this.m_layer = -1;
                this.m_slice = -1;
                this.m_col = -1;
                this.m_row = -1;
                this.m_type = null;
                this.m_executionLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            var1_1 = this.m_executionLock;
            synchronized (var1_1) {
                while (this.m_bContinueRunning) {
                    try {
                        this.m_executionLock.wait();
                    }
                    catch (InterruptedException ie) {
                        GridView.this.getErrorHandler().log("thread interrupted", this.getClass().getName(), "run()");
                    }
                    if (!this.m_bContinueRunning) {
                        return;
                    }
                    object = null;
                    dataException = null;
                    try {
                        switch (this.m_mode) {
                            case 1: {
                                if (this.m_da == null) ** break;
                                object = this.m_da.getValue(this.m_row, this.m_col, this.m_type);
                                ** break;
lbl20:
                                // 1 sources

                                break;
                            }
                            case 2: {
                                if (this.m_da == null) ** break;
                                object = this.m_da.getMemberMetadata(this.m_edge, this.m_layer, this.m_slice, this.m_type);
                                ** break;
lbl25:
                                // 1 sources

                                break;
                            }
                            case 3: {
                                if (GridView.this.getGridViewHeaderStyleManager() == null) ** break;
                                object = GridView.this.getGridViewHeaderStyleManager().getMetadataStyle(GridView.this, this.m_metadata, this.m_initStyle, this.m_edge, this.m_layer, this.m_slice);
                                ** break;
lbl30:
                                // 1 sources

                                break;
                            }
                            case 4: {
                                if (this.m_da == null) ** break;
                                val = this.m_da.forceFetch(this.m_startSlice, this.m_endSlice, this.m_forceFetchFlag);
                                object = new Boolean(val);
                                break;
                            }
                            ** default:
lbl37:
                            // 1 sources

                            break;
                        }
                    }
                    catch (DataException e) {
                        dataException = e;
                    }
                    finally {
                        this.m_da = null;
                        this.m_metadata = null;
                        this.m_initStyle = null;
                        this.m_type = null;
                        this.m_startSlice = null;
                        this.m_endSlice = null;
                    }
                    var4_5 = GridView.access$000(GridView.this);
                    synchronized (var4_5) {
                        GridView.access$000(GridView.this).setDataException(dataException);
                        GridView.access$000(GridView.this).setResult(object);
                        GridView.access$000(GridView.this).setDone(true);
                        GridView.access$000(GridView.this).notifyAll();
                    }
                }
            }
        }
    }

    private static class DataFetchLock {
        private boolean m_bDone;
        private Object m_result;
        private DataException m_dataException;

        DataFetchLock() {
            this.init();
        }

        void init() {
            this.m_bDone = false;
            this.m_result = null;
            this.m_dataException = null;
        }

        void setDone(boolean bDone) {
            this.m_bDone = bDone;
        }

        boolean isDone() {
            return this.m_bDone;
        }

        void setDataException(DataException de) {
            this.m_dataException = de;
        }

        void setResult(Object result) {
            this.m_result = result;
        }

        Object getResult() throws DataException {
            return this.m_result;
        }
    }
}

