/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.model3d;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Axis3DObj;
import oracle.dss.graph.pfj.JChart_3D;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.model3d.Matrix4d;
import oracle.dss.graph.pfj.model3d.Point3d;

public abstract class Model3DFlatFace
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int XX = 0;
    public static final int YY = 1;
    public static final int ZZ = 2;
    public static final int MIN_POINTS = 3;
    public static final double BY_ANGLE_SCALE = 1.0;
    static final int OBJ_FACTOR = 1000;
    static final int FACE_FACTOR = 1000000;
    static final int AXIS_FACTOR = 100000000;
    protected JChart_3D m_chart;
    protected Point3d m_viewer;
    protected IdentObj m_id;
    protected BlackBoxIF m_bb;
    protected int m_nVertices;
    protected Point3d[] m_vertices;
    protected Point3d[] m_xVertices;
    protected Point[] m_projVertices;
    protected boolean m_bIsTransformed;
    protected boolean m_bIsProjected;
    protected int m_nFaces;
    protected int[][] m_faces;
    protected double m_distance;
    protected Detectiv m_Detectiv;
    protected Vector[][][] m_GridLines;
    protected Point3d m_boundMin;
    protected Point3d m_boundMax;
    protected boolean[][] m_bGridStatus;
    protected boolean m_bWantGrids;
    protected boolean m_bAutoshading;
    protected boolean m_bCanUseSimpleVisibility;
    protected Point3d[] m_ptsForNormal;
    protected int m_nPointsFound;
    protected double m_floorLevel;
    protected double m_fLightSourceX;
    protected double m_fLightSourceY;
    protected double m_fLightSourceZ;

    protected Model3DFlatFace(JChart_3D chart, IdentObj id, BlackBoxIF bb, int nFaces, int nVertices, boolean[][] bGridStatus, boolean bAutoshading) {
        this.m_chart = chart;
        this.m_viewer = null;
        this.m_id = id;
        this.m_bb = bb;
        this.m_nVertices = nVertices;
        this.m_nFaces = nFaces;
        this.m_Detectiv = this.m_chart.getDetectiv();
        this.m_bIsTransformed = false;
        this.m_bIsProjected = false;
        this.m_vertices = new Point3d[this.m_nVertices];
        this.m_xVertices = new Point3d[this.m_nVertices];
        this.m_projVertices = new Point[this.m_nVertices];
        this.m_bGridStatus = bGridStatus;
        this.m_bWantGrids = bGridStatus == null ? false : bGridStatus[1][0] || bGridStatus[1][1] || bGridStatus[1][2];
        this.m_bAutoshading = bAutoshading;
        this.m_bCanUseSimpleVisibility = false;
        this.m_GridLines = null;
        this.m_floorLevel = this.m_chart.getCubeWallThickY();
        this.m_fLightSourceX = this.m_chart.m_fColorLightSourceX;
        this.m_fLightSourceY = this.m_chart.m_fColorLightSourceY;
        this.m_fLightSourceZ = this.m_chart.m_fColorLightSourceZ;
    }

    public static double applyDiffuseLighting(double[] vNormal, double[] vLight) {
        double fIntensity;
        double fCosAngleOfIncidence = Model3DFlatFace.dotProduct(vNormal, vLight);
        if (fCosAngleOfIncidence < 0.0) {
            fCosAngleOfIncidence = 5.0E-4;
        }
        if ((fIntensity = fCosAngleOfIncidence * 1.5) < 0.0) {
            fIntensity = 0.0;
        }
        if (fIntensity > 1.0) {
            fIntensity = 1.0;
        }
        fIntensity *= fIntensity;
        return fIntensity;
    }

    private void calcBounds() {
        this.m_boundMin = new Point3d(this.m_vertices[0].x, this.m_vertices[0].y, this.m_vertices[0].z);
        this.m_boundMax = new Point3d(this.m_vertices[0].x, this.m_vertices[0].y, this.m_vertices[0].z);
        for (int v = 1; v < this.m_nVertices; ++v) {
            if (this.m_vertices[v].x < this.m_boundMin.x) {
                this.m_boundMin.x = this.m_vertices[v].x;
            }
            if (this.m_vertices[v].x > this.m_boundMax.x) {
                this.m_boundMax.x = this.m_vertices[v].x;
            }
            if (this.m_vertices[v].y < this.m_boundMin.y) {
                this.m_boundMin.y = this.m_vertices[v].y;
            }
            if (this.m_vertices[v].y > this.m_boundMax.y) {
                this.m_boundMax.y = this.m_vertices[v].y;
            }
            if (this.m_vertices[v].z < this.m_boundMin.z) {
                this.m_boundMin.z = this.m_vertices[v].z;
            }
            if (!(this.m_vertices[v].z > this.m_boundMax.z)) continue;
            this.m_boundMax.z = this.m_vertices[v].z;
        }
    }

    public void calcDistance(Matrix4d matrix, Point3d viewer) {
        Point3d center = this.getCenter();
        center.y = this.m_floorLevel;
        this.transformPoint3d(center, matrix);
        double dist2 = (viewer.x - center.x) * (viewer.x - center.x) + (viewer.y - center.y) * (viewer.y - center.y) + (viewer.z - center.z) * (viewer.z - center.z);
        this.m_distance = Math.sqrt(dist2);
    }

    private void calcGridLines() {
        Point3d ptStart = null;
        Point3d ptEnd = null;
        this.m_GridLines = new Vector[2][3][this.m_nFaces];
        for (int nGridType = 0; nGridType < 2; ++nGridType) {
            for (int nAxis = 0; nAxis <= 2; ++nAxis) {
                double axisMax;
                double axisMin;
                if (!this.m_bGridStatus[nGridType][nAxis]) continue;
                if (nAxis == 0) {
                    axisMin = this.m_boundMin.x;
                    axisMax = this.m_boundMax.x;
                } else if (nAxis == 1) {
                    axisMin = this.m_boundMin.y;
                    axisMax = this.m_boundMax.y;
                } else {
                    axisMin = this.m_boundMin.z;
                    axisMax = this.m_boundMax.z;
                }
                List gridPos = nGridType == 0 ? this.m_chart.getMinorGridPositions(nAxis) : this.m_chart.getMajorGridPositions(nAxis);
                for (int nFace = 0; nFace < this.m_nFaces; ++nFace) {
                    this.m_GridLines[nGridType][nAxis][nFace] = null;
                    int gridCount = gridPos.size();
                    for (int index = 0; index < gridCount; ++index) {
                        double d = (Double)gridPos.get(index);
                        ptStart = this.getGridLineStart(nAxis, nFace, d);
                        ptEnd = this.getGridLineEnd(nAxis, nFace, d);
                        if (ptStart == null || ptEnd == null || !(d > axisMin) || !(d < axisMax)) continue;
                        if (this.m_GridLines[nGridType][nAxis][nFace] == null) {
                            this.m_GridLines[nGridType][nAxis][nFace] = new Vector();
                        }
                        this.m_GridLines[nGridType][nAxis][nFace].addElement(ptStart);
                        this.m_GridLines[nGridType][nAxis][nFace].addElement(ptEnd);
                    }
                }
            }
        }
    }

    public void calcGrids() {
        if (this.m_bWantGrids) {
            this.calcBounds();
            this.calcGridLines();
        }
    }

    public void display() {
        if (this.m_bCanUseSimpleVisibility && !this.m_bWantGrids) {
            BlackBoxIF bb = this.m_bb != null ? this.m_bb : this.m_chart.getModelBlackBox(this.m_id);
            this.transformVertices();
            this.projectVertices();
            IdentObj newId = new IdentObj(this.m_id);
            newId.incrMiscID(0);
            Polygon poly = this.projectVertices(0);
            new DetPolygon(this.m_Detectiv, newId, poly, bb, null, 1.0, true);
            newId = new IdentObj(this.m_id);
            newId.incrMiscID(2);
            poly = this.projectVertices(2);
            new DetPolygon(this.m_Detectiv, newId, poly, bb, null, 1.0, true);
            newId = new IdentObj(this.m_id);
            newId.incrMiscID(4);
            poly = this.projectVertices(4);
            new DetPolygon(this.m_Detectiv, newId, poly, bb, null, 1.0, true);
        } else {
            double[] vLight = null;
            double[] vNormal = null;
            double[] p1 = null;
            double[] p2 = null;
            double[] p3 = null;
            double fIntensity = 1.0;
            BlackBoxIF bb = this.m_bb == null ? this.m_chart.getModelBlackBox(this.m_id) : this.m_bb;
            this.transformVertices();
            if (this.m_bWantGrids) {
                this.transformGrids();
            }
            this.projectVertices();
            if (this.m_bAutoshading) {
                vLight = new double[3];
                vNormal = new double[3];
                p1 = new double[3];
                p2 = new double[3];
                p3 = new double[3];
                vLight[0] = this.m_fLightSourceX;
                vLight[1] = this.m_fLightSourceY;
                vLight[2] = this.m_fLightSourceZ;
            }
            for (int f = 0; f < this.getNumFaces(); ++f) {
                if (this.m_bCanUseSimpleVisibility) {
                    if (!this.isVisibleIpsoFacto(f)) continue;
                    this.displayFace(f, bb, fIntensity);
                    continue;
                }
                double fVis = this.visibility(f);
                if (fVis <= 0.0) continue;
                if (this.m_bAutoshading && this.getPointsForNormal(f, p1, p2, p3)) {
                    Model3DFlatFace.OGL_CalcNormal(p1, p2, p3, vNormal);
                    fIntensity = Model3DFlatFace.applyDiffuseLighting(vNormal, vLight);
                }
                this.displayFace(f, bb, fIntensity);
            }
        }
    }

    public void displayFace(int f, BlackBoxIF bb, double fIntensity) {
        Polygon poly = this.projectVertices(f);
        IdentObj newId = new IdentObj(this.m_id);
        newId.incrMiscID(f);
        new DetPolygon(this.m_Detectiv, newId, poly, bb, null, fIntensity, true);
        if (this.m_bWantGrids) {
            this.displayGridFace(true, 0, f);
            this.displayGridFace(true, 1, f);
            this.displayGridFace(true, 2, f);
            this.displayGridFace(false, 0, f);
            this.displayGridFace(false, 1, f);
            this.displayGridFace(false, 2, f);
        }
    }

    private void displayGridFace(boolean bMajor, int nAxis, int nFace) {
        int i = 0;
        Vector pts = this.projectGrids(bMajor, nAxis, nFace);
        if (pts == null) {
            return;
        }
        IdentObj id = bMajor ? this.m_chart.getMajorGridId(nAxis) : this.m_chart.getMinorGridId(nAxis);
        BlackBoxIF bb = bMajor ? this.m_chart.getMajorGridsBlackBox(nAxis) : this.m_chart.getMinorGridsBlackBox(nAxis);
        int nLineWidth = 0;
        try {
            Perspective p = this.m_Detectiv.getPerspective();
            Axis3DObj axis = this.m_chart.getAxisObj(nAxis);
            IdentObj idMajor = new IdentObj(axis.getMajorGridId().getObjectID());
            if (bMajor) {
                nLineWidth = p.getLineWidth(idMajor);
            }
        }
        catch (AssertionException exc) {
            // empty catch block
        }
        Enumeration e = pts.elements();
        while (e.hasMoreElements()) {
            Point pt0 = (Point)e.nextElement();
            Point pt1 = (Point)e.nextElement();
            IdentObj newID = new IdentObj(id.getObjectID(), this.m_id.getSeriesID(), this.m_id.getGroupID());
            newID.incrMiscID(nAxis * 100000000 + nFace * 1000000 + this.m_id.getObjectID() * 1000 + i);
            new DetLine(this.m_Detectiv, newID, pt0.x, pt0.y, pt1.x, pt1.y, bb, null, nLineWidth);
            ++i;
            ++i;
        }
    }

    public static double dotProduct(double[] vector_one, double[] vector_two) {
        return vector_one[0] * vector_two[0] + vector_one[1] * vector_two[1] + vector_one[2] * vector_two[2];
    }

    public double getDistance() {
        return this.m_distance;
    }

    public int[] getFace(int iFace) {
        return this.m_faces[iFace];
    }

    public Point3d getFaceNormal(int f) {
        int v0 = this.getFace(f)[0];
        this.m_ptsForNormal = new Point3d[3];
        this.transformVertices();
        this.m_ptsForNormal[0] = new Point3d(this.m_xVertices[v0]);
        int nFound = 1;
        for (int i = 1; i < this.getNumPtsPerFace(f) && nFound < 3; ++i) {
            int vi = this.getFace(f)[i];
            if (nFound == 1) {
                if (this.m_xVertices[vi].equals(this.m_ptsForNormal[0])) continue;
                this.m_ptsForNormal[nFound++] = new Point3d(this.m_xVertices[vi]);
                continue;
            }
            if (nFound != 2 || this.m_xVertices[vi].equals(this.m_ptsForNormal[0]) || this.m_xVertices[vi].equals(this.m_ptsForNormal[1])) continue;
            this.m_ptsForNormal[nFound++] = new Point3d(this.m_xVertices[vi]);
        }
        this.m_nPointsFound = nFound;
        if (nFound < 3) {
            return null;
        }
        Point3d delta1 = this.m_ptsForNormal[1].minus(this.m_ptsForNormal[0]);
        Point3d delta2 = this.m_ptsForNormal[2].minus(this.m_ptsForNormal[0]);
        double nx = delta1.y * delta2.z - delta1.z * delta2.y;
        double ny = delta1.z * delta2.x - delta1.x * delta2.z;
        double nz = delta1.x * delta2.y - delta1.y * delta2.x;
        return new Point3d(nx, ny, nz);
    }

    public IdentObj getID() {
        return this.m_id;
    }

    public IdentObj getIDColor() {
        IdentObj idColor = this.m_id.getSeriesID() != -3 ? new IdentObj(-3, this.m_id.getSeriesID()) : this.m_id;
        return idColor;
    }

    public int getNumFaces() {
        return this.m_nFaces;
    }

    public boolean getPointsForNormal(int f, double[] p1, double[] p2, double[] p3) {
        if (this.m_nPointsFound > 0) {
            p1[0] = this.m_ptsForNormal[0].x;
            p1[1] = this.m_ptsForNormal[0].y;
            p1[2] = this.m_ptsForNormal[0].z;
            if (this.m_nPointsFound > 1) {
                p2[0] = this.m_ptsForNormal[1].x;
                p2[1] = this.m_ptsForNormal[1].y;
                p2[2] = this.m_ptsForNormal[1].z;
                if (this.m_nPointsFound > 2) {
                    p3[0] = this.m_ptsForNormal[2].x;
                    p3[1] = this.m_ptsForNormal[2].y;
                    p3[2] = this.m_ptsForNormal[2].z;
                }
            }
        }
        return this.m_nPointsFound >= 3;
    }

    public Point3d getVertex(int iPoint) {
        return this.m_vertices[iPoint];
    }

    public boolean isVisibleIpsoFacto(int f) {
        throw new AssertionException("Simple visiblity is available only for rectangular solids");
    }

    public static void OGL_CalcNormal(double[] p1, double[] p2, double[] p3, double[] n) {
        double length;
        double[] a = new double[3];
        double[] b = new double[3];
        a[0] = p2[0] - p1[0];
        a[1] = p2[1] - p1[1];
        a[2] = p2[2] - p1[2];
        b[0] = p3[0] - p1[0];
        b[1] = p3[1] - p1[1];
        b[2] = p3[2] - p1[2];
        n[0] = a[1] * b[2] - a[2] * b[1];
        n[1] = a[2] * b[0] - a[0] * b[2];
        n[2] = a[0] * b[1] - a[1] * b[0];
        try {
            length = Math.sqrt(n[0] * n[0] + n[1] * n[1] + n[2] * n[2]);
        }
        catch (Exception e) {
            length = 0.0;
        }
        if (length != 0.0) {
            n[0] = n[0] / length;
            n[1] = n[1] / length;
            n[2] = n[2] / length;
        }
    }

    public Vector projectGrids(boolean bMajor, int nAxis, int f) {
        double x0 = 0.0;
        double y0 = 0.0;
        Vector<Point> pts = new Vector<Point>();
        if (this.m_GridLines[bMajor ? 1 : 0][nAxis][f] == null) {
            return null;
        }
        Enumeration e = this.m_GridLines[bMajor ? 1 : 0][nAxis][f].elements();
        while (e.hasMoreElements()) {
            pts.addElement(this.m_chart.projectPoint3d((Point3d)e.nextElement()));
        }
        return pts;
    }

    public void projectVertices() {
        if (this.m_bIsProjected) {
            return;
        }
        for (int i = 0; i < this.m_nVertices; ++i) {
            this.m_projVertices[i] = this.m_chart.projectPoint3d(this.m_xVertices[i]);
        }
        this.m_bIsProjected = true;
    }

    public void projectVerticesInDouble(double[] xPoints, double[] yPoints) {
        for (int i = 0; i < this.m_nVertices; ++i) {
            Point2D p2d = this.m_chart.projectPoint3dInDouble(this.m_xVertices[i]);
            xPoints[i] = p2d.getX();
            yPoints[i] = p2d.getY();
        }
    }

    public Polygon projectVertices(int f) {
        Polygon poly = new Polygon();
        int x0 = 0;
        int y0 = 0;
        PfjAssert.pfjAssert(this.m_bIsProjected);
        for (int iPoint = 0; iPoint < this.m_faces[f].length; ++iPoint) {
            int nPoint = this.m_faces[f][iPoint];
            Point pt = this.m_projVertices[nPoint];
            poly.addPoint(pt.x, pt.y);
            if (iPoint != 0) continue;
            x0 = pt.x;
            y0 = pt.y;
        }
        poly.addPoint(x0, y0);
        return poly;
    }

    public void transformGrids() {
        if (this.m_GridLines == null) {
            throw new RuntimeException("Grid line not initialized in 3D Model");
        }
        int nGridType = 1;
        for (int nAxis = 0; nAxis < 3; ++nAxis) {
            for (int nFace = 0; nFace < this.m_nFaces; ++nFace) {
                if (this.m_GridLines[nGridType][nAxis][nFace] == null) continue;
                Enumeration e = this.m_GridLines[nGridType][nAxis][nFace].elements();
                while (e.hasMoreElements()) {
                    this.m_chart.transformPoint3d((Point3d)e.nextElement());
                }
            }
        }
    }

    public void transformPoint3d(Point3d p3D_X, Matrix4d matrix) {
        double tempX = p3D_X.x;
        double tempY = p3D_X.y;
        double tempZ = p3D_X.z;
        p3D_X.x = tempX * matrix.m00 + tempY * matrix.m10 + tempZ * matrix.m20 + matrix.m30;
        p3D_X.y = tempX * matrix.m01 + tempY * matrix.m11 + tempZ * matrix.m21 + matrix.m31;
        p3D_X.z = tempX * matrix.m02 + tempY * matrix.m12 + tempZ * matrix.m22 + matrix.m32;
    }

    public void transformVertices() {
        if (this.m_bIsTransformed) {
            return;
        }
        for (int i = 0; i < this.m_nVertices; ++i) {
            Point3d p3D_X = new Point3d(this.m_vertices[i]);
            this.m_chart.transformPoint3d(p3D_X);
            this.m_xVertices[i] = p3D_X;
        }
        this.m_bIsTransformed = true;
    }

    public double visibility(int f) {
        Point3d normal = this.getFaceNormal(f);
        int v0 = this.getFace(f)[0];
        if (normal == null) {
            return -1.0;
        }
        this.m_viewer = this.m_chart.getViewer();
        Point3d toViewer = this.m_viewer.minus(this.m_xVertices[v0]);
        double dotProduct = normal.x * toViewer.x + normal.y * toViewer.y + normal.z * toViewer.z;
        double normalLength = Math.sqrt(normal.x * normal.x + normal.y * normal.y + normal.z * normal.z);
        double visiFactor = normalLength == 0.0 ? -1.0 : dotProduct * 1.0 / normalLength;
        return visiFactor;
    }

    protected abstract Point3d getCenter();

    protected abstract Point3d getGridLineEnd(int var1, int var2, double var3);

    protected abstract Point3d getGridLineStart(int var1, int var2, double var3);

    public abstract int getNumPtsPerFace(int var1);
}

