/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.GraphExportXMLWriter;
import oracle.dss.graph.pfj.GraphSVGWriter;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.RangeSlider;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetMarker;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.DetOval;
import oracle.dss.graph.pfj.draw.DetShape;
import oracle.dss.graph.pfj.draw.IdentObj;

public class Detectiv
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int MIN_LINEWIDTH = 4;
    public static final int INIT_CAPACITY = 512;
    private Perspective m_Perspective;
    private Vector m_detList;
    boolean m_bExceptionalFlag;
    Rectangle m_defaultClipRect;
    private DetMarker m_prevDetMarker = null;
    private DetObj m_currentDetObj = null;

    public Detectiv(Perspective perspective) {
        this.m_Perspective = perspective;
        this.m_detList = new Vector(512);
        this.m_bExceptionalFlag = false;
    }

    public DetObj findNodeOf(int x, int y, VC vc) {
        DetObj detObj = null;
        boolean bFound = false;
        for (int i = this.m_detList.size() - 1; i >= 0 && !bFound; --i) {
            detObj = (DetObj)this.m_detList.elementAt(i);
            if (!detObj.isPointInObj(x, y, vc)) continue;
            bFound = true;
        }
        return detObj;
    }

    public DetObj findNodeOf(int nSeriesID, int nGroupID) {
        DetObj detObj = null;
        boolean bFound = false;
        for (int nIdx = this.m_detList.size() - 1; nIdx >= 0 && !bFound; --nIdx) {
            detObj = (DetObj)this.m_detList.elementAt(nIdx);
            if (detObj.getSeriesID() != nSeriesID || detObj.getGroupID() != nGroupID) continue;
            bFound = true;
        }
        return detObj;
    }

    public DetObj findNodeOf(IdentObj id) {
        block5: {
            IdentObj dtoID;
            int i;
            DetObj detObj;
            block4: {
                detObj = null;
                for (i = this.m_detList.size() - 1; i >= 0; --i) {
                    detObj = (DetObj)this.m_detList.elementAt(i);
                    if (detObj == null || !detObj.isDetectable() && (id.getObjectID() != 620 || id.getMiscID() != 627) || !(dtoID = detObj.getIdentID()).equals(id)) continue;
                    return detObj;
                }
                if (id.getObjectID() != -3) break block4;
                for (i = this.m_detList.size() - 1; i >= 0; --i) {
                    detObj = (DetObj)this.m_detList.elementAt(i);
                    if (detObj == null || !detObj.isDetectable() || (dtoID = detObj.getIdentID()).getSeriesID() != id.getSeriesID() || dtoID.getGroupID() != id.getGroupID()) continue;
                    return detObj;
                }
                for (i = this.m_detList.size() - 1; i >= 0; --i) {
                    detObj = (DetObj)this.m_detList.elementAt(i);
                    if (detObj == null || !detObj.isDetectable() || (dtoID = detObj.getIdentID()).getSeriesID() != id.getSeriesID()) continue;
                    return detObj;
                }
                break block5;
            }
            if (!id.isExceptional()) break block5;
            for (i = this.m_detList.size() - 1; i >= 0; --i) {
                detObj = (DetObj)this.m_detList.elementAt(i);
                if (detObj == null || !detObj.isDetectable() || !(dtoID = detObj.getIdentID()).isExceptional() || dtoID.getSeriesID() != id.getSeriesID() || dtoID.getGroupID() != id.getGroupID()) continue;
                return detObj;
            }
        }
        return null;
    }

    public IdentObj getExceptionalID(IdentObj id) {
        if (id == null) {
            return null;
        }
        int s = id.getSeriesID();
        int g = id.getGroupID();
        IdentObj erID = this.m_Perspective.getExceptionalRiser(s, g);
        return erID;
    }

    public Enumeration getList() {
        return this.m_detList.elements();
    }

    public Vector getVectorList() {
        return this.m_detList;
    }

    public Perspective getPerspective() {
        return this.m_Perspective;
    }

    public boolean isExceptional(IdentObj id) {
        IdentObj excID = this.getExceptionalID(id);
        return excID != null;
    }

    public boolean isExceptionalAllowed() {
        return this.m_Perspective.isExceptionalAllowed();
    }

    public void insertDetNode(DetObj detObj) {
        this.m_detList.addElement(detObj);
        this.m_currentDetObj = detObj;
    }

    public void removeDetNode(DetObj detObj) {
        this.m_detList.removeElement(detObj);
        this.m_currentDetObj = (DetObj)this.m_detList.lastElement();
    }

    public void paint(Graphics g, VC vc) {
        for (int i = 0; i < this.m_detList.size(); ++i) {
            DetObj detObj = (DetObj)this.m_detList.elementAt(i);
            detObj.paint(g, vc);
        }
    }

    public void renderSVG(Map context) throws IOException, Exception {
        GraphSVGWriter writer = (GraphSVGWriter)context.get("svgWriter");
        int mode = (Integer)context.get("svgMode");
        boolean bMetadata = (mode & 0x100) != 0;
        String id = null;
        String prevId = null;
        boolean bGroupStarted = false;
        for (int i = 0; i < this.m_detList.size(); ++i) {
            DetObj detObj = (DetObj)this.m_detList.elementAt(i);
            if (bMetadata) {
                id = writer.createElementId(detObj.m_id);
                if (id != prevId) {
                    if (id == null) {
                        if (bGroupStarted) {
                            bGroupStarted = false;
                            writer.endElement();
                        }
                    } else if (!id.equals(prevId)) {
                        if (bGroupStarted) {
                            bGroupStarted = false;
                            writer.endElement();
                        }
                        if (id.length() > 0) {
                            bGroupStarted = true;
                            writer.startElement("g");
                            writer.writeAttribute("id", id);
                        }
                    }
                }
                prevId = id;
            }
            detObj.renderSVG(context);
        }
        if (bGroupStarted) {
            bGroupStarted = false;
            writer.endElement();
        }
    }

    public void renderXML(Map context) throws IOException, Exception {
        for (int i = 0; i < this.m_detList.size(); ++i) {
            DetObj detObj = (DetObj)this.m_detList.elementAt(i);
            detObj.renderXML(context);
        }
        if (this.m_Perspective.getHorzRangeSlider() != null || this.m_Perspective.getY1RangeSlider() != null || this.m_Perspective.getY2RangeSlider() != null) {
            GraphExportXMLWriter writer = (GraphExportXMLWriter)context.get("xmlWriter");
            writer.write("<h id=\"" + RangeSlider.HANDLE_ID[4] + "\"><h/></h>");
            if (this.m_Perspective.getY1RangeSlider() != null) {
                writer.write("<h id=\"" + RangeSlider.HANDLE_ID[2] + "\"><h/></h>");
            }
            if (this.m_Perspective.getY2RangeSlider() != null) {
                writer.write("<h id=\"" + RangeSlider.HANDLE_ID[3] + "\"><h/></h>");
            }
        }
    }

    public void renderXMLWithHandles(Map context) throws IOException, Exception {
        DetObj detObj;
        int i;
        GraphExportXMLWriter writer = (GraphExportXMLWriter)context.get("xmlWriter");
        boolean isPA = false;
        boolean isX1 = false;
        boolean isY1 = false;
        boolean isY2 = false;
        boolean isY2PA = false;
        int currentHandle = 0;
        int newHandle = 0;
        int currentVC = 0;
        int newVC = 0;
        RangeSlider horzRS = this.m_Perspective.getHorzRangeSlider();
        RangeSlider y1RS = this.m_Perspective.getY1RangeSlider();
        RangeSlider y2RS = this.m_Perspective.getY2RangeSlider();
        VC paVC = this.m_Perspective.getRangeSliderVC();
        VC paY2VC = this.m_Perspective.getRangeSliderVC(77);
        Rectangle rFrame = new Rectangle(this.m_Perspective.getFrameRect(false));
        Point depth25D = ((JChart_2D_Standard)this.m_Perspective.getGraphObject()).getFrameObj().getDepthOffset(1.0);
        rFrame.x -= depth25D.x;
        rFrame.width += depth25D.x;
        rFrame.y -= depth25D.y;
        rFrame.height += depth25D.y;
        if (this.m_Perspective.isSplitY(this.m_Perspective.getGraphType())) {
            if (!this.m_Perspective.isChartOrientHorz()) {
                rFrame.height /= 2;
            } else {
                rFrame.width /= 2;
            }
        }
        Vector<DetObj> otherList = new Vector<DetObj>();
        Vector<DetObj> paList = new Vector<DetObj>();
        Vector<DetObj> paY2List = new Vector<DetObj>();
        Vector<DetObj> horzLabelList = new Vector<DetObj>();
        Vector<DetObj> y1LabelList = new Vector<DetObj>();
        Vector<DetObj> y2LabelList = new Vector<DetObj>();
        block15: for (i = 0; i < this.m_detList.size(); ++i) {
            detObj = (DetObj)this.m_detList.elementAt(i);
            switch (detObj.getObjectID()) {
                case 270: 
                case 280: {
                    horzLabelList.add(detObj);
                    continue block15;
                }
                case 284: {
                    y1LabelList.add(detObj);
                    continue block15;
                }
                case 288: 
                case 289: 
                case 290: {
                    y2LabelList.add(detObj);
                    continue block15;
                }
                case 256: 
                case 258: 
                case 259: 
                case 260: 
                case 277: 
                case 303: 
                case 312: 
                case 313: 
                case 314: 
                case 315: 
                case 316: 
                case 317: 
                case 318: 
                case 356: 
                case 389: {
                    int axis = ((JChart_2D_Standard)this.m_Perspective.getGraphObject()).axisAssignedToSeries(detObj.getSeriesID(), DataItem.DI_GENERAL);
                    if (axis == 1) {
                        paY2List.add(detObj);
                        continue block15;
                    }
                }
                case 271: 
                case 272: 
                case 281: 
                case 282: 
                case 285: 
                case 286: 
                case 328: 
                case 329: 
                case 357: 
                case 358: 
                case 390: {
                    paList.add(detObj);
                    continue block15;
                }
                default: {
                    otherList.add(detObj);
                }
            }
        }
        this.m_detList.clear();
        this.m_detList.addAll(otherList);
        this.m_detList.addAll(horzLabelList);
        this.m_detList.addAll(y1LabelList);
        this.m_detList.addAll(y2LabelList);
        this.m_detList.addAll(paList);
        this.m_detList.addAll(paY2List);
        for (i = 0; i < this.m_detList.size(); ++i) {
            detObj = (DetObj)this.m_detList.elementAt(i);
            switch (detObj.getObjectID()) {
                case 256: 
                case 258: 
                case 259: 
                case 260: 
                case 277: 
                case 303: 
                case 312: 
                case 313: 
                case 314: 
                case 315: 
                case 316: 
                case 317: 
                case 318: 
                case 356: 
                case 389: {
                    int axis = ((JChart_2D_Standard)this.m_Perspective.getGraphObject()).axisAssignedToSeries(detObj.getSeriesID(), DataItem.DI_GENERAL);
                    if (axis == 1) {
                        newVC = newHandle = 5;
                        break;
                    }
                }
                case 271: 
                case 272: 
                case 281: 
                case 282: 
                case 285: 
                case 286: 
                case 328: 
                case 329: 
                case 357: 
                case 358: 
                case 390: {
                    newVC = newHandle = 4;
                    break;
                }
                case 270: {
                    newVC = horzRS != null ? 6 : 0;
                    newHandle = 6;
                    break;
                }
                case 280: {
                    newVC = horzRS != null ? 1 : 0;
                    newHandle = 1;
                    break;
                }
                case 284: {
                    newVC = y1RS != null ? 2 : 0;
                    newHandle = 2;
                    break;
                }
                case 288: 
                case 289: 
                case 290: {
                    newVC = y2RS != null ? 3 : 0;
                    newHandle = 3;
                    break;
                }
                default: {
                    newHandle = 0;
                    newVC = 0;
                }
            }
            if (newHandle != currentHandle) {
                if (newHandle == 0 || currentHandle != 0) {
                    writer.endElement();
                }
                if (newHandle == 4) {
                    Rectangle rPA = new Rectangle(rFrame);
                    if (this.m_Perspective.isSplitY(this.m_Perspective.getGraphType())) {
                        if (!this.m_Perspective.isChartOrientHorz()) {
                            rPA.y += rPA.height;
                        } else {
                            rPA.x += rPA.width;
                        }
                    }
                    writer.startHandleElem(RangeSlider.HANDLE_ID[newHandle], this.m_Perspective.getVC().virtToDest(rPA), paVC.virtToDest(rPA));
                } else if (newHandle == 1 || newHandle == 6) {
                    writer.startHandleElem(RangeSlider.HANDLE_ID[newHandle], horzRS != null ? horzRS.getLabelClipRect() : null, null);
                } else if (newHandle == 2) {
                    writer.startHandleElem(RangeSlider.HANDLE_ID[newHandle], y1RS != null ? y1RS.getLabelClipRect() : null, null);
                } else if (newHandle == 5) {
                    writer.startHandleElem(RangeSlider.HANDLE_ID[newHandle], this.m_Perspective.getVC().virtToDest(rFrame), paY2VC.virtToDest(rFrame));
                } else if (newHandle == 3) {
                    writer.startHandleElem(RangeSlider.HANDLE_ID[newHandle], y2RS != null ? y2RS.getLabelClipRect() : null, null);
                }
                currentHandle = newHandle;
            }
            if (newVC != currentVC) {
                if (newVC == 0) {
                    context.put("xmlVC", this.m_Perspective.getVC());
                } else if (newVC == 4) {
                    context.put("xmlVC", paVC);
                } else if (newVC == 1 || newHandle == 6) {
                    context.put("xmlVC", horzRS.getVC());
                } else if (newVC == 2) {
                    context.put("xmlVC", y1RS.getVC());
                } else if (newVC == 5) {
                    context.put("xmlVC", paY2VC);
                } else if (newVC == 3) {
                    context.put("xmlVC", y2RS.getVC());
                }
                currentVC = newVC;
            }
            detObj.renderXML(context);
        }
        if (currentHandle != 0) {
            writer.endElement();
        }
    }

    private void releaseDetListReferences() {
        for (int i = this.m_detList.size() - 1; i >= 0; --i) {
            BlackBoxIF bb;
            DetObj detObj = (DetObj)this.m_detList.elementAt(i);
            if (detObj == null || (bb = detObj.getBlackBox()) == null) continue;
            bb.releaseReferences();
        }
    }

    public void releaseReferences() {
        this.releaseDetListReferences();
        this.m_Perspective = null;
    }

    public void resetList() {
        this.releaseDetListReferences();
        if (this.m_detList.size() > 0) {
            this.m_detList.clear();
        }
    }

    public void setDefaultClipRect(Rectangle r) {
        this.m_defaultClipRect = r;
    }

    public void setExceptionalFlag(boolean bNewValue) {
        this.m_bExceptionalFlag = bNewValue;
    }

    public void addDetMarker(IdentObj id, int markerType, int destX, int destY, int destSize, BlackBoxIF blackBox) {
        this.m_prevDetMarker = DetMarker.addMarker(this, id, markerType, destX, destY, destSize, blackBox, this.m_prevDetMarker);
    }

    public void addDetMarkerAttributes(String key, Object value) {
        this.m_prevDetMarker.addMarkerAttributes(key, value);
    }

    public void addVisualEffectMap(Map map) {
        this.m_prevDetMarker.setVisualEffectsMap(map);
    }

    public void addMarkerLabel(DetLabel detLabel) {
        this.removeDetNode(detLabel);
        if (this.m_prevDetMarker != null) {
            this.m_prevDetMarker.addMarkerLabel(detLabel);
        } else if (this.m_Perspective.isChartBubble()) {
            if (this.m_currentDetObj instanceof DetOval) {
                ((DetOval)this.m_currentDetObj).setMarkerLabel(detLabel);
            } else if (this.m_currentDetObj instanceof DetShape) {
                ((DetShape)this.m_currentDetObj).setMarkerLabel(detLabel);
            }
        }
    }
}

