/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Map;
import oracle.dss.graph.pfj.GraphExportXMLWriter;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;

public class DetSlice
extends DetObj {
    private static final long serialVersionUID = 1L;
    private double m_explode;
    private String m_customLabel;
    private static final Rectangle EMPTY_GRADIENT_RECT = new Rectangle(0, 0, 0, 0);

    public DetSlice(Detectiv detectiv, IdentObj id, BlackBoxIF blackBox, double explode, String customLabel) {
        super(detectiv, id, blackBox, false, true);
        this.m_explode = explode;
        this.m_customLabel = customLabel;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DetSlice)) {
            return false;
        }
        DetSlice DetSlice2 = (DetSlice)obj;
        return this.m_id.equals(DetSlice2.m_id);
    }

    @Override
    public Rectangle getBounds() {
        return null;
    }

    @Override
    public void hilite(Graphics g, VC vc) {
    }

    @Override
    public boolean isPointInObj(int x, int y, VC vc) {
        return this.m_bDetectable && this.getBounds().contains(x, y);
    }

    @Override
    public boolean isPointInObj(Point pt, VC vc) {
        return this.isPointInObj(pt.x, pt.y, vc);
    }

    @Override
    public void paintIt(Graphics g, VC vc) {
    }

    @Override
    public void renderItToSVG(Map context) throws IOException, Exception {
    }

    @Override
    public void renderItToXML(Map context) throws IOException, Exception {
        String drillJS;
        boolean bDrilling;
        GraphExportXMLWriter writer = (GraphExportXMLWriter)context.get("xmlWriter");
        String[] tooltipsArray = null;
        boolean bTooltipTemplate = writer.useTooltipTemplate(this.m_id);
        if (!bTooltipTemplate) {
            tooltipsArray = this.m_Detectiv.getPerspective().getUserTooltipStrings(this);
        }
        String link = null;
        boolean bLink = this.m_Detectiv.getPerspective().isDataLinkEnabled();
        if (bLink && ((link = this.m_Detectiv.getPerspective().getLink(this)) == null || link.length() < 1)) {
            bLink = false;
        }
        boolean bl = bDrilling = (drillJS = writer.getDrillJS(this)) != null && drillJS.length() > 0;
        if (bDrilling && !bTooltipTemplate && tooltipsArray == null) {
            tooltipsArray = new String[]{writer.getDrillTooltip(this)};
        }
        boolean bTooltips = tooltipsArray != null && tooltipsArray.length > 0;
        boolean bElementStarted = false;
        bElementStarted = writer.startPieSliceElement(this.m_id, this.m_blackBox, this.m_explode, this.m_customLabel);
        if (bElementStarted) {
            if (bDrilling) {
                writer.writeAttribute("drillJs", drillJS);
            }
            if (bLink) {
                writer.writeAttribute("link", link);
            }
            if (!writer.hasAlt()) {
                if (bTooltips && tooltipsArray != null) {
                    writer.writeTooltipAttribute(tooltipsArray);
                } else if (!bTooltipTemplate) {
                    writer.writeCachedAttribute("tt", "f", null);
                }
            }
            writer.writeVisualEffectsAttributes(this.m_visualEffectsMap);
            writer.writeCustomPropertiesElement();
            writer.writeFillChildren(this.m_id, this.m_blackBox, EMPTY_GRADIENT_RECT);
            writer.writeBorderChildren(this.m_id, this.m_blackBox, EMPTY_GRADIENT_RECT);
            int graphID = this.m_Detectiv.getPerspective().getReferenceObjectGraphID(this.m_id.getObjectID());
            if (graphID != -1 && this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID) == 2) {
                writer.writeReferenceObjectsElement(this.m_id);
            }
            writer.writeShapeAttributesElement();
            IdentObj sliceID = this.m_id;
            this.m_id = new IdentObj(sliceID);
            this.m_id.setObjectID(295);
            writer.init(this);
            if (writer.hasShapeAttributes()) {
                writer.startElement("psl");
                writer.writeShapeAttributesElement();
                writer.endElement();
            }
            this.m_id = sliceID;
            writer.endElement();
        }
    }

    @Override
    public void setBounds(Rectangle rBounds) {
    }

    @Override
    public Polygon getShape(VC vc) {
        return null;
    }

    @Override
    public boolean isMoveable() {
        return super.isMoveable();
    }
}

