/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.GraphExportXMLWriter;
import oracle.dss.graph.pfj.GraphSVGWriter;
import oracle.dss.graph.pfj.JChart_2D;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;

public class DetRect
extends DetObj {
    private static final long serialVersionUID = 1L;
    public static final float SLOP_FACTOR = 1.05f;
    public static final int PAINT_SHAPE = 0;
    public static final int LINE_AT_TOP = 1;
    public static final int LINE_AT_BOTTOM = 2;
    public static final int LINE_AT_LEFT = 3;
    public static final int LINE_AT_RIGHT = 4;
    public static final int PERFECT_SQUARE = 5;
    Rectangle m_rBounds;
    Rectangle m_rLooseBounds;
    Rectangle m_rDestBounds;
    boolean m_bLooseBounds;
    boolean m_bDotted = false;
    int m_draw = 0;
    Rectangle m_clipRect;

    public DetRect(Detectiv detectiv, IdentObj id, int x, int y, int width, int height, BlackBoxIF blackBox) {
        this(detectiv, id, x, y, width, height, blackBox, null, false, true, false);
    }

    public DetRect(Detectiv detectiv, IdentObj id, int x, int y, int width, int height, BlackBoxIF blackBox, boolean bDotted) {
        this(detectiv, id, x, y, width, height, blackBox, null, false, true, false);
        this.m_bDotted = bDotted;
    }

    public DetRect(Detectiv detectiv, IdentObj id, int x, int y, int width, int height, BlackBoxIF blackBox, boolean bMoveable, boolean bDetectable) {
        this(detectiv, id, x, y, width, height, blackBox, null, bMoveable, bDetectable, false);
    }

    public DetRect(Detectiv detectiv, IdentObj id, int width, int height, BlackBoxIF blackBox, Rectangle clipRect) {
        this(detectiv, id, 0, 0, width, height, blackBox, clipRect, false, true, false);
    }

    public DetRect(Detectiv detectiv, IdentObj id, Rectangle r, BlackBoxIF blackBox, Rectangle clipRect) {
        this(detectiv, id, r.x, r.y, r.width, r.height, blackBox, clipRect, false, true, false);
    }

    public DetRect(Detectiv detectiv, IdentObj id, Rectangle r, BlackBoxIF blackBox, Rectangle clipRect, int type) {
        this(detectiv, id, r.x, r.y, r.width, r.height, blackBox, clipRect, false, true, false);
        this.m_draw = type;
    }

    public DetRect(Detectiv detectiv, IdentObj id, Rectangle r, BlackBoxIF blackBox, boolean bHiliteable, Rectangle clipRect) {
        this(detectiv, id, r, blackBox, bHiliteable);
        this.m_clipRect = clipRect;
    }

    public DetRect(Detectiv detectiv, IdentObj id, Rectangle r, BlackBoxIF blackBox, boolean bHiliteable) {
        super(detectiv, id, blackBox, false, true, bHiliteable);
        this.m_draw = 5;
        this.m_rDestBounds = r;
        if (id.getObjectID() == 277 && this.m_rDestBounds != null) {
            boolean bHorz = this.m_Detectiv.getPerspective().getJGraphType().isOrientHorz();
            if (bHorz) {
                int destWidth = this.m_rDestBounds.height;
            } else {
                int destWidth = this.m_rDestBounds.width;
            }
            this.setVisualEffectsMap(JChart_2D.getBarEffectsMap(this.m_rDestBounds.width));
        }
    }

    public DetRect(Detectiv detectiv, IdentObj id, int x, int y, int width, int height, BlackBoxIF blackBox, Rectangle clipRect, boolean bMoveable, boolean bDetectable, boolean bLooseBounds) {
        super(detectiv, id, blackBox, bMoveable, bDetectable);
        this.m_clipRect = clipRect;
        this.m_bLooseBounds = bLooseBounds;
        this.m_rBounds = new Rectangle(x, y, width, height);
        if (bLooseBounds) {
            this.m_rLooseBounds = new Rectangle(x, y, width, height);
            this.setBounds(x, y, width, height);
        } else {
            this.m_rLooseBounds = this.m_rBounds;
        }
        if (id.getObjectID() == 277 && this.m_rBounds != null) {
            boolean bHorz = this.m_Detectiv.getPerspective().getJGraphType().isOrientHorz();
            int destWidth = bHorz ? this.m_Detectiv.getPerspective().getVC().virtToDestWidth(this.m_rBounds.height) : this.m_Detectiv.getPerspective().getVC().virtToDestWidth(this.m_rBounds.width);
            this.setVisualEffectsMap(JChart_2D.getBarEffectsMap(destWidth));
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DetRect)) {
            return false;
        }
        DetRect detRect = (DetRect)obj;
        return this.m_id.equals(detRect.m_id);
    }

    @Override
    public Rectangle getBounds() {
        if (this.m_draw == 5) {
            Rectangle rect = this.m_Detectiv.getPerspective().getVC().destToVirt(this.m_rDestBounds);
            return new Rectangle(rect.x, rect.y, rect.width, rect.height);
        }
        return new Rectangle(this.m_rBounds.x, this.m_rBounds.y, this.m_rBounds.width, this.m_rBounds.height);
    }

    @Override
    public Rectangle getLooseBounds() {
        if (this.m_draw == 5) {
            Rectangle rect = this.m_Detectiv.getPerspective().getVC().destToVirt(this.m_rDestBounds);
            return new Rectangle(rect.x, rect.y, rect.width, rect.height);
        }
        return new Rectangle(this.m_rLooseBounds.x, this.m_rLooseBounds.y, this.m_rLooseBounds.width, this.m_rLooseBounds.height);
    }

    @Override
    public void hilite(Graphics g, VC vc) {
        if (this.m_draw == 0 || this.m_draw == 5) {
            Rectangle dest = null;
            dest = this.m_draw == 5 ? this.m_rDestBounds : vc.virtToDest(this.m_rBounds);
            g.setXORMode(Color.yellow);
            g.drawRect(dest.x, dest.y, dest.width, dest.height);
            g.setPaintMode();
        } else {
            Rectangle dest = vc.virtToDest(this.m_rBounds);
            g.setXORMode(Color.yellow);
            int x1 = 0;
            int x2 = 0;
            int y1 = 0;
            int y2 = 0;
            if (this.m_draw == 2) {
                x1 = dest.x;
                y1 = dest.y + dest.height;
                x2 = dest.x + dest.width;
                y2 = y1;
            } else if (this.m_draw == 1) {
                x1 = dest.x;
                y1 = dest.y;
                x2 = x1 + dest.width;
                y2 = y1;
            } else if (this.m_draw == 3) {
                x1 = dest.x;
                y1 = dest.y;
                x2 = dest.x;
                y2 = dest.y + dest.height;
            } else if (this.m_draw == 4) {
                x1 = dest.x + dest.width;
                y1 = dest.y;
                x2 = x1;
                y2 = dest.y + dest.height;
            }
            g.drawLine(x1, y1, x2, y2);
            g.setPaintMode();
        }
    }

    @Override
    public boolean isPointInObj(int x, int y, VC vc) {
        if (this.m_draw == 5) {
            return this.m_bDetectable && this.m_rDestBounds.contains(vc.virtToDestX(x), vc.virtToDestY(y));
        }
        return this.m_bDetectable && this.m_rLooseBounds.contains(x, y);
    }

    @Override
    public boolean isPointInObj(Point pt, VC vc) {
        return this.isPointInObj(pt.x, pt.y, vc);
    }

    @Override
    public void paintIt(Graphics g, VC vc) {
        if (this.m_draw != 0 && this.m_draw != 5) {
            this.m_blackBox.paint(g, vc.virtToDest(this.m_rBounds), this.m_draw);
            return;
        }
        if (this.m_clipRect != null) {
            Rectangle rClip = vc.virtToDest(this.m_clipRect);
            Shape shape = g.getClip();
            if (shape == null) {
                g.setClip(rClip);
            }
            if (this.m_draw == 5) {
                this.m_blackBox.paint(g, this.m_rDestBounds);
            } else if (this.m_bDotted) {
                this.m_blackBox.paint(g, vc.virtToDest(this.m_rBounds), false, true);
            } else {
                this.m_blackBox.paint(g, vc.virtToDest(this.m_rBounds));
            }
            g.setClip(shape);
        } else {
            if (this.m_draw == 5) {
                this.m_blackBox.paint(g, this.m_rDestBounds);
                return;
            }
            if (this.m_bDotted) {
                this.m_blackBox.paint(g, vc.virtToDest(this.m_rBounds), false, true, true);
            } else {
                this.m_blackBox.paint(g, vc.virtToDest(this.m_rBounds));
            }
        }
    }

    @Override
    public void renderItToSVG(Map context) throws IOException, Exception {
        boolean bOnMouseOverOutPresent;
        boolean bOnClickPresent;
        GraphSVGWriter writer = (GraphSVGWriter)context.get("svgWriter");
        VC vc = (VC)context.get("svgVC");
        int mode = (Integer)context.get("svgMode");
        boolean bTooltips = (mode & 2) != 0;
        String[] tooltipsArray = null;
        if (bTooltips) {
            tooltipsArray = this.m_Detectiv.getPerspective().getUserTooltipStrings(this);
        }
        boolean bShapeAttributes = (mode & 0x10) != 0;
        String clickEventJS = null;
        boolean bl = bOnClickPresent = bShapeAttributes && writer.isOnClickPresent();
        if (bShapeAttributes && !bOnClickPresent) {
            clickEventJS = writer.getClickEventJS();
        }
        boolean bl2 = bOnMouseOverOutPresent = bShapeAttributes && writer.isOnMouseOverOutPresent();
        if (bOnMouseOverOutPresent) {
            bTooltips = false;
        }
        String saAlt = null;
        String saTitle = null;
        String saHRef = null;
        String saTarget = null;
        if (bShapeAttributes) {
            saAlt = writer.getShapeAttributesAlt();
            saTitle = writer.getShapeAttributesTitle();
            if (!bOnClickPresent) {
                saHRef = writer.getShapeAttributesHRef();
            }
            saTarget = writer.getShapeAttributesTarget();
        }
        boolean bDrilling = (mode & 4) != 0;
        bDrilling = bDrilling && !bOnClickPresent && clickEventJS == null;
        String drillJS = null;
        String link = null;
        boolean bLink = this.m_Detectiv.getPerspective().isDataLinkEnabled();
        if (bLink && ((link = writer.getLink(this)) == null || link.length() < 1)) {
            bLink = false;
        }
        if (bDrilling && ((drillJS = writer.getDrillJS(this)) == null || drillJS.length() < 1)) {
            bDrilling = false;
        }
        if (bTooltips) {
            if (saAlt != null) {
                tooltipsArray = new String[]{saAlt};
            } else if (saTitle != null) {
                tooltipsArray = new String[]{saTitle};
            }
        }
        if (bDrilling && bTooltips && tooltipsArray == null) {
            tooltipsArray = new String[]{writer.getDrillTooltip(this)};
        }
        bTooltips = bTooltips && tooltipsArray != null && tooltipsArray.length > 0;
        boolean bStartA = bDrilling || bOnClickPresent || clickEventJS != null || saHRef != null || bLink;
        boolean bAnchorGroup = false;
        if (bStartA) {
            writer.startElement("a");
            String href = "";
            if (clickEventJS == null && !bDrilling && saHRef != null) {
                href = saHRef;
            } else if (clickEventJS == null && !bDrilling && bLink) {
                href = link;
            }
            writer.writeAttribute("xlink:href", href);
            if (saTarget != null) {
                writer.writeAttribute("target", saTarget);
            }
            String strOnclick = null;
            if (clickEventJS != null) {
                strOnclick = clickEventJS;
            } else if (bDrilling) {
                strOnclick = drillJS;
            }
            if (strOnclick != null) {
                bAnchorGroup = true;
                writer.startElement("g");
                writer.writeAttribute("onclick", strOnclick);
            }
        }
        boolean bTimeSelectorGroup = false;
        if (this.m_id.getObjectID() == 513) {
            bTimeSelectorGroup = true;
            writer.startElement("g");
            writer.writeAttribute("id", writer.getTimeSelectorGroupId());
        }
        boolean bElementStarted = false;
        bElementStarted = this.m_draw != 0 && this.m_draw != 5 ? writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest(this.m_rBounds), this.m_draw) : (this.m_clipRect != null ? (this.m_bDotted ? writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest(this.m_rBounds), false, true) : writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest(this.m_rBounds))) : (this.m_draw == 5 ? writer.startElement(this.m_id, this.m_blackBox, this.m_rDestBounds) : (this.m_bDotted ? writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest(this.m_rBounds), false, true, true) : writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest(this.m_rBounds)))));
        if (bElementStarted) {
            if (this.m_id.getObjectID() == 2 && (this.m_Detectiv.getPerspective().isTimeAxis() || this.m_Detectiv.getPerspective().isContinuousTimeAxis()) && (mode & 0x80) != 0) {
                writer.writeAttribute("onclick", writer.getTimeAxisEventClickJS());
            }
            if (bShapeAttributes) {
                writer.writeShapeAttributes();
            }
            if (bTooltips) {
                int rbMode;
                List l;
                int graphID;
                String onMouseOverJS = null;
                String onMouseOutJS = null;
                if (bTimeSelectorGroup) {
                    onMouseOverJS = writer.getTimeSelectorOnMouseOverJS();
                    onMouseOutJS = writer.getTimeSelectorOnMouseOutJS();
                    String onMouseDownJS = writer.getTimeSelectorOnMouseDownJS();
                    String onMouseMoveJS = writer.getTimeSelectorOnMouseMoveJS();
                    if (onMouseOverJS != null && onMouseOutJS != null && onMouseDownJS != null && onMouseMoveJS != null) {
                        context.put("svgHasTimeSelector", Boolean.TRUE);
                        writer.writeAttribute("id", writer.getTimeSelectorRectId());
                        writer.writeAttribute("onmousedown", onMouseDownJS);
                        writer.writeAttribute("onmousemove", onMouseMoveJS);
                    }
                }
                if ((graphID = this.m_Detectiv.getPerspective().getReferenceObjectGraphID(this.m_id.getObjectID())) != -1 && this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID) == 2 && (l = writer.getReferenceObjects(this.m_id)) != null) {
                    context.put("svgHasReferenceObj", Boolean.TRUE);
                    StringBuilder strBuf = new StringBuilder("evt,");
                    for (int i = 0; i < l.size() - 1; ++i) {
                        strBuf.append("'" + (String)l.get(i) + "',");
                    }
                    strBuf.append("'" + (String)l.get(l.size() - 1) + "'");
                    onMouseOverJS = onMouseOverJS == null ? "bi_refObj_show_mOver(" + strBuf.toString() + ");" : onMouseOverJS + "bi_refObj_show_mOver(" + strBuf.toString() + ");";
                    onMouseOutJS = onMouseOutJS == null ? "bi_refObj_hide_mOut(" + strBuf.toString() + ");" : onMouseOutJS + "bi_refObj_hide_mOut(" + strBuf.toString() + ");";
                }
                if ((rbMode = this.m_Detectiv.getPerspective().getIntegerProp(Attr.SeriesRolloverBehavior)) != 0) {
                    String shfOver = "bi_rollover(evt, true, '" + writer.getSimpleBeanName() + "');";
                    String shfOut = "bi_rollover(evt, false, '" + writer.getSimpleBeanName() + "');";
                    onMouseOverJS = onMouseOverJS != null ? onMouseOverJS + shfOver : shfOver;
                    onMouseOutJS = onMouseOutJS != null ? onMouseOutJS + shfOut : shfOut;
                }
                writer.writeTooltip(tooltipsArray, onMouseOverJS, onMouseOutJS);
            } else {
                List l;
                int graphID;
                String onMouseOverJS = null;
                String onMouseOutJS = null;
                int rbMode = this.m_Detectiv.getPerspective().getIntegerProp(Attr.SeriesRolloverBehavior);
                if (rbMode != 0 && this.m_id.isSeriesRelated()) {
                    String shfOver = "bi_rollover(evt, true, '" + writer.getSimpleBeanName() + "');";
                    String shfOut = "bi_rollover(evt, false, '" + writer.getSimpleBeanName() + "');";
                    onMouseOverJS = onMouseOverJS != null ? onMouseOverJS + shfOver : shfOver;
                    onMouseOutJS = onMouseOutJS != null ? onMouseOutJS + shfOut : shfOut;
                }
                if ((graphID = this.m_Detectiv.getPerspective().getReferenceObjectGraphID(this.m_id.getObjectID())) != -1 && this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID) == 2 && (l = writer.getReferenceObjects(this.m_id)) != null) {
                    context.put("svgHasReferenceObj", Boolean.TRUE);
                    StringBuilder strBuf = new StringBuilder("evt,");
                    for (int i = 0; i < l.size() - 1; ++i) {
                        strBuf.append("'" + (String)l.get(i) + "',");
                    }
                    strBuf.append("'" + (String)l.get(l.size() - 1) + "'");
                    onMouseOverJS = onMouseOverJS == null ? "bi_refObj_show_mOver(" + strBuf.toString() + ");" : onMouseOverJS + "bi_refObj_show_mOver(" + strBuf.toString() + ");";
                    onMouseOutJS = onMouseOutJS == null ? "bi_refObj_hide_mOut(" + strBuf.toString() + ");" : onMouseOutJS + "bi_refObj_hide_mOut(" + strBuf.toString() + ");";
                }
                if (bTimeSelectorGroup) {
                    String moverjs = writer.getTimeSelectorOnMouseOverJS();
                    onMouseOverJS = onMouseOverJS == null ? moverjs : onMouseOverJS + moverjs;
                    String moutjs = writer.getTimeSelectorOnMouseOutJS();
                    onMouseOutJS = onMouseOutJS == null ? moutjs : onMouseOutJS + moutjs;
                    String onMouseDownJS = writer.getTimeSelectorOnMouseDownJS();
                    String onMouseMoveJS = writer.getTimeSelectorOnMouseMoveJS();
                    if (moverjs != null && moutjs != null && onMouseDownJS != null && onMouseMoveJS != null) {
                        context.put("svgHasTimeSelector", Boolean.TRUE);
                        writer.writeAttribute("id", writer.getTimeSelectorRectId());
                        writer.writeAttribute("onmousedown", onMouseDownJS);
                        writer.writeAttribute("onmousemove", onMouseMoveJS);
                    }
                }
                if (onMouseOverJS != null) {
                    writer.writeAttribute("onmouseover", onMouseOverJS);
                }
                if (onMouseOutJS != null) {
                    writer.writeAttribute("onmouseout", onMouseOutJS);
                }
                if (saTitle != null) {
                    writer.writeTitleElement(saTitle);
                }
            }
            writer.endElement();
        }
        if (bTimeSelectorGroup) {
            writer.endElement();
        }
        if (bStartA) {
            if (bAnchorGroup) {
                writer.endElement();
            }
            writer.endElement();
        }
    }

    @Override
    public void renderItToXML(Map context) throws IOException, Exception {
        Rectangle rPieSliceLabelFrame;
        String drillJS;
        boolean bDrilling;
        GraphExportXMLWriter writer = (GraphExportXMLWriter)context.get("xmlWriter");
        VC vc = (VC)context.get("xmlVC");
        String[] tooltipsArray = null;
        boolean bTooltipTemplate = writer.useTooltipTemplate(this.m_id);
        if (!bTooltipTemplate) {
            tooltipsArray = this.m_Detectiv.getPerspective().getUserTooltipStrings(this);
        }
        String link = null;
        boolean bLink = this.m_Detectiv.getPerspective().isDataLinkEnabled();
        if (bLink && ((link = this.m_Detectiv.getPerspective().getLink(this)) == null || link.length() < 1)) {
            bLink = false;
        }
        boolean bl = bDrilling = (drillJS = writer.getDrillJS(this)) != null && drillJS.length() > 0;
        if (bDrilling && !bTooltipTemplate && tooltipsArray == null) {
            tooltipsArray = new String[]{writer.getDrillTooltip(this)};
        }
        boolean bTooltips = tooltipsArray != null && tooltipsArray.length > 0;
        boolean bElementStarted = false;
        Rectangle boundsRect = null;
        if (this.m_id.getObjectID() == 302 && this.m_Detectiv.getPerspective().getGraphType() == 55 && (rPieSliceLabelFrame = this.m_Detectiv.getPerspective().getRect(391)) != null && rPieSliceLabelFrame.width != 0 && rPieSliceLabelFrame.height != 0) {
            this.m_rBounds = rPieSliceLabelFrame;
        }
        if (this.m_draw != 0 && this.m_draw != 5) {
            bElementStarted = writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest(this.m_rBounds), this.m_draw);
            boundsRect = vc.virtToDest(this.m_rBounds);
        } else if (this.m_clipRect != null) {
            bElementStarted = this.m_bDotted ? writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest(this.m_rBounds), false, true) : writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest(this.m_rBounds));
            boundsRect = vc.virtToDest(this.m_rBounds);
        } else if (this.m_draw == 5) {
            bElementStarted = writer.startElement(this.m_id, this.m_blackBox, this.m_rDestBounds);
            boundsRect = this.m_rDestBounds;
        } else if (this.m_bDotted) {
            bElementStarted = writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest(this.m_rBounds), false, true, true);
            boundsRect = vc.virtToDest(this.m_rBounds);
        } else {
            bElementStarted = writer.startElement(this.m_id, this.m_blackBox, vc.virtToDest(this.m_rBounds));
            boundsRect = vc.virtToDest(this.m_rBounds);
        }
        if (bElementStarted) {
            if (this.m_Detectiv.getPerspective().isTimeAxis() || this.m_Detectiv.getPerspective().isContinuousTimeAxis()) {
                String timeAxisEventJs;
                if (this.m_id.getObjectID() == 2 && (timeAxisEventJs = writer.getTimeAxisEventSubmitJS()) != null && timeAxisEventJs.length() > 0) {
                    writer.writeAttribute("timeAxisEventJs", timeAxisEventJs);
                }
                if (this.m_id.getObjectID() == 513) {
                    String translatedEnd;
                    writer.writeAttribute("timeSelectorEventJs", writer.getTimeSelectorSubmitJS());
                    writer.writeAttribute("timeAxisStartDate", this.m_Detectiv.getPerspective().getStartDateOfTimeAxis());
                    writer.writeAttribute("timeAxisEndDate", this.m_Detectiv.getPerspective().getEndDateOfTimeAxis());
                    writer.writeAttribute("timeAxisStartPixel", this.m_Detectiv.getPerspective().getStartPixelTimeAxis());
                    writer.writeAttribute("timeAxisEndPixel", this.m_Detectiv.getPerspective().getEndPixelTimeAxis());
                    String translatedStart = (String)context.get("xmlTranslatedStart");
                    if (translatedStart != null && translatedStart.length() > 0) {
                        writer.writeAttribute("translatedStart", translatedStart);
                    }
                    if ((translatedEnd = (String)context.get("xmlTranslatedEnd")) != null && translatedEnd.length() > 0) {
                        writer.writeAttribute("translatedEnd", translatedEnd);
                    }
                    writer.writeAttribute("timeAxisResources", GraphExportXMLWriter.getTimeAxisResources(this.m_Detectiv.getPerspective()));
                    writer.writeAttribute("timeZone", GraphExportXMLWriter.getTimeZoneOffset(this.m_Detectiv.getPerspective()));
                }
            }
            writer.writeDataZoomAndScrollEventJsAttributes(this);
            if (bDrilling) {
                writer.writeAttribute("drillJs", drillJS);
            }
            if (bLink) {
                writer.writeAttribute("link", link);
            }
            writer.writeVisualEffectsAttributes(this.m_visualEffectsMap);
            if (!writer.hasAlt()) {
                if (bTooltips) {
                    writer.writeTooltipAttribute(tooltipsArray);
                } else if (!bTooltipTemplate) {
                    writer.writeCachedAttribute("tt", "f", null);
                }
            }
            writer.writeCustomPropertiesElement();
            writer.writeShapeAttributesElement();
            writer.writeFillChildren(this.m_id, this.m_blackBox, boundsRect);
            writer.writeBorderChildren(this.m_id, this.m_blackBox, boundsRect);
            int graphID = this.m_Detectiv.getPerspective().getReferenceObjectGraphID(this.m_id.getObjectID());
            if (graphID != -1 && this.m_Detectiv.getPerspective().getReferenceObjectDisplay(graphID) == 2) {
                writer.writeReferenceObjectsElement(this.m_id);
            }
            writer.endElement();
        }
    }

    @Override
    public void setBounds(Rectangle rBounds) {
        this.setBounds(rBounds.x, rBounds.y, rBounds.width, rBounds.height);
    }

    public void setBounds(int x, int y, int w, int h) {
        this.m_rBounds.x = x;
        this.m_rBounds.y = y;
        this.m_rBounds.width = w;
        this.m_rBounds.height = h;
        if (this.m_bLooseBounds) {
            float xCenter = (float)x + (float)w / 2.0f;
            float yCenter = (float)y + (float)h / 2.0f;
            float fWidth = (float)w * 1.05f;
            float fHeight = (float)h * 1.05f;
            this.m_rLooseBounds.x = (int)((double)xCenter - (double)fWidth / 2.0);
            this.m_rLooseBounds.y = (int)((double)yCenter - (double)fHeight / 2.0);
            this.m_rLooseBounds.width = (int)fWidth;
            this.m_rLooseBounds.height = (int)fHeight;
        }
    }

    @Override
    public Polygon getShape(VC vc) {
        if (this.m_rDestBounds != null) {
            return this.rectToPoly(vc.destToVirt(this.m_rDestBounds));
        }
        return this.rectToPoly(this.m_rBounds);
    }
}

