/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.DataStyleCallback;
import oracle.dss.graph.DataStyleContext;
import oracle.dss.graph.DataStyleType;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.DataStyle;
import oracle.dss.graph.pfj.GraphExportXMLWriter;
import oracle.dss.graph.pfj.MarkerTemplate;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.draw.DetMarker;
import oracle.dss.presutil.PresUtils;

public class ScatterGraphDataStyle
extends DataStyle {
    Perspective m_pfj;
    private String m_markerShapeRELayerName;
    private String m_markerColorRELayerName;
    private String m_underlayShapeALayerName;
    private String m_underlayColorALayerName;
    private boolean bMarkerShape = false;
    private boolean bMarkerColor = false;
    private boolean bUnderlayShape = false;
    private boolean bUnderlayColor = false;
    private boolean bSeriesAreRows;
    private int m_prevSlice = -1;

    public ScatterGraphDataStyle(CommonGraph graph) {
        super(graph);
        this.m_pfj = graph.getPFJ();
        this.m_underlayShapeALayerName = graph.getMarkerUnderlayShapeAttribute();
        this.m_underlayColorALayerName = graph.getMarkerUnderlayColorAttribute();
        this.bUnderlayShape = this.m_underlayShapeALayerName != null;
        boolean bl = this.bUnderlayColor = this.m_underlayColorALayerName != null;
        if (this.m_pfj.getJGraphType().isScatter()) {
            this.m_markerShapeRELayerName = graph.getMarkerShapeAttribute();
            this.m_markerColorRELayerName = graph.getMarkerColorAttribute();
            this.bMarkerShape = this.m_markerShapeRELayerName != null;
            this.bMarkerColor = this.m_markerColorRELayerName != null;
        }
        this.bSeriesAreRows = this.m_pfj.getSeriesAreRows();
    }

    public void addStyleKeys(int row, int col) {
        int slice;
        int edge;
        if (this.bSeriesAreRows) {
            edge = 1;
            slice = row;
        } else {
            edge = 0;
            slice = col;
        }
        if (row != this.m_prevSlice) {
            if (this.bMarkerShape) {
                this.addKeyFromEdgeMetadata(DataStyleType.MARKER_SHAPE, this.m_markerShapeRELayerName, edge, slice);
            }
            if (this.bMarkerColor) {
                this.addKeyFromEdgeMetadata(DataStyleType.MARKER_COLOR, this.m_markerColorRELayerName, edge, slice);
            }
            ++this.m_prevSlice;
        }
        if (this.m_pfj.getJGraphType().isScatter() && (this.bSeriesAreRows ? col : row) % 2 == 0 || this.m_pfj.getJGraphType().isBubble() && (this.bSeriesAreRows ? col : row) % 3 == 0) {
            DataStyleContext context;
            if (this.bUnderlayShape) {
                context = this.addKeyFromAnalyticLayer(DataStyleType.UNDERLAY_SHAPE, this.m_underlayShapeALayerName, row, col);
                this.updateValueFromCallback(context);
            }
            if (this.bUnderlayColor) {
                context = this.addKeyFromAnalyticLayer(DataStyleType.UNDERLAY_COLOR, this.m_underlayColorALayerName, row, col);
                this.updateValueFromCallback(context);
            }
        }
    }

    public DataStyleType.Shape getMarkerShape(int row, int col) {
        Object key;
        Object object = key = this.bSeriesAreRows ? this.getKeyFromEdgeMetadata(this.m_markerShapeRELayerName, 1, row) : this.getKeyFromEdgeMetadata(this.m_markerShapeRELayerName, 0, col);
        if (key == null) {
            return null;
        }
        return (DataStyleType.Shape)((Object)this.getStyleValue(DataStyleType.MARKER_SHAPE, key));
    }

    public Color getMarkerColor(int row, int col) {
        Object key;
        Object object = key = this.bSeriesAreRows ? this.getKeyFromEdgeMetadata(this.m_markerColorRELayerName, 1, row) : this.getKeyFromEdgeMetadata(this.m_markerColorRELayerName, 0, col);
        if (key == null) {
            return null;
        }
        return (Color)this.getStyleValue(DataStyleType.MARKER_COLOR, key);
    }

    public DataStyleType.Shape getUnderlayShape(int row, int col) {
        Object key = this.getKeyFromAnalyticLayer(this.m_underlayShapeALayerName, row, col);
        if (key == null) {
            return null;
        }
        return (DataStyleType.Shape)((Object)this.getStyleValue(DataStyleType.UNDERLAY_SHAPE, key));
    }

    public Color getUnderlayColor(int row, int col) {
        Object key = this.getKeyFromAnalyticLayer(this.m_underlayColorALayerName, row, col);
        if (key == null) {
            return null;
        }
        return (Color)this.getStyleValue(DataStyleType.UNDERLAY_COLOR, key);
    }

    public List getUnderlayAttributesFromSeries(int s, int g) {
        if (s < 0 || g < 0) {
            return null;
        }
        int row = this.m_pfj.m_chart.m_Access.getRow(s, g);
        int col = this.m_pfj.m_chart.m_Access.getCol(s, g);
        return this.getUnderlayAttributes(row, col);
    }

    public List getUnderlayAttributes(int row, int col) {
        DataStyleType.Shape shape = this.getUnderlayShape(row, col);
        Color color = this.getUnderlayColor(row, col);
        if (shape == null && color == null) {
            return null;
        }
        if (shape == null) {
            shape = this.getDefaultShape();
        }
        if (color == null) {
            color = this.getDefaultColor();
        }
        ArrayList<Object> attribs = new ArrayList<Object>(2);
        attribs.add((Object)shape);
        attribs.add(color);
        return attribs;
    }

    public Color getDefaultColor() {
        return new Color(Color.GRAY.getRed(), Color.GRAY.getGreen(), Color.GRAY.getBlue(), 143);
    }

    public DataStyleType.Shape getDefaultShape() {
        return DataStyleType.Shape.SQUARE;
    }

    public void writeUnderlayXML(GraphExportXMLWriter writer, int s, int g) throws Exception {
        if (!this.bUnderlayColor && !this.bUnderlayShape || writer == null) {
            return;
        }
        List attribs = this.getUnderlayAttributesFromSeries(s, g);
        if (attribs != null) {
            int markerType = ((MarkerTemplate)attribs.get(UnderlayAttributesIndex.Shape.getId())).getMarkerType();
            Color markerColor = (Color)attribs.get(UnderlayAttributesIndex.Color.getId());
            writer.writeAttribute("ums", DetMarker.convertMarkerShapeToString(markerType));
            writer.writeAttribute("umc", PresUtils.toHexStringWithAlpha(markerColor.getRGB()));
        }
    }

    @Override
    protected Object assignValue(DataStyleType styleType, Object styleKey, int styleKeyId) {
        Object val = null;
        if (styleType == DataStyleType.MARKER_SHAPE) {
            val = this.assignDefaultShape(styleKeyId % 7);
        } else if (styleType == DataStyleType.MARKER_COLOR) {
            val = this.assignDefaultColor(styleKey, styleKeyId + 3);
        } else if (styleType == DataStyleType.UNDERLAY_SHAPE) {
            val = this.assignDefaultShape((styleKeyId + 2) % 5);
        } else if (styleType == DataStyleType.UNDERLAY_COLOR) {
            Color c = this.assignDefaultColor(styleKey, styleKeyId + 5);
            val = new Color(c.getRed(), c.getGreen(), c.getBlue(), 143);
        }
        return val;
    }

    private DataStyleType.Shape assignDefaultShape(int offset) {
        DataStyleType.Shape val = null;
        switch (offset) {
            case 1: {
                val = DataStyleType.Shape.SQUARE;
                break;
            }
            case 2: {
                val = DataStyleType.Shape.CIRCLE;
                break;
            }
            case 3: {
                val = DataStyleType.Shape.DIAMOND;
                break;
            }
            case 4: {
                val = DataStyleType.Shape.TRIANGLE_DN;
                break;
            }
            case 0: {
                val = DataStyleType.Shape.TRIANGLE_UP;
                break;
            }
            case 5: {
                val = DataStyleType.Shape.PLUS;
            }
            case 6: {
                val = DataStyleType.Shape.HUMAN;
            }
        }
        return val;
    }

    private Color assignDefaultColor(Object key, int offset) {
        Color val = this.parseColor(key);
        if (val == null) {
            val = (Color)Attr.SeriesFillColor[offset % 12].getDefault();
        }
        return val;
    }

    private Color parseColor(Object key) {
        if (key instanceof Color) {
            return (Color)key;
        }
        if (key instanceof Integer) {
            return new Color((Integer)key);
        }
        if (key instanceof String && ((String)key).startsWith("#")) {
            return DataviewUtils.hexStringToColor((String)key);
        }
        return null;
    }

    public boolean isMarkerShapePresent() {
        return this.bMarkerShape;
    }

    public boolean isMarkerColorPresent() {
        return this.bMarkerColor;
    }

    public boolean isUnderlayShapePresent() {
        return this.bUnderlayShape;
    }

    public boolean isUnderlayColorPresent() {
        return this.bUnderlayColor;
    }

    private void updateValueFromCallback(DataStyleContext context) {
        DataStyleCallback callback = this.m_graph.getDataStyleCallback();
        if (callback != null && context != null) {
            DataStyleType type = context.getType();
            Object temp = callback.getDataStyle(context.getType(), context);
            Object val = null;
            if (type == DataStyleType.MARKER_SHAPE || type == DataStyleType.UNDERLAY_SHAPE) {
                val = temp;
            } else if (type == DataStyleType.MARKER_COLOR || type == DataStyleType.UNDERLAY_COLOR) {
                val = this.parseColor(temp);
            }
            DataStyleContext newContext = new DataStyleContext(context.getAttributeName(), context.getAttributeName(), val, context.getType(), context.getSeries(), context.getID());
            int contextId = this.getStyleId(context.getType(), context.getAttributeValue());
            this.m_contextList.remove(contextId);
            this.m_contextList.add(contextId, newContext);
        }
    }

    public static enum UnderlayAttributesIndex {
        Shape(0),
        Color(1);

        private final int idx;

        private UnderlayAttributesIndex(int id) {
            this.idx = id;
        }

        public int getId() {
            return this.idx;
        }
    }
}

