/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Date;
import java.util.Map;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.GraphExportXMLWriter;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.RangeSliderVC;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.math.FP;

public class RangeSlider {
    private int rsID;
    private int rsAxisID;
    private Rectangle rsRect = new Rectangle();
    private int rsThumbStart = 0;
    private int rsThumbLen = 0;
    private MinMaxObj rsZoomMinMax = null;
    private double rsAxisMin = 0.0;
    private double rsAxisMax = 0.0;
    private boolean rsAutoMin = true;
    private boolean rsAutoMax = true;
    private Double rsZoomRangeMin = null;
    private Double rsZoomRangeMax = null;
    private int rsZoomViewableGroups = 0;
    private int rsZoomGroupOffset = 0;
    public static double RS_NO_ZOOM = 1.0;
    public static double RS_MAX_ZOOM = 16.0;
    private double rsZoomRatio = RS_NO_ZOOM;
    private Perspective rsPFJ = null;
    private Rectangle cachedFrameRect = null;
    private int rsFrameStart = 0;
    private int rsFrameLen = 0;
    private int rsLabelVirtStart = Integer.MAX_VALUE;
    private int rsLabelVirtEnd = 0;
    private boolean rsIsVertical;
    private boolean rsIsLiveScroll = false;
    private Rectangle rsLabelClipRect;
    private RangeSliderVC rsVC = null;
    private int rsLabelClipStartOffset = 0;
    private int rsLabelClipEndOffset = 0;
    private int rsScrollPresence = 0;
    public static final int RANGE_SLIDER_HORZ_THICKNESS = 15;
    public static final int RANGE_SLIDER_VERT_THICKNESS = 15;
    public static final int RANGE_SLIDER_BUTTON_WIDTH = 21;
    public static final int RANGE_SLIDER_BUTTON_HEIGHT = 15;
    public static final String START_VAL = "startV";
    public static final String END_VAL = "endV";
    public static final String START_DATE = "startD";
    public static final String END_DATE = "endD";
    public static final String THUMP_POSITION = "tp";
    public static final String O1_RS_ID = "O1RS";
    public static final String X1_RS_ID = "X1RS";
    public static final String Y1_RS_ID = "Y1RS";
    public static final String Y2_RS_ID = "Y2RS";
    public static final String RS_HORIZ = "isHoriz";
    public static final int NO_H = 0;
    public static final int X_H = 1;
    public static final int Y1_H = 2;
    public static final int Y2_H = 3;
    public static final int PA_H = 4;
    public static final int PA_Y2_H = 5;
    public static final int O_H = 6;
    public static final String[] HANDLE_ID = new String[]{"", "X1L", "Y1L", "Y2L", "PA", "Y2PA", "OL"};
    public static final String ATTR_SCROLL_JS = "scrollJS";
    public static final String ATTR_ZOOM_JS = "zoomJS";
    public static final String ATTR_X1_ZOOM_IN_JS = "x1in";
    public static final String ATTR_X1_ZOOM_OUT_JS = "x1out";
    public static final String ATTR_Y1_ZOOM_IN_JS = "y1in";
    public static final String ATTR_Y1_ZOOM_OUT_JS = "y1out";
    public static final String ATTR_Y2_ZOOM_IN_JS = "y2in";
    public static final String ATTR_Y2_ZOOM_OUT_JS = "y2out";
    public static final String ATTR_X1_ACTUAL_JS = "x1actual";
    public static final String ATTR_Y1_ACTUAL_JS = "y1actual";
    public static final String ATTR_Y2_ACTUAL_JS = "y2actual";
    public static final String ATTR_ALL_ACTUAL_JS = "allactual";
    private int LABEL_MARGIN_CHARS = 1;

    public RangeSlider(int id, Perspective pfj, int scrollPresence, int axisID) {
        this.rsID = id;
        this.rsPFJ = pfj;
        this.rsScrollPresence = scrollPresence;
        this.rsAxisID = axisID;
        this.rsIsLiveScroll = this.rsPFJ.getZoomAndScroll() == 0;
        boolean isHorz = this.rsPFJ.isChartOrientHorz();
        this.rsIsVertical = !(this.rsID == 75 && !isHorz || this.rsID != 75 && isHorz);
    }

    public void transferNumericProperties(boolean autoMin, boolean autoMax, double minVal, double maxVal, Double zoomRangeMin, Double zoomRangeMax) {
        boolean bZoomRangeMin = !autoMin && zoomRangeMin != null;
        boolean bZoomRangeMax = !autoMax && zoomRangeMax != null;
        this.rsAutoMin = autoMin;
        this.rsAutoMax = autoMax;
        this.rsZoomRangeMin = zoomRangeMin;
        this.rsZoomRangeMax = zoomRangeMax;
        if (bZoomRangeMin) {
            this.setZoomMin(Math.max(minVal, this.rsZoomRangeMin));
        } else {
            this.setZoomMin(minVal);
        }
        if (bZoomRangeMax) {
            this.setZoomMax(Math.min(maxVal, this.rsZoomRangeMax));
        } else {
            this.setZoomMax(maxVal);
        }
    }

    public void updateNumericAutoProperties(double minAutoVal, double maxAutoVal) {
        this.rsAxisMax = maxAutoVal;
        this.rsAxisMin = minAutoVal;
        if (this.rsAutoMin) {
            this.setZoomMin(minAutoVal);
        } else if (this.rsZoomRangeMin != null) {
            this.rsAxisMin = this.rsZoomRangeMin;
        }
        if (this.rsAutoMax) {
            this.setZoomMax(maxAutoVal);
        } else if (this.rsZoomRangeMax != null) {
            this.rsAxisMax = this.rsZoomRangeMax;
        }
        if (this.rsPFJ.isTimeAxis() || this.rsPFJ.isContinuousTimeAxis()) {
            int timeMode = this.rsPFJ.getIntegerProp(Attr.TimeRangeMode);
            if (timeMode == 2) {
                if (this.rsAutoMin) {
                    this.setZoomMin(this.rsAxisMin);
                }
                if (this.rsAutoMax) {
                    this.setZoomMax(this.rsAxisMin + (double)this.rsPFJ.getLongProp(Attr.RelativeTimeRange));
                }
            } else if (timeMode == 1) {
                if (this.rsAutoMin) {
                    this.setZoomMin(this.rsAxisMax - (double)this.rsPFJ.getLongProp(Attr.RelativeTimeRange));
                }
                if (this.rsAutoMax) {
                    this.setZoomMax(this.rsAxisMax);
                }
            }
        }
        this.calcRatio();
    }

    public void calcRatio() {
        boolean isHorz = this.rsPFJ.isChartOrientHorz();
        this.rsIsVertical = !(this.rsID == 75 && !isHorz || this.rsID != 75 && isHorz);
        if (this.rsZoomMinMax == null && this.rsZoomViewableGroups == 0 && this.rsZoomRatio == RS_NO_ZOOM) {
            return;
        }
        if (this.rsZoomMinMax == null) {
            if (this.rsZoomViewableGroups != 0) {
                if ((this.rsPFJ.isChartArea() || this.rsPFJ.isChartLine()) && this.rsZoomViewableGroups >= 2) {
                    this.setZoomRatio((double)(this.rsPFJ.getNumTotalGroups() - 1) / (double)(this.rsZoomViewableGroups - 1));
                } else {
                    this.setZoomRatio((double)this.rsPFJ.getNumTotalGroups() / (double)this.rsZoomViewableGroups);
                }
            } else {
                this.setZoomRatio(RS_NO_ZOOM);
            }
        } else {
            double min = this.rsZoomMinMax.getRawMin();
            double max = this.rsZoomMinMax.getRawMax();
            double scaledAxis = max - min;
            if (min < this.rsAxisMin) {
                this.rsAxisMin = min;
                if (!this.rsAutoMin && this.rsIsLiveScroll) {
                    this.rsPFJ.setScaleMin(this.rsAxisID, this.getZoomMin());
                }
            }
            if (max > this.rsAxisMax) {
                this.rsAxisMax = max;
                if (!this.rsAutoMax && this.rsIsLiveScroll) {
                    this.rsPFJ.setScaleMax(this.rsAxisID, this.getZoomMax());
                }
            }
            double axisLen = this.getAxisLen();
            if (scaledAxis != 0.0 && axisLen != 0.0) {
                double ratio = axisLen / scaledAxis;
                if (this.rsIsLiveScroll && ratio > RS_MAX_ZOOM) {
                    ratio = RS_MAX_ZOOM;
                    double center = (max + min) / 2.0;
                    double halfCapLen = axisLen / RS_MAX_ZOOM / 2.0;
                    double newMin = center - halfCapLen;
                    double newMax = center + halfCapLen;
                    boolean overshotLeft = FP.lessThan(newMin, this.rsAxisMin);
                    boolean overshotRight = FP.greaterThan(newMax, this.rsAxisMax);
                    if (!overshotLeft && !overshotRight) {
                        this.setZoomMin(newMin);
                        this.setZoomMax(newMax);
                        ratio = RS_MAX_ZOOM;
                    } else if (overshotLeft && !overshotRight) {
                        this.setZoomMin(this.rsAxisMin);
                        if (!FP.greaterThan(newMax += this.rsAxisMin - newMin, this.rsAxisMax)) {
                            this.setZoomMax(newMax);
                        } else {
                            this.setZoomMax(this.rsAxisMax);
                            ratio = RS_NO_ZOOM;
                        }
                    } else if (overshotRight && !overshotLeft) {
                        this.setZoomMax(max);
                        if (!FP.lessThan(newMin -= newMax - this.rsAxisMax, this.rsAxisMin)) {
                            this.setZoomMin(newMin);
                        } else {
                            this.setZoomMin(this.rsAxisMin);
                            ratio = RS_NO_ZOOM;
                        }
                    } else {
                        this.setZoomMin(this.rsAxisMin);
                        this.setZoomMax(this.rsAxisMax);
                        ratio = RS_NO_ZOOM;
                    }
                }
                this.setZoomRatio(ratio);
            } else {
                this.setZoomRatio(RS_NO_ZOOM);
            }
        }
    }

    public void calc() {
        boolean isBIDINeeded;
        Dimension destDim = this.rsPFJ.getImageSize();
        Rectangle frameRect = this.rsPFJ.getFrameRect(false);
        boolean bl = isBIDINeeded = !this.rsPFJ.isChartOrientHorz() && this.rsPFJ.getCommonGraph().isO1AxisSupported() && this.rsPFJ.isBIDILocale();
        if (this.rsPFJ.isSplitY(this.rsPFJ.getGraphType()) && (this.rsID == 76 || this.rsID == 77)) {
            if (!this.rsPFJ.isChartOrientHorz()) {
                frameRect.height /= 2;
                this.rsRect.height /= 2;
                if (this.rsID == 76 && !isBIDINeeded || this.rsID == 77 && isBIDINeeded) {
                    frameRect.y += frameRect.height;
                    this.rsRect.y += this.rsRect.height;
                }
            } else {
                frameRect.width /= 2;
                this.rsRect.width /= 2;
                if (this.rsID == 76) {
                    frameRect.x += frameRect.width;
                    this.rsRect.x += this.rsRect.width;
                }
            }
        }
        Rectangle rsDestRect = this.rsPFJ.getVC().virtToDest(this.rsRect);
        this.cachedFrameRect = this.rsPFJ.getVC().virtToDest(frameRect);
        if (!this.rsIsVertical) {
            this.rsFrameLen = this.cachedFrameRect.width;
            this.rsFrameStart = this.cachedFrameRect.x;
            this.rsThumbStart = Math.max(0, this.calcThumbStart(this.cachedFrameRect.width));
            this.rsThumbLen = Math.max(1, this.calcThumbLen(this.cachedFrameRect.width));
            if (this.rsIsLiveScroll) {
                this.rsVC = new RangeSliderVC((double)destDim.width * this.rsZoomRatio, destDim.height);
                if (this.rsZoomRatio > RS_NO_ZOOM) {
                    this.rsLabelClipStartOffset = (int)((double)this.rsFrameStart * (this.getZoomRatio() - RS_NO_ZOOM));
                    this.rsLabelClipEndOffset = (int)((double)this.rsLabelClipStartOffset + (this.rsZoomRatio - 1.0) * (double)this.rsFrameLen);
                    this.rsLabelVirtStart = this.rsPFJ.getVC().destToVirtX(this.rsVC.virtToDestX(this.rsLabelVirtStart) - this.rsLabelClipStartOffset);
                    this.rsLabelVirtEnd = this.rsPFJ.getVC().destToVirtX(this.rsVC.virtToDestX(this.rsLabelVirtEnd) - this.rsLabelClipEndOffset);
                    this.rsLabelVirtStart = Math.min(this.rsLabelVirtStart, this.rsRect.x);
                    this.rsLabelVirtEnd = Math.max(this.rsLabelVirtEnd, this.rsRect.x + this.rsRect.width);
                    int startX = this.rsPFJ.getVC().virtToDestX(this.rsLabelVirtStart) - 1;
                    int endX = this.rsPFJ.getVC().virtToDestX(this.rsLabelVirtEnd) + 1;
                    int startY = this.cachedFrameRect.y + this.cachedFrameRect.height;
                    int clipHeight = this.cachedFrameRect.height;
                    if (this.rsID == 77) {
                        startY = rsDestRect.y;
                        clipHeight = this.cachedFrameRect.y - startY + this.cachedFrameRect.height;
                    }
                    this.rsLabelClipRect = new Rectangle(startX, startY, endX - startX, clipHeight);
                    this.rsVC.setXOffset(this.getPositionOffset());
                } else {
                    this.rsLabelClipRect = null;
                }
            }
        } else {
            this.rsFrameLen = this.cachedFrameRect.height;
            this.rsFrameStart = this.cachedFrameRect.y;
            this.rsThumbStart = Math.max(0, this.calcThumbStart(this.cachedFrameRect.height));
            this.rsThumbLen = Math.max(1, this.calcThumbLen(this.cachedFrameRect.height));
            if (this.rsZoomMinMax != null) {
                this.rsThumbStart = this.cachedFrameRect.height - this.rsThumbLen - this.rsThumbStart;
            }
            if (this.rsIsLiveScroll) {
                this.rsVC = new RangeSliderVC(destDim.getWidth(), destDim.getHeight() * this.rsZoomRatio);
                if (this.rsZoomRatio > RS_NO_ZOOM) {
                    this.rsLabelClipStartOffset = (int)((double)this.rsFrameStart * (this.getZoomRatio() - RS_NO_ZOOM));
                    this.rsLabelClipEndOffset = (int)((double)this.rsLabelClipStartOffset + (this.rsZoomRatio - 1.0) * (double)this.rsFrameLen);
                    this.rsLabelVirtStart = this.rsPFJ.getVC().destToVirtY(this.rsVC.virtToDestY(this.rsLabelVirtStart) - this.rsLabelClipEndOffset);
                    this.rsLabelVirtEnd = this.rsPFJ.getVC().destToVirtY(this.rsVC.virtToDestY(this.rsLabelVirtEnd) - this.rsLabelClipStartOffset);
                    this.rsLabelVirtStart = Math.min(this.rsLabelVirtStart, this.rsRect.y);
                    this.rsLabelVirtEnd = Math.max(this.rsLabelVirtEnd, this.rsRect.y + this.rsRect.height);
                    int startY = this.rsPFJ.getVC().virtToDestY(this.rsLabelVirtStart) + 1;
                    int endY = this.rsPFJ.getVC().virtToDestY(this.rsLabelVirtEnd) - 1;
                    int startX = rsDestRect.x;
                    int clipWidth = this.cachedFrameRect.width;
                    if (this.rsID == 77 && !isBIDINeeded || this.rsID == 76 && isBIDINeeded) {
                        startX = this.cachedFrameRect.x;
                        clipWidth = rsDestRect.x - startX;
                    }
                    this.rsLabelClipRect = new Rectangle(startX, startY, clipWidth, endY - startY);
                    this.rsVC.setYOffset(this.getPositionOffset());
                } else {
                    this.rsLabelClipRect = null;
                }
            }
        }
        if (this.rsZoomMinMax != null && this.rsIsLiveScroll) {
            this.rsPFJ.setScaleMin(this.rsAxisID, this.getZoomMin());
            this.rsPFJ.setScaleMax(this.rsAxisID, this.getZoomMax());
        }
        this.rsLabelVirtStart = Integer.MAX_VALUE;
        this.rsLabelVirtEnd = 0;
        this.rsLabelClipStartOffset = 0;
        this.rsLabelClipEndOffset = 0;
    }

    private void setZoomRatio(double ratio) {
        this.rsZoomRatio = ratio;
        if (this.rsIsLiveScroll) {
            Dimension destDim = this.rsPFJ.getImageSize();
            this.rsVC = this.rsIsVertical ? new RangeSliderVC(destDim.getWidth(), destDim.getHeight() * this.rsZoomRatio) : new RangeSliderVC(destDim.getWidth() * this.rsZoomRatio, destDim.getHeight());
        }
    }

    public void setZoomMin(double min) {
        if (this.rsZoomMinMax == null) {
            this.setZoomMinMax(new MinMaxObj(min, 0.0));
        } else {
            this.setZoomMinMax(new MinMaxObj(min, this.rsZoomMinMax.getRawMax()));
        }
    }

    public void setZoomMin(double min, double defaultMax) {
        if (this.rsZoomMinMax == null) {
            this.setZoomMinMax(new MinMaxObj(min, defaultMax));
        } else {
            this.setZoomMinMax(new MinMaxObj(min, this.rsZoomMinMax.getRawMax()));
        }
    }

    public void setZoomMax(double max) {
        if (this.rsZoomMinMax == null) {
            this.setZoomMinMax(new MinMaxObj(0.0, max));
        } else {
            this.setZoomMinMax(new MinMaxObj(this.rsZoomMinMax.getRawMin(), max));
        }
    }

    public void setZoomMax(double max, double defaultMin) {
        if (this.rsZoomMinMax == null) {
            this.setZoomMinMax(new MinMaxObj(defaultMin, max));
        } else {
            this.setZoomMinMax(new MinMaxObj(this.rsZoomMinMax.getRawMin(), max));
        }
    }

    public void setZoomMinMax(MinMaxObj minMax) {
        this.rsZoomMinMax = minMax;
    }

    public void setZoomGroups(int newValue, int newOffset) {
        this.rsZoomViewableGroups = Math.max(Math.min(newValue, this.rsPFJ.getNumTotalGroups()), 0);
        this.rsZoomGroupOffset = Math.max(Math.min(newOffset, this.rsPFJ.getNumTotalGroups() - 1), 0);
    }

    public double getZoomRatio() {
        return this.rsZoomRatio;
    }

    public int getZoomViewableGroups() {
        if (this.rsZoomViewableGroups == 0) {
            return this.rsPFJ.getNumTotalGroups();
        }
        return this.rsZoomViewableGroups;
    }

    public int getZoomOffsetGroup() {
        return this.rsZoomGroupOffset;
    }

    public boolean getScaleMinAuto() {
        return this.rsAutoMin;
    }

    public boolean getScaleMaxAuto() {
        return this.rsAutoMax;
    }

    public double getZoomMin() {
        return this.rsZoomMinMax != null ? this.rsZoomMinMax.getRawMin() : 0.0;
    }

    public double getZoomMax() {
        return this.rsZoomMinMax != null ? this.rsZoomMinMax.getRawMax() : 0.0;
    }

    public double getAxisMin() {
        return this.rsAxisMin;
    }

    public double getAxisMax() {
        return this.rsAxisMax;
    }

    public MinMaxObj getZoomMinMax() {
        return this.rsZoomMinMax;
    }

    public int getID() {
        return this.rsID;
    }

    public VC getVC() {
        if (this.rsVC != null) {
            return this.rsVC;
        }
        return this.rsPFJ.getVC();
    }

    public Rectangle getRect() {
        return this.rsRect;
    }

    public Rectangle getLabelClipRect() {
        return this.rsLabelClipRect;
    }

    public int getThumbStart() {
        return this.rsThumbStart;
    }

    public void setThumbStart(int thumbStart) {
        this.rsThumbStart = thumbStart;
    }

    public void calcLabelClip(Rectangle labelRect) {
        if (this.getZoomRatio() == RS_NO_ZOOM) {
            return;
        }
        if (labelRect != null) {
            if (this.rsIsVertical) {
                this.rsLabelVirtStart = Math.min(labelRect.y, this.rsLabelVirtStart);
                this.rsLabelVirtEnd = Math.max(labelRect.y + labelRect.height, this.rsLabelVirtEnd);
            } else {
                this.rsLabelVirtStart = Math.min(labelRect.x, this.rsLabelVirtStart);
                this.rsLabelVirtEnd = Math.max(labelRect.x + labelRect.width, this.rsLabelVirtEnd);
            }
        }
    }

    public void writeMetaData(Map<String, String> metadataMap) {
        if (this.cachedFrameRect == null) {
            this.cachedFrameRect = this.rsPFJ.getVC().virtToDest(this.rsPFJ.getFrameRect(false));
        }
        Rectangle destRSRect = this.rsScrollPresence == 5 ? new Rectangle(0, 0, 0, 0) : this.rsPFJ.getVC().virtToDest(this.rsRect);
        StringBuilder sb = DataviewUtils.getSharedStringBuilder();
        sb.append(destRSRect.getX()).append(',');
        sb.append(destRSRect.getY()).append(',');
        sb.append(destRSRect.getWidth()).append(',');
        sb.append(destRSRect.getHeight());
        metadataMap.put("p", sb.toString());
        if (!this.rsIsVertical) {
            metadataMap.put(RS_HORIZ, "t");
        }
        int start = this.getThumbStart();
        int len = this.getThumbLen();
        if (!this.rsIsVertical && (double)len > destRSRect.getWidth()) {
            len = (int)destRSRect.getWidth();
        } else if (this.rsIsVertical && (double)len > destRSRect.getHeight()) {
            len = (int)destRSRect.getHeight();
        }
        metadataMap.put(THUMP_POSITION, len + "," + start);
        if (this.rsZoomMinMax != null) {
            double endVal;
            double startVal = this.rsAxisMin;
            double d = endVal = this.rsAxisMax > this.rsAxisMin ? this.rsAxisMax : this.rsAxisMin + 1.0;
            if (this.rsID == 75 && this.rsPFJ.isContinuousTimeAxis()) {
                metadataMap.put(START_DATE, String.valueOf((long)startVal));
                metadataMap.put(END_DATE, String.valueOf((long)endVal));
                metadataMap.put("timeAxisResources", GraphExportXMLWriter.getTimeAxisResources(this.rsPFJ));
                metadataMap.put("timeZone", GraphExportXMLWriter.getTimeZoneOffset(this.rsPFJ));
            } else {
                metadataMap.put(START_VAL, String.valueOf(startVal));
                metadataMap.put(END_VAL, String.valueOf(endVal));
            }
        } else if (this.rsID == 75 && this.rsPFJ.isTimeAxis() && this.rsPFJ.m_groupLabels != null && this.rsPFJ.m_groupLabels.size() > 0) {
            Object startGroup = this.rsPFJ.m_groupLabels.get(0);
            Object endGroup = this.rsPFJ.m_groupLabels.get(this.rsPFJ.m_groupLabels.size() - 1);
            if (startGroup instanceof Date && endGroup instanceof Date) {
                metadataMap.put(START_DATE, String.valueOf(((Date)startGroup).getTime()));
                metadataMap.put(END_DATE, String.valueOf(((Date)endGroup).getTime()));
                metadataMap.put("timeAxisResources", GraphExportXMLWriter.getTimeAxisResources(this.rsPFJ));
                metadataMap.put("timeZone", GraphExportXMLWriter.getTimeZoneOffset(this.rsPFJ));
            }
        }
    }

    private int getLabelClipMargin() {
        int labelClipMargin = 0;
        switch (this.rsID) {
            case 75: {
                if (this.rsPFJ.isX1AxisPresent()) {
                    labelClipMargin = this.rsPFJ.getFontSize(this.rsPFJ.getX1Label());
                    break;
                }
                labelClipMargin = this.rsPFJ.getFontSize(this.rsPFJ.getO1Label());
                break;
            }
            case 76: {
                labelClipMargin = this.rsPFJ.getFontSize(this.rsPFJ.getY1Label());
                break;
            }
            case 77: {
                labelClipMargin = this.rsPFJ.getFontSize(this.rsPFJ.getY2Label());
                break;
            }
            default: {
                return 0;
            }
        }
        return labelClipMargin * this.LABEL_MARGIN_CHARS;
    }

    private double getPositionOffset() {
        double startOffset = (double)this.rsFrameStart * (this.getZoomRatio() - RS_NO_ZOOM);
        double cornerOffset = 0.0;
        if (this.rsZoomMinMax == null) {
            cornerOffset = (double)(this.rsZoomGroupOffset * this.rsFrameLen) * this.getZoomRatio() / (double)this.rsPFJ.getNumGroups();
        } else {
            double zoomRange = this.getZoomMax() - this.getZoomMin();
            if (zoomRange != 0.0) {
                cornerOffset = this.rsIsVertical ? (this.getAxisMax() - this.getZoomMax()) / zoomRange * (double)this.rsFrameLen : (this.getZoomMin() - this.rsAxisMin) / zoomRange * (double)this.rsFrameLen;
            }
        }
        return startOffset + cornerOffset;
    }

    private int calcThumbStart(int frameLen) {
        if (this.rsZoomRatio > RS_NO_ZOOM) {
            if (this.rsZoomMinMax != null && this.getZoomMin() > this.rsAxisMin) {
                return (int)Math.round((double)frameLen * (this.getZoomMin() - this.rsAxisMin) / this.getAxisLen());
            }
            int numGroups = this.rsPFJ.getNumTotalGroups();
            if (this.rsPFJ.isChartArea() || this.rsPFJ.isChartLine()) {
                --numGroups;
            }
            return (int)Math.round((double)this.rsZoomGroupOffset / (double)numGroups * (double)frameLen);
        }
        return 0;
    }

    private double getAxisLen() {
        return this.rsAxisMax - this.rsAxisMin;
    }

    private int calcThumbLen(int frameLen) {
        if (this.rsZoomRatio > RS_NO_ZOOM) {
            return (int)Math.round((double)frameLen / this.getZoomRatio());
        }
        return frameLen;
    }

    private int getThumbLen() {
        if (this.rsThumbLen == 0) {
            boolean isHorz = this.rsPFJ.isChartOrientHorz();
            this.rsThumbLen = this.rsID == 75 && !isHorz || this.rsID != 75 && isHorz ? this.cachedFrameRect.width : this.cachedFrameRect.height;
        }
        return this.rsThumbLen;
    }

    public boolean isVisible() {
        return this.rsScrollPresence == 2 || (this.rsScrollPresence == 1 || this.rsScrollPresence == 3) && this.getZoomRatio() > RS_NO_ZOOM;
    }

    public boolean isRendered() {
        return this.isVisible() || this.rsScrollPresence == 5;
    }

    public boolean isReserved() {
        return this.rsScrollPresence == 3;
    }

    public static String getActualSizeJS(String scrollJS) {
        if (scrollJS == null) {
            return "";
        }
        String actualJS = scrollJS;
        actualJS = actualJS.replace("__SPAN__", "1");
        actualJS = actualJS.replace("__TOTAL__", "1");
        actualJS = actualJS.replace("__START__", "0");
        actualJS = actualJS.replace("__T__", "r");
        return actualJS;
    }
}

