/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import oracle.dss.graph.pfj.RadixCompare;

public class RadixSort {
    private RadixCompare delegate;
    private Object[] userArray;
    private Object[] sourceArray;
    private Object[] targetArray;
    private int keyLength;
    private int[] counts;

    public static void sort(Object[] userArray, RadixCompare delegate, int keyLength) {
        RadixSort h = new RadixSort();
        h.delegate = delegate;
        h.userArray = userArray;
        h.keyLength = keyLength;
        h.radixSort();
    }

    private void radixSort() {
        this.counts = new int[256];
        this.sourceArray = this.userArray;
        this.targetArray = new Object[this.userArray.length];
        for (int col = this.keyLength - 1; col > 0; --col) {
            this.sortCol(col);
            Object[] temp = this.sourceArray;
            this.sourceArray = this.targetArray;
            this.targetArray = temp;
        }
        if (this.sourceArray != this.userArray) {
            System.arraycopy(this.sourceArray, 0, this.userArray, 0, this.sourceArray.length);
        }
    }

    private void sortCol(int col) {
        int i;
        for (i = 0; i < this.counts.length; ++i) {
            this.counts[i] = 0;
        }
        for (i = 0; i < this.sourceArray.length; ++i) {
            int n = this.delegate.getKeyByteAt(this.sourceArray[i], col);
            this.counts[n] = this.counts[n] + 1;
        }
        int soFar = 0;
        for (int i2 = 0; i2 < this.counts.length; ++i2) {
            int temp = this.counts[i2];
            this.counts[i2] = soFar;
            soFar += temp;
        }
        for (int from = 0; from < this.sourceArray.length; ++from) {
            int keyByte;
            int n = keyByte = this.delegate.getKeyByteAt(this.sourceArray[from], col);
            this.counts[n] = this.counts[n] + 1;
            this.targetArray[to] = this.sourceArray[from];
        }
    }
}

