/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import oracle.dss.graph.DataStyleType;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.MarkerTemplate;
import oracle.dss.graph.pfj.MarkerTemplateArray;
import oracle.dss.graph.pfj.ObjClassID;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.QSortPoly;
import oracle.dss.graph.pfj.ScatterGraphDataStyle;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetImage;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetMarker;
import oracle.dss.graph.pfj.draw.DetOval;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.DetShape;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.FillGradientObj;
import oracle.dss.graph.pfj.draw.IdentObj;

public class MarkerObj {
    protected static final int MIN_MARKER_SIZE = 5;
    public static final Area SHAPE_HUMAN;
    private static final Rectangle SHAPE_HUMAN_BOUNDS;
    protected static final double SHAPE_HUMAN_WIDTH_HEIGHT_RATIO;

    protected static void createMarker(Detectiv a_Detectiv, IdentObj id, MarkerTemplate template, Point center, int markerSizeX, int markerSizeY, BlackBoxIF blackBox, Rectangle rClip, boolean bLimitSize) {
        MarkerObj.createMarker(a_Detectiv, id, template, center, markerSizeX, markerSizeY, blackBox, rClip, bLimitSize, false, 0, 0, 0);
    }

    protected static void createMarker(Detectiv a_Detectiv, IdentObj id, MarkerTemplate template, Point center, int markerSizeX, int markerSizeY, BlackBoxIF blackBox, Rectangle rClip, boolean bLimitSize, boolean threed, int nXDepth, int nYDepth, int nDepthAngle) {
        MarkerObj.createMarker(a_Detectiv, id, template, center, markerSizeX, markerSizeY, blackBox, rClip, bLimitSize, threed, nDepthAngle, 0, 0, true);
    }

    protected static void createMarker(Detectiv a_Detectiv, IdentObj id, MarkerTemplate template, Point center, int markerSizeX, int markerSizeY, BlackBoxIF blackBox) {
        MarkerObj.createMarker(a_Detectiv, id, template, center, markerSizeX, markerSizeY, blackBox, null, true);
    }

    protected static void createMarker(Detectiv detectiv, IdentObj id, MarkerTemplate template, Point center, int markerSizeX, int markerSizeY, BlackBoxIF blackBox, Rectangle rClip, boolean bLimitSize, boolean threed, int nDepthAngle, int nXDepth, int nYDepth, boolean bHiliteable) {
        List underlayAttrib;
        Perspective pfj = detectiv.getPerspective();
        boolean isBubble = pfj.isChartBubble();
        int xDepth = 300;
        int yDepth = 300;
        if (center == null) {
            center = new Point(0, 0);
        }
        if (template == MarkerTemplateArray.PRESET_BUBBLE || template == MarkerTemplateArray.PRESET_HUMAN && isBubble) {
            if (markerSizeX < 0) {
                throw new AssertionException(0, Integer.MAX_VALUE, markerSizeX);
            }
            if (markerSizeY < 0) {
                throw new AssertionException(0, Integer.MAX_VALUE, markerSizeY);
            }
        } else {
            if (markerSizeX < 0 || bLimitSize && markerSizeX > 100) {
                throw new AssertionException(0, 100, markerSizeX);
            }
            if (markerSizeY < 0 || bLimitSize && markerSizeY > 100) {
                throw new AssertionException(0, 100, markerSizeY);
            }
        }
        if (blackBox.getTransparentFillColor()) {
            boolean noRescaleHidden;
            boolean bl = noRescaleHidden = pfj.isNoRescaleHiddenSeries(id.getSeriesID()) && !pfj.isExportingToXML();
            if (ObjClassID.stripExceptionalOffset(id.getObjectID()) == 13 && (pfj.getSeriesVisibility(id.getSeriesID()) == 1 || noRescaleHidden)) {
                blackBox.setTransparentBorderColor(false);
                Color borderColor = noRescaleHidden ? new Color(blackBox.getFillColor().getRGB(), false) : blackBox.getFillColor();
                if (!threed) {
                    blackBox.setBorderColor(pfj.getDarker(borderColor));
                } else {
                    blackBox.setBorderColor(borderColor);
                }
            } else {
                blackBox.setTransparentBorderColor(true);
            }
        }
        int markerType = template.getMarkerType();
        if ((isBubble || pfj.isChartScatter() && !threed) && id.getObjectID() == 259 && pfj.m_ScatterGraphDataStyle != null && (pfj.m_ScatterGraphDataStyle.isUnderlayShapePresent() || pfj.m_ScatterGraphDataStyle.isUnderlayColorPresent()) && (underlayAttrib = pfj.m_ScatterGraphDataStyle.getUnderlayAttributesFromSeries(id.getSeriesID(), id.getGroupID())) != null) {
            Color underlayColor = (Color)underlayAttrib.get(ScatterGraphDataStyle.UnderlayAttributesIndex.Color.getId());
            MarkerTemplate underlayShape = DetMarker.getMarkerTemplate((DataStyleType.Shape)((Object)underlayAttrib.get(ScatterGraphDataStyle.UnderlayAttributesIndex.Shape.getId())));
            IdentObj underlayID = new IdentObj(259, id.getSeriesID(), id.getGroupID());
            BlackBoxObj underlayBB = new BlackBoxObj(pfj, underlayID);
            underlayBB.setTransparentBorderColor(true);
            int underlaySizeX = markerSizeX;
            int underlaySizeY = markerSizeY;
            if (template.getMarkerType() == 11) {
                if (underlayShape.getMarkerType() == 2 || underlayShape.getMarkerType() == 1) {
                    underlaySizeX = (int)((double)underlaySizeX * 1.55);
                    underlaySizeY = (int)((double)underlaySizeY * 1.55);
                } else if (underlayShape.getMarkerType() == 7) {
                    underlaySizeX = (int)((double)underlaySizeX * 1.7);
                    underlaySizeY = (int)((double)underlaySizeY * 1.7);
                } else {
                    underlaySizeX = (int)((double)underlaySizeX * 1.9);
                    underlaySizeY = (int)((double)underlaySizeY * 1.9);
                }
            } else if (underlayShape.getMarkerType() == 2) {
                underlaySizeX = (int)((double)underlaySizeX * 1.55);
                underlaySizeY = (int)((double)underlaySizeY * 1.55);
            } else if (underlayShape.getMarkerType() == 1) {
                underlaySizeX = (int)((double)underlaySizeX * 1.65);
                underlaySizeY = (int)((double)underlaySizeY * 1.65);
            } else {
                underlaySizeX = (int)((double)underlaySizeX * 2.0);
                underlaySizeY = (int)((double)underlaySizeY * 2.0);
            }
            underlayBB.setFillColor(underlayColor);
            if (threed) {
                pfj.setFillColor(underlayID, underlayColor);
            }
            MarkerObj.calcShape(pfj, detectiv, underlayShape.getMarkerType(), nDepthAngle, xDepth, yDepth, center, underlayShape, underlayID, underlaySizeX, underlaySizeY, threed, underlayBB, bHiliteable, rClip, true, markerType);
        }
        switch (markerType) {
            case 0: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                Rectangle clipRect = isBubble ? rClip : null;
                MarkerObj.calcShape(pfj, detectiv, markerType, nDepthAngle, xDepth, yDepth, center, template, id, markerSizeX, markerSizeY, threed, blackBox, bHiliteable, clipRect, false, markerType);
                break;
            }
            case 4: 
            case 10: {
                MarkerObj.calcLine(pfj, detectiv, center, template, id, markerSizeX, blackBox);
                break;
            }
            case 8: {
                MarkerObj.calcDrillUp(pfj, detectiv, center, id, markerSizeX, markerSizeY, blackBox, rClip);
                break;
            }
            default: {
                throw new AssertionException("MarkerObj - unknown markerType = " + markerType);
            }
        }
    }

    private static void _calcOval(Perspective pfj, Detectiv detectiv, BlackBoxIF bb, IdentObj id, int cx, int cy, int width, int height, boolean threed, Rectangle rClip, VC vc, boolean isUnderLay) {
        int x = cx - width / 2;
        int y = cy - height / 2;
        Rectangle scaledRectVC = vc.destToVirt(new Rectangle(x, y, width - 1, height - 1));
        if (!pfj.m_bExportingToXML) {
            if (threed && pfj.getFillType(pfj.getSeries(id.getSeriesID())) == 1) {
                Color c = pfj.getFillColor(id);
                IdentObj identObj = new IdentObj(id);
                identObj.setMiscID(1);
                pfj.setBubbleEffect(identObj);
                BlackBoxObj blackBox = new BlackBoxObj(pfj, identObj);
                blackBox.setBorderColor(c);
                DetOval.newMarkerInstance(detectiv, identObj, scaledRectVC, blackBox, rClip);
            } else {
                DetOval.newMarkerInstance(detectiv, id, scaledRectVC, bb, rClip);
            }
        }
        if (isUnderLay) {
            Rectangle2D rect = scaledRectVC.getBounds2D();
            pfj.setUnderLayRectangle(id, rect);
        }
    }

    private static void calcShape(Perspective pfj, Detectiv detectiv, int markerShape, int nDepthAngle, int xDepth, int yDepth, Point center, MarkerTemplate template, IdentObj id, int markerSizeX, int markerSizeY, boolean threed, BlackBoxIF bb, boolean bHiliteable, Rectangle rClip, boolean isUnderLay, int markerTypeWithUnderlay) {
        int side;
        int height;
        int width;
        VC vc = pfj.getVC();
        boolean isUnderLayRectNeeded = pfj.getDataTextDisplay() && isUnderLay;
        VC posVC = pfj.getZoomAndScroll() == 0 && id.getObjectID() == 259 ? pfj.getRangeSliderSeriesVC(id.getSeriesID()) : vc;
        int cx = posVC.virtToDestX(center.x);
        int cy = posVC.virtToDestY(center.y);
        if (pfj.isChartBubble() && ObjClassID.stripExceptionalOffset(id.getObjectID()) != 13) {
            width = vc.virtToDestWidth(markerSizeX);
            height = vc.virtToDestHeight(markerSizeY);
            side = Math.max(Math.max(width, height), 3);
        } else {
            width = vc.virtToDestWidth(template.m_rect.width * markerSizeX / 100);
            height = vc.virtToDestHeight(template.m_rect.height * markerSizeY / 100);
            side = Math.max(width, height);
            if (isUnderLay) {
                if (side < 20) {
                    side = 20;
                }
            } else if (side < 5) {
                side = 5;
            }
            if (side % 2 == 0) {
                ++side;
            }
        }
        if (pfj.m_bExportingToXML && !isUnderLay) {
            switch (markerShape) {
                case 1: 
                case 2: 
                case 11: {
                    --side;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 9: {
                    int x = cx - side / 2;
                    int y = cy - side / 2;
                    detectiv.addDetMarker(id, markerShape, x, y, side, bb);
                    boolean hasUnderlay = false;
                    if (pfj.m_ScatterGraphDataStyle != null && pfj.m_ScatterGraphDataStyle.getUnderlayAttributesFromSeries(id.getSeriesID(), id.getGroupID()) != null) {
                        hasUnderlay = true;
                    }
                    if (!pfj.isChartBubble() || markerShape != 11 || hasUnderlay || id.getObjectID() != 259) break;
                    HashMap<String, Serializable> visualMap = new HashMap<String, Serializable>();
                    Color sColor = new Color(0, 0, 0, 255);
                    double sDistance = 1.0;
                    double sStrength = 2.0;
                    double sAngle = 45.0;
                    double sBlurX = 0.0;
                    double sBlurY = 0.0;
                    int sQuality = 3;
                    int sInner = 0;
                    int sKnockout = 0;
                    int sHide = 0;
                    visualMap.put("shadowColor", sColor);
                    visualMap.put("shadowDistance", Double.valueOf(sDistance));
                    visualMap.put("shadowStrength", Double.valueOf(sStrength));
                    visualMap.put("shadowAngle", Double.valueOf(sAngle));
                    visualMap.put("shadowBlurX", Double.valueOf(sBlurX));
                    visualMap.put("shadowBlurY", Double.valueOf(sBlurY));
                    visualMap.put("shadowQuality", Integer.valueOf(sQuality));
                    visualMap.put("shadowInner", Integer.valueOf(sInner));
                    visualMap.put("shadowKnockout", Integer.valueOf(sKnockout));
                    visualMap.put("shadowHide", Integer.valueOf(sHide));
                    detectiv.addVisualEffectMap(visualMap);
                }
            }
        }
        if (isUnderLayRectNeeded || !pfj.m_bExportingToXML) {
            Polygon scaledPolygon = new Polygon();
            switch (markerShape) {
                case 11: {
                    MarkerObj.drawHuman(pfj, detectiv, bb, id, cx, cy, side, side, rClip, isUnderLayRectNeeded);
                    return;
                }
                case 2: 
                case 9: {
                    MarkerObj._calcOval(pfj, detectiv, bb, id, cx, cy, side, side, threed, rClip, vc, isUnderLayRectNeeded);
                    return;
                }
                case 1: {
                    --side;
                    if (!threed) {
                        Rectangle scaledRect = new Rectangle(cx - side / 2, cy - side / 2, side, side);
                        if (ObjClassID.stripExceptionalOffset(id.getObjectID()) == 13 && pfj.getBarShape() == 1) {
                            MarkerObj.applyCylinderBarsGradientEffect(bb, pfj);
                        }
                        if (isUnderLayRectNeeded) {
                            Rectangle2D rect = vc.destToVirt(scaledRect).getBounds2D();
                            pfj.setUnderLayRectangle(id, rect);
                        }
                        if (!pfj.m_bExportingToXML) {
                            new DetRect(detectiv, id, scaledRect, bb, bHiliteable, rClip);
                        }
                        return;
                    }
                    scaledPolygon.addPoint(cx - side / 2, cy - side / 2);
                    scaledPolygon.addPoint(cx + side / 2, cy - side / 2);
                    scaledPolygon.addPoint(cx + side / 2, cy + side / 2);
                    scaledPolygon.addPoint(cx - side / 2, cy + side / 2);
                    break;
                }
                case 3: {
                    scaledPolygon.addPoint(cx + side / 2, cy);
                    scaledPolygon.addPoint(cx, cy - side / 2);
                    scaledPolygon.addPoint(cx - side / 2, cy);
                    scaledPolygon.addPoint(cx, cy + side / 2);
                    break;
                }
                case 5: {
                    int depth = 1;
                    boolean done = false;
                    while (!done) {
                        if (side >= (depth += 2) * 3 + 2) continue;
                        done = true;
                        depth -= 2;
                    }
                    int halfDepth = (depth + 1) / 2;
                    scaledPolygon.addPoint(cx - halfDepth, cy - side / 2);
                    scaledPolygon.addPoint(cx + halfDepth, cy - side / 2);
                    scaledPolygon.addPoint(cx + halfDepth, cy - halfDepth);
                    scaledPolygon.addPoint(cx + side / 2, cy - halfDepth);
                    scaledPolygon.addPoint(cx + side / 2, cy + halfDepth);
                    scaledPolygon.addPoint(cx + halfDepth, cy + halfDepth);
                    scaledPolygon.addPoint(cx + halfDepth, cy + side / 2);
                    scaledPolygon.addPoint(cx - halfDepth, cy + side / 2);
                    scaledPolygon.addPoint(cx - halfDepth, cy + halfDepth);
                    scaledPolygon.addPoint(cx - side / 2, cy + halfDepth);
                    scaledPolygon.addPoint(cx - side / 2, cy - halfDepth);
                    scaledPolygon.addPoint(cx - halfDepth, cy - halfDepth);
                    scaledPolygon.addPoint(cx - halfDepth, cy - side / 2);
                    break;
                }
                case 6: {
                    int skewBtm;
                    int skewTip;
                    if (isUnderLay && (markerTypeWithUnderlay == 9 || markerTypeWithUnderlay == 2 || markerTypeWithUnderlay == 6)) {
                        skewTip = (int)Math.round((double)side * 0.7);
                        skewBtm = (int)Math.round((double)side * 0.3);
                    } else {
                        skewTip = (int)Math.round((double)side * 0.6);
                        skewBtm = (int)Math.round((double)side * 0.4);
                    }
                    scaledPolygon.addPoint(cx, cy + skewTip);
                    scaledPolygon.addPoint(cx + side / 2, cy - skewBtm);
                    scaledPolygon.addPoint(cx - side / 2, cy - skewBtm);
                    scaledPolygon.addPoint(cx, cy + skewTip);
                    break;
                }
                case 7: {
                    int skewBtm;
                    int skewTip;
                    if (isUnderLay && (markerTypeWithUnderlay == 9 || markerTypeWithUnderlay == 2 || markerTypeWithUnderlay == 7)) {
                        skewTip = (int)Math.round((double)side * 0.7);
                        skewBtm = (int)Math.round((double)side * 0.3);
                    } else if (isUnderLay && markerTypeWithUnderlay == 11) {
                        skewTip = (int)Math.round((double)side * 0.55);
                        skewBtm = (int)Math.round((double)side * 0.45);
                    } else {
                        skewTip = (int)Math.round((double)side * 0.6);
                        skewBtm = (int)Math.round((double)side * 0.4);
                    }
                    scaledPolygon.addPoint(cx, cy - skewTip);
                    scaledPolygon.addPoint(cx + side / 2, cy + skewBtm);
                    scaledPolygon.addPoint(cx - side / 2, cy + skewBtm);
                    scaledPolygon.addPoint(cx, cy - skewTip);
                    break;
                }
                default: {
                    return;
                }
            }
            if ((markerShape == 3 || markerShape == 5 || markerShape == 6 || markerShape == 7) && isUnderLayRectNeeded) {
                Rectangle2D rect = vc.destToVirt(scaledPolygon.getBounds()).getBounds2D();
                pfj.setUnderLayRectangle(id, rect);
            }
            if (!pfj.m_bExportingToXML || threed && markerShape != 2 && markerShape != 9 && markerShape != 11) {
                if (!threed) {
                    new DetPolygon(detectiv, id, scaledPolygon, bb, bHiliteable, rClip);
                } else {
                    MarkerObj.threedPolygons(scaledPolygon, vc, nDepthAngle, xDepth, yDepth, pfj, detectiv, id, bb, bHiliteable, rClip);
                }
            }
        }
    }

    private static void threedPolygons(Polygon scaledPolygon, VC vc, int nDepthAngle, int xDepth, int yDepth, Perspective pfj, Detectiv detectiv, IdentObj id, BlackBoxIF bb, boolean bHiliteable, Rectangle rClip) {
        Vector<Polygon> vectorPolyMarker = new Vector<Polygon>();
        Vector<Double> directionVector = new Vector<Double>();
        xDepth /= 3;
        yDepth /= 3;
        for (int nFace = 0; nFace < scaledPolygon.npoints; ++nFace) {
            int nSide = (nFace + 1) % scaledPolygon.npoints;
            double fAngleRad = Math.atan2(scaledPolygon.ypoints[nSide] - scaledPolygon.ypoints[nFace], scaledPolygon.xpoints[nSide] - scaledPolygon.xpoints[nFace]);
            double fAngleDeg = fAngleRad * 57.29577951308232;
            directionVector.addElement(fAngleDeg);
            Polygon polyMarkerSide = new Polygon();
            polyMarkerSide.addPoint(scaledPolygon.xpoints[nFace], scaledPolygon.ypoints[nFace]);
            polyMarkerSide.addPoint(scaledPolygon.xpoints[nSide], scaledPolygon.ypoints[nSide]);
            polyMarkerSide.addPoint(scaledPolygon.xpoints[nSide] + vc.virtToDestWidth(xDepth), scaledPolygon.ypoints[nSide] - vc.virtToDestHeight(yDepth));
            polyMarkerSide.addPoint(scaledPolygon.xpoints[nFace] + vc.virtToDestWidth(xDepth), scaledPolygon.ypoints[nFace] - vc.virtToDestHeight(yDepth));
            vectorPolyMarker.addElement(polyMarkerSide);
        }
        int nSortType = nDepthAngle > 90 ? 1 : 0;
        QSortPoly.quickSortPoly(vectorPolyMarker, 0, vectorPolyMarker.size() - 1, nSortType);
        if (!bb.getTransparentFillColor()) {
            Color c = bb.getFillColor();
            for (int nPoly = 0; nPoly < vectorPolyMarker.size(); ++nPoly) {
                Polygon p = (Polygon)vectorPolyMarker.elementAt(nPoly);
                IdentObj identObj = new IdentObj(id);
                identObj.setMiscID(nPoly);
                pfj.setFillType(identObj, 2);
                if ((Double)directionVector.elementAt(nPoly) >= 45.0) {
                    pfj.setGradientDirection(identObj, 2);
                } else {
                    pfj.setGradientDirection(identObj, 4);
                }
                pfj.setGradientNumPins(identObj, 2);
                pfj.setGradientPinPosition(identObj, 0.0, 0);
                pfj.setGradientPinPosition(identObj, 1.0, 1);
                pfj.setGradientPinRightColor(identObj, pfj.getBrighter(c), 0);
                pfj.setGradientPinLeftColor(identObj, pfj.getBrighter(c), 0);
                pfj.setGradientPinRightColor(identObj, c, 1);
                pfj.setGradientPinLeftColor(identObj, c, 1);
                BlackBoxObj blackBox = new BlackBoxObj(pfj, identObj);
                blackBox.setBorderColor(pfj.getBrighter(c));
                new DetPolygon(detectiv, identObj, p, (BlackBoxIF)blackBox, bHiliteable, rClip);
            }
        }
        IdentObj obj = new IdentObj(id);
        obj.setMiscID(vectorPolyMarker.size());
        new DetPolygon(detectiv, obj, scaledPolygon, bb, bHiliteable, rClip);
    }

    private static void applyCylinderBarsGradientEffect(BlackBoxIF bb, Perspective pfj) {
        JGraphType gt = pfj.getJGraphType();
        if (!gt.isBLAType()) {
            return;
        }
        int direction = 1;
        if (gt.isOrientHorz()) {
            direction = 4;
        }
        Color c = pfj.getFillColor(bb.getIdentObj());
        Color darkerColor = pfj.getDarker(c);
        Color brighterColor = pfj.getBrighter(c);
        FillGradientObj fillGradient = new FillGradientObj(pfj, direction);
        double midPinPos = 0.5;
        if (pfj.getDepthRadius() > 0 && gt.wantDepthEffect()) {
            midPinPos = 0.3 + 0.4 * ((double)pfj.getDepthAngle() / 180.0);
        }
        fillGradient.insertPin(0.0, darkerColor, darkerColor);
        fillGradient.insertPin(midPinPos, brighterColor, brighterColor);
        fillGradient.insertPin(1.0, darkerColor, darkerColor);
        bb.setFillGradientObj(fillGradient);
    }

    private static void calcLine(Perspective pfj, Detectiv detectiv, Point center, MarkerTemplate template, IdentObj id, int markerSizeX, BlackBoxIF bb) {
        int nLineStyle = template.getLineStyle();
        int nLineWidth = template.getLineWidth();
        VC vc = pfj.getVC();
        int width = vc.virtToDestWidth(template.m_rect.width * markerSizeX / 100);
        int x = vc.virtToDestX(center.x);
        x = vc.destToVirtX(x - width / 2);
        new DetLine(detectiv, id, x, center.y, x + vc.destToVirtWidth(width - 1), center.y, bb, null, nLineWidth, nLineStyle);
    }

    private static void calcDrillUp(Perspective pfj, Detectiv detectiv, Point center, IdentObj id, int markerSizeX, int markerSizeY, BlackBoxIF bb, Rectangle rClip) {
        VC vc = pfj.getVC();
        int x = vc.virtToDestX(center.x);
        int y = vc.virtToDestY(center.y);
        Rectangle scaledRect = new Rectangle(x - markerSizeX / 2, y - markerSizeY / 2, markerSizeX, markerSizeY);
        new DetImage(detectiv, id, bb, rClip, false, scaledRect);
    }

    private static void drawHuman(Perspective pfj, Detectiv detectiv, BlackBoxIF bb, IdentObj id, int cx, int cy, int width, int height, Rectangle rClip, boolean isUnderLay) {
        double scaleFactor;
        int x = cx - width / 2;
        int y = cy - height / 2;
        Rectangle markerBounds = new Rectangle(x, y, width - 1, height - 1);
        if ((pfj.isChartScatter() || pfj.getJGraphType().isPolar() || pfj.getJGraphType().isBubble()) && ObjClassID.stripExceptionalOffset(id.getObjectID()) != 13) {
            scaleFactor = (markerBounds.getWidth() + markerBounds.getHeight()) / (double)(MarkerObj.SHAPE_HUMAN_BOUNDS.width + MarkerObj.SHAPE_HUMAN_BOUNDS.height);
        } else {
            double sx = markerBounds.getWidth() / (double)MarkerObj.SHAPE_HUMAN_BOUNDS.width;
            double sy = markerBounds.getHeight() / (double)MarkerObj.SHAPE_HUMAN_BOUNDS.height;
            scaleFactor = Math.min(sx, sy);
        }
        AffineTransform scale = AffineTransform.getScaleInstance(scaleFactor, scaleFactor);
        Shape marker = scale.createTransformedShape(SHAPE_HUMAN);
        Rectangle2D scaledMarkerBounds = marker.getBounds2D();
        double tx = markerBounds.getCenterX() - scaledMarkerBounds.getCenterX();
        double ty = markerBounds.getCenterY() - scaledMarkerBounds.getCenterY();
        AffineTransform translate = AffineTransform.getTranslateInstance(tx, ty);
        marker = translate.createTransformedShape(marker);
        Rectangle destClip = null;
        if (rClip != null) {
            destClip = pfj.getVC().virtToDest(rClip);
        }
        if (!pfj.m_bExportingToXML) {
            new DetShape(detectiv, id, bb, new Area(marker)).clipRect(destClip);
        }
        if (isUnderLay) {
            Rectangle2D rect = marker.getBounds2D();
            pfj.setUnderLayRectangle(id, rect);
        }
    }

    static {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(39.791983, 38.300506);
        ((Path2D)path).curveTo(47.199983, 38.300506, 53.205983, 32.296506, 53.205983, 24.894506);
        ((Path2D)path).lineTo(53.205983, 15.636506);
        ((Path2D)path).curveTo(53.205983, 8.234506, 47.199983, 2.232506, 39.791983, 2.232506);
        ((Path2D)path).curveTo(32.381983, 2.232506, 26.377983, 8.234506, 26.377983, 15.636506);
        ((Path2D)path).lineTo(26.377983, 24.894506);
        ((Path2D)path).curveTo(26.377983, 32.296506, 32.381983, 38.300506, 39.791983, 38.300506);
        path.closePath();
        ((Path2D)path).moveTo(56.010983, 45.575506);
        ((Path2D)path).lineTo(23.574983, 45.575506);
        ((Path2D)path).curveTo(9.5389825, 45.575506, 2.2219825, 56.954506, 2.2219825, 70.989506);
        ((Path2D)path).lineTo(2.2219825, 125.38551);
        ((Path2D)path).lineTo(14.967983, 125.38551);
        ((Path2D)path).lineTo(14.967983, 73.776506);
        ((Path2D)path).curveTo(14.967983, 72.215506, 14.748983, 70.952506, 15.760983, 70.952506);
        ((Path2D)path).curveTo(16.772983, 70.952506, 16.502983, 72.304506, 16.502983, 73.661506);
        ((Path2D)path).lineTo(16.502983, 197.92951);
        ((Path2D)path).curveTo(16.502983, 199.49051, 17.768983, 200.75351, 19.326983, 200.75351);
        ((Path2D)path).lineTo(31.857983, 200.75351);
        ((Path2D)path).curveTo(33.417983, 200.75351, 34.681983, 199.48951, 34.681983, 197.92951);
        ((Path2D)path).lineTo(34.681983, 131.67951);
        ((Path2D)path).lineTo(44.900983, 131.67951);
        ((Path2D)path).lineTo(44.900983, 197.92951);
        ((Path2D)path).curveTo(44.900983, 199.49051, 46.164983, 200.75351, 47.724983, 200.75351);
        ((Path2D)path).lineTo(60.252983, 200.75351);
        ((Path2D)path).curveTo(61.812983, 200.75351, 63.077983, 199.48951, 63.077983, 197.92951);
        ((Path2D)path).lineTo(63.077983, 73.661506);
        ((Path2D)path).curveTo(63.077983, 72.304506, 62.960983, 70.952506, 63.916983, 70.952506);
        ((Path2D)path).curveTo(64.872983, 70.952506, 64.708983, 72.216506, 64.708983, 73.776506);
        ((Path2D)path).lineTo(64.708983, 125.38551);
        ((Path2D)path).lineTo(77.358983, 125.38551);
        ((Path2D)path).lineTo(77.358983, 70.989506);
        ((Path2D)path).curveTo(77.360983, 56.954506, 70.047983, 45.575506, 56.010983, 45.575506);
        path.closePath();
        SHAPE_HUMAN = new Area(path);
        SHAPE_HUMAN_BOUNDS = SHAPE_HUMAN.getBounds();
        SHAPE_HUMAN_WIDTH_HEIGHT_RATIO = SHAPE_HUMAN_BOUNDS.getWidth() / SHAPE_HUMAN_BOUNDS.getHeight();
    }
}

