/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;
import oracle.dss.graph.pfj.AxisPieBarObj;
import oracle.dss.graph.pfj.AxisTemplate;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_Pie;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.TDGNumberFormat;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class JChart_2D_PieBar
extends JChart_2D_Pie {
    private static final long serialVersionUID = 1L;
    public static final int PIEBAR_RISER_WIDTH = 2000;
    public static final int ID_TOPLINE = 300;
    public static final int ID_BOTTOMLINE = 400;
    protected RelativeAxisObj m_Y1Axis;
    protected String[] m_DataLabel;
    protected Rectangle[] m_RiserRect;
    protected Point m_ptTopBar;
    protected Point m_ptBottomBar;
    protected double m_fSliceValue;
    protected boolean m_bPieBarSliceIsOK;
    protected boolean m_bDataTextDisplay;
    protected int m_nDepthRadius;
    protected boolean m_bAutoshading;
    protected Point m_frontOffset;
    protected double[] m_groupValues;

    public void calcBar() {
        int gPrev;
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        this.m_groupValues = new double[this.m_nTotalGroups];
        double[] fPartialSums = new double[this.m_nTotalGroups];
        int[] nNumYCoords = new int[this.m_nTotalGroups];
        int g = -1;
        Point frontOffset = new Point(this.m_frontOffset.x, this.m_frontOffset.y);
        PfjAssert.pfjAssert(this.m_nPieBarSlice >= 0 && this.m_nPieBarSlice < this.m_nTotalSeries);
        PfjAssert.pfjAssert(this.m_nGroups > 0);
        PfjAssert.pfjAssert(this.m_fPieTotal > 0.0);
        PfjAssert.pfjAssert(this.m_Y1Axis);
        int gFirst = gEnum.getFirstGroup();
        int gLast = gEnum.getLastGroup();
        while (gEnum.hasMoreElements()) {
            g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            gPrev = gEnum.peekAtGroupBefore(g);
            if (g != gFirst) {
                PfjAssert.pfjAssert(gPrev >= 0 && gPrev < this.m_nTotalGroups);
            }
            this.m_groupValues[g] = Math.max(this.getDataValue((int)this.m_nPieBarSlice, (int)g).m_fValue, 0.0);
            if (g == gFirst) {
                fPartialSums[g] = this.m_groupValues[g];
                continue;
            }
            fPartialSums[g] = fPartialSums[gPrev] + this.m_groupValues[g];
        }
        double fSliceTotal = g == -1 ? 0.0 : fPartialSums[g];
        if (this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalGroups];
            this.m_RiserRect = new Rectangle[this.m_nTotalGroups];
            String szDataFormatPattern = this.m_Perspective.getDataTextFormatPattern();
            int nDataFormat = this.m_Perspective.getDataTextFormat();
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                double fDataTextValue;
                g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                double d = fDataTextValue = TDGNumberFormat.isPercentFormat(nDataFormat) ? fPartialSums[g] / fSliceTotal : fPartialSums[g];
                if (this.m_Perspective.isNumberFormatCallBack()) {
                    this.m_Perspective.getNumberFormatCallBack().setState(3, this.m_nPieBarSlice, g, -1, -3);
                    this.m_DataLabel[g] = this.m_Perspective.getNumberFormatCallBack().toString(this.m_groupValues[g]);
                    continue;
                }
                this.m_DataLabel[g] = TDGNumberFormat.toString(this.m_Perspective, nDataFormat, this.m_groupValues[g], szDataFormatPattern);
            }
        }
        int nZeroCoord = (int)this.m_Y1Axis.getValueCoord(0.0);
        int nHeight = (int)this.m_Y1Axis.getValueCoord(fSliceTotal) - nZeroCoord;
        int nOffsetY = (this.m_rPieFrame.height - nHeight) / 2;
        gEnum.reset();
        while (gEnum.hasMoreElements()) {
            g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            gPrev = gEnum.peekAtGroupBefore(g);
            if (g != gFirst) {
                PfjAssert.pfjAssert(gPrev >= 0 && gPrev < this.m_nTotalGroups);
            }
            nNumYCoords[g] = (int)this.m_Y1Axis.getValueCoord(fPartialSums[g]);
            int left = this.m_rPieFrame.x + this.m_rPieFrame.width - this.m_nBarThickCoord;
            int right = left + this.m_nBarThickCoord;
            int bottom = g == gFirst ? nZeroCoord + nOffsetY : nNumYCoords[gPrev] + nOffsetY;
            int top = nNumYCoords[g] + nOffsetY;
            Rectangle rVirt = new Rectangle(left, bottom, right - left, top - bottom);
            if (this.m_bDataTextDisplay) {
                this.m_RiserRect[g] = rVirt;
            }
            if (g == gLast) {
                this.m_ptTopBar = new Point(left, top);
                this.m_ptBottomBar = new Point(left, nZeroCoord + nOffsetY);
            }
            int gColor = g % this.m_nSeriesLooping;
            IdentObj idFront = new IdentObj(331, this.m_nPieBarSlice, gColor);
            IdentObj idSeries = new IdentObj(-3, -3, gColor);
            BlackBoxIF blackBox = this.assignSeriesColor(idSeries);
            if (this.m_nDepthRadius > 0 && this.m_Frame != null) {
                Polygon polyVC;
                double fIntensity;
                if (this.m_nDepthAngle > 90) {
                    rVirt.x += frontOffset.x;
                    if (g == gLast) {
                        this.m_ptTopBar = new Point(rVirt.x, top);
                        this.m_ptBottomBar = new Point(rVirt.x, nZeroCoord + nOffsetY);
                    }
                }
                Point backOffset = new Point(0, 0);
                rVirt.x -= frontOffset.x;
                rVirt.y -= frontOffset.y;
                if (this.m_bAutoshading) {
                    fIntensity = 1.0;
                    polyVC = new Polygon();
                    polyVC.addPoint(rVirt.x, rVirt.y);
                    polyVC.addPoint(rVirt.x + rVirt.width, rVirt.y);
                    polyVC.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
                    polyVC.addPoint(rVirt.x, rVirt.y + rVirt.height);
                    polyVC.addPoint(rVirt.x, rVirt.y);
                    new DetPolygon(this.m_Detectiv, idFront, polyVC, blackBox, fIntensity);
                } else {
                    new DetRect(this.m_Detectiv, idFront, rVirt, blackBox, null);
                }
                if (this.m_nDepthAngle != 90) {
                    int xFrame = this.m_nDepthAngle > 90 ? rVirt.x : rVirt.x + rVirt.width;
                    polyVC = new Polygon();
                    polyVC.addPoint(xFrame, rVirt.y);
                    polyVC.addPoint(xFrame, rVirt.y + rVirt.height);
                    polyVC.addPoint(xFrame + (frontOffset.x - backOffset.x), rVirt.y + rVirt.height + (frontOffset.y - backOffset.y));
                    polyVC.addPoint(xFrame + (frontOffset.x - backOffset.x), rVirt.y + (frontOffset.y - backOffset.y));
                    polyVC.addPoint(xFrame, rVirt.y);
                    fIntensity = this.m_bAutoshading ? 0.6 : 1.0;
                    IdentObj idSide = new IdentObj(334, this.m_nPieBarSlice, gColor);
                    new DetPolygon(this.m_Detectiv, idSide, polyVC, blackBox, fIntensity);
                }
                if (this.m_nDepthAngle == 0 || this.m_nDepthAngle == 180) continue;
                polyVC = new Polygon();
                polyVC.addPoint(rVirt.x, rVirt.y + rVirt.height);
                polyVC.addPoint(rVirt.x + rVirt.width, rVirt.y + rVirt.height);
                polyVC.addPoint(rVirt.x + rVirt.width + (frontOffset.x - backOffset.x), rVirt.y + rVirt.height + (frontOffset.y - backOffset.y));
                polyVC.addPoint(rVirt.x + (frontOffset.x - backOffset.x), rVirt.y + rVirt.height + (frontOffset.y - backOffset.y));
                polyVC.addPoint(rVirt.x, rVirt.y + rVirt.height);
                fIntensity = 0.8;
                IdentObj idTop = new IdentObj(335, this.m_nPieBarSlice, gColor);
                new DetPolygon(this.m_Detectiv, idTop, polyVC, blackBox, fIntensity);
                continue;
            }
            new DetRect(this.m_Detectiv, idFront, rVirt, blackBox, null);
        }
    }

    protected Rectangle calcDataValuePosition(int g, Dimension labelDim) {
        Point centerTop = new Point(this.m_RiserRect[g].x + this.m_RiserRect[g].width / 2, this.m_RiserRect[g].y + this.m_RiserRect[g].height);
        Rectangle r = new Rectangle(centerTop.x - labelDim.width / 2, centerTop.y - labelDim.height / 2, labelDim.width, labelDim.height);
        switch (this.m_Perspective.getDataTextPosition()) {
            case 0: {
                double nAngle = this.m_Perspective.getDataTextAngle(this.m_nPieBarSlice, g);
                double nDist = this.m_Perspective.getDataTextRadius(this.m_nPieBarSlice, g);
                r.x += (int)(Math.cos(nAngle * (Math.PI / 180)) * nDist * 40.0);
                r.y += (int)(Math.sin(nAngle * (Math.PI / 180)) * nDist * 40.0);
                break;
            }
            case 1: {
                r.y += labelDim.height / 2;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                r.y -= labelDim.height / 2;
                break;
            }
            case 4: {
                r.y = this.m_RiserRect[g].y + this.m_RiserRect[g].height / 2 - labelDim.height / 2;
                break;
            }
            case 5: {
                r.y = (int)this.m_Y1Axis.getValueCoord(0.0);
            }
        }
        return r;
    }

    @Override
    protected void calcSinglePie() {
        super.calcSinglePie();
        if (this.m_bPieBarSliceIsOK) {
            this.m_Y1Axis = null;
            this.createY1Axis();
            this.calcBar();
            this.drawConnectingLines();
            if (this.m_bDataTextDisplay) {
                this.drawDataValues();
            }
        }
    }

    @Override
    protected void copyParams() {
        super.copyParams();
        this.m_fSliceValue = this.getSeriesTotal(this.m_nPieBarSlice);
        if (this.m_fSliceValue < 0.0) {
            this.m_fSliceValue = 0.0;
        }
        this.m_bPieBarSliceIsOK = this.m_fSliceValue > 0.0;
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        if (sEnum.getRelativeSeries(this.m_nPieBarSlice) == -1) {
            this.m_bPieBarSliceIsOK = false;
        }
        this.m_bDataTextDisplay = this.m_Perspective.getDataTextDisplay();
        this.m_DataLabel = null;
        this.m_RiserRect = null;
        this.m_nBarThickCoord = 2000 * this.m_Perspective.getRiserWidth() / 100;
        Rectangle rFrame = this.m_Perspective.getRect(this.m_Perspective.getPieFrame());
        if (this.m_nBarThickCoord > rFrame.width / 5) {
            this.m_nBarThickCoord = rFrame.width / 5;
        }
        this.m_nDepthRadius = this.m_Perspective.getPieDepth();
        this.m_bAutoshading = this.m_Perspective.getAutoshading();
        double rMax = this.m_nBarThickCoord;
        double r = rMax * (double)this.m_nDepthRadius / 100.0;
        double dx = r * Math.cos((double)this.m_nDepthAngle * (Math.PI / 180));
        double dy = r * Math.sin((double)this.m_nDepthAngle * (Math.PI / 180));
        this.m_frontOffset = new Point((int)dx, (int)dy);
    }

    protected void createY1Axis() {
        MinMaxObj y1MinMaxObj = new MinMaxObj(0.0, this.m_fSliceValue);
        int nOffset = 0;
        int nSize = 100;
        boolean bMustIncludeZero = false;
        boolean bVerticalAxis = true;
        boolean bAscending = true;
        this.m_Y1Axis = new AxisPieBarObj(this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, y1MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize);
        this.m_Y1Axis.calc();
    }

    public void drawConnectingLines() {
        IdentObj id = this.m_Perspective.getPieBarConnectLines();
        BlackBoxObj bb = new BlackBoxObj(this.m_Perspective, id);
        int nWidth = this.m_Perspective.getLineWidth(id);
        int x1 = (int)this.m_ptTopSlice.getX();
        int y1 = (int)this.m_ptTopSlice.getY();
        int x2 = this.m_ptTopBar.x - this.m_frontOffset.x;
        int y2 = this.m_ptTopBar.y - this.m_frontOffset.y;
        IdentObj newID = new IdentObj(id);
        newID.setMiscID(300);
        new DetLine(this.m_Detectiv, newID, x1, y1, x2, y2, (BlackBoxIF)bb, null, nWidth);
        x1 = (int)this.m_ptBottomSlice.getX();
        y1 = (int)this.m_ptBottomSlice.getY();
        x2 = this.m_ptBottomBar.x - this.m_frontOffset.x;
        y2 = this.m_ptBottomBar.y - this.m_frontOffset.y;
        newID = new IdentObj(id);
        newID.setMiscID(400);
        new DetLine(this.m_Detectiv, newID, x1, y1, x2, y2, (BlackBoxIF)bb, null, nWidth);
    }

    protected void drawDataValues() {
        int g;
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        Graphics gx = this.m_Perspective.getGraphicsContext();
        Vector<String> szLabels = new Vector<String>(this.m_nGroups);
        Dimension labelDim = new Dimension(8000, 1600);
        IdentObj id = this.m_Perspective.getDataText();
        boolean bDataValueFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(id);
        TextStyleObj textStyle = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), bDataValueFontSizeAbsolute, this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), this.m_Perspective.getTextJustHoriz(id), this.m_Perspective.getTextJustVert(id), false, false, this.m_Perspective.getTextWrap(id));
        while (gEnum.hasMoreElements()) {
            g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            this.m_DataLabel[g] = this.m_Perspective.getCustomDataText(this.m_DataLabel[g], new IdentObj(id.getObjectID(), id.getSeriesID(), g));
            szLabels.addElement(this.m_DataLabel[g]);
        }
        int nFontSizeVC = bDataValueFontSizeAbsolute ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(id)) : this.m_Perspective.getFontSizeVC(id);
        textStyle.formatAndAutofit(gx, this.m_Perspective, this.m_Perspective.getAutofit(new IdentObj(260)), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), nFontSizeVC, szLabels, labelDim, this.m_Perspective.m_VC);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        gEnum.reset();
        while (gEnum.hasMoreElements()) {
            g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            if (this.m_DataLabel[g] == null) continue;
            Rectangle r = this.calcDataValuePosition(g, labelDim);
            IdentObj newID = new IdentObj(id.getObjectID(), this.m_nPieBarSlice, g);
            String fullText = this.m_DataLabel[g];
            String newLabel = this.getTruncatedLabel(textStyle, labelDim.width, fullText);
            new DetLabel(this.m_Detectiv, newID, newLabel, fullText, r, textStyle, blackBox, false, null);
        }
    }

    @Override
    public int getBarThickness() {
        return this.m_nBarThickCoord;
    }

    @Override
    protected int getSliceObjectID(int nDefaultID) {
        int nPieBarID;
        switch (nDefaultID) {
            case 298: {
                nPieBarID = 332;
                break;
            }
            case 299: {
                nPieBarID = 333;
                break;
            }
            default: {
                nPieBarID = nDefaultID;
            }
        }
        return nPieBarID;
    }

    @Override
    protected double getPieRotation() {
        PfjAssert.pfjAssert(this.m_nPieBarSlice >= 0 && this.m_nPieBarSlice < this.m_nTotalSeries);
        PfjAssert.pfjAssert(this.m_nGroups > 0);
        PfjAssert.pfjAssert(this.m_nSeries > 0);
        PfjAssert.pfjAssert(this.m_fPieTotal > 0.0);
        double fPrevSlicesValue = 0.0;
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        while (sEnum.hasMoreElements()) {
            int s = sEnum.nextSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            if (s >= this.m_nPieBarSlice) break;
            double fValue = this.getSeriesTotal(s);
            if (!(fValue > 0.0)) continue;
            fPrevSlicesValue += fValue;
        }
        double fPrevSlicesPct = fPrevSlicesValue / this.m_fPieTotal;
        double fSlicePct = this.m_fSliceValue / this.m_fPieTotal;
        return 0.25 - fPrevSlicesPct - fSlicePct / 2.0;
    }

    @Override
    protected boolean isPieBarSliceOK() {
        return this.m_bPieBarSliceIsOK;
    }

    @Override
    public void releaseReferences() {
        if (this.m_Y1Axis != null) {
            this.m_Y1Axis.releaseReferences();
        }
        super.releaseReferences();
    }

    public RelativeAxisObj getY1Axis() {
        return this.m_Y1Axis;
    }

    public double getGroupValueForBar(int g) {
        if (this.m_groupValues != null) {
            return this.m_groupValues[g];
        }
        return 0.0;
    }
}

