/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import oracle.dss.graph.GraphConstants;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Axis2DObj;
import oracle.dss.graph.pfj.AxisTemplate;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.TDGNumberFormat;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.SimpleBlackBoxObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.graph.pfj.event.TDGEventManager;

public class JChart_2D_Hilo
extends JChart_2D_Standard {
    private static final long serialVersionUID = 1L;
    public static final int TICK_LENGTH = 5;
    public static final int RISER_TICK_THICKNESS = 3;
    public static final int MA_SCIENTIFIC = 0;
    public static final int MA_FINANCIAL = 1;
    public static final int MISC_LOWER = 1;
    public static final int kMAX_HILO_ITEMS = 4;
    public static final int STOCK_SPLITBAR = 0;
    public static final int STOCK_TICKS = 1;
    public static final int VOLUME_SERIES = 1;
    protected DataFormat m_df;
    protected boolean m_bHasOpen;
    protected boolean m_bHasClose;
    protected boolean m_bHasVolume;
    protected int m_nLineWidthMA;
    protected int m_nLineWidthCloseTick;
    protected int m_nLineWidthOpenTick;
    protected int m_nLineWidthHighWick;
    protected int m_nLineWidthLowWick;
    protected boolean m_bCloseSplitDisplay;
    protected boolean m_bCloseTicksDisplay;
    protected boolean m_bOpenTicksDisplay;
    protected boolean m_bInterpretAsHLOC;
    String[] m_VolumeDataLabel;
    GroupsEnumerator m_gEnumReadOnly;

    @Override
    public void init(Perspective perspective) {
        super.init(perspective);
        this.m_df = this.m_Access.getDataFormat();
        this.m_bHasOpen = this.hasOpenValue(this.m_df);
        this.m_bHasClose = this.hasCloseValue(this.m_df);
        this.m_bHasVolume = this.hasVolumeValue(this.m_df);
    }

    protected void calc52WeekLines() {
        int x2;
        int x1;
        int y2;
        int y1;
        IdentObj idHigh = new IdentObj(304);
        IdentObj idLow = new IdentObj(305);
        BlackBoxObj blackBoxHigh = new BlackBoxObj(this.m_Perspective, idHigh);
        BlackBoxObj blackBoxLow = new BlackBoxObj(this.m_Perspective, idLow);
        Rectangle frameRect = this.m_Perspective.getFrameRect(true);
        if (this.m_gt.isBipolar()) {
            return;
        }
        if (this.m_Perspective.getStock52WeekHighDisplay()) {
            double f52High = this.m_Perspective.getStock52WeekHighValue();
            y2 = y1 = (int)this.m_Y1Axis.getValueCoord(f52High);
            x1 = frameRect.x;
            x2 = frameRect.x + frameRect.width;
            new DetLine(this.m_Detectiv, idHigh, x1, y1, x2, y2, (BlackBoxIF)blackBoxHigh, this.m_rClip, this.m_Perspective.getLineWidth(this.m_Perspective.getStock52WeekHighLine()));
        }
        if (this.m_Perspective.getStock52WeekLowDisplay()) {
            double f52Low = (int)this.m_Perspective.getStock52WeekLowValue();
            y2 = y1 = (int)this.m_Y1Axis.getValueCoord(f52Low);
            x1 = frameRect.x;
            x2 = frameRect.x + frameRect.width;
            new DetLine(this.m_Detectiv, idLow, x1, y1, x2, y2, (BlackBoxIF)blackBoxLow, this.m_rClip, this.m_Perspective.getLineWidth(this.m_Perspective.getStock52WeekLowLine()));
        }
    }

    @Override
    protected void calcDataAbsolute() {
        this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_gEnumReadOnly = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        this.m_Perspective.calcReferenceObjects(1);
        this.m_Perspective.calcAnnotations(GraphConstants.AnnotationLocation.BACK);
        if (this.m_gt.isStockCandleType()) {
            this.drawCandleRisers();
        } else {
            this.drawRisersAndTicks();
        }
        if ((this.m_gt.isBipolar() || this.m_bHasVolume) && this.m_Perspective.getFrameDisplay() && this.m_Perspective.getDualAxisLineDisplay()) {
            double fSplit = (double)this.m_Perspective.getDualAxisSplitPosition() / 100.0;
            this.m_Frame.drawSeparator(this.m_bHorz, fSplit);
        }
        this.calc52WeekLines();
        if (this.m_Perspective.getStockMovingAverageDisplay()) {
            SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
            while (sEnum.hasMoreElements()) {
                int s = sEnum.nextSeries();
                PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
                this.calcMovingAverageLine(s);
            }
        }
        if (this.m_bDataTextDisplay) {
            this.drawDataValues();
            if (this.m_bHasVolume) {
                this.drawVolumeDataValues();
            }
        }
    }

    @Override
    protected void drawDataValues() {
        int g;
        int s;
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        Graphics gx = this.m_Perspective.getGraphicsContext();
        IdentObj id = this.m_Perspective.getDataText();
        Vector<String> szLabels = new Vector<String>(this.m_nSeries * this.m_nGroups);
        Dimension labelDim = new Dimension(8000, 3000);
        boolean bDataValueFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(id);
        TextStyleObj textStyle = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), bDataValueFontSizeAbsolute, this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), this.m_Perspective.getTextJustHoriz(id), this.m_Perspective.getTextJustVert(id), false, false, this.m_Perspective.getTextWrap(id));
        while (sEnum.hasMoreElements() && (s = sEnum.nextSeries()) < this.m_nTotalSeries) {
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                this.m_DataLabel[s][g] = this.m_Perspective.getCustomDataText(this.m_DataLabel[s][g], new IdentObj(id.getObjectID(), s, g));
                szLabels.addElement(this.m_DataLabel[s][g]);
            }
        }
        int nFontSizeVC = bDataValueFontSizeAbsolute ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(id)) : this.m_Perspective.getFontSizeVC(id);
        textStyle.formatAndAutofit(gx, this.m_Perspective, this.m_Perspective.getAutofit(new IdentObj(260)), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), nFontSizeVC, szLabels, labelDim, this.m_Perspective.m_VC);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        sEnum.reset();
        while (sEnum.hasMoreElements() && (s = sEnum.nextSeries()) < this.m_nTotalSeries) {
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                if (!this.m_dataOK[s][g] || this.m_DataLabel[s][g] == null) continue;
                Rectangle r = this.calcHiLoDataValuePosition(s, g, labelDim);
                IdentObj newID = new IdentObj(id.getObjectID(), s, g);
                String fullText = this.m_DataLabel[s][g];
                String newLabel = this.getTruncatedLabel(textStyle, labelDim.width, fullText);
                new DetLabel(this.m_Detectiv, newID, newLabel, fullText, r, textStyle, blackBox, false);
            }
        }
    }

    protected Rectangle calcHiLoDataValuePosition(int s, int g, Dimension labelDim) {
        Point center = this.getCoords(s, g);
        Point base = this.getBottomCoords(s, g);
        Rectangle r = new Rectangle(center.x - labelDim.width / 2, center.y - labelDim.height / 2, labelDim.width, labelDim.height);
        switch (this.m_Perspective.getDataTextPosition()) {
            case 0: {
                double nAngle = this.m_Perspective.getDataTextAngle(s, g);
                double nDist = this.m_Perspective.getDataTextRadius(s, g);
                r.x += (int)(Math.cos(nAngle * (Math.PI / 180)) * nDist * 40.0);
                r.y += (int)(Math.sin(nAngle * (Math.PI / 180)) * nDist * 40.0);
                break;
            }
            case 1: {
                if (this.isAxisAscending(s)) {
                    r.y += labelDim.height / 2;
                    break;
                }
                r.y -= labelDim.height / 2;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (this.isAxisAscending(s)) {
                    r.y -= labelDim.height / 2;
                    break;
                }
                r.y += labelDim.height / 2;
                break;
            }
            case 4: {
                r.y = Math.min(center.y, base.y) + (Math.abs(center.y - base.y) - labelDim.height) / 2;
                break;
            }
            case 5: {
                r.y = base.y;
            }
        }
        Point offset = new Point(0, 0);
        if (this.m_Frame != null) {
            offset = this.m_Frame.getDepthOffset(1.0);
        }
        r.x -= offset.x;
        r.y -= offset.y;
        return r;
    }

    protected void drawVolumeDataValues() {
        int s;
        int g;
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        Graphics gx = this.m_Perspective.getGraphicsContext();
        IdentObj id = this.m_Perspective.getDataText();
        Vector<String> vectStrLabels = new Vector<String>(this.m_nSeries * this.m_nGroups);
        Dimension labelDim = new Dimension(3000, 3000);
        boolean bDataValueFontSizeAbsolute = this.m_Perspective.getFontSizeAbsolute(id);
        TextStyleObj textStyle = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(id), this.m_Perspective.getFontStyle(id), bDataValueFontSizeAbsolute, this.m_Perspective.getFontSize(id), this.m_Perspective.getFontSizeVC(id), this.m_Perspective.getTextRotation(id), this.m_Perspective.getTextJustHoriz(id), this.m_Perspective.getTextJustVert(id), false, false, this.m_Perspective.getTextWrap(id));
        while (gEnum.hasMoreElements()) {
            g = gEnum.nextGroup();
            PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
            vectStrLabels.addElement(this.m_VolumeDataLabel[g]);
        }
        int nFontSizeVC = bDataValueFontSizeAbsolute ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(id)) : this.m_Perspective.getFontSizeVC(id);
        textStyle.formatAndAutofit(gx, this.m_Perspective, this.m_Perspective.getAutofit(new IdentObj(260)), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), nFontSizeVC, vectStrLabels, labelDim, this.m_Perspective.m_VC);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        while (sEnum.hasMoreElements() && (s = sEnum.nextSeries()) < this.m_nTotalSeries) {
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                if (!this.m_dataOK[s][g] || this.m_VolumeDataLabel[g] == null) continue;
                Rectangle r = this.calcVolumeDataValuePosition(s, g, labelDim);
                IdentObj newID = new IdentObj(id.getObjectID(), s, g);
                new DetLabel(this.m_Detectiv, newID, this.m_VolumeDataLabel[g], r, textStyle, blackBox, false);
            }
        }
    }

    protected Rectangle calcVolumeDataValuePosition(int s, int g, Dimension labelDim) {
        boolean bDescendingVol = this.m_Y2Axis.isDescending();
        int gRel = this.m_gEnumReadOnly.getRelativeGroup(g);
        PfjAssert.pfjAssert(gRel >= 0 && gRel < this.m_nGroups);
        double fVolume = this.getVolumeValue(s, g);
        int bottom = (int)(bDescendingVol ? this.m_Y2Axis.getValueCoord(fVolume) : this.m_Y2Axis.getBaseCoord());
        int top = (int)(bDescendingVol ? this.m_Y2Axis.getBaseCoord() : this.m_Y2Axis.getValueCoord(fVolume));
        int left = (int)this.m_O1Axis.getLowCoord(0, gRel);
        int right = (int)this.m_O1Axis.getHighCoord(0, gRel);
        Point center = new Point(left + (right - left) / 2, top);
        int base = bottom;
        Rectangle r = new Rectangle(center.x - labelDim.width / 2, center.y - labelDim.height / 2, labelDim.width, labelDim.height);
        switch (this.m_Perspective.getDataTextPosition()) {
            case 0: {
                double nAngle = this.m_Perspective.getDataTextAngle(s, g);
                double nDist = this.m_Perspective.getDataTextRadius(s, g);
                r.x += (int)(Math.cos(nAngle * (Math.PI / 180)) * nDist * 40.0);
                r.y += (int)(Math.sin(nAngle * (Math.PI / 180)) * nDist * 40.0);
                break;
            }
            case 1: {
                if (this.isAxisAscending(s)) {
                    r.y += labelDim.height / 2;
                    break;
                }
                r.y -= labelDim.height / 2;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (this.isAxisAscending(s)) {
                    r.y -= labelDim.height / 2;
                    break;
                }
                r.y += labelDim.height / 2;
                break;
            }
            case 4: {
                r.y = Math.min(center.y, base) + (Math.abs(center.y - base) - labelDim.height) / 2;
                break;
            }
            case 5: {
                r.y = base;
            }
        }
        Point offset = null;
        if (this.m_Frame != null) {
            offset = this.m_Frame.getDepthOffset(1.0);
        }
        r.x -= offset.x;
        r.y -= offset.y;
        return r;
    }

    protected void calcMovingAverageLine(int s) {
        int g;
        RelativeAxisObj yAxisObj = this.getAxisAssignment(s) == 1 ? this.m_Y2Axis : this.m_Y1Axis;
        int nType = 1;
        int nOrder = 6;
        double[] fValues = new double[this.m_nTotalGroups];
        double[] fPartialSums = new double[this.m_nTotalGroups];
        int x0 = Integer.MIN_VALUE;
        int y0 = 0;
        if (nType != 0 && nType != 1) {
            throw new AssertionException("calcMovingAverageLine: unknown moving average type = " + nType);
        }
        if (nOrder < 1) {
            throw new AssertionException("calcMovingAverageLine: cannot average fewer than 1 point :-)");
        }
        if (nOrder >= this.m_nGroups) {
            this.m_Perspective.getErrorHandler().log("nOrder set to data points - 1.", this.getClass().getName(), "calcMovingAverageLine(int s)");
            nOrder = this.m_nGroups - 1;
        }
        DataItem item = this.m_bHasClose ? this.getCloseItem() : this.getHighItem();
        for (g = 0; g < this.m_nTotalGroups; ++g) {
            DatumObj dObj = this.getDataValue(s, g, item);
            fValues[g] = dObj.m_fValue;
            this.m_dataOK[s][g] = dObj.m_bOK;
            fPartialSums[g] = g == 0 ? fValues[g] : fPartialSums[g - 1] + fValues[g];
        }
        IdentObj id = new IdentObj(309);
        BlackBoxObj bb = new BlackBoxObj(this.m_Perspective, id);
        for (g = nOrder - 1; g < this.m_nTotalGroups; ++g) {
            int gRel = this.m_gEnumReadOnly.getRelativeGroup(g);
            if (gRel == -1) continue;
            PfjAssert.pfjAssert(gRel >= 0 && gRel < this.m_nGroups);
            double fTotal = g < nOrder ? fPartialSums[g] : fPartialSums[g] - fPartialSums[g - nOrder];
            double fAverage = fTotal / (double)nOrder;
            int x1 = nType == 0 ? (int)this.m_O1Axis.getCenterCoord(gRel) : (int)((this.m_O1Axis.getCenterCoord(gRel) + this.m_O1Axis.getCenterCoord(gRel - nOrder + 1)) / 2.0);
            int y1 = (int)yAxisObj.getValueCoord(fAverage);
            if (x0 != Integer.MIN_VALUE) {
                IdentObj newID = new IdentObj(id.getObjectID(), s, g);
                new DetLine(this.m_Detectiv, newID, x0, y0, x1, y1, (BlackBoxIF)bb, this.m_rClip, this.m_nLineWidthMA);
            }
            x0 = x1;
            y0 = y1;
        }
    }

    protected void calcVolumeBar(int g, double fVolume) {
        boolean bDescendingVol = this.m_Y2Axis.isDescending();
        int gRel = this.m_gEnumReadOnly.getRelativeGroup(g);
        PfjAssert.pfjAssert(gRel >= 0 && gRel < this.m_nGroups);
        int bottom = (int)(bDescendingVol ? this.m_Y2Axis.getValueCoord(fVolume) : this.m_Y2Axis.getBaseCoord());
        int top = (int)(bDescendingVol ? this.m_Y2Axis.getBaseCoord() : this.m_Y2Axis.getValueCoord(fVolume));
        int left = (int)this.m_O1Axis.getLowCoord(0, gRel);
        int right = (int)this.m_O1Axis.getHighCoord(0, gRel);
        Rectangle rVirt = new Rectangle(left, bottom, right - left, top - bottom);
        IdentObj idVol = new IdentObj(310, 1, g);
        BlackBoxIF blackBoxVol = this.m_autoGradient && (this.m_Perspective.m_VC.virtToDestWidth(rVirt.width) <= 3 || this.m_Perspective.m_VC.virtToDestHeight(rVirt.height) <= 3) ? new SimpleBlackBoxObj(this.m_Perspective, new IdentObj(310), this.m_bWantRiserBorder) : new BlackBoxObj(this.m_Perspective, new IdentObj(310));
        new DetRect(this.m_Detectiv, idVol, rVirt, blackBoxVol, this.m_rClip);
    }

    @Override
    protected void copyParams() {
        super.copyParams();
        this.m_nLineWidthMA = this.m_Perspective.getLineWidth(this.m_Perspective.getStockMALine());
        this.m_nLineWidthCloseTick = this.m_Perspective.getLineWidth(this.m_Perspective.getStockCloseTick());
        this.m_nLineWidthOpenTick = this.m_Perspective.getLineWidth(this.m_Perspective.getStockOpenTick());
        this.m_nLineWidthHighWick = this.m_Perspective.getLineWidth(this.m_Perspective.getStockHighLine());
        this.m_nLineWidthLowWick = this.m_Perspective.getLineWidth(this.m_Perspective.getStockLowLine());
        this.m_bCloseSplitDisplay = this.m_Perspective.getStockCloseSplitDisplay();
        this.m_bCloseTicksDisplay = this.m_Perspective.getStockCloseTicksDisplay();
        this.m_bOpenTicksDisplay = this.m_Perspective.getStockOpenTicksDisplay();
        this.m_bInterpretAsHLOC = this.m_Perspective.getInterpretAsHLOC();
        if (this.isSingleSeriesOnly() && this.m_nSeries > 1) {
            this.m_nSeries = 1;
            this.m_nTotalSeries = 1;
        }
    }

    @Override
    protected void createAxes() {
        int split;
        int offsetY1 = split = this.m_gt.isBipolar() || this.m_bHasVolume ? this.m_Perspective.getDualAxisSplitPosition() : 0;
        int sizeY1 = 100 - offsetY1;
        int offsetY2 = this.m_gt.isBipolar() ? 0 : offsetY1;
        int sizeY2 = this.m_gt.isBipolar() ? 100 - sizeY1 : sizeY1;
        boolean bVerticalAxis = this.m_gt.getOrientation() == 2;
        int ordType = 1;
        this.m_O1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.O1_AXIS, ordType, !bVerticalAxis, bVerticalAxis);
        boolean bMustIncludeZero = this.m_Perspective.getY1MustIncludeZero();
        MinMaxObj y1MinMaxObj = this.findLimits(0, bMustIncludeZero);
        this.m_Y1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, y1MinMaxObj, bVerticalAxis, !this.m_Perspective.getY1AxisDescending(), offsetY1, sizeY1);
        if (this.m_gt.isDualY()) {
            bMustIncludeZero = this.m_Perspective.getY2MustIncludeZero();
            MinMaxObj y2MinMaxObj = this.findLimits(1, bMustIncludeZero);
            this.m_Y2Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y2_AXIS, y2MinMaxObj, bVerticalAxis, !this.m_Perspective.getY2AxisDescending(), offsetY2, sizeY2);
        } else if (this.m_bHasVolume) {
            bMustIncludeZero = this.m_Perspective.getY2MustIncludeZero();
            MinMaxObj y2MinMaxObj = this.findVolumeLimits(bMustIncludeZero);
            this.m_Y2Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y2_AXIS, y2MinMaxObj, bVerticalAxis, !this.m_Perspective.getY2AxisDescending(), 0, split);
        }
        if (this.m_O1Axis != null) {
            this.m_O1Axis.calc();
        }
        if (this.m_Y1Axis != null) {
            this.m_Y1Axis.calc();
        }
        if (this.m_Y2Axis != null) {
            this.m_Y2Axis.calc();
        }
    }

    protected void drawCandleRisers() {
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        IdentObj idRising = new IdentObj(319);
        IdentObj idFalling = new IdentObj(320);
        IdentObj idHighLine = new IdentObj(321);
        IdentObj idLowLine = new IdentObj(322);
        double fHigh = 0.0;
        double fLow = 0.0;
        double fOpen = 0.0;
        double fClose = 0.0;
        double fVolume = 0.0;
        boolean bDescending = this.m_Y1Axis.isDescending();
        boolean bHasHighLow = this.m_df != DataFormat.DF_OC && this.m_df != DataFormat.DF_OC_VOL;
        boolean bNumberFormatCallBackActive = this.m_Perspective.isNumberFormatCallBack();
        String[] dataItemStringArray = new String[4];
        String sDataTextTemplate = "";
        int nDataTextFormat = this.m_Perspective.getDataTextFormat();
        String sDataTextFormatPattern = this.m_Perspective.getDataTextFormatPattern();
        if (!this.m_bHasClose || !this.m_bHasOpen) {
            return;
        }
        if (this.m_bHasVolume) {
            this.m_VolumeDataLabel = new String[this.m_nTotalGroups];
        }
        sDataTextTemplate = this.m_Perspective.getDataTextTemplateHiLo();
        BlackBoxObj blackBoxRising = new BlackBoxObj(this.m_Perspective, idRising);
        BlackBoxObj blackBoxFalling = new BlackBoxObj(this.m_Perspective, idFalling);
        BlackBoxObj blackBoxHighLine = new BlackBoxObj(this.m_Perspective, idHighLine);
        BlackBoxObj blackBoxLowLine = new BlackBoxObj(this.m_Perspective, idLowLine);
        int s = 0;
        gEnum.reset();
        while (gEnum.hasMoreElements()) {
            IdentObj newID;
            int y2;
            int x2;
            int y1;
            int x1;
            double fValue;
            double fMax;
            double fMin;
            int gRel;
            int g;
            block37: {
                g = gEnum.nextGroup();
                PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                gRel = gEnum.getRelativeGroup(g);
                PfjAssert.pfjAssert(gRel >= 0 && gRel < this.m_nGroups);
                this.m_dataOK[s][g] = true;
                try {
                    if (this.m_bHasOpen) {
                        fOpen = this.getOpenValue(s, g);
                    }
                    if (bHasHighLow) {
                        fHigh = this.getHighValue(s, g);
                        fLow = this.getLowValue(s, g);
                        if (fLow > fHigh) {
                            double fTemp = fLow;
                            fLow = fHigh;
                            fHigh = fTemp;
                        }
                    }
                    if (this.m_bHasClose) {
                        fClose = this.getCloseValue(s, g);
                    }
                    if (!this.m_bHasVolume) break block37;
                    fVolume = this.getVolumeValue(s, g);
                }
                catch (AssertionException e) {
                    this.m_dataOK[s][g] = false;
                    continue;
                }
            }
            if (fClose > fOpen) {
                fMin = fOpen;
                fMax = fClose;
            } else {
                fMin = fClose;
                fMax = fOpen;
            }
            double d = fValue = bHasHighLow && fHigh > fMax ? fHigh : fMax;
            if (this.isIgnoredOffScale(this.m_Y1Axis, fValue)) {
                this.m_dataOK[s][g] = false;
                continue;
            }
            fValue = this.m_bHasClose ? fClose : fHigh;
            int bottom = (int)(bDescending ? this.m_Y1Axis.getValueCoord(fMax) : this.m_Y1Axis.getValueCoord(fMin));
            int top = (int)(bDescending ? this.m_Y1Axis.getValueCoord(fMin) : this.m_Y1Axis.getValueCoord(fMax));
            int left = (int)this.m_O1Axis.getLowCoord(0, gRel);
            int right = (int)this.m_O1Axis.getHighCoord(0, gRel);
            int center = (int)this.m_O1Axis.getCenterCoord(gRel);
            Rectangle rVirt = new Rectangle(left, bottom, right - left, top - bottom);
            Rectangle rDest = this.m_Perspective.m_VC.virtToDest(rVirt);
            if (rDest.height < 2) {
                rDest.height = 2;
                rVirt = this.m_Perspective.m_VC.destToVirt(rDest);
            }
            if (bHasHighLow && fHigh > fMax) {
                x1 = center;
                y1 = bDescending ? bottom : top;
                x2 = center;
                y2 = (int)this.m_Y1Axis.getValueCoord(fHigh);
                newID = new IdentObj(idHighLine.getObjectID(), s, g);
                new DetLine(this.m_Detectiv, newID, x1, y1, x2, y2, (BlackBoxIF)blackBoxHighLine, this.m_rClip, this.m_nLineWidthHighWick);
            }
            if (bHasHighLow && fLow < fMin) {
                x1 = center;
                y1 = bDescending ? top : bottom;
                x2 = center;
                y2 = (int)this.m_Y1Axis.getValueCoord(fLow);
                newID = new IdentObj(idLowLine.getObjectID(), s, g);
                new DetLine(this.m_Detectiv, newID, x1, y1, x2, y2, (BlackBoxIF)blackBoxLowLine, this.m_rClip, this.m_nLineWidthLowWick);
            }
            if (fClose >= fOpen) {
                if (this.m_autoGradient && (rDest.height <= 3 || rDest.width <= 3)) {
                    SimpleBlackBoxObj bb = new SimpleBlackBoxObj(this.m_Perspective, idRising, this.m_bWantRiserBorder);
                    new DetRect(this.m_Detectiv, new IdentObj(319, s, g), rVirt, (BlackBoxIF)bb, this.m_rClip);
                } else {
                    new DetRect(this.m_Detectiv, new IdentObj(319, s, g), rVirt, (BlackBoxIF)blackBoxRising, this.m_rClip);
                }
            } else if (this.m_autoGradient && (rDest.height <= 3 || rDest.width <= 3)) {
                SimpleBlackBoxObj bb = new SimpleBlackBoxObj(this.m_Perspective, idFalling, this.m_bWantRiserBorder);
                new DetRect(this.m_Detectiv, new IdentObj(320, s, g), rVirt, (BlackBoxIF)bb, this.m_rClip);
            } else {
                new DetRect(this.m_Detectiv, new IdentObj(320, s, g), rVirt, (BlackBoxIF)blackBoxFalling, this.m_rClip);
            }
            if (this.m_bDataTextDisplay) {
                if (this.m_bHasOpen) {
                    if (bNumberFormatCallBackActive) {
                        this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, "OPEN", -1, -3);
                        dataItemStringArray[0] = this.m_Perspective.getNumberFormatCallBack().toString(fOpen);
                    } else {
                        dataItemStringArray[0] = TDGNumberFormat.toString(this.m_Perspective, nDataTextFormat, fOpen, sDataTextFormatPattern);
                    }
                }
                if (bHasHighLow) {
                    if (bNumberFormatCallBackActive) {
                        this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, "HIGH", -1, -3);
                        dataItemStringArray[1] = this.m_Perspective.getNumberFormatCallBack().toString(fHigh);
                    } else {
                        dataItemStringArray[1] = TDGNumberFormat.toString(this.m_Perspective, nDataTextFormat, fHigh, sDataTextFormatPattern);
                    }
                    if (bNumberFormatCallBackActive) {
                        this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, "LOW", -1, -3);
                        dataItemStringArray[2] = this.m_Perspective.getNumberFormatCallBack().toString(fLow);
                    } else {
                        dataItemStringArray[2] = TDGNumberFormat.toString(this.m_Perspective, nDataTextFormat, fLow, sDataTextFormatPattern);
                    }
                }
                if (this.m_bHasClose) {
                    if (bNumberFormatCallBackActive) {
                        this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, "CLOSE", -1, -3);
                        dataItemStringArray[3] = this.m_Perspective.getNumberFormatCallBack().toString(fClose);
                    } else {
                        dataItemStringArray[3] = TDGNumberFormat.toString(this.m_Perspective, nDataTextFormat, fClose, sDataTextFormatPattern);
                    }
                }
                if (sDataTextTemplate == null || sDataTextTemplate.length() < 1) {
                    sDataTextTemplate = this.m_bHasClose ? "[CLOSE]" : "[HIGH]";
                }
                this.m_DataLabel[s][g] = this.processDataTextTemplate(dataItemStringArray, sDataTextTemplate);
                if (this.m_bHasVolume) {
                    if (bNumberFormatCallBackActive) {
                        this.m_Perspective.getNumberFormatCallBack().setState(5, s, g, "VOLUME", -1, -3);
                        this.m_VolumeDataLabel[g] = this.m_Perspective.getNumberFormatCallBack().toString(fVolume);
                    } else {
                        this.m_VolumeDataLabel[g] = TDGNumberFormat.toString(this.m_Perspective, this.m_Perspective.getDataTextFormat(), fVolume, this.m_Perspective.getDataTextFormatPattern());
                    }
                }
            }
            if (!this.m_bHasVolume) continue;
            this.calcVolumeBar(g, fVolume);
        }
    }

    protected void drawRisersAndTicks() {
        int s;
        SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator gEnum = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        IdentObj idCloseTick = new IdentObj(307);
        IdentObj idOpenTick = new IdentObj(308);
        double fOpen = 0.0;
        double fClose = 0.0;
        double fVolume = 0.0;
        int tickLen = this.m_Perspective.getStockTickLength();
        boolean bNumberFormatCallBackActive = this.m_Perspective.isNumberFormatCallBack();
        String[] dataItemStringArray = new String[4];
        String sDataTextTemplate = "";
        int nDataTextFormat = this.m_Perspective.getDataTextFormat();
        String sDataTextFormatPattern = this.m_Perspective.getDataTextFormatPattern();
        boolean bNotifyHighLessThanLowEvent = false;
        boolean bNotifyOpenCloseNotInRangeEvent = false;
        if (this.m_bHasVolume) {
            this.m_VolumeDataLabel = new String[this.m_nTotalGroups];
        }
        sDataTextTemplate = this.m_Perspective.getDataTextTemplateHiLo();
        BlackBoxObj blackBoxCloseTick = new BlackBoxObj(this.m_Perspective, idCloseTick);
        BlackBoxObj blackBoxOpenTick = new BlackBoxObj(this.m_Perspective, idOpenTick);
        while (sEnum.hasMoreElements() && (s = sEnum.nextSeries()) < this.m_nTotalSeries) {
            IdentObj id = new IdentObj(-3, s);
            RelativeAxisObj yAxisObj = this.getAxisAssignment(s) == 1 ? this.m_Y2Axis : this.m_Y1Axis;
            boolean bDescending = yAxisObj.isDescending();
            gEnum.reset();
            while (gEnum.hasMoreElements()) {
                IdentObj newID;
                int center;
                double fLow;
                double fHigh;
                boolean nullOpen;
                boolean nullClose;
                BlackBoxIF blackBox;
                int gRel;
                int g;
                block46: {
                    g = gEnum.nextGroup();
                    PfjAssert.pfjAssert(g >= 0 && g < this.m_nTotalGroups);
                    gRel = gEnum.getRelativeGroup(g);
                    PfjAssert.pfjAssert(gRel >= 0 && gRel < this.m_nGroups);
                    this.m_dataOK[s][g] = true;
                    blackBox = this.assignSeriesColor(s, g);
                    blackBox.setTransparentBorderColor(false);
                    if (blackBox.getFillColor() != null) {
                        blackBox.setBorderColor(blackBox.getFillColor());
                    }
                    if (this.m_Perspective.getTransparentFillColor(id)) {
                        blackBox.setTransparentBorderColor(true);
                    }
                    nullClose = false;
                    nullOpen = false;
                    try {
                        boolean bCloseOutOfRange;
                        boolean bOpenOutOfRange;
                        TDGEventManager evtMgr;
                        if (this.m_bHasOpen) {
                            try {
                                fOpen = this.getOpenValue(s, g);
                            }
                            catch (AssertionException aex) {
                                nullOpen = true;
                            }
                        }
                        fHigh = this.getHighValue(s, g);
                        fLow = this.getLowValue(s, g);
                        if (fLow > fHigh) {
                            double fTemp = fLow;
                            fLow = fHigh;
                            fHigh = fTemp;
                            if (!bNotifyHighLessThanLowEvent) {
                                evtMgr = this.m_Perspective.getEventManager();
                                evtMgr.notifyPerspectiveListener((Object)this.m_Perspective, 3980, null);
                                bNotifyHighLessThanLowEvent = true;
                            }
                        }
                        if (this.m_bHasClose) {
                            try {
                                fClose = this.getCloseValue(s, g);
                            }
                            catch (AssertionException ae) {
                                nullClose = true;
                            }
                        }
                        if (this.m_bHasVolume) {
                            fVolume = this.getVolumeValue(s, g);
                        }
                        if (!this.m_bHasOpen || !this.m_bHasClose || bNotifyOpenCloseNotInRangeEvent) break block46;
                        if (nullOpen) {
                            bOpenOutOfRange = false;
                        } else {
                            boolean bl = bOpenOutOfRange = fOpen > fHigh || fOpen < fLow;
                        }
                        if (nullClose) {
                            bCloseOutOfRange = false;
                        } else {
                            boolean bl = bCloseOutOfRange = fClose > fHigh || fClose < fLow;
                        }
                        if (!bOpenOutOfRange && !bCloseOutOfRange) break block46;
                        bNotifyOpenCloseNotInRangeEvent = true;
                        evtMgr = this.m_Perspective.getEventManager();
                        evtMgr.notifyPerspectiveListener((Object)this.m_Perspective, 3984, null);
                    }
                    catch (AssertionException e) {
                        this.m_dataOK[s][g] = false;
                        continue;
                    }
                }
                if (this.isIgnoredOffScale(this.m_Y1Axis, fHigh)) {
                    this.m_dataOK[s][g] = false;
                    continue;
                }
                int bottom = (int)(bDescending ? yAxisObj.getValueCoord(fHigh) : yAxisObj.getValueCoord(fLow));
                int top = (int)(bDescending ? yAxisObj.getValueCoord(fLow) : yAxisObj.getValueCoord(fHigh));
                int x1 = center = (int)this.m_O1Axis.getCenterCoord(gRel);
                int x2 = center;
                int y1 = bottom;
                int y2 = top;
                if (top == bottom) {
                    Rectangle rect = new Rectangle(x1 - this.m_Perspective.getVC().destToVirtWidth(2), y1, this.m_Perspective.getVC().destToVirtWidth(3), this.m_Perspective.getVC().destToVirtHeight(3));
                    new DetRect(this.m_Detectiv, new IdentObj(303, s, g), rect, blackBox, null, 2);
                } else {
                    new DetLine(this.m_Detectiv, new IdentObj(303, s, g), x1, y1, x2, y2, blackBox, this.m_rClip, 3);
                }
                if (this.m_bHasClose && !nullClose) {
                    int closeCoord = (int)yAxisObj.getValueCoord(fClose);
                    if (this.m_bCloseSplitDisplay) {
                        if (bDescending) {
                            bottom = closeCoord;
                        } else {
                            top = closeCoord;
                        }
                        int left = (int)this.m_O1Axis.getLowCoord(0, gRel);
                        int right = (int)this.m_O1Axis.getHighCoord(0, gRel);
                        Rectangle rVirt = new Rectangle(left, bottom, right - left, top - bottom);
                        IdentObj idLower = new IdentObj(306, s, g, -3, 1);
                        BlackBoxObj blackBoxLower = new BlackBoxObj(this.m_Perspective, idLower);
                        new DetRect(this.m_Detectiv, idLower, rVirt, (BlackBoxIF)blackBoxLower, this.m_rClip);
                    }
                    if (this.m_bCloseTicksDisplay) {
                        x1 = center;
                        y1 = closeCoord;
                        x2 = center + this.m_Perspective.getVC().destToVirtWidth(6);
                        y2 = y1;
                        newID = new IdentObj(idCloseTick.getObjectID(), s, g);
                        new DetLine(this.m_Detectiv, newID, x1, y1, x2, y2, blackBox, this.m_rClip, 3);
                    }
                }
                if (this.m_bHasOpen && this.m_bOpenTicksDisplay && !nullOpen) {
                    x1 = center - this.m_Perspective.getVC().destToVirtWidth(5);
                    y1 = (int)yAxisObj.getValueCoord(fOpen);
                    x2 = center;
                    y2 = y1;
                    newID = new IdentObj(idOpenTick.getObjectID(), s, g);
                    new DetLine(this.m_Detectiv, newID, x1, y1, x2, y2, blackBox, this.m_rClip, 3);
                }
                if (this.m_bDataTextDisplay) {
                    if (this.m_bHasOpen && !nullOpen) {
                        if (bNumberFormatCallBackActive) {
                            this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, "OPEN", -1, -3);
                            dataItemStringArray[0] = this.m_Perspective.getNumberFormatCallBack().toString(fOpen);
                        } else {
                            dataItemStringArray[0] = TDGNumberFormat.toString(this.m_Perspective, nDataTextFormat, fOpen, sDataTextFormatPattern);
                        }
                    }
                    if (bNumberFormatCallBackActive) {
                        this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, "HIGH", -1, -3);
                        dataItemStringArray[1] = this.m_Perspective.getNumberFormatCallBack().toString(fHigh);
                    } else {
                        dataItemStringArray[1] = TDGNumberFormat.toString(this.m_Perspective, nDataTextFormat, fHigh, sDataTextFormatPattern);
                    }
                    if (bNumberFormatCallBackActive) {
                        this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, "LOW", -1, -3);
                        dataItemStringArray[2] = this.m_Perspective.getNumberFormatCallBack().toString(fLow);
                    } else {
                        dataItemStringArray[2] = TDGNumberFormat.toString(this.m_Perspective, nDataTextFormat, fLow, sDataTextFormatPattern);
                    }
                    if (this.m_bHasClose && !nullClose) {
                        if (bNumberFormatCallBackActive) {
                            this.m_Perspective.getNumberFormatCallBack().setState(3, s, g, "CLOSE", -1, -3);
                            dataItemStringArray[3] = this.m_Perspective.getNumberFormatCallBack().toString(fClose);
                        } else {
                            dataItemStringArray[3] = TDGNumberFormat.toString(this.m_Perspective, nDataTextFormat, fClose, sDataTextFormatPattern);
                        }
                    }
                    if (nullClose) {
                        this.m_DataLabel[s][g] = null;
                    } else {
                        if (sDataTextTemplate == null || sDataTextTemplate.length() < 1) {
                            sDataTextTemplate = this.m_bHasClose ? "[CLOSE]" : "[HIGH]";
                        }
                        this.m_DataLabel[s][g] = this.processDataTextTemplate(dataItemStringArray, sDataTextTemplate);
                    }
                    if (this.m_bHasVolume) {
                        if (bNumberFormatCallBackActive) {
                            this.m_Perspective.getNumberFormatCallBack().setState(5, s, g, "VOLUME", -1, -3);
                            this.m_VolumeDataLabel[g] = this.m_Perspective.getNumberFormatCallBack().toString(fVolume);
                        } else {
                            this.m_VolumeDataLabel[g] = TDGNumberFormat.toString(this.m_Perspective, this.m_Perspective.getDataTextFormat(), fVolume, this.m_Perspective.getDataTextFormatPattern());
                        }
                    }
                }
                if (!this.m_bHasVolume) continue;
                this.calcVolumeBar(g, fVolume);
            }
        }
    }

    @Override
    protected String processDataTextTemplate(String[] dataItems, String dataTextTemplate) {
        String ResultString = dataTextTemplate;
        ResultString = this.ReplaceMacro(ResultString, "[OPEN]", dataItems[0]);
        ResultString = this.ReplaceMacro(ResultString, "[HIGH]", dataItems[1]);
        ResultString = this.ReplaceMacro(ResultString, "[LOW]", dataItems[2]);
        ResultString = this.ReplaceMacro(ResultString, "[CLOSE]", dataItems[3]);
        return ResultString;
    }

    protected MinMaxObj findLimits(int axis, boolean bMustIncludeZero) {
        int scaling = this.m_gt.getScalingMethod();
        MinMaxObj minMaxObj = this.findPreScaledLimits(axis, scaling, bMustIncludeZero);
        if (minMaxObj != null) {
            return minMaxObj;
        }
        minMaxObj = new MinMaxObj(bMustIncludeZero);
        DataFormat df = this.m_Access.getDataFormat();
        int nItems = df.getNumDataItems();
        if (scaling == 1) {
            if (this.m_Perspective.getStock52WeekHighDisplay() && !this.m_gt.isBipolar()) {
                double f52High = this.m_Perspective.getStock52WeekHighValue();
                minMaxObj.testRawValue(f52High);
            }
            if (this.m_Perspective.getStock52WeekLowDisplay() && !this.m_gt.isBipolar()) {
                double f52Low = this.m_Perspective.getStock52WeekLowValue();
                minMaxObj.testRawValue(f52Low);
            }
            for (int s = 0; s < this.m_nTotalSeries; ++s) {
                if ((axis == 0 || axis == 1) && this.getAxisAssignment(s) != axis) continue;
                if (axis == 1) {
                    this.m_dualY = true;
                }
                for (int g = 0; g < this.m_nTotalGroups; ++g) {
                    for (int i = 0; i < nItems; ++i) {
                        DataItem item = df.getDataItem(i);
                        if (item.ignoreInScaling() || !AxisTemplate.isSameType(item.getAssocAxis(), axis)) continue;
                        DatumObj dObj = this.getDataValue(s, g, item);
                        double fValue = dObj.m_fValue;
                        if (fValue == 0.0 && !dObj.m_bOK) {
                            if (axis == 0) {
                                this.m_nullValY1 = true;
                            } else if (axis == 1) {
                                this.m_nullValY2 = true;
                            }
                        }
                        if (fValue <= 0.0 && this.isBadValueInLogscale(axis, fValue)) {
                            if (axis == 0) {
                                if (fValue == 0.0 && dObj.m_bOK) {
                                    this.m_zeroValY1 = true;
                                } else if (fValue == 0.0 && !dObj.m_bOK) {
                                    this.m_nullValY1 = true;
                                } else {
                                    this.m_negativeValY1 = true;
                                }
                            } else if (axis == 1) {
                                if (fValue == 0.0 && dObj.m_bOK) {
                                    this.m_zeroValY2 = true;
                                } else if (fValue == 0.0 && !dObj.m_bOK) {
                                    this.m_nullValY2 = true;
                                } else {
                                    this.m_negativeValY2 = true;
                                }
                            }
                        } else if (axis == 0) {
                            this.m_positiveValY1 = true;
                        } else if (axis == 1) {
                            this.m_positiveValY2 = true;
                        }
                        if (!dObj.m_bOK) continue;
                        minMaxObj.testRawValue(fValue);
                    }
                }
            }
        } else {
            throw new AssertionException("This chart type only works with Absolute scaling!");
        }
        return minMaxObj;
    }

    protected MinMaxObj findVolumeLimits(boolean bMustIncludeZero) {
        MinMaxObj minMaxObj = new MinMaxObj(bMustIncludeZero);
        int scaling = this.m_gt.getScalingMethod();
        if (scaling == 1) {
            SeriesEnumerator sEnum = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
            int s = sEnum.getFirstSeries();
            PfjAssert.pfjAssert(s >= 0 && s < this.m_nTotalSeries);
            for (int g = 0; g < this.m_nTotalGroups; ++g) {
                double fValue;
                try {
                    fValue = this.getVolumeValue(s, g);
                }
                catch (AssertionException e) {
                    continue;
                }
                minMaxObj.testRawValue(fValue);
            }
        } else {
            throw new AssertionException("This chart type only works with Absolute scaling!");
        }
        return minMaxObj;
    }

    private DataItem getCloseItem() {
        DataItem item;
        if (this.m_df == DataFormat.DF_HLC) {
            item = DataItem.DI_HLC_C;
        } else if (this.m_df == DataFormat.DF_HLC_VOL) {
            item = DataItem.DI_HLC_VOL_C;
        } else if (this.m_df == DataFormat.DF_OHLC) {
            item = DataItem.DI_OHLC_C;
        } else if (this.m_df == DataFormat.DF_OHLC_VOL) {
            item = DataItem.DI_OHLC_VOL_C;
        } else if (this.m_df == DataFormat.DF_OC) {
            item = DataItem.DI_OC_C;
        } else if (this.m_df == DataFormat.DF_OC_VOL) {
            item = DataItem.DI_OC_VOL_C;
        } else {
            throw new AssertionException("getCloseItem used with wrong dataFormat: " + this.m_df.toString());
        }
        return item;
    }

    public double getCloseValue(int s, int g) throws AssertionException {
        DataItem item = this.getCloseItem();
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    @Override
    protected Point getCoords(int s, int g) {
        int nNumCoord;
        RelativeAxisObj yAxisObj = this.getAxisAssignment(s) == 1 ? this.m_Y2Axis : this.m_Y1Axis;
        boolean bHasHighLow = this.m_df != DataFormat.DF_OC && this.m_df != DataFormat.DF_OC_VOL;
        int gRel = this.m_gEnumReadOnly.getRelativeGroup(g);
        PfjAssert.pfjAssert(gRel >= 0 && gRel < this.m_nGroups);
        int nOrdCoord = (int)this.m_O1Axis.getCenterCoord(gRel);
        try {
            if (bHasHighLow) {
                nNumCoord = (int)yAxisObj.getValueCoord(this.getHighValue(s, g));
            } else {
                double fClose = this.getCloseValue(s, g);
                double fOpen = this.getOpenValue(s, g);
                nNumCoord = (int)yAxisObj.getValueCoord(Math.max(fClose, fOpen));
            }
        }
        catch (Exception e) {
            nNumCoord = 0;
        }
        Point center = this.m_bHorz ? new Point(nNumCoord, nOrdCoord) : new Point(nOrdCoord, nNumCoord);
        return center;
    }

    protected Point getBottomCoords(int s, int g) {
        int nNumCoord;
        RelativeAxisObj yAxisObj = this.getAxisAssignment(s) == 1 ? this.m_Y2Axis : this.m_Y1Axis;
        boolean bHasHighLow = this.m_df != DataFormat.DF_OC && this.m_df != DataFormat.DF_OC_VOL;
        int gRel = this.m_gEnumReadOnly.getRelativeGroup(g);
        PfjAssert.pfjAssert(gRel >= 0 && gRel < this.m_nGroups);
        int nOrdCoord = (int)this.m_O1Axis.getCenterCoord(gRel);
        try {
            if (bHasHighLow) {
                nNumCoord = (int)yAxisObj.getValueCoord(this.getLowValue(s, g));
            } else {
                double fClose = this.getCloseValue(s, g);
                double fOpen = this.getOpenValue(s, g);
                nNumCoord = (int)yAxisObj.getValueCoord(Math.min(fClose, fOpen));
            }
        }
        catch (Exception e) {
            nNumCoord = 0;
        }
        Point center = this.m_bHorz ? new Point(nNumCoord, nOrdCoord) : new Point(nOrdCoord, nNumCoord);
        return center;
    }

    private DataItem getHighItem() {
        DataItem item;
        if (this.m_df == DataFormat.DF_HL) {
            item = DataItem.DI_HL_H;
        } else if (this.m_df == DataFormat.DF_HL_VOL) {
            item = DataItem.DI_HL_VOL_H;
        } else if (this.m_df == DataFormat.DF_HLC) {
            item = DataItem.DI_HLC_H;
        } else if (this.m_df == DataFormat.DF_HLC_VOL) {
            item = DataItem.DI_HLC_VOL_H;
        } else if (this.m_df == DataFormat.DF_OHLC) {
            item = this.m_bInterpretAsHLOC ? DataItem.DI_HLOC_H : DataItem.DI_OHLC_H;
        } else if (this.m_df == DataFormat.DF_OHLC_VOL) {
            item = DataItem.DI_OHLC_VOL_H;
        } else {
            throw new AssertionException("getHighItem used with wrong dataFormat: " + this.m_df.toString());
        }
        return item;
    }

    public double getHighValue(int s, int g) throws AssertionException {
        DataItem item = this.getHighItem();
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    private DataItem getLowItem() {
        DataItem item;
        if (this.m_df == DataFormat.DF_HL) {
            item = DataItem.DI_HL_L;
        } else if (this.m_df == DataFormat.DF_HL_VOL) {
            item = DataItem.DI_HL_VOL_L;
        } else if (this.m_df == DataFormat.DF_HLC) {
            item = DataItem.DI_HLC_L;
        } else if (this.m_df == DataFormat.DF_HLC_VOL) {
            item = DataItem.DI_HLC_VOL_L;
        } else if (this.m_df == DataFormat.DF_OHLC) {
            item = this.m_bInterpretAsHLOC ? DataItem.DI_HLOC_L : DataItem.DI_OHLC_L;
        } else if (this.m_df == DataFormat.DF_OHLC_VOL) {
            item = DataItem.DI_OHLC_VOL_L;
        } else {
            throw new AssertionException("getLowItem used with wrong dataFormat: " + this.m_df.toString());
        }
        return item;
    }

    public double getLowValue(int s, int g) throws AssertionException {
        DataItem item = this.getLowItem();
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    private DataItem getOpenItem() {
        DataItem item;
        if (this.m_df == DataFormat.DF_OHLC) {
            item = this.m_bInterpretAsHLOC ? DataItem.DI_HLOC_O : DataItem.DI_OHLC_O;
        } else if (this.m_df == DataFormat.DF_OHLC_VOL) {
            item = DataItem.DI_OHLC_VOL_O;
        } else if (this.m_df == DataFormat.DF_OC) {
            item = DataItem.DI_OC_O;
        } else if (this.m_df == DataFormat.DF_OC_VOL) {
            item = DataItem.DI_OC_VOL_O;
        } else {
            throw new AssertionException("getOpenItem used with wrong dataFormat: " + this.m_df.toString());
        }
        return item;
    }

    public double getOpenValue(int s, int g) throws AssertionException {
        DataItem item = this.getOpenItem();
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    private DataItem getVolumeItem() {
        DataItem item;
        if (this.m_df == DataFormat.DF_HL_VOL) {
            item = DataItem.DI_HL_VOL_VOL;
        } else if (this.m_df == DataFormat.DF_HLC_VOL) {
            item = DataItem.DI_HLC_VOL_VOL;
        } else if (this.m_df == DataFormat.DF_OHLC_VOL) {
            item = DataItem.DI_OHLC_VOL_VOL;
        } else if (this.m_df == DataFormat.DF_OC_VOL) {
            item = DataItem.DI_OC_VOL_VOL;
        } else {
            throw new AssertionException("getVolumeItem used with wrong dataFormat: " + this.m_df.toString());
        }
        return item;
    }

    public double getVolumeValue(int s, int g) throws AssertionException {
        DataItem item = this.getVolumeItem();
        DatumObj dObj = this.getDataValue(s, g, item);
        if (dObj.m_bOK) {
            return dObj.m_fValue;
        }
        throw new AssertionException();
    }

    @Override
    public boolean isSingleSeriesOnly() {
        boolean bSingleSeries = false;
        if (this.m_gt.isStockCandleType()) {
            bSingleSeries = true;
        }
        if (this.m_bHasVolume) {
            bSingleSeries = true;
        }
        return bSingleSeries;
    }

    @Override
    public boolean wantLegend() {
        boolean bWantLegend = true;
        if (this.m_gt.isStockCandleType() && this.m_Perspective.getReferenceObjectCount() == 0) {
            bWantLegend = false;
        }
        return bWantLegend;
    }

    public boolean hasHighValue(DataFormat theDataFormat) {
        boolean bHasHighValue = theDataFormat == DataFormat.DF_HL || theDataFormat == DataFormat.DF_HLC || theDataFormat == DataFormat.DF_OHLC || theDataFormat == DataFormat.DF_HL_VOL || theDataFormat == DataFormat.DF_HLC_VOL || theDataFormat == DataFormat.DF_OHLC_VOL;
        return bHasHighValue;
    }

    public boolean hasLowValue(DataFormat theDataFormat) {
        boolean bHasLowValue = theDataFormat == DataFormat.DF_HL || theDataFormat == DataFormat.DF_HLC || theDataFormat == DataFormat.DF_OHLC || theDataFormat == DataFormat.DF_HL_VOL || theDataFormat == DataFormat.DF_HLC_VOL || theDataFormat == DataFormat.DF_OHLC_VOL;
        return bHasLowValue;
    }

    public boolean hasOpenValue(DataFormat theDataFormat) {
        boolean bHasOpenValue = theDataFormat == DataFormat.DF_OHLC || theDataFormat == DataFormat.DF_OHLC_VOL || theDataFormat == DataFormat.DF_OC || theDataFormat == DataFormat.DF_OC_VOL;
        return bHasOpenValue;
    }

    public boolean hasCloseValue(DataFormat theDataFormat) {
        boolean bHasCloseValue = theDataFormat == DataFormat.DF_HLC || theDataFormat == DataFormat.DF_OHLC || theDataFormat == DataFormat.DF_HLC_VOL || theDataFormat == DataFormat.DF_OHLC_VOL || theDataFormat == DataFormat.DF_OC || theDataFormat == DataFormat.DF_OC_VOL;
        return bHasCloseValue;
    }

    public boolean hasVolumeValue(DataFormat theDataFormat) {
        boolean bHasVolumeValue = theDataFormat == DataFormat.DF_HL_VOL || theDataFormat == DataFormat.DF_HLC_VOL || theDataFormat == DataFormat.DF_OHLC_VOL || theDataFormat == DataFormat.DF_OC_VOL;
        return bHasVolumeValue;
    }
}

