/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;
import oracle.dss.graph.pfj.Axis2DObj;
import oracle.dss.graph.pfj.AxisDescriptor;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetOval;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.IdentObj;

public class DataScroller
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int SCROLLER_THICKNESS = 12;
    public static final int SCROLLER_THICKNESS_HORZ = 12;
    public static final int EDITBOX_PIXELS = 60;
    public static final int PRESENCE_NEVER = 0;
    public static final int PRESENCE_SOMETIMES = 1;
    public static final int PRESENCE_ALWAYS = 2;
    public static final int PRESENCE_RESERVED = 3;
    protected Perspective m_Perspective;
    protected Rectangle m_rFrame;
    protected Rectangle m_rScroller;
    protected Rectangle m_rEditBox;
    protected boolean m_bVert;
    protected boolean m_bGroups;
    protected int m_nTotal;
    protected int m_nViewable;
    protected int m_nOffset;
    protected int m_axisID;
    private static final Color ZOOM_BUTTON_BORDER_COLOR = new Color(132, 130, 132);
    private static final Color ZOOM_BUTTON_FILL_COLOR = new Color(234, 234, 234);
    private static final Color SCROLLER_BORDER_COLOR = new Color(132, 169, 252);
    private static final Color SCROLLER_FILL_COLOR = new Color(250, 250, 255);
    public static final Color SCROLL_THUMB_FILL_COLOR = new Color(210, 234, 255);
    public static final Color SCROLL_THUMB_BORDER_COLOR = new Color(140, 164, 255);
    public static final Color SCROLL_ARROW_FILL_COLOR = SCROLL_THUMB_FILL_COLOR;
    public static final Color SCROLL_ARROW_BORDER_COLOR = SCROLL_THUMB_BORDER_COLOR;
    public static final Color SCROLL_ICONS_FILL_COLOR = SCROLLER_FILL_COLOR;
    public static final Color SCROLL_ICONS_BORDER_COLOR = SCROLLER_BORDER_COLOR;

    public DataScroller(Perspective perspective, Rectangle rFrame, boolean bVert, boolean bGroups) {
        this.m_Perspective = perspective;
        this.m_rFrame = rFrame;
        this.m_bVert = bVert;
        this.m_bGroups = bGroups;
        if (bGroups) {
            this.m_nTotal = this.m_Perspective.getNumTotalGroups();
            this.m_nViewable = this.m_Perspective.getNumGroups();
            this.m_nOffset = this.m_Perspective.getEffectiveGroupOffset();
        } else {
            this.m_nTotal = this.m_Perspective.getNumTotalSeries();
            this.m_nViewable = this.m_Perspective.getNumSeries();
            this.m_nOffset = this.m_Perspective.getEffectiveSeriesOffset();
        }
    }

    public DataScroller(Perspective perspective, Rectangle rFrame, boolean bVert, boolean bGroups, int axisID) {
        this(perspective, rFrame, bVert, bGroups);
        this.m_axisID = axisID;
        if (!(bGroups || this.m_axisID != 2004 && this.m_axisID != 2005 && this.m_axisID != 2003)) {
            Axis2DObj axisObj = null;
            double autoMinVal = 0.0;
            double autoMaxVal = 0.0;
            boolean bAutoMin = false;
            boolean bAutoMax = false;
            bAutoMin = perspective.getY1ScaleMinAuto();
            bAutoMax = perspective.getY1ScaleMaxAuto();
            autoMinVal = perspective.getY1ScaleMinAutoValue();
            autoMaxVal = perspective.getY1ScaleMaxAutoValue();
            if (perspective.getGraphObject() instanceof JChart_2D_Standard) {
                Double scaleZoomMin = null;
                Double scaleZoomMax = null;
                if (this.m_axisID == 2004) {
                    axisObj = (Axis2DObj)((JChart_2D_Standard)perspective.getGraphObject()).m_Y1Axis;
                    scaleZoomMin = this.m_Perspective.getY1ScaleZoomMin();
                    scaleZoomMax = this.m_Perspective.getY1ScaleZoomMax();
                } else if (this.m_axisID == 2005) {
                    axisObj = (Axis2DObj)((JChart_2D_Standard)perspective.getGraphObject()).m_Y2Axis;
                    scaleZoomMin = this.m_Perspective.getY2ScaleZoomMin();
                    scaleZoomMax = this.m_Perspective.getY2ScaleZoomMax();
                } else if (this.m_axisID == 2003) {
                    axisObj = perspective.isContinuousTimeAxis() ? (Axis2DObj)((JChart_2D_Standard)perspective.getGraphObject()).m_O1Axis : (Axis2DObj)((JChart_2D_Standard)perspective.getGraphObject()).m_X1Axis;
                    scaleZoomMin = this.m_Perspective.getX1ScaleZoomMin();
                    scaleZoomMax = this.m_Perspective.getX1ScaleZoomMax();
                } else {
                    return;
                }
                if (axisObj == null) {
                    this.m_nTotal = 0;
                    this.m_nViewable = 0;
                    this.m_nOffset = 0;
                    return;
                }
                if (axisObj.getAutoMinMaxArray() != null) {
                    autoMinVal = axisObj.getAutoMinMaxArray()[0];
                    autoMaxVal = axisObj.getAutoMinMaxArray()[1];
                }
                if (scaleZoomMin != null) {
                    autoMinVal = scaleZoomMin;
                }
                if (scaleZoomMax != null) {
                    autoMaxVal = scaleZoomMax;
                }
                double autoMin = axisObj.getValueCoordForZoom(autoMinVal);
                double autoMax = axisObj.getValueCoordForZoom(autoMaxVal);
                double min = axisObj.getMinCoord();
                double max = axisObj.getMaxCoord();
                if (axisObj.getAutoMinMaxArray() == null) {
                    if (scaleZoomMin == null) {
                        autoMin = min;
                    }
                    if (scaleZoomMax == null) {
                        autoMax = max;
                    }
                }
                if (!this.m_bVert) {
                    this.m_nTotal = Math.abs(this.m_Perspective.getVC().virtToDestWidth((int)(autoMax - autoMin)));
                    this.m_nViewable = Math.abs(this.m_Perspective.getVC().virtToDestWidth((int)(max - min)));
                    this.m_nOffset = Math.abs(this.m_Perspective.getVC().virtToDestWidth((int)(min - autoMin)));
                } else {
                    this.m_nTotal = Math.abs(this.m_Perspective.getVC().virtToDestHeight((int)(autoMax - autoMin)));
                    this.m_nViewable = Math.abs(this.m_Perspective.getVC().virtToDestHeight((int)(max - min)));
                    this.m_nOffset = Math.abs(this.m_Perspective.getVC().virtToDestHeight((int)(min - autoMin)));
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void calc() {
        Rectangle rScroller;
        int thirdScrollIconHeight;
        int thirdScrollIconWidth;
        int quarterScrollIconHeight;
        int quarterScrollIconWidth;
        int nWidth;
        int nHeight;
        boolean bHasY2;
        boolean bAxisLeft = false;
        boolean bAxisRight = false;
        IdentObj idScroller = null;
        IdentObj idThumb = null;
        IdentObj idZoomIn = null;
        IdentObj idZoomOut = null;
        IdentObj idScrollIconF = null;
        IdentObj idScrollIconS = null;
        IdentObj idArrowF = null;
        IdentObj idArrowS = null;
        Rectangle rThumb = null;
        Object rZoomIn = null;
        Object rZoomOut = null;
        Rectangle rScrollIconF = null;
        Rectangle rScrollIconS = null;
        Rectangle rZoomInIcon = null;
        Rectangle rZoomOutIcon = null;
        Polygon pArrowF = null;
        Polygon pArrowS = null;
        Point ptZoomInVertF = null;
        Point ptZoomInVertS = null;
        Point ptZoomOutF = null;
        Point ptZoomOutS = null;
        Point ptZoomInHorzF = null;
        Point ptZoomInHorzS = null;
        if (this.m_rFrame == null) {
            return;
        }
        int nReduFactor = 0;
        int o1AxisSide = this.m_Perspective.getO1AxisSide();
        boolean bO1AxisLeft = o1AxisSide == 0 || o1AxisSide == 2;
        boolean bO1AxisRight = o1AxisSide == 1;
        int x1AxisSide = this.m_Perspective.getX1AxisSide();
        boolean bX1AxisLeft = x1AxisSide == 0 || x1AxisSide == 2;
        boolean bX1AxisRight = x1AxisSide == 1;
        int y1AxisSide = this.m_Perspective.getY1AxisSide();
        boolean bY1AxisLeft = y1AxisSide == 0 || y1AxisSide == 2;
        boolean bY1AxisRight = y1AxisSide == 1;
        int y2AxisSide = this.m_Perspective.getY2AxisSide();
        boolean bY2AxisLeft = y2AxisSide == 0 || y2AxisSide == 2;
        boolean bY2AxisRight = y2AxisSide == 1;
        JGraphType gt = this.m_Perspective.getJGraphType();
        AxisDescriptor ad = gt.getAxisDescriptor();
        boolean bHasO1 = ad.hasO1() && (this.m_Perspective.isGroupScrollerPresent() || this.m_Perspective.getDataScrollerPresenceGroups() == 3);
        boolean bHasX1 = ad.hasX1() && (this.m_Perspective.isDataAxisScrollerPresent(2003) || this.m_Perspective.getDataScrollerPresenceX1() == 3);
        boolean bHasY1 = ad.hasY1() && (this.m_Perspective.isDataAxisScrollerPresent(2004) || this.m_Perspective.getDataScrollerPresenceY1() == 3);
        boolean bl = bHasY2 = ad.hasY2() && (this.m_Perspective.isDataAxisScrollerPresent(2005) || this.m_Perspective.getDataScrollerPresenceY2() == 3);
        if (bHasY1 && bHasY2) {
            if (bY1AxisLeft) {
                bY2AxisLeft = false;
                bY2AxisRight = true;
            } else if (bY1AxisRight) {
                bY2AxisLeft = true;
                bY2AxisRight = false;
            }
        }
        switch (this.m_axisID) {
            case 2001: {
                idZoomIn = new IdentObj(3007);
                idZoomOut = new IdentObj(3008);
                idScrollIconF = new IdentObj(3009);
                idScrollIconS = new IdentObj(3010);
                idScroller = new IdentObj(3011);
                idThumb = new IdentObj(3012);
                int axisSide = o1AxisSide;
                bAxisLeft = bO1AxisLeft;
                bAxisRight = bO1AxisRight;
                break;
            }
            case 2003: {
                idZoomIn = new IdentObj(3013);
                idZoomOut = new IdentObj(3014);
                idScrollIconF = new IdentObj(3015);
                idScrollIconS = new IdentObj(3016);
                idScroller = new IdentObj(3017);
                idThumb = new IdentObj(3018);
                int axisSide = x1AxisSide;
                bAxisLeft = bX1AxisLeft;
                bAxisRight = bX1AxisRight;
                break;
            }
            case 2004: {
                idZoomIn = new IdentObj(3001);
                idZoomOut = new IdentObj(3002);
                idScrollIconF = new IdentObj(3003);
                idScrollIconS = new IdentObj(3004);
                idScroller = new IdentObj(3005);
                idThumb = new IdentObj(3006);
                int axisSide = y1AxisSide;
                bAxisLeft = bY1AxisLeft;
                bAxisRight = bY1AxisRight;
                break;
            }
            case 2005: {
                idZoomIn = new IdentObj(3019);
                idZoomOut = new IdentObj(3020);
                idScrollIconF = new IdentObj(3021);
                idScrollIconS = new IdentObj(3022);
                idScroller = new IdentObj(3023);
                idThumb = new IdentObj(3024);
                int axisSide = y2AxisSide;
                bAxisLeft = bY2AxisLeft;
                bAxisRight = bY2AxisRight;
            }
        }
        idArrowF = new IdentObj(3025);
        idArrowS = new IdentObj(3025);
        BlackBoxObj bbZoomIn = new BlackBoxObj(this.m_Perspective, idZoomIn);
        bbZoomIn.setBorderColor(ZOOM_BUTTON_BORDER_COLOR);
        bbZoomIn.setFillColor(ZOOM_BUTTON_FILL_COLOR);
        BlackBoxObj bbZoomOut = new BlackBoxObj(this.m_Perspective, idZoomOut);
        if (this.hasScrollThumb()) {
            bbZoomOut.setBorderColor(ZOOM_BUTTON_BORDER_COLOR);
            bbZoomOut.setFillColor(ZOOM_BUTTON_FILL_COLOR);
        } else {
            bbZoomOut.setBorderColor(ZOOM_BUTTON_BORDER_COLOR.brighter());
            bbZoomOut.setFillColor(ZOOM_BUTTON_FILL_COLOR.brighter());
        }
        BlackBoxObj bbPlusMinus = new BlackBoxObj(this.m_Perspective, new IdentObj(3000));
        bbPlusMinus.setBorderColor(ZOOM_BUTTON_BORDER_COLOR);
        BlackBoxObj bbScrollIconF = new BlackBoxObj(this.m_Perspective, idScrollIconF);
        bbScrollIconF.setBorderColor(SCROLL_ICONS_BORDER_COLOR);
        bbScrollIconF.setFillColor(SCROLL_ICONS_FILL_COLOR);
        BlackBoxObj bbScrollIconS = new BlackBoxObj(this.m_Perspective, idScrollIconS);
        bbScrollIconS.setBorderColor(SCROLL_ICONS_BORDER_COLOR);
        bbScrollIconS.setFillColor(SCROLL_ICONS_FILL_COLOR);
        BlackBoxObj bbArrowF = new BlackBoxObj(this.m_Perspective, idArrowF);
        bbArrowF.setBorderColor(SCROLLER_BORDER_COLOR);
        bbArrowF.setFillColor(SCROLL_ARROW_FILL_COLOR);
        BlackBoxObj bbArrowS = new BlackBoxObj(this.m_Perspective, idArrowS);
        bbArrowS.setBorderColor(SCROLL_ARROW_BORDER_COLOR);
        bbArrowS.setFillColor(SCROLL_ARROW_FILL_COLOR);
        BlackBoxObj bbScroller = new BlackBoxObj(this.m_Perspective, idScroller);
        bbScroller.setBorderColor(SCROLLER_BORDER_COLOR);
        bbScroller.setFillColor(SCROLLER_FILL_COLOR);
        BlackBoxObj bbThumb = new BlackBoxObj(this.m_Perspective, idThumb);
        Rectangle rFrame = new Rectangle(this.m_rFrame);
        if (this.m_bVert) {
            int nScrollIconHeight = this.m_Perspective.getVC().destToVirtHeight(12);
            int nScrollIconWidth = this.m_Perspective.getVC().destToVirtWidth(12);
            switch (this.m_axisID) {
                case 2001: 
                case 2003: {
                    if (bHasY1) {
                        if (bY1AxisLeft) {
                            rFrame.y += nScrollIconHeight;
                            rFrame.height -= nScrollIconHeight;
                        } else if (bY1AxisRight) {
                            rFrame.height -= nScrollIconHeight;
                        }
                    }
                    if (!bHasY2) break;
                    if (bY2AxisLeft) {
                        rFrame.y += nScrollIconHeight;
                        rFrame.height -= nScrollIconHeight;
                        break;
                    }
                    if (!bY2AxisRight) break;
                    rFrame.height -= nScrollIconHeight;
                    break;
                }
                case 2004: 
                case 2005: {
                    if (bHasO1) {
                        if (bO1AxisLeft) {
                            rFrame.y += nScrollIconHeight;
                            rFrame.height -= nScrollIconHeight;
                            break;
                        }
                        if (!bO1AxisRight) break;
                        rFrame.height -= nScrollIconHeight;
                        break;
                    }
                    if (!bHasX1) break;
                    if (bX1AxisLeft) {
                        rFrame.y += nScrollIconHeight;
                        rFrame.height -= nScrollIconHeight;
                        break;
                    }
                    if (!bX1AxisRight) break;
                    rFrame.height -= nScrollIconHeight;
                }
            }
            nHeight = rFrame.height;
            nWidth = nScrollIconWidth;
            quarterScrollIconWidth = nScrollIconWidth / 4;
            quarterScrollIconHeight = nScrollIconHeight / 4;
            thirdScrollIconWidth = nScrollIconWidth / 3;
            thirdScrollIconHeight = nScrollIconHeight / 3;
            nReduFactor = nScrollIconHeight * 4;
            double radius = nScrollIconWidth / 2;
            if (bAxisLeft) {
                rScroller = new Rectangle(rFrame.x, rFrame.y + nScrollIconHeight, nWidth, nHeight - nReduFactor);
                rScrollIconF = new Rectangle(rFrame.x, rFrame.y + nHeight - 3 * nScrollIconHeight, nScrollIconWidth, nScrollIconHeight);
                pArrowF = new Polygon();
                pArrowF.addPoint(rFrame.x + quarterScrollIconWidth, rFrame.y + nHeight - 3 * nScrollIconHeight + thirdScrollIconHeight);
                pArrowF.addPoint(rFrame.x + nScrollIconWidth - quarterScrollIconWidth, rFrame.y + nHeight - 3 * nScrollIconHeight + thirdScrollIconHeight);
                pArrowF.addPoint(rFrame.x + nScrollIconWidth / 2, rFrame.y + nHeight - 2 * nScrollIconHeight - thirdScrollIconHeight);
                rScrollIconS = new Rectangle(rFrame.x, rFrame.y, nScrollIconWidth, nScrollIconHeight);
                pArrowS = new Polygon();
                pArrowS.addPoint(rFrame.x + nScrollIconWidth / 2, rFrame.y + thirdScrollIconHeight);
                pArrowS.addPoint(rFrame.x + quarterScrollIconWidth, rFrame.y + nScrollIconHeight - thirdScrollIconHeight);
                pArrowS.addPoint(rFrame.x + nScrollIconWidth - quarterScrollIconWidth, rFrame.y + nScrollIconHeight - thirdScrollIconHeight);
                rZoomInIcon = new Rectangle(rFrame.x, rFrame.y + nHeight - nScrollIconHeight, nScrollIconWidth, nScrollIconHeight);
                rZoomOutIcon = new Rectangle(rFrame.x, rFrame.y + nHeight - 2 * nScrollIconHeight, nScrollIconWidth, nScrollIconHeight);
                ptZoomOutF = new Point(rZoomOutIcon.x < 0 ? rZoomOutIcon.x + rZoomOutIcon.width : rZoomOutIcon.x - rZoomOutIcon.width, rZoomOutIcon.y < 0 ? rZoomOutIcon.y - rZoomOutIcon.height / 2 : rZoomOutIcon.y + rZoomOutIcon.height / 2);
                ptZoomOutS = new Point(rZoomOutIcon.x, rZoomOutIcon.y < 0 ? rZoomOutIcon.y - rZoomOutIcon.height / 2 : rZoomOutIcon.y + rZoomOutIcon.height / 2);
                ptZoomInHorzF = new Point(rZoomInIcon.x < 0 ? rZoomInIcon.x + rZoomInIcon.width : rZoomInIcon.x - rZoomInIcon.width, rZoomInIcon.y < 0 ? rZoomInIcon.y - rZoomInIcon.height / 2 : rZoomInIcon.y + rZoomInIcon.height / 2);
                ptZoomInHorzS = new Point(rZoomInIcon.x, rZoomInIcon.y < 0 ? rZoomInIcon.y - rZoomInIcon.height / 2 : rZoomInIcon.y + rZoomInIcon.height / 2);
                ptZoomInVertF = new Point(rZoomInIcon.x < 0 ? rZoomInIcon.x + rZoomInIcon.width / 2 : rZoomInIcon.x - rZoomInIcon.width / 2, rZoomInIcon.y);
                ptZoomInVertS = new Point(rZoomInIcon.x < 0 ? rZoomInIcon.x + rZoomInIcon.width / 2 : rZoomInIcon.x - rZoomInIcon.width / 2, rZoomInIcon.y < 0 ? rZoomInIcon.y - rZoomInIcon.height : rZoomInIcon.y + rZoomInIcon.height);
            } else {
                if (!bAxisRight) return;
                rScroller = new Rectangle(rFrame.x + rFrame.width - nScrollIconWidth, rFrame.y + nScrollIconHeight, nWidth, nHeight - nReduFactor);
                rScrollIconF = new Rectangle(rFrame.x + rFrame.width - nScrollIconWidth, rFrame.y + nHeight - 3 * nScrollIconHeight, nScrollIconWidth, nScrollIconHeight);
                pArrowF = new Polygon();
                pArrowF.addPoint(rFrame.x + rFrame.width - nScrollIconWidth + quarterScrollIconWidth, rFrame.y + nHeight - 3 * nScrollIconHeight + thirdScrollIconHeight);
                pArrowF.addPoint(rFrame.x + rFrame.width - quarterScrollIconWidth, rFrame.y + nHeight - 3 * nScrollIconHeight + thirdScrollIconHeight);
                pArrowF.addPoint(rFrame.x + rFrame.width - nScrollIconWidth / 2, rFrame.y + nHeight - 2 * nScrollIconHeight - thirdScrollIconHeight);
                rScrollIconS = new Rectangle(rFrame.x + rFrame.width - nScrollIconWidth, rFrame.y, nScrollIconWidth, nScrollIconHeight);
                pArrowS = new Polygon();
                pArrowS.addPoint(rFrame.x + rFrame.width - nScrollIconWidth / 2, rFrame.y + thirdScrollIconHeight);
                pArrowS.addPoint(rFrame.x + rFrame.width - quarterScrollIconWidth, rFrame.y + nScrollIconHeight - thirdScrollIconHeight);
                pArrowS.addPoint(rFrame.x + rFrame.width - nScrollIconWidth + quarterScrollIconWidth, rFrame.y + nScrollIconHeight - thirdScrollIconHeight);
                rZoomInIcon = new Rectangle(rFrame.x + rFrame.width - nScrollIconWidth, rFrame.y + nHeight - nScrollIconHeight, nScrollIconWidth, nScrollIconHeight);
                rZoomOutIcon = new Rectangle(rFrame.x + rFrame.width - nScrollIconWidth, rFrame.y + nHeight - 2 * nScrollIconHeight, nScrollIconWidth, nScrollIconHeight);
                ptZoomOutF = new Point(rZoomOutIcon.x, rZoomOutIcon.y < 0 ? rZoomOutIcon.y - rZoomOutIcon.height / 2 : rZoomOutIcon.y + rZoomOutIcon.height / 2);
                ptZoomOutS = new Point(rZoomOutIcon.x < 0 ? rZoomOutIcon.x - rZoomOutIcon.width : rZoomOutIcon.x + rZoomOutIcon.width, rZoomOutIcon.y < 0 ? rZoomOutIcon.y - rZoomOutIcon.height / 2 : rZoomOutIcon.y + rZoomOutIcon.height / 2);
                ptZoomInHorzF = new Point(rZoomInIcon.x, rZoomInIcon.y < 0 ? rZoomInIcon.y - rZoomInIcon.height / 2 : rZoomInIcon.y + rZoomInIcon.height / 2);
                ptZoomInHorzS = new Point(rZoomInIcon.x < 0 ? rZoomInIcon.x - rZoomInIcon.width : rZoomInIcon.x + rZoomInIcon.width, rZoomInIcon.y < 0 ? rZoomInIcon.y - rZoomInIcon.height / 2 : rZoomInIcon.y + rZoomInIcon.height / 2);
                ptZoomInVertF = new Point(rZoomInIcon.x < 0 ? rZoomInIcon.x - rZoomInIcon.width / 2 : rZoomInIcon.x + rZoomInIcon.width / 2, rZoomInIcon.y);
                ptZoomInVertS = new Point(rZoomInIcon.x < 0 ? rZoomInIcon.x - rZoomInIcon.width / 2 : rZoomInIcon.x + rZoomInIcon.width / 2, rZoomInIcon.y < 0 ? rZoomInIcon.y - rZoomInIcon.height : rZoomInIcon.y + rZoomInIcon.height);
            }
        } else {
            int nScrollIconHeight = this.m_Perspective.getVC().destToVirtHeight(12);
            int nScrollIconWidth = this.m_Perspective.getVC().destToVirtWidth(12);
            switch (this.m_axisID) {
                case 2001: 
                case 2003: {
                    if (bHasY1) {
                        if (bY1AxisLeft) {
                            rFrame.x += nScrollIconWidth;
                            rFrame.width -= nScrollIconWidth;
                        } else if (bY1AxisRight) {
                            rFrame.width -= nScrollIconWidth;
                        }
                    }
                    if (!bHasY2) break;
                    if (bY2AxisLeft) {
                        rFrame.x += nScrollIconWidth;
                        rFrame.width -= nScrollIconWidth;
                        break;
                    }
                    if (!bY2AxisRight) break;
                    rFrame.width -= nScrollIconWidth;
                    break;
                }
                case 2004: 
                case 2005: {
                    if (bHasO1) {
                        if (bO1AxisLeft) {
                            rFrame.x += nScrollIconWidth;
                            rFrame.width -= nScrollIconWidth;
                            break;
                        }
                        if (!bO1AxisRight) break;
                        rFrame.width -= nScrollIconWidth;
                        break;
                    }
                    if (!bHasX1) break;
                    if (bX1AxisLeft) {
                        rFrame.x += nScrollIconWidth;
                        rFrame.width -= nScrollIconWidth;
                        break;
                    }
                    if (!bX1AxisRight) break;
                    rFrame.width -= nScrollIconWidth;
                }
            }
            if (bAxisLeft) {
                quarterScrollIconWidth = nScrollIconWidth / 4;
                quarterScrollIconHeight = nScrollIconHeight / 4;
                thirdScrollIconWidth = nScrollIconWidth / 3;
                thirdScrollIconHeight = nScrollIconHeight / 3;
                nReduFactor = nScrollIconWidth * 4;
                nHeight = nScrollIconHeight;
                nWidth = rFrame.width;
                rScroller = new Rectangle(rFrame.x + nScrollIconWidth, rFrame.y, nWidth - nReduFactor, nHeight);
                rScrollIconF = new Rectangle(rFrame.x, rFrame.y, nScrollIconWidth, nHeight);
                pArrowF = new Polygon();
                pArrowF.addPoint(rFrame.x + nScrollIconWidth - thirdScrollIconWidth, rFrame.y + nScrollIconHeight - quarterScrollIconHeight);
                pArrowF.addPoint(rFrame.x + thirdScrollIconWidth, rFrame.y + nScrollIconHeight / 2);
                pArrowF.addPoint(rFrame.x + nScrollIconWidth - thirdScrollIconWidth, rFrame.y + quarterScrollIconHeight);
                rScrollIconS = new Rectangle(rFrame.x + nWidth - nScrollIconWidth * 3, rFrame.y, nScrollIconWidth, nScrollIconHeight);
                pArrowS = new Polygon();
                pArrowS.addPoint(rFrame.x + nWidth - nScrollIconWidth * 3 + thirdScrollIconWidth, rFrame.y + nScrollIconHeight - quarterScrollIconHeight);
                pArrowS.addPoint(rFrame.x + nWidth - nScrollIconWidth * 2 - thirdScrollIconWidth, rFrame.y + nScrollIconHeight / 2);
                pArrowS.addPoint(rFrame.x + nWidth - nScrollIconWidth * 3 + thirdScrollIconWidth, rFrame.y + quarterScrollIconHeight);
                double radius = nScrollIconWidth / 2;
                rZoomInIcon = new Rectangle(rFrame.x + nWidth - nScrollIconWidth, rFrame.y, nScrollIconWidth, nScrollIconHeight);
                rZoomOutIcon = new Rectangle(rFrame.x + nWidth - nScrollIconWidth * 2, rFrame.y, nScrollIconWidth, nScrollIconHeight);
                ptZoomOutF = new Point(rZoomOutIcon.x, rZoomOutIcon.y < 0 ? rZoomOutIcon.y + rZoomOutIcon.height / 2 : rZoomOutIcon.y - rZoomOutIcon.height / 2);
                ptZoomOutS = new Point(rZoomOutIcon.x < 0 ? rZoomOutIcon.x - rZoomOutIcon.width : rZoomOutIcon.x + rZoomOutIcon.width, rZoomOutIcon.y < 0 ? rZoomOutIcon.y + rZoomOutIcon.height / 2 : rZoomOutIcon.y - rZoomOutIcon.height / 2);
                ptZoomInHorzF = new Point(rZoomInIcon.x, rZoomInIcon.y < 0 ? rZoomInIcon.y + rZoomInIcon.height / 2 : rZoomInIcon.y - rZoomInIcon.height / 2);
                ptZoomInHorzS = new Point(rZoomInIcon.x < 0 ? rZoomInIcon.x - rZoomInIcon.width : rZoomInIcon.x + rZoomInIcon.width, rZoomInIcon.y < 0 ? rZoomInIcon.y + rZoomInIcon.height / 2 : rZoomInIcon.y - rZoomInIcon.height / 2);
                ptZoomInVertF = new Point(rZoomInIcon.x < 0 ? rZoomInIcon.x - rZoomInIcon.width / 2 : rZoomInIcon.x + rZoomInIcon.width / 2, rZoomInIcon.y);
                ptZoomInVertS = new Point(rZoomInIcon.x < 0 ? rZoomInIcon.x - rZoomInIcon.width / 2 : rZoomInIcon.x + rZoomInIcon.width / 2, rZoomInIcon.y < 0 ? rZoomInIcon.y + rZoomInIcon.height : rZoomInIcon.y - rZoomInIcon.height);
            } else {
                quarterScrollIconWidth = nScrollIconWidth / 4;
                quarterScrollIconHeight = nScrollIconHeight / 4;
                thirdScrollIconWidth = nScrollIconWidth / 3;
                thirdScrollIconHeight = nScrollIconHeight / 3;
                nReduFactor = nScrollIconWidth * 4;
                nHeight = this.m_Perspective.m_VC.destToVirtHeight(12);
                nWidth = rFrame.width;
                rScroller = new Rectangle(rFrame.x + nScrollIconWidth, rFrame.y < 0 ? rFrame.y + (rFrame.height - nHeight) : rFrame.y + (rFrame.height - nHeight), nWidth - nReduFactor, nHeight);
                rScrollIconF = new Rectangle(rFrame.x, rFrame.y < 0 ? rFrame.y + (rFrame.height - nHeight) : rFrame.y + (rFrame.height - nHeight), nScrollIconWidth, nScrollIconHeight);
                pArrowF = new Polygon();
                pArrowF.addPoint(rFrame.x + nScrollIconWidth - thirdScrollIconWidth, (rFrame.y < 0 ? rFrame.y + (rFrame.height - nHeight) : rFrame.y + (rFrame.height - nHeight)) + nScrollIconHeight - quarterScrollIconHeight);
                pArrowF.addPoint(rFrame.x + thirdScrollIconWidth, (rFrame.y < 0 ? rFrame.y + (rFrame.height - nHeight) : rFrame.y + (rFrame.height - nHeight)) + nScrollIconHeight / 2);
                pArrowF.addPoint(rFrame.x + nScrollIconWidth - thirdScrollIconWidth, (rFrame.y < 0 ? rFrame.y + (rFrame.height - nHeight) : rFrame.y + (rFrame.height - nHeight)) + quarterScrollIconHeight);
                rScrollIconS = new Rectangle(rFrame.x + nWidth - nScrollIconWidth * 3, rFrame.y < 0 ? rFrame.y + (rFrame.height - nHeight) : rFrame.y + (rFrame.height - nHeight), nScrollIconWidth, nScrollIconHeight);
                pArrowS = new Polygon();
                pArrowS.addPoint(rFrame.x + nWidth - nScrollIconWidth * 3 + thirdScrollIconWidth, (rFrame.y < 0 ? rFrame.y + (rFrame.height - nHeight) : rFrame.y + (rFrame.height - nHeight)) + nScrollIconHeight - quarterScrollIconHeight);
                pArrowS.addPoint(rFrame.x + nWidth - nScrollIconWidth * 2 - thirdScrollIconWidth, (rFrame.y < 0 ? rFrame.y + (rFrame.height - nHeight) : rFrame.y + (rFrame.height - nHeight)) + nScrollIconHeight / 2);
                pArrowS.addPoint(rFrame.x + nWidth - nScrollIconWidth * 3 + thirdScrollIconWidth, (rFrame.y < 0 ? rFrame.y + (rFrame.height - nHeight) : rFrame.y + (rFrame.height - nHeight)) + quarterScrollIconHeight);
                double radius = nScrollIconWidth / 2;
                rZoomInIcon = new Rectangle(rFrame.x + nWidth - nScrollIconWidth, rFrame.y < 0 ? rFrame.y + (rFrame.height - nHeight) : rFrame.y + (rFrame.height - nHeight), nScrollIconWidth, nScrollIconHeight);
                rZoomOutIcon = new Rectangle(rFrame.x + nWidth - nScrollIconWidth * 2, rFrame.y < 0 ? rFrame.y + (rFrame.height - nHeight) : rFrame.y + (rFrame.height - nHeight), nScrollIconWidth, nScrollIconHeight);
                ptZoomOutF = new Point(rZoomOutIcon.x, rZoomOutIcon.y < 0 ? rZoomOutIcon.y - rZoomOutIcon.height / 2 : rZoomOutIcon.y + rZoomOutIcon.height / 2);
                ptZoomOutS = new Point(rZoomOutIcon.x < 0 ? rZoomOutIcon.x - rZoomOutIcon.width : rZoomOutIcon.x + rZoomOutIcon.width, rZoomOutIcon.y < 0 ? rZoomOutIcon.y - rZoomOutIcon.height / 2 : rZoomOutIcon.y + rZoomOutIcon.height / 2);
                ptZoomInHorzF = new Point(rZoomInIcon.x, rZoomInIcon.y < 0 ? rZoomInIcon.y - rZoomInIcon.height / 2 : rZoomInIcon.y + rZoomInIcon.height / 2);
                ptZoomInHorzS = new Point(rZoomInIcon.x < 0 ? rZoomInIcon.x - rZoomInIcon.width : rZoomInIcon.x + rZoomInIcon.width, rZoomInIcon.y < 0 ? rZoomInIcon.y - rZoomInIcon.height / 2 : rZoomInIcon.y + rZoomInIcon.height / 2);
                ptZoomInVertF = new Point(rZoomInIcon.x < 0 ? rZoomInIcon.x - rZoomInIcon.width / 2 : rZoomInIcon.x + rZoomInIcon.width / 2, rZoomInIcon.y);
                ptZoomInVertS = new Point(rZoomInIcon.x < 0 ? rZoomInIcon.x - rZoomInIcon.width / 2 : rZoomInIcon.x + rZoomInIcon.width / 2, rZoomInIcon.y < 0 ? rZoomInIcon.y - rZoomInIcon.height : rZoomInIcon.y + rZoomInIcon.height);
            }
        }
        if (rZoomOutIcon != null && rZoomInIcon != null) {
            int halfDiff;
            int destNewLength;
            int newLength;
            int length;
            new DetOval(this.m_Perspective.m_Detectiv, idZoomOut, rZoomOutIcon.x, rZoomOutIcon.y, rZoomOutIcon.width, rZoomOutIcon.height, bbZoomOut, true);
            new DetOval(this.m_Perspective.m_Detectiv, idZoomIn, rZoomInIcon.x, rZoomInIcon.y, rZoomInIcon.width, rZoomInIcon.height, bbZoomIn, true);
            double PAD_PCT = 0.5;
            VC vc = this.m_Perspective.getVC();
            if (ptZoomOutF != null && ptZoomOutS != null) {
                if (ptZoomOutF.x < ptZoomOutS.x) {
                    length = ptZoomOutS.x - ptZoomOutF.x;
                    newLength = (int)Math.round(0.5 * (double)length);
                    destNewLength = vc.virtToDestWidth(newLength);
                    if (destNewLength % 2 == 0) {
                        newLength = vc.destToVirtWidth(destNewLength + 1);
                    }
                    halfDiff = (length - newLength) / 2;
                    ptZoomOutF.x += halfDiff;
                    ptZoomOutS.x -= halfDiff;
                } else {
                    length = ptZoomOutF.x - ptZoomOutS.x;
                    newLength = (int)Math.round(0.5 * (double)length);
                    destNewLength = vc.virtToDestWidth(newLength);
                    if (destNewLength % 2 == 0) {
                        newLength = vc.destToVirtWidth(destNewLength + 1);
                    }
                    halfDiff = (length - newLength) / 2;
                    ptZoomOutS.x += halfDiff;
                    ptZoomOutF.x -= halfDiff;
                }
                new DetLine(this.m_Perspective.m_Detectiv, new IdentObj(3000), ptZoomOutF.x, ptZoomOutF.y, ptZoomOutS.x, ptZoomOutS.y, (BlackBoxIF)bbPlusMinus, null, 1);
            }
            if (ptZoomInHorzF != null && ptZoomInHorzS != null) {
                if (ptZoomInHorzF.x < ptZoomInHorzS.x) {
                    length = ptZoomInHorzS.x - ptZoomInHorzF.x;
                    newLength = (int)Math.round(0.5 * (double)length);
                    destNewLength = vc.virtToDestWidth(newLength);
                    if (destNewLength % 2 == 0) {
                        newLength = vc.destToVirtWidth(destNewLength + 1);
                    }
                    halfDiff = (length - newLength) / 2;
                    ptZoomInHorzF.x += halfDiff;
                    ptZoomInHorzS.x -= halfDiff;
                } else {
                    length = ptZoomInHorzF.x - ptZoomInHorzS.x;
                    newLength = (int)Math.round(0.5 * (double)length);
                    destNewLength = vc.virtToDestWidth(newLength);
                    if (destNewLength % 2 == 0) {
                        newLength = vc.destToVirtWidth(destNewLength + 1);
                    }
                    halfDiff = (length - newLength) / 2;
                    ptZoomInHorzS.x += halfDiff;
                    ptZoomInHorzF.x -= halfDiff;
                }
                new DetLine(this.m_Perspective.m_Detectiv, new IdentObj(3000), ptZoomInHorzF.x, ptZoomInHorzF.y, ptZoomInHorzS.x, ptZoomInHorzS.y, (BlackBoxIF)bbPlusMinus, null, 1);
            }
            if (ptZoomInVertF != null && ptZoomInVertS != null) {
                if (ptZoomInVertF.y < ptZoomInVertS.y) {
                    length = ptZoomInVertS.y - ptZoomInVertF.y;
                    newLength = (int)Math.round(0.5 * (double)length);
                    destNewLength = vc.virtToDestHeight(newLength);
                    if (destNewLength % 2 == 0) {
                        newLength = vc.destToVirtHeight(destNewLength + 1);
                    }
                    halfDiff = (length - newLength) / 2;
                    ptZoomInVertF.y += halfDiff;
                    ptZoomInVertS.y -= halfDiff;
                } else {
                    length = ptZoomInVertF.y - ptZoomInVertS.y;
                    newLength = (int)Math.round(0.5 * (double)length);
                    destNewLength = vc.virtToDestHeight(newLength);
                    if (destNewLength % 2 == 0) {
                        newLength = vc.destToVirtHeight(destNewLength + 1);
                    }
                    halfDiff = (length - newLength) / 2;
                    ptZoomInVertS.y += halfDiff;
                    ptZoomInVertF.y -= halfDiff;
                }
                new DetLine(this.m_Perspective.m_Detectiv, new IdentObj(3000), ptZoomInVertF.x, ptZoomInVertF.y, ptZoomInVertS.x, ptZoomInVertS.y, (BlackBoxIF)bbPlusMinus, null, 1);
            }
        }
        boolean noScrolling = !this.hasScrollThumb();
        switch (this.m_axisID) {
            case 2004: {
                if (!noScrolling || this.m_Perspective.getDataScrollerPresenceY1() == 2) break;
                return;
            }
            case 2005: {
                if (!noScrolling || this.m_Perspective.getDataScrollerPresenceY2() == 2) break;
                return;
            }
            case 2003: {
                if (!noScrolling || this.m_Perspective.getDataScrollerPresenceX1() == 2) break;
                return;
            }
            case 2001: {
                if (!noScrolling || this.m_Perspective.getDataScrollerPresenceGroups() == 2) break;
                return;
            }
        }
        int nExtra = this.m_nTotal - this.m_nViewable;
        if (this.m_nTotal == 0) return;
        if (this.m_bVert) {
            int nThumbHeight = rScroller.height * this.m_nViewable / this.m_nTotal;
            if (nThumbHeight < this.m_Perspective.m_VC.destToVirtHeight(12)) {
                nThumbHeight = this.m_Perspective.m_VC.destToVirtHeight(12);
            }
            int nThumbCenter = nExtra == 0 ? rScroller.y + rScroller.height - nThumbHeight / 2 : rScroller.y + rScroller.height - nThumbHeight / 2 - (int)((double)(this.m_nTotal - this.m_nOffset - this.m_nViewable) * (double)(rScroller.height - nThumbHeight) / (double)nExtra);
            rThumb = new Rectangle(rScroller.x, nThumbCenter - nThumbHeight / 2, nWidth, nThumbHeight);
        } else {
            int nThumbWidth = rScroller.width * this.m_nViewable / this.m_nTotal;
            if (nThumbWidth < this.m_Perspective.m_VC.destToVirtWidth(12)) {
                nThumbWidth = this.m_Perspective.m_VC.destToVirtWidth(12);
            }
            int nThumbCenter = nExtra == 0 ? rScroller.x + nThumbWidth / 2 : rScroller.x + nThumbWidth / 2 + (int)((double)this.m_nOffset * (double)(rScroller.width - nThumbWidth) / (double)nExtra);
            rThumb = new Rectangle(nThumbCenter - nThumbWidth / 2, rScroller.y, nThumbWidth, nHeight);
        }
        new DetRect(this.m_Perspective.m_Detectiv, idScroller, rScroller, (BlackBoxIF)bbScroller, null);
        new DetRect(this.m_Perspective.m_Detectiv, idScrollIconF, rScrollIconF, (BlackBoxIF)bbScrollIconF, null);
        new DetRect(this.m_Perspective.m_Detectiv, idScrollIconS, rScrollIconS, (BlackBoxIF)bbScrollIconS, null);
        new DetPolygon(this.m_Perspective.m_Detectiv, idArrowF, pArrowF, (BlackBoxIF)bbArrowF, 1.0);
        new DetPolygon(this.m_Perspective.m_Detectiv, idArrowS, pArrowS, (BlackBoxIF)bbArrowS, 1.0);
        if (!this.hasScrollThumb()) return;
        new DetRect(this.m_Perspective.m_Detectiv, idThumb, rThumb, (BlackBoxIF)bbThumb, rScroller);
    }

    public int getScrollerHeightVC() {
        int nHeight = this.m_Perspective.m_VC.destToVirtHeight(12);
        return nHeight;
    }

    public int getScrollerWidthVC() {
        int nWidth = this.m_Perspective.m_VC.destToVirtWidth(12);
        return nWidth;
    }

    public boolean isPresent() {
        int nPresence = this.m_bGroups ? this.m_Perspective.getDataScrollerPresenceGroups() : this.m_Perspective.getDataScrollerPresenceSeries();
        return nPresence != 0 && (nPresence != 1 && nPresence != 3 || this.m_nViewable < this.m_nTotal);
    }

    public boolean isVertScroller() {
        return this.m_bVert;
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }

    public String toString() {
        return super.toString();
    }

    public int[] getScrollDetails() {
        return new int[]{this.m_nTotal, this.m_nViewable, this.m_nOffset};
    }

    public boolean hasScrollThumb() {
        return this.m_nTotal >= this.m_nViewable;
    }
}

