/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.PlainDocument;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.olaf.BrowserLookAndFeel;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.graph.DataEndPoints;
import oracle.dss.graph.Graph;
import oracle.dss.graph.gui.BaseAxis;
import oracle.dss.graph.gui.FormatButtonDialog;
import oracle.dss.graph.gui.GraphGUINames;
import oracle.dss.graph.gui.ReferenceLine;
import oracle.dss.util.gui.BIColorChoice;
import oracle.dss.util.gui.FontButton;
import oracle.dss.util.help.HelpContext;

public class ValueAxis
extends BaseAxis
implements HelpContext {
    private static final long serialVersionUID = 1L;
    protected JPanel minimum;
    protected JLabel minimumLabel;
    protected JPanel maximum;
    protected JLabel maximumLabel;
    protected JPanel increment;
    protected JLabel incrementLabel;
    protected JPanel baseline;
    protected JLabel baselineLabel;
    protected DoubleTextField m_minimumField;
    protected DoubleTextField m_maximumField;
    protected DoubleTextField m_incrementField;
    protected DoubleTextField m_baselineField;
    protected JCheckBox m_minimumBox;
    protected JCheckBox m_maximumBox;
    protected JCheckBox m_incrementBox;
    protected JCheckBox m_logarithmicBox;
    protected JButton m_scaleFontButton;
    protected JButton m_referenceLineButton;
    protected JPanel m_buttonPanel;
    protected JComboBox m_logChoice;
    protected JLabel m_base;
    protected JPanel logarithmic;
    protected int m_componentID;
    protected double m_oldMinimum;
    protected double m_oldMaximum;
    protected double m_oldIncrement;
    protected double m_oldBaseline;
    protected double m_oldLogBase;
    protected double m_currentLogBase;
    protected boolean m_bHelpEnabled;
    protected HelpProvider m_helpProvider;
    protected String m_strHelpContextID;
    protected boolean m_incrChecked;
    protected boolean m_repeatWarnings = true;
    protected double m_currentMaxValue;
    protected double m_currentMinValue;
    protected double m_currentIncrValue;
    protected double m_currentBaselineValue;
    protected int m_multiplier = 10;
    protected ReferenceLine m_referenceLine;
    protected boolean m_bScaleLogarithmicChanged = false;
    protected boolean m_bLogarithmicBaseChanged = false;
    protected boolean m_bReferenceLineChanged = false;
    protected double autoTickStep;
    protected FormatButtonDialog m_formatDialog;
    public static final String PROPERTY_AXIS_MAX_VALUE = "AxisMaxValue";
    public static final String PROPERTY_AXIS_MIN_VALUE = "AxisMinValue";
    public static final String PROPERTY_AXIS_MAJOR_TICK_STEP = "AxisMajorTickStep";
    public static final String PROPERTY_AXIS_AUTO_MAX = "AxisAutoMax";
    public static final String PROPERTY_AXIS_AUTO_MIN = "AxisAutoMin";
    public static final String PROPERTY_AXIS_AUTO_TICK_STEP = "AxisAutoTickStep";
    public static final String PROPERTY_AXIS_LOG_SCALE = "AxisLogScale";
    public static final String PROPERTY_AXIS_LOG_BASE = "AxisLogarithmicBase";

    public ValueAxis(Graph graph, int componentID) {
        super(graph);
        this.updateResourceBundle(graph.getLocale());
        this.m_optionsLabel.setText(this.rBundle.getString("axis scale"));
        this.minimum = new JPanel();
        this.minimum.setLayout(new BoxLayout(this.minimum, 0));
        this.minimumLabel = new JLabel(StringUtils.stripMnemonic((String)this.rBundle.getString("Minimum")));
        this.minimumLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Minimum")));
        this.minimum.add(this.minimumLabel);
        this.minimum.add(Box.createHorizontalStrut(12));
        this.m_minimumField = new DoubleTextField(graph.getLocale());
        this.m_minimumField.setName(GraphGUINames.AXISMINIMUM_TEXTFIELD);
        this.minimumLabel.setLabelFor(this.m_minimumField);
        this.minimumLabel.getAccessibleContext().setAccessibleName(this.rBundle.getString("Minimum ADA"));
        this.minimum.add(this.m_minimumField);
        this.minimum.add(Box.createHorizontalStrut(5));
        this.m_minimumBox = new JCheckBox(StringUtils.stripMnemonic((String)this.rBundle.getString("Automatic 1")));
        this.m_minimumBox.setName(GraphGUINames.AXISMINIMUMSETAUTO_CHECKBOX);
        this.m_minimumBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Automatic 1")));
        this.m_minimumBox.getAccessibleContext().setAccessibleName(this.rBundle.getString("Automatic 1 ADA"));
        this.m_minimumBox.setForeground(this.m_label.getForeground());
        this.minimum.add(this.m_minimumBox);
        this.maximum = new JPanel();
        this.maximum.setLayout(new BoxLayout(this.maximum, 0));
        this.maximumLabel = new JLabel(StringUtils.stripMnemonic((String)this.rBundle.getString("Maximum")));
        this.maximumLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Maximum")));
        this.maximum.add(Box.createVerticalStrut(5));
        this.maximum.add(this.maximumLabel);
        this.maximum.add(Box.createHorizontalStrut(12));
        this.m_maximumField = new DoubleTextField(graph.getLocale());
        this.m_maximumField.setName(GraphGUINames.AXISMAXIMUM_TEXTFIELD);
        this.maximumLabel.setLabelFor(this.m_maximumField);
        this.maximumLabel.getAccessibleContext().setAccessibleName(this.rBundle.getString("Maximum ADA"));
        this.maximum.add(this.m_maximumField);
        this.maximum.add(Box.createHorizontalStrut(5));
        this.m_maximumBox = new JCheckBox(StringUtils.stripMnemonic((String)this.rBundle.getString("Automatic 2")));
        this.m_maximumBox.setName(GraphGUINames.AXISMAXIMUMSETAUTO_CHECKBOX);
        this.m_maximumBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Automatic 2")));
        this.m_maximumBox.getAccessibleContext().setAccessibleName(this.rBundle.getString("Automatic 2 ADA"));
        this.m_maximumBox.setForeground(this.m_label.getForeground());
        this.maximum.add(this.m_maximumBox);
        this.increment = new JPanel();
        this.increment.setLayout(new BoxLayout(this.increment, 0));
        this.incrementLabel = new JLabel(StringUtils.stripMnemonic((String)this.rBundle.getString("Increment")));
        this.incrementLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Increment")));
        this.increment.add(Box.createVerticalStrut(5));
        this.increment.add(this.incrementLabel);
        this.increment.add(Box.createHorizontalStrut(12));
        this.m_incrementField = new DoubleTextField(graph.getLocale());
        this.m_incrementField.setName(GraphGUINames.AXISINCREMENT_TEXTFIELD);
        this.incrementLabel.setLabelFor(this.m_incrementField);
        this.incrementLabel.getAccessibleContext().setAccessibleName(this.rBundle.getString("Increment ADA"));
        this.increment.add(this.m_incrementField);
        this.increment.add(Box.createHorizontalStrut(5));
        this.m_incrementBox = new JCheckBox(StringUtils.stripMnemonic((String)this.rBundle.getString("Automatic 3")));
        this.m_incrementBox.setName(GraphGUINames.AXISINCREMENTSETAUTO_CHECKBOX);
        this.m_incrementBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Automatic 3")));
        this.m_incrementBox.getAccessibleContext().setAccessibleName(this.rBundle.getString("Automatic 3 ADA"));
        this.m_incrementBox.setForeground(this.m_label.getForeground());
        this.increment.add(this.m_incrementBox);
        this.baseline = new JPanel();
        this.baseline.setLayout(new BoxLayout(this.baseline, 0));
        this.baselineLabel = new JLabel(StringUtils.stripMnemonic((String)this.rBundle.getString("Baseline value")));
        this.baselineLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Baseline value")));
        this.baseline.add(Box.createVerticalStrut(5));
        this.baseline.add(this.baselineLabel);
        this.baseline.add(Box.createHorizontalStrut(12));
        this.m_baselineField = new DoubleTextField(graph.getLocale());
        this.m_baselineField.setName(GraphGUINames.AXISBASELINE_TEXTFIELD);
        this.baselineLabel.setLabelFor(this.m_baselineField);
        this.baselineLabel.getAccessibleContext().setAccessibleName(this.rBundle.getString("Baseline ADA"));
        this.baseline.add(this.m_baselineField);
        this.m_referenceLineButton = new JButton(StringUtils.stripMnemonic((String)this.rBundle.getString("ReferenceLines")));
        this.m_referenceLineButton.setName(GraphGUINames.AXISREFERENCELINE_BUTTON);
        this.m_referenceLineButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("ReferenceLines")));
        this.m_referenceLineButton.setAlignmentX(0.0f);
        this.m_scaleFontButton = new JButton();
        this.m_scaleFontButton.setName(GraphGUINames.AXISFORMATAXIS_BUTTON);
        this.m_buttonPanel = new JPanel(new FlowLayout(2, 0, 0));
        this.m_buttonPanel.setAlignmentX(0.0f);
        this.m_buttonPanel.add(this.m_referenceLineButton);
        this.m_buttonPanel.add(Box.createHorizontalStrut(10));
        this.m_buttonPanel.add(this.m_scaleFontButton);
        this.logarithmic = new JPanel();
        this.logarithmic.setLayout(new BoxLayout(this.logarithmic, 0));
        this.m_logarithmicBox = new JCheckBox(StringUtils.stripMnemonic((String)this.rBundle.getString("Logarithmic scale")));
        this.m_logarithmicBox.setName(GraphGUINames.AXISLOGARITHMICSCALE_CHECKBOX);
        this.m_logarithmicBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Logarithmic scale")));
        this.m_logarithmicBox.setForeground(this.m_label.getForeground());
        this.m_logChoice = new JComboBox<String>(new String[]{this.rBundle.getString("2"), this.rBundle.getString("NaturalLog"), this.rBundle.getString("10")});
        this.m_logChoice.setName(GraphGUINames.AXISLOGSCALEBASE_COMBOBOX);
        this.m_base = new JLabel(StringUtils.stripMnemonic((String)this.rBundle.getString("Base")));
        this.m_base.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Base")));
        this.m_base.setLabelFor(this.m_logChoice);
        this.logarithmic.add(Box.createVerticalStrut(5));
        this.logarithmic.add(this.m_logarithmicBox);
        this.logarithmic.add(Box.createHorizontalStrut(24));
        this.logarithmic.add(this.m_base);
        this.logarithmic.add(Box.createHorizontalStrut(12));
        this.logarithmic.add(this.m_logChoice);
        this.minimum.setAlignmentX(0.0f);
        this.maximum.setAlignmentX(0.0f);
        this.increment.setAlignmentX(0.0f);
        this.baseline.setAlignmentX(0.0f);
        this.logarithmic.setAlignmentX(0.0f);
        this.m_mainPanel.add(this.minimum);
        this.m_mainPanel.add(this.maximum);
        this.m_mainPanel.add(this.increment);
        this.m_mainPanel.add(this.baseline);
        this.m_mainPanel.add(this.logarithmic);
        this.m_mainPanel.add(Box.createVerticalStrut(15));
        this.m_mainPanel.add(this.m_buttonPanel);
        this.m_mainPanel.add(Box.createGlue());
        this.m_componentID = componentID;
        this.m_minimumBox.addItemListener(this);
        this.m_maximumBox.addItemListener(this);
        this.m_incrementBox.addItemListener(this);
        this.m_logarithmicBox.addItemListener(this);
        this.m_logChoice.addItemListener(this);
        this._init();
        this.m_referenceLineButton.addActionListener(this);
        this.m_scaleFontButton.addActionListener(this);
        this.m_minimumField.addCaretListener(this);
        this.m_maximumField.addCaretListener(this);
        this.m_incrementField.addCaretListener(this);
        this.m_baselineField.addCaretListener(this);
    }

    public ValueAxis(Graph graph, int componentID, int errorTypes) {
        this(graph, componentID);
        this.m_errorTypes = errorTypes;
    }

    @Override
    public void setGraph(Graph graph) {
        super.setGraph(graph);
        this._init();
    }

    @Override
    public void setColorPalette(Color[][] colors) {
        super.setColorPalette(colors);
        if (this.m_formatDialog != null) {
            this.m_formatDialog.setColorPalette(this.m_colorPalette);
        }
    }

    public void setRepeatWarnings(boolean repeat) {
        this.m_repeatWarnings = repeat;
    }

    public boolean isRepeatWarnings() {
        return this.m_repeatWarnings;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.m_referenceLineButton) {
            ReferenceDialog d = this.createReferenceDialog(this.rBundle.getString("Reference Lines"), true, this.m_referenceLine, this.m_bHelpEnabled);
            d.show();
            this.m_referenceLine.resetFocus();
            d.dispose();
            d = null;
            this.m_bReferenceLineChanged = true;
        }
        if (e.getSource() == this.m_scaleFontButton) {
            if (this.m_formatDialog == null) {
                this.m_formatDialog = new FormatButtonDialog(WindowUtils.parentFrame((Component)this), this.m_graph, this.m_componentID);
                this.m_formatDialog.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
                this.initFontButton(this.m_formatDialog);
                this._initFormatDialog();
                this.m_formatDialog.setForeground(this.m_label.getForeground());
                this.m_formatDialog.addPropertyChangeListener(this);
            }
            this.m_formatDialog.initFontPane();
            this.m_formatDialog.show();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.prefSize;
    }

    private void _setLogChoiceIndex(double value) {
        if (value < Math.E) {
            this.m_logChoice.setSelectedIndex(0);
        } else if (value == Math.E) {
            this.m_logChoice.setSelectedIndex(1);
        } else if (value > Math.E) {
            this.m_logChoice.setSelectedIndex(2);
        }
        this.m_oldLogBase = this.m_currentLogBase = value;
    }

    private boolean isPercentGraph() {
        switch (this.m_graph.getGraphType()) {
            case 23: 
            case 30: 
            case 35: 
            case 47: {
                return true;
            }
        }
        return false;
    }

    private boolean isPieGraph() {
        switch (this.m_graph.getGraphType()) {
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 93: 
            case 94: {
                return true;
            }
        }
        return false;
    }

    private boolean isBaselineGraph() {
        switch (this.m_graph.getGraphType()) {
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 33: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 48: 
            case 50: 
            case 52: {
                return true;
            }
        }
        return false;
    }

    private void _initFormatDialog() {
        this.m_formatDialog.setHelpProvider(this.getHelpProvider());
        switch (this.m_componentID) {
            case 41: {
                this.m_formatDialog.setTitle(this.rBundle.getString("Format X1Axis Labels"));
                this.m_formatDialog.setComponentFont(this.m_graph.getX1TickLabel().getFont());
                this.m_formatDialog.setTextRotation(this.convertToFontButtonConstants(this.m_graph.getX1TickLabel().getTextRotation()));
                if (this.m_graph.getX1TickLabel().getGraphFont().getGraphFontStyle() >= 4) {
                    this.m_formatDialog.setUnderlineStyle(true);
                } else {
                    this.m_formatDialog.setUnderlineStyle(false);
                }
                this.m_formatDialog.setComponentForeground(this.m_graph.getX1TickLabel().getGraphFont().getGraphFontColor());
                break;
            }
            case 46: {
                this.m_formatDialog.setTitle(this.rBundle.getString("Format Y1Axis Labels"));
                this.m_formatDialog.setComponentFont(this.m_graph.getY1TickLabel().getFont());
                if (this.m_graph.getY1TickLabel().getGraphFont().getGraphFontStyle() >= 4) {
                    this.m_formatDialog.setUnderlineStyle(true);
                } else {
                    this.m_formatDialog.setUnderlineStyle(false);
                }
                this.m_formatDialog.setComponentForeground(this.m_graph.getY1TickLabel().getGraphFont().getGraphFontColor());
                this.m_formatDialog.setTextRotation(this.convertToFontButtonConstants(this.m_graph.getY1TickLabel().getTextRotation()));
                break;
            }
            case 51: {
                this.m_formatDialog.setTitle(this.rBundle.getString("Format Y2Axis Labels"));
                this.m_formatDialog.setComponentFont(this.m_graph.getY2TickLabel().getFont());
                if (this.m_graph.getY2TickLabel().getGraphFont().getGraphFontStyle() >= 4) {
                    this.m_formatDialog.setUnderlineStyle(true);
                } else {
                    this.m_formatDialog.setUnderlineStyle(false);
                }
                this.m_formatDialog.setComponentForeground(this.m_graph.getY2TickLabel().getGraphFont().getGraphFontColor());
                this.m_formatDialog.setTextRotation(this.convertToFontButtonConstants(this.m_graph.getY2TickLabel().getTextRotation()));
            }
        }
    }

    private void _init() {
        this.baseline.setVisible(this.isBaselineGraph());
        this.m_minimumField.setEnabled(true);
        this.m_maximumField.setEnabled(true);
        this.m_incrementField.setEnabled(true);
        this.m_baselineField.setEnabled(true);
        this.m_minimumBox.setEnabled(true);
        this.m_maximumBox.setEnabled(true);
        this.m_logarithmicBox.setEnabled(true);
        this.m_logChoice.setEnabled(true);
        this.m_incrementBox.setEnabled(true);
        this.minimum.setVisible(true);
        this.maximum.setVisible(true);
        this.increment.setVisible(true);
        this.logarithmic.setVisible(true);
        this.m_optionsLabelPanel.setVisible(true);
        switch (this.m_componentID) {
            case 41: {
                this.setTitleText(this.rBundle.getString("X-Axis options"));
                this.m_showAxis.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("Show X-Axis Title")));
                this.m_showAxis.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Show X-Axis Title")));
                this.m_lineLabel.setText(this.rBundle.getString("X-Axis line options"));
                this.m_fontButton.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("X-Title Font")));
                this.m_fontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("X-Title Font")));
                this.m_fontButton.setDialogTitle(this.rBundle.getString("X-Title Font For FontButton"));
                this.m_fontButton.setRotationButtonMask(0);
                this.m_scaleFontButton.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("Format Axis Labels")));
                this.m_scaleFontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Format Axis Labels")));
                this.m_font = this.m_graph.getX1Title().getFont();
                this.m_oldAxisColor = this.m_graph.getX1Axis().getLineColor();
                this.m_oldAxisTitle = this.m_token.getTokenString(this.m_graph.getX1Title().getUnParseText());
                this.m_oldLineWidth = this.m_graph.getX1Axis().getLineWidth();
                if (this.m_oldLineWidth == 0) {
                    this.m_oldLineWidth = 1;
                }
                this.m_oldMinimum = this.m_graph.getX1Axis().getAxisMinValue();
                this.m_oldMaximum = this.m_graph.getX1Axis().getAxisMaxValue();
                this.m_oldIncrement = this.m_graph.getX1Axis().getMajorTickStep();
                this.m_axisTitle.setText(this.m_token.getTokenString(this.m_graph.getX1Title().getUnParseText()));
                if (this.m_axisTitle.getText() != null) {
                    this.m_axisTitle.setCaretPosition(this.m_axisTitle.getText().length());
                }
                this.m_showAxis.setSelected(this.m_graph.getX1Title().isVisible());
                this.m_fontButton.setComponentFont(this.m_graph.getX1Title().getFont());
                if (this.m_graph.getX1Title().getGraphFont().getGraphFontStyle() >= 4) {
                    this.m_fontButton.setUnderlineStyle(true);
                    this.m_axisTitle.setUnderline(true);
                } else {
                    this.m_fontButton.setUnderlineStyle(false);
                    this.m_axisTitle.setUnderline(false);
                }
                this.m_axisTitle.setHorizontalAlignment(this.m_graph.getX1Title().getHorizontalAlignment());
                this.m_fontButton.setPaneHorizontalAlignment(this.m_graph.getX1Title().getHorizontalAlignment());
                this.m_fontButton.setComponentForeground(this.m_graph.getX1Title().getGraphFont().getGraphFontColor());
                this.m_fontButton.setTextRotation(this.convertToFontButtonConstants(this.m_graph.getX1Title().getTextRotation()));
                Color color = this.m_graph.getX1Axis().getLineColor();
                if (!this.m_bColorPaletteSet) {
                    if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_colorButton.getColorPalette(), (Color)color)) {
                        this.m_colorButton.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_colorButton.getColorPalette(), (Color)color, (boolean)this.m_bColorPaletteSet));
                    }
                    this.m_colorButton.setSelectedColor(color);
                } else {
                    this.m_colorButton.setSelectedColor(this.m_colorButton.getClosestColor(color));
                }
                this.m_lColor = color;
                this.m_lineWidth.setLineWidth(this.m_graph.getX1Axis().getLineWidth());
                this.m_minimumBox.setSelected(this.m_graph.getX1Axis().isAxisMinAutoScaled());
                this.m_maximumBox.setSelected(this.m_graph.getX1Axis().isAxisMaxAutoScaled());
                this.m_incrementBox.setSelected(this.m_graph.getX1Axis().isMajorTickStepAutomatic());
                this.m_incrChecked = this.m_incrementBox.isSelected();
                if (this.m_minimumBox.isSelected()) {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getX1Axis().getAxisMinAutoValue()));
                } else {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getX1Axis().getAxisMinValue()));
                }
                if (this.m_maximumBox.isSelected()) {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getX1Axis().getAxisMaxAutoValue()));
                } else {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getX1Axis().getAxisMaxValue()));
                }
                if (this.m_incrementBox.isSelected()) {
                    this.m_incrementField.setNumber(new Double(this.m_graph.getX1Axis().getAutoMajorTickStep()));
                } else {
                    this.m_incrementField.setNumber(new Double(this.m_graph.getX1Axis().getMajorTickStep()));
                }
                if (this.m_minimumBox.isSelected()) {
                    this.m_minimumField.setEnabled(false);
                }
                if (this.m_maximumBox.isSelected()) {
                    this.m_maximumField.setEnabled(false);
                }
                if (this.m_incrementBox.isSelected()) {
                    this.m_incrementField.setEnabled(false);
                }
                this.m_logarithmicBox.setSelected(this.m_graph.getX1Axis().isScaledLogarithmic());
                this._setLogChoiceIndex(this.m_graph.getX1Axis().getLogarithmicBase());
                this.m_logChoice.setEnabled(this.m_logarithmicBox.isSelected());
                this.m_base.setEnabled(this.m_logarithmicBox.isSelected());
                if (this.m_graph.getGraphType() == 65 || this.m_graph.getGraphType() == 66) {
                    this.m_axisLineSeparatorPanel.setVisible(false);
                    this.m_axisTitlePanel.setVisible(false);
                    this.m_lineWidthPanel.setVisible(false);
                    break;
                }
                if (this.isPieGraph()) {
                    this.m_axisLinePanel.setVisible(false);
                    this.m_axisLineSeparatorPanel.setVisible(false);
                    break;
                }
                this.m_axisTitlePanel.setVisible(true);
                this.m_lineWidthPanel.setVisible(true);
                this.m_axisLineSeparatorPanel.setVisible(true);
                this.m_axisLinePanel.setVisible(true);
                break;
            }
            case 46: {
                this.setTitleText(this.rBundle.getString("Y1-Axis options"));
                this.m_showAxis.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("Show Y1-Axis Title")));
                this.m_showAxis.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Show Y1-Axis Title")));
                this.m_lineLabel.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("Y1-Axis line options")));
                this.m_fontButton.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("Y1-Title Font")));
                this.m_fontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Y1-Title Font")));
                this.m_fontButton.setDialogTitle(this.rBundle.getString("Y1-Title Font For FontButton"));
                this.m_scaleFontButton.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("Format Axis Labels")));
                this.m_scaleFontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Format Axis Labels")));
                this.m_font = this.m_graph.getY1Title().getFont();
                this.m_oldAxisColor = this.m_graph.getY1Axis().getLineColor();
                this.m_oldAxisTitle = this.m_token.getTokenString(this.m_graph.getY1Title().getUnParseText());
                this.m_oldLineWidth = this.m_graph.getY1Axis().getLineWidth();
                if (this.m_oldLineWidth == 0) {
                    this.m_oldLineWidth = 1;
                }
                this.m_axisTitle.setText(this.m_token.getTokenString(this.m_graph.getY1Title().getUnParseText()));
                if (this.m_axisTitle.getText() != null) {
                    this.m_axisTitle.setCaretPosition(this.m_axisTitle.getText().length());
                }
                this.m_showAxis.setSelected(this.m_graph.getY1Title().isVisible());
                this.m_fontButton.setComponentFont(this.m_graph.getY1Title().getFont());
                if (this.m_graph.getY1Title().getGraphFont().getGraphFontStyle() >= 4) {
                    this.m_fontButton.setUnderlineStyle(true);
                    this.m_axisTitle.setUnderline(true);
                } else {
                    this.m_fontButton.setUnderlineStyle(false);
                    this.m_axisTitle.setUnderline(false);
                }
                this.m_axisTitle.setHorizontalAlignment(this.m_graph.getY1Title().getHorizontalAlignment());
                this.m_fontButton.setPaneHorizontalAlignment(this.m_graph.getY1Title().getHorizontalAlignment());
                this.m_fontButton.setComponentForeground(this.m_graph.getY1Title().getGraphFont().getGraphFontColor());
                this.m_fontButton.setTextRotation(this.convertToFontButtonConstants(this.m_graph.getY1Title().getTextRotation()));
                this.m_lineWidth.setLineWidth(this.m_graph.getY1Axis().getLineWidth());
                Color color = this.m_graph.getY1Axis().getLineColor();
                if (!this.m_bColorPaletteSet) {
                    if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_colorButton.getColorPalette(), (Color)color)) {
                        this.m_colorButton.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_colorButton.getColorPalette(), (Color)color, (boolean)this.m_bColorPaletteSet));
                    }
                    this.m_colorButton.setSelectedColor(color);
                } else {
                    this.m_colorButton.setSelectedColor(this.m_colorButton.getClosestColor(color));
                }
                this.m_lColor = color;
                this.m_baselineField.setNumber(new Double(this.m_graph.getY1BaseLine().getValue()));
                this.m_minimumBox.setSelected(this.m_graph.getY1Axis().isAxisMinAutoScaled());
                this.m_maximumBox.setSelected(this.m_graph.getY1Axis().isAxisMaxAutoScaled());
                this.m_incrementBox.setSelected(this.m_graph.getY1Axis().isMajorTickStepAutomatic());
                this.m_incrChecked = this.m_incrementBox.isSelected();
                if (this.m_incrementBox.isSelected()) {
                    this.m_incrementField.setNumber(new Double(this.m_graph.getY1Axis().getAutoMajorTickStep()));
                } else {
                    this.m_incrementField.setNumber(new Double(this.m_graph.getY1Axis().getMajorTickStep()));
                }
                if (this.m_minimumBox.isSelected()) {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getY1Axis().getAxisMinAutoValue()));
                } else {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getY1Axis().getAxisMinValue()));
                }
                if (this.m_maximumBox.isSelected()) {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getY1Axis().getAxisMaxAutoValue()));
                } else {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getY1Axis().getAxisMaxValue()));
                }
                if (this.m_minimumBox.isSelected()) {
                    this.m_minimumField.setEnabled(false);
                }
                if (this.m_maximumBox.isSelected()) {
                    this.m_maximumField.setEnabled(false);
                }
                if (this.m_incrementBox.isSelected()) {
                    this.m_incrementField.setEnabled(false);
                }
                if (this.m_graph.getGraphType() != 96) {
                    this.logarithmic.setVisible(true);
                    this.m_logarithmicBox.setSelected(this.m_graph.getY1Axis().isScaledLogarithmic());
                } else {
                    this.logarithmic.setVisible(false);
                }
                this._setLogChoiceIndex(this.m_graph.getY1Axis().getLogarithmicBase());
                this.m_logChoice.setEnabled(this.m_logarithmicBox.isSelected());
                this.m_base.setEnabled(this.m_logarithmicBox.isSelected());
                if (this.m_graph.getGraphType() >= 0 && this.m_graph.getGraphType() <= 14 || this.isPieGraph()) {
                    this.m_axisLineSeparatorPanel.setVisible(false);
                    this.m_axisLinePanel.setVisible(false);
                    break;
                }
                this.m_axisLinePanel.setVisible(true);
                break;
            }
            case 51: {
                this.setTitleText(this.rBundle.getString("Y2-Axis options"));
                this.m_showAxis.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("Show Y2-Axis Title")));
                this.m_showAxis.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Show Y2-Axis Title")));
                this.m_lineLabel.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("Y2-Axis line options")));
                this.m_fontButton.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("Y2-Title Font")));
                this.m_fontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Y2-Title Font")));
                this.m_fontButton.setDialogTitle(this.rBundle.getString("Y2-Title Font For FontButton"));
                this.m_scaleFontButton.setText(StringUtils.stripMnemonic((String)this.rBundle.getString("Format Axis Labels")));
                this.m_scaleFontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.rBundle.getString("Format Axis Labels")));
                this.m_font = this.m_graph.getY2Title().getFont();
                this.m_oldAxisColor = this.m_graph.getY2Axis().getLineColor();
                this.m_oldAxisTitle = this.m_token.getTokenString(this.m_graph.getY2Title().getUnParseText());
                this.m_oldLineWidth = this.m_graph.getY2Axis().getLineWidth();
                if (this.m_oldLineWidth == 0) {
                    this.m_oldLineWidth = 1;
                }
                this.m_axisTitle.setText(this.m_token.getTokenString(this.m_graph.getY2Title().getUnParseText()));
                if (this.m_axisTitle.getText() != null) {
                    this.m_axisTitle.setCaretPosition(this.m_axisTitle.getText().length());
                }
                this.m_showAxis.setSelected(this.m_graph.getY2Title().isVisible());
                this.m_fontButton.setComponentFont(this.m_graph.getY2Title().getFont());
                if (this.m_graph.getY2Title().getGraphFont().getGraphFontStyle() >= 4) {
                    this.m_fontButton.setUnderlineStyle(true);
                    this.m_axisTitle.setUnderline(true);
                } else {
                    this.m_fontButton.setUnderlineStyle(false);
                    this.m_axisTitle.setUnderline(false);
                }
                this.m_axisTitle.setHorizontalAlignment(this.m_graph.getY2Title().getHorizontalAlignment());
                this.m_fontButton.setPaneHorizontalAlignment(this.m_graph.getY2Title().getHorizontalAlignment());
                this.m_fontButton.setComponentForeground(this.m_graph.getY2Title().getGraphFont().getGraphFontColor());
                this.m_fontButton.setTextRotation(this.convertToFontButtonConstants(this.m_graph.getY2Title().getTextRotation()));
                this.m_lineWidth.setLineWidth(this.m_graph.getY2Axis().getLineWidth());
                Color color = this.m_graph.getY2Axis().getLineColor();
                if (!this.m_bColorPaletteSet) {
                    if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_colorButton.getColorPalette(), (Color)color)) {
                        this.m_colorButton.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_colorButton.getColorPalette(), (Color)color, (boolean)this.m_bColorPaletteSet));
                    }
                    this.m_colorButton.setSelectedColor(color);
                } else {
                    this.m_colorButton.setSelectedColor(this.m_colorButton.getClosestColor(color));
                }
                this.m_lColor = color;
                this.m_baselineField.setNumber(new Double(this.m_graph.getY2BaseLine().getValue()));
                this.m_minimumBox.setSelected(this.m_graph.getY2Axis().isAxisMinAutoScaled());
                this.m_maximumBox.setSelected(this.m_graph.getY2Axis().isAxisMaxAutoScaled());
                this.m_incrementBox.setSelected(this.m_graph.getY2Axis().isMajorTickStepAutomatic());
                if (this.m_incrementBox.isSelected()) {
                    this.m_incrementField.setNumber(new Double(this.m_graph.getY2Axis().getAutoMajorTickStep()));
                } else {
                    this.m_incrementField.setNumber(new Double(this.m_graph.getY2Axis().getMajorTickStep()));
                }
                if (this.m_minimumBox.isSelected()) {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getY2Axis().getAxisMinAutoValue()));
                } else {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getY2Axis().getAxisMinValue()));
                }
                if (this.m_maximumBox.isSelected()) {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getY2Axis().getAxisMaxAutoValue()));
                } else {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getY2Axis().getAxisMaxValue()));
                }
                if (this.m_minimumBox.isSelected()) {
                    this.m_minimumField.setEnabled(false);
                }
                if (this.m_maximumBox.isSelected()) {
                    this.m_maximumField.setEnabled(false);
                }
                if (this.m_incrementBox.isSelected()) {
                    this.m_incrementField.setEnabled(false);
                }
                this.m_incrChecked = this.m_incrementBox.isSelected();
                this._setLogChoiceIndex(this.m_graph.getY2Axis().getLogarithmicBase());
                if (this.m_graph.getGraphType() != 96) {
                    this.logarithmic.setVisible(true);
                    this.m_logarithmicBox.setSelected(this.m_graph.getY2Axis().isScaledLogarithmic());
                } else {
                    this.logarithmic.setVisible(false);
                }
                this.m_logChoice.setEnabled(this.m_logarithmicBox.isSelected());
                this.m_base.setEnabled(this.m_logarithmicBox.isSelected());
                if (this.m_graph.getGraphType() >= 0 && this.m_graph.getGraphType() <= 14 || this.isPieGraph()) {
                    this.m_axisLineSeparatorPanel.setVisible(false);
                    this.m_axisLinePanel.setVisible(false);
                    break;
                }
                this.m_axisLinePanel.setVisible(true);
            }
        }
        this.m_lineWidth.setCellColor(this.m_colorButton.getSelectedColor());
        this.m_axisTitle.setForeground(this.m_fontButton.getComponentForeground());
        Font f = this.m_fontButton.getComponentFont();
        this.m_axisTitle.setFont(new Font(f.getName(), f.getStyle(), this.m_axisTitle.getFont().getSize()));
        if (this.m_logarithmicBox.isSelected()) {
            this.m_incrementBox.setSelected(true);
            this.m_incrementBox.setEnabled(false);
        }
        if (this.isPercentGraph()) {
            this.minimum.setVisible(false);
            this.maximum.setVisible(false);
            this.increment.setVisible(false);
            this.logarithmic.setVisible(false);
            this.m_optionsLabelPanel.setVisible(false);
            this.m_optionSeparatorPanel.setVisible(false);
        }
        if (this.m_graph.getGraphType() == 96 || this.isPieGraph()) {
            this.minimum.setVisible(false);
            this.maximum.setVisible(false);
            if (this.m_graph.getGraphType() != 96) {
                this.logarithmic.setVisible(false);
            }
        }
        this.m_referenceLine = new ReferenceLine(this.m_graph, this.m_componentID);
        this.m_bLineWidthChanged = false;
        this.m_bLineColorChanged = false;
        this.m_bTitleTextChanged = false;
        this.m_bTitleVisibleChanged = false;
        this.m_bScaleLogarithmicChanged = false;
        this.m_bLogarithmicBaseChanged = false;
        if (this.m_graph.getGraphType() >= 55 && this.m_graph.getGraphType() <= 60 || this.m_graph.getGraphType() >= 93 && this.m_graph.getGraphType() <= 94 || this.m_graph.getGraphType() >= 0 && this.m_graph.getGraphType() <= 14 || this.m_graph.getGraphType() >= 70 && this.m_graph.getGraphType() <= 84 || this.m_graph.getGraphType() == 88) {
            this.m_referenceLineButton.setVisible(false);
        } else {
            this.m_referenceLineButton.setVisible(true);
        }
        this.calculatePanelSizes();
        this.calculatePreferredSize();
        this.m_maximumField.setCaretPosition(0);
        this.m_maximumField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (ValueAxis.this.getToolkit().getFontMetrics(ValueAxis.this.m_maximumField.getFont()).stringWidth(ValueAxis.this.m_maximumField.getText()) > ValueAxis.this.m_maximumField.getSize().width) {
                    ValueAxis.this.m_maximumField.setToolTipText(ValueAxis.this.m_maximumField.getText());
                } else {
                    ValueAxis.this.m_maximumField.setToolTipText(null);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ValueAxis.this.m_maximumField.setToolTipText(null);
            }
        });
        this.m_minimumField.setCaretPosition(0);
        this.m_minimumField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (ValueAxis.this.getToolkit().getFontMetrics(ValueAxis.this.m_minimumField.getFont()).stringWidth(ValueAxis.this.m_minimumField.getText()) > ValueAxis.this.m_minimumField.getSize().width) {
                    ValueAxis.this.m_minimumField.setToolTipText(ValueAxis.this.m_minimumField.getText());
                } else {
                    ValueAxis.this.m_minimumField.setToolTipText(null);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ValueAxis.this.m_minimumField.setToolTipText(null);
            }
        });
        this.m_incrementField.setCaretPosition(0);
        this.m_incrementField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (ValueAxis.this.getToolkit().getFontMetrics(ValueAxis.this.m_incrementField.getFont()).stringWidth(ValueAxis.this.m_incrementField.getText()) > ValueAxis.this.m_incrementField.getSize().width) {
                    ValueAxis.this.m_incrementField.setToolTipText(ValueAxis.this.m_incrementField.getText());
                } else {
                    ValueAxis.this.m_incrementField.setToolTipText(null);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ValueAxis.this.m_incrementField.setToolTipText(null);
            }
        });
        this.m_baselineField.setCaretPosition(0);
        this.m_baselineField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (ValueAxis.this.getToolkit().getFontMetrics(ValueAxis.this.m_baselineField.getFont()).stringWidth(ValueAxis.this.m_baselineField.getText()) > ValueAxis.this.m_baselineField.getSize().width) {
                    ValueAxis.this.m_baselineField.setToolTipText(ValueAxis.this.m_baselineField.getText());
                } else {
                    ValueAxis.this.m_baselineField.setToolTipText(null);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ValueAxis.this.m_baselineField.setToolTipText(null);
            }
        });
    }

    private void calculatePanelSizes() {
        int pWidth = Math.max(this.m_lineLabel.getPreferredSize().width, this.axisLinePanel.getPreferredSize().width);
        int pHeight = this.m_lineLabel.getPreferredSize().height + 5 + this.axisLinePanel.getPreferredSize().height;
        this.m_axisLinePanel.setPreferredSize(new Dimension(pWidth, pHeight));
        this.m_axisLinePanel.setMinimumSize(this.m_axisLinePanel.getPreferredSize());
        this.m_axisLinePanel.setMaximumSize(this.m_axisLinePanel.getPreferredSize());
        pWidth = this.m_optionsLabel.getPreferredSize().width;
        pHeight = this.m_optionsLabel.getPreferredSize().height + 5;
        this.m_optionsLabelPanel.setPreferredSize(new Dimension(pWidth, pHeight));
        this.m_optionsLabelPanel.setMinimumSize(this.m_optionsLabelPanel.getPreferredSize());
        this.m_optionsLabelPanel.setMaximumSize(this.m_optionsLabelPanel.getPreferredSize());
        int minimumWidth = this.getToolkit().getFontMetrics(this.minimumLabel.getFont()).stringWidth(this.minimumLabel.getText());
        int maximumWidth = this.getToolkit().getFontMetrics(this.maximumLabel.getFont()).stringWidth(this.maximumLabel.getText());
        int incrementWidth = this.getToolkit().getFontMetrics(this.incrementLabel.getFont()).stringWidth(this.incrementLabel.getText());
        int baselineWidth = this.getToolkit().getFontMetrics(this.baselineLabel.getFont()).stringWidth(this.baselineLabel.getText());
        int width = this.isBaselineGraph() ? Math.max(Math.max(minimumWidth, maximumWidth), Math.max(incrementWidth, baselineWidth)) : Math.max(minimumWidth, Math.max(maximumWidth, incrementWidth));
        this.minimumLabel.setPreferredSize(new Dimension(width, this.minimumLabel.getPreferredSize().height));
        this.minimumLabel.setMinimumSize(this.minimumLabel.getPreferredSize());
        this.minimumLabel.setMaximumSize(this.minimumLabel.getPreferredSize());
        this.maximumLabel.setPreferredSize(this.minimumLabel.getPreferredSize());
        this.maximumLabel.setMinimumSize(this.minimumLabel.getPreferredSize());
        this.maximumLabel.setMaximumSize(this.minimumLabel.getPreferredSize());
        this.incrementLabel.setPreferredSize(this.minimumLabel.getPreferredSize());
        this.incrementLabel.setMinimumSize(this.minimumLabel.getPreferredSize());
        this.incrementLabel.setMaximumSize(this.minimumLabel.getPreferredSize());
        this.baselineLabel.setPreferredSize(this.minimumLabel.getPreferredSize());
        this.baselineLabel.setMinimumSize(this.minimumLabel.getPreferredSize());
        this.baselineLabel.setMaximumSize(this.minimumLabel.getPreferredSize());
        this.m_minimumField.setPreferredSize(new Dimension(110, 20));
        this.m_minimumField.setMinimumSize(this.m_minimumField.getPreferredSize());
        this.m_minimumField.setMaximumSize(this.m_minimumField.getPreferredSize());
        pWidth = this.minimumLabel.getPreferredSize().width + 12 + this.m_minimumField.getPreferredSize().width + 5 + this.m_minimumBox.getPreferredSize().width;
        pHeight = Math.max(this.minimumLabel.getPreferredSize().height, Math.max(this.m_minimumField.getPreferredSize().height, this.m_minimumBox.getPreferredSize().height));
        this.minimum.setPreferredSize(new Dimension(pWidth, pHeight));
        this.minimum.setMinimumSize(this.minimum.getPreferredSize());
        this.minimum.setMaximumSize(this.minimum.getPreferredSize());
        this.m_maximumField.setPreferredSize(new Dimension(110, 20));
        this.m_maximumField.setMinimumSize(this.m_maximumField.getPreferredSize());
        this.m_maximumField.setMaximumSize(this.m_maximumField.getPreferredSize());
        pWidth = this.maximumLabel.getPreferredSize().width + 12 + this.m_maximumField.getPreferredSize().width + 5 + this.m_maximumBox.getPreferredSize().width;
        pHeight = Math.max(this.maximumLabel.getPreferredSize().height, Math.max(this.m_maximumField.getPreferredSize().height, this.m_maximumBox.getPreferredSize().height)) + 5;
        this.maximum.setPreferredSize(new Dimension(pWidth, pHeight));
        this.maximum.setMinimumSize(this.maximum.getPreferredSize());
        this.maximum.setMaximumSize(this.maximum.getPreferredSize());
        this.m_incrementField.setPreferredSize(new Dimension(110, 20));
        this.m_incrementField.setMinimumSize(this.m_incrementField.getPreferredSize());
        this.m_incrementField.setMaximumSize(this.m_incrementField.getPreferredSize());
        pWidth = this.incrementLabel.getPreferredSize().width + 12 + this.m_incrementField.getPreferredSize().width + 5 + this.m_incrementBox.getPreferredSize().width;
        pHeight = Math.max(this.incrementLabel.getPreferredSize().height, Math.max(this.m_incrementField.getPreferredSize().height, this.m_incrementBox.getPreferredSize().height)) + 5;
        this.increment.setPreferredSize(new Dimension(pWidth, pHeight));
        this.increment.setMinimumSize(this.increment.getPreferredSize());
        this.increment.setMaximumSize(this.increment.getPreferredSize());
        this.m_baselineField.setPreferredSize(new Dimension(110, 20));
        this.m_baselineField.setMinimumSize(this.m_baselineField.getPreferredSize());
        this.m_baselineField.setMaximumSize(this.m_baselineField.getPreferredSize());
        pWidth = this.baselineLabel.getPreferredSize().width + 12 + this.m_baselineField.getPreferredSize().width;
        pHeight = Math.max(this.baselineLabel.getPreferredSize().height, this.m_baselineField.getPreferredSize().height) + 5;
        this.baseline.setPreferredSize(new Dimension(pWidth, pHeight));
        this.baseline.setMinimumSize(this.baseline.getPreferredSize());
        this.baseline.setMaximumSize(this.baseline.getPreferredSize());
        this.m_logChoice.setPreferredSize(new Dimension(50, 25));
        this.m_logChoice.setMinimumSize(this.m_logChoice.getPreferredSize());
        this.m_logChoice.setMaximumSize(this.m_logChoice.getPreferredSize());
        pWidth = this.m_logarithmicBox.getPreferredSize().width + 24 + this.m_base.getPreferredSize().width + 12 + this.m_logChoice.getPreferredSize().width;
        pHeight = Math.max(this.m_logarithmicBox.getPreferredSize().height, Math.max(this.m_base.getPreferredSize().height, this.m_logChoice.getPreferredSize().height)) + 5;
        this.logarithmic.setPreferredSize(new Dimension(pWidth, pHeight));
        this.logarithmic.setMinimumSize(this.logarithmic.getPreferredSize());
        this.logarithmic.setMaximumSize(this.logarithmic.getPreferredSize());
    }

    private void calculatePreferredSize() {
        int maxWidth = 0;
        int pWidth = this.m_axisTitlePanel.getPreferredSize().width;
        if (maxWidth < pWidth) {
            maxWidth = pWidth;
        }
        if (maxWidth < (pWidth = this.m_axisLinePanel.getPreferredSize().width)) {
            maxWidth = pWidth;
        }
        if (!this.isPercentGraph()) {
            pWidth = this.m_optionsLabelPanel.getPreferredSize().width;
            if (maxWidth < pWidth) {
                maxWidth = pWidth;
            }
            if (maxWidth < (pWidth = this.minimum.getPreferredSize().width)) {
                maxWidth = pWidth;
            }
            if (maxWidth < (pWidth = this.maximum.getPreferredSize().width)) {
                maxWidth = pWidth;
            }
            if (maxWidth < (pWidth = this.increment.getPreferredSize().width)) {
                maxWidth = pWidth;
            }
        }
        if (this.isBaselineGraph() && maxWidth < (pWidth = this.baseline.getPreferredSize().width)) {
            maxWidth = pWidth;
        }
        if (maxWidth < (pWidth = this.logarithmic.getPreferredSize().width)) {
            maxWidth = pWidth;
        }
        if (maxWidth < (pWidth = this.m_buttonPanel.getPreferredSize().width)) {
            maxWidth = pWidth;
        }
        pWidth = maxWidth + 10 + 10;
        int pHeight = 10 + this.m_label.getPreferredSize().height + 15 + this.m_axisTitlePanel.getPreferredSize().height + 15 + this.m_axisLinePanel.getPreferredSize().height + 15 + this.m_optionsLabelPanel.getPreferredSize().height + this.minimum.getPreferredSize().height + this.maximum.getPreferredSize().height + this.increment.getPreferredSize().height + this.baseline.getPreferredSize().height + this.logarithmic.getPreferredSize().height + 15 + this.m_buttonPanel.getPreferredSize().height + 10;
        if (!this.isBaselineGraph()) {
            pHeight -= this.baseline.getPreferredSize().height;
        }
        switch (this.m_componentID) {
            case 41: {
                if (this.m_graph.getGraphType() == 65 || this.m_graph.getGraphType() == 66) {
                    pHeight -= this.m_axisTitlePanel.getPreferredSize().height + 15;
                    break;
                }
                if (!this.isPieGraph()) break;
                pHeight -= 15 + this.m_axisLinePanel.getPreferredSize().height;
                break;
            }
            case 46: 
            case 51: {
                if (this.m_graph.getGraphType() == 96) {
                    pHeight -= this.logarithmic.getPreferredSize().height;
                }
                if ((this.m_graph.getGraphType() < 0 || this.m_graph.getGraphType() > 14) && !this.isPieGraph()) break;
                pHeight -= 15 + this.m_axisLinePanel.getPreferredSize().height;
            }
        }
        if (this.isPercentGraph()) {
            pHeight -= 15 + this.m_optionsLabelPanel.getPreferredSize().height + this.minimum.getPreferredSize().height + this.maximum.getPreferredSize().height + this.increment.getPreferredSize().height + this.logarithmic.getPreferredSize().height;
        }
        if (this.m_graph.getGraphType() == 96 || this.isPieGraph()) {
            pHeight -= this.minimum.getPreferredSize().height + this.maximum.getPreferredSize().height;
            if (this.m_graph.getGraphType() != 96) {
                pHeight -= this.logarithmic.getPreferredSize().height;
            }
        }
        this.prefSize = new Dimension(pWidth, pHeight);
    }

    @Override
    public void apply() {
        this.applyAfterCheck();
    }

    public boolean applyAfterCheck() {
        if (!this.checkForBadInput()) {
            return false;
        }
        if (this.m_bReferenceLineChanged) {
            this.m_referenceLine.apply();
        }
        switch (this.m_componentID) {
            case 41: {
                Double incr;
                if (this.m_graph.getGraphType() != 65 && this.m_graph.getGraphType() != 66) {
                    int rotation;
                    if (this.m_bTitleTextChanged) {
                        this.m_graph.getX1Title().setText(this.m_token.getKeyString(this.m_axisTitle.getText()));
                    }
                    if (this.m_bTitleVisibleChanged) {
                        this.m_graph.getX1Title().setVisible(this.m_showAxis.isSelected());
                    }
                    if (this.m_bTitleFontNameChanged) {
                        this.m_graph.getX1Title().getGraphFont().setGraphFontTypeface(this.m_fontButton.getComponentFont().getName());
                    }
                    if (this.m_bTitleFontSizeChanged) {
                        this.m_graph.getX1Title().getGraphFont().setGraphFontSize(this.m_fontButton.getComponentFont().getSize());
                    }
                    if (this.m_bTitleFontBoldChanged) {
                        this.m_graph.getX1Title().getGraphFont().setFontBold(this.m_fontButton.getComponentFont().isBold());
                    }
                    if (this.m_bTitleFontItalicChanged) {
                        this.m_graph.getX1Title().getGraphFont().setFontItalic(this.m_fontButton.getComponentFont().isItalic());
                    }
                    if (this.m_bTitleFontUnderlineChanged) {
                        this.m_graph.getX1Title().getGraphFont().setUnderline(this.m_fontButton.isUnderlineStyle());
                    }
                    if (this.m_bTitleRotationChanged && (rotation = this.convertFromFontButtonConstants(this.m_fontButton.getTextRotation())) != -1) {
                        this.m_graph.getX1Title().setTextRotation(rotation);
                    }
                    if (this.m_bTitleAlignmentChanged) {
                        this.m_graph.getX1Title().setHorizontalAlignment(this.m_fontButton.getPaneHorizontalAlignment());
                    }
                    if (this.m_bTitleFontColorChanged) {
                        this.m_graph.getX1Title().getGraphFont().setGraphFontColor(this.m_fontButton.getComponentForeground());
                    }
                    if (this.m_bLineWidthChanged) {
                        this.m_graph.getX1Axis().setLineWidth(this.m_lineWidth.getLineWidth());
                    }
                }
                if (this.m_bLineColorChanged) {
                    this.m_graph.getX1Axis().setLineColor(this.m_colorButton.getSelectedColor());
                }
                this.m_graph.getX1Axis().setMajorTickStepAutomatic(this.m_incrementBox.isSelected());
                boolean applyChanges = false;
                int apply = 0;
                if (this.m_graph.getX1Axis().isAxisMaxAutoScaled() != this.m_maximumBox.isSelected()) {
                    applyChanges = true;
                    apply |= 1;
                }
                if (this.m_graph.getX1Axis().isAxisMinAutoScaled() != this.m_minimumBox.isSelected()) {
                    applyChanges = true;
                    apply |= 2;
                }
                Double min = this.m_minimumField.getNumber();
                if (!this.m_minimumBox.isSelected() && min != null) {
                    applyChanges = true;
                    apply |= 4;
                }
                Double max = this.m_maximumField.getNumber();
                if (!this.m_maximumBox.isSelected() && max != null && this.m_graph.getX1Axis().getAxisMaxValue() != max.doubleValue()) {
                    applyChanges = true;
                    apply |= 8;
                }
                if (applyChanges) {
                    if ((apply & 1) != 0) {
                        this.m_graph.getX1Axis().setAxisMaxAutoScaled(this.m_maximumBox.isSelected());
                    }
                    if ((apply & 2) != 0) {
                        this.m_graph.getX1Axis().setAxisMinAutoScaled(this.m_minimumBox.isSelected());
                    }
                    if ((apply & 4) != 0) {
                        this.m_graph.getX1Axis().setAxisMinValue(min);
                    }
                    if ((apply & 8) != 0) {
                        this.m_graph.getX1Axis().setAxisMaxValue(max);
                    }
                }
                if (!this.m_incrementBox.isSelected() && (incr = this.m_incrementField.getNumber()) != null) {
                    this.m_graph.getX1Axis().setMajorTickStep(incr);
                }
                if (this.m_bScaleLogarithmicChanged) {
                    this.m_graph.getX1Axis().setScaledLogarithmic(this.m_logarithmicBox.isSelected());
                }
                if (this.m_formatDialog != null) {
                    if (this.m_bLabelFontNameChanged) {
                        this.m_graph.getX1TickLabel().getGraphFont().setGraphFontTypeface(this.m_formatDialog.getComponentFont().getName());
                    }
                    if (this.m_bLabelFontSizeChanged) {
                        this.m_graph.getX1TickLabel().getGraphFont().setGraphFontSize(this.m_formatDialog.getComponentFont().getSize());
                    }
                    if (this.m_bLabelFontBoldChanged) {
                        this.m_graph.getX1TickLabel().getGraphFont().setFontBold(this.m_formatDialog.getComponentFont().isBold());
                    }
                    if (this.m_bLabelFontItalicChanged) {
                        this.m_graph.getX1TickLabel().getGraphFont().setFontItalic(this.m_formatDialog.getComponentFont().isItalic());
                    }
                    if (this.m_bLabelFontUnderlineChanged) {
                        this.m_graph.getX1TickLabel().getGraphFont().setUnderline(this.m_formatDialog.isUnderlineStyle());
                    }
                    if (this.m_bLabelFontColorChanged) {
                        this.m_graph.getX1TickLabel().getGraphFont().setGraphFontColor(this.m_formatDialog.getComponentForeground());
                    }
                    if (this.m_bLabelRotationChanged) {
                        this.m_graph.getX1TickLabel().setTextRotation(this.convertFromFontButtonConstants(this.m_formatDialog.getTextRotation()));
                    }
                }
                if (!this.m_bLogarithmicBaseChanged) break;
                this.m_graph.getX1Axis().setLogarithmicBase(this.m_currentLogBase);
                break;
            }
            case 46: {
                Double blY1;
                Double incr;
                int rotation;
                if (this.m_bTitleTextChanged) {
                    this.m_graph.getY1Title().setText(this.m_token.getKeyString(this.m_axisTitle.getText()));
                }
                if (this.m_bTitleVisibleChanged) {
                    this.m_graph.getY1Title().setVisible(this.m_showAxis.isSelected());
                }
                if (this.m_bTitleFontNameChanged) {
                    this.m_graph.getY1Title().getGraphFont().setGraphFontTypeface(this.m_fontButton.getComponentFont().getName());
                }
                if (this.m_bTitleFontSizeChanged) {
                    this.m_graph.getY1Title().getGraphFont().setGraphFontSize(this.m_fontButton.getComponentFont().getSize());
                }
                if (this.m_bTitleFontBoldChanged) {
                    this.m_graph.getY1Title().getGraphFont().setFontBold(this.m_fontButton.getComponentFont().isBold());
                }
                if (this.m_bTitleFontItalicChanged) {
                    this.m_graph.getY1Title().getGraphFont().setFontItalic(this.m_fontButton.getComponentFont().isItalic());
                }
                if (this.m_bTitleFontUnderlineChanged) {
                    this.m_graph.getY1Title().getGraphFont().setUnderline(this.m_fontButton.isUnderlineStyle());
                }
                if (this.m_bTitleAlignmentChanged) {
                    this.m_graph.getY1Title().setHorizontalAlignment(this.m_fontButton.getPaneHorizontalAlignment());
                }
                if (this.m_bTitleFontColorChanged) {
                    this.m_graph.getY1Title().getGraphFont().setGraphFontColor(this.m_fontButton.getComponentForeground());
                }
                if (this.m_bTitleRotationChanged && (rotation = this.convertFromFontButtonConstants(this.m_fontButton.getTextRotation())) != -1) {
                    this.m_graph.getY1Title().setTextRotation(rotation);
                }
                if (this.m_bLineWidthChanged) {
                    this.m_graph.getY1Axis().setLineWidth(this.m_lineWidth.getLineWidth());
                }
                if (this.m_bLineColorChanged) {
                    this.m_graph.getY1Axis().setLineColor(this.m_colorButton.getSelectedColor());
                }
                if (this.m_formatDialog != null) {
                    if (this.m_bLabelFontNameChanged) {
                        this.m_graph.getY1TickLabel().getGraphFont().setGraphFontTypeface(this.m_formatDialog.getComponentFont().getName());
                    }
                    if (this.m_bLabelFontSizeChanged) {
                        this.m_graph.getY1TickLabel().getGraphFont().setGraphFontSize(this.m_formatDialog.getComponentFont().getSize());
                    }
                    if (this.m_bLabelFontBoldChanged) {
                        this.m_graph.getY1TickLabel().getGraphFont().setFontBold(this.m_formatDialog.getComponentFont().isBold());
                    }
                    if (this.m_bLabelFontItalicChanged) {
                        this.m_graph.getY1TickLabel().getGraphFont().setFontItalic(this.m_formatDialog.getComponentFont().isItalic());
                    }
                    if (this.m_bLabelFontUnderlineChanged) {
                        this.m_graph.getY1TickLabel().getGraphFont().setUnderline(this.m_formatDialog.isUnderlineStyle());
                    }
                    if (this.m_bLabelFontColorChanged) {
                        this.m_graph.getY1TickLabel().getGraphFont().setGraphFontColor(this.m_formatDialog.getComponentForeground());
                    }
                    if (this.m_bLabelRotationChanged) {
                        this.m_graph.getY1TickLabel().setTextRotation(this.convertFromFontButtonConstants(this.m_formatDialog.getTextRotation()));
                    }
                }
                if (this.isPercentGraph()) {
                    return true;
                }
                this.m_graph.getY1Axis().setMajorTickStepAutomatic(this.m_incrementBox.isSelected());
                boolean applyChanges = false;
                int apply = 0;
                if (this.m_graph.getY1Axis().isAxisMaxAutoScaled() != this.m_maximumBox.isSelected()) {
                    applyChanges = true;
                    apply |= 1;
                }
                if (this.m_graph.getY1Axis().isAxisMinAutoScaled() != this.m_minimumBox.isSelected()) {
                    applyChanges = true;
                    apply |= 2;
                }
                Double min = this.m_minimumField.getNumber();
                if (!this.m_minimumBox.isSelected() && min != null) {
                    applyChanges = true;
                    apply |= 4;
                }
                Double max = this.m_maximumField.getNumber();
                if (!this.m_maximumBox.isSelected() && max != null && this.m_graph.getY1Axis().getAxisMaxValue() != max.doubleValue()) {
                    applyChanges = true;
                    apply |= 8;
                }
                if (applyChanges) {
                    if ((apply & 1) != 0) {
                        this.m_graph.getY1Axis().setAxisMaxAutoScaled(this.m_maximumBox.isSelected());
                    }
                    if ((apply & 2) != 0) {
                        this.m_graph.getY1Axis().setAxisMinAutoScaled(this.m_minimumBox.isSelected());
                    }
                    if ((apply & 4) != 0) {
                        this.m_graph.getY1Axis().setAxisMinValue(min);
                    }
                    if ((apply & 8) != 0) {
                        this.m_graph.getY1Axis().setAxisMaxValue(max);
                    }
                }
                if (!this.m_incrementBox.isSelected() && (incr = this.m_incrementField.getNumber()) != null) {
                    this.m_graph.getY1Axis().setMajorTickStep(incr);
                }
                if ((blY1 = this.m_baselineField.getNumber()) != null && this.isBaselineGraph()) {
                    this.m_graph.getY1BaseLine().setValue(blY1);
                }
                if (this.m_bScaleLogarithmicChanged) {
                    this.m_graph.getY1Axis().setScaledLogarithmic(this.m_logarithmicBox.isSelected());
                }
                if (!this.m_bLogarithmicBaseChanged) break;
                this.m_graph.getY1Axis().setLogarithmicBase(this.m_currentLogBase);
                break;
            }
            case 51: {
                Double blY2;
                Double incr;
                int rotation;
                if (this.m_bTitleTextChanged) {
                    this.m_graph.getY2Title().setText(this.m_token.getKeyString(this.m_axisTitle.getText()));
                }
                if (this.m_bTitleVisibleChanged) {
                    this.m_graph.getY2Title().setVisible(this.m_showAxis.isSelected());
                }
                if (this.m_bTitleFontNameChanged) {
                    this.m_graph.getY2Title().getGraphFont().setGraphFontTypeface(this.m_fontButton.getComponentFont().getName());
                }
                if (this.m_bTitleFontSizeChanged) {
                    this.m_graph.getY2Title().getGraphFont().setGraphFontSize(this.m_fontButton.getComponentFont().getSize());
                }
                if (this.m_bTitleFontBoldChanged) {
                    this.m_graph.getY2Title().getGraphFont().setFontBold(this.m_fontButton.getComponentFont().isBold());
                }
                if (this.m_bTitleFontItalicChanged) {
                    this.m_graph.getY2Title().getGraphFont().setFontItalic(this.m_fontButton.getComponentFont().isItalic());
                }
                if (this.m_bTitleFontUnderlineChanged) {
                    this.m_graph.getX1Title().getGraphFont().setUnderline(this.m_fontButton.isUnderlineStyle());
                }
                if (this.m_bTitleAlignmentChanged) {
                    this.m_graph.getY2Title().setHorizontalAlignment(this.m_fontButton.getPaneHorizontalAlignment());
                }
                if (this.m_bTitleFontColorChanged) {
                    this.m_graph.getY2Title().getGraphFont().setGraphFontColor(this.m_fontButton.getComponentForeground());
                }
                if (this.m_bTitleRotationChanged && (rotation = this.convertFromFontButtonConstants(this.m_fontButton.getTextRotation())) != -1) {
                    this.m_graph.getY2Title().setTextRotation(rotation);
                }
                if (this.m_bLineWidthChanged) {
                    this.m_graph.getY2Axis().setLineWidth(this.m_lineWidth.getLineWidth());
                }
                if (this.m_bLineColorChanged) {
                    this.m_graph.getY2Axis().setLineColor(this.m_colorButton.getSelectedColor());
                }
                if (this.m_formatDialog != null) {
                    if (this.m_bLabelFontNameChanged) {
                        this.m_graph.getY2TickLabel().getGraphFont().setGraphFontTypeface(this.m_formatDialog.getComponentFont().getName());
                    }
                    if (this.m_bLabelFontSizeChanged) {
                        this.m_graph.getY2TickLabel().getGraphFont().setGraphFontSize(this.m_formatDialog.getComponentFont().getSize());
                    }
                    if (this.m_bLabelFontBoldChanged) {
                        this.m_graph.getY2TickLabel().getGraphFont().setFontBold(this.m_formatDialog.getComponentFont().isBold());
                    }
                    if (this.m_bLabelFontItalicChanged) {
                        this.m_graph.getY2TickLabel().getGraphFont().setFontItalic(this.m_formatDialog.getComponentFont().isItalic());
                    }
                    if (this.m_bLabelFontUnderlineChanged) {
                        this.m_graph.getY2TickLabel().getGraphFont().setUnderline(this.m_formatDialog.isUnderlineStyle());
                    }
                    if (this.m_bLabelFontColorChanged) {
                        this.m_graph.getY2TickLabel().getGraphFont().setGraphFontColor(this.m_formatDialog.getComponentForeground());
                    }
                    if (this.m_bLabelRotationChanged) {
                        this.m_graph.getY2TickLabel().setTextRotation(this.convertFromFontButtonConstants(this.m_formatDialog.getTextRotation()));
                    }
                }
                this.m_graph.getY2Axis().setMajorTickStepAutomatic(this.m_incrementBox.isSelected());
                if (!this.m_incrementBox.isSelected() && (incr = this.m_incrementField.getNumber()) != null) {
                    this.m_graph.getY2Axis().setMajorTickStep(incr);
                }
                if ((blY2 = this.m_baselineField.getNumber()) != null && this.isBaselineGraph()) {
                    this.m_graph.getY2BaseLine().setValue(blY2);
                }
                if (this.m_graph.getGraphType() == 96) {
                    return true;
                }
                boolean applyChanges = false;
                int apply = 0;
                if (this.m_graph.getY2Axis().isAxisMaxAutoScaled() != this.m_maximumBox.isSelected()) {
                    applyChanges = true;
                    apply |= 1;
                }
                if (this.m_graph.getY2Axis().isAxisMinAutoScaled() != this.m_minimumBox.isSelected()) {
                    applyChanges = true;
                    apply |= 2;
                }
                Double min = this.m_minimumField.getNumber();
                if (!this.m_minimumBox.isSelected() && min != null) {
                    applyChanges = true;
                    apply |= 4;
                }
                Double max = this.m_maximumField.getNumber();
                if (!this.m_maximumBox.isSelected() && max != null && this.m_graph.getY2Axis().getAxisMaxValue() != max.doubleValue()) {
                    applyChanges = true;
                    apply |= 8;
                }
                if (applyChanges) {
                    if ((apply & 1) != 0) {
                        this.m_graph.getY2Axis().setAxisMaxAutoScaled(this.m_maximumBox.isSelected());
                    }
                    if ((apply & 2) != 0) {
                        this.m_graph.getY2Axis().setAxisMinAutoScaled(this.m_minimumBox.isSelected());
                    }
                    if ((apply & 4) != 0) {
                        this.m_graph.getY2Axis().setAxisMinValue(min);
                    }
                    if ((apply & 8) != 0) {
                        this.m_graph.getY2Axis().setAxisMaxValue(max);
                    }
                }
                if (this.m_bLogarithmicBaseChanged) {
                    this.m_graph.getY2Axis().setLogarithmicBase(this.m_currentLogBase);
                }
                if (!this.m_bScaleLogarithmicChanged) break;
                this.m_graph.getY2Axis().setScaledLogarithmic(this.m_logarithmicBox.isSelected());
            }
        }
        if (this.m_formatDialog != null) {
            this.m_formatDialog.applyViewFormat();
        }
        return true;
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        super.caretUpdate(e);
        if (e.getSource() == this.m_minimumField) {
            this.m_minimumField.setToolTipText(null);
            Double d = null;
            try {
                d = new Double(this.m_minimumField.getText());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (d != null) {
                double newValue = d;
                this.firePropertyChange(PROPERTY_AXIS_MIN_VALUE, this.m_oldMinimum, newValue);
                this.m_oldMinimum = newValue;
            }
        } else if (e.getSource() == this.m_maximumField) {
            this.m_maximumField.setToolTipText(null);
            Double d = null;
            try {
                d = new Double(this.m_maximumField.getText());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (d != null) {
                double newValue = d;
                this.firePropertyChange(PROPERTY_AXIS_MAX_VALUE, this.m_oldMaximum, newValue);
                this.m_oldMaximum = newValue;
            }
        } else if (e.getSource() == this.m_incrementField) {
            this.m_incrementField.setToolTipText(null);
            Double d = null;
            try {
                d = new Double(this.m_incrementField.getText());
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            if (d != null) {
                double newValue = d;
                this.firePropertyChange(PROPERTY_AXIS_MAJOR_TICK_STEP, this.m_oldIncrement, newValue);
                this.m_oldIncrement = newValue;
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.m_minimumBox) {
                this.m_minimumField.setEnabled(false);
                this.m_minimumField.setEditable(false);
                this.m_minimumField.setBackground(this.getBackground());
                switch (this.m_componentID) {
                    case 41: {
                        this.m_minimumField.setNumber(new Double(this.m_graph.getX1Axis().getAxisMinAutoValue()));
                        break;
                    }
                    case 46: {
                        this.m_minimumField.setNumber(new Double(this.m_graph.getY1Axis().getAxisMinAutoValue()));
                        break;
                    }
                    case 51: {
                        this.m_minimumField.setNumber(new Double(this.m_graph.getY2Axis().getAxisMinAutoValue()));
                    }
                }
                this.firePropertyChange(PROPERTY_AXIS_AUTO_MIN, false, true);
            } else if (e.getSource() == this.m_maximumBox) {
                this.m_maximumField.setEnabled(false);
                this.m_maximumField.setEditable(false);
                this.m_maximumField.setBackground(this.getBackground());
                switch (this.m_componentID) {
                    case 41: {
                        this.m_maximumField.setNumber(new Double(this.m_graph.getX1Axis().getAxisMaxAutoValue()));
                        break;
                    }
                    case 46: {
                        this.m_maximumField.setNumber(new Double(this.m_graph.getY1Axis().getAxisMaxAutoValue()));
                        break;
                    }
                    case 51: {
                        this.m_maximumField.setNumber(new Double(this.m_graph.getY2Axis().getAxisMaxAutoValue()));
                    }
                }
                this.firePropertyChange(PROPERTY_AXIS_AUTO_MAX, false, true);
            } else if (e.getSource() == this.m_incrementBox) {
                this.m_incrementField.setEnabled(false);
                this.m_incrementField.setEditable(false);
                this.m_incrementField.setBackground(this.getBackground());
                switch (this.m_componentID) {
                    case 41: {
                        double incr = this.m_graph.getX1Axis().getAutoMajorTickStep();
                        this.m_incrementField.setNumber(new Double(incr));
                        break;
                    }
                    case 46: {
                        double incr = this.m_graph.getY1Axis().getAutoMajorTickStep();
                        this.m_incrementField.setNumber(new Double(incr));
                        break;
                    }
                    case 51: {
                        double incr = this.m_graph.getY2Axis().getAutoMajorTickStep();
                        this.m_incrementField.setNumber(new Double(incr));
                    }
                }
                this.firePropertyChange(PROPERTY_AXIS_AUTO_TICK_STEP, false, true);
            } else if (e.getSource() == this.m_logarithmicBox) {
                this.m_incrChecked = this.m_incrementBox.isSelected();
                this.m_incrementBox.setSelected(true);
                this.m_incrementBox.setEnabled(false);
                this.firePropertyChange(PROPERTY_AXIS_LOG_SCALE, false, true);
                this.m_logChoice.setEnabled(true);
                this.m_base.setEnabled(true);
                this.m_bScaleLogarithmicChanged = true;
            } else if (e.getSource() == this.m_logChoice) {
                int index = this.m_logChoice.getSelectedIndex();
                double log = 10.0;
                switch (index) {
                    case 0: {
                        log = 2.0;
                        break;
                    }
                    case 1: {
                        log = Math.E;
                        break;
                    }
                    case 2: {
                        log = 10.0;
                    }
                }
                this.m_currentLogBase = log;
                this.firePropertyChange(PROPERTY_AXIS_LOG_BASE, this.m_oldLogBase, this.m_currentLogBase);
                this.m_oldLogBase = this.m_currentLogBase;
                this.m_bLogarithmicBaseChanged = true;
            }
        } else if (e.getStateChange() == 2) {
            if (e.getSource() == this.m_minimumBox) {
                this.m_minimumField.setEnabled(true);
                this.m_minimumField.setEditable(true);
                this.m_minimumField.setBackground(Color.white);
                switch (this.m_componentID) {
                    case 41: {
                        this.m_minimumField.setNumber(new Double(this.m_graph.getX1Axis().getAxisMinValue()));
                        break;
                    }
                    case 46: {
                        this.m_minimumField.setNumber(new Double(this.m_graph.getY1Axis().getAxisMinAutoValue()));
                        break;
                    }
                    case 51: {
                        this.m_minimumField.setNumber(new Double(this.m_graph.getY2Axis().getAxisMinValue()));
                    }
                }
                this.firePropertyChange(PROPERTY_AXIS_AUTO_MIN, true, false);
            } else if (e.getSource() == this.m_maximumBox) {
                this.m_maximumField.setEnabled(true);
                this.m_maximumField.setEditable(true);
                this.m_maximumField.setBackground(Color.white);
                switch (this.m_componentID) {
                    case 41: {
                        this.m_maximumField.setNumber(new Double(this.m_graph.getX1Axis().getAxisMaxValue()));
                        break;
                    }
                    case 46: {
                        this.m_maximumField.setNumber(new Double(this.m_graph.getY1Axis().getAxisMaxAutoValue()));
                        break;
                    }
                    case 51: {
                        this.m_maximumField.setNumber(new Double(this.m_graph.getY2Axis().getAxisMaxValue()));
                    }
                }
                this.firePropertyChange(PROPERTY_AXIS_AUTO_MAX, true, false);
            } else if (e.getSource() == this.m_incrementBox) {
                this.m_incrementField.setEnabled(true);
                this.m_incrementField.setEditable(true);
                this.m_incrementField.setBackground(Color.white);
                this.firePropertyChange(PROPERTY_AXIS_AUTO_TICK_STEP, true, false);
            } else if (e.getSource() == this.m_logarithmicBox) {
                this.m_incrementBox.setSelected(this.m_incrChecked);
                this.m_incrementBox.setEnabled(true);
                this.firePropertyChange(PROPERTY_AXIS_LOG_SCALE, true, false);
                this.m_logChoice.setEnabled(false);
                this.m_base.setEnabled(false);
                this.m_bScaleLogarithmicChanged = true;
            }
        }
    }

    public String getHelpContextID() {
        return this.getClass().getName();
    }

    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
        if (this.m_formatDialog != null) {
            this.m_formatDialog.setHelpProvider(helpProvider);
        }
        this.m_fontButton.setHelpProvider(helpProvider);
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    public void setMaxMultiplier(int multiplier) {
        this.m_multiplier = multiplier;
    }

    public int getMaxMultiplier() {
        return this.m_multiplier;
    }

    @Override
    public void cleanUp() {
        this.m_minimumBox.removeItemListener(this);
        this.m_maximumBox.removeItemListener(this);
        this.m_incrementBox.removeItemListener(this);
        this.m_logarithmicBox.removeItemListener(this);
        this.m_logChoice.removeItemListener(this);
        if (this.m_formatDialog != null) {
            this.m_formatDialog.removePropertyChangeListener(this);
        }
        this.m_minimumField.removeCaretListener(this);
        this.m_maximumField.removeCaretListener(this);
        this.m_incrementField.removeCaretListener(this);
        this.m_baselineField.removeCaretListener(this);
        this.minimum.remove(this.m_minimumField);
        this.minimumLabel.setLabelFor(null);
        this.m_minimumField.cleanUp();
        this.m_minimumField = null;
        this.maximum.remove(this.m_maximumField);
        this.maximumLabel.setLabelFor(null);
        this.m_maximumField.cleanUp();
        this.m_maximumField = null;
        this.increment.remove(this.m_incrementField);
        this.incrementLabel.setLabelFor(null);
        this.m_incrementField.cleanUp();
        this.m_incrementField = null;
        this.baseline.remove(this.m_baselineField);
        this.baselineLabel.setLabelFor(null);
        this.m_baselineField.cleanUp();
        this.m_baselineField = null;
        super.cleanUp();
    }

    protected boolean checkForBadInput() {
        JDialog tmpDialog;
        JOptionPane jpane;
        String text;
        Object val;
        JDialog tmpDialog2;
        JOptionPane jpane2;
        String errorMsg;
        Object[] args;
        this._initializeCurrentValues();
        boolean log = this.m_logarithmicBox.isSelected();
        boolean autoMin = this.m_minimumBox.isSelected();
        boolean autoMax = this.m_maximumBox.isSelected();
        boolean autoIncr = this.m_incrementBox.isSelected();
        boolean pfjBug = false;
        boolean warnings = false;
        boolean errors = false;
        boolean nonDataErrors = false;
        if (this.m_errorTypes == 65535) {
            warnings = true;
            errors = true;
        } else if (this.m_errorTypes == 1) {
            errors = true;
        } else if (this.m_errorTypes == 2) {
            warnings = true;
        } else if (this.m_errorTypes == 4) {
            nonDataErrors = true;
        }
        if (this.m_baselineField.getNumber() == null && this.isBaselineGraph()) {
            if (errors) {
                ImageIcon icon = new ImageIcon(ImageUtils.getImageResource(ValueAxis.class, (String)"images/stop.gif"));
                String text2 = this.rBundle.getString("Baseline value can't be empty");
                JOptionPane jpane3 = new JOptionPane(text2, 0, -1, icon);
                jpane3.getAccessibleContext().setAccessibleName(text2);
                JDialog tmpDialog3 = jpane3.createDialog(this, this.m_applicationName);
                tmpDialog3.show();
            } else if (this.m_eh != null) {
                this.m_eh.log(this.rBundle.getString("Baseline value can't be empty"), this.getClass().getName(), "checkForBadInput");
            }
            return false;
        }
        if (this.m_minimumField.getNumber() == null && !autoMin) {
            if (errors) {
                ImageIcon icon = new ImageIcon(ImageUtils.getImageResource(ValueAxis.class, (String)"images/stop.gif"));
                String text3 = this.rBundle.getString("Min value can't be empty");
                JOptionPane jpane4 = new JOptionPane(text3, 0, -1, icon);
                jpane4.getAccessibleContext().setAccessibleName(text3);
                JDialog tmpDialog4 = jpane4.createDialog(this, this.m_applicationName);
                tmpDialog4.show();
            } else if (this.m_eh != null) {
                this.m_eh.log(this.rBundle.getString("min value can't be empty"), this.getClass().getName(), "checkForBadInput");
            }
            return false;
        }
        if (this.m_maximumField.getNumber() == null && !autoMax) {
            if (errors) {
                ImageIcon icon = new ImageIcon(ImageUtils.getImageResource(ValueAxis.class, (String)"images/stop.gif"));
                String text4 = this.rBundle.getString("Max value can't be empty");
                JOptionPane jpane5 = new JOptionPane(text4, 0, -1, icon);
                jpane5.getAccessibleContext().setAccessibleName(text4);
                JDialog tmpDialog5 = jpane5.createDialog(this, this.m_applicationName);
                tmpDialog5.show();
            } else if (this.m_eh != null) {
                this.m_eh.log(this.rBundle.getString("Max value can't be empty"), this.getClass().getName(), "checkForBadInput");
            }
            return false;
        }
        if (this.m_incrementField.getNumber() == null && !autoIncr) {
            if (errors) {
                ImageIcon icon = new ImageIcon(ImageUtils.getImageResource(ValueAxis.class, (String)"images/stop.gif"));
                String text5 = this.rBundle.getString("Increment value can't be empty");
                JOptionPane jpane6 = new JOptionPane(text5, 0, -1, icon);
                jpane6.getAccessibleContext().setAccessibleName(text5);
                JDialog tmpDialog6 = jpane6.createDialog(this, this.m_applicationName);
                tmpDialog6.show();
            } else if (this.m_eh != null) {
                this.m_eh.log(this.rBundle.getString("Increment value can't be empty"), this.getClass().getName(), "checkForBadInput");
            }
            return false;
        }
        double min = 0.0;
        min = !autoMin ? this.m_minimumField.getNumber() : this.m_currentMinValue;
        double max = 0.0;
        max = !autoMax ? this.m_maximumField.getNumber() : this.m_currentMaxValue;
        double incr = 0.0;
        incr = !autoIncr ? this.m_incrementField.getNumber() : this.m_currentIncrValue;
        if (max <= min) {
            if (!autoMin || !autoMax) {
                ImageIcon icon = new ImageIcon(ImageUtils.getImageResource(ValueAxis.class, (String)"images/stop.gif"));
                if (!autoMax) {
                    if (errors || nonDataErrors) {
                        String text6 = this.rBundle.getString("Max must be greater than min");
                        JOptionPane jpane7 = new JOptionPane(text6, 0, -1, icon);
                        jpane7.getAccessibleContext().setAccessibleName(text6);
                        JDialog tmpDialog7 = jpane7.createDialog(this, this.m_applicationName);
                        tmpDialog7.show();
                        this.m_maximumField.selectAll();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ValueAxis.this.m_maximumField.requestFocus();
                            }
                        });
                        if (!autoMin) {
                            this.m_minimumField.selectAll();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ValueAxis.this.m_minimumField.requestFocus();
                                }
                            });
                        }
                        return false;
                    }
                    if (this.m_eh != null) {
                        this.m_eh.log("Maximum value must be greater than minimum value.", this.getClass().getName(), "checkForBadInput");
                    }
                } else if (!autoMin) {
                    if (errors || nonDataErrors) {
                        String text7 = this.rBundle.getString("Min must be less than max");
                        JOptionPane jpane8 = new JOptionPane(text7, 0, -1, icon);
                        jpane8.getAccessibleContext().setAccessibleName(text7);
                        JDialog tmpDialog8 = jpane8.createDialog(this, this.m_applicationName);
                        tmpDialog8.show();
                        this.m_minimumField.selectAll();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ValueAxis.this.m_minimumField.requestFocus();
                            }
                        });
                        return false;
                    }
                    if (this.m_eh != null) {
                        this.m_eh.log("Minimum value must be less than maximum value.", this.getClass().getName(), "checkForBadInput");
                    }
                }
            } else {
                pfjBug = true;
            }
        }
        if (pfjBug) {
            return true;
        }
        double minDataValue = 0.0;
        double maxDataValue = 0.0;
        DataEndPoints ends = null;
        if (errors || warnings) {
            switch (this.m_componentID) {
                case 41: {
                    ends = this.m_graph.getX1Axis().getDataEndPoints();
                    break;
                }
                case 46: {
                    ends = this.m_graph.getY1Axis().getDataEndPoints();
                    break;
                }
                case 51: {
                    ends = this.m_graph.getY2Axis().getDataEndPoints();
                }
            }
            if (ends != null) {
                minDataValue = ends.minimum;
                maxDataValue = ends.maximum;
            }
        }
        if (!autoMin) {
            if (warnings && ends != null && min >= maxDataValue) {
                args = new String[]{String.valueOf(new Double(min).longValue()), String.valueOf(new Double(maxDataValue).longValue())};
                errorMsg = MessageFormat.format(this.rBundle.getString("Min greater than maxDataValue"), args);
                jpane2 = new JOptionPane(errorMsg, 2, 0, new ImageIcon(ImageUtils.getImageResource(ValueAxis.class, (String)"images/Warn.gif")));
                jpane2.getAccessibleContext().setAccessibleName(errorMsg);
                tmpDialog2 = jpane2.createDialog(this, this.m_applicationName);
                tmpDialog2.show();
                val = jpane2.getValue();
                if (val == null || (Integer)val == 1) {
                    this.m_minimumField.selectAll();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ValueAxis.this.m_minimumField.requestFocus();
                        }
                    });
                    return false;
                }
            } else if (warnings && ends != null && min > minDataValue && (this.m_repeatWarnings || !this.m_repeatWarnings && this.m_currentMinValue != this.m_minimumField.getNumber())) {
                args = new String[]{String.valueOf(new Double(min).longValue()), String.valueOf(new Double(minDataValue).longValue())};
                errorMsg = MessageFormat.format(this.rBundle.getString("Min greater than minDataValue"), args);
                jpane2 = new JOptionPane(errorMsg, 2, 0, new ImageIcon(ImageUtils.getImageResource(ValueAxis.class, (String)"images/Warn.gif")));
                jpane2.getAccessibleContext().setAccessibleName(errorMsg);
                tmpDialog2 = jpane2.createDialog(this, this.m_applicationName);
                tmpDialog2.show();
                val = jpane2.getValue();
                if (val == null || (Integer)val == 1) {
                    this.m_minimumField.selectAll();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ValueAxis.this.m_minimumField.requestFocus();
                        }
                    });
                    return false;
                }
            }
            if (warnings && ends != null && this.isBaselineGraph() && this.m_baselineField.getNumber() != 0.0 && this.m_baselineField.getNumber() < min) {
                args = new String[]{String.valueOf(new Double(min).longValue()), String.valueOf(new Double(minDataValue).longValue())};
                errorMsg = MessageFormat.format(this.rBundle.getString("Base line less than min"), args);
                jpane2 = new JOptionPane(errorMsg, 2, 0, new ImageIcon(ImageUtils.getImageResource(ValueAxis.class, (String)"images/Warn.gif")));
                jpane2.getAccessibleContext().setAccessibleName(errorMsg);
                tmpDialog2 = jpane2.createDialog(this, this.m_applicationName);
                tmpDialog2.show();
                val = jpane2.getValue();
                if (val == null || (Integer)val == 1) {
                    this.m_baselineField.selectAll();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ValueAxis.this.m_baselineField.requestFocus();
                        }
                    });
                    return false;
                }
            }
            if (!log && warnings && ends != null && min - minDataValue < (double)this.m_multiplier * (minDataValue - maxDataValue) && minDataValue != maxDataValue && (this.m_repeatWarnings || !this.m_repeatWarnings && this.m_currentMinValue != this.m_minimumField.getNumber())) {
                args = new String[]{String.valueOf(new Double(min).longValue()), String.valueOf(new Double(minDataValue).longValue())};
                errorMsg = MessageFormat.format(this.rBundle.getString("Min is much smaller than minDataValue"), args);
                jpane2 = new JOptionPane(errorMsg, 2, 0, new ImageIcon(ImageUtils.getImageResource(ValueAxis.class, (String)"images/Warn.gif")));
                jpane2.getAccessibleContext().setAccessibleName(errorMsg);
                tmpDialog2 = jpane2.createDialog(this, this.m_applicationName);
                tmpDialog2.show();
                val = jpane2.getValue();
                if (val == null || (Integer)val == 1) {
                    this.m_minimumField.selectAll();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ValueAxis.this.m_minimumField.requestFocus();
                        }
                    });
                    return false;
                }
            }
        }
        if (log) {
            if (!autoMin && min <= 0.0) {
                if (errors || nonDataErrors) {
                    text = this.rBundle.getString("Min must be greater than zero for log");
                    jpane = new JOptionPane(text, 0, -1, new ImageIcon(ImageUtils.getImageResource(ValueAxis.class, (String)"images/stop.gif")));
                    jpane.getAccessibleContext().setAccessibleName(text);
                    tmpDialog = jpane.createDialog(this, this.m_applicationName);
                    tmpDialog.show();
                    this.m_minimumField.selectAll();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ValueAxis.this.m_minimumField.requestFocus();
                        }
                    });
                    return false;
                }
                if (this.m_eh != null) {
                    this.m_eh.log("Minimum value must be greater than zero for logarithmic scale.", this.getClass().getName(), "checkForBadInput");
                }
            }
            if (warnings && ends != null && this.isBaselineGraph() && this.m_baselineField.getNumber() < 0.0) {
                String errorMsg2 = this.rBundle.getString("Base line log warning");
                jpane = new JOptionPane(errorMsg2, 2, 0, new ImageIcon(ImageUtils.getImageResource(ValueAxis.class, (String)"images/Warn.gif")));
                jpane.getAccessibleContext().setAccessibleName(errorMsg2);
                tmpDialog = jpane.createDialog(this, this.m_applicationName);
                tmpDialog.show();
                Object val2 = jpane.getValue();
                if (val2 == null || (Integer)val2 == 1) {
                    this.m_baselineField.selectAll();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ValueAxis.this.m_baselineField.requestFocus();
                        }
                    });
                    return false;
                }
            }
        }
        if (!autoMax) {
            if (!log && warnings && ends != null && max - maxDataValue > (double)this.m_multiplier * (maxDataValue - minDataValue) && maxDataValue != minDataValue && (this.m_repeatWarnings || !this.m_repeatWarnings && this.m_currentMaxValue != this.m_maximumField.getNumber())) {
                args = new String[]{String.valueOf(new Double(max).longValue()), String.valueOf(new Double(maxDataValue).longValue())};
                errorMsg = MessageFormat.format(this.rBundle.getString("Max is much greater than maxDataValue"), args);
                jpane2 = new JOptionPane(errorMsg, 2, 0, new ImageIcon(ImageUtils.getImageResource(ValueAxis.class, (String)"images/Warn.gif")));
                jpane2.getAccessibleContext().setAccessibleName(errorMsg);
                tmpDialog2 = jpane2.createDialog(this, this.m_applicationName);
                tmpDialog2.show();
                val = jpane2.getValue();
                if (val == null || (Integer)val == 1) {
                    this.m_maximumField.selectAll();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ValueAxis.this.m_maximumField.requestFocus();
                        }
                    });
                    return false;
                }
            }
            if (warnings && ends != null && max < maxDataValue && (this.m_repeatWarnings || !this.m_repeatWarnings && this.m_currentMaxValue != this.m_maximumField.getNumber())) {
                args = new String[]{String.valueOf(new Double(max).longValue()), String.valueOf(new Double(maxDataValue).longValue())};
                errorMsg = MessageFormat.format(this.rBundle.getString("Max is less than maxDataValue"), args);
                jpane2 = new JOptionPane(errorMsg, 2, 0, new ImageIcon(ImageUtils.getImageResource(ValueAxis.class, (String)"images/Warn.gif")));
                jpane2.getAccessibleContext().setAccessibleName(errorMsg);
                tmpDialog2 = jpane2.createDialog(this, this.m_applicationName);
                tmpDialog2.show();
                val = jpane2.getValue();
                if (val == null || (Integer)val == 1) {
                    this.m_maximumField.selectAll();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ValueAxis.this.m_maximumField.requestFocus();
                        }
                    });
                    return false;
                }
            }
            if (warnings && ends != null && this.isBaselineGraph() && this.m_baselineField.getNumber() != 0.0 && this.m_baselineField.getNumber() > max) {
                args = new String[]{String.valueOf(new Double(max).longValue()), String.valueOf(new Double(maxDataValue).longValue())};
                errorMsg = MessageFormat.format(this.rBundle.getString("Base line greater than max"), args);
                jpane2 = new JOptionPane(errorMsg, 2, 0, new ImageIcon(ImageUtils.getImageResource(ValueAxis.class, (String)"images/Warn.gif")));
                jpane2.getAccessibleContext().setAccessibleName(errorMsg);
                tmpDialog2 = jpane2.createDialog(this, this.m_applicationName);
                tmpDialog2.show();
                val = jpane2.getValue();
                if (val == null || (Integer)val == 1) {
                    this.m_baselineField.selectAll();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ValueAxis.this.m_baselineField.requestFocus();
                        }
                    });
                    return false;
                }
            }
        }
        if (!autoIncr && incr <= 0.0) {
            if (errors || nonDataErrors) {
                text = this.rBundle.getString("Increment value must be greater than zero.");
                jpane = new JOptionPane(text, 0, -1, new ImageIcon(ImageUtils.getImageResource(ValueAxis.class, (String)"images/stop.gif")));
                jpane.getAccessibleContext().setAccessibleName(text);
                tmpDialog = jpane.createDialog(this, this.m_applicationName);
                tmpDialog.show();
                this.m_incrementField.selectAll();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ValueAxis.this.m_incrementField.requestFocus();
                    }
                });
                return false;
            }
            if (this.m_eh != null) {
                this.m_eh.log("Increment value must be greater than zero.", this.getClass().getName(), "checkForBadInput");
            }
        }
        if (incr > max - min && !this.m_incrementBox.isSelected()) {
            if (errors || nonDataErrors) {
                text = this.rBundle.getString("Incr must not be greater than max-min");
                jpane = new JOptionPane(text, 0, -1, new ImageIcon(ImageUtils.getImageResource(ValueAxis.class, (String)"images/stop.gif")));
                jpane.getAccessibleContext().setAccessibleName(text);
                tmpDialog = jpane.createDialog(this, this.m_applicationName);
                tmpDialog.show();
                this.m_incrementField.selectAll();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ValueAxis.this.m_incrementField.requestFocus();
                    }
                });
                return false;
            }
            if (this.m_eh != null) {
                this.m_eh.log("Increment value must not be greater than the difference between the maximum and the minimum.", this.getClass().getName(), "checkForBadInput");
            }
        }
        if (!autoIncr) {
            double minIncr = 0.0;
            double maxIncr = 0.0;
            boolean displayBadIncr = true;
            int graphType = this.m_graph.getGraphType();
            if (max > 0.0 && min >= 0.0) {
                if (autoMax && ends != null && graphType != 96 && graphType != 93 && graphType != 94) {
                    minIncr = (maxDataValue - min) / 100.0;
                    maxIncr = maxDataValue - min;
                } else if (autoMax && ends == null) {
                    displayBadIncr = false;
                } else if (!autoMax || graphType == 96 || graphType == 93 || graphType == 94) {
                    minIncr = (max - min) / 100.0;
                    maxIncr = max - min;
                }
            } else if (max <= 0.0 && min < 0.0) {
                if (autoMin && ends != null) {
                    minIncr = -((minDataValue - max) / 100.0);
                    maxIncr = -(minDataValue - max);
                } else if (autoMin && ends == null) {
                    displayBadIncr = false;
                } else if (!autoMin) {
                    minIncr = -((min - max) / 100.0);
                    maxIncr = max - min;
                }
            } else {
                if (ends == null) {
                    displayBadIncr = false;
                }
                if (autoMin && autoMax && ends != null) {
                    minIncr = (maxDataValue - minDataValue) / 100.0;
                    maxIncr = maxDataValue - minDataValue;
                } else if (!autoMax && !autoMin) {
                    minIncr = (max - min) / 100.0;
                    maxIncr = max - min;
                    displayBadIncr = true;
                } else if (autoMax && ends != null) {
                    minIncr = (maxDataValue - min) / 100.0;
                    maxIncr = maxDataValue - min;
                } else if (autoMin && ends != null) {
                    minIncr = (max - minDataValue) / 100.0;
                    maxIncr = max - minDataValue;
                }
            }
            if (incr < minIncr && errors && displayBadIncr) {
                Object[] args2 = new String[]{Double.toString(minIncr)};
                String errorMsg3 = MessageFormat.format(this.rBundle.getString("Too small increment"), args2);
                JOptionPane jpane9 = new JOptionPane(errorMsg3, 0, -1, new ImageIcon(ImageUtils.getImageResource(ValueAxis.class, (String)"images/stop.gif")));
                jpane9.getAccessibleContext().setAccessibleName(errorMsg3);
                JDialog tmpDialog9 = jpane9.createDialog(this, this.m_applicationName);
                tmpDialog9.show();
                this.m_incrementField.selectAll();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ValueAxis.this.m_incrementField.requestFocus();
                    }
                });
                return false;
            }
            if (incr > maxIncr && errors && displayBadIncr) {
                Object[] args3 = new String[]{String.valueOf(new Double(maxIncr).longValue())};
                String errorMsg4 = MessageFormat.format(this.rBundle.getString("Too large increment"), args3);
                JOptionPane jpane10 = new JOptionPane(errorMsg4, 0, -1, new ImageIcon(ImageUtils.getImageResource(ValueAxis.class, (String)"images/stop.gif")));
                jpane10.getAccessibleContext().setAccessibleName(errorMsg4);
                JDialog tmpDialog10 = jpane10.createDialog(this, this.m_applicationName);
                tmpDialog10.show();
                this.m_incrementField.selectAll();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ValueAxis.this.m_incrementField.requestFocus();
                    }
                });
                return false;
            }
        }
        return true;
    }

    private void _initializeCurrentValues() {
        switch (this.m_componentID) {
            case 41: {
                this.m_currentMinValue = this.m_graph.getX1Axis().getAxisMinValue();
                this.m_currentMaxValue = this.m_graph.getX1Axis().getAxisMaxValue();
                this.m_currentIncrValue = this.m_graph.getX1Axis().getMajorTickStep();
                break;
            }
            case 46: {
                this.m_currentMinValue = this.m_graph.getY1Axis().getAxisMinValue();
                this.m_currentMaxValue = this.m_graph.getY1Axis().getAxisMaxValue();
                this.m_currentIncrValue = this.m_graph.getY1Axis().getMajorTickStep();
                break;
            }
            case 51: {
                this.m_currentMinValue = this.m_graph.getY2Axis().getAxisMinValue();
                this.m_currentMaxValue = this.m_graph.getY2Axis().getAxisMaxValue();
                this.m_currentIncrValue = this.m_graph.getY2Axis().getMajorTickStep();
            }
        }
    }

    public void setDecimalSeparator(char decimalSeparator) {
        this.m_minimumField.setDecimalSeparator(decimalSeparator);
        this.m_maximumField.setDecimalSeparator(decimalSeparator);
        this.m_incrementField.setDecimalSeparator(decimalSeparator);
        this.m_baselineField.setDecimalSeparator(decimalSeparator);
        this.updateNumbers();
    }

    public void setGroupingSeparator(char groupingSeparator) {
        this.m_minimumField.setGroupingSeparator(groupingSeparator);
        this.m_maximumField.setGroupingSeparator(groupingSeparator);
        this.m_incrementField.setGroupingSeparator(groupingSeparator);
        this.m_baselineField.setGroupingSeparator(groupingSeparator);
        this.updateNumbers();
    }

    private void updateNumbers() {
        switch (this.m_componentID) {
            case 41: {
                if (this.m_minimumBox.isSelected()) {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getX1Axis().getAxisMinAutoValue()));
                } else {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getX1Axis().getAxisMinValue()));
                }
                if (this.m_maximumBox.isSelected()) {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getX1Axis().getAxisMaxAutoValue()));
                } else {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getX1Axis().getAxisMaxValue()));
                }
                if (this.m_incrementBox.isSelected()) {
                    this.m_incrementField.setNumber(new Double(this.m_graph.getX1Axis().getAutoMajorTickStep()));
                    break;
                }
                this.m_incrementField.setNumber(new Double(this.m_graph.getX1Axis().getMajorTickStep()));
                break;
            }
            case 46: {
                if (this.m_minimumBox.isSelected()) {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getY1Axis().getAxisMinAutoValue()));
                } else {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getY1Axis().getAxisMinValue()));
                }
                if (this.m_maximumBox.isSelected()) {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getY1Axis().getAxisMaxAutoValue()));
                } else {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getY1Axis().getAxisMaxValue()));
                }
                if (this.m_incrementBox.isSelected()) {
                    this.m_incrementField.setNumber(new Double(this.m_graph.getY1Axis().getAutoMajorTickStep()));
                } else {
                    this.m_incrementField.setNumber(new Double(this.m_graph.getY1Axis().getMajorTickStep()));
                }
                this.m_baselineField.setNumber(new Double(this.m_graph.getY1BaseLine().getValue()));
                break;
            }
            case 51: {
                if (this.m_minimumBox.isSelected()) {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getY2Axis().getAxisMinAutoValue()));
                } else {
                    this.m_minimumField.setNumber(new Double(this.m_graph.getY2Axis().getAxisMinValue()));
                }
                if (this.m_maximumBox.isSelected()) {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getY2Axis().getAxisMaxAutoValue()));
                } else {
                    this.m_maximumField.setNumber(new Double(this.m_graph.getY2Axis().getAxisMaxValue()));
                }
                if (this.m_incrementBox.isSelected()) {
                    this.m_incrementField.setNumber(new Double(this.m_graph.getY2Axis().getAutoMajorTickStep()));
                } else {
                    this.m_incrementField.setNumber(new Double(this.m_graph.getY2Axis().getMajorTickStep()));
                }
                this.m_baselineField.setNumber(new Double(this.m_graph.getY2BaseLine().getValue()));
            }
        }
    }

    @Override
    protected void initTitleFontButton(FontButton f) {
        super.initTitleFontButton(f);
        if (!(this.isGraphHorizontal() || this.m_graph.getGraphType() >= 0 && this.m_graph.getGraphType() <= 14 || this.m_graph.getGraphType() >= 65 && this.m_graph.getGraphType() <= 66 || this.m_graph.getGraphType() >= 67 && this.m_graph.getGraphType() <= 69)) {
            int rbutton = 12;
            f.setRotationButtonMask(rbutton);
        } else {
            f.setRotationButtonMask(0);
        }
    }

    private ReferenceDialog createReferenceDialog(String title, boolean modal, JPanel p, boolean bHelpEnabled) {
        ReferenceDialog d = null;
        Container owner = this;
        while (owner != null) {
            if (owner instanceof Dialog) {
                d = new ReferenceDialog((Dialog)owner, title, modal, p, bHelpEnabled);
                break;
            }
            if (owner instanceof Frame) {
                d = new ReferenceDialog((Frame)owner, title, modal, p, bHelpEnabled);
                break;
            }
            owner = SwingUtilities.getWindowAncestor(owner);
        }
        if (owner == null) {
            d = new ReferenceDialog((Frame)null, title, modal, p, bHelpEnabled);
        }
        return d;
    }

    class ReferenceDialog
    extends JDialog
    implements ActionListener,
    FocusListener,
    HelpContext {
        private static final long serialVersionUID = 1L;
        private boolean m_bHelpEnabled;
        private JButton okButton;
        private JButton cancelButton;
        private JButton helpButton;
        protected JPanel m_panel;
        protected String m_strHelpContextID;
        private Object[][] m_data;
        private int m_initialWidth;
        private int m_initialHeight;
        private final Border _sBorder;
        private final Border _sBorderButtons;

        public ReferenceDialog(Frame parentFrame, String title, boolean modal, JPanel p, boolean bHelpEnabled) {
            super(parentFrame);
            this.m_bHelpEnabled = true;
            this._sBorder = new EmptyBorder(6, 6, 8, 5);
            this._sBorderButtons = new EmptyBorder(8, 10, 0, 10);
            this._initDialog(title, modal, p, bHelpEnabled);
        }

        public ReferenceDialog(Dialog parentFrame, String title, boolean modal, JPanel p, boolean bHelpEnabled) {
            super(parentFrame);
            this.m_bHelpEnabled = true;
            this._sBorder = new EmptyBorder(6, 6, 8, 5);
            this._sBorderButtons = new EmptyBorder(8, 10, 0, 10);
            this._initDialog(title, modal, p, bHelpEnabled);
        }

        private void _initDialog(String title, boolean modal, JPanel p, boolean bHelpEnabled) {
            this.m_bHelpEnabled = bHelpEnabled;
            this.setTitle(title);
            this.setModal(modal);
            this.m_panel = p;
            JTable table = ((ReferenceLine)this.m_panel).getTable();
            this.m_data = new Object[table.getRowCount()][table.getColumnCount()];
            for (int i = 0; i < table.getRowCount(); ++i) {
                for (int j = 0; j < table.getColumnCount(); ++j) {
                    this.m_data[i][j] = table.getValueAt(i, j);
                }
            }
            this.init();
            this.pack();
            this.m_initialWidth = this.getWidth();
            this.m_initialHeight = this.getHeight();
            this.setLocationRelativeTo(ValueAxis.this.m_referenceLineButton);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    ReferenceDialog.this.resetValues();
                }
            });
            p = null;
        }

        public String getHelpContextID() {
            return this.getClass().getName();
        }

        public void setHelpContextID(String strHelpContextID) {
            this.m_strHelpContextID = strHelpContextID;
        }

        public void setHelpEnabled(boolean bValue) {
            this.m_bHelpEnabled = bValue;
        }

        public boolean isHelpEnabled() {
            return this.m_bHelpEnabled;
        }

        private void init() {
            this.m_initialWidth = -1;
            this.m_initialHeight = -1;
            JComponent content = (JComponent)this.getContentPane();
            content.setLayout(new BoxLayout(content, 1));
            content.setBorder(this._sBorder);
            if (UIManager.getLookAndFeel() instanceof BrowserLookAndFeel) {
                content.setBackground(UIManager.getColor("MenuBar.background"));
            } else if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
                content.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
            }
            GrayPane gp = new GrayPane((Component)this.m_panel);
            content.add((Component)gp);
            DialogButtonBar buttonPanel = new DialogButtonBar();
            buttonPanel.setBorder(this._sBorderButtons);
            if (this.m_bHelpEnabled) {
                String translatedText = ValueAxis.this.rBundle.getString("Help");
                this.helpButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
                this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
                buttonPanel.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
                this.helpButton.addActionListener(this);
                this.helpButton.addFocusListener(this);
                this.helpButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(112, 0), 2);
            }
            JPanel buttonPanel_east = new JPanel();
            this.okButton = new JButton(ValueAxis.this.rBundle.getString("OK"));
            buttonPanel.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_YES);
            this.okButton.addActionListener(this);
            this.okButton.addFocusListener(this);
            this.getRootPane().setDefaultButton(this.okButton);
            this.cancelButton = new JButton(ValueAxis.this.rBundle.getString("Cancel"));
            buttonPanel.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
            this.cancelButton.addActionListener(this);
            this.cancelButton.addFocusListener(this);
            this.cancelButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
            this.getContentPane().add((Component)buttonPanel);
            this.setResizable(true);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int originalHeight;
                    int originalWidth;
                    int width = originalWidth = ReferenceDialog.this.getWidth();
                    int height = originalHeight = ReferenceDialog.this.getHeight();
                    if (ReferenceDialog.this.m_initialWidth != -1) {
                        width = Math.max(ReferenceDialog.this.m_initialWidth, width);
                    }
                    if (ReferenceDialog.this.m_initialHeight != -1) {
                        height = Math.max(ReferenceDialog.this.m_initialHeight, height);
                    }
                    if (originalWidth != width || originalHeight != height) {
                        ReferenceDialog.this.setSize(width, height);
                    }
                    ReferenceDialog.this.validate();
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.cancelButton) {
                this.setVisible(false);
                this.getParent().repaint();
                this.resetValues();
                ValueAxis.this.m_referenceLine.resetFocus();
            } else if (e.getSource() == this.okButton) {
                this.setVisible(false);
                ValueAxis.this.m_referenceLine.resetFocus();
            } else if (e.getSource() == this.helpButton) {
                try {
                    if (ValueAxis.this.getHelpProvider() != null) {
                        ValueAxis.this.getHelpProvider().showHelp((Component)this);
                    } else if (HelpUtils.getDefaultHelpProvider() != null) {
                        HelpUtils.getDefaultHelpProvider().showHelp((Component)this);
                    }
                }
                catch (HelpUnavailableException helpUnavailableException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() == this.cancelButton) {
                ValueAxis.this.m_referenceLine.resetFocus();
            } else if (e.getSource() == this.okButton) {
                ValueAxis.this.m_referenceLine.resetFocusLast();
            } else if (e.getSource() == this.helpButton) {
                ValueAxis.this.m_referenceLine.resetFocusLast();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        public void resetValues() {
            int i;
            JTable table = ((ReferenceLine)this.m_panel).getTable();
            if (table.isEditing()) {
                int row = table.getEditingRow();
                int col = table.getEditingColumn();
                if (row >= 0 && col >= 0) {
                    table.getCellEditor(row, col).cancelCellEditing();
                }
            }
            for (i = 0; i < table.getRowCount(); ++i) {
                for (int j = 1; j < table.getColumnCount(); ++j) {
                    table.setValueAt(this.m_data[i][j], i, j);
                }
            }
            for (i = 0; i < table.getRowCount(); ++i) {
                table.setValueAt(this.m_data[i][0], i, 0);
            }
        }
    }

    protected class NumberLocaleDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        private DecimalFormat m_format;
        private JTextField m_text;
        private char Minus;
        private char Dec;
        private char Group;

        public NumberLocaleDocument(JTextField text, Locale loc) {
            this.m_text = text;
            this.m_format = (DecimalFormat)NumberFormat.getNumberInstance(loc);
            this.Minus = this.m_format.getDecimalFormatSymbols().getMinusSign();
            this.Dec = this.m_format.getDecimalFormatSymbols().getDecimalSeparator();
            this.Group = this.m_format.getDecimalFormatSymbols().getGroupingSeparator();
            this.m_format.setGroupingUsed(false);
        }

        public void setDecimalSeparator(char decimalSeparator) {
            DecimalFormatSymbols formatSymbols = this.m_format.getDecimalFormatSymbols();
            formatSymbols.setDecimalSeparator(decimalSeparator);
            this.Dec = formatSymbols.getDecimalSeparator();
            this.m_format.setDecimalFormatSymbols(formatSymbols);
        }

        public void setGroupingSeparator(char groupingSeparator) {
            DecimalFormatSymbols formatSymbols = this.m_format.getDecimalFormatSymbols();
            formatSymbols.setGroupingSeparator(groupingSeparator);
            this.Group = formatSymbols.getGroupingSeparator();
            this.m_format.setGroupingUsed(true);
            this.m_format.setDecimalFormatSymbols(formatSymbols);
        }

        @Override
        public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
            try {
                if (this.m_text.getText().length() == 0 && offset == 0 && str.length() == 1 && (str.charAt(0) == this.Minus || str.charAt(0) == this.Dec)) {
                    super.insertString(offset, str, a);
                    return;
                }
                StringBuilder oldText = new StringBuilder(this.m_text.getText());
                oldText.insert(offset, str);
                ParsePosition pos = new ParsePosition(0);
                Number result = this.m_format.parse(oldText.toString(), pos);
                if (pos.getIndex() != oldText.length()) {
                    if (pos.getIndex() == oldText.length() - 1 && str.equals(new String(new char[]{this.Dec})) && this.m_text.getText().indexOf(this.Dec) == -1) {
                        super.insertString(offset, str, a);
                    } else if (pos.getIndex() == oldText.length() - 1 && str.equals(new String(new char[]{this.Group}))) {
                        super.insertString(offset, str, a);
                    }
                    return;
                }
                super.insertString(offset, str, a);
            }
            catch (Exception eNumber) {
                return;
            }
        }

        public void cleanUp() {
            this.m_format = null;
            this.m_text = null;
        }
    }

    protected class DoubleTextField
    extends JTextField {
        private static final long serialVersionUID = 1L;
        DecimalFormat m_format = null;
        NumberLocaleDocument m_document = null;

        public DoubleTextField(Locale loc) {
            this.m_format = (DecimalFormat)NumberFormat.getInstance(loc);
            this.m_format.setMinimumFractionDigits(2);
            this.m_format.setMaximumFractionDigits(10);
            this.m_format.setGroupingUsed(false);
            this.m_document = new NumberLocaleDocument(this, loc);
            this.setDocument(this.m_document);
        }

        public Double getNumber() {
            String text = this.getText();
            if (text == null || text.equals("")) {
                return null;
            }
            if (text.length() == 1) {
                char Minus = this.m_format.getDecimalFormatSymbols().getMinusSign();
                char dec = this.m_format.getDecimalFormatSymbols().getDecimalSeparator();
                if (text.charAt(0) == Minus || text.charAt(0) == dec) {
                    return new Double(0.0);
                }
            }
            ParsePosition pos = new ParsePosition(0);
            Number number = this.m_format.parse(text, pos);
            if (pos.getIndex() != text.length()) {
                return new Double(0.0);
            }
            return new Double(number.doubleValue());
        }

        public void setNumber(Double number) {
            this.setText(this.m_format.format(number));
        }

        public void setDecimalSeparator(char decimalSeparator) {
            DecimalFormatSymbols formatSymbols = this.m_format.getDecimalFormatSymbols();
            formatSymbols.setDecimalSeparator(decimalSeparator);
            this.m_format.setDecimalFormatSymbols(formatSymbols);
            this.m_document.setDecimalSeparator(decimalSeparator);
        }

        public void setGroupingSeparator(char groupingSeparator) {
            DecimalFormatSymbols formatSymbols = this.m_format.getDecimalFormatSymbols();
            formatSymbols.setGroupingSeparator(groupingSeparator);
            this.m_format.setGroupingUsed(true);
            this.m_format.setDecimalFormatSymbols(formatSymbols);
            this.m_document.setGroupingSeparator(groupingSeparator);
        }

        public void cleanUp() {
            this.setDocument(new DefaultStyledDocument());
            this.m_document.cleanUp();
            this.m_document = null;
            this.m_format = null;
        }
    }
}

