/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.border.GrayPane;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.model.ArrayTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.olaf.BrowserLookAndFeel;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.graph.Graph;
import oracle.dss.graph.gui.BasePanel;
import oracle.dss.graph.gui.FormatButtonDialog;
import oracle.dss.graph.gui.LineWidth;
import oracle.dss.graph.gui.Series;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.gui.BIColorChoice;
import oracle.dss.util.gui.FontButton;
import oracle.dss.util.help.HelpContext;

public class PlotArea
extends BasePanel
implements ActionListener,
ItemListener,
PropertyChangeListener,
HelpContext {
    private static final long serialVersionUID = 1L;
    private ResourceBundle rBundle = null;
    private Component m_tmpPanel = null;
    protected HelpProvider m_helpProvider;
    protected int m_currentType;
    protected JLabel m_backgroundLabel;
    protected JLabel m_borderLabel;
    protected JLabel m_seriesLabel;
    protected JLabel m_horzLabel;
    protected JLabel m_vertLabel;
    protected BIColorChoice m_backgroundColor;
    protected BIColorChoice m_borderColor;
    protected JCheckBox m_horzBox;
    protected JCheckBox m_vertBox;
    protected JCheckBox m_dataLabelBox;
    protected JCheckBox m_dataTipsBox;
    protected LineWidth m_horzLineWidth;
    protected LineWidth m_vertLineWidth;
    protected BIColorChoice m_horzColor;
    protected BIColorChoice m_vertColor;
    protected JButton m_dataLabelOption;
    protected JButton m_fontButton;
    protected FormatButtonDialog m_formatDialog;
    protected JButton m_dataTipsOption;
    protected Series m_series;
    protected Color m_oldBackgroundColor;
    protected Color m_bColor;
    protected Color m_bgColor;
    protected Color m_yColor;
    protected Color m_oColor;
    protected Color m_bdColor;
    protected Color m_oldHorzColor;
    protected int m_oldHorzLineWidth;
    protected Color m_oldVertColor;
    protected int m_oldVertLineWidth;
    protected int m_tooltipType;
    protected int m_labelPosition;
    protected DataTip m_dataTip;
    protected DataLabel m_dataLabel;
    protected ComponentAdapter m_componentListener;
    protected ArrayTwoDModel m_colorPalette = null;
    protected boolean m_bColorPaletteSet = false;
    protected boolean m_bHelpEnabled;
    protected ErrorHandler m_eh = null;
    protected String m_strHelpContextID;
    protected JPanel m_backgroundColorPanel;
    protected JPanel m_borderColorPanel;
    protected JPanel m_horzGridLinesPanel;
    protected JPanel m_vertGridLinesPanel;
    protected JPanel m_dataLabelsPanel;
    protected JPanel m_dataTipsPanel;
    protected boolean m_bBackgroundChanged = false;
    protected boolean m_bBorderColorChanged = false;
    protected boolean m_bHorzVisibleChanged = false;
    protected boolean m_bHorzColorChanged = false;
    protected boolean m_bHorzWidthChanged = false;
    protected boolean m_bVertVisibleChanged = false;
    protected boolean m_bVertColorChanged = false;
    protected boolean m_bVertWidthChanged = false;
    protected boolean m_bDataLabelVisibleChanged = false;
    protected boolean m_bDataTipVisibleChanged = false;
    protected boolean m_bDataLabelPositionChanged = false;
    protected boolean m_bDataLabelTextTypeChanged = false;
    protected boolean m_bDataTipTypeChanged = false;
    protected boolean m_bDataLabelFontColorChanged = false;
    protected boolean m_bDataLabelFontNameChanged = false;
    protected boolean m_bDataLabelFontSizeChanged = false;
    protected boolean m_bDataLabelFontBoldChanged = false;
    protected boolean m_bDataLabelFontItalicChanged = false;
    protected boolean m_bDataLabelFontUnderlineChanged = false;
    protected boolean m_bDataMarkerVisibleChanged = false;
    protected boolean m_bMainFontNameChange = false;
    protected String m_mainOldFontName;
    protected String m_mainNewFontName;
    protected boolean m_bMainFontStyleChange = false;
    protected int m_mainOldFontStyle;
    protected int m_mainNewFontStyle;
    protected boolean m_bMainFontSizeChange = false;
    protected int m_mainOldFontSize;
    protected int m_mainNewFontSize;
    protected boolean m_bMainFontColorChange = false;
    protected Color m_mainOldFontColor;
    protected Color m_mainNewFontColor;
    private static Color c_Transparent = null;
    private int m_initialWidth = -1;
    private int m_initialHeight = -1;
    public static final String PROPERTY_BACKGROUND_COLOR = "BackgroundColor";
    public static final String PROPERTY_BORDER_COLOR = "BorderColor";
    public static final String PROPERTY_HORIZONTAL_GRID_VISIBLE = "HorizontalGridVisible";
    public static final String PROPERTY_HORIZONTAL_GRID_COLOR = "HorizontalGridColor";
    public static final String PROPERTY_HORIZONTAL_GRID_LINE_WIDTH = "HorizontalGridLineWidth";
    public static final String PROPERTY_VERTICAL_GRID_VISIBLE = "VerticalGridVisible";
    public static final String PROPERTY_VERTICAL_GRID_COLOR = "VerticalGridColor";
    public static final String PROPERTY_VERTICAL_GRID_LINE_WIDTH = "VerticalGridLineWidth";
    public static final String PROPERTY_DATA_LABEL_POSITION = "DataLabelPosition";
    public static final String PROPERTY_DATA_LABEL_VISIBLE = "DataLabelVisible";
    public static final String PROPERTY_DATA_LABEL_TEXT = "DataLabelText";
    public static final String PROPERTY_DATA_TIPS_VISIBLE = "DataTipsVisible";
    public static final String PROPERTY_DATA_MARKER_VISIBLE = "DataMarkerVisible";
    public static final String PROPERTY_DATA_TIPS_TEXT = "DataTipsText";
    public static final int COLOR_COLUMN = 1;
    public static final int LINE_COLUMN = 2;
    public static final int MARKER_SHAPE_COLUMN = 4;
    public static final int YAXIS_COLUMN = 16;
    public static final int MARKER_TYPE_COLUMN = 32;
    public static final int FITLINE_COLUMN = 64;

    public PlotArea(Graph graph) {
        super(graph);
        this._initialize(graph, 0);
    }

    public PlotArea(Graph graph, int excludeColumns) {
        super(graph);
        this._initialize(graph, excludeColumns);
    }

    @Override
    public void setGraph(Graph graph) {
        super.setGraph(graph);
        this.m_currentType = this.m_graph.getGraphType();
        this.m_tooltipType = this.m_graph.getMarkerTooltipType();
        this.m_backgroundLabel.setEnabled(true);
        this.m_backgroundColor.setEnabled(true);
        this.m_backgroundColor.setLocale(graph.getLocale());
        this.m_backgroundColor.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_borderLabel.setEnabled(true);
        this.m_borderColor.setEnabled(true);
        this.m_borderColor.setLocale(graph.getLocale());
        this.m_borderColor.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_horzBox.setSelected(true);
        this.m_horzBox.setEnabled(true);
        this.m_horzLineWidth.setEnabled(true);
        this.m_horzColor.setEnabled(true);
        this.m_horzColor.setLocale(graph.getLocale());
        this.m_horzColor.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_vertBox.setSelected(true);
        this.m_vertBox.setEnabled(true);
        this.m_vertLineWidth.setEnabled(true);
        this.m_vertColor.setEnabled(true);
        this.m_vertColor.setLocale(graph.getLocale());
        this.m_vertColor.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_vertLabel.setEnabled(true);
        this.m_horzLabel.setEnabled(true);
        this.m_horzGridLinesPanel.setVisible(true);
        this.m_vertGridLinesPanel.setVisible(true);
        this.m_dataLabelsPanel.setVisible(true);
        this.m_vertLineWidth.setVisible(true);
        this.m_horzLineWidth.setVisible(true);
        this.m_tmpPanel.setVisible(true);
        this.m_dataLabelBox.setSelected(true);
        this.m_dataLabelBox.setEnabled(true);
        String translatedText = !this._isDataLabelInTheCenterSupported() ? MessageFormat.format(this.rBundle.getString("PlotArea Show uneditable labels"), this._getDataLabelString()) : MessageFormat.format(this.rBundle.getString("PlotArea Show labels"), this._getDataLabelString());
        this.m_dataLabelBox.setText(StringUtils.stripMnemonic((String)translatedText));
        this.m_dataLabelBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.setDataLabelOptions();
        translatedText = MessageFormat.format(this.rBundle.getString("Show tips"), this._getDataLabelString());
        this.m_dataTipsBox.setText(StringUtils.stripMnemonic((String)translatedText));
        this.m_dataTipsBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = this.m_currentType == 65 || this.m_currentType == 67 ? this.rBundle.getString("Show Cg lines") : this.rBundle.getString("Show Hg lines");
        this.m_horzBox.setText(StringUtils.stripMnemonic((String)translatedText));
        this.m_horzBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = this.m_currentType == 65 || this.m_currentType == 67 ? this.rBundle.getString("Show Rg lines") : this.rBundle.getString("Show Vg lines");
        this.m_vertBox.setText(StringUtils.stripMnemonic((String)translatedText));
        this.m_vertBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.sizeComponents();
        this._init();
        if (graph.getGraphType() == 12 || graph.getGraphType() == 70 || graph.getGraphType() == 71 || graph.getGraphType() == 72 || graph.getGraphType() == 84) {
            this.m_seriesLabel.setVisible(false);
            this.m_series.setVisible(false);
        } else {
            this.m_seriesLabel.setVisible(true);
            this.m_series.setVisible(false);
            this.m_series.setGraph(graph);
            this.m_series.setMaximumSize(this.m_series.getPreferredSize());
            this.m_series.setVisible(true);
        }
        this.m_dataLabel = null;
        this.m_dataTip = null;
        this.m_bBackgroundChanged = false;
        this.m_bBorderColorChanged = false;
        this.m_bHorzVisibleChanged = false;
        this.m_bHorzColorChanged = false;
        this.m_bHorzWidthChanged = false;
        this.m_bVertVisibleChanged = false;
        this.m_bVertColorChanged = false;
        this.m_bVertWidthChanged = false;
        this.m_bDataLabelVisibleChanged = false;
        this.m_bDataTipVisibleChanged = false;
        this.m_bDataLabelPositionChanged = false;
        this.m_bDataLabelTextTypeChanged = false;
        this.m_bDataTipTypeChanged = false;
        this.m_bDataLabelFontColorChanged = false;
        this.m_bDataLabelFontNameChanged = false;
        this.m_bDataLabelFontSizeChanged = false;
        this.m_bDataLabelFontBoldChanged = false;
        this.m_bDataLabelFontItalicChanged = false;
        this.m_bDataLabelFontUnderlineChanged = false;
        this.m_bDataMarkerVisibleChanged = false;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.m_eh = eh;
    }

    public void setSelectedSeries(int series) {
        if (this.m_series != null) {
            this.m_series.setSelectedSeries(series);
        }
    }

    public int getSelectedSeries() {
        if (this.m_series != null) {
            return this.m_series.getSelectedSeries();
        }
        return -1;
    }

    public ErrorHandler getErrorHandler() {
        return this.m_eh;
    }

    public void setColorPalette(Color[][] colors) {
        BIColorChoice OAxisColor;
        BIColorChoice YAxisColor;
        if (colors != null) {
            this.m_colorPalette = FontButton.getArrayTwoDModel((Color[][])colors);
            this.m_bColorPaletteSet = true;
        } else {
            this.m_bColorPaletteSet = false;
            this.m_colorPalette = null;
        }
        if (this.m_bgColor != null) {
            this.m_backgroundColor.setSelectedColor((Color)this.m_backgroundColor.getColorPalette().getData(0, 0));
            this.m_backgroundColor.setColorPalette((TwoDModel)this.m_colorPalette);
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_backgroundColor.getColorPalette(), (Color)this.m_bgColor)) {
                    this.m_backgroundColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_backgroundColor.getColorPalette(), (Color)this.m_bgColor, (boolean)this.m_bColorPaletteSet));
                }
                this.m_backgroundColor.setSelectedColor(this.m_bgColor);
            } else {
                this.m_backgroundColor.setSelectedColor(this.m_backgroundColor.getClosestColor(this.m_bgColor));
            }
        } else {
            this.m_backgroundColor.setColorPalette((TwoDModel)this.m_colorPalette);
        }
        if (this.m_bdColor != null) {
            this.m_borderColor.setSelectedColor((Color)this.m_borderColor.getColorPalette().getData(0, 0));
            this.m_borderColor.setColorPalette((TwoDModel)this.m_colorPalette);
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_borderColor.getColorPalette(), (Color)this.m_bdColor)) {
                    this.m_borderColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_borderColor.getColorPalette(), (Color)this.m_bdColor, (boolean)this.m_bColorPaletteSet));
                }
                this.m_borderColor.setSelectedColor(this.m_bdColor);
            } else {
                this.m_borderColor.setSelectedColor(this.m_borderColor.getClosestColor(this.m_bdColor));
            }
        } else {
            this.m_borderColor.setColorPalette((TwoDModel)this.m_colorPalette);
        }
        if (!this.m_graph.isHorizontal()) {
            YAxisColor = this.m_horzColor;
            OAxisColor = this.m_vertColor;
        } else {
            YAxisColor = this.m_vertColor;
            OAxisColor = this.m_horzColor;
        }
        if (this.m_yColor != null) {
            YAxisColor.setSelectedColor((Color)YAxisColor.getColorPalette().getData(0, 0));
            YAxisColor.setColorPalette((TwoDModel)this.m_colorPalette);
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)YAxisColor.getColorPalette(), (Color)this.m_yColor)) {
                    YAxisColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)YAxisColor.getColorPalette(), (Color)this.m_yColor, (boolean)this.m_bColorPaletteSet));
                }
                YAxisColor.setSelectedColor(this.m_yColor);
            } else {
                YAxisColor.setSelectedColor(YAxisColor.getClosestColor(this.m_yColor));
            }
        } else {
            YAxisColor.setColorPalette((TwoDModel)this.m_colorPalette);
        }
        if (this.m_oColor != null) {
            OAxisColor.setSelectedColor((Color)OAxisColor.getColorPalette().getData(0, 0));
            OAxisColor.setColorPalette((TwoDModel)this.m_colorPalette);
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)OAxisColor.getColorPalette(), (Color)this.m_oColor)) {
                    OAxisColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)OAxisColor.getColorPalette(), (Color)this.m_oColor, (boolean)this.m_bColorPaletteSet));
                }
                OAxisColor.setSelectedColor(this.m_oColor);
            } else {
                OAxisColor.setSelectedColor(OAxisColor.getClosestColor(this.m_oColor));
            }
        } else {
            OAxisColor.setColorPalette((TwoDModel)this.m_colorPalette);
        }
        this.m_series.setColorPalette(this.m_colorPalette);
        if (this.m_dataLabel != null) {
            this.m_dataLabel.getFontButton().setColorPalette(this.m_colorPalette);
        }
        if (this.m_formatDialog != null) {
            this.m_formatDialog.setColorPalette(this.m_colorPalette);
        }
    }

    public Color[][] getColorPalette() {
        return FontButton.getColorArray((TwoDModel)this.m_backgroundColor.getColorPalette());
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_mainPanel.removeComponentListener(this.m_componentListener);
        this.m_componentListener = null;
        this.m_mainPanel.remove(this.m_series);
        this.m_series.cleanUp();
        this.m_series = null;
        this.m_dataTip = null;
        this.m_dataLabel = null;
        this.m_horzGridLinesPanel.remove(this.m_horzLineWidth);
        this.m_horzLineWidth.cleanUp();
        this.m_horzLineWidth = null;
        this.m_vertGridLinesPanel.remove(this.m_vertLineWidth);
        this.m_vertLineWidth.cleanUp();
        this.m_vertLineWidth = null;
    }

    private void _initialize(Graph graph, int columnMask) {
        this.updateResourceBundle(graph.getLocale());
        this.setTitleText(this.rBundle.getString("plot area options"));
        this.m_mainPanel.setLayout(new BoxLayout(this.m_mainPanel, 1));
        this.m_currentType = this.m_graph.getGraphType();
        this.m_tooltipType = this.m_graph.getMarkerTooltipType();
        this.m_labelPosition = 1;
        this.m_backgroundColorPanel = new JPanel();
        this.m_backgroundColorPanel.setLayout(new BoxLayout(this.m_backgroundColorPanel, 0));
        String translatedText = this.rBundle.getString("PlotArea Bg color");
        this.m_backgroundLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_backgroundLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_backgroundColor = new BIColorChoice();
        this.m_backgroundColor.setName("BackgroundColorChoice");
        this.m_backgroundColor.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_backgroundColor.setLocale(graph.getLocale());
        this.m_backgroundColor.setTransparentAllowed(true);
        this.m_backgroundLabel.setLabelFor((Component)this.m_backgroundColor);
        this.m_backgroundColorPanel.add(this.m_backgroundLabel);
        this.m_backgroundColorPanel.add((Component)this.m_backgroundColor);
        this.m_borderColorPanel = new JPanel();
        this.m_borderColorPanel.setLayout(new BoxLayout(this.m_borderColorPanel, 0));
        translatedText = this.rBundle.getString("PlotArea Br color");
        this.m_borderLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_borderLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_borderColor = new BIColorChoice();
        this.m_borderColor.setName("BorderColorChoice");
        this.m_borderColor.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_borderColor.setLocale(graph.getLocale());
        this.m_borderColor.setTransparentAllowed(true);
        this.m_borderLabel.setLabelFor((Component)this.m_borderColor);
        this.m_borderColorPanel.add(this.m_borderLabel);
        this.m_borderColorPanel.add((Component)this.m_borderColor);
        this.m_horzGridLinesPanel = new JPanel();
        this.m_horzGridLinesPanel.setLayout(new BoxLayout(this.m_horzGridLinesPanel, 0));
        translatedText = this.m_currentType == 65 || this.m_currentType == 67 ? this.rBundle.getString("Show Cg lines") : this.rBundle.getString("Show Hg lines");
        this.m_horzBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
        this.m_horzBox.setName("ShowHorizontalGridLinesCheck");
        this.m_horzBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_horzLineWidth = new LineWidth();
        this.m_horzLineWidth.setName("ShowHorizontalGridLinesCombo");
        this.m_horzColor = new BIColorChoice();
        this.m_horzColor.setName("HorizGridLinesColorChoice");
        this.m_horzColor.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_horzColor.setLocale(graph.getLocale());
        translatedText = this.rBundle.getString("Color I");
        this.m_horzLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_horzLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_horzLabel.setLabelFor((Component)this.m_horzColor);
        this.m_horzGridLinesPanel.add(this.m_horzBox);
        this.m_horzGridLinesPanel.add(this.m_horzLineWidth);
        this.m_horzGridLinesPanel.add(Box.createRigidArea(new Dimension(8, 0)));
        this.m_horzGridLinesPanel.add(this.m_horzLabel);
        this.m_horzGridLinesPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        this.m_horzGridLinesPanel.add((Component)this.m_horzColor);
        this.m_vertGridLinesPanel = new JPanel();
        this.m_vertGridLinesPanel.setLayout(new BoxLayout(this.m_vertGridLinesPanel, 0));
        translatedText = this.m_currentType == 65 || this.m_currentType == 67 ? this.rBundle.getString("Show Rg lines") : this.rBundle.getString("Show Vg lines");
        this.m_vertBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
        this.m_vertBox.setName("ShowVerticalGridLinesCheck");
        this.m_vertBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_vertLineWidth = new LineWidth();
        this.m_vertLineWidth.setName("ShowVerticalGridLinesCombo");
        this.m_vertColor = new BIColorChoice();
        this.m_vertColor.setName("VertGridLinesColorChoice");
        this.m_vertColor.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
        this.m_vertColor.setLocale(graph.getLocale());
        translatedText = this.rBundle.getString("Color II");
        this.m_vertLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_vertLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_vertLabel.setLabelFor((Component)this.m_vertColor);
        this.m_vertGridLinesPanel.add(this.m_vertBox);
        this.m_vertGridLinesPanel.add(this.m_vertLineWidth);
        this.m_vertGridLinesPanel.add(Box.createRigidArea(new Dimension(8, 0)));
        this.m_vertGridLinesPanel.add(this.m_vertLabel);
        this.m_vertGridLinesPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        this.m_vertGridLinesPanel.add((Component)this.m_vertColor);
        this.m_dataLabelsPanel = new JPanel();
        this.m_dataLabelsPanel.setLayout(new BoxLayout(this.m_dataLabelsPanel, 0));
        translatedText = !this._isDataLabelInTheCenterSupported() ? MessageFormat.format(this.rBundle.getString("PlotArea Show uneditable labels"), this._getDataLabelString()) : MessageFormat.format(this.rBundle.getString("PlotArea Show labels"), this._getDataLabelString());
        this.m_dataLabelBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
        this.m_dataLabelBox.setName("ShowDataLabelsForBars");
        this.m_dataLabelBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.setDataLabelOptions();
        this.m_dataTipsPanel = new JPanel();
        this.m_dataTipsPanel.setLayout(new BoxLayout(this.m_dataTipsPanel, 0));
        translatedText = MessageFormat.format(this.rBundle.getString("Show tips"), this._getDataLabelString());
        this.m_dataTipsBox = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
        this.m_dataTipsBox.setName("ShowDataTipsWhenMouseIsOverBars");
        this.m_dataTipsBox.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = this.rBundle.getString("Options II");
        this.m_dataTipsOption = new JButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_dataTipsOption.setName("DataTipsOptionsButton");
        this.m_dataTipsOption.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_dataTipsPanel.add(this.m_dataTipsBox);
        this.m_dataTipsPanel.add(Box.createRigidArea(new Dimension(8, 0)));
        this.m_dataTipsPanel.add(this.m_dataTipsOption);
        translatedText = this.rBundle.getString("Show data marker");
        translatedText = this.rBundle.getString("items options");
        this.m_seriesLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_seriesLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_series = new Series(graph, columnMask, StringUtils.stripMnemonic((String)translatedText));
        this.m_seriesLabel.setLabelFor(this.m_series);
        this.m_horzBox.setForeground(this.m_label.getForeground());
        this.m_vertBox.setForeground(this.m_label.getForeground());
        this.m_dataLabelBox.setForeground(this.m_label.getForeground());
        this.m_dataTipsBox.setForeground(this.m_label.getForeground());
        this.m_dataTipsOption.setForeground(this.m_label.getForeground());
        this.m_series.setForeground(this.m_label.getForeground());
        this.m_mainPanel.add(this.m_backgroundColorPanel);
        this.m_mainPanel.add(Box.createRigidArea(new Dimension(0, 4)));
        this.m_mainPanel.add(this.m_borderColorPanel);
        this.m_mainPanel.add(Box.createRigidArea(new Dimension(0, 4)));
        this.m_mainPanel.add(this.m_horzGridLinesPanel);
        this.m_mainPanel.add(this.m_vertGridLinesPanel);
        this.m_tmpPanel = Box.createRigidArea(new Dimension(0, 10));
        this.m_mainPanel.add(this.m_tmpPanel);
        this.m_mainPanel.add(this.m_dataLabelsPanel);
        this.m_mainPanel.add(Box.createRigidArea(new Dimension(0, 4)));
        this.m_mainPanel.add(this.m_dataTipsPanel);
        this.m_mainPanel.add(Box.createRigidArea(new Dimension(0, 4)));
        this.m_mainPanel.add(this.m_seriesLabel);
        this.m_mainPanel.add(Box.createRigidArea(new Dimension(0, 3)));
        if (this.m_series != null) {
            this.m_mainPanel.add(this.m_series);
        }
        this.m_mainPanel.add(Box.createVerticalGlue());
        if (graph.getGraphType() == 12 || graph.getGraphType() == 70 || graph.getGraphType() == 71 || graph.getGraphType() == 72 || graph.getGraphType() == 84) {
            this.m_seriesLabel.setVisible(false);
            this.m_series.setVisible(false);
        }
        this.m_backgroundColorPanel.setAlignmentX(0.0f);
        this.m_borderColorPanel.setAlignmentX(0.0f);
        this.m_horzGridLinesPanel.setAlignmentX(0.0f);
        this.m_vertGridLinesPanel.setAlignmentX(0.0f);
        this.m_dataLabelsPanel.setAlignmentX(0.0f);
        this.m_dataTipsPanel.setAlignmentX(0.0f);
        this.m_seriesLabel.setAlignmentX(0.0f);
        this.m_series.setAlignmentX(0.0f);
        this.sizeComponents();
        this.m_dataTipsOption.addActionListener(this);
        this.m_backgroundColor.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_borderColor.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_vertColor.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_horzColor.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_horzBox.addItemListener(this);
        this.m_horzLineWidth.addItemListener(this);
        this.m_vertBox.addItemListener(this);
        this.m_vertLineWidth.addItemListener(this);
        this.m_dataLabelBox.addItemListener(this);
        this.m_dataTipsBox.addItemListener(this);
        this._init();
        this.m_dataTip = null;
        this.m_dataLabel = null;
        this.m_bBackgroundChanged = false;
        this.m_bBorderColorChanged = false;
        this.m_bHorzVisibleChanged = false;
        this.m_bHorzColorChanged = false;
        this.m_bHorzWidthChanged = false;
        this.m_bVertVisibleChanged = false;
        this.m_bVertColorChanged = false;
        this.m_bVertWidthChanged = false;
        this.m_bDataLabelVisibleChanged = false;
        this.m_bDataTipVisibleChanged = false;
        this.m_bDataLabelPositionChanged = false;
        this.m_bDataLabelTextTypeChanged = false;
        this.m_bDataTipTypeChanged = false;
        this.m_bDataLabelFontColorChanged = false;
        this.m_bDataLabelFontNameChanged = false;
        this.m_bDataLabelFontSizeChanged = false;
        this.m_bDataLabelFontBoldChanged = false;
        this.m_bDataLabelFontItalicChanged = false;
        this.m_bDataLabelFontUnderlineChanged = false;
        this.m_bDataMarkerVisibleChanged = false;
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.graph.gui.resource.GraphGUIBundle");
    }

    private String _getDataLabelString() {
        String str = "";
        switch (this.m_currentType) {
            case 17: 
            case 19: {
                str = str + this.rBundle.getString("bars");
                break;
            }
            case 97: 
            case 98: {
                str = str + this.rBundle.getString("markers");
                break;
            }
            case 0: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 96: {
                str = str + this.rBundle.getString("bars");
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                if (this.m_graph.isLineDataLineDisplayed()) {
                    str = str + this.rBundle.getString("lines");
                    break;
                }
                str = str + this.rBundle.getString("points");
                break;
            }
            case 6: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                str = str + this.rBundle.getString("areas");
                break;
            }
            case 55: 
            case 57: 
            case 93: {
                str = str + this.rBundle.getString("pie slices");
                break;
            }
            case 100: {
                str = str + this.rBundle.getString("funnel slices");
                break;
            }
            case 56: 
            case 58: 
            case 94: {
                str = str + this.rBundle.getString("ring slices");
                break;
            }
            case 61: 
            case 62: 
            case 65: {
                str = str + this.rBundle.getString("markers");
                break;
            }
            case 67: {
                str = str + this.rBundle.getString("lines");
                break;
            }
            case 89: 
            case 91: {
                str = str + this.rBundle.getString("bubbles");
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 76: 
            case 79: 
            case 83: 
            case 84: 
            case 88: {
                str = str + this.rBundle.getString("stock markers");
                break;
            }
            case 4: {
                str = str + this.rBundle.getString("cubes");
                break;
            }
            case 7: {
                str = str + this.rBundle.getString("ribbons");
                break;
            }
            case 12: {
                str = str + this.rBundle.getString("surface");
            }
        }
        return str;
    }

    private boolean _isDataLabelInTheCenterSupported() {
        boolean yesNo = false;
        switch (this.m_currentType) {
            case 17: 
            case 19: {
                yesNo = true;
                break;
            }
            case 97: 
            case 98: {
                yesNo = false;
                break;
            }
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 88: 
            case 93: 
            case 94: 
            case 96: 
            case 100: {
                yesNo = true;
                break;
            }
            default: {
                yesNo = false;
            }
        }
        return yesNo;
    }

    private boolean _isPie() {
        return this.m_currentType >= 55 && this.m_currentType <= 60 || this.m_currentType >= 93 && this.m_currentType <= 94;
    }

    private boolean _isFunnel() {
        return this.m_currentType == 100;
    }

    private boolean _isPercentGraph() {
        return this._isPie() || this.m_currentType == 35 || this.m_currentType == 23 || this.m_currentType == 47 || this.m_currentType == 40 || this.m_currentType == 30 || this.m_currentType == 54;
    }

    private boolean _isThreeD() {
        return this.m_currentType >= 0 && this.m_currentType <= 14;
    }

    private void _init() {
        if (this._isThreeD()) {
            if (!this.m_graph.get3DFloor().isFillTransparent()) {
                Color floorColor;
                this.m_bgColor = floorColor = this.m_graph.get3DFloor().getFillColor();
                if (!this.m_bColorPaletteSet) {
                    if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_backgroundColor.getColorPalette(), (Color)floorColor)) {
                        this.m_backgroundColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_backgroundColor.getColorPalette(), (Color)floorColor, (boolean)this.m_bColorPaletteSet));
                    }
                    this.m_backgroundColor.setSelectedColor(floorColor);
                } else {
                    this.m_backgroundColor.setSelectedColor(this.m_backgroundColor.getClosestColor(floorColor));
                }
            } else {
                this.m_bgColor = c_Transparent;
            }
            if (!this.m_graph.get3DFloor().isBorderTransparent()) {
                this.m_bColor = this.m_graph.get3DFloor().getBorderColor();
                if (!this.m_bColorPaletteSet) {
                    if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_borderColor.getColorPalette(), (Color)this.m_bColor)) {
                        this.m_borderColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_borderColor.getColorPalette(), (Color)this.m_bColor, (boolean)this.m_bColorPaletteSet));
                    }
                    this.m_borderColor.setSelectedColor(this.m_bColor);
                } else {
                    this.m_borderColor.setSelectedColor(this.m_borderColor.getClosestColor(this.m_bColor));
                }
            } else {
                this.m_bColor = c_Transparent;
            }
            this.m_bdColor = this.m_bColor;
            this.m_horzGridLinesPanel.setVisible(false);
            this.m_vertGridLinesPanel.setVisible(false);
            this.m_tmpPanel.setVisible(false);
            this.m_dataLabelsPanel.setVisible(false);
        } else if (this._isPie() || this._isFunnel()) {
            Color color;
            if (this._isFunnel()) {
                if (!this.m_graph.getFunnelFrame().isFillTransparent()) {
                    this.m_bgColor = color = this.m_graph.getFunnelFrame().getFillColor();
                    if (!this.m_bColorPaletteSet) {
                        if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_backgroundColor.getColorPalette(), (Color)color)) {
                            this.m_backgroundColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_backgroundColor.getColorPalette(), (Color)color, (boolean)this.m_bColorPaletteSet));
                        }
                        this.m_backgroundColor.setSelectedColor(color);
                    } else {
                        this.m_backgroundColor.setSelectedColor(this.m_backgroundColor.getClosestColor(color));
                    }
                } else {
                    this.m_bgColor = null;
                }
                if (!this.m_graph.getFunnelFrame().isBorderTransparent()) {
                    this.m_bColor = this.m_graph.getFunnelFrame().getBorderColor();
                    if (!this.m_bColorPaletteSet) {
                        if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_borderColor.getColorPalette(), (Color)this.m_bColor)) {
                            this.m_borderColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_borderColor.getColorPalette(), (Color)this.m_bColor, (boolean)this.m_bColorPaletteSet));
                        }
                        this.m_borderColor.setSelectedColor(this.m_bColor);
                    } else {
                        this.m_borderColor.setSelectedColor(this.m_borderColor.getClosestColor(this.m_bColor));
                    }
                } else {
                    this.m_bColor = c_Transparent;
                }
            } else {
                if (!this.m_graph.getPieFrame().isFillTransparent()) {
                    this.m_bgColor = color = this.m_graph.getPieFrame().getFillColor();
                    if (!this.m_bColorPaletteSet) {
                        if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_backgroundColor.getColorPalette(), (Color)color)) {
                            this.m_backgroundColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_backgroundColor.getColorPalette(), (Color)color, (boolean)this.m_bColorPaletteSet));
                        }
                        this.m_backgroundColor.setSelectedColor(color);
                    } else {
                        this.m_backgroundColor.setSelectedColor(this.m_backgroundColor.getClosestColor(color));
                    }
                } else {
                    this.m_bgColor = null;
                }
                if (!this.m_graph.getPieFrame().isBorderTransparent()) {
                    this.m_bColor = this.m_graph.getPieFrame().getBorderColor();
                    if (!this.m_bColorPaletteSet) {
                        if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_borderColor.getColorPalette(), (Color)this.m_bColor)) {
                            this.m_borderColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_borderColor.getColorPalette(), (Color)this.m_bColor, (boolean)this.m_bColorPaletteSet));
                        }
                        this.m_borderColor.setSelectedColor(this.m_bColor);
                    } else {
                        this.m_borderColor.setSelectedColor(this.m_borderColor.getClosestColor(this.m_bColor));
                    }
                } else {
                    this.m_bColor = c_Transparent;
                }
            }
            this.m_bdColor = this.m_bColor;
            this.m_horzGridLinesPanel.setVisible(false);
            this.m_vertGridLinesPanel.setVisible(false);
            this.m_tmpPanel.setVisible(false);
            int textDisplay = this.m_graph.getSlice().getLabelPosition();
            if (textDisplay > 0) {
                this.m_dataLabelBox.setSelected(true);
            } else {
                this.m_dataLabelBox.setSelected(false);
            }
            this.m_labelPosition = this.m_graph.getSlice().getLabelPosition();
            if (this.m_labelPosition == 0) {
                ++this.m_labelPosition;
            }
        } else {
            LineWidth OAxisLineWidth;
            LineWidth YAxisLineWidth;
            BIColorChoice OAxisColor;
            BIColorChoice YAxisColor;
            JCheckBox OAxisCheckBox;
            JCheckBox YAxisCheckBox;
            if (!this.m_graph.getPlotArea().isFillTransparent()) {
                Color color;
                this.m_bgColor = color = this.m_graph.getPlotArea().getFillColor();
                if (!this.m_bColorPaletteSet) {
                    if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_backgroundColor.getColorPalette(), (Color)color)) {
                        this.m_backgroundColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_backgroundColor.getColorPalette(), (Color)color, (boolean)this.m_bColorPaletteSet));
                    }
                    this.m_backgroundColor.setSelectedColor(color);
                } else {
                    this.m_backgroundColor.setSelectedColor(this.m_backgroundColor.getClosestColor(color));
                }
            } else {
                this.m_bgColor = c_Transparent;
            }
            if (!this.m_graph.getPlotArea().isBorderTransparent()) {
                this.m_bColor = this.m_graph.getPlotArea().getBorderColor();
                if (!this.m_bColorPaletteSet) {
                    if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_borderColor.getColorPalette(), (Color)this.m_bColor)) {
                        this.m_borderColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)this.m_borderColor.getColorPalette(), (Color)this.m_bColor, (boolean)this.m_bColorPaletteSet));
                    }
                    this.m_borderColor.setSelectedColor(this.m_bColor);
                } else {
                    this.m_borderColor.setSelectedColor(this.m_borderColor.getClosestColor(this.m_bColor));
                }
            } else {
                this.m_bColor = c_Transparent;
            }
            this.m_bdColor = this.m_bColor;
            if (!this.m_graph.isHorizontal()) {
                YAxisCheckBox = this.m_horzBox;
                OAxisCheckBox = this.m_vertBox;
                YAxisColor = this.m_horzColor;
                OAxisColor = this.m_vertColor;
                YAxisLineWidth = this.m_horzLineWidth;
                OAxisLineWidth = this.m_vertLineWidth;
            } else {
                YAxisCheckBox = this.m_vertBox;
                OAxisCheckBox = this.m_horzBox;
                YAxisColor = this.m_vertColor;
                OAxisColor = this.m_horzColor;
                YAxisLineWidth = this.m_vertLineWidth;
                OAxisLineWidth = this.m_horzLineWidth;
            }
            YAxisCheckBox.setSelected(this.m_graph.getY1MajorTick().getTickStyle() != 6);
            Color color = this.m_graph.getY1MajorTick().getLineColor();
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)YAxisColor.getColorPalette(), (Color)color)) {
                    YAxisColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)YAxisColor.getColorPalette(), (Color)color, (boolean)this.m_bColorPaletteSet));
                }
                YAxisColor.setSelectedColor(color);
            } else {
                YAxisColor.setSelectedColor(YAxisColor.getClosestColor(color));
            }
            this.m_yColor = color;
            YAxisLineWidth.setCellColor(YAxisColor.getSelectedColor());
            YAxisLineWidth.setLineWidth(this.m_graph.getY1MajorTick().getLineWidth());
            if (this.m_currentType >= 61 && this.m_currentType <= 64 || this.m_currentType >= 89 && this.m_currentType <= 92 || this.m_currentType >= 65 && this.m_currentType <= 66) {
                OAxisCheckBox.setSelected(this.m_graph.getX1MajorTick().getTickStyle() != 6);
                color = this.m_graph.getX1MajorTick().getLineColor();
                OAxisLineWidth.setLineWidth(this.m_graph.getX1MajorTick().getLineWidth());
            } else {
                if (this.m_graph.getGraphType() == 68 || this.m_graph.getGraphType() == 67 || this.m_graph.getGraphType() == 69) {
                    OAxisCheckBox.setSelected(this.m_graph.getO1MajorTick().getTickStyle() != 6);
                } else {
                    OAxisCheckBox.setSelected(this.m_graph.getO1MajorTick().getTickStyle() != 6 && this.m_graph.getO1MajorTick().getTickStyle() != 5);
                }
                color = this.m_graph.getO1MajorTick().getLineColor();
                OAxisLineWidth.setLineWidth(this.m_graph.getO1MajorTick().getLineWidth());
            }
            if (!this.m_bColorPaletteSet) {
                if (!BIColorChoice.isColorInPalette((TwoDModel)OAxisColor.getColorPalette(), (Color)color)) {
                    OAxisColor.setColorPalette(FontButton.getNewColorPalette((TwoDModel)OAxisColor.getColorPalette(), (Color)color, (boolean)this.m_bColorPaletteSet));
                }
                OAxisColor.setSelectedColor(color);
            } else {
                OAxisColor.setSelectedColor(OAxisColor.getClosestColor(color));
            }
            this.m_oColor = color;
            OAxisLineWidth.setCellColor(OAxisColor.getSelectedColor());
            this.m_dataLabelBox.setSelected(this.m_graph.getMarkerText().isVisible());
            if (this.m_currentType >= 67 && this.m_currentType <= 69 || this.m_currentType == 65 || this.m_currentType == 66) {
                YAxisLineWidth.setVisible(false);
                OAxisLineWidth.setEnabled(OAxisCheckBox.isSelected());
            } else {
                YAxisLineWidth.setEnabled(YAxisCheckBox.isSelected());
                OAxisLineWidth.setEnabled(OAxisCheckBox.isSelected());
            }
            if (this.m_graph.getGraphType() == 40 || this.m_graph.getGraphType() == 35) {
                this.m_backgroundLabel.setEnabled(false);
                this.m_backgroundColor.setEnabled(false);
                this.m_borderLabel.setEnabled(false);
                this.m_borderColor.setEnabled(false);
                this.m_horzBox.setEnabled(false);
                this.m_horzLineWidth.setEnabled(false);
                this.m_horzColor.setEnabled(false);
                this.m_vertBox.setEnabled(false);
                this.m_vertLineWidth.setEnabled(false);
                this.m_vertColor.setEnabled(false);
                this.m_vertLabel.setEnabled(false);
                this.m_horzLabel.setEnabled(false);
            }
        }
        if (this.m_tooltipType > 0) {
            this.m_dataTipsBox.setSelected(true);
        } else {
            this.m_dataTipsBox.setSelected(false);
        }
        this.m_oldBackgroundColor = this.m_backgroundColor.getSelectedColor();
        this.m_oldHorzColor = this.m_horzColor.getSelectedColor();
        this.m_oldHorzLineWidth = this.m_horzLineWidth.getLineWidth();
        this.m_oldVertColor = this.m_vertColor.getSelectedColor();
        this.m_oldVertLineWidth = this.m_vertLineWidth.getLineWidth();
        this.m_bBorderColorChanged = false;
        this.m_bBackgroundChanged = false;
        this.m_bHorzColorChanged = false;
        this.m_bVertColorChanged = false;
        this.m_bHorzWidthChanged = false;
        this.m_bVertWidthChanged = false;
        this.m_bHorzVisibleChanged = false;
        this.m_bVertVisibleChanged = false;
        if (!this.m_dataLabelBox.isSelected()) {
            if (this.m_dataLabelOption != null) {
                this.m_dataLabelOption.setEnabled(false);
            } else {
                this.m_fontButton.setEnabled(false);
            }
        }
        if (!this.m_dataTipsBox.isSelected()) {
            this.m_dataTipsOption.setEnabled(false);
        }
        if (!this.m_vertBox.isSelected()) {
            this.m_vertLineWidth.setEnabled(false);
            this.m_vertLabel.setEnabled(false);
            this.m_vertColor.setEnabled(false);
        }
        if (!this.m_horzBox.isSelected()) {
            this.m_horzLineWidth.setEnabled(false);
            this.m_horzLabel.setEnabled(false);
            this.m_horzColor.setEnabled(false);
        }
    }

    private void setDataLabelOptions() {
        this.m_dataLabelsPanel.removeAll();
        this.m_dataLabelOption = null;
        this.m_fontButton = null;
        if (!this._isDataLabelInTheCenterSupported()) {
            String translatedText = this.rBundle.getString("Format Labels");
            this.m_fontButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
            this.m_fontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_dataLabelsPanel.add(this.m_dataLabelBox);
            this.m_dataLabelsPanel.add(Box.createRigidArea(new Dimension(8, 0)));
            this.m_dataLabelsPanel.add(this.m_fontButton);
        } else {
            String translatedText = this.rBundle.getString("Options I");
            this.m_dataLabelOption = new JButton(StringUtils.stripMnemonic((String)translatedText));
            this.m_dataLabelOption.setName("DataLabelOptionsButton");
            this.m_dataLabelOption.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_dataLabelsPanel.add(this.m_dataLabelBox);
            this.m_dataLabelsPanel.add(Box.createRigidArea(new Dimension(8, 0)));
            this.m_dataLabelsPanel.add(this.m_dataLabelOption);
        }
        if (this.m_dataLabelOption != null) {
            this.m_dataLabelOption.addActionListener(this);
            this.m_dataLabelOption.setForeground(this.m_label.getForeground());
        } else {
            this.m_fontButton.addActionListener(this);
        }
    }

    protected void sizeComponents() {
        int adjLabelWidth;
        JCheckBox checkBox = new JCheckBox();
        int iconWidth = checkBox.getPreferredSize().width;
        this.m_backgroundColorPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 35));
        this.m_backgroundColorPanel.setMinimumSize(this.m_backgroundColorPanel.getPreferredSize());
        this.m_backgroundColorPanel.setMaximumSize(this.m_backgroundColorPanel.getPreferredSize());
        this.m_borderColorPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 35));
        this.m_borderColorPanel.setMinimumSize(this.m_borderColorPanel.getPreferredSize());
        this.m_borderColorPanel.setMaximumSize(this.m_borderColorPanel.getPreferredSize());
        this.m_horzGridLinesPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 32));
        this.m_horzGridLinesPanel.setMinimumSize(this.m_horzGridLinesPanel.getPreferredSize());
        this.m_horzGridLinesPanel.setMaximumSize(this.m_horzGridLinesPanel.getPreferredSize());
        this.m_vertGridLinesPanel.setPreferredSize(new Dimension(this.getToolkit().getScreenSize().width, 32));
        this.m_vertGridLinesPanel.setMinimumSize(this.m_vertGridLinesPanel.getPreferredSize());
        this.m_vertGridLinesPanel.setMaximumSize(this.m_vertGridLinesPanel.getPreferredSize());
        int horzWidth = this.getToolkit().getFontMetrics(this.m_horzBox.getFont()).stringWidth(this.m_horzBox.getText());
        int vertWidth = this.getToolkit().getFontMetrics(this.m_vertBox.getFont()).stringWidth(this.m_vertBox.getText());
        int backWidth = this.getToolkit().getFontMetrics(this.m_backgroundLabel.getFont()).stringWidth(this.m_backgroundLabel.getText());
        int width = horzWidth;
        if (vertWidth > width) {
            width = vertWidth;
        }
        if (backWidth > width) {
            width = backWidth;
        }
        this.m_vertBox.setPreferredSize(new Dimension(width + iconWidth + 4, this.m_vertBox.getPreferredSize().height));
        this.m_vertBox.setMinimumSize(this.m_vertBox.getPreferredSize());
        this.m_vertBox.setMaximumSize(this.m_vertBox.getPreferredSize());
        this.m_horzBox.setPreferredSize(this.m_vertBox.getPreferredSize());
        this.m_horzBox.setMinimumSize(this.m_vertBox.getPreferredSize());
        this.m_horzBox.setMaximumSize(this.m_vertBox.getPreferredSize());
        this.m_backgroundLabel.setPreferredSize(this.m_vertBox.getPreferredSize());
        this.m_backgroundLabel.setMinimumSize(this.m_vertBox.getPreferredSize());
        this.m_backgroundLabel.setMaximumSize(this.m_vertBox.getPreferredSize());
        this.m_borderLabel.setPreferredSize(this.m_vertBox.getPreferredSize());
        this.m_borderLabel.setMinimumSize(this.m_vertBox.getPreferredSize());
        this.m_borderLabel.setMaximumSize(this.m_vertBox.getPreferredSize());
        int dataLabelWidth = this.getToolkit().getFontMetrics(this.m_dataLabelBox.getFont()).stringWidth(this.m_dataLabelBox.getText());
        int dataTipsWidth = this.getToolkit().getFontMetrics(this.m_dataTipsBox.getFont()).stringWidth(this.m_dataTipsBox.getText());
        int colorWidth = this.getToolkit().getFontMetrics(this.m_horzLabel.getFont()).stringWidth(this.m_horzLabel.getText());
        int gridWidth = this.m_horzLineWidth.getPreferredSize().width + width;
        int dataWidth = dataLabelWidth;
        if (dataTipsWidth > dataWidth) {
            dataWidth = dataTipsWidth;
        }
        if (dataWidth < gridWidth) {
            dataWidth = gridWidth;
        }
        int labelWidth = dataWidth + iconWidth + 4;
        if (!this._isDataLabelInTheCenterSupported()) {
            JButton button1 = new JButton(this.rBundle.getString("Format Labels"));
            JButton button2 = new JButton(this.rBundle.getString("Options I"));
            adjLabelWidth = labelWidth - (button1.getPreferredSize().width - button2.getPreferredSize().width);
        } else {
            adjLabelWidth = labelWidth;
        }
        this.m_dataLabelBox.setPreferredSize(new Dimension(adjLabelWidth, this.m_dataLabelBox.getPreferredSize().height));
        this.m_dataLabelBox.setMinimumSize(this.m_dataLabelBox.getPreferredSize());
        this.m_dataLabelBox.setMaximumSize(this.m_dataLabelBox.getPreferredSize());
        this.m_dataTipsBox.setPreferredSize(new Dimension(labelWidth, this.m_dataLabelBox.getPreferredSize().height));
        this.m_dataTipsBox.setMinimumSize(this.m_dataTipsBox.getPreferredSize());
        this.m_dataTipsBox.setMaximumSize(this.m_dataTipsBox.getPreferredSize());
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
    }

    @Override
    public void apply() {
        if (this.m_dataLabel != null) {
            this.m_dataLabel.apply();
        }
        if (this._isThreeD()) {
            boolean bTemp = this.m_graph.get3DFloor().isSharePanelProperties();
            this.m_graph.get3DFloor().setSharePanelProperties(true);
            if (this.m_bBackgroundChanged) {
                if (this.m_bgColor != c_Transparent) {
                    this.m_graph.get3DFloor().setFillColor(this.m_backgroundColor.getSelectedColor());
                    this.m_graph.get3DFloor().getSFX().setFillType(1);
                    this.m_graph.get3DFloor().setFillTransparent(false);
                } else {
                    this.m_graph.get3DFloor().setFillTransparent(true);
                    this.m_graph.get3DFloor().getSFX().setFillType(1);
                }
            }
            if (this.m_bBorderColorChanged) {
                if (this.m_bColor != c_Transparent) {
                    if (!this.m_graph.get3DFloor().getBorderColor().equals(this.m_bColor)) {
                        this.m_graph.get3DFloor().setBorderColor(this.m_bColor);
                    }
                    this.m_graph.get3DFloor().setBorderTransparent(false);
                } else {
                    this.m_graph.get3DFloor().setBorderTransparent(true);
                }
            }
            this.m_graph.get3DFloor().setSharePanelProperties(bTemp);
        } else if (this._isPie() || this._isFunnel()) {
            if (this.m_formatDialog != null) {
                if (this.m_bDataLabelFontNameChanged) {
                    this.m_graph.getSliceLabel().getGraphFont().setGraphFontTypeface(this.m_formatDialog.getComponentFont().getFontName());
                }
                if (this.m_bDataLabelFontSizeChanged) {
                    this.m_graph.getSliceLabel().getGraphFont().setGraphFontSize(this.m_formatDialog.getComponentFont().getSize());
                }
                if (this.m_bDataLabelFontBoldChanged) {
                    this.m_graph.getSliceLabel().getGraphFont().setFontBold(this.m_formatDialog.getComponentFont().isBold());
                }
                if (this.m_bDataLabelFontItalicChanged) {
                    this.m_graph.getSliceLabel().getGraphFont().setFontItalic(this.m_formatDialog.getComponentFont().isItalic());
                }
                if (this.m_bDataLabelFontUnderlineChanged) {
                    this.m_graph.getSliceLabel().getGraphFont().setUnderline(this.m_formatDialog.isUnderlineStyle());
                }
                if (this.m_bDataLabelFontColorChanged) {
                    this.m_graph.getSliceLabel().getGraphFont().setGraphFontColor(this.m_formatDialog.getComponentForeground());
                }
            }
            if (this.m_bBackgroundChanged) {
                if (this.m_bgColor != c_Transparent) {
                    if (this._isFunnel()) {
                        this.m_graph.getFunnelFrame().setFillColor(this.m_backgroundColor.getSelectedColor());
                        this.m_graph.getFunnelFrame().getSFX().setFillType(1);
                        this.m_graph.getFunnelFrame().setFillTransparent(false);
                    } else {
                        this.m_graph.getPieFrame().setFillColor(this.m_backgroundColor.getSelectedColor());
                        this.m_graph.getPieFrame().getSFX().setFillType(1);
                        this.m_graph.getPieFrame().setFillTransparent(false);
                    }
                } else if (this._isFunnel()) {
                    this.m_graph.getFunnelFrame().setFillTransparent(true);
                    this.m_graph.getFunnelFrame().getSFX().setFillType(1);
                } else {
                    this.m_graph.getPieFrame().setFillTransparent(true);
                    this.m_graph.getPieFrame().getSFX().setFillType(1);
                }
            }
            if (this.m_bBorderColorChanged) {
                if (this.m_bColor != c_Transparent) {
                    if (this._isFunnel()) {
                        if (!this.m_graph.getFunnelFrame().getBorderColor().equals(this.m_bColor)) {
                            this.m_graph.getFunnelFrame().setBorderColor(this.m_bColor);
                        }
                        this.m_graph.getFunnelFrame().setBorderTransparent(false);
                    } else {
                        if (!this.m_graph.getPieFrame().getBorderColor().equals(this.m_bColor)) {
                            this.m_graph.getPieFrame().setBorderColor(this.m_bColor);
                        }
                        this.m_graph.getPieFrame().setBorderTransparent(false);
                    }
                } else if (this._isFunnel()) {
                    this.m_graph.getFunnelFrame().setBorderTransparent(true);
                } else {
                    this.m_graph.getPieFrame().setBorderTransparent(true);
                }
            }
            if (this.m_dataLabelBox.isSelected()) {
                this.m_graph.getSlice().setLabelPosition(this.m_labelPosition);
            } else {
                this.m_graph.getSlice().setLabelPosition(0);
            }
        } else {
            boolean m_vertWidthChanged;
            boolean m_horzWidthChanged;
            boolean m_vertColorChanged;
            boolean m_horzColorChanged;
            boolean m_vertVisibleChanged;
            boolean m_horzVisibleChanged;
            LineWidth OAxisLineWidth;
            LineWidth YAxisLineWidth;
            BIColorChoice OAxisColor;
            BIColorChoice YAxisColor;
            JCheckBox OAxisCheckBox;
            JCheckBox YAxisCheckBox;
            if (this.m_formatDialog != null) {
                if (this.m_bDataLabelFontNameChanged) {
                    this.m_graph.getMarkerText().getGraphFont().setGraphFontTypeface(this.m_formatDialog.getComponentFont().getFontName());
                }
                if (this.m_bDataLabelFontSizeChanged) {
                    this.m_graph.getMarkerText().getGraphFont().setGraphFontSize(this.m_formatDialog.getComponentFont().getSize());
                }
                if (this.m_bDataLabelFontBoldChanged) {
                    this.m_graph.getMarkerText().getGraphFont().setFontBold(this.m_formatDialog.getComponentFont().isBold());
                }
                if (this.m_bDataLabelFontItalicChanged) {
                    this.m_graph.getMarkerText().getGraphFont().setFontItalic(this.m_formatDialog.getComponentFont().isItalic());
                }
                if (this.m_bDataLabelFontUnderlineChanged) {
                    this.m_graph.getMarkerText().getGraphFont().setUnderline(this.m_formatDialog.isUnderlineStyle());
                }
                if (this.m_bDataLabelFontColorChanged) {
                    this.m_graph.getMarkerText().getGraphFont().setGraphFontColor(this.m_formatDialog.getComponentForeground());
                }
            }
            if (this.m_bBackgroundChanged) {
                if (this.m_bgColor != c_Transparent) {
                    this.m_graph.getPlotArea().setFillColor(this.m_backgroundColor.getSelectedColor());
                    this.m_graph.getPlotArea().getSFX().setFillType(1);
                    this.m_graph.getPlotArea().setFillTransparent(false);
                } else {
                    this.m_graph.getPlotArea().setFillTransparent(true);
                    this.m_graph.getPlotArea().getSFX().setFillType(1);
                }
            }
            if (this.m_bBorderColorChanged) {
                if (this.m_bColor != c_Transparent) {
                    if (!this.m_graph.getPlotArea().getBorderColor().equals(this.m_bColor)) {
                        this.m_graph.getPlotArea().setBorderColor(this.m_bColor);
                    }
                    this.m_graph.getPlotArea().setBorderTransparent(false);
                } else {
                    this.m_graph.getPlotArea().setBorderTransparent(true);
                }
            }
            if (!this.m_graph.isHorizontal()) {
                YAxisCheckBox = this.m_horzBox;
                OAxisCheckBox = this.m_vertBox;
                YAxisColor = this.m_horzColor;
                OAxisColor = this.m_vertColor;
                YAxisLineWidth = this.m_horzLineWidth;
                OAxisLineWidth = this.m_vertLineWidth;
                m_horzVisibleChanged = this.m_bVertVisibleChanged;
                m_vertVisibleChanged = this.m_bHorzVisibleChanged;
                m_horzColorChanged = this.m_bVertColorChanged;
                m_vertColorChanged = this.m_bHorzColorChanged;
                m_horzWidthChanged = this.m_bVertWidthChanged;
                m_vertWidthChanged = this.m_bHorzWidthChanged;
            } else {
                YAxisCheckBox = this.m_vertBox;
                OAxisCheckBox = this.m_horzBox;
                YAxisColor = this.m_vertColor;
                OAxisColor = this.m_horzColor;
                YAxisLineWidth = this.m_vertLineWidth;
                OAxisLineWidth = this.m_horzLineWidth;
                m_horzVisibleChanged = this.m_bHorzVisibleChanged;
                m_vertVisibleChanged = this.m_bVertVisibleChanged;
                m_horzColorChanged = this.m_bHorzColorChanged;
                m_vertColorChanged = this.m_bVertColorChanged;
                m_horzWidthChanged = this.m_bHorzWidthChanged;
                m_vertWidthChanged = this.m_bVertWidthChanged;
            }
            if (m_vertVisibleChanged) {
                if (YAxisCheckBox.isSelected()) {
                    this.m_graph.getY1MajorTick().setTickStyle(5);
                } else {
                    this.m_graph.getY1MajorTick().setTickStyle(6);
                }
            }
            if (m_vertWidthChanged) {
                this.m_graph.getY1MajorTick().setLineWidth(YAxisLineWidth.getLineWidth());
            }
            if (m_vertColorChanged) {
                this.m_graph.getY1MajorTick().setLineColor(YAxisColor.getSelectedColor());
            }
            if (m_vertVisibleChanged) {
                if (YAxisCheckBox.isSelected()) {
                    this.m_graph.getY2MajorTick().setTickStyle(5);
                } else {
                    this.m_graph.getY2MajorTick().setTickStyle(6);
                }
            }
            if (m_vertWidthChanged) {
                this.m_graph.getY2MajorTick().setLineWidth(YAxisLineWidth.getLineWidth());
            }
            if (m_vertColorChanged) {
                this.m_graph.getY2MajorTick().setLineColor(YAxisColor.getSelectedColor());
            }
            if (m_horzVisibleChanged) {
                if (OAxisCheckBox.isSelected()) {
                    this.m_graph.getX1MajorTick().setTickStyle(5);
                } else {
                    this.m_graph.getX1MajorTick().setTickStyle(6);
                }
            }
            if (m_horzWidthChanged) {
                this.m_graph.getX1MajorTick().setLineWidth(OAxisLineWidth.getLineWidth());
            }
            if (m_horzColorChanged) {
                this.m_graph.getX1MajorTick().setLineColor(OAxisColor.getSelectedColor());
            }
            if (m_horzVisibleChanged) {
                if (this.m_graph.getGraphType() == 68 || this.m_graph.getGraphType() == 67 || this.m_graph.getGraphType() == 69) {
                    if (OAxisCheckBox.isSelected()) {
                        this.m_graph.getO1MajorTick().setTickStyle(5);
                    } else {
                        this.m_graph.getO1MajorTick().setTickStyle(6);
                    }
                } else if (OAxisCheckBox.isSelected()) {
                    this.m_graph.getO1MajorTick().setTickStyle(0);
                } else {
                    this.m_graph.getO1MajorTick().setTickStyle(5);
                }
            }
            if (m_horzWidthChanged) {
                this.m_graph.getO1MajorTick().setLineWidth(OAxisLineWidth.getLineWidth());
            }
            if (m_horzColorChanged) {
                this.m_graph.getO1MajorTick().setLineColor(OAxisColor.getSelectedColor());
            }
            if (this.m_bDataLabelVisibleChanged) {
                this.m_graph.getMarkerText().setVisible(this.m_dataLabelBox.isSelected());
            }
        }
        if (this.m_bDataTipVisibleChanged || this.m_bDataTipTypeChanged) {
            if (this.m_dataTipsBox.isSelected()) {
                if (this.m_dataTip != null) {
                    this.m_dataTip.apply();
                } else if (this.m_tooltipType == 0) {
                    this.m_tooltipType |= 1;
                }
                this.m_graph.setMarkerTooltipType(this.m_tooltipType);
            } else {
                this.m_graph.setMarkerTooltipType(0);
            }
        }
        this.m_series.apply();
        if (this._isDataMarkerSupported()) {
            this.m_graph.setMarkerDisplayed(this.m_graph.isMarkerDisplayed());
        }
        if (this.m_formatDialog != null) {
            this.m_formatDialog.applyViewFormat();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        int width = Integer.parseInt(this.rBundle.getString("PlotAreaPanelWidth"));
        int height = Integer.parseInt(this.rBundle.getString("PlotAreaPanelHeight"));
        return new Dimension(width, height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
        if (this.m_formatDialog != null) {
            this.m_formatDialog.setHelpProvider(helpProvider);
        }
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_dataLabelOption) {
            if (this.m_dataLabel == null) {
                this.m_dataLabel = new DataLabel();
            }
            this.m_dataLabel.setHelpProvider(this.getHelpProvider());
            PanelDialog d = this.createPanelDialog(this.rBundle.getString("Data Label Options"), true, this.m_dataLabel, this.m_bHelpEnabled);
            d.show();
            d.dispose();
            d = null;
        } else if (e.getSource() == this.m_dataTipsOption) {
            if (this.m_dataTip == null) {
                this.m_dataTip = new DataTip();
            }
            this.m_dataTip.setHelpProvider(this.getHelpProvider());
            PanelDialog d = this.createPanelDialog(this.rBundle.getString("Data Tip Options"), true, this.m_dataTip, this.m_bHelpEnabled);
            if (this.m_tooltipType == 0) {
                this.m_dataTip.value.setSelected(true);
                this.m_tooltipType |= 1;
            }
            d.show();
            d.dispose();
            d = null;
        } else if (e.getSource() == this.m_fontButton) {
            if (this.m_formatDialog == null) {
                this.m_formatDialog = this._isPie() ? new FormatButtonDialog(WindowUtils.parentFrame((Component)this), this.m_graph, 33) : new FormatButtonDialog(WindowUtils.parentFrame((Component)this), this.m_graph, 21);
                this.m_formatDialog.setCustomColorsEnabled(this.m_graph.isCustomColorsEnabled());
                if (this.m_bColorPaletteSet) {
                    this.m_formatDialog.setColorPalette(this.m_colorPalette);
                }
                String translatedText = this.rBundle.getString("Format Data Labels");
                this.m_formatDialog.setTitle(translatedText);
                int sbutton = 7;
                int cbutton = 1;
                this.m_formatDialog.setStyleButtonMask(sbutton);
                this.m_formatDialog.setAlignmentButtonMask(0);
                this.m_formatDialog.setColorComponentMask(cbutton);
                this.m_formatDialog.setHelpProvider(this.getHelpProvider());
                this.m_formatDialog.addPropertyChangeListener(this);
                this.m_formatDialog.setForeground(this.m_label.getForeground());
                if (this._isPie() || this._isFunnel()) {
                    if (this.m_formatDialog != null) {
                        this.m_formatDialog.setComponentFont(this.m_graph.getSliceLabel().getFont());
                        if (this.m_graph.getSliceLabel().getGraphFont().getGraphFontStyle() >= 4) {
                            this.m_formatDialog.setUnderlineStyle(true);
                        }
                        this.m_formatDialog.setComponentForeground(this.m_graph.getSliceLabel().getGraphFont().getGraphFontColor());
                    }
                } else if (!this._isThreeD() && this.m_formatDialog != null) {
                    this.m_formatDialog.setComponentFont(this.m_graph.getMarkerText().getFont());
                    if (this.m_graph.getMarkerText().getGraphFont().getGraphFontStyle() >= 4) {
                        this.m_formatDialog.setUnderlineStyle(true);
                    }
                    this.m_formatDialog.setComponentForeground(this.m_graph.getMarkerText().getGraphFont().getGraphFontColor());
                }
            }
            this.m_formatDialog.initFontPane();
            this.m_formatDialog.show();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.m_horzBox) {
                this.firePropertyChange(PROPERTY_HORIZONTAL_GRID_VISIBLE, false, true);
                if (this.m_currentType == 65 || this.m_currentType == 66 || !this.m_graph.isHorizontal() && this.m_currentType >= 67 && this.m_currentType <= 69) {
                    this.m_horzLineWidth.setEnabled(false);
                } else {
                    this.m_horzLineWidth.setEnabled(true);
                }
                this.m_horzLabel.setEnabled(true);
                this.m_horzColor.setEnabled(true);
                this.m_bHorzVisibleChanged = true;
            } else if (e.getSource() == this.m_vertBox) {
                this.firePropertyChange(PROPERTY_VERTICAL_GRID_VISIBLE, false, true);
                this.m_vertLineWidth.setEnabled(true);
                this.m_vertLabel.setEnabled(true);
                this.m_vertColor.setEnabled(true);
                this.m_bVertVisibleChanged = true;
            } else if (e.getSource() == this.m_horzLineWidth) {
                int newLineWidth = this.m_horzLineWidth.getLineWidth();
                this.firePropertyChange(PROPERTY_HORIZONTAL_GRID_LINE_WIDTH, this.m_oldHorzLineWidth, newLineWidth);
                this.m_oldHorzLineWidth = newLineWidth;
                this.m_bHorzWidthChanged = true;
            } else if (e.getSource() == this.m_vertLineWidth) {
                int newLineWidth = this.m_vertLineWidth.getLineWidth();
                this.firePropertyChange(PROPERTY_VERTICAL_GRID_LINE_WIDTH, this.m_oldVertLineWidth, newLineWidth);
                this.m_oldVertLineWidth = newLineWidth;
                this.m_bVertWidthChanged = true;
            } else if (e.getSource() == this.m_dataLabelBox) {
                this.firePropertyChange(PROPERTY_DATA_LABEL_VISIBLE, false, true);
                if (this.m_dataLabelOption != null) {
                    this.m_dataLabelOption.setEnabled(true);
                    this.m_bDataLabelVisibleChanged = true;
                } else {
                    this.m_fontButton.setEnabled(true);
                    this.m_bDataLabelVisibleChanged = true;
                }
            } else if (e.getSource() == this.m_dataTipsBox) {
                this.firePropertyChange(PROPERTY_DATA_TIPS_VISIBLE, false, true);
                this.m_dataTipsOption.setEnabled(true);
                this.m_bDataTipVisibleChanged = true;
            }
        } else if (e.getStateChange() == 2) {
            if (e.getSource() == this.m_horzBox) {
                this.firePropertyChange(PROPERTY_HORIZONTAL_GRID_VISIBLE, true, false);
                this.m_horzLineWidth.setEnabled(false);
                this.m_horzLabel.setEnabled(false);
                this.m_horzColor.setEnabled(false);
                this.m_bHorzVisibleChanged = true;
            } else if (e.getSource() == this.m_vertBox) {
                this.firePropertyChange(PROPERTY_VERTICAL_GRID_VISIBLE, true, false);
                this.m_vertLineWidth.setEnabled(false);
                this.m_vertLabel.setEnabled(false);
                this.m_vertColor.setEnabled(false);
                this.m_bVertVisibleChanged = true;
            } else if (e.getSource() == this.m_dataLabelBox) {
                this.firePropertyChange(PROPERTY_DATA_LABEL_VISIBLE, true, false);
                if (this.m_dataLabelOption != null) {
                    this.m_dataLabelOption.setEnabled(false);
                    this.m_bDataLabelVisibleChanged = true;
                } else {
                    this.m_fontButton.setEnabled(false);
                    this.m_bDataLabelVisibleChanged = true;
                }
            } else if (e.getSource() == this.m_dataTipsBox) {
                this.firePropertyChange(PROPERTY_DATA_TIPS_VISIBLE, true, false);
                this.m_dataTipsOption.setEnabled(false);
                this.m_bDataTipVisibleChanged = true;
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("selectedColor")) {
            Color newColor;
            if (e.getSource() == this.m_backgroundColor) {
                newColor = this.m_backgroundColor.getSelectedColor();
                this.firePropertyChange(PROPERTY_BACKGROUND_COLOR, this.m_oldBackgroundColor, newColor);
                this.m_oldBackgroundColor = newColor;
                this.m_bgColor = newColor;
                this.m_bBackgroundChanged = true;
            }
            if (e.getSource() == this.m_borderColor) {
                newColor = this.m_borderColor.getSelectedColor();
                this.firePropertyChange(PROPERTY_BORDER_COLOR, this.m_bColor, newColor);
                this.m_bColor = newColor;
                this.m_bBorderColorChanged = true;
            } else if (e.getSource() == this.m_horzColor) {
                newColor = this.m_horzColor.getSelectedColor();
                this.m_horzLineWidth.setCellColor(newColor);
                this.firePropertyChange(PROPERTY_HORIZONTAL_GRID_COLOR, this.m_oldHorzColor, newColor);
                this.m_oldHorzColor = newColor;
                this.m_bHorzColorChanged = true;
            } else if (e.getSource() == this.m_vertColor) {
                newColor = this.m_vertColor.getSelectedColor();
                this.m_vertLineWidth.setCellColor(newColor);
                this.firePropertyChange(PROPERTY_VERTICAL_GRID_COLOR, this.m_oldVertColor, newColor);
                this.m_oldVertColor = newColor;
                this.m_bVertColorChanged = true;
            }
        }
        if (this.m_formatDialog != null) {
            Boolean b;
            boolean cancelled;
            String name = e.getPropertyName();
            if (name == "fontDialogCancelled" && !(cancelled = (b = (Boolean)e.getNewValue()).booleanValue())) {
                if (this.m_bMainFontNameChange) {
                    this.firePropertyChange("fontName", this.m_mainOldFontName, this.m_mainNewFontName);
                    this.m_bMainFontNameChange = false;
                    this.m_bDataLabelFontNameChanged = true;
                }
                if (this.m_bMainFontStyleChange) {
                    this.firePropertyChange("fontStyle", this.m_mainOldFontStyle, this.m_mainNewFontStyle);
                    this.m_bMainFontStyleChange = false;
                    int style = this.m_mainOldFontStyle ^ this.m_mainNewFontStyle;
                    if ((style & 1) != 0) {
                        this.m_bDataLabelFontBoldChanged = true;
                    }
                    if ((style & 2) != 0) {
                        this.m_bDataLabelFontItalicChanged = true;
                    }
                    if ((style & 4) != 0) {
                        this.m_bDataLabelFontUnderlineChanged = true;
                    }
                }
                if (this.m_bMainFontSizeChange) {
                    this.firePropertyChange("fontSize", this.m_mainOldFontSize, this.m_mainNewFontSize);
                    this.m_bMainFontSizeChange = false;
                    this.m_bDataLabelFontSizeChanged = true;
                }
                if (this.m_bMainFontColorChange) {
                    this.firePropertyChange("fontColor", this.m_mainOldFontColor, this.m_mainNewFontColor);
                    this.m_bMainFontColorChange = false;
                    this.m_bDataLabelFontColorChanged = true;
                }
            }
            if (name == "fontColor") {
                Color oldColor = (Color)e.getOldValue();
                if (!this.m_bMainFontColorChange) {
                    this.m_mainOldFontColor = oldColor;
                }
                this.m_mainNewFontColor = (Color)e.getNewValue();
                if (oldColor != this.m_mainNewFontColor) {
                    this.m_bMainFontColorChange = true;
                }
            }
            if (name == "fontName") {
                String oldName = (String)e.getOldValue();
                if (!this.m_bMainFontNameChange) {
                    this.m_mainOldFontName = oldName;
                }
                this.m_mainNewFontName = (String)e.getNewValue();
                if (oldName != this.m_mainNewFontName) {
                    this.m_bMainFontNameChange = true;
                }
            }
            if (name == "fontStyle") {
                Integer oldIntStyle = (Integer)e.getOldValue();
                if (!this.m_bMainFontStyleChange) {
                    this.m_mainOldFontStyle = oldIntStyle;
                }
                Integer newIntStyle = (Integer)e.getNewValue();
                this.m_mainNewFontStyle = newIntStyle;
                if (oldIntStyle != this.m_mainNewFontStyle) {
                    this.m_bMainFontStyleChange = true;
                }
            }
            if (name == "fontSize") {
                Integer oldIntSize = (Integer)e.getOldValue();
                if (!this.m_bMainFontSizeChange) {
                    this.m_mainOldFontSize = oldIntSize;
                }
                Integer newIntSize = (Integer)e.getNewValue();
                this.m_mainNewFontSize = newIntSize;
                if (oldIntSize != this.m_mainNewFontSize) {
                    this.m_bMainFontSizeChange = true;
                }
            }
        }
    }

    public String getHelpContextID() {
        String flavor;
        switch (this.m_currentType) {
            case 43: 
            case 45: {
                if (this.m_graph.isLineDataLineDisplayed()) {
                    flavor = "F";
                    break;
                }
                flavor = "C";
                break;
            }
            case 61: 
            case 65: 
            case 67: 
            case 89: {
                flavor = "B";
                break;
            }
            case 62: 
            case 91: {
                flavor = "C";
                break;
            }
            case 41: 
            case 42: 
            case 47: {
                flavor = "D";
                break;
            }
            case 17: {
                flavor = "E";
                break;
            }
            case 44: {
                flavor = "F";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 34: {
                flavor = "G";
                break;
            }
            case 96: {
                flavor = "H";
            }
            default: {
                flavor = "A";
            }
        }
        return this.getClass().getName() + "_" + flavor;
    }

    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    private boolean _isDataMarkerSupported() {
        return this.m_graph.getGraphType() == 97 || this.m_graph.getGraphType() == 98 || this.m_graph.getGraphType() == 96 || this.m_graph.getGraphType() >= 41 && this.m_graph.getGraphType() <= 54 || this.m_graph.getGraphType() >= 67 && this.m_graph.getGraphType() <= 69;
    }

    private PanelDialog createPanelDialog(String title, boolean modal, JPanel p, boolean bHelpEnabled) {
        PanelDialog d = null;
        Container owner = this;
        while (owner != null) {
            if (owner instanceof Dialog) {
                d = new PanelDialog((Dialog)owner, title, modal, p, bHelpEnabled);
                break;
            }
            if (owner instanceof Frame) {
                d = new PanelDialog((Frame)owner, title, modal, p, bHelpEnabled);
                break;
            }
            owner = SwingUtilities.getWindowAncestor(owner);
        }
        if (owner == null) {
            d = new PanelDialog((Frame)null, title, modal, p, bHelpEnabled);
        }
        return d;
    }

    class PanelDialog
    extends JDialog
    implements ActionListener,
    HelpContext {
        private static final long serialVersionUID = 1L;
        private boolean m_bHelpEnabled;
        private JButton okButton;
        private JButton cancelButton;
        private JButton helpButton;
        protected JPanel m_panel;
        protected String m_strHelpContextID;
        private final Border _sBorder;
        private final Border _sBorderButtons;
        private boolean value;
        private boolean percent;
        private boolean series;
        private boolean group;
        private int dataLabelPosition;
        private Color dataLabelcolor;
        private boolean dataLabelUnderLine;
        private Font dataLabelFont;
        private int dataLabelTextType;
        private boolean dataLabelPositionChanged;
        private boolean dataLabelTextTypeChanged;
        private boolean dataLabelColorChanged;
        private boolean dataLabelFontNameChanged;
        private boolean dataLabelFontSizeChanged;
        private boolean dataLabelFontBoldChanged;
        private boolean dataLabelFontItalicChanged;
        private boolean dataLabelFontUnderlineChanged;
        private boolean dataTipTypeChanged;

        public PanelDialog(Frame parentFrame, String title, boolean modal, JPanel p, boolean bHelpEnabled) {
            super(parentFrame);
            this.m_bHelpEnabled = true;
            this._sBorder = new EmptyBorder(6, 6, 8, 5);
            this._sBorderButtons = new EmptyBorder(8, 10, 0, 10);
            this._initDialog(title, modal, p, bHelpEnabled);
        }

        public PanelDialog(Dialog parentFrame, String title, boolean modal, JPanel p, boolean bHelpEnabled) {
            super(parentFrame);
            this.m_bHelpEnabled = true;
            this._sBorder = new EmptyBorder(6, 6, 8, 5);
            this._sBorderButtons = new EmptyBorder(8, 10, 0, 10);
            this._initDialog(title, modal, p, bHelpEnabled);
        }

        private void _initDialog(String title, boolean modal, JPanel p, boolean bHelpEnabled) {
            this.m_bHelpEnabled = bHelpEnabled;
            this.setTitle(title);
            this.setModal(modal);
            try {
                this.m_panel = p;
                if (p instanceof DataTip) {
                    this.value = ((DataTip)p).value.isSelected();
                    this.percent = ((DataTip)p).percent.isSelected();
                    this.series = ((DataTip)p).item.isSelected();
                    this.group = ((DataTip)p).group.isSelected();
                    this.dataTipTypeChanged = PlotArea.this.m_bDataTipTypeChanged;
                }
                if (p instanceof DataLabel) {
                    this.dataLabelPosition = ((DataLabel)p).position.getSelectedIndex();
                    this.dataLabelTextType = ((DataLabel)p).textType;
                    this.dataLabelFontNameChanged = PlotArea.this.m_bDataLabelFontNameChanged;
                    this.dataLabelFontBoldChanged = PlotArea.this.m_bDataLabelFontBoldChanged;
                    this.dataLabelFontItalicChanged = PlotArea.this.m_bDataLabelFontItalicChanged;
                    this.dataLabelFontUnderlineChanged = PlotArea.this.m_bDataLabelFontUnderlineChanged;
                    this.dataLabelFontSizeChanged = PlotArea.this.m_bDataLabelFontSizeChanged;
                    this.dataLabelColorChanged = PlotArea.this.m_bDataLabelFontColorChanged;
                    this.dataLabelPositionChanged = PlotArea.this.m_bDataLabelPositionChanged;
                    this.dataLabelTextTypeChanged = PlotArea.this.m_bDataLabelTextTypeChanged;
                    if (((DataLabel)p).formatDialog != null) {
                        this.dataLabelcolor = ((DataLabel)p).formatDialog.getComponentForeground();
                        this.dataLabelUnderLine = ((DataLabel)p).formatDialog.isUnderlineStyle();
                        this.dataLabelFont = new Font(((DataLabel)p).formatDialog.getComponentFont().getName(), ((DataLabel)p).formatDialog.getComponentFont().getStyle(), ((DataLabel)p).formatDialog.getComponentFont().getSize());
                    }
                }
                this.init();
                this.pack();
                PlotArea.this.m_initialWidth = this.getWidth();
                PlotArea.this.m_initialHeight = this.getHeight();
                if (p instanceof DataTip) {
                    if (PlotArea.this.m_dataLabelOption != null) {
                        this.setLocationRelativeTo(PlotArea.this.m_dataLabelOption);
                    } else {
                        this.setLocationRelativeTo(PlotArea.this.m_fontButton);
                    }
                } else {
                    this.setLocationRelativeTo(PlotArea.this.m_dataTipsOption);
                }
                this.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent we) {
                        PanelDialog.this.resetValues();
                    }
                });
                p = null;
            }
            catch (Exception e) {
                if (PlotArea.this.m_eh != null) {
                    PlotArea.this.m_eh.log("Error initiating panel dialog", this.getClass().getName(), "PanelDialog");
                }
                e.printStackTrace();
            }
        }

        public String getHelpContextID() {
            if (this.m_panel instanceof DataLabel) {
                if (PlotArea.this._isPie() || PlotArea.this._isFunnel()) {
                    return "oracle.dss.graph.gui.PlotArea.DataLabelOptionDialog_A";
                }
                return "oracle.dss.graph.gui.PlotArea.DataLabelOptionDialog_B";
            }
            if (this.m_panel instanceof DataTip) {
                return "oracle.dss.graph.gui.PlotArea.DataTipOptionDialog";
            }
            return this.getClass().getName();
        }

        public void setHelpContextID(String strHelpContextID) {
            this.m_strHelpContextID = strHelpContextID;
        }

        public void setHelpEnabled(boolean bValue) {
            this.m_bHelpEnabled = bValue;
        }

        public boolean isHelpEnabled() {
            return this.m_bHelpEnabled;
        }

        private void init() throws Exception {
            PlotArea.this.m_initialWidth = -1;
            PlotArea.this.m_initialHeight = -1;
            JComponent content = (JComponent)this.getContentPane();
            content.setLayout(new BoxLayout(content, 1));
            content.setBorder(this._sBorder);
            if (UIManager.getLookAndFeel() instanceof BrowserLookAndFeel) {
                content.setBackground(UIManager.getColor("MenuBar.background"));
            } else if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
                content.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
            }
            GrayPane gp = new GrayPane((Component)this.m_panel);
            content.add((Component)gp);
            DialogButtonBar buttonPanel = new DialogButtonBar();
            buttonPanel.setBorder(this._sBorderButtons);
            if (this.m_bHelpEnabled) {
                String translatedText = PlotArea.this.rBundle.getString("Help");
                this.helpButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
                this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
                buttonPanel.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
                this.helpButton.addActionListener(this);
                this.helpButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(112, 0), 2);
            }
            JPanel buttonPanel_east = new JPanel();
            this.okButton = new JButton(PlotArea.this.rBundle.getString("OK"));
            buttonPanel.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_YES);
            this.okButton.addActionListener(this);
            this.getRootPane().setDefaultButton(this.okButton);
            this.cancelButton = new JButton(PlotArea.this.rBundle.getString("Cancel"));
            buttonPanel.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
            this.cancelButton.addActionListener(this);
            this.cancelButton.registerKeyboardAction(this, KeyStroke.getKeyStroke(27, 0), 2);
            this.getContentPane().add((Component)buttonPanel);
            this.setResizable(true);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int originalHeight;
                    int originalWidth;
                    int width = originalWidth = PanelDialog.this.getWidth();
                    int height = originalHeight = PanelDialog.this.getHeight();
                    if (PlotArea.this.m_initialWidth != -1) {
                        width = Math.max(PlotArea.this.m_initialWidth, width);
                    }
                    if (PlotArea.this.m_initialHeight != -1) {
                        height = Math.max(PlotArea.this.m_initialHeight, height);
                    }
                    if (originalWidth != width || originalHeight != height) {
                        PanelDialog.this.setSize(width, height);
                    }
                    PanelDialog.this.validate();
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.cancelButton) {
                this.setVisible(false);
                this.getParent().repaint();
                this.resetValues();
            } else if (e.getSource() == this.okButton) {
                this.setVisible(false);
                if (this.m_panel instanceof DataTip) {
                    PlotArea.this.m_dataTip.apply();
                }
            } else if (e.getSource() == this.helpButton) {
                try {
                    if (PlotArea.this.getHelpProvider() != null) {
                        PlotArea.this.getHelpProvider().showHelp((Component)this);
                    } else if (HelpUtils.getDefaultHelpProvider() != null) {
                        HelpUtils.getDefaultHelpProvider().showHelp((Component)this);
                    }
                }
                catch (HelpUnavailableException helpUnavailableException) {
                    // empty catch block
                }
            }
        }

        public void resetValues() {
            if (this.m_panel instanceof DataTip) {
                ((DataTip)this.m_panel).value.setSelected(this.value);
                ((DataTip)this.m_panel).percent.setSelected(this.percent);
                ((DataTip)this.m_panel).item.setSelected(this.series);
                ((DataTip)this.m_panel).group.setSelected(this.group);
            }
            if (this.m_panel instanceof DataLabel) {
                ((DataLabel)this.m_panel).position.setSelectedIndex(this.dataLabelPosition);
                if (((DataLabel)this.m_panel).formatDialog != null) {
                    ((DataLabel)this.m_panel).formatDialog.setComponentForeground(this.dataLabelcolor);
                    ((DataLabel)this.m_panel).formatDialog.setUnderlineStyle(this.dataLabelUnderLine);
                    ((DataLabel)this.m_panel).formatDialog.setComponentFont(this.dataLabelFont);
                }
                if (this.dataLabelTextType == 0) {
                    ((DataLabel)this.m_panel).value.setSelected(true);
                } else if (this.dataLabelTextType == 1) {
                    ((DataLabel)this.m_panel).percent.setSelected(true);
                } else if (this.dataLabelTextType == 2) {
                    ((DataLabel)this.m_panel).item.setSelected(true);
                } else if (this.dataLabelTextType == 3) {
                    ((DataLabel)this.m_panel).itemPercent.setSelected(true);
                }
            }
            PlotArea.this.m_bDataLabelFontNameChanged = this.dataLabelFontNameChanged;
            PlotArea.this.m_bDataLabelFontBoldChanged = this.dataLabelFontBoldChanged;
            PlotArea.this.m_bDataLabelFontItalicChanged = this.dataLabelFontItalicChanged;
            PlotArea.this.m_bDataLabelFontUnderlineChanged = this.dataLabelFontUnderlineChanged;
            PlotArea.this.m_bDataLabelFontSizeChanged = this.dataLabelFontSizeChanged;
            PlotArea.this.m_bDataLabelFontColorChanged = this.dataLabelColorChanged;
            PlotArea.this.m_bDataLabelPositionChanged = this.dataLabelPositionChanged;
            PlotArea.this.m_bDataLabelTextTypeChanged = this.dataLabelTextTypeChanged;
            PlotArea.this.m_bDataTipTypeChanged = this.dataTipTypeChanged;
        }
    }

    class DataTip
    extends JPanel
    implements ItemListener {
        private static final long serialVersionUID = 1L;
        MultiLineLabel label;
        JCheckBox value;
        JCheckBox percent;
        JCheckBox item;
        JCheckBox group;
        protected HelpProvider m_helpProvider;

        public DataTip() {
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.label = new MultiLineLabel();
            this.label.setTextWrapper(WordWrapper.getTextWrapper());
            this.label.setText(MessageFormat.format(PlotArea.this.rBundle.getString("displayed information"), PlotArea.this._getDataLabelString()));
            double textwidth = this.getToolkit().getFontMetrics(this.label.getFont()).stringWidth(this.label.getText());
            int rows = (int)Math.ceil(textwidth / (double)(Integer.parseInt(PlotArea.this.rBundle.getString("DataTipPanelWidth")) - 20));
            this.label.setPreferredRows(rows);
            this.label.setMinimumRows(rows);
            this.label.setMaximumRows(rows);
            JLabel showLabel = new JLabel(PlotArea.this.rBundle.getString("Show"));
            int showLabelWidth = this.getToolkit().getFontMetrics(showLabel.getFont()).stringWidth(showLabel.getText());
            JPanel pnlChecks = new JPanel();
            pnlChecks.setLayout(new BoxLayout(pnlChecks, 1));
            pnlChecks.setBorder(BorderFactory.createEmptyBorder(0, showLabelWidth + 12, 0, 0));
            String translatedText = PlotArea.this.rBundle.getString("Value");
            this.value = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
            this.value.setName("ValueCheckBox");
            this.value.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            translatedText = PlotArea.this.rBundle.getString("Percent");
            this.percent = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
            this.percent.setName("PercentCheckBox");
            this.percent.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            translatedText = PlotArea.this.rBundle.getString("Item Label");
            this.item = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
            this.item.setName("SeriesLabelCheckBox");
            this.item.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            translatedText = PlotArea.this.rBundle.getString("Group Label");
            this.group = new JCheckBox(StringUtils.stripMnemonic((String)translatedText));
            this.group.setName("GroupLabelCheckBox");
            this.group.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            JPanel showLabelPanel = new JPanel();
            showLabelPanel.setLayout(new BoxLayout(showLabelPanel, 0));
            showLabelPanel.add(showLabel);
            showLabelPanel.add(Box.createHorizontalStrut(12));
            boolean series = PlotArea.this.m_graph.isDataRowShownAsASeries();
            if (PlotArea.this.m_graph.isGroupSeriesTooltipSupported(series ? 1 : 0)) {
                showLabelPanel.add(this.group);
                pnlChecks.add(this.value);
                if (PlotArea.this._isPercentGraph()) {
                    pnlChecks.add(this.percent);
                }
            } else if (PlotArea.this.m_graph.isGroupSeriesTooltipSupported(series ? 0 : 1)) {
                showLabelPanel.add(this.item);
                pnlChecks.add(this.value);
                if (PlotArea.this._isPercentGraph()) {
                    pnlChecks.add(this.percent);
                }
            } else {
                showLabelPanel.add(this.item);
                pnlChecks.add(this.group);
                pnlChecks.add(this.value);
                if (PlotArea.this._isPercentGraph()) {
                    pnlChecks.add(this.percent);
                }
            }
            this.add((Component)this.label);
            this.add(Box.createVerticalStrut(15));
            this.add(showLabelPanel);
            this.add(pnlChecks);
            this.add(Box.createVerticalGlue());
            this.label.setAlignmentX(0.0f);
            showLabelPanel.setAlignmentX(0.0f);
            pnlChecks.setAlignmentX(0.0f);
            this.value.addItemListener(this);
            this.percent.addItemListener(this);
            this.item.addItemListener(this);
            this.group.addItemListener(this);
            boolean tmp = PlotArea.this.m_bDataTipTypeChanged;
            this._init();
            PlotArea.this.m_bDataTipTypeChanged = tmp;
            this.setPreferredSize(new Dimension(Integer.parseInt(PlotArea.this.rBundle.getString("DataTipPanelWidth")), this.getPreferredSize().height));
        }

        public void _init() {
            if (PlotArea.this._isPercentGraph() && (4 & PlotArea.this.m_tooltipType) == 4) {
                this.percent.setSelected(true);
            }
            if ((1 & PlotArea.this.m_tooltipType) == 1) {
                this.value.setSelected(true);
            }
            if ((8 & PlotArea.this.m_tooltipType) == 8) {
                if (PlotArea.this.m_graph.getSeriesTooltipLabelType() != 0) {
                    this.item.setSelected(true);
                }
                if (PlotArea.this.m_graph.getGroupTooltipLabelType() != 0) {
                    this.group.setSelected(true);
                }
            }
        }

        public void setHelpProvider(HelpProvider helpProvider) {
            this.m_helpProvider = helpProvider;
        }

        public HelpProvider getHelpProvider() {
            return this.m_helpProvider;
        }

        public void apply() {
            if (PlotArea.this.m_bDataTipTypeChanged) {
                int type = 0;
                if (this.value.isSelected()) {
                    type |= 1;
                }
                if (this.percent.isEnabled() && this.percent.isSelected()) {
                    type |= 4;
                }
                if (this.item.isEnabled() && this.item.isSelected()) {
                    type |= 8;
                    PlotArea.this.m_graph.setSeriesTooltipLabelType(1);
                } else {
                    PlotArea.this.m_graph.setSeriesTooltipLabelType(0);
                }
                if (this.group.isEnabled() && this.group.isSelected()) {
                    type |= 8;
                    PlotArea.this.m_graph.setGroupTooltipLabelType(1);
                } else {
                    PlotArea.this.m_graph.setGroupTooltipLabelType(0);
                }
                PlotArea.this.m_tooltipType = type;
                if (PlotArea.this.m_tooltipType == 0) {
                    PlotArea.this.m_dataTipsBox.setSelected(false);
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            int type;
            if (e.getStateChange() == 1) {
                PlotArea.this.m_bDataTipTypeChanged = true;
                if (e.getSource() == this.value) {
                    type = PlotArea.this.m_tooltipType | 1;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_TIPS_TEXT, PlotArea.this.m_tooltipType, type);
                } else if (e.getSource() == this.percent) {
                    type = PlotArea.this.m_tooltipType | 4;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_TIPS_TEXT, PlotArea.this.m_tooltipType, type);
                } else if (e.getSource() == this.item) {
                    type = PlotArea.this.m_tooltipType | 8;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_TIPS_TEXT, PlotArea.this.m_tooltipType, type);
                } else if (e.getSource() == this.group) {
                    type = PlotArea.this.m_tooltipType | 8;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_TIPS_TEXT, PlotArea.this.m_tooltipType, type);
                }
            }
            if (e.getStateChange() == 2) {
                PlotArea.this.m_bDataTipTypeChanged = true;
                if (e.getSource() == this.value) {
                    type = PlotArea.this.m_tooltipType & 0xFFFFFFFE;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_TIPS_TEXT, PlotArea.this.m_tooltipType, type);
                } else if (e.getSource() == this.percent) {
                    type = PlotArea.this.m_tooltipType & 0xFFFFFFFB;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_TIPS_TEXT, PlotArea.this.m_tooltipType, type);
                } else if (e.getSource() == this.item) {
                    type = PlotArea.this.m_tooltipType & 0xFFFFFFF7;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_TIPS_TEXT, PlotArea.this.m_tooltipType, type);
                } else if (e.getSource() == this.group) {
                    type = PlotArea.this.m_tooltipType & 0xFFFFFFF7;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_TIPS_TEXT, PlotArea.this.m_tooltipType, type);
                }
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    class DataLabel
    extends JPanel
    implements ItemListener,
    PropertyChangeListener,
    ActionListener {
        private static final long serialVersionUID = 1L;
        MultiLineLabel label;
        JRadioButton value;
        JRadioButton percent;
        JRadioButton item;
        JRadioButton itemPercent;
        JComboBox position;
        JButton fontButton;
        FormatButtonDialog formatDialog;
        int oldPosition;
        int textType;
        int height;
        protected HelpProvider m_helpProvider;
        protected boolean m_bFontNameChange = false;
        protected boolean m_bFontStyleChange = false;
        protected boolean m_bFontSizeChange = false;
        protected boolean m_bFontColorChange = false;
        protected String m_oldFontName;
        protected String m_newFontName;
        protected int m_oldFontStyle;
        protected int m_newFontStyle;
        protected int m_oldFontSize;
        protected int m_newFontSize;
        protected Color m_oldFontColor;
        protected Color m_newFontColor;
        protected int m_oldTextType;

        public DataLabel() {
            String[] displayList;
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.label = new MultiLineLabel();
            this.label.setTextWrapper(WordWrapper.getTextWrapper());
            String translatedText = PlotArea.this.rBundle.getString("Value");
            this.value = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
            this.value.setName("ValueRadioButton");
            this.value.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            translatedText = PlotArea.this.rBundle.getString("Per_Value");
            this.percent = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
            this.percent.setName("PercentValueRadioButton");
            this.percent.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            translatedText = PlotArea.this.rBundle.getString("Item Label");
            this.item = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
            this.item.setName("SeriesLabelRadionButton");
            this.item.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            translatedText = PlotArea.this.rBundle.getString("Item Label and % Value");
            this.itemPercent = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
            this.item.setName("SeriesLabelAndPercentValueRadioButton");
            this.itemPercent.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            if (PlotArea.this._isPie()) {
                this.label.setText(MessageFormat.format(PlotArea.this.rBundle.getString("data labels infomation"), PlotArea.this._getDataLabelString()));
                displayList = new String[]{PlotArea.this.rBundle.getString("Outside with line"), PlotArea.this.rBundle.getString("Outside Pie Slice"), PlotArea.this.rBundle.getString("Inside Pie Slice"), PlotArea.this.rBundle.getString("Outside Feeler if needed")};
            } else {
                this.label.setText(MessageFormat.format(PlotArea.this.rBundle.getString("Display data values"), PlotArea.this._getDataLabelString()));
                displayList = new String[]{MessageFormat.format(PlotArea.this.rBundle.getString("Above"), PlotArea.this._getDataLabelString()), MessageFormat.format(PlotArea.this.rBundle.getString("Centered"), PlotArea.this._getDataLabelString())};
            }
            double textwidth = this.getToolkit().getFontMetrics(this.label.getFont()).stringWidth(this.label.getText());
            int rows = (int)Math.ceil(textwidth / (double)(Integer.parseInt(PlotArea.this.rBundle.getString("DataLabelPanelWidth")) - 20));
            this.label.setPreferredRows(rows);
            this.label.setMinimumRows(rows);
            this.label.setMaximumRows(rows);
            this.position = new JComboBox<String>(displayList);
            this.position.setName("LabelPosition");
            translatedText = PlotArea.this.rBundle.getString("Format Labels");
            this.fontButton = new JButton(StringUtils.stripMnemonic((String)translatedText));
            this.fontButton.setName("FormatDataLabelsButton");
            this.fontButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            JPanel fontPanel = new JPanel(new FlowLayout(2, 0, 0));
            fontPanel.add(this.fontButton);
            this.add((Component)this.label);
            this.add(Box.createVerticalStrut(15));
            if (PlotArea.this._isPie() || PlotArea.this._isFunnel()) {
                this.add(new JLabel(PlotArea.this.rBundle.getString("Show")));
                this.add(this.value);
                this.add(this.percent);
                this.add(this.item);
                this.add(this.itemPercent);
                this.add(Box.createRigidArea(new Dimension(0, 6)));
                ButtonGroup buttonGroup = new ButtonGroup();
                buttonGroup.add(this.value);
                buttonGroup.add(this.percent);
                buttonGroup.add(this.item);
                buttonGroup.add(this.itemPercent);
            }
            translatedText = PlotArea.this.rBundle.getString("labels location");
            JLabel locationLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
            locationLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            locationLabel.setLabelFor(this.position);
            if (!PlotArea.this._isFunnel()) {
                this.add(locationLabel);
                this.add(Box.createRigidArea(new Dimension(0, 3)));
                this.add(this.position);
            }
            this.add(Box.createRigidArea(new Dimension(0, 5)));
            this.add(fontPanel);
            this.add(Box.createVerticalGlue());
            this.setPreferredSize(new Dimension(Integer.parseInt(PlotArea.this.rBundle.getString("DataLabelPanelWidth")), this.getPreferredSize().height));
            if (!PlotArea.this._isDataLabelInTheCenterSupported()) {
                locationLabel.setEnabled(false);
                this.position.setEnabled(false);
            }
            this.label.setAlignmentX(0.0f);
            this.value.setAlignmentX(0.0f);
            this.percent.setAlignmentX(0.0f);
            this.item.setAlignmentX(0.0f);
            this.itemPercent.setAlignmentX(0.0f);
            this.position.setAlignmentX(0.0f);
            fontPanel.setAlignmentX(0.0f);
            this.position.addItemListener(this);
            this.fontButton.addActionListener(this);
            this.value.addItemListener(this);
            this.percent.addItemListener(this);
            this.item.addItemListener(this);
            this.itemPercent.addItemListener(this);
            boolean colorChanged = PlotArea.this.m_bDataLabelFontColorChanged;
            boolean nameChanged = PlotArea.this.m_bDataLabelFontNameChanged;
            boolean sizeChanged = PlotArea.this.m_bDataLabelFontSizeChanged;
            boolean boldChanged = PlotArea.this.m_bDataLabelFontBoldChanged;
            boolean italicChanged = PlotArea.this.m_bDataLabelFontItalicChanged;
            boolean underlineChanged = PlotArea.this.m_bDataLabelFontUnderlineChanged;
            boolean positionChanged = PlotArea.this.m_bDataLabelPositionChanged;
            boolean textTypeChanged = PlotArea.this.m_bDataLabelTextTypeChanged;
            this._init();
            PlotArea.this.m_bDataLabelFontColorChanged = colorChanged;
            PlotArea.this.m_bDataLabelFontNameChanged = nameChanged;
            PlotArea.this.m_bDataLabelFontSizeChanged = sizeChanged;
            PlotArea.this.m_bDataLabelFontBoldChanged = boldChanged;
            PlotArea.this.m_bDataLabelFontItalicChanged = italicChanged;
            PlotArea.this.m_bDataLabelFontUnderlineChanged = underlineChanged;
            PlotArea.this.m_bDataLabelPositionChanged = positionChanged;
            PlotArea.this.m_bDataLabelTextTypeChanged = textTypeChanged;
        }

        private void _init() {
            if (PlotArea.this._isPie() || PlotArea.this._isFunnel()) {
                this.oldPosition = PlotArea.this.m_labelPosition;
                this.position.setSelectedIndex(this.oldPosition - 1);
                this.m_oldTextType = this.textType = PlotArea.this.m_graph.getSliceLabel().getTextType();
                switch (this.textType) {
                    case 0: {
                        this.value.setSelected(true);
                        break;
                    }
                    case 1: {
                        this.percent.setSelected(true);
                        break;
                    }
                    case 2: {
                        this.item.setSelected(true);
                        break;
                    }
                    case 3: {
                        this.itemPercent.setSelected(true);
                    }
                }
            } else {
                this.oldPosition = PlotArea.this.m_graph.getMarkerText().getMarkerTextPlace() - 1;
                if (!PlotArea.this._isDataLabelInTheCenterSupported()) {
                    this.position.setSelectedIndex(0);
                } else if (this.oldPosition == 0) {
                    this.position.setSelectedIndex(this.oldPosition);
                } else {
                    this.position.setSelectedIndex(1);
                }
            }
        }

        public void apply() {
            if (PlotArea.this._isPie() || PlotArea.this._isFunnel()) {
                PlotArea.this.m_labelPosition = this.position.getSelectedIndex() + 1;
                if (PlotArea.this.m_bDataLabelTextTypeChanged) {
                    PlotArea.this.m_graph.getSliceLabel().setTextType(this.textType);
                }
                if (this.formatDialog != null) {
                    if (PlotArea.this.m_bDataLabelFontNameChanged) {
                        PlotArea.this.m_graph.getSliceLabel().getGraphFont().setGraphFontTypeface(this.formatDialog.getComponentFont().getFontName());
                    }
                    if (PlotArea.this.m_bDataLabelFontSizeChanged) {
                        PlotArea.this.m_graph.getSliceLabel().getGraphFont().setGraphFontSize(this.formatDialog.getComponentFont().getSize());
                    }
                    if (PlotArea.this.m_bDataLabelFontBoldChanged) {
                        PlotArea.this.m_graph.getSliceLabel().getGraphFont().setFontBold(this.formatDialog.getComponentFont().isBold());
                    }
                    if (PlotArea.this.m_bDataLabelFontItalicChanged) {
                        PlotArea.this.m_graph.getSliceLabel().getGraphFont().setFontItalic(this.formatDialog.getComponentFont().isItalic());
                    }
                    if (PlotArea.this.m_bDataLabelFontUnderlineChanged) {
                        PlotArea.this.m_graph.getSliceLabel().getGraphFont().setUnderline(this.formatDialog.isUnderlineStyle());
                    }
                    if (PlotArea.this.m_bDataLabelFontColorChanged) {
                        PlotArea.this.m_graph.getSliceLabel().getGraphFont().setGraphFontColor(this.formatDialog.getComponentForeground());
                    }
                }
            } else {
                if (PlotArea.this._isDataLabelInTheCenterSupported() && PlotArea.this.m_bDataLabelPositionChanged) {
                    int place = this.position.getSelectedIndex();
                    if (place == 0) {
                        PlotArea.this.m_graph.getMarkerText().setMarkerTextPlace(1);
                    } else {
                        PlotArea.this.m_graph.getMarkerText().setMarkerTextPlace(4);
                    }
                }
                if (this.formatDialog != null) {
                    if (PlotArea.this.m_bDataLabelFontNameChanged) {
                        PlotArea.this.m_graph.getMarkerText().getGraphFont().setGraphFontTypeface(this.formatDialog.getComponentFont().getFontName());
                    }
                    if (PlotArea.this.m_bDataLabelFontSizeChanged) {
                        PlotArea.this.m_graph.getMarkerText().getGraphFont().setGraphFontSize(this.formatDialog.getComponentFont().getSize());
                    }
                    if (PlotArea.this.m_bDataLabelFontBoldChanged) {
                        PlotArea.this.m_graph.getMarkerText().getGraphFont().setFontBold(this.formatDialog.getComponentFont().isBold());
                    }
                    if (PlotArea.this.m_bDataLabelFontItalicChanged) {
                        PlotArea.this.m_graph.getMarkerText().getGraphFont().setFontItalic(this.formatDialog.getComponentFont().isItalic());
                    }
                    if (PlotArea.this.m_bDataLabelFontUnderlineChanged) {
                        PlotArea.this.m_graph.getMarkerText().getGraphFont().setUnderline(this.formatDialog.isUnderlineStyle());
                    }
                    if (PlotArea.this.m_bDataLabelFontColorChanged) {
                        PlotArea.this.m_graph.getMarkerText().getGraphFont().setGraphFontColor(this.formatDialog.getComponentForeground());
                    }
                }
            }
            if (this.formatDialog != null) {
                this.formatDialog.applyViewFormat();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.fontButton) {
                if (this.formatDialog == null) {
                    this.formatDialog = PlotArea.this._isPie() ? new FormatButtonDialog(WindowUtils.parentFrame((Component)this), PlotArea.this.m_graph, 33) : new FormatButtonDialog(WindowUtils.parentFrame((Component)this), PlotArea.this.m_graph, 21);
                    this.formatDialog.setCustomColorsEnabled(PlotArea.this.m_graph.isCustomColorsEnabled());
                    if (PlotArea.this.m_bColorPaletteSet) {
                        this.formatDialog.setColorPalette(PlotArea.this.m_colorPalette);
                    }
                    String translatedText = PlotArea.this.rBundle.getString("Format Data Labels");
                    this.formatDialog.setTitle(translatedText);
                    this.formatDialog.addPropertyChangeListener(this);
                    int sbutton = 7;
                    int cbutton = 1;
                    this.formatDialog.setStyleButtonMask(sbutton);
                    this.formatDialog.setAlignmentButtonMask(0);
                    this.formatDialog.setColorComponentMask(cbutton);
                    if (PlotArea.this._isPie() || PlotArea.this._isFunnel()) {
                        this.formatDialog.setComponentFont(PlotArea.this.m_graph.getSliceLabel().getFont());
                        if (PlotArea.this.m_graph.getSliceLabel().getGraphFont().getGraphFontStyle() >= 4) {
                            this.formatDialog.setUnderlineStyle(true);
                        }
                        this.formatDialog.setComponentForeground(PlotArea.this.m_graph.getSliceLabel().getGraphFont().getGraphFontColor());
                    } else {
                        this.formatDialog.setComponentFont(PlotArea.this.m_graph.getMarkerText().getFont());
                        if (PlotArea.this.m_graph.getMarkerText().getGraphFont().getGraphFontStyle() >= 4) {
                            this.formatDialog.setUnderlineStyle(true);
                        }
                        this.formatDialog.setComponentForeground(PlotArea.this.m_graph.getMarkerText().getGraphFont().getGraphFontColor());
                    }
                }
                this.formatDialog.initFontPane();
                this.formatDialog.show();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (e.getSource() == this.position) {
                    int newPosition = this.position.getSelectedIndex();
                    newPosition = PlotArea.this._isPie() || PlotArea.this._isFunnel() ? ++newPosition : (newPosition += 2);
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_LABEL_POSITION, this.oldPosition, newPosition);
                    this.oldPosition = newPosition;
                    PlotArea.this.m_bDataLabelPositionChanged = true;
                } else if (e.getSource() == this.value) {
                    this.textType = 0;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_LABEL_TEXT, this.m_oldTextType, this.textType);
                    this.m_oldTextType = this.textType;
                    PlotArea.this.m_bDataLabelTextTypeChanged = true;
                } else if (e.getSource() == this.percent) {
                    this.textType = 1;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_LABEL_TEXT, this.m_oldTextType, this.textType);
                    this.m_oldTextType = this.textType;
                    PlotArea.this.m_bDataLabelTextTypeChanged = true;
                } else if (e.getSource() == this.item) {
                    this.textType = 2;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_LABEL_TEXT, this.m_oldTextType, this.textType);
                    this.m_oldTextType = this.textType;
                    PlotArea.this.m_bDataLabelTextTypeChanged = true;
                } else if (e.getSource() == this.itemPercent) {
                    this.textType = 3;
                    this.firePropertyChange(PlotArea.PROPERTY_DATA_LABEL_TEXT, this.m_oldTextType, this.textType);
                    this.m_oldTextType = this.textType;
                    PlotArea.this.m_bDataLabelTextTypeChanged = true;
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Boolean b;
            boolean cancelled;
            String name = e.getPropertyName();
            if (name == "fontDialogCancelled" && !(cancelled = (b = (Boolean)e.getNewValue()).booleanValue())) {
                if (this.m_bFontNameChange) {
                    this.firePropertyChange("fontName", this.m_oldFontName, this.m_newFontName);
                    this.m_bFontNameChange = false;
                    PlotArea.this.m_bDataLabelFontNameChanged = true;
                }
                if (this.m_bFontStyleChange) {
                    this.firePropertyChange("fontStyle", this.m_oldFontStyle, this.m_newFontStyle);
                    this.m_bFontStyleChange = false;
                    int style = this.m_oldFontStyle ^ this.m_newFontStyle;
                    if ((style & 1) != 0) {
                        PlotArea.this.m_bDataLabelFontBoldChanged = true;
                    }
                    if ((style & 2) != 0) {
                        PlotArea.this.m_bDataLabelFontItalicChanged = true;
                    }
                    if ((style & 4) != 0) {
                        PlotArea.this.m_bDataLabelFontUnderlineChanged = true;
                    }
                }
                if (this.m_bFontSizeChange) {
                    this.firePropertyChange("fontSize", this.m_oldFontSize, this.m_newFontSize);
                    this.m_bFontSizeChange = false;
                    PlotArea.this.m_bDataLabelFontSizeChanged = true;
                }
                if (this.m_bFontColorChange) {
                    this.firePropertyChange("fontColor", this.m_oldFontColor, this.m_newFontColor);
                    this.m_bFontColorChange = false;
                    PlotArea.this.m_bDataLabelFontColorChanged = true;
                }
            }
            if (name == "fontColor") {
                Color oldColor = (Color)e.getOldValue();
                if (!this.m_bFontColorChange) {
                    this.m_oldFontColor = oldColor;
                }
                this.m_newFontColor = (Color)e.getNewValue();
                if (oldColor != this.m_newFontColor) {
                    this.m_bFontColorChange = true;
                }
            }
            if (name == "fontName") {
                String oldName = (String)e.getOldValue();
                if (!this.m_bFontNameChange) {
                    this.m_oldFontName = oldName;
                }
                this.m_newFontName = (String)e.getNewValue();
                if (oldName != this.m_newFontName) {
                    this.m_bFontNameChange = true;
                }
            }
            if (name == "fontStyle") {
                Integer oldIntStyle = (Integer)e.getOldValue();
                if (!this.m_bFontStyleChange) {
                    this.m_oldFontStyle = oldIntStyle;
                }
                Integer newIntStyle = (Integer)e.getNewValue();
                this.m_newFontStyle = newIntStyle;
                if (oldIntStyle != this.m_newFontStyle) {
                    this.m_bFontStyleChange = true;
                }
            }
            if (name == "fontSize") {
                Integer oldIntSize = (Integer)e.getOldValue();
                if (!this.m_bFontSizeChange) {
                    this.m_oldFontSize = oldIntSize;
                }
                Integer newIntSize = (Integer)e.getNewValue();
                this.m_newFontSize = newIntSize;
                if (oldIntSize != this.m_newFontSize) {
                    this.m_bFontSizeChange = true;
                }
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public FontButton getFontButton() {
            return null;
        }

        public void setHelpProvider(HelpProvider helpProvider) {
            this.m_helpProvider = helpProvider;
            if (this.formatDialog != null) {
                this.formatDialog.setHelpProvider(helpProvider);
            }
        }

        public HelpProvider getHelpProvider() {
            return this.m_helpProvider;
        }
    }
}

