/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.draw.IdentObj;

public class PFJ
extends Perspective {
    private static final long serialVersionUID = 1L;

    protected void cleanUp() {
        this.askForRelease();
    }

    @Override
    protected int calcRiserWidth() {
        int defaultRiserWidth = 75;
        int maxBarWidth = this.getIntegerProp(Attr.MaxBarWidth);
        if (maxBarWidth == -1) {
            return defaultRiserWidth;
        }
        int groupCount = this.getNumGroups();
        int groupCountProp = (Integer)this.getObjProp(Attr.ViewableGroups);
        if (this.getZoomAndScroll() == 0 && groupCountProp != 0) {
            groupCount = groupCountProp;
        }
        if (groupCount < 1) {
            return defaultRiserWidth;
        }
        int barCount = this._getBarCountPerGroup();
        if (barCount < 1) {
            return defaultRiserWidth;
        }
        int plotAreaWidth = this.getRect((IdentObj)this.getFrame()).width;
        int groupWidth = plotAreaWidth / groupCount;
        int availableBarWidth = groupWidth / barCount;
        if (availableBarWidth < 1) {
            return defaultRiserWidth;
        }
        double maxRiserPercent = (double)maxBarWidth / (double)availableBarWidth;
        int maxRiserWidth = (int)Math.floor(100.0 * maxRiserPercent);
        if (maxRiserWidth > 100) {
            maxRiserWidth = 100;
        } else if (maxRiserWidth < 1) {
            maxRiserWidth = 1;
        }
        if (maxRiserWidth < defaultRiserWidth) {
            return maxRiserWidth;
        }
        return defaultRiserWidth;
    }

    protected boolean isCalculated() {
        return this.getChartState() > 0;
    }

    private int _getBarCountPerGroup() {
        int barCount = 0;
        switch (this.getGraphType()) {
            case 17: 
            case 19: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 97: 
            case 98: {
                barCount = this._getClusteredBarCountPerGroup(true);
                break;
            }
            case 18: 
            case 23: 
            case 25: 
            case 30: {
                barCount = this._getStackedBarCountPerGroup(true, false, false);
                break;
            }
            case 20: 
            case 27: {
                barCount = this._getStackedBarCountPerGroup(true, true, false);
                break;
            }
            case 22: 
            case 29: {
                barCount = this._getStackedBarCountPerGroup(true, true, true);
                break;
            }
            case 31: 
            case 33: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 48: 
            case 50: 
            case 52: {
                barCount = this._getClusteredBarCountPerGroup(false);
                break;
            }
            case 32: 
            case 35: 
            case 37: 
            case 40: 
            case 42: 
            case 47: 
            case 49: 
            case 54: {
                barCount = this._getStackedBarCountPerGroup(false, false, false);
                break;
            }
            case 44: 
            case 51: {
                barCount = this._getStackedBarCountPerGroup(false, true, false);
                break;
            }
            case 34: 
            case 39: 
            case 46: 
            case 53: {
                barCount = this._getStackedBarCountPerGroup(false, true, true);
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 76: 
            case 79: 
            case 82: 
            case 83: 
            case 84: 
            case 88: {
                barCount = 1;
                break;
            }
            case 74: 
            case 77: 
            case 80: {
                barCount = 1;
                break;
            }
            case 75: 
            case 78: 
            case 81: {
                barCount = 1;
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                barCount = 0;
                break;
            }
            case 93: 
            case 94: {
                barCount = 0;
                break;
            }
            default: {
                barCount = 0;
            }
        }
        return barCount;
    }

    private int _getClusteredBarCountPerGroup(boolean bDefaultBar) {
        int endSeries;
        int startSeries;
        if (this._isEverySeriesShown()) {
            startSeries = 0;
            endSeries = this.getNumSeries() - 1;
        } else {
            startSeries = this.getScrollOffsetSeries();
            endSeries = startSeries + this.getNumSeries() - 1;
        }
        int barCount = 0;
        for (int series = startSeries; series <= endSeries; ++series) {
            int markerType = this.getSeriesType(series);
            if ((!bDefaultBar || markerType != 0) && markerType != 1) continue;
            ++barCount;
        }
        return barCount;
    }

    private int _getStackedBarCountPerGroup(boolean bDefaultBar, boolean bDualY, boolean bSplit) {
        int endSeries;
        int startSeries;
        if (this._isEverySeriesShown()) {
            startSeries = 0;
            endSeries = this.getNumSeries() - 1;
        } else {
            startSeries = this.getScrollOffsetSeries();
            endSeries = startSeries + this.getNumSeries() - 1;
        }
        if (!bDualY || bSplit) {
            for (int series = startSeries; series <= endSeries; ++series) {
                int markerType = this.getSeriesType(series);
                if ((!bDefaultBar || markerType != 0) && markerType != 1) continue;
                return 1;
            }
            return 0;
        }
        boolean bY1Series = false;
        boolean bY2Series = false;
        for (int series = startSeries; series <= endSeries; ++series) {
            int markerType = this.getSeriesType(series);
            if ((!bDefaultBar || markerType != 0) && markerType != 1) continue;
            if (this.getAxisAssignment(series) == 1) {
                bY2Series = true;
                continue;
            }
            bY1Series = true;
        }
        if (bY1Series && bY2Series) {
            return 2;
        }
        if (bY1Series || bY2Series) {
            return 1;
        }
        return 0;
    }

    private boolean _isEverySeriesShown() {
        return this.getViewableSeries() == 0 || this.getViewableSeries() >= this.getNumTotalSeries();
    }
}

