/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.Date;
import oracle.dss.graph.BaseDataAxis;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.ChartFrameZoom;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.OrdinalAxisFragment;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.ZoomState;

public class GraphEventHandler {
    public static void handleDataScroll(CommonGraph graph, String axis, String count, String start, String span, String type) {
        int _span;
        int _start;
        int _count;
        try {
            _count = (int)Math.round(Double.parseDouble(count));
            _start = (int)Math.round(Double.parseDouble(start));
            _span = (int)Math.round(Double.parseDouble(span));
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        graph.getPFJ().setZoomScrollStarted(true);
        GraphEventHandler.prepareCommonGraphToHandleEvent(graph);
        graph.setTimeRangeMode(0);
        if (!ChartFrameZoom.isZoomAllowed(graph.getPFJ().getGraphObject())) {
            return;
        }
        try {
            ZoomState zoomState = graph.getPFJ().calcScrollState(axis, _count, _start, _span);
            GraphEventHandler.applyDataZoom(graph, zoomState);
        }
        catch (AssertionException ae) {
            graph.getErrorHandler().log("Could not scroll data: " + ae.toString(), GraphEventHandler.class.toString(), "");
        }
    }

    public static void handleDataZoomIn(CommonGraph graph, int x, int y, int width, int height) {
        graph.getPFJ().setZoomScrollStarted(true);
        GraphEventHandler.prepareCommonGraphToHandleEvent(graph);
        graph.setTimeRangeMode(0);
        if (!ChartFrameZoom.isZoomAllowed(graph.getPFJ().getGraphObject())) {
            return;
        }
        try {
            VC vc = graph.getPFJ().getVC();
            int xVirt = vc.destToVirtX(x);
            int yVirt = vc.destToVirtY(y += height);
            int widthVirt = vc.destToVirtWidth(width);
            int heightVirt = vc.destToVirtHeight(height);
            ZoomState zoomState = graph.getPFJ().calcZoomInState(new Rectangle(xVirt, yVirt, widthVirt, heightVirt));
            GraphEventHandler.applyDataZoom(graph, zoomState);
        }
        catch (AssertionException ae) {
            graph.getErrorHandler().log("Could not zoom in: " + ae.toString(), GraphEventHandler.class.toString(), "");
        }
    }

    public static void handleDataZoomOut(CommonGraph graph, int x, int y, int width, int height) {
        graph.getPFJ().setZoomScrollStarted(true);
        GraphEventHandler.prepareCommonGraphToHandleEvent(graph);
        graph.setTimeRangeMode(0);
        if (!ChartFrameZoom.isZoomAllowed(graph.getPFJ().getGraphObject())) {
            return;
        }
        try {
            VC vc = graph.getPFJ().getVC();
            int xVirt = vc.destToVirtX(x);
            int yVirt = vc.destToVirtY(y += height);
            int widthVirt = vc.destToVirtWidth(width);
            int heightVirt = vc.destToVirtHeight(height);
            ZoomState zoomState = graph.getPFJ().calcZoomOutState(new Rectangle(xVirt, yVirt, widthVirt, heightVirt));
            GraphEventHandler.applyDataZoom(graph, zoomState);
        }
        catch (AssertionException ae) {
            graph.getErrorHandler().log("Could not zoom out: " + ae.toString(), GraphEventHandler.class.toString(), "");
        }
    }

    public static void handleDataZoomInIncr(CommonGraph graph, int x, int y) {
        graph.getPFJ().setZoomScrollStarted(true);
        GraphEventHandler.prepareCommonGraphToHandleEvent(graph);
        graph.setTimeRangeMode(0);
        if (!ChartFrameZoom.isZoomAllowed(graph.getPFJ().getGraphObject())) {
            return;
        }
        try {
            VC vc = graph.getPFJ().getVC();
            int xVirt = vc.destToVirtX(x);
            int yVirt = vc.destToVirtY(y);
            ZoomState zoomState = graph.getPFJ().calcZoomInState(new Rectangle(xVirt, yVirt, -1, -1));
            GraphEventHandler.applyDataZoom(graph, zoomState);
        }
        catch (AssertionException ae) {
            graph.getErrorHandler().log("Could not zoom in: " + ae.toString(), GraphEventHandler.class.toString(), "");
        }
    }

    public static void handleLineSelectPoint(CommonGraph graph, int x, int y) {
        graph.getPFJ().setObjProp(new Point(x, y), Attr.LineSelectedPoint);
        GraphEventHandler.prepareCommonGraphToHandleEvent(graph);
    }

    public static void handleDataZoomOutIncr(CommonGraph graph, int x, int y) {
        graph.getPFJ().setZoomScrollStarted(true);
        GraphEventHandler.prepareCommonGraphToHandleEvent(graph);
        graph.setTimeRangeMode(0);
        if (!ChartFrameZoom.isZoomAllowed(graph.getPFJ().getGraphObject())) {
            return;
        }
        try {
            VC vc = graph.getPFJ().getVC();
            int xVirt = vc.destToVirtX(x);
            int yVirt = vc.destToVirtY(y);
            ZoomState zoomState = graph.getPFJ().calcZoomOutState(new Rectangle(xVirt, yVirt, -1, -1));
            GraphEventHandler.applyDataZoom(graph, zoomState);
        }
        catch (AssertionException ae) {
            graph.getErrorHandler().log("Could not zoom out: " + ae.toString(), GraphEventHandler.class.toString(), "");
        }
    }

    public static void handleDataZoomInIncr(CommonGraph graph, String axis) {
        graph.getPFJ().setZoomScrollStarted(true);
        GraphEventHandler.prepareCommonGraphToHandleEvent(graph);
        graph.setTimeRangeMode(0);
        if (!ChartFrameZoom.isZoomAllowed(graph.getPFJ().getGraphObject())) {
            return;
        }
        try {
            ZoomState zoomState = graph.getPFJ().calcZoomInState(axis);
            GraphEventHandler.applyDataZoom(graph, zoomState);
        }
        catch (AssertionException ae) {
            graph.getErrorHandler().log("Could not zoom in: " + ae.toString(), GraphEventHandler.class.toString(), "");
        }
    }

    public static void handleDataZoomOutIncr(CommonGraph graph, String axis) {
        graph.getPFJ().setZoomScrollStarted(true);
        GraphEventHandler.prepareCommonGraphToHandleEvent(graph);
        graph.setTimeRangeMode(0);
        if (!ChartFrameZoom.isZoomAllowed(graph.getPFJ().getGraphObject())) {
            return;
        }
        try {
            ZoomState zoomState = graph.getPFJ().calcZoomOutState(axis);
            GraphEventHandler.applyDataZoom(graph, zoomState);
        }
        catch (AssertionException ae) {
            graph.getErrorHandler().log("Could not zoom out: " + ae.toString(), GraphEventHandler.class.toString(), "");
        }
    }

    public static void handleTimeSelectorEvent(CommonGraph graph, long startTime, long endTime) {
        graph.getTimeSelector().setExplicitStart(new Date(startTime));
        graph.getTimeSelector().setExplicitEnd(new Date(endTime));
    }

    private static void prepareCommonGraphToHandleEvent(CommonGraph graph) {
        graph.getPFJ().setAlwaysCalcAxisAutoMinMax(true);
        graph.getPFJ().calcWithoutDrawing();
    }

    private static void applyDataZoom(CommonGraph graph, ZoomState zoomState) {
        try {
            OrdinalAxisFragment ordAxisFrag;
            BaseDataAxis dataAxis;
            MinMaxObj minMax = zoomState.getScaleMinMax(7);
            if (minMax != null && minMax.getRawMin() != minMax.getRawMax()) {
                dataAxis = graph.getX1Axis();
                dataAxis.setAxisMinValue(minMax.getRawMin());
                dataAxis.setAxisMaxValue(minMax.getRawMax());
                dataAxis.setAxisMinAutoScaled(zoomState.isAutoMin(7));
                dataAxis.setAxisMaxAutoScaled(zoomState.isAutoMax(7));
            }
            if ((minMax = zoomState.getScaleMinMax(0)) != null && minMax.getRawMin() != minMax.getRawMax()) {
                dataAxis = graph.getY1Axis();
                dataAxis.setAxisMinValue(minMax.getRawMin());
                dataAxis.setAxisMaxValue(minMax.getRawMax());
                dataAxis.setAxisMinAutoScaled(zoomState.isAutoMin(0));
                dataAxis.setAxisMaxAutoScaled(zoomState.isAutoMax(0));
            }
            if ((minMax = zoomState.getScaleMinMax(1)) != null && minMax.getRawMin() != minMax.getRawMax()) {
                dataAxis = graph.getY2Axis();
                dataAxis.setAxisMinValue(minMax.getRawMin());
                dataAxis.setAxisMaxValue(minMax.getRawMax());
                dataAxis.setAxisMinAutoScaled(zoomState.isAutoMin(1));
                dataAxis.setAxisMaxAutoScaled(zoomState.isAutoMax(1));
            }
            if ((ordAxisFrag = zoomState.getOrdinalAxisFragment(5)) != null) {
                graph.setDisplayGroups(ordAxisFrag.getOrdinalCount());
                graph.setStartGroup(ordAxisFrag.getOrdinalOffset());
            }
        }
        catch (AssertionException ae) {
            graph.getErrorHandler().log("Could not zoom in/out: " + ae.toString(), GraphEventHandler.class.toString(), "");
        }
    }

    public static void handleHideShowSeriesEvent(CommonGraph graph, int series, int visibility) {
        graph.getPFJ().setSeriesVisibility(series, visibility);
    }
}

