/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Color;
import oracle.dss.dataView.UIFillColor;
import oracle.dss.dataView.UITransparentFillColor;
import oracle.dss.graph.BaseFrame;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class FunnelFrame
extends BaseFrame
implements UIFillColor,
UITransparentFillColor {
    protected static int rect_Height = 21742;
    protected static int rect_Width = 25251;
    protected static int rect_X = -15393;
    protected static int rect_Y = 12378;

    public FunnelFrame(CommonGraph graph, IdentObj identObj) {
        super(graph, identObj);
    }

    @Override
    public void setFillColor(Color newColor) {
        if (newColor == null) {
            this.m_commonGraph.getErrorHandler().log("invalid Color value", this.getClass().toString(), "setFillColor(Color newColor)");
            return;
        }
        this.m_pfj.setFillColor(this.m_identObj, newColor);
    }

    @Override
    public void setFillTransparent(boolean yesNo) {
        this.m_pfj.setTransparentFillColor(this.m_identObj, yesNo);
        this.m_pfj.setTransparentFillColor(this.m_pfj.getFunnelLeftSurface(), yesNo);
    }

    public int getBorderWidth() {
        return this.m_pfj.getLineWidth(this.m_identObj);
    }

    public void setBorderWidth(int width) {
        if (width <= 0) {
            this.m_commonGraph.getErrorHandler().log("invalid border width", this.getClass().getName(), "setBorderWidth(int width)");
        } else {
            this.m_pfj.setLineWidth(this.m_identObj, width);
        }
    }

    @Deprecated
    public int getLineStyle() {
        return this.m_pfj.getLineStyle(this.m_identObj);
    }

    @Deprecated
    public void setLineStyle(int style) {
        if (style < 0 || style > 3) {
            this.m_commonGraph.getErrorHandler().log("invalid line style", this.getClass().getName(), "setLineStyle(int style)");
        } else {
            this.m_pfj.setLineStyle(this.m_identObj, style);
        }
    }

    @Override
    public ObjectNode getXML(boolean allProperties) {
        return this.getXML(allProperties, true);
    }

    @Override
    public ObjectNode getStyleXML(boolean allProperties) {
        return this.getXML(allProperties, false);
    }

    @Override
    protected ObjectNode getXML(boolean allProperties, boolean allOverriddenProperties) {
        ObjectNode rectStyleXML;
        boolean nodeExists = false;
        ObjectNode node = super.getXML(allProperties, allOverriddenProperties);
        if (node != null) {
            nodeExists = true;
        } else {
            node = new ObjectNode(this.getComponentName());
        }
        Object val = this.m_pfj.getLineWidthObj(this.m_identObj);
        if (val != null) {
            node.addProperty("borderWidth", ((Integer)val).intValue());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getLineStyleObj(this.m_identObj)) != null) {
            node.addProperty("borderStyle", FunnelFrame.convertLineStyleToString((Integer)val));
            nodeExists = true;
        }
        if ((rectStyleXML = this.getRectXML(allProperties)) != null) {
            if (node == null) {
                node = new ObjectNode(this.getComponentName());
            }
            node.addProperty(rectStyleXML);
            nodeExists = true;
        }
        return nodeExists ? node : null;
    }

    @Override
    public void setXML(ObjectNode node) {
        this.setXML(node, true);
    }

    @Override
    public void setStyleXML(ObjectNode node) {
        this.setXML(node, false);
    }

    @Override
    protected void setXML(ObjectNode node, boolean allProperties) {
        super.setXML(node, allProperties);
        PropertyNode pNode = node.getProperty("borderWidth");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("borderWidth", new Integer(pNode.getValueAsInteger()));
            } else {
                this.setBorderWidth(pNode.getValueAsInteger());
            }
        }
        pNode = node.getProperty("borderStyle");
    }

    @Override
    protected String getComponentName() {
        return "FunnelFrame";
    }
}

