/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.util.ResourceBundle;
import oracle.dss.dataView.Titles;
import oracle.dss.dataView.TokenSubstitution;
import oracle.dss.graph.BaseText;
import oracle.dss.graph.CommonGraph;
import oracle.dss.graph.Visible;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public abstract class BaseTitle
extends BaseText
implements Visible,
Titles {
    protected boolean visible = false;
    protected String text = "";
    protected String m_text = "";
    protected ResourceBundle rBundle = null;

    public BaseTitle(CommonGraph graph) {
        super(graph);
        this.updateResourceBundle();
    }

    @Override
    public boolean selectObject(int series, int group) {
        this.m_pfj.setSelection(this.m_identObj);
        return this.m_identObj.equals(this.m_pfj.getSelectionID());
    }

    @Override
    public int getHorizontalAlignment() {
        return this.m_pfj.getTextJustHoriz(this.m_identObj);
    }

    @Override
    public void setHorizontalAlignment(int a) {
        if (a == 2 || a == 0 || a == 4 || a == 10) {
            this.m_pfj.setTextJustHoriz(this.m_identObj, a);
        } else {
            this.m_commonGraph.getErrorHandler().log("invalid horizontal aligment", this.getClass().getName(), "setHorizontalAlignment(a)");
        }
    }

    @Override
    public String getText() {
        TokenSubstitution vs = this.m_commonGraph.getTokenSubstitution();
        return vs.getParsedString(this.m_text);
    }

    @Override
    public String getUnParseText() {
        return this.m_text;
    }

    @Override
    public void setText(String str) {
        if (str == null) {
            this.m_commonGraph.getErrorHandler().log("invalid text", this.getClass().toString(), "setText");
            return;
        }
        TokenSubstitution vs = this.m_commonGraph.getTokenSubstitution();
        String[] tokenArray = null;
        if (vs != null) {
            tokenArray = vs.getListItems();
            for (int i = 0; i < tokenArray.length; ++i) {
                tokenArray[i] = vs.getToken(tokenArray[i]);
            }
        }
        str = this.truncateText(str, tokenArray);
        this.setTitleString(vs.getParsedString(str));
        this.m_text = str;
    }

    public void setUnParseText(String str) {
        this.m_text = str;
    }

    protected abstract void setTitleString(String var1);

    public void resetToDefault() {
        this.m_text = "";
    }

    @Override
    public void resetStyle() {
        this.setTextRotation(0);
        this.setHorizontalAlignment(2);
        super.resetStyle();
    }

    public int getTextRotation() {
        return this.m_pfj.getTextRotation(this.m_identObj);
    }

    public void setTextRotation(int rotate) {
        if (rotate < 0 || rotate > 270) {
            this.m_commonGraph.getErrorHandler().log("invalid value for TextRotation", this.getClass().getName(), "setTextRotation(int rotate)");
        } else {
            this.m_pfj.setTextRotation(this.m_identObj, rotate);
            this.m_commonGraph.autoSetAxisTitleVerticalAlignment(this.m_identObj.getObjectID());
        }
    }

    @Override
    public boolean isVisible() {
        return this.m_pfj.getDisplay(this.m_identObj);
    }

    @Override
    public void setVisible(boolean yesNo) {
        this.m_pfj.setDisplay(this.m_identObj, yesNo);
    }

    public void updateResourceBundle() {
        this.rBundle = CommonGraph.getGraphResourceBundle(this.m_commonGraph.getLocale());
    }

    protected String convertTextRotationToString(int rotation) {
        String str = "";
        switch (rotation) {
            case 0: {
                str = "TR_HORIZ";
                break;
            }
            case 90: {
                str = "TR_HORIZ_ROTATE_90";
                break;
            }
            case 270: {
                str = "TR_HORIZ_ROTATE_270";
            }
        }
        return str;
    }

    protected int convertTextRotationToInt(String str) {
        int rotation = 0;
        if (str.equals("TR_HORIZ")) {
            rotation = 0;
        } else if (str.equals("TR_HORIZ_ROTATE_90")) {
            rotation = 90;
        } else if (str.equals("TR_HORIZ_ROTATE_270")) {
            rotation = 270;
        }
        return rotation;
    }

    @Override
    public boolean getNonstyleXML(boolean allProperties, ObjectNode node) {
        Object val;
        boolean nodeExists = super.getNonstyleXML(allProperties, node);
        if (allProperties || !this.text.equals(this.getUnParseText())) {
            node.addProperty("text", this.getUnParseText());
            nodeExists = true;
        }
        if ((val = this.m_pfj.getDisplayObj(this.m_identObj)) != null) {
            node.addProperty("visible", ((Boolean)val).booleanValue());
            nodeExists = true;
        }
        return nodeExists;
    }

    @Override
    public boolean getStyleXML(boolean allProperties, ObjectNode node) {
        boolean nodeExists = super.getStyleXML(allProperties, node);
        Object val = this.m_pfj.getTextJustHorizObj(this.m_identObj);
        if (val != null) {
            node.addProperty("horizontalAlignment", this.convertHorizontalAlignmentToString((Integer)val));
            nodeExists = true;
        }
        if ((val = this.m_pfj.getTextRotationObj(this.m_identObj)) != null) {
            node.addProperty("textRotation", this.convertTextRotationToString((Integer)val));
            nodeExists = true;
        }
        return nodeExists;
    }

    @Override
    public void setNonstyleXML(ObjectNode node) {
        super.setNonstyleXML(node);
        PropertyNode pNode = node.getProperty("text");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("text", pNode.getValueAsString());
            } else {
                this.setText(pNode.getValueAsString());
            }
        }
        if ((pNode = node.getProperty("visible")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("rendered", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
        if ((pNode = node.getProperty("rendered")) != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("rendered", new Boolean(pNode.getValueAsBoolean()));
            } else {
                this.setVisible(pNode.getValueAsBoolean());
            }
        }
    }

    @Override
    public void setStyleXML(ObjectNode node) {
        super.setStyleXML(node);
        PropertyNode pNode = node.getProperty("horizontalAlignment");
        if (pNode != null) {
            if (this.m_jsfHashMap != null) {
                this.m_jsfHashMap.put("horizontalAlignment", new Integer(BaseTitle.convertHorizontalAlignmentToInt(pNode.getValueAsString())));
            } else {
                this.setHorizontalAlignment(BaseTitle.convertHorizontalAlignmentToInt(pNode.getValueAsString()));
            }
        }
        if ((pNode = node.getProperty("textRotation")) != null) {
            this.setTextRotation(this.convertTextRotationToInt(pNode.getValueAsString()));
        }
    }
}

