/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Color;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.gauge.CustomShape;
import oracle.dss.gauge.CustomShapesParser;
import oracle.dss.gauge.SFX;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SVGShapesHandler
extends DefaultHandler {
    private CustomShapesParser m_parser;
    private List<List<AffineTransform>> m_transformList;
    private int m_zOrder;
    private Map<String, CustomGradient> m_gradientMap;
    private CustomGradient m_currGradient;

    public SVGShapesHandler(CustomShapesParser parser) {
        this.m_parser = parser;
        this.m_transformList = new ArrayList<List<AffineTransform>>();
        this.m_zOrder = 0;
        this.m_gradientMap = new HashMap<String, CustomGradient>();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        String id = atts.getValue("id");
        if (id != null) {
            id = id.split("_")[0];
        }
        Shape s = null;
        boolean bShapeElement = true;
        if (qName.equals("path")) {
            s = this._processPath(atts);
        } else if (qName.equals("rect")) {
            s = this._processRect(atts);
        } else if (qName.equals("circle") || qName.equals("ellipse")) {
            s = this._processCircleOrEllipse(atts);
        } else if (qName.equals("line")) {
            s = this._processLine(atts);
        } else if (qName.equals("polyline")) {
            s = this._processPolyline(atts);
        } else if (qName.equals("polygon")) {
            s = this._processPolygon(atts);
        } else {
            bShapeElement = false;
            if (qName.equals("linearGradient")) {
                this._processLinearGradient(atts);
            } else if (qName.equals("radialGradient")) {
                this._processRadialGradient(atts);
            } else if (qName.equals("stop")) {
                this._processStop(atts);
            }
        }
        this._processTransform(atts);
        if (bShapeElement) {
            Map<Object, Object> styleMap = new HashMap();
            String style = atts.getValue("style");
            if (style != null) {
                styleMap = SVGShapesHandler._convertStyleToMap(style);
            }
            Object fill = Color.black;
            if (atts.getValue("fill") != null) {
                fill = SVGShapesHandler._parseSFX(atts.getValue("fill"), this.m_gradientMap, s);
            } else if (styleMap.get("fill") != null) {
                fill = SVGShapesHandler._parseSFX((String)styleMap.get("fill"), this.m_gradientMap, s);
            }
            Color fillColor = null;
            HashMap sfxMap = null;
            if (fill instanceof Color) {
                fillColor = (Color)fill;
            } else if (fill instanceof HashMap) {
                sfxMap = (HashMap)fill;
            }
            if (atts.getValue("fill-opacity") != null) {
                fillColor = SVGShapesHandler._setAlpha(atts.getValue("fill-opacity"), fillColor);
            } else if (styleMap.get("fill-opacity") != null) {
                fillColor = SVGShapesHandler._setAlpha((String)styleMap.get("fill-opacity"), fillColor);
            }
            Color borderColor = null;
            if (atts.getValue("stroke") != null) {
                borderColor = SVGShapesHandler._parseColor(atts.getValue("stroke"));
            } else if (styleMap.get("stroke") != null) {
                borderColor = SVGShapesHandler._parseColor((String)styleMap.get("stroke"));
            }
            if (atts.getValue("stroke-opacity") != null) {
                borderColor = SVGShapesHandler._setAlpha(atts.getValue("stroke-opacity"), borderColor);
            } else if (styleMap.get("stroke-opacity") != null) {
                borderColor = SVGShapesHandler._setAlpha((String)styleMap.get("stroke-opacity"), borderColor);
            }
            int strokeWidth = 1;
            if (atts.getValue("stroke-width") != null) {
                strokeWidth = (int)SVGShapesHandler._parseValue(atts.getValue("stroke-width"));
            } else if (styleMap.get("stroke-width") != null) {
                strokeWidth = (int)SVGShapesHandler._parseValue((String)styleMap.get("stroke-width"));
            }
            if (s != null) {
                s = this._applyTransforms(s);
                CustomShape cs = new CustomShape(s, fillColor, borderColor, sfxMap, strokeWidth, this.m_zOrder);
                ++this.m_zOrder;
                this.m_parser.addShape(id, cs);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.m_transformList.remove(this.m_transformList.size() - 1);
        if (qName.equals("linearGradient") || qName.equals("radialGradient")) {
            this.m_gradientMap.put(this.m_currGradient.id, this.m_currGradient);
            this.m_currGradient = null;
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        return new InputSource(new ByteArrayInputStream(new byte[0]));
    }

    private Shape _processRect(Attributes atts) {
        RectangularShape rect = null;
        float x = SVGShapesHandler._parseValue(atts.getValue("x"));
        float y = SVGShapesHandler._parseValue(atts.getValue("y"));
        float w = SVGShapesHandler._parseValue(atts.getValue("width"));
        float h = SVGShapesHandler._parseValue(atts.getValue("height"));
        if (atts.getValue("rx") != null && atts.getValue("ry") != null) {
            float rx = SVGShapesHandler._parseValue(atts.getValue("rx"));
            float ry = SVGShapesHandler._parseValue(atts.getValue("ry"));
            rect = new RoundRectangle2D.Double(x, y, w, h, rx, ry);
        } else {
            rect = new Rectangle2D.Double(x, y, w, h);
        }
        return rect;
    }

    private Ellipse2D _processCircleOrEllipse(Attributes atts) {
        Ellipse2D.Double oval = null;
        float cx = SVGShapesHandler._parseValue(atts.getValue("cx"));
        float cy = SVGShapesHandler._parseValue(atts.getValue("cy"));
        if (atts.getValue("r") != null) {
            float r = SVGShapesHandler._parseValue(atts.getValue("r"));
            oval = new Ellipse2D.Double(cx - r, cy - r, 2.0f * r, 2.0f * r);
        } else if (atts.getValue("rx") != null && atts.getValue("ry") != null) {
            float rx = SVGShapesHandler._parseValue(atts.getValue("rx"));
            float ry = SVGShapesHandler._parseValue(atts.getValue("ry"));
            oval = new Ellipse2D.Double(cx - rx, cy - ry, 2.0f * rx, 2.0f * ry);
        }
        return oval;
    }

    private Line2D _processLine(Attributes atts) {
        float x1 = SVGShapesHandler._parseValue(atts.getValue("x1"));
        float y1 = SVGShapesHandler._parseValue(atts.getValue("y1"));
        float x2 = SVGShapesHandler._parseValue(atts.getValue("x2"));
        float y2 = SVGShapesHandler._parseValue(atts.getValue("y2"));
        Line2D.Double line = new Line2D.Double(x1, y1, x2, y2);
        return line;
    }

    private GeneralPath _processPolyline(Attributes atts) {
        GeneralPath path = new GeneralPath();
        if (atts.getValue("points") != null) {
            String[] points = atts.getValue("points").split("\\s+");
            String[] coords = points[0].split(",");
            float x = SVGShapesHandler._parseValue(coords[0]);
            float y = SVGShapesHandler._parseValue(coords[1]);
            path.moveTo(x, y);
            for (int i = 1; i < points.length; ++i) {
                if (points[i].length() <= 0) continue;
                coords = points[i].split(",");
                x = SVGShapesHandler._parseValue(coords[0]);
                y = SVGShapesHandler._parseValue(coords[1]);
                path.lineTo(x, y);
            }
        }
        return path;
    }

    private Polygon _processPolygon(Attributes atts) {
        Polygon polygon = new Polygon();
        if (atts.getValue("points") != null) {
            String[] points = atts.getValue("points").split("\\s+");
            for (int i = 0; i < points.length; ++i) {
                if (points[i].length() <= 0) continue;
                String[] coords = points[i].split(",");
                int x = (int)SVGShapesHandler._parseValue(coords[0]);
                int y = (int)SVGShapesHandler._parseValue(coords[1]);
                polygon.addPoint(x, y);
            }
        }
        return polygon;
    }

    private GeneralPath _processPath(Attributes atts) {
        GeneralPath path = new GeneralPath();
        String pathData = atts.getValue("d");
        String commands = pathData.replaceAll("[^a-zA-Z]", "");
        String[] coords = pathData.split("[a-zA-Z]");
        float currX = 0.0f;
        float currY = 0.0f;
        Point2D prevCubicControlPoint = null;
        Point2D prevQuadControlPoint = null;
        for (int i = 0; i < commands.length(); ++i) {
            float y;
            float y1;
            float x1;
            float y2;
            float x;
            int j;
            char command = commands.charAt(i);
            boolean isRelative = false;
            if (Character.isLowerCase(command)) {
                isRelative = true;
            }
            String[] points = null;
            if (i + 1 < coords.length) {
                points = coords[i + 1].trim().split("[,\\s]+");
            }
            if (command == 'M' || command == 'm') {
                for (j = 0; j < points.length; j += 2) {
                    x = SVGShapesHandler._parseValue(points[j]);
                    y2 = SVGShapesHandler._parseValue(points[j + 1]);
                    if (isRelative) {
                        x += currX;
                        y2 += currY;
                    }
                    currX = x;
                    currY = y2;
                    path.moveTo(x, y2);
                }
            } else if (command == 'L' || command == 'l') {
                for (j = 0; j < points.length; j += 2) {
                    x = SVGShapesHandler._parseValue(points[j]);
                    y2 = SVGShapesHandler._parseValue(points[j + 1]);
                    if (isRelative) {
                        x += currX;
                        y2 += currY;
                    }
                    currX = x;
                    currY = y2;
                    path.lineTo(x, y2);
                }
            } else if (command == 'H' || command == 'h') {
                for (j = 0; j < points.length; ++j) {
                    x = SVGShapesHandler._parseValue(points[j]);
                    y2 = currY;
                    if (isRelative) {
                        x += currX;
                    }
                    currX = x;
                    path.lineTo(x, y2);
                }
            } else if (command == 'V' || command == 'v') {
                for (j = 0; j < points.length; ++j) {
                    x = currX;
                    y2 = SVGShapesHandler._parseValue(points[j]);
                    if (isRelative) {
                        y2 += currY;
                    }
                    currY = y2;
                    path.lineTo(x, y2);
                }
            } else if (command == 'C' || command == 'c') {
                for (j = 0; j < points.length; j += 6) {
                    x1 = SVGShapesHandler._parseValue(points[j]);
                    y1 = SVGShapesHandler._parseValue(points[j + 1]);
                    float x2 = SVGShapesHandler._parseValue(points[j + 2]);
                    float y22 = SVGShapesHandler._parseValue(points[j + 3]);
                    float x3 = SVGShapesHandler._parseValue(points[j + 4]);
                    float y3 = SVGShapesHandler._parseValue(points[j + 5]);
                    if (isRelative) {
                        x1 += currX;
                        y1 += currY;
                        x2 += currX;
                        y22 += currY;
                        x3 += currX;
                        y3 += currY;
                    }
                    currX = x3;
                    currY = y3;
                    prevCubicControlPoint = new Point2D.Double(x2, y22);
                    path.curveTo(x1, y1, x2, y22, x3, y3);
                }
            } else if (command == 'S' || command == 's') {
                for (j = 0; j < points.length; j += 4) {
                    float x2 = SVGShapesHandler._parseValue(points[j]);
                    float y23 = SVGShapesHandler._parseValue(points[j + 1]);
                    float x4 = SVGShapesHandler._parseValue(points[j + 2]);
                    y = SVGShapesHandler._parseValue(points[j + 3]);
                    float x12 = currX;
                    float y12 = currY;
                    if (prevCubicControlPoint != null) {
                        x12 = (float)((double)currX + ((double)currX - prevCubicControlPoint.getX()));
                        y12 = (float)((double)currY + ((double)currY - prevCubicControlPoint.getY()));
                    }
                    if (isRelative) {
                        x2 += currX;
                        y23 += currY;
                        x4 += currX;
                        y += currY;
                    }
                    currX = x4;
                    currY = y;
                    prevCubicControlPoint = new Point2D.Double(x2, y23);
                    path.curveTo(x12, y12, x2, y23, x4, y);
                }
            } else if (command == 'Q' || command == 'q') {
                for (j = 0; j < points.length; j += 4) {
                    x1 = SVGShapesHandler._parseValue(points[j]);
                    y1 = SVGShapesHandler._parseValue(points[j + 1]);
                    float x5 = SVGShapesHandler._parseValue(points[j + 2]);
                    y = SVGShapesHandler._parseValue(points[j + 3]);
                    if (isRelative) {
                        x1 += currX;
                        y1 += currY;
                        x5 += currX;
                        y += currY;
                    }
                    currX = x5;
                    currY = y;
                    prevQuadControlPoint = new Point2D.Double(x1, y1);
                    path.quadTo(x1, y1, x5, y);
                }
            } else if (command == 'T' || command == 't') {
                for (j = 0; j < points.length; j += 2) {
                    x = SVGShapesHandler._parseValue(points[j]);
                    y2 = SVGShapesHandler._parseValue(points[j + 1]);
                    float x13 = currX;
                    float y13 = currY;
                    if (prevQuadControlPoint != null) {
                        x13 = (float)((double)currX + ((double)currX - prevQuadControlPoint.getX()));
                        y13 = (float)((double)currY + ((double)currY - prevQuadControlPoint.getY()));
                    }
                    if (isRelative) {
                        x += currX;
                        y2 += currY;
                    }
                    currX = x;
                    currY = y2;
                    prevQuadControlPoint = new Point2D.Double(x13, y13);
                    path.quadTo(x13, y13, x, y2);
                }
            } else if (command == 'A' || command == 'a') {
                for (j = 0; j < points.length; j += 7) {
                    Rectangle2D.Double bounds;
                    Arc2D.Double arc;
                    double cyPrime;
                    double cxPrime;
                    float rx = SVGShapesHandler._parseValue(points[j]);
                    float ry = SVGShapesHandler._parseValue(points[j + 1]);
                    double x_axis_rot = Math.toRadians(SVGShapesHandler._parseValue(points[j + 2]));
                    float large_arc_flag = SVGShapesHandler._parseValue(points[j + 3]);
                    float sweep_flag = SVGShapesHandler._parseValue(points[j + 4]);
                    float x6 = SVGShapesHandler._parseValue(points[j + 5]);
                    float y4 = SVGShapesHandler._parseValue(points[j + 6]);
                    if (isRelative) {
                        rx += currX;
                        ry += currY;
                        x6 += currX;
                        y4 += currY;
                    }
                    if (x6 == currX && y4 == currY) continue;
                    if (rx == 0.0f || ry == 0.0f) {
                        currX = x6;
                        currY = y4;
                        path.lineTo(x6, y4);
                        continue;
                    }
                    if (rx < 0.0f) {
                        rx *= -1.0f;
                    }
                    if (ry < 0.0f) {
                        ry *= -1.0f;
                    }
                    if (x_axis_rot > 360.0) {
                        x_axis_rot %= 360.0;
                    }
                    if (large_arc_flag != 0.0f) {
                        large_arc_flag = 1.0f;
                    }
                    if (sweep_flag != 0.0f) {
                        sweep_flag = 1.0f;
                    }
                    double tempA = (currX - x6) / 2.0f;
                    double tempB = (currY - y4) / 2.0f;
                    double x1Prime = Math.cos(x_axis_rot) * tempA + Math.sin(x_axis_rot) * tempB;
                    double y1Prime = -1.0 * Math.sin(x_axis_rot) * tempA + Math.cos(x_axis_rot) * tempB;
                    tempA = (double)rx * y1Prime / (double)ry;
                    tempB = -1.0 * ((double)ry * x1Prime) / (double)rx;
                    double tempC = Math.sqrt(Math.max((Math.pow(rx, 2.0) * Math.pow(ry, 2.0) - Math.pow(rx, 2.0) * Math.pow(y1Prime, 2.0) - Math.pow(ry, 2.0) * Math.pow(x1Prime, 2.0)) / (Math.pow(rx, 2.0) * Math.pow(y1Prime, 2.0) + Math.pow(ry, 2.0) * Math.pow(x1Prime, 2.0)), 0.0));
                    if (large_arc_flag != sweep_flag) {
                        cxPrime = tempC * tempA;
                        cyPrime = tempC * tempB;
                    } else {
                        cxPrime = -1.0 * tempC * tempA;
                        cyPrime = -1.0 * tempC * tempB;
                    }
                    tempA = (currX + x6) / 2.0f;
                    tempB = (currY + y4) / 2.0f;
                    double cx = Math.cos(x_axis_rot) * cxPrime - Math.sin(x_axis_rot) * cyPrime + tempA;
                    double cy = Math.sin(x_axis_rot) * cxPrime + Math.cos(x_axis_rot) * cyPrime + tempB;
                    double ux = 1.0;
                    double uy = 0.0;
                    double vx = (x1Prime - cxPrime) / (double)rx;
                    double vy = (y1Prime - cyPrime) / (double)ry;
                    double lengthU = Math.sqrt(Math.pow(ux, 2.0) + Math.pow(uy, 2.0));
                    double lengthV = Math.sqrt(Math.pow(vx, 2.0) + Math.pow(vy, 2.0));
                    double angleStart = Math.toDegrees(Math.acos((ux * vx + uy * vy) / (lengthU * lengthV)));
                    if (ux * vy - uy * vx < 0.0) {
                        angleStart *= -1.0;
                    }
                    ux = (x1Prime - cxPrime) / (double)rx;
                    uy = (y1Prime - cyPrime) / (double)ry;
                    vx = (-1.0 * x1Prime - cxPrime) / (double)rx;
                    vy = (-1.0 * y1Prime - cyPrime) / (double)ry;
                    lengthU = Math.sqrt(Math.pow(ux, 2.0) + Math.pow(uy, 2.0));
                    lengthV = Math.sqrt(Math.pow(vx, 2.0) + Math.pow(vy, 2.0));
                    double angleExtent = Math.toDegrees(Math.acos((ux * vx + uy * vy) / (lengthU * lengthV))) % 360.0;
                    if (ux * vy - uy * vx < 0.0) {
                        angleExtent *= -1.0;
                    }
                    if (sweep_flag == 0.0f && angleExtent < 0.0 || sweep_flag == 1.0f && angleExtent > 0.0) {
                        angleExtent *= -1.0;
                    }
                    if (((RectangularShape)(arc = new Arc2D.Double(bounds = new Rectangle2D.Double(cx - (double)rx, cy - (double)ry, 2.0f * rx, 2.0f * ry), angleStart, angleExtent, 0))).getX() >= 0.0 && ((RectangularShape)arc).getY() >= 0.0) {
                        path.append(arc, true);
                    }
                    currX = x6;
                    currY = y4;
                }
            } else if (command == 'Z' || command == 'z') {
                path.closePath();
            }
            if (command != 'C' && command != 'c' && command != 'S' && command != 's') {
                prevCubicControlPoint = null;
            }
            if (command == 'Q' || command == 'q' || command == 'T' || command == 't') continue;
            prevQuadControlPoint = null;
        }
        return path;
    }

    private void _processLinearGradient(Attributes atts) {
        String y2;
        String x2;
        String y1;
        String x1;
        String id = atts.getValue("id");
        if (id == null) {
            return;
        }
        String gradientUnits = atts.getValue("gradientUnits");
        if (gradientUnits == null || !gradientUnits.equals("userSpaceOnUse")) {
            gradientUnits = "objectBoundingBox";
        }
        if ((x1 = atts.getValue("x1")) == null) {
            x1 = "0%";
        }
        if ((y1 = atts.getValue("y1")) == null) {
            y1 = "0%";
        }
        if ((x2 = atts.getValue("x2")) == null) {
            x2 = "100%";
        }
        if ((y2 = atts.getValue("y2")) == null) {
            y2 = "0%";
        }
        this.m_currGradient = new CustomLinearGradient(id, gradientUnits, x1, y1, x2, y2);
    }

    private void _processRadialGradient(Attributes atts) {
        String fy;
        String fx;
        String r;
        String cy;
        String cx;
        String id = atts.getValue("id");
        if (id == null) {
            return;
        }
        String gradientUnits = atts.getValue("gradientUnits");
        if (gradientUnits == null || !gradientUnits.equals("userSpaceOnUse")) {
            gradientUnits = "objectBoundingBox";
        }
        if ((cx = atts.getValue("cx")) == null) {
            cx = "50%";
        }
        if ((cy = atts.getValue("cy")) == null) {
            cy = "50%";
        }
        if ((r = atts.getValue("r")) == null) {
            r = "50%";
        }
        if ((fx = atts.getValue("fx")) == null) {
            fx = cx;
        }
        if ((fy = atts.getValue("fy")) == null) {
            fy = cy;
        }
        this.m_currGradient = new CustomRadialGradient(id, gradientUnits, cx, cy, r, fx, fy);
    }

    private void _processStop(Attributes atts) {
        if (this.m_currGradient == null) {
            return;
        }
        String offset = atts.getValue("offset");
        double offsetVal = 0.0;
        if (offset != null) {
            if (offset.contains("%")) {
                offset = offset.substring(0, offset.length() - 1);
                offsetVal = Double.parseDouble(offset) / 100.0;
            } else {
                offsetVal = Double.parseDouble(offset);
            }
        } else {
            return;
        }
        Map<Object, Object> styleMap = new HashMap();
        String style = atts.getValue("style");
        if (style != null) {
            styleMap = SVGShapesHandler._convertStyleToMap(style);
        }
        Color stopColor = Color.BLACK;
        if (atts.getValue("stop-color") != null) {
            stopColor = SVGShapesHandler._parseColor(atts.getValue("stop-color"));
        } else if (styleMap.get("stop-color") != null) {
            stopColor = SVGShapesHandler._parseColor((String)styleMap.get("stop-color"));
        }
        if (atts.getValue("stop-opacity") != null) {
            stopColor = SVGShapesHandler._setAlpha(atts.getValue("stop-opacity"), stopColor);
        } else if (styleMap.get("stop-opacity") != null) {
            stopColor = SVGShapesHandler._setAlpha((String)styleMap.get("stop-opacity"), stopColor);
        }
        CustomStop stop = new CustomStop(offsetVal, stopColor);
        this.m_currGradient.addStop(stop);
    }

    private static float _parseValue(String s) {
        if (s == null) {
            return new Float(0.0f).floatValue();
        }
        s = s.replaceAll("px", "");
        float val = Float.valueOf(s).floatValue();
        return val;
    }

    private static Color _parseColor(String s) {
        if (s.equals("none")) {
            return null;
        }
        return DataviewUtils.hexStringToColor(s);
    }

    private static Object _parseSFX(String s, Map<String, CustomGradient> gradMap, Shape shape) {
        if (s.startsWith("url(#")) {
            s = s.substring(5, s.length() - 1);
            CustomGradient gradient = gradMap.get(s);
            HashMap sfxMap = SVGShapesHandler._convertGradientMapToSFXMap(gradient, shape);
            return sfxMap;
        }
        return SVGShapesHandler._parseColor(s);
    }

    private static Color _setAlpha(String alpha, Color c) {
        if (c == null) {
            return null;
        }
        int a = (int)(Double.parseDouble(alpha) * 255.0);
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        return new Color(r, g, b, a);
    }

    private static Map<String, String> _convertStyleToMap(String style) {
        HashMap<String, String> styleMap = new HashMap<String, String>();
        String s = style.replaceAll("\\s", "");
        int start = 0;
        while (start < s.length() - 1) {
            String value;
            int end = s.indexOf(58, start);
            String key = s.substring(start, end);
            start = end + 1;
            if ((end = s.indexOf(59, start)) == -1) {
                value = s.substring(start);
                start = s.length();
            } else {
                value = s.substring(start, end);
                start = end + 1;
            }
            styleMap.put(key, value);
        }
        return styleMap;
    }

    private void _processTransform(Attributes atts) {
        String t = atts.getValue("transform");
        ArrayList<AffineTransform> list = new ArrayList<AffineTransform>();
        if (t == null) {
            this.m_transformList.add(list);
            return;
        }
        String[] transforms = t.split("\\x29");
        for (int i = 0; i < transforms.length; ++i) {
            String transform = transforms[i];
            int beginIndex = transform.indexOf("(");
            if (beginIndex < 0) continue;
            String command = transform.substring(0, beginIndex);
            command = command.replaceAll("[\\s,]", "");
            String coords = transform.substring(beginIndex + 1);
            String[] points = coords.split(",");
            if (transforms[i] == null || transforms[i].equals("")) continue;
            if (command.equals("translate")) {
                double tx = SVGShapesHandler._parseValue(points[0]);
                double ty = 0.0;
                if (points.length >= 2) {
                    ty = SVGShapesHandler._parseValue(points[1]);
                }
                AffineTransform at = new AffineTransform();
                at.translate(tx, ty);
                list.add(at);
                continue;
            }
            if (command.equals("matrix")) {
                double a = SVGShapesHandler._parseValue(points[0]);
                double b = SVGShapesHandler._parseValue(points[1]);
                double c = SVGShapesHandler._parseValue(points[2]);
                double d = SVGShapesHandler._parseValue(points[3]);
                double e = SVGShapesHandler._parseValue(points[4]);
                double f = SVGShapesHandler._parseValue(points[5]);
                AffineTransform at = new AffineTransform(a, b, c, d, e, f);
                list.add(at);
                continue;
            }
            if (command.equals("scale")) {
                AffineTransform at = new AffineTransform();
                double sx = SVGShapesHandler._parseValue(points[0]);
                if (points.length >= 2) {
                    double sy = SVGShapesHandler._parseValue(points[1]);
                    at.scale(sx, sy);
                } else {
                    at.scale(sx, sx);
                }
                list.add(at);
                continue;
            }
            if (command.equals("rotate")) {
                AffineTransform at = new AffineTransform();
                double ang = Math.toRadians(SVGShapesHandler._parseValue(points[0]));
                if (points.length >= 3) {
                    double cx = SVGShapesHandler._parseValue(points[1]);
                    double cy = SVGShapesHandler._parseValue(points[1]);
                    at.rotate(ang, cx, cy);
                } else {
                    at.rotate(ang);
                }
                list.add(at);
                continue;
            }
            if (command.equals("skewX")) {
                double ang = Math.toRadians(SVGShapesHandler._parseValue(points[0]));
                AffineTransform at = new AffineTransform(1.0, 0.0, Math.tan(ang), 1.0, 0.0, 0.0);
                list.add(at);
                continue;
            }
            if (!command.equals("skewY")) continue;
            double ang = Math.toRadians(SVGShapesHandler._parseValue(points[0]));
            AffineTransform at = new AffineTransform(1.0, Math.tan(ang), 0.0, 1.0, 0.0, 0.0);
            list.add(at);
        }
        this.m_transformList.add(list);
    }

    private Shape _applyTransforms(Shape s) {
        for (int i = 0; i < this.m_transformList.size(); ++i) {
            List<AffineTransform> trans = this.m_transformList.get(i);
            for (int j = 0; j < trans.size(); ++j) {
                AffineTransform at = trans.get(j);
                if (at == null) continue;
                s = at.createTransformedShape(s);
            }
        }
        return s;
    }

    private static HashMap _convertGradientMapToSFXMap(CustomGradient gradient, Shape shape) {
        HashMap sfxMap = SFX.cloneDefaultMap();
        if (shape == null || gradient == null) {
            return sfxMap;
        }
        sfxMap.put("SFX_FILL_TYPE", new Integer(2));
        List<CustomStop> stopList = gradient.stopList;
        if (stopList == null) {
            return sfxMap;
        }
        ArrayList<Double> offsets = new ArrayList<Double>(stopList.size());
        ArrayList<Color> stopColors = new ArrayList<Color>(stopList.size());
        for (CustomStop stop : stopList) {
            offsets.add(stop.offset);
            stopColors.add(stop.color);
        }
        sfxMap.put("SFX_STOP_POSITIONS", offsets);
        sfxMap.put("SFX_STOP_COLORS", stopColors);
        sfxMap.put("SFX_NUM_STOPS", stopList.size());
        if (gradient instanceof CustomLinearGradient) {
            CustomLinearGradient linearGradient = (CustomLinearGradient)gradient;
            double x1 = SVGShapesHandler._convertCoordToPercent(linearGradient.gradientUnits, linearGradient.x1, shape, true);
            double y1 = SVGShapesHandler._convertCoordToPercent(linearGradient.gradientUnits, linearGradient.y1, shape, false);
            double x2 = SVGShapesHandler._convertCoordToPercent(linearGradient.gradientUnits, linearGradient.x2, shape, true);
            double y2 = SVGShapesHandler._convertCoordToPercent(linearGradient.gradientUnits, linearGradient.y2, shape, false);
            sfxMap.put("SFX_START_POINT", new Point2D.Double(x1, y1));
            sfxMap.put("SFX_END_POINT", new Point2D.Double(x2, y2));
            sfxMap.put("SFX_GRADIENT_DIRECTION", new Integer(20));
        } else {
            CustomRadialGradient radialGradient = (CustomRadialGradient)gradient;
            double cx = SVGShapesHandler._convertCoordToPercent(radialGradient.gradientUnits, radialGradient.cx, shape, true);
            double cy = SVGShapesHandler._convertCoordToPercent(radialGradient.gradientUnits, radialGradient.cy, shape, false);
            sfxMap.put("SFX_GRADIENT_CENTER", new Point2D.Double(cx, cy));
            sfxMap.put("SFX_GRADIENT_DIRECTION", new Integer(21));
        }
        return sfxMap;
    }

    private static double _convertCoordToPercent(String gradientUnits, String coord, Shape shape, boolean xAxis) {
        double percent = 0.0;
        if (gradientUnits.equals("userSpaceOnUse")) {
            Rectangle bounds = shape.getBounds();
            double val = Double.parseDouble(coord);
            percent = xAxis ? (val - (double)bounds.x) / (double)bounds.width * 100.0 : (val - (double)bounds.y) / (double)bounds.height * 100.0;
        } else {
            percent = coord.contains("%") ? Double.parseDouble(coord.substring(0, coord.length() - 1)) : Double.parseDouble(coord) * 100.0;
        }
        if (percent > 100.0) {
            percent = 100.0;
        } else if (percent < 0.0) {
            percent = 0.0;
        }
        return percent;
    }

    private class CustomStop {
        final double offset;
        final Color color;

        private CustomStop(double offset, Color color) {
            this.offset = offset;
            this.color = color;
        }
    }

    private class CustomRadialGradient
    extends CustomGradient {
        final String cx;
        final String cy;
        final String r;
        final String fx;
        final String fy;

        private CustomRadialGradient(String id, String gradientUnits, String cx, String cy, String r, String fx, String fy) {
            super(id, gradientUnits);
            this.cx = cx;
            this.cy = cy;
            this.r = r;
            this.fx = fx;
            this.fy = fy;
        }
    }

    private class CustomLinearGradient
    extends CustomGradient {
        final String x1;
        final String x2;
        final String y1;
        final String y2;

        private CustomLinearGradient(String id, String gradientUnits, String x1, String y1, String x2, String y2) {
            super(id, gradientUnits);
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }
    }

    private abstract class CustomGradient {
        final String id;
        final String gradientUnits;
        List<CustomStop> stopList;

        private CustomGradient(String id, String gradientUnits) {
            this.id = id;
            this.gradientUnits = gradientUnits;
            this.stopList = new ArrayList<CustomStop>();
        }

        private void addStop(CustomStop stop) {
            this.stopList.add(stop);
        }
    }
}

