/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gauge;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.gauge.CustomShape;
import oracle.dss.gauge.CustomShapesParser;
import oracle.dss.gauge.DrawableObject;
import oracle.dss.gauge.GaugeDefaultValues;
import oracle.dss.gauge.GaugeEngine;
import oracle.dss.gauge.GaugeLayout;
import oracle.dss.presutil.PresUtils;

public abstract class GaugeType {
    protected static String DEF_TICK_LABEL = "2.34M";
    protected static String LABEL_SPACE = "    ";
    protected static double SHADOW_OFFSET = 0.33;
    protected static int TICK_MARK_LENGTH = 3;
    protected static final int LED_GAUGESET_GAP = 2;
    protected static final int HEIGHT_LOWERLABELFRAME_REFLECTION = 8;
    protected static final int HEIGHT_TITLESEPARATOR = 3;
    protected static final int DIR_TOP = 0;
    protected static final int DIR_BOTTOM = 1;
    protected static final int DIR_LEFT = 2;
    protected static final int DIR_RIGHT = 3;
    protected static final boolean m_bBlended = false;
    protected GaugeEngine _engine;
    protected CustomShapesParser _csParser;
    protected GaugeLayout _layout;
    protected Rectangle _innerBounds = null;
    protected Rectangle _gaugeFrameBounds = null;
    protected Rectangle _lowerLabelFrameBounds = null;
    protected Rectangle _upperLabelFrameBounds = null;
    protected Rectangle _bottomLabelBounds = null;
    protected Rectangle _topLabelBounds = null;
    protected Rectangle _metricLabelBounds = null;
    protected Rectangle _titleSeparatorBounds = null;
    private String _topLabelToolTip = null;
    private String _bottomLabelToolTip = null;
    protected Dimension _btmLblDim = null;
    protected Dimension _metLblDim = null;
    protected Dimension _topLblDim = null;
    protected Dimension _upperFrameDim = null;
    protected Dimension _lowerFrameDim = null;
    protected boolean _hasLowerReflection = false;
    protected AffineTransform _scaleTransform;
    protected AffineTransform _moveTransform;
    protected ResourceBundle _gaugeBundle;
    protected ResourceBundle _utilBundle;
    protected Locale m_locale = null;

    public GaugeType(GaugeEngine engine) {
        this._engine = engine;
        this.setLocale(this._engine.getLocale());
        this._layout = new GaugeLayout(new Dimension(GaugeDefaultValues.getImageWidth(), GaugeDefaultValues.getImageHeight()));
    }

    protected Collection getBackgroundObject(Map map, Rectangle outerBounds, Shape gaugeSetClip) {
        Color borderColor;
        ArrayList<DrawableObject.Shape> objects = new ArrayList<DrawableObject.Shape>(15);
        HashMap sfxMap = (HashMap)map.get("BackgroundSFX");
        Color fillColor = (Color)map.get("BackgroundFillColor");
        if (fillColor == null) {
            fillColor = GaugeDefaultValues.getBackgroundFillColor();
        }
        if (sfxMap == null) {
            sfxMap = GaugeDefaultValues.getBackgroundSFX();
        }
        if ((borderColor = (Color)map.get("BackgroundBorderColor")) == null) {
            borderColor = GaugeDefaultValues.getBackgroundBorderColor();
        }
        if (gaugeSetClip != null) {
            Area background = new Area(outerBounds);
            background.intersect(new Area(gaugeSetClip));
            if (borderColor != null || fillColor != null || sfxMap != null) {
                objects.add(new DrawableObject.Shape(10, background, borderColor, fillColor, sfxMap, null));
            }
        } else {
            if (borderColor != null || fillColor != null || sfxMap != null) {
                objects.add(new DrawableObject.Shape(10, outerBounds, null, fillColor, sfxMap, null));
            }
            if (borderColor != null) {
                Rectangle2D.Double borderRect = new Rectangle2D.Double(outerBounds.getX(), outerBounds.getY(), outerBounds.getWidth() - 1.0, outerBounds.getHeight() - 1.0);
                objects.add(new DrawableObject.Shape(10, borderRect, borderColor, null, null, null));
            }
        }
        return objects;
    }

    protected static DrawableObject createTickMark(Point2D pt, double angle, int length, Color color, int position) {
        double x = pt.getX();
        double y = pt.getY();
        double x1 = x + (double)length / 2.0 * Math.cos(Math.toRadians(360.0 - angle));
        double y1 = y + (double)length / 2.0 * Math.sin(Math.toRadians(360.0 - angle));
        double x2 = x + (double)(-length) / 2.0 * Math.cos(Math.toRadians(360.0 - angle));
        double y2 = y + (double)(-length) / 2.0 * Math.sin(Math.toRadians(360.0 - angle));
        if (angle == 0.0 || angle == 180.0) {
            int x0 = (int)Math.round(x);
            x1 = x1 > (double)x0 ? (double)(x0 + 3) : (double)(x0 - 3);
            x2 = x2 > (double)x0 ? (double)(x0 + 3) : (double)(x0 - 3);
        }
        if (position == 0) {
            return new DrawableObject.Shape(13, new Line2D.Double(x, y, x2, y2), color, null, null, null);
        }
        return new DrawableObject.Shape(13, new Line2D.Double(x1, y1, x2, y2), color, null, null, null);
    }

    public abstract int getGaugeType();

    protected abstract Collection getPlotAreaObject(Map var1, int var2);

    protected abstract Collection getIndicatorObject(Map var1, int var2);

    protected abstract Collection getTickLabelObjects(Map var1);

    protected abstract Collection getTickMarkObjects(Map var1);

    protected abstract Collection getGaugeFrameObject(Map var1);

    protected abstract Collection getGaugeLinkObject(Map var1, Rectangle var2);

    protected Collection<DrawableObject> getOverlayEffectObjects(Map map) {
        return Collections.emptyList();
    }

    protected static Object getThresholdAttribute(Map map, int index, Object attr) {
        Color tAttr = null;
        if (map != null) {
            tAttr = (Color)map.get(attr);
        }
        if (tAttr == null) {
            if (attr.equals("ThresholdFillColor")) {
                Color[] defClrs = GaugeDefaultValues.getThresholdColors();
                tAttr = index < defClrs.length ? defClrs[index] : defClrs[defClrs.length - 1];
            }
            if (attr.equals("ThresholdBorderColor")) {
                tAttr = GaugeDefaultValues.getThresholdBorderColor();
            }
        }
        return tAttr;
    }

    protected Collection getLabelObjects(Map map, Rectangle outerBounds) {
        boolean bBtmLblBelow;
        Rectangle bounds;
        boolean hasMetWithBtmLbl;
        ViewFormat viewFmt;
        int content;
        boolean bTitleSeparator;
        Color metFontColor;
        Double metric;
        Color btmFontColor;
        Color topFontColor;
        ArrayList<DrawableObject.Shape> objects = new ArrayList<DrawableObject.Shape>();
        ArrayList<DrawableObject> lblObjects = new ArrayList<DrawableObject>();
        Graphics2D g = this._engine.getGraphics();
        String topLabel = this._engine.getTopLabel();
        String btmLabel = this._engine.getBottomLabel();
        Font topFont = (Font)map.get("TopLabelFont");
        if (topFont == null) {
            topFont = GaugeDefaultValues.getTopLabelFont();
        }
        if ((topFontColor = (Color)map.get("TopLabelColor")) == null) {
            topFontColor = GaugeDefaultValues.getTopLabelFontColor();
        }
        Dimension topLblDim = DrawableObject.getLabelDimensions(g, topFont, topLabel);
        int topLblPos = this.getTopLabelPosition(map);
        Font btmFont = (Font)map.get("BottomLabelFont");
        if (btmFont == null) {
            btmFont = GaugeDefaultValues.getBottomLabelFont();
        }
        if ((btmFontColor = (Color)map.get("BottomLabelColor")) == null) {
            btmFontColor = GaugeDefaultValues.getBottomLabelFontColor();
        }
        Dimension btmLblDim = DrawableObject.getLabelDimensions(g, btmFont, btmLabel);
        int btmLblPos = this.getBottomLabelPosition(map);
        String metLabel = this._engine.isNullMetric() ? "" : ((metric = this._engine.getMetric()) != null ? this._engine.formatValue(metric, "MetricLabelViewFormat") : this._engine.getIntlStringFromUtilBundle("af_dvt_util.NULL"));
        Font metFont = (Font)map.get("MetricLabelFont");
        if (metFont == null) {
            metFont = GaugeDefaultValues.getMetricLabelFont();
        }
        if ((metFontColor = (Color)map.get("MetricLabelColor")) == null) {
            metFontColor = GaugeDefaultValues.getMetricLabelFontColor();
        }
        Dimension metLblDim = DrawableObject.getLabelDimensions(g, metFont, metLabel);
        int metLblPos = this.getMetricLabelPosition(map);
        boolean showUpLbl = GaugeDefaultValues.isUpperLabelFrameVisible();
        if (map.get("UpLblFrameVisible") != null) {
            showUpLbl = (Boolean)map.get("UpLblFrameVisible");
        }
        boolean showLowLbl = GaugeDefaultValues.isLowerLabelFrameVisible();
        if (map.get("LowLblFrameVisible") != null) {
            showLowLbl = (Boolean)map.get("LowLblFrameVisible");
        }
        int customLayout = GaugeDefaultValues.getCustomLayout();
        if (map.get("CustomLayout") != null) {
            customLayout = (Integer)map.get("CustomLayout");
        }
        boolean bl = bTitleSeparator = (customLayout & 1) != 0 && topLblPos == 3;
        if (metLblPos == 2) {
            if (btmLblPos == 0) {
                metLblPos = 0;
            } else if (btmLabel == null) {
                metLblPos = 1;
                this._metricLabelBounds = this._bottomLabelBounds;
            }
        }
        boolean redoFormat = true;
        if (map.get("TickLabelContent") != null && ((content = ((Integer)map.get("TickLabelContent")).intValue()) & 0x10) != 0) {
            redoFormat = false;
        }
        if (!(!redoFormat || (viewFmt = (ViewFormat)((Object)map.get("MetricLabelViewFormat"))) != null && viewFmt.isScaleFactorUsed() && viewFmt.isDecimalDigitUsed())) {
            this._engine.determineFormat(true);
        }
        boolean bl2 = hasMetWithBtmLbl = metLblPos == 2;
        if (this._topLabelBounds != null) {
            if (topLblDim != null && topLblDim.width > this._topLabelBounds.width) {
                FontMetrics fm = g.getFontMetrics(topFont);
                this._topLabelToolTip = topLabel;
                topLabel = PresUtils.truncateText(topLabel, fm, 0, this._topLabelBounds.width);
                topLblDim = DrawableObject.getLabelDimensions(g, topFont, topLabel);
                if (topLblDim.width > this._topLabelBounds.width) {
                    topLblPos = 0;
                }
                this._engine.getErrorHandler().trace("Truncated or removed topLabel to fit in gauge.", this.getClass().getName(), "getLabelObjects");
            }
            if (topLabel != null && topLblPos != 0) {
                bounds = new Rectangle();
                bounds.x = bTitleSeparator ? this._topLabelBounds.x : (int)(this._topLabelBounds.getCenterX() - (double)topLblDim.width / 2.0);
                bounds.width = topLblDim.width;
                bounds.y = (int)(this._topLabelBounds.getCenterY() - (double)topLblDim.height / 2.0);
                bounds.height = topLblDim.height;
                lblObjects.add(DrawableObject.getLabelObject(g, topLabel, topFont, topFontColor, bounds, "TopLabel"));
            }
        }
        if (this._bottomLabelBounds != null && btmLabel != null && btmLblPos != 0) {
            Dimension oneCharDim;
            if (btmLblDim != null) {
                int availBtmWidth;
                oneCharDim = DrawableObject.getLabelDimensions(g, btmFont, "n");
                int frameWidth = 0;
                if (showLowLbl) {
                    frameWidth = oneCharDim.width * 2;
                }
                int metLblWidth = 0;
                if (hasMetWithBtmLbl && metLabel != null) {
                    metLblWidth = metLblDim.width + oneCharDim.width;
                }
                if (btmLblDim.width + metLblWidth + frameWidth > (availBtmWidth = this._lowerLabelFrameBounds != null && btmLblPos == 1 ? this._lowerLabelFrameBounds.width : this._bottomLabelBounds.width)) {
                    FontMetrics fm = g.getFontMetrics(btmFont);
                    this._bottomLabelToolTip = btmLabel;
                    btmLabel = PresUtils.truncateText(btmLabel, fm, 0, availBtmWidth - (metLblWidth + frameWidth));
                    btmLblDim = DrawableObject.getLabelDimensions(g, btmFont, btmLabel);
                    if (btmLblDim.width + metLblWidth + frameWidth > availBtmWidth) {
                        btmLblPos = 0;
                    } else if (btmLblDim.width <= 0) {
                        btmLblPos = 0;
                        metLblPos = 1;
                        this._metricLabelBounds = this._bottomLabelBounds;
                        hasMetWithBtmLbl = false;
                    }
                    this._engine.getErrorHandler().trace("Truncated or removed bottomLabel to fit in gauge.", this.getClass().getName(), "getLabelObjects");
                }
            }
            if (btmLblPos != 0) {
                int btmX;
                oneCharDim = DrawableObject.getLabelDimensions(g, btmFont, "n");
                if (hasMetWithBtmLbl) {
                    int metX;
                    if (btmLblPos == 4) {
                        int totLblWidth = btmLblDim.width + oneCharDim.width + metLblDim.width;
                        btmX = (int)(this._bottomLabelBounds.getCenterX() - (double)totLblWidth / 2.0);
                        metX = btmX + btmLblDim.width + oneCharDim.width;
                    } else {
                        btmX = showLowLbl && this._lowerLabelFrameBounds != null ? this._lowerLabelFrameBounds.x + oneCharDim.width : this._bottomLabelBounds.x;
                        metX = showLowLbl && this._lowerLabelFrameBounds != null ? (int)this._lowerLabelFrameBounds.getMaxX() - metLblDim.width - oneCharDim.width : (int)(this._bottomLabelBounds.getMaxX() - (double)metLblDim.width);
                    }
                    int metY = (int)(this._bottomLabelBounds.getMaxY() - (double)metLblDim.height);
                    Rectangle metBounds = new Rectangle(metX, metY, metLblDim.width, metLblDim.height);
                    lblObjects.add(DrawableObject.getLabelObject(g, metLabel, metFont, metFontColor, metBounds, "MetricLabelPosition"));
                } else {
                    btmX = (int)(this._bottomLabelBounds.getCenterX() - (double)btmLblDim.width / 2.0);
                }
                int btmY = (int)(this._bottomLabelBounds.getMaxY() - (double)btmLblDim.height);
                Rectangle btmBounds = new Rectangle(btmX, btmY, btmLblDim.width, btmLblDim.height);
                lblObjects.add(DrawableObject.getLabelObject(g, btmLabel, btmFont, btmFontColor, btmBounds, "BottomLabel"));
            }
        }
        if (this._metricLabelBounds != null && metLabel != null && metLblPos != 0) {
            bounds = new Rectangle();
            bounds.x = (int)(this._metricLabelBounds.getCenterX() - (double)metLblDim.width / 2.0);
            bounds.width = metLblDim.width;
            bounds.y = (int)(this._metricLabelBounds.getCenterY() - (double)metLblDim.height / 2.0);
            bounds.height = metLblDim.height;
            int availBtmWidth = this._lowerLabelFrameBounds != null && metLblPos == 1 ? this._lowerLabelFrameBounds.width : this._metricLabelBounds.width;
            if (bounds.width <= availBtmWidth || this._csParser != null) {
                lblObjects.add(DrawableObject.getLabelObject(g, metLabel, metFont, metFontColor, bounds, "MetricLabelPosition"));
            }
        }
        if (this._titleSeparatorBounds != null && bTitleSeparator) {
            int x = this._titleSeparatorBounds.x;
            int w = this._titleSeparatorBounds.width;
            int yDark = this._titleSeparatorBounds.y;
            int yLight = this._titleSeparatorBounds.y + this._titleSeparatorBounds.height / 3;
            int yWhite = this._titleSeparatorBounds.y + 2 * this._titleSeparatorBounds.height / 3;
            int h = this._titleSeparatorBounds.height / 3;
            Rectangle dark = new Rectangle(x, yDark, w, h);
            Rectangle light = new Rectangle(x, yLight, w, h);
            Rectangle white = new Rectangle(x, yWhite, w, h);
            Color darkColor = GaugeDefaultValues.d_titleSeparatorDark;
            Color lightColor = PresUtils.getPastel(darkColor, 0.4);
            Color whiteColor = Color.white;
            objects.add(new DrawableObject.Shape(32, dark, null, darkColor, null, null));
            objects.add(new DrawableObject.Shape(32, light, null, lightColor, null, null));
            objects.add(new DrawableObject.Shape(32, white, null, whiteColor, null, null));
        }
        if (showUpLbl && this._upperLabelFrameBounds != null && topLblDim != null && topLblPos == 3) {
            if (this._csParser != null && this._csParser.defines("upperLabelFrame")) {
                AffineTransform move;
                AffineTransform scale;
                Rectangle2D bounds2 = this._csParser.getBounds("upperLabelFrame");
                if (this._scaleTransform != null && this._moveTransform != null) {
                    scale = this._scaleTransform;
                    move = this._moveTransform;
                } else {
                    scale = GaugeType.getScalingTransform(bounds2, this._upperLabelFrameBounds);
                    this._moveTransform = move = GaugeType.getTranslateTransform(bounds2, this._upperLabelFrameBounds, scale);
                    this._scaleTransform = scale;
                }
                Color userBorderColor = (Color)map.get("UpLblFrameBorderColor");
                Color userFillColor = (Color)map.get("UpLblFrameFillColor");
                HashMap userSFXMap = (HashMap)map.get("UpLblFrameSFX");
                List<CustomShape> shapesList = this._csParser.getShapes("upperLabelFrame");
                for (int i = 0; i < shapesList.size(); ++i) {
                    CustomShape cs = shapesList.get(i);
                    Shape s = cs.getShape();
                    s = scale.createTransformedShape(s);
                    s = move.createTransformedShape(s);
                    Color csBorderColor = userBorderColor != null ? userBorderColor : cs.getBorderColor();
                    Color csFillColor = userFillColor != null ? userFillColor : cs.getFillColor();
                    HashMap csSFXMap = userSFXMap != null ? userSFXMap : cs.getSFXMap();
                    objects.add(new DrawableObject.Shape(25, s, csBorderColor, csFillColor, csSFXMap, null));
                }
            } else {
                HashMap upLblFrameSFX;
                Color upLblFrameBorderClr;
                Color upLblFrameFillClr = (Color)map.get("UpLblFrameFillColor");
                if (upLblFrameFillClr == null) {
                    upLblFrameFillClr = GaugeDefaultValues.getLabelFrameFillColor();
                }
                if ((upLblFrameBorderClr = (Color)map.get("UpLblFrameBorderColor")) == null) {
                    upLblFrameBorderClr = GaugeDefaultValues.getLabelFrameBorderColor();
                }
                if ((upLblFrameSFX = (HashMap)map.get("UpLblFrameSFX")) == null) {
                    upLblFrameSFX = GaugeDefaultValues.getBottomLabelSFX();
                }
                Dimension oneCharDim = DrawableObject.getLabelDimensions(g, topFont, "n");
                int x = (int)(this._upperLabelFrameBounds.getCenterX() - (double)(topLblDim.width / 2) - (double)oneCharDim.width);
                int width = topLblDim.width + 2 * oneCharDim.width;
                int y = this._upperLabelFrameBounds.y;
                int height = this._upperLabelFrameBounds.height;
                RoundRectangle2D.Double frameRect = new RoundRectangle2D.Double(x, y, width, height, height / 4, height / 4);
                objects.add(new DrawableObject.Shape(25, frameRect, upLblFrameBorderClr, upLblFrameFillClr, upLblFrameSFX, null));
            }
        }
        boolean bMetLblBelow = metLblPos == 1 && metLblDim != null && metLblDim.width > 0;
        boolean bl3 = bBtmLblBelow = btmLblPos == 1 && btmLblDim != null && btmLblDim.width > 0;
        if (showLowLbl && this._lowerLabelFrameBounds != null && (bMetLblBelow || bBtmLblBelow)) {
            if (this._csParser != null && this._csParser.defines("lowerLabelFrame")) {
                AffineTransform move;
                AffineTransform scale;
                Rectangle2D bounds3 = this._csParser.getBounds("lowerLabelFrame");
                if (this._scaleTransform != null && this._moveTransform != null) {
                    scale = this._scaleTransform;
                    move = this._moveTransform;
                } else {
                    scale = GaugeType.getScalingTransform(bounds3, this._lowerLabelFrameBounds);
                    this._moveTransform = move = GaugeType.getTranslateTransform(bounds3, this._lowerLabelFrameBounds, scale);
                    this._scaleTransform = scale;
                }
                Color userBorderColor = (Color)map.get("LowLblFrameBorderColor");
                Color userFillColor = (Color)map.get("LowLblFrameFillColor");
                HashMap userSFXMap = (HashMap)map.get("LowLblFrameSFX");
                List<CustomShape> shapesList = this._csParser.getShapes("lowerLabelFrame");
                for (int i = 0; i < shapesList.size(); ++i) {
                    CustomShape cs = shapesList.get(i);
                    Shape s = cs.getShape();
                    s = scale.createTransformedShape(s);
                    s = move.createTransformedShape(s);
                    Color csBorderColor = userBorderColor != null ? userBorderColor : cs.getBorderColor();
                    Color csFillColor = userFillColor != null ? userFillColor : cs.getFillColor();
                    HashMap csSFXMap = userSFXMap != null ? userSFXMap : cs.getSFXMap();
                    objects.add(new DrawableObject.Shape(26, s, csBorderColor, csFillColor, csSFXMap, null));
                }
            } else {
                Color lowLblFrameBorderClr;
                HashMap lowLblFrameSFX;
                Color lowLblFrameFillClr = (Color)map.get("LowLblFrameFillColor");
                if (lowLblFrameFillClr == null) {
                    lowLblFrameFillClr = GaugeDefaultValues.getLabelFrameFillColor();
                }
                if ((lowLblFrameSFX = (HashMap)map.get("LowLblFrameSFX")) == null) {
                    lowLblFrameSFX = GaugeDefaultValues.getBottomLabelSFX();
                }
                if ((lowLblFrameBorderClr = (Color)map.get("LowLblFrameBorderColor")) == null) {
                    lowLblFrameBorderClr = GaugeDefaultValues.getLabelFrameBorderColor();
                }
                int x = this._lowerLabelFrameBounds.x;
                int width = this._lowerLabelFrameBounds.width;
                int y = this._lowerLabelFrameBounds.y;
                int height = this._lowerLabelFrameBounds.height;
                RoundRectangle2D.Double frameRect = new RoundRectangle2D.Double(x, y, width, height, height / 4, height / 4);
                objects.add(new DrawableObject.Shape(26, frameRect, lowLblFrameBorderClr, lowLblFrameFillClr, lowLblFrameSFX, null));
            }
        }
        if (!lblObjects.isEmpty()) {
            objects.addAll(lblObjects);
        }
        return objects;
    }

    protected abstract DrawableObject getNoDataLabelObject(Map var1);

    protected Dimension autoLayout(Graphics2D g, Rectangle rect, Map map) {
        boolean bTitleSeparator;
        if (g == null) {
            g = this._engine.getGraphics();
        }
        int reqAboveSpace = this.getSpaceAboveGauge(map, g);
        int reqBelowSpace = this.getSpaceBelowGauge(map, g);
        int reqLeftSpace = this.getSpaceLeftOfGauge(map, g);
        int reqRightSpace = this.getSpaceRightOfGauge(map, g);
        int availHeight = rect.height - (reqAboveSpace + reqBelowSpace);
        int availWidth = rect.width - (reqLeftSpace + reqRightSpace);
        int radius = this.getGaugeRadius(availWidth, availHeight);
        boolean bCSLayout = GaugeType._definesFullGauge(this._csParser);
        this._gaugeFrameBounds = null;
        this._innerBounds = null;
        this._topLabelBounds = null;
        this._bottomLabelBounds = null;
        this._metricLabelBounds = null;
        this._upperLabelFrameBounds = null;
        this._lowerLabelFrameBounds = null;
        this._topLabelToolTip = null;
        this._bottomLabelToolTip = null;
        this._calcLabelDimensions(map, g);
        Rectangle csBounds = new Rectangle(rect.x + reqLeftSpace, rect.y + reqAboveSpace, rect.width - reqLeftSpace - reqRightSpace, rect.height - reqAboveSpace - reqBelowSpace);
        int visualEffects = GaugeDefaultValues.getVisualEffects();
        if (map.get("VisualEffects") != null) {
            visualEffects = (Integer)map.get("VisualEffects");
        }
        int customLayout = GaugeDefaultValues.getCustomLayout();
        if (map.get("CustomLayout") != null) {
            customLayout = (Integer)map.get("CustomLayout");
        }
        int topLblPos = this.getTopLabelPosition(map);
        boolean bl = bTitleSeparator = (customLayout & 1) != 0 && topLblPos == 3;
        if (this._csParser == null || !bCSLayout || !this._csParser.defines("topLabelBounds") && !this._csParser.defines("upperLabelFrame")) {
            int topLblHeight = GaugeType._getHeight(this._getTopLabelBounds(csBounds, map));
            int upperFrameHeight = GaugeType._getHeight(this._getUpperLabelFrameBounds(this._topLabelBounds, map));
            if (bTitleSeparator && topLblHeight > 0) {
                topLblHeight += 3 + this._layout.getGapHeight(10);
            }
            csBounds = new Rectangle(csBounds.x, csBounds.y + topLblHeight + upperFrameHeight, csBounds.width, csBounds.height - (topLblHeight + upperFrameHeight));
        }
        if (this._csParser == null || !bCSLayout || !this._csParser.defines("metricLabelBounds")) {
            int metricLblHeight = GaugeType._getHeight(this._getMetricLabelBounds(csBounds, map, g));
            csBounds = new Rectangle(csBounds.x, csBounds.y, csBounds.width, csBounds.height - metricLblHeight);
        }
        if (this._csParser == null || !bCSLayout || !this._csParser.defines("bottomLabelBounds") && !this._csParser.defines("lowerLabelFrame")) {
            int btmLblHeight = GaugeType._getHeight(this._getBottomLabelBounds(csBounds, map, g));
            int lowerFrameHeight = GaugeType._getHeight(this._getLowerLabelFrameBounds(csBounds, map));
            csBounds = new Rectangle(csBounds.x, csBounds.y, csBounds.width, csBounds.height - btmLblHeight - lowerFrameHeight);
        }
        if (this._csParser != null && (bCSLayout || this._csParser.defines("gaugeFrame") && GaugeType._hasGaugeFrame(map))) {
            Rectangle2D shapesBounds = this._csParser.getFullBounds();
            this._scaleTransform = GaugeType.getScalingTransform(shapesBounds, csBounds);
            this._moveTransform = GaugeType.getTranslateTransform(shapesBounds, csBounds, this._scaleTransform);
        } else {
            this._scaleTransform = null;
            this._moveTransform = null;
        }
        if (bCSLayout) {
            this._calcCustomShapesLabelBounds();
        }
        this._gaugeFrameBounds = this._getGaugeFrameBounds(csBounds, this._upperLabelFrameBounds, this._lowerLabelFrameBounds, map);
        if (this._csParser != null && this._scaleTransform != null && this._moveTransform != null && (this._csParser.defines("plotArea") || this._csParser.defines("plotAreaBounds"))) {
            Shape shapeBounds = this._csParser.getBounds("plotArea");
            if (shapeBounds == null) {
                shapeBounds = this._csParser.getBounds("plotAreaBounds");
            }
            shapeBounds = this._scaleTransform.createTransformedShape(shapeBounds);
            shapeBounds = this._moveTransform.createTransformedShape(shapeBounds);
            this._innerBounds = shapeBounds.getBounds();
        } else {
            this._innerBounds = this._getPlotAreaBounds(this._gaugeFrameBounds, map, g);
        }
        csBounds = new Rectangle(rect.x + reqLeftSpace, rect.y + reqAboveSpace, rect.width - reqLeftSpace - reqRightSpace, rect.height - reqAboveSpace - reqBelowSpace);
        if (this._topLabelBounds == null) {
            this._topLabelBounds = this._getTopLabelBounds(csBounds, map);
            if (bTitleSeparator && this._topLabelBounds != null) {
                int x = this._topLabelBounds.x;
                int y = this._topLabelBounds.y + this._topLabelBounds.height + this._layout.getGapHeight(3);
                int w = this._topLabelBounds.width;
                int h = 3;
                this._titleSeparatorBounds = new Rectangle(x, y, w, h);
            }
        }
        if (this._upperLabelFrameBounds == null) {
            this._upperLabelFrameBounds = this._getUpperLabelFrameBounds(this._topLabelBounds, map);
        }
        if (this._metricLabelBounds == null) {
            this._metricLabelBounds = this._getMetricLabelBounds(csBounds, map, g);
        }
        if (this._bottomLabelBounds == null) {
            this._bottomLabelBounds = this._getBottomLabelBounds(csBounds, map, g);
        }
        if (this._lowerLabelFrameBounds == null) {
            this._lowerLabelFrameBounds = this._getLowerLabelFrameBounds(csBounds, map);
        }
        Dimension reqSize = new Dimension();
        int topPt = csBounds.y + csBounds.height;
        if (this._upperLabelFrameBounds != null && this._upperLabelFrameBounds.y < topPt) {
            topPt = this._upperLabelFrameBounds.y;
        } else if (this._topLabelBounds != null && this._topLabelBounds.y < topPt) {
            topPt = this._topLabelBounds.y;
        } else if (this._gaugeFrameBounds != null && this._gaugeFrameBounds.y < topPt) {
            topPt = this._gaugeFrameBounds.y;
        }
        int lowPt = csBounds.y;
        if (this._lowerLabelFrameBounds != null && this._lowerLabelFrameBounds.y + this._lowerLabelFrameBounds.height > lowPt) {
            lowPt = this._lowerLabelFrameBounds.y + this._lowerLabelFrameBounds.height;
        } else if (this._bottomLabelBounds != null && this._bottomLabelBounds.y + this._bottomLabelBounds.height > lowPt) {
            lowPt = this._bottomLabelBounds.y + this._bottomLabelBounds.height;
        } else if (this._gaugeFrameBounds != null && this._gaugeFrameBounds.y + this._gaugeFrameBounds.height > lowPt) {
            lowPt = this._gaugeFrameBounds.y + this._gaugeFrameBounds.height;
        }
        reqSize.width = this._gaugeFrameBounds.width + reqLeftSpace + reqRightSpace;
        reqSize.height = lowPt - topPt + reqAboveSpace + reqBelowSpace;
        if (reqSize.width < 0) {
            reqSize.width = 10;
        }
        if (reqSize.height < 0) {
            reqSize.height = 10;
        }
        return reqSize;
    }

    protected int getSpaceAboveGauge(Map map, Graphics2D g) {
        return this.getGaugeSetGap(map, g, 0);
    }

    protected int getSpaceBelowGauge(Map map, Graphics2D g) {
        return this.getGaugeSetGap(map, g, 1);
    }

    protected int getSpaceLeftOfGauge(Map map, Graphics2D g) {
        return this.getGaugeSetGap(map, g, 2);
    }

    protected int getSpaceRightOfGauge(Map map, Graphics2D g) {
        return this.getGaugeSetGap(map, g, 3);
    }

    protected int getGaugeSetGap(Map map, Graphics2D g, int dir) {
        switch (dir) {
            case 0: {
                return this._layout.getGapSize(3);
            }
            case 1: {
                int btmGap = this._layout.getGapSize(6);
                return btmGap > 1 ? btmGap : btmGap + 1;
            }
            case 2: {
                return this._layout.getGapSize(10);
            }
            case 3: {
                int gap = this._layout.getGapSize(10);
                return gap > 1 ? gap : gap + 1;
            }
        }
        return this._layout.getGapSize(3);
    }

    protected abstract int getGaugeRadius(int var1, int var2);

    protected abstract Rectangle getInnerBounds(Map var1, Rectangle var2, int var3, int var4, int var5, int var6);

    protected abstract int getMaxNumberOfSteps();

    protected int getTickLabelWidth(Map map, Graphics2D g, String tickType) {
        String valueLabel = DEF_TICK_LABEL;
        Font font = (Font)map.get("TickLabelFont");
        if (font == null) {
            font = GaugeDefaultValues.getTickLabelFont();
        }
        if (tickType == "minValue") {
            valueLabel = this._engine.formatValue(this._engine.getMin(), "TickLabelViewFormat");
        } else if (tickType == "maxValue") {
            valueLabel = this._engine.formatValue(this._engine.getMax(), "TickLabelViewFormat");
        } else if (tickType == "Metric") {
            valueLabel = this._engine.formatValue(this._engine.getMetric(), "MetricLabelViewFormat");
        }
        Dimension dim = DrawableObject.getLabelDimensions(g, font, valueLabel);
        return dim.width;
    }

    protected void setCustomShapesParser(CustomShapesParser parser) {
        this._csParser = parser;
    }

    protected static AffineTransform getScalingTransform(Shape s, Rectangle bounds) {
        return GaugeType.getScalingTransform(s, bounds, false);
    }

    protected static AffineTransform getScalingTransform(Shape s, Rectangle bounds, boolean flip) {
        Rectangle2D shapeBounds = s.getBounds2D();
        double sx = (double)bounds.width / shapeBounds.getWidth();
        double sy = (double)bounds.height / shapeBounds.getHeight();
        double scaleFactor = Math.min(sx, sy);
        if (!flip) {
            return AffineTransform.getScaleInstance(scaleFactor, scaleFactor);
        }
        return AffineTransform.getScaleInstance(-scaleFactor, scaleFactor);
    }

    protected static AffineTransform getTranslateTransform(Shape s, Rectangle bounds, AffineTransform scale) {
        Rectangle2D scaledBounds = scale != null ? scale.createTransformedShape(s).getBounds2D() : s.getBounds2D();
        double tx = bounds.getCenterX() - scaledBounds.getCenterX();
        double ty = bounds.getCenterY() - scaledBounds.getCenterY();
        return AffineTransform.getTranslateInstance(tx, ty);
    }

    protected void _calcCustomShapesLabelBounds() {
        if (this._csParser != null && this._scaleTransform != null && this._moveTransform != null) {
            Shape shapeBounds;
            if (this._csParser.defines("topLabelBounds") || this._csParser.defines("upperLabelFrame")) {
                shapeBounds = this._csParser.defines("topLabelBounds") ? this._csParser.getBounds("topLabelBounds") : this._csParser.getBounds("upperLabelFrame");
                shapeBounds = this._scaleTransform.createTransformedShape(shapeBounds);
                shapeBounds = this._moveTransform.createTransformedShape(shapeBounds);
                this._topLabelBounds = shapeBounds.getBounds();
            }
            if (this._csParser.defines("upperLabelFrame")) {
                shapeBounds = this._csParser.getBounds("upperLabelFrame");
                shapeBounds = this._scaleTransform.createTransformedShape(shapeBounds);
                shapeBounds = this._moveTransform.createTransformedShape(shapeBounds);
                this._upperLabelFrameBounds = shapeBounds.getBounds();
            }
            if (this._csParser.defines("bottomLabelBounds") || this._csParser.defines("lowerLabelFrame")) {
                shapeBounds = this._csParser.defines("bottomLabelBounds") ? this._csParser.getBounds("bottomLabelBounds") : this._csParser.getBounds("lowerLabelFrame");
                shapeBounds = this._scaleTransform.createTransformedShape(shapeBounds);
                shapeBounds = this._moveTransform.createTransformedShape(shapeBounds);
                this._bottomLabelBounds = shapeBounds.getBounds();
            }
            if (this._csParser.defines("lowerLabelFrame")) {
                shapeBounds = this._csParser.getBounds("lowerLabelFrame");
                shapeBounds = this._scaleTransform.createTransformedShape(shapeBounds);
                shapeBounds = this._moveTransform.createTransformedShape(shapeBounds);
                this._lowerLabelFrameBounds = shapeBounds.getBounds();
            }
            if (this._csParser.defines("metricLabelBounds")) {
                shapeBounds = this._csParser.getBounds("metricLabelBounds");
                shapeBounds = this._scaleTransform.createTransformedShape(shapeBounds);
                shapeBounds = this._moveTransform.createTransformedShape(shapeBounds);
                this._metricLabelBounds = shapeBounds.getBounds();
            }
        }
    }

    protected Rectangle _getTopLabelBounds(Rectangle outerBounds, Map map) {
        boolean bTitleSeparator;
        int pos = this.getTopLabelPosition(map);
        String topLabel = this._engine.getTopLabel();
        int customLayout = GaugeDefaultValues.getCustomLayout();
        if (map.get("CustomLayout") != null) {
            customLayout = (Integer)map.get("CustomLayout");
        }
        boolean bl = bTitleSeparator = (customLayout & 1) != 0;
        if (topLabel == null || pos == 0) {
            return null;
        }
        int topLblHeight = this._topLblDim.height;
        int upperFrameHeight = this._upperFrameDim.height;
        if (pos == 4) {
            if (this._innerBounds != null) {
                boolean hasMetInside;
                int y = this._getPlotAreaCenter(map) - this._topLblDim.height / 2;
                int btmLblPos = this.getBottomLabelPosition(map);
                int metLblPos = this.getMetricLabelPosition(map);
                boolean hasBtmInside = this._btmLblDim != null && btmLblPos == 4;
                boolean bl2 = hasMetInside = this._metLblDim != null && metLblPos == 4;
                if (hasBtmInside && hasMetInside) {
                    y -= (2 * this._layout.getGapHeight(3) + this._btmLblDim.height + this._metLblDim.height) / 2;
                } else if (hasBtmInside) {
                    y -= (this._layout.getGapHeight(3) + this._btmLblDim.height) / 2;
                } else if (hasMetInside) {
                    y -= (this._layout.getGapHeight(3) + this._metLblDim.height) / 2;
                }
                return new Rectangle(this._innerBounds.x, y, this._innerBounds.width, topLblHeight);
            }
            return null;
        }
        if (bTitleSeparator && outerBounds != null) {
            int x = outerBounds.x;
            int y = outerBounds.y;
            int width = outerBounds.width;
            int height = topLblHeight;
            if (this._gaugeFrameBounds != null) {
                return new Rectangle(x, y, width, height);
            }
            return new Rectangle(x, y, width, height + this._layout.getGapHeight(3));
        }
        if (this._gaugeFrameBounds != null) {
            int extraFrameWidth = this._upperFrameDim.width;
            int x = outerBounds.x + extraFrameWidth / 2;
            int width = outerBounds.width - extraFrameWidth;
            int y = this._gaugeFrameBounds.y - 2 * this._layout.getGapHeight(3) - upperFrameHeight / 2 - topLblHeight;
            return new Rectangle(x, y, width, topLblHeight);
        }
        if (outerBounds != null) {
            return new Rectangle(0, 0, 0, topLblHeight + 2 * this._layout.getGapHeight(3));
        }
        return null;
    }

    protected Rectangle _getUpperLabelFrameBounds(Rectangle labelBounds, Map map) {
        boolean bTitleSeparator;
        int upperFrameHeight = this._upperFrameDim.height;
        int pos = this.getTopLabelPosition(map);
        int customLayout = GaugeDefaultValues.getCustomLayout();
        if (map.get("CustomLayout") != null) {
            customLayout = (Integer)map.get("CustomLayout");
        }
        boolean bl = bTitleSeparator = (customLayout & 1) != 0;
        if (!bTitleSeparator && pos == 3) {
            if (labelBounds == null) {
                return new Rectangle(0, 0, 0, upperFrameHeight);
            }
            if (pos == 3) {
                int x = labelBounds.x;
                int y = labelBounds.y - upperFrameHeight / 2;
                int w = labelBounds.width;
                int h = labelBounds.height + upperFrameHeight;
                Rectangle frameBounds = new Rectangle(x, y, w, h);
                return frameBounds;
            }
        }
        return null;
    }

    private Rectangle _getBottomLabelBounds(Rectangle outerBounds, Map map, Graphics2D g) {
        int btmLblPos = this.getBottomLabelPosition(map);
        int metLblPos = this.getMetricLabelPosition(map);
        String bottomLabel = this._engine.getBottomLabel();
        if (btmLblPos == 0 || bottomLabel == null && metLblPos != 2) {
            return null;
        }
        int bottomLblHeight = this._btmLblDim.height;
        if (metLblPos == 2) {
            bottomLblHeight = Math.max(this._btmLblDim.height, this._metLblDim.height);
        }
        if (btmLblPos == 4) {
            if (this._innerBounds != null) {
                boolean hasMetInside;
                int y = this._getPlotAreaCenter(map) - this._btmLblDim.height / 2;
                int topLblPos = this.getTopLabelPosition(map);
                boolean hasTopInside = this._topLblDim != null && topLblPos == 4;
                boolean bl = hasMetInside = this._metLblDim != null && metLblPos == 4;
                if (hasTopInside && !hasMetInside) {
                    y += (this._layout.getGapHeight(3) + this._topLblDim.height) / 2;
                } else if (!hasTopInside && hasMetInside) {
                    y -= (this._layout.getGapHeight(3) + this._metLblDim.height) / 2;
                }
                return new Rectangle(this._innerBounds.x, y, this._innerBounds.width, this._btmLblDim.height);
            }
            return null;
        }
        if (this._gaugeFrameBounds != null) {
            int x = outerBounds.x + this._lowerFrameDim.width / 2;
            int width = outerBounds.width - this._lowerFrameDim.width;
            int y = this.getGaugeType() == 0 ? this._gaugeFrameBounds.y + this._gaugeFrameBounds.height + this._layout.getGapHeight(5) : this._gaugeFrameBounds.y + this._gaugeFrameBounds.height + this._layout.getGapHeight(5);
            return new Rectangle(x, y += this._lowerFrameDim.height / 2, width, bottomLblHeight);
        }
        if (outerBounds != null) {
            return new Rectangle(0, 0, 0, bottomLblHeight + this._layout.getGapHeight(5));
        }
        return null;
    }

    private Rectangle _getLowerLabelFrameBounds(Rectangle outerBounds, Map map) {
        boolean bBtmLblBelow;
        Font btmFont = (Font)map.get("BottomLabelFont");
        if (btmFont == null) {
            btmFont = GaugeDefaultValues.getBottomLabelFont();
        }
        boolean showLowerLbl = GaugeDefaultValues.isLowerLabelFrameVisible();
        if (map.get("LowLblFrameVisible") != null) {
            showLowerLbl = (Boolean)map.get("LowLblFrameVisible");
        }
        int pos = this.getBottomLabelPosition(map);
        int metLblPos = this.getMetricLabelPosition(map);
        int frameHeight = this._lowerFrameDim.height;
        boolean bMetLblExists = this._metLblDim != null && this._metLblDim.width > 0 && this._metLblDim.height > 0;
        boolean bMetLblBelow = bMetLblExists && metLblPos == 1;
        boolean bl = bBtmLblBelow = pos == 1 && (this._btmLblDim != null && this._btmLblDim.width > 0 && this._btmLblDim.height > 0 || metLblPos == 2 && bMetLblExists);
        if (this._gaugeFrameBounds == null && showLowerLbl && (bMetLblBelow || bBtmLblBelow)) {
            return new Rectangle(0, 0, 0, frameHeight);
        }
        if (this._gaugeFrameBounds != null && showLowerLbl && (this._metricLabelBounds != null && bMetLblBelow || this._bottomLabelBounds != null && bBtmLblBelow)) {
            int minY = bBtmLblBelow && this._bottomLabelBounds != null ? this._bottomLabelBounds.y - frameHeight / 2 : this._metricLabelBounds.y - frameHeight / 2;
            int maxY = bMetLblBelow && this._metricLabelBounds != null ? this._metricLabelBounds.y + this._metricLabelBounds.height + frameHeight / 2 : this._bottomLabelBounds.y + this._bottomLabelBounds.height + frameHeight / 2;
            return new Rectangle(outerBounds.x, minY, outerBounds.width, maxY - minY);
        }
        return null;
    }

    protected Rectangle _getMetricLabelBounds(Rectangle outerBounds, Map map, Graphics2D g) {
        int metLblPos = this.getMetricLabelPosition(map);
        Font metFont = (Font)map.get("MetricLabelFont");
        if (metFont == null) {
            metFont = GaugeDefaultValues.getMetricLabelFont();
        }
        String metLabel = this._engine.formatValue(this._engine.getMetric(), "MetricLabelViewFormat");
        boolean showBtmLbl = GaugeDefaultValues.isLowerLabelFrameVisible();
        if (map.get("LowLblFrameVisible") != null) {
            showBtmLbl = (Boolean)map.get("LowLblFrameVisible");
        }
        int btmLblPos = this.getBottomLabelPosition(map);
        if (metLabel == null) {
            return null;
        }
        if (metLblPos == 1) {
            if (this._gaugeFrameBounds != null) {
                int bottomLabelHeight = 0;
                if (btmLblPos == 1 && this._btmLblDim != null) {
                    bottomLabelHeight = this._btmLblDim.height + this._layout.getGapHeight(3);
                }
                int extraFrameHeight = 0;
                if (this._lowerLabelFrameBounds != null) {
                    extraFrameHeight = this._lowerLabelFrameBounds.height - this._metLblDim.height - bottomLabelHeight;
                } else if (showBtmLbl) {
                    extraFrameHeight = this._lowerFrameDim.height;
                }
                int extraFrameWidth = this._lowerFrameDim.width;
                int x = outerBounds.x + extraFrameWidth / 2;
                int w = outerBounds.width - extraFrameWidth;
                int y = this._gaugeFrameBounds.y + this._gaugeFrameBounds.height + this._layout.getGapHeight(3) + bottomLabelHeight + extraFrameHeight / 2;
                return new Rectangle(x, y, w, this._metLblDim.height);
            }
            if (outerBounds != null) {
                return new Rectangle(0, 0, 0, this._metLblDim.height + this._layout.getGapHeight(3));
            }
            return null;
        }
        if (metLblPos == 4 || metLblPos == 5 || metLblPos == 6) {
            if (this._innerBounds != null) {
                boolean hasBtmInside;
                int y = this._getPlotAreaCenter(map) - this._metLblDim.height / 2;
                Font topFont = (Font)map.get("TopLabelFont");
                if (topFont == null) {
                    topFont = GaugeDefaultValues.getTopLabelFont();
                }
                int topLblPos = this.getTopLabelPosition(map);
                boolean hasTopInside = this._topLblDim != null && topLblPos == 4;
                boolean bl = hasBtmInside = btmLblPos == 4;
                if (hasTopInside && hasBtmInside) {
                    y += (2 * this._layout.getGapHeight(3) + this._topLblDim.height + this._btmLblDim.height) / 2;
                } else if (hasTopInside) {
                    y += (this._layout.getGapHeight(3) + this._topLblDim.height) / 2;
                } else if (hasBtmInside) {
                    y += (this._layout.getGapHeight(3) + this._btmLblDim.height) / 2;
                }
                if (metLblPos == 4) {
                    return new Rectangle(this._innerBounds.x, y, this._innerBounds.width, this._metLblDim.height);
                }
                if (this.getGaugeType() == 2) {
                    int style;
                    Integer styleObj = (Integer)map.get("LEDStyle");
                    int n = style = styleObj != null ? styleObj : GaugeDefaultValues.getLEDStyle();
                    if (style == 5) {
                        if (metLblPos == 5) {
                            return new Rectangle(this._innerBounds.x + this._layout.getGapWidth(5), y, this._metLblDim.width, this._metLblDim.height);
                        }
                        if (metLblPos == 6) {
                            return new Rectangle(this._innerBounds.x + this._innerBounds.width - this._layout.getGapWidth(5) - this._metLblDim.width, y, this._metLblDim.width, this._metLblDim.height);
                        }
                    }
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private Rectangle _getGaugeFrameBounds(Rectangle outerBounds, Rectangle upperFrameBounds, Rectangle lowerFrameBounds, Map map) {
        if (this._csParser != null && this._scaleTransform != null && this._moveTransform != null && this._csParser.defines("gaugeFrame")) {
            Shape shapeBounds = this._csParser.getBounds("gaugeFrame");
            shapeBounds = this._scaleTransform.createTransformedShape(shapeBounds);
            shapeBounds = this._moveTransform.createTransformedShape(shapeBounds);
            return shapeBounds.getBounds();
        }
        return this._calcGaugeFrameBounds(outerBounds, upperFrameBounds, lowerFrameBounds, map);
    }

    private Rectangle _calcGaugeFrameBounds(Rectangle outerBounds, Rectangle upperFrameBounds, Rectangle lowerFrameBounds, Map map) {
        int minY = upperFrameBounds != null ? upperFrameBounds.y + upperFrameBounds.height : outerBounds.y;
        int maxY = lowerFrameBounds != null ? lowerFrameBounds.y : outerBounds.y + outerBounds.height;
        int x = outerBounds.x;
        int w = outerBounds.width;
        return new Rectangle(x, minY, w, maxY - minY);
    }

    protected Rectangle _getPlotAreaBounds(Rectangle gaugeFrameBounds, Map map, Graphics2D g) {
        int reqAboveSpace = 0;
        int reqBelowSpace = 0;
        int reqLeftSpace = 0;
        int reqRightSpace = 0;
        Rectangle bounds = this.getInnerBounds(map, gaugeFrameBounds, reqAboveSpace, reqBelowSpace, reqLeftSpace, reqRightSpace);
        if (this._csParser == null || !this._csParser.defines("gaugeFrame")) {
            this._gaugeFrameBounds = new Rectangle(bounds.x - reqLeftSpace, bounds.y - reqAboveSpace, bounds.width + reqLeftSpace + reqRightSpace, bounds.height + reqAboveSpace + reqBelowSpace);
        }
        return bounds;
    }

    protected int getFrameHeight(Graphics2D g, Font f) {
        Dimension oneCharDim = DrawableObject.getLabelDimensions(g, f, "n");
        int backHgt = (int)((double)oneCharDim.height * 0.33 / 2.0);
        return backHgt * 2;
    }

    private static int _getHeight(Rectangle rect) {
        if (rect != null) {
            return rect.height;
        }
        return 0;
    }

    private static boolean _definesFullGauge(CustomShapesParser csp) {
        return !(csp == null || !csp.defines("gaugeFrame") && !csp.defines("plotArea") && !csp.defines("plotAreaBounds") || !csp.defines("topLabelBounds") && !csp.defines("bottomLabelBounds") && !csp.defines("upperLabelFrame") && !csp.defines("lowerLabelFrame") && !csp.defines("metricLabelBounds"));
    }

    protected static boolean _hasGaugeFrame(Map map) {
        Boolean drawRaised = (Boolean)map.get("GaugeFrameVisible");
        if (drawRaised == null) {
            drawRaised = GaugeDefaultValues.isGaugeFrameVisible();
        }
        return drawRaised;
    }

    protected int _getPlotAreaCenter(Map map) {
        if (this._innerBounds != null) {
            return this._innerBounds.y + this._innerBounds.height / 2;
        }
        return -1;
    }

    protected void _calcLabelDimensions(Map map, Graphics2D g) {
        Color topFontColor;
        Font topFont = (Font)map.get("TopLabelFont");
        if (topFont == null) {
            topFont = GaugeDefaultValues.getTopLabelFont();
        }
        if ((topFontColor = (Color)map.get("TopLabelColor")) == null) {
            topFontColor = GaugeDefaultValues.getTopLabelFontColor();
        }
        String topLabel = this._engine.getTopLabel();
        this._topLblDim = DrawableObject.getLabelDimensions(g, topFont, topLabel);
        if (this._topLblDim == null) {
            this._topLblDim = new Dimension(0, 0);
        }
        int btmLblPos = this.getBottomLabelPosition(map);
        Font btmFont = (Font)map.get("BottomLabelFont");
        if (btmFont == null) {
            btmFont = GaugeDefaultValues.getBottomLabelFont();
        }
        String bottomLabel = this._engine.getBottomLabel();
        this._btmLblDim = DrawableObject.getLabelDimensions(g, btmFont, bottomLabel);
        if (this._btmLblDim == null) {
            this._btmLblDim = new Dimension(0, 0);
        }
        int metLblPos = this.getMetricLabelPosition(map);
        Font metFont = (Font)map.get("MetricLabelFont");
        if (metFont == null) {
            metFont = GaugeDefaultValues.getMetricLabelFont();
        }
        String metLabel = this._engine.formatValue(this._engine.getMetric(), "MetricLabelViewFormat");
        this._metLblDim = DrawableObject.getLabelDimensions(g, metFont, metLabel);
        if (this._metLblDim == null) {
            this._metLblDim = new Dimension(0, 0);
        }
        boolean showUpLbl = GaugeDefaultValues.isUpperLabelFrameVisible();
        if (map.get("UpLblFrameVisible") != null) {
            showUpLbl = (Boolean)map.get("UpLblFrameVisible");
        }
        if (showUpLbl) {
            Dimension oneCharDim = DrawableObject.getLabelDimensions(g, topFont, "n");
            int extraFrameWidth = 2 * oneCharDim.width;
            int extraFrameHeight = this.getFrameHeight(g, topFont);
            this._upperFrameDim = new Dimension(extraFrameWidth, extraFrameHeight);
        } else {
            this._upperFrameDim = new Dimension(0, 0);
        }
        boolean showBtmLbl = GaugeDefaultValues.isLowerLabelFrameVisible();
        if (map.get("LowLblFrameVisible") != null) {
            showBtmLbl = (Boolean)map.get("LowLblFrameVisible");
        }
        if (showBtmLbl) {
            Dimension oneCharDim = DrawableObject.getLabelDimensions(g, btmFont, "n");
            int extraFrameWidth = 2 * oneCharDim.width;
            int extraFrameHeight = this.getFrameHeight(g, btmFont);
            this._lowerFrameDim = new Dimension(extraFrameWidth, extraFrameHeight);
        } else {
            this._lowerFrameDim = new Dimension(0, 0);
        }
    }

    protected Color _getIndicatorColor(Map map, boolean autoColor) {
        return this._getIndicatorColor(map, autoColor, 0);
    }

    protected Color _getIndicatorColor(Map map, boolean autoColor, int ind) {
        Double metric = this._engine.getMetric(ind);
        if (metric != null) {
            Color indicatorColor = GaugeDefaultValues.getIndicatorFillColor();
            if (GaugeEngine.getIndicatorAttr(map, "IndicatorFillColor", ind) != null) {
                indicatorColor = (Color)GaugeEngine.getIndicatorAttr(map, "IndicatorFillColor", ind);
            }
            double[] tValues = (double[])map.get("ThresholdValues");
            if (autoColor && tValues != null) {
                ArrayList tList;
                int index = -1;
                for (int i = 0; i < tValues.length; ++i) {
                    if (metric <= tValues[i]) {
                        index = i;
                        break;
                    }
                    if (i != tValues.length - 1) continue;
                    index = tValues.length;
                }
                if ((tList = (ArrayList)map.get("THRESHOLD_ATTRIBUTES")) != null && index < tList.size()) {
                    HashMap tMap = (HashMap)tList.get(index);
                    indicatorColor = (Color)GaugeType.getThresholdAttribute(tMap, index, "ThresholdFillColor");
                } else {
                    Color[] defClrs = GaugeDefaultValues.getThresholdColors();
                    indicatorColor = index < defClrs.length ? defClrs[index] : GaugeDefaultValues.getIndicatorFillColor();
                }
            }
            return indicatorColor;
        }
        return null;
    }

    protected Color _blendColors(Color a, Color b) {
        if (a == null || b == null) {
            return null;
        }
        int alpha = (a.getAlpha() + b.getAlpha()) / 2;
        int red = (a.getRed() + b.getRed()) / 2;
        int green = (a.getGreen() + b.getGreen()) / 2;
        int blue = (a.getBlue() + b.getBlue()) / 2;
        return new Color(red, green, blue, alpha);
    }

    public void setLocale(Locale loc) {
        this.m_locale = loc;
        this.updateResourceBundle();
    }

    protected void updateResourceBundle() {
        try {
            if (this.m_locale != null) {
                this._gaugeBundle = ResourceBundle.getBundle("oracle.dss.gauge.resource.GaugeBundle", this.m_locale);
                this._utilBundle = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle", this.m_locale);
            } else {
                this._gaugeBundle = ResourceBundle.getBundle("oracle.dss.gauge.resource.GaugeBundle");
                this._utilBundle = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle");
            }
        }
        catch (MissingResourceException e) {
            this._gaugeBundle = null;
            this._utilBundle = null;
        }
    }

    int getTopLabelPosition(Map map) {
        int topLblPos = GaugeDefaultValues.getTopLabelPosition();
        if (map.get("TopLabelPosition") != null) {
            topLblPos = (Integer)map.get("TopLabelPosition");
        }
        return topLblPos;
    }

    int getBottomLabelPosition(Map map) {
        int btmLblPos = GaugeDefaultValues.getBottomLabelPosition();
        if (map.get("BottomLabelPosition") != null) {
            btmLblPos = (Integer)map.get("BottomLabelPosition");
        }
        return btmLblPos;
    }

    int getMetricLabelPosition(Map map) {
        int metLblPos = GaugeDefaultValues.getMetricLabelPosition();
        if (map.get("MetricLabelPosition") != null) {
            metLblPos = (Integer)map.get("MetricLabelPosition");
        }
        return metLblPos;
    }

    String getTopLabelToolTip() {
        return this._topLabelToolTip;
    }

    String getBottomLabelToolTip() {
        return this._bottomLabelToolTip;
    }
}

