/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import oracle.bali.ewt.button.PushButton;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.imageCanvas.ImageCanvas;
import oracle.bali.ewt.print.PrinterGraphics2DProxy;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.UIViewPrinter;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.dataView.gui.PrintDialogsProvider;
import oracle.dss.dataView.gui.ToolBar;

public class PreviewPanel
extends JPanel
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 1L;
    public static final int SCALE_IMAGE_DEFAULT = 2;
    public static final int SCALE_IMAGE_SMOOTH = 4;
    private PrintDialogsProvider m_pdp = null;
    private int paperWidth;
    private int paperHeight;
    private int preferredWidth;
    private int scalingMode = 2;
    private int scaledWidth;
    private int scaledHeight;
    private long pageNum = 1L;
    private JButton previous;
    private JButton next;
    private PushButton first;
    private PushButton last;
    private JComboBox m_zoomBox;
    private Graphics pg;
    private JTextField field;
    private JPanel pagePanel;
    private JPanel toolBar;
    private JScrollPane pane;
    private ImageCanvas canvas;
    private BufferedImage bImage;
    private UIViewPrinter[] printers = null;
    protected long m_currentLogicalPage = 0L;
    protected int m_currentViewPrinter = 0;
    protected boolean[] m_bViewPrinterGoToPrev = null;
    protected boolean[] m_bViewPrinterGoToNext = null;
    protected boolean[] m_bDataInFirstPage = null;
    protected boolean[] m_bDataInPages = new boolean[500];
    ResourceBundle dvStrings = null;

    public PreviewPanel(ViewPrinter[] printers, PrintDialogsProvider pdp) {
        UIViewPrinter[] uiViewPrinters = printers;
        this.constructPanel(printers, pdp);
    }

    public PreviewPanel(UIViewPrinter printer, PrintDialogsProvider pdp) {
        UIViewPrinter[] uiViewPrinters = new UIViewPrinter[]{printer};
        this.constructPanel(uiViewPrinters, pdp);
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
    }

    public void componentResized() {
        if (this.m_zoomBox.getSelectedIndex() == 1) {
            this.scaleComponents();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource() == this.last && !this.last.isEnabled()) {
            this.last.transferFocus();
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.previous) {
            --this.pageNum;
            if (this.printers[0].getViewPrinterType() <= 2) {
                this.bImage = new BufferedImage(this.paperWidth, this.paperHeight, 2);
                this.pg = new PrinterGraphics2DProxy(this.bImage.createGraphics(), null);
                if (this.preparePrevPage(this.pg)) {
                    this.printers[this.m_currentViewPrinter].renderPage(this.pg);
                }
            } else {
                this.printers[0].preparePrevPage(this.pg);
                Dimension viewDimension = this.printers[0].getViewDimension();
                this.paperWidth = viewDimension.width;
                this.paperHeight = viewDimension.height;
                this.bImage = new BufferedImage(this.paperWidth, this.paperHeight, 2);
                this.pg = new PrinterGraphics2DProxy(this.bImage.createGraphics(), null);
                this.printers[0].renderPage(this.pg);
            }
            Object[] formatArgs = new String[]{Long.toString(this.pageNum)};
            this.field.setText(" " + MessageFormat.format(this.getIntlString("pageNumber"), formatArgs) + " ");
            if (this.field.getPreferredSize().width != this.preferredWidth) {
                this.field.setMaximumSize(this.field.getPreferredSize());
                this.toolBar.validate();
                this.toolBar.invalidate();
                this.preferredWidth = this.field.getPreferredSize().width;
            }
            if (this.m_zoomBox.getSelectedIndex() == 1) {
                this.scaleComponents();
            } else {
                this.pagePanel.setPreferredSize(new Dimension(this.paperWidth + 30, this.paperHeight + 30));
                this.canvas.setBounds(10, 10, this.paperWidth, this.paperHeight);
                this.canvas.setSize(this.paperWidth, this.paperHeight);
                this.canvas.setImage((Image)this.bImage);
            }
            if (!this.hasPrevPage()) {
                this.previous.setEnabled(false);
                this.first.setEnabled(false);
            }
            this.next.setEnabled(true);
            this.last.setEnabled(true);
        } else if (event.getSource() == this.next) {
            this.previous.setEnabled(true);
            this.first.setEnabled(true);
            ++this.pageNum;
            if (this.printers[0].getViewPrinterType() <= 2) {
                this.bImage = new BufferedImage(this.paperWidth, this.paperHeight, 2);
                this.pg = new PrinterGraphics2DProxy(this.bImage.createGraphics(), null);
                if ((long)this.m_bDataInPages.length < this.pageNum) {
                    boolean[] pages = new boolean[this.m_bDataInPages.length * 2];
                    for (int i = 0; i < this.m_bDataInPages.length; ++i) {
                        pages[i] = this.m_bDataInPages[i];
                    }
                    this.m_bDataInPages = pages;
                }
                if (this.prepareNextPage(this.pg)) {
                    this.m_bDataInPages[(int)(this.pageNum - 1L)] = true;
                    this.printers[this.m_currentViewPrinter].renderPage(this.pg);
                } else {
                    this.m_bDataInPages[(int)(this.pageNum - 1L)] = false;
                }
            } else {
                this.printers[0].prepareNextPage(this.pg);
                Dimension viewDimension = this.printers[0].getViewDimension();
                this.paperWidth = viewDimension.width;
                this.paperHeight = viewDimension.height;
                this.bImage = new BufferedImage(this.paperWidth, this.paperHeight, 2);
                this.pg = new PrinterGraphics2DProxy(this.bImage.createGraphics(), null);
                this.printers[0].renderPage(this.pg);
            }
            Object[] formatArgs = new String[]{Long.toString(this.pageNum)};
            this.field.setText(" " + MessageFormat.format(this.getIntlString("pageNumber"), formatArgs) + " ");
            if (this.field.getPreferredSize().width != this.preferredWidth) {
                this.field.setMaximumSize(this.field.getPreferredSize());
                this.toolBar.validate();
                this.toolBar.invalidate();
                this.preferredWidth = this.field.getPreferredSize().width;
            }
            if (this.m_zoomBox.getSelectedIndex() == 1) {
                this.scaleComponents();
            } else {
                this.pagePanel.setPreferredSize(new Dimension(this.paperWidth + 30, this.paperHeight + 30));
                this.canvas.setBounds(10, 10, this.paperWidth, this.paperHeight);
                this.canvas.setSize(this.paperWidth, this.paperHeight);
                this.canvas.setImage((Image)this.bImage);
            }
            if (!this.hasNextPage()) {
                this.next.setEnabled(false);
                this.last.setEnabled(false);
                this.field.requestFocus();
            }
        } else if (event.getSource() == this.first) {
            this.setCursor(WindowUtils.getWindow((Component)this.last), this.printers[0].getWaitCursor());
            this.previous.setEnabled(false);
            this.first.setEnabled(false);
            this.next.setEnabled(true);
            this.last.setEnabled(true);
            this.pageNum = 1L;
            boolean hasData = false;
            if (this.printers[0].getViewPrinterType() <= 2) {
                this.bImage = new BufferedImage(this.paperWidth, this.paperHeight, 2);
                this.pg = new PrinterGraphics2DProxy(this.bImage.createGraphics(), null);
                for (int i = 0; i < this.printers.length; ++i) {
                    this.m_bViewPrinterGoToPrev[i] = true;
                    this.m_bViewPrinterGoToNext[i] = true;
                }
                while (this.hasPrevPage()) {
                    hasData = this.preparePrevPage(this.pg);
                }
                if (hasData) {
                    this.printers[this.m_currentViewPrinter].renderPage(this.pg);
                }
            } else {
                this.printers[0].goToFirstPage(this.pg);
                Dimension viewDimension = this.printers[0].getViewDimension();
                this.paperWidth = viewDimension.width;
                this.paperHeight = viewDimension.height;
                this.bImage = new BufferedImage(this.paperWidth, this.paperHeight, 2);
                this.pg = new PrinterGraphics2DProxy(this.bImage.createGraphics(), null);
                this.printers[0].renderFirstPage(this.pg);
            }
            Object[] formatArgs = new String[]{Long.toString(this.pageNum)};
            this.field.setText(" " + MessageFormat.format(this.getIntlString("pageNumber"), formatArgs) + " ");
            if (this.field.getPreferredSize().width != this.preferredWidth) {
                this.field.setMaximumSize(this.field.getPreferredSize());
                this.toolBar.validate();
                this.toolBar.invalidate();
                this.preferredWidth = this.field.getPreferredSize().width;
            }
            if (this.m_zoomBox.getSelectedIndex() == 1) {
                this.scaleComponents();
            } else {
                this.pagePanel.setPreferredSize(new Dimension(this.paperWidth + 30, this.paperHeight + 30));
                this.canvas.setBounds(10, 10, this.paperWidth, this.paperHeight);
                this.canvas.setSize(this.paperWidth, this.paperHeight);
                this.canvas.setImage((Image)this.bImage);
            }
            this.setCursor(WindowUtils.getWindow((Component)this.last), this.printers[0].getDefaultCursor());
        } else if (event.getSource() == this.last) {
            this.setCursor(WindowUtils.getWindow((Component)this.last), this.printers[0].getWaitCursor());
            this.next.setEnabled(false);
            this.last.setEnabled(false);
            this.previous.setEnabled(true);
            this.first.setEnabled(true);
            boolean hasData = false;
            if (this.printers[0].getViewPrinterType() <= 2) {
                this.bImage = new BufferedImage(this.paperWidth, this.paperHeight, 2);
                this.pg = new PrinterGraphics2DProxy(this.bImage.createGraphics(), null);
                while (this.hasNextPage()) {
                    hasData = this.prepareNextPage(this.pg);
                    ++this.pageNum;
                }
                if (hasData) {
                    this.printers[this.m_currentViewPrinter].renderPage(this.pg);
                }
            } else {
                this.printers[0].goToLastPage(this.pg);
                Dimension viewDimension = this.printers[0].getViewDimension();
                this.paperWidth = viewDimension.width;
                this.paperHeight = viewDimension.height;
                this.bImage = new BufferedImage(this.paperWidth, this.paperHeight, 2);
                this.pg = new PrinterGraphics2DProxy(this.bImage.createGraphics(), null);
                this.printers[0].renderLastPage(this.pg);
                this.pageNum = this.printers[0].getSequentialPageNumber();
            }
            Object[] formatArgs = new String[]{Long.toString(this.pageNum)};
            this.field.setText(" " + MessageFormat.format(this.getIntlString("pageNumber"), formatArgs) + " ");
            if (this.field.getPreferredSize().width != this.preferredWidth) {
                this.field.setMaximumSize(this.field.getPreferredSize());
                this.toolBar.validate();
                this.toolBar.invalidate();
                this.preferredWidth = this.field.getPreferredSize().width;
            }
            if (this.m_zoomBox.getSelectedIndex() == 1) {
                this.scaleComponents();
            } else {
                this.pagePanel.setPreferredSize(new Dimension(this.paperWidth + 30, this.paperHeight + 30));
                this.canvas.setBounds(10, 10, this.paperWidth, this.paperHeight);
                this.canvas.setSize(this.paperWidth, this.paperHeight);
                this.canvas.setImage((Image)this.bImage);
            }
            this.setCursor(WindowUtils.getWindow((Component)this.last), this.printers[0].getDefaultCursor());
        } else if (event.getSource() == this.m_zoomBox) {
            if (this.m_zoomBox.getSelectedIndex() == 1) {
                this.scaleComponents();
            } else {
                this.pagePanel.setPreferredSize(new Dimension(this.paperWidth + 30, this.paperHeight + 30));
                this.canvas.setBounds(10, 10, this.paperWidth, this.paperHeight);
                this.canvas.setSize(this.paperWidth, this.paperHeight);
                this.canvas.setImage((Image)this.bImage);
            }
        }
    }

    protected void setCursor(Component component, Cursor c) {
        component.setCursor(c);
        if (component instanceof Container) {
            Container cont = (Container)component;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                this.setCursor(cont.getComponent(i), c);
            }
        }
    }

    private void constructPanel(UIViewPrinter[] printers, PrintDialogsProvider pdp) {
        this.printers = printers;
        this.m_pdp = pdp;
        this.updateResourceBundle(printers[0].getLocale());
        this.setLayout(new BorderLayout());
        this.pagePanel = new JPanel();
        this.pagePanel.setLayout(null);
        Dimension viewDimension = printers[0].getViewDimension();
        this.paperWidth = viewDimension.width;
        this.paperHeight = viewDimension.height;
        this.pagePanel.setBackground(Color.white);
        this.pagePanel.setPreferredSize(new Dimension(this.paperWidth + 20, this.paperHeight + 20));
        this.pane = new JScrollPane(this.pagePanel, 20, 30);
        this.add(Box.createHorizontalStrut(11), "East");
        this.add(Box.createHorizontalStrut(11), "West");
        this.add(Box.createVerticalStrut(11), "South");
        this.add((Component)this.pane, "Center");
        this.toolBar = new JPanel();
        this.toolBar.setLayout(new BoxLayout(this.toolBar, 0));
        this.toolBar.setBorder(new EmptyBorder(3, 3, 5, 3));
        String translatedText = this.getIntlString("Zoom:");
        JLabel zoom = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        zoom.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        zoom.setAlignmentY(0.5f);
        this.toolBar.add(Box.createHorizontalStrut(9));
        this.toolBar.add(zoom);
        this.toolBar.add(Box.createHorizontalStrut(6));
        String[] m_zoomType = new String[]{this.getIntlString("100%"), this.getIntlString("FitToPage")};
        this.m_zoomBox = new JComboBox<String>(m_zoomType);
        this.m_zoomBox.setSelectedIndex(1);
        this.m_zoomBox.setMaximumSize(this.m_zoomBox.getPreferredSize());
        this.m_zoomBox.addActionListener(this);
        this.m_zoomBox.setAlignmentY(0.5f);
        zoom.setLabelFor(this.m_zoomBox);
        this.toolBar.add(this.m_zoomBox);
        this.toolBar.add(Box.createHorizontalGlue());
        this.first = new PushButton((Icon)new ImageIcon(ImageUtils.getImageResource(ToolBar.class, (String)"images/first.gif")));
        this.first.getAccessibleContext().setAccessibleName(this.dvStrings.getString("First Page"));
        this.first.setAlignmentY(0.5f);
        this.toolBar.add((Component)this.first);
        this.first.addActionListener((ActionListener)this);
        this.first.setEnabled(false);
        this.first.setLeftmost(true);
        this.previous = new JButton(new ImageIcon(ImageUtils.getImageResource(ToolBar.class, (String)"images/prev.gif")));
        this.previous.getAccessibleContext().setAccessibleName(this.dvStrings.getString("Previous Page"));
        this.previous.setEnabled(false);
        this.previous.addActionListener(this);
        this.previous.setAlignmentY(0.5f);
        this.toolBar.add(this.previous);
        this.field = new JTextField();
        this.field.setEditable(false);
        this.field.setAlignmentY(0.5f);
        this.toolBar.add(this.field);
        Object[] formatArgs = new String[]{Long.toString(this.pageNum)};
        this.field.setText(" " + MessageFormat.format(this.getIntlString("pageNumber"), formatArgs) + " ");
        this.preferredWidth = this.field.getPreferredSize().width;
        this.field.setMaximumSize(this.field.getPreferredSize());
        this.next = new JButton(new ImageIcon(ImageUtils.getImageResource(ToolBar.class, (String)"images/next.gif")));
        this.next.getAccessibleContext().setAccessibleName(this.dvStrings.getString("Next Page"));
        this.next.addActionListener(this);
        this.next.setAlignmentY(0.5f);
        this.toolBar.add(this.next);
        this.last = new PushButton((Icon)new ImageIcon(ImageUtils.getImageResource(ToolBar.class, (String)"images/last.gif")));
        this.last.getAccessibleContext().setAccessibleName(this.dvStrings.getString("Last Page"));
        this.last.setAlignmentY(0.5f);
        this.toolBar.add((Component)this.last);
        this.last.addActionListener((ActionListener)this);
        this.last.setRightmost(true);
        this.toolBar.add(Box.createHorizontalStrut(9));
        this.add((Component)this.toolBar, "North");
        this.bImage = new BufferedImage(this.paperWidth, this.paperHeight, 2);
        this.pg = new PrinterGraphics2DProxy(this.bImage.createGraphics(), null);
        this.init(this.pg);
        this.canvas = new ImageCanvas((Image)this.bImage);
        this.canvas.setBorder((Border)new LineBorder(Color.black));
        this.canvas.setBounds(10, 10, this.paperWidth, this.paperHeight);
        if (!this.hasNextPage()) {
            this.next.setEnabled(false);
            this.last.setEnabled(false);
        }
        this.pagePanel.add((Component)this.canvas);
        this.last.addFocusListener((FocusListener)this);
    }

    public void cleanUp() {
        super.removeAll();
        this.removeAll();
        this.m_zoomBox.removeActionListener(this);
        this.first.removeActionListener((ActionListener)this);
        this.previous.removeActionListener(this);
        this.next.removeActionListener(this);
        this.last.removeActionListener((ActionListener)this);
        this.last.removeFocusListener((FocusListener)this);
        this.m_pdp = null;
        Object previous = null;
        Object next = null;
        Object first = null;
        Object last = null;
        Object m_zoomBox = null;
        Object pg = null;
        Object field = null;
        Object pagePanel = null;
        Object toolBar = null;
        Object pane = null;
        Object canvas = null;
        Object bImage = null;
        this.dvStrings = null;
    }

    private void init(Graphics pg) {
        if (this.printers[0].getViewPrinterType() <= 2) {
            int i;
            this.m_currentViewPrinter = 0;
            this.m_bViewPrinterGoToPrev = new boolean[this.printers.length];
            this.m_bViewPrinterGoToNext = new boolean[this.printers.length];
            for (i = 0; i < this.printers.length; ++i) {
                this.m_bViewPrinterGoToPrev[i] = true;
                this.m_bViewPrinterGoToNext[i] = true;
            }
            for (i = 0; i < this.printers.length; ++i) {
                this.printers[i].startPrint(true);
            }
            this.m_bDataInFirstPage = new boolean[this.printers.length];
            for (i = 0; i < this.printers.length; ++i) {
                this.m_bDataInFirstPage[i] = this.printers[i].prepareFirstPage(pg);
            }
            this.m_bDataInPages[0] = this.m_bDataInFirstPage[0];
            if (this.m_bDataInFirstPage[0]) {
                this.printers[0].renderPage(pg);
            }
        } else {
            this.printers[0].startPrint(true);
            this.printers[0].prepareFirstPage(pg);
            this.printers[0].renderPage(pg);
        }
    }

    private boolean prepareNextPage(Graphics pg) {
        boolean isDataPresent = false;
        if (this.printers[this.m_currentViewPrinter].isLastPhysicalPage()) {
            this.m_bViewPrinterGoToPrev[this.m_currentViewPrinter] = false;
            this.m_bViewPrinterGoToNext[this.m_currentViewPrinter] = true;
            int lastPageNum = this.printers[this.m_currentViewPrinter].getSequentialPageNumber();
            if (this.m_currentViewPrinter == this.printers.length - 1) {
                ++this.m_currentLogicalPage;
                this.m_currentViewPrinter = 0;
            } else {
                ++this.m_currentViewPrinter;
            }
            this.m_bViewPrinterGoToPrev[this.m_currentViewPrinter] = true;
            if (this.m_bViewPrinterGoToNext[this.m_currentViewPrinter]) {
                this.printers[this.m_currentViewPrinter].setSequentialPageNumber(lastPageNum);
                if (this.m_currentLogicalPage != 0L) {
                    isDataPresent = this.printers[this.m_currentViewPrinter].prepareNextPage(pg);
                } else if (this.printers[this.m_currentViewPrinter].hasPrevPage()) {
                    isDataPresent = this.printers[this.m_currentViewPrinter].prepareNextPage(pg);
                } else {
                    this.printers[this.m_currentViewPrinter].setSequentialPageNumber(lastPageNum + 1);
                    isDataPresent = this.m_bDataInFirstPage[this.m_currentViewPrinter];
                }
            } else {
                isDataPresent = this.m_bDataInPages[(int)(this.pageNum - 1L)];
            }
        } else {
            isDataPresent = this.printers[this.m_currentViewPrinter].prepareNextPage(pg);
        }
        return isDataPresent;
    }

    private boolean preparePrevPage(Graphics pg) {
        boolean isDataPresent = false;
        if (this.printers[this.m_currentViewPrinter].isFirstPhysicalPage()) {
            this.m_bViewPrinterGoToNext[this.m_currentViewPrinter] = false;
            this.m_bViewPrinterGoToPrev[this.m_currentViewPrinter] = true;
            int lastPageNum = this.printers[this.m_currentViewPrinter].getSequentialPageNumber();
            if (this.m_currentViewPrinter == 0) {
                --this.m_currentLogicalPage;
                this.m_currentViewPrinter = this.printers.length - 1;
            } else {
                --this.m_currentViewPrinter;
            }
            this.m_bViewPrinterGoToNext[this.m_currentViewPrinter] = true;
            if (this.m_bViewPrinterGoToPrev[this.m_currentViewPrinter]) {
                this.printers[this.m_currentViewPrinter].setSequentialPageNumber(lastPageNum);
                isDataPresent = this.printers[this.m_currentViewPrinter].preparePrevPage(pg);
            } else {
                isDataPresent = this.m_bDataInPages[(int)(this.pageNum - 1L)];
            }
        } else {
            isDataPresent = this.printers[this.m_currentViewPrinter].preparePrevPage(pg);
        }
        return isDataPresent;
    }

    private boolean hasNextPage() {
        if (this.printers[0].getViewPrinterType() > 2) {
            return this.printers[0].hasNextPage();
        }
        if (this.m_currentViewPrinter < this.printers.length - 1) {
            return true;
        }
        if (this.printers[this.m_currentViewPrinter].hasNextPage()) {
            return true;
        }
        return this.printers[0].hasNextPage();
    }

    private boolean hasPrevPage() {
        if (this.printers[0].getViewPrinterType() > 2) {
            return this.printers[0].hasPrevPage();
        }
        if (this.m_currentViewPrinter != 0) {
            return true;
        }
        if (this.printers[this.m_currentViewPrinter].hasPrevPage()) {
            return true;
        }
        return this.printers[this.printers.length - 1].hasPrevPage();
    }

    public void setImageScalingMode(int mode) {
        this.scalingMode = mode;
    }

    public int getImageScalingMode() {
        return this.scalingMode;
    }

    private String getIntlString(String key) {
        return this.getIntlString(key, this.dvStrings);
    }

    private String getIntlString(String key, ResourceBundle rBundle) {
        String strTemp;
        if (rBundle == null) {
            return key;
        }
        try {
            strTemp = rBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
        return strTemp;
    }

    private void scaleComponents() {
        Dimension dim = this.pane.getViewport().getExtentSize();
        float ratio_x = (float)(dim.width - 20) / (float)this.paperWidth;
        float ratio_y = (float)(dim.height - 20) / (float)this.paperHeight;
        float ratio = ratio_x < ratio_y ? ratio_x : ratio_y;
        this.scaledWidth = (int)((float)this.paperWidth * ratio);
        this.scaledHeight = (int)((float)this.paperHeight * ratio);
        int widthMargin = (dim.width - this.scaledWidth) / 2;
        int heightMargin = (dim.height - this.scaledHeight) / 2;
        this.pagePanel.setPreferredSize(new Dimension(this.scaledWidth + widthMargin * 2, this.scaledHeight + heightMargin * 2));
        this.canvas.setBounds(widthMargin, heightMargin, this.scaledWidth, this.scaledHeight);
        this.canvas.setSize(this.scaledWidth, this.scaledHeight);
        this.canvas.setImage(this.bImage.getScaledInstance(this.scaledWidth, this.scaledHeight, this.scalingMode));
    }

    private void updateResourceBundle(Locale loc) {
        try {
            this.dvStrings = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
        }
        catch (MissingResourceException e) {
            this.dvStrings = null;
        }
    }
}

