/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListCellRenderer;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.UIViewPrinter;
import oracle.dss.dataView.ViewPrinter;
import oracle.dss.dataView.gui.PaperSize;
import oracle.dss.util.ErrorHandler;

public class PageSetupGeneralPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected UIViewPrinter[] m_viewPrinter;
    protected PageFormat m_pageFormat;
    protected JPanel m_orientationPanel;
    protected JLabel m_orientationLabel;
    protected JLabel m_titleLabel;
    protected JLabel m_textLabel;
    protected JPanel m_paperSizePanel;
    protected JPanel m_mainPanel;
    protected JRadioButton m_potraitRadioButton;
    protected JLabel m_potraitLabel;
    protected JRadioButton m_landscapeRadioButton;
    protected JLabel m_landscapeLabel;
    protected JLabel m_pageSizeLabel;
    private boolean m_inD4O = false;
    private boolean m_D4OWksheetTitleVisible = false;
    private boolean m_D4OWksheetTextVisible = false;
    protected JLabel m_pageItemLabel;
    protected String m_papeSize = "";
    protected JPanel m_titlePanel;
    protected JPanel m_textPanel;
    protected JPanel m_pageItemsPanel;
    protected JRadioButton m_titleEveryPageButton;
    protected JRadioButton m_titleFirstPageButton;
    protected JRadioButton m_textEveryPageButton;
    protected JRadioButton m_textLastPageButton;
    protected JRadioButton m_pageCurrentButton;
    protected JRadioButton m_pageAllButton;
    protected int m_mask = -1;
    protected boolean m_bHelpEnabled;
    protected ErrorHandler m_eh = null;
    protected String m_strHelpContextID;
    protected boolean m_isWorkSheet = false;
    private boolean isVersionSupportOrientation = false;
    private ResourceBundle rBundle = null;
    private boolean m_bSuperCalled = false;
    public static final int SHOW_ORITATION = 1;
    public static final int SHOW_PAPER_SIZE = 8;
    private JComboBox m_paperSizeComboBox;
    private CellRenderer m_paperSizeCellRenderer;
    private PaperSize m_currentPaperSize;
    private NumberFormat m_numberFormat;
    private static final Object[] PaperSizes = new Object[]{PaperSize.LETTER, PaperSize.LEGAL, PaperSize.TABLOID, PaperSize.EXECUTIVE, PaperSize.BROADSHEET, PaperSize.A1, PaperSize.A2, PaperSize.A3, PaperSize.A4, PaperSize.A5, PaperSize.A6, PaperSize.B3, PaperSize.B4, PaperSize.B5, PaperSize.B6, PaperSize.C1, PaperSize.C2, PaperSize.C3, PaperSize.C4, PaperSize.C5, PaperSize.C6};

    public PageSetupGeneralPanel(ViewPrinter[] viewPrinter) {
        this((UIViewPrinter[])viewPrinter);
    }

    public PageSetupGeneralPanel(UIViewPrinter[] viewPrinter, boolean inD4O, boolean D4OWksheetTitleVisible, boolean D4OWksheetTextVisible) {
        this.m_inD4O = inD4O;
        this.m_D4OWksheetTitleVisible = D4OWksheetTitleVisible;
        this.m_D4OWksheetTextVisible = D4OWksheetTextVisible;
        this.m_bSuperCalled = true;
        if (viewPrinter == null) {
            return;
        }
        this.m_numberFormat = NumberFormat.getInstance(viewPrinter[0].getLocale());
        this.m_pageFormat = viewPrinter[0].getPageFormat() != null ? (PageFormat)viewPrinter[0].getPageFormat().clone() : new PageFormat();
        this.m_viewPrinter = viewPrinter;
        if (this.m_viewPrinter[0].getViewPrinterType() == 4 || this.m_viewPrinter[0].getViewPrinterType() == 3 || this.m_viewPrinter[0].getViewPrinterType() == 5 || this.m_viewPrinter[0].getViewPrinterType() == 6 || this.m_viewPrinter[0].getViewPrinterType() == 7) {
            this.m_isWorkSheet = true;
        }
        this.updateResourceBundle(this.m_viewPrinter[0].getLocale());
        this.setLayout(new BoxLayout(this, 1));
        this.m_mainPanel = new JPanel();
        this.m_mainPanel.setLayout(new BoxLayout(this.m_mainPanel, 1));
        this.m_mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(this.m_mainPanel);
        this._init();
    }

    public PageSetupGeneralPanel(UIViewPrinter[] viewPrinter) {
        this.m_bSuperCalled = true;
        if (viewPrinter == null) {
            return;
        }
        this.m_numberFormat = NumberFormat.getInstance(viewPrinter[0].getLocale());
        this.m_pageFormat = viewPrinter[0].getPageFormat() != null ? (PageFormat)viewPrinter[0].getPageFormat().clone() : new PageFormat();
        this.m_viewPrinter = viewPrinter;
        if (this.m_viewPrinter[0].getViewPrinterType() == 4 || this.m_viewPrinter[0].getViewPrinterType() == 3 || this.m_viewPrinter[0].getViewPrinterType() == 5 || this.m_viewPrinter[0].getViewPrinterType() == 6 || this.m_viewPrinter[0].getViewPrinterType() == 7) {
            this.m_isWorkSheet = true;
        }
        this.updateResourceBundle(this.m_viewPrinter[0].getLocale());
        this.setLayout(new BoxLayout(this, 1));
        this.m_mainPanel = new JPanel();
        this.m_mainPanel.setLayout(new BoxLayout(this.m_mainPanel, 1));
        this.m_mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(this.m_mainPanel);
        this._init();
    }

    public void cleanUp() {
        super.removeAll();
        this.removeAll();
        this.m_viewPrinter = null;
        this.m_pageFormat = null;
        this.m_numberFormat = null;
        this.m_currentPaperSize = null;
        this.m_paperSizeCellRenderer = null;
        this.m_paperSizeComboBox.removeActionListener(this);
        this.m_potraitRadioButton.removeActionListener(this);
        this.m_landscapeRadioButton.removeActionListener(this);
        this.m_orientationPanel.removeAll();
        this.m_orientationPanel = null;
        this.m_orientationLabel = null;
        this.m_titleLabel = null;
        this.m_textLabel = null;
        this.m_paperSizePanel.removeAll();
        this.m_paperSizePanel = null;
        this.m_mainPanel.removeAll();
        this.m_mainPanel = null;
        this.m_potraitRadioButton = null;
        this.m_potraitLabel = null;
        this.m_landscapeRadioButton = null;
        this.m_landscapeLabel = null;
        this.m_pageSizeLabel = null;
        this.m_pageItemLabel = null;
        this.m_papeSize = null;
        if (this.m_isWorkSheet) {
            this.m_titlePanel.removeAll();
            this.m_titlePanel = null;
            this.m_textPanel.removeAll();
            this.m_textPanel = null;
            if (!this.m_inD4O) {
                this.m_pageItemsPanel.removeAll();
            }
            this.m_pageItemsPanel = null;
        }
        this.m_titleEveryPageButton = null;
        this.m_titleFirstPageButton = null;
        this.m_textEveryPageButton = null;
        this.m_textLastPageButton = null;
        this.m_pageCurrentButton = null;
        this.m_pageAllButton = null;
        this.m_eh = null;
        this.m_strHelpContextID = null;
        this.rBundle = null;
    }

    private void _init() {
        this.m_mainPanel.removeAll();
        String translatedText = this.rBundle.getString("Paper Size");
        this.m_pageSizeLabel = new JLabel(StringUtils.stripMnemonic((String)translatedText));
        this.m_pageSizeLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_pageSizeLabel.setAlignmentX(0.0f);
        this.m_paperSizeComboBox = new JComboBox();
        this.setPaperSizeList();
        this.m_paperSizeComboBox.addActionListener(this);
        this.m_paperSizeCellRenderer = new CellRenderer();
        this.m_paperSizeComboBox.setRenderer(this.m_paperSizeCellRenderer);
        this.m_paperSizeComboBox.setMinimumSize(this.m_paperSizeComboBox.getPreferredSize());
        this.m_paperSizeComboBox.setMaximumSize(this.m_paperSizeComboBox.getPreferredSize());
        this.m_paperSizeComboBox.setToolTipText(this.rBundle.getString("Paper Size"));
        this.m_paperSizeComboBox.setAlignmentX(0.0f);
        this.m_pageSizeLabel.setLabelFor(this.m_paperSizeComboBox);
        int labelWidth = 0;
        if ((this.m_mask & 8) != 0) {
            labelWidth = this.getToolkit().getFontMetrics(this.m_pageSizeLabel.getFont()).stringWidth(this.m_pageSizeLabel.getText());
        }
        translatedText = this.rBundle.getString("Orientation");
        this.m_orientationLabel = new JLabel(translatedText);
        this.m_orientationLabel.setAlignmentX(0.0f);
        labelWidth = Math.max(labelWidth, this.getToolkit().getFontMetrics(this.m_orientationLabel.getFont()).stringWidth(this.m_orientationLabel.getText()));
        if (this.m_isWorkSheet) {
            translatedText = this.rBundle.getString("Title:");
            this.m_titleLabel = new JLabel(translatedText);
            this.m_titleLabel.setAlignmentX(0.0f);
            labelWidth = Math.max(labelWidth, this.getToolkit().getFontMetrics(this.m_titleLabel.getFont()).stringWidth(this.m_titleLabel.getText()));
            translatedText = this.rBundle.getString("Text:");
            this.m_textLabel = new JLabel(translatedText);
            this.m_textLabel.setAlignmentX(0.0f);
            labelWidth = Math.max(labelWidth, this.getToolkit().getFontMetrics(this.m_textLabel.getFont()).stringWidth(this.m_textLabel.getText()));
        }
        if (!this.m_inD4O) {
            translatedText = this.rBundle.getString("Page Items:");
            this.m_pageItemLabel = new JLabel(translatedText);
            this.m_pageItemLabel.setAlignmentX(0.0f);
            labelWidth = Math.max(labelWidth, this.getToolkit().getFontMetrics(this.m_pageItemLabel.getFont()).stringWidth(this.m_pageItemLabel.getText()));
        }
        this.m_paperSizePanel = new JPanel();
        this.m_paperSizePanel.setLayout(new BoxLayout(this.m_paperSizePanel, 0));
        this.m_paperSizePanel.setAlignmentX(0.0f);
        this.m_pageSizeLabel.setPreferredSize(new Dimension(labelWidth + 5, this.m_pageSizeLabel.getPreferredSize().height));
        this.m_pageSizeLabel.setMinimumSize(this.m_pageSizeLabel.getPreferredSize());
        this.m_pageSizeLabel.setMaximumSize(this.m_pageSizeLabel.getPreferredSize());
        this.m_paperSizePanel.add(this.m_pageSizeLabel);
        this.m_paperSizePanel.add(this.m_paperSizeComboBox);
        this.m_paperSizePanel.setMinimumSize(this.m_paperSizePanel.getPreferredSize());
        this.m_paperSizePanel.setMaximumSize(this.m_paperSizePanel.getPreferredSize());
        if ((this.m_mask & 8) != 0) {
            this.m_mainPanel.add(this.m_paperSizePanel);
            this.m_mainPanel.add(Box.createVerticalStrut(5));
        }
        this.m_orientationPanel = new JPanel();
        this.m_orientationPanel.setLayout(new BoxLayout(this.m_orientationPanel, 1));
        this.m_orientationPanel.setAlignmentX(0.0f);
        JPanel orientPanel = new JPanel();
        orientPanel.setLayout(new BoxLayout(orientPanel, 1));
        orientPanel.setAlignmentX(0.0f);
        orientPanel.add(this.m_orientationLabel);
        orientPanel.setPreferredSize(new Dimension(labelWidth + 5, orientPanel.getPreferredSize().height));
        orientPanel.setMinimumSize(orientPanel.getPreferredSize());
        orientPanel.setMaximumSize(orientPanel.getPreferredSize());
        JPanel portaitPanel = new JPanel();
        portaitPanel.setLayout(new BoxLayout(portaitPanel, 0));
        portaitPanel.setAlignmentX(0.0f);
        translatedText = this.rBundle.getString("Portrait");
        this.m_potraitRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_potraitRadioButton.addActionListener(this);
        this.m_potraitLabel = new JLabel();
        this.m_potraitRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_potraitRadioButton.setAlignmentX(0.0f);
        this.m_potraitLabel.setAlignmentX(0.0f);
        this.m_potraitLabel.setIcon(new ImageIcon(ImageUtils.getImageResource(PageSetupGeneralPanel.class, (String)"images/portrait.gif")));
        this.m_potraitRadioButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("PortraitADA"));
        portaitPanel.add(orientPanel);
        portaitPanel.add(this.m_potraitRadioButton);
        portaitPanel.add(this.m_potraitLabel);
        portaitPanel.setMinimumSize(portaitPanel.getPreferredSize());
        portaitPanel.setMaximumSize(portaitPanel.getPreferredSize());
        JPanel landscapePanel = new JPanel();
        landscapePanel.setAlignmentX(0.0f);
        landscapePanel.setLayout(new BoxLayout(landscapePanel, 0));
        translatedText = this.rBundle.getString("Landscape");
        this.m_landscapeRadioButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
        this.m_landscapeRadioButton.addActionListener(this);
        this.m_landscapeLabel = new JLabel();
        this.m_landscapeRadioButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.m_landscapeLabel.setAlignmentX(0.0f);
        this.m_landscapeLabel.setIcon(new ImageIcon(ImageUtils.getImageResource(PageSetupGeneralPanel.class, (String)"images/landscape.gif")));
        this.m_landscapeRadioButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("LandscapeADA"));
        landscapePanel.add(Box.createHorizontalStrut(labelWidth + 5));
        landscapePanel.add(this.m_landscapeRadioButton);
        landscapePanel.add(this.m_landscapeLabel);
        landscapePanel.setMinimumSize(landscapePanel.getPreferredSize());
        landscapePanel.setMaximumSize(landscapePanel.getPreferredSize());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_potraitRadioButton);
        buttonGroup.add(this.m_landscapeRadioButton);
        this.m_orientationPanel.add(portaitPanel);
        this.m_orientationPanel.add(landscapePanel);
        this.m_orientationPanel.add(Box.createVerticalStrut(5));
        if ((this.m_mask & 1) != 0) {
            this.m_mainPanel.add(this.m_orientationPanel);
        }
        if (this.m_isWorkSheet) {
            this.m_titlePanel = new JPanel();
            this.m_titlePanel.setLayout(new BoxLayout(this.m_titlePanel, 1));
            this.m_titlePanel.setAlignmentX(0.0f);
            JPanel titlePanel = new JPanel();
            titlePanel.setLayout(new BoxLayout(titlePanel, 1));
            titlePanel.setAlignmentX(0.0f);
            titlePanel.add(this.m_titleLabel);
            titlePanel.setPreferredSize(new Dimension(labelWidth + 5, titlePanel.getPreferredSize().height));
            titlePanel.setMinimumSize(titlePanel.getPreferredSize());
            titlePanel.setMaximumSize(titlePanel.getPreferredSize());
            JPanel tmpPanel = new JPanel();
            tmpPanel.setAlignmentX(0.0f);
            tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
            translatedText = this.rBundle.getString("TitleFirstPage");
            this.m_titleFirstPageButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
            this.m_titleFirstPageButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_titleFirstPageButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("TitleFirstPage"));
            tmpPanel.add(titlePanel);
            tmpPanel.add(this.m_titleFirstPageButton);
            tmpPanel.setMinimumSize(tmpPanel.getPreferredSize());
            tmpPanel.setMaximumSize(tmpPanel.getPreferredSize());
            this.m_titlePanel.add(tmpPanel);
            tmpPanel = new JPanel();
            tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
            tmpPanel.setAlignmentX(0.0f);
            translatedText = this.rBundle.getString("TitleEveryPage");
            this.m_titleEveryPageButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
            this.m_titleEveryPageButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_titleEveryPageButton.setAlignmentX(0.0f);
            this.m_titleEveryPageButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("TitleEveryPage"));
            tmpPanel.add(Box.createHorizontalStrut(labelWidth + 5));
            tmpPanel.add(this.m_titleEveryPageButton);
            tmpPanel.setMinimumSize(tmpPanel.getPreferredSize());
            tmpPanel.setMaximumSize(tmpPanel.getPreferredSize());
            this.m_titlePanel.add(tmpPanel);
            this.m_titlePanel.add(Box.createVerticalStrut(5));
            ButtonGroup group = new ButtonGroup();
            group.add(this.m_titleEveryPageButton);
            group.add(this.m_titleFirstPageButton);
            this.m_mainPanel.add(this.m_titlePanel);
            this.m_textPanel = new JPanel();
            this.m_textPanel.setLayout(new BoxLayout(this.m_textPanel, 1));
            this.m_textPanel.setAlignmentX(0.0f);
            JPanel textPanel = new JPanel();
            textPanel.setLayout(new BoxLayout(textPanel, 1));
            textPanel.setAlignmentX(0.0f);
            textPanel.add(this.m_textLabel);
            textPanel.setPreferredSize(new Dimension(labelWidth + 5, textPanel.getPreferredSize().height));
            textPanel.setMinimumSize(textPanel.getPreferredSize());
            textPanel.setMaximumSize(textPanel.getPreferredSize());
            tmpPanel = new JPanel();
            tmpPanel.setAlignmentX(0.0f);
            tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
            translatedText = this.rBundle.getString("TextLastPage");
            this.m_textLastPageButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
            this.m_textLastPageButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_textLastPageButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("TextLastPage"));
            tmpPanel.add(textPanel);
            tmpPanel.add(this.m_textLastPageButton);
            tmpPanel.setMinimumSize(tmpPanel.getPreferredSize());
            tmpPanel.setMaximumSize(tmpPanel.getPreferredSize());
            this.m_textPanel.add(tmpPanel);
            tmpPanel = new JPanel();
            tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
            tmpPanel.setAlignmentX(0.0f);
            translatedText = this.rBundle.getString("TextEveryPage");
            this.m_textEveryPageButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
            this.m_textEveryPageButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
            this.m_textEveryPageButton.setAlignmentX(0.0f);
            this.m_textEveryPageButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("TextEveryPage"));
            tmpPanel.add(Box.createHorizontalStrut(labelWidth + 5));
            tmpPanel.add(this.m_textEveryPageButton);
            tmpPanel.setMinimumSize(tmpPanel.getPreferredSize());
            tmpPanel.setMaximumSize(tmpPanel.getPreferredSize());
            this.m_textPanel.add(tmpPanel);
            ButtonGroup group1 = new ButtonGroup();
            group1.add(this.m_textEveryPageButton);
            group1.add(this.m_textLastPageButton);
            this.m_textPanel.add(Box.createVerticalStrut(5));
            this.m_mainPanel.add(this.m_textPanel);
            if (!this.m_inD4O) {
                this.m_pageItemsPanel = new JPanel();
                this.m_pageItemsPanel.setLayout(new BoxLayout(this.m_pageItemsPanel, 1));
                this.m_pageItemsPanel.setAlignmentX(0.0f);
                JPanel pageItemsPanel = new JPanel();
                pageItemsPanel.setLayout(new BoxLayout(pageItemsPanel, 1));
                pageItemsPanel.setAlignmentX(0.0f);
                pageItemsPanel.add(this.m_pageItemLabel);
                pageItemsPanel.setPreferredSize(new Dimension(labelWidth + 5, pageItemsPanel.getPreferredSize().height));
                pageItemsPanel.setMinimumSize(pageItemsPanel.getPreferredSize());
                pageItemsPanel.setMaximumSize(pageItemsPanel.getPreferredSize());
                tmpPanel = new JPanel();
                tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
                tmpPanel.setAlignmentX(0.0f);
                translatedText = this.rBundle.getString("PageItemsCurrent");
                this.m_pageCurrentButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
                this.m_pageCurrentButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
                this.m_pageCurrentButton.setAlignmentX(0.0f);
                this.m_pageCurrentButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("PageItemsCurrent"));
                tmpPanel.add(pageItemsPanel);
                tmpPanel.add(this.m_pageCurrentButton);
                tmpPanel.setMinimumSize(tmpPanel.getPreferredSize());
                tmpPanel.setMaximumSize(tmpPanel.getPreferredSize());
                this.m_pageItemsPanel.add(tmpPanel);
                tmpPanel = new JPanel();
                tmpPanel.setAlignmentX(0.0f);
                tmpPanel.setLayout(new BoxLayout(tmpPanel, 0));
                translatedText = this.rBundle.getString("PageItemsAll");
                this.m_pageAllButton = new JRadioButton(StringUtils.stripMnemonic((String)translatedText));
                this.m_pageAllButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
                this.m_pageAllButton.getAccessibleContext().setAccessibleName(this.rBundle.getString("PageItemsAll"));
                tmpPanel.add(Box.createHorizontalStrut(labelWidth + 5));
                tmpPanel.add(this.m_pageAllButton);
                tmpPanel.setMinimumSize(tmpPanel.getPreferredSize());
                tmpPanel.setMaximumSize(tmpPanel.getPreferredSize());
                ButtonGroup group2 = new ButtonGroup();
                group2.add(this.m_pageCurrentButton);
                group2.add(this.m_pageAllButton);
                this.m_pageItemsPanel.add(tmpPanel);
                this.m_pageItemsPanel.add(Box.createVerticalStrut(5));
                this.m_mainPanel.add(this.m_pageItemsPanel);
            }
        }
        if (this.m_inD4O) {
            if (this.m_D4OWksheetTitleVisible) {
                this.m_titleEveryPageButton.setEnabled(true);
                this.m_titleFirstPageButton.setEnabled(true);
            } else {
                this.m_titleEveryPageButton.setEnabled(false);
                this.m_titleFirstPageButton.setEnabled(false);
            }
            if (this.m_D4OWksheetTextVisible) {
                this.m_textEveryPageButton.setEnabled(true);
                this.m_textLastPageButton.setEnabled(true);
            } else {
                this.m_textEveryPageButton.setEnabled(false);
                this.m_textLastPageButton.setEnabled(false);
            }
        }
        this.setAlignmentX(0.0f);
        this.m_mainPanel.setAlignmentX(0.0f);
        this.m_mainPanel.setMaximumSize(this.m_mainPanel.getPreferredSize());
        this.m_mainPanel.setMinimumSize(this.m_mainPanel.getPreferredSize());
        this._initiate();
    }

    private void _initiate() {
        if (this.m_pageFormat.getOrientation() == 1) {
            this.m_potraitRadioButton.setSelected(true);
        } else {
            this.m_landscapeRadioButton.setSelected(true);
        }
        this.setSelectedPaperSize();
        if (this.m_isWorkSheet && this.m_viewPrinter != null) {
            this.m_titleEveryPageButton.setSelected(this.m_viewPrinter[0].isRepeatComponent(64));
            this.m_titleFirstPageButton.setSelected(!this.m_titleEveryPageButton.isSelected());
            this.m_textEveryPageButton.setSelected(this.m_viewPrinter[0].isRepeatComponent(128));
            this.m_textLastPageButton.setSelected(!this.m_textEveryPageButton.isSelected());
            if (!this.m_inD4O) {
                if (this.m_viewPrinter[0].getRangeType() == 1) {
                    this.m_pageAllButton.setSelected(true);
                } else {
                    this.m_pageCurrentButton.setSelected(true);
                }
            }
        }
    }

    public void setUIComponentMask(int mask) {
        this.m_mask = mask;
        this._init();
    }

    public int getUIComponentMask() {
        return this.m_mask;
    }

    public void apply() {
        for (int i = 0; i < this.m_viewPrinter.length; ++i) {
            this.m_viewPrinter[i].setPageFormat(this.m_pageFormat);
            if (!this.m_isWorkSheet) continue;
            this.m_viewPrinter[i].setRepeatComponent(64, this.m_titleEveryPageButton.isSelected());
            this.m_viewPrinter[i].setRepeatComponent(128, this.m_textEveryPageButton.isSelected());
            if (this.m_inD4O) continue;
            if (this.m_pageAllButton.isSelected()) {
                this.m_viewPrinter[i].setRangeType(1);
                continue;
            }
            this.m_viewPrinter[i].setRangeType(0);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return super.getPreferredSize();
    }

    public void setViewPrinter(ViewPrinter[] viewPrinter) {
        if (viewPrinter != null) {
            this.m_viewPrinter = viewPrinter;
        }
        this._init();
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(loc);
        this._init();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_paperSizeComboBox) {
            if (this.m_paperSizeComboBox.getSelectedItem() != null) {
                this.m_currentPaperSize = (PaperSize)this.m_paperSizeComboBox.getSelectedItem();
                this.setPaperSize();
            }
        } else if (e.getSource() == this.m_landscapeRadioButton) {
            if (this.m_landscapeRadioButton.isSelected()) {
                this.m_paperSizeComboBox.removeAllItems();
                this.setPaperSizeList();
                this.m_pageFormat.setOrientation(0);
                this.m_paperSizeComboBox.setSelectedItem(this.m_currentPaperSize);
            }
        } else if (e.getSource() == this.m_potraitRadioButton && this.m_potraitRadioButton.isSelected()) {
            this.m_paperSizeComboBox.removeAllItems();
            this.setPaperSizeList();
            this.m_pageFormat.setOrientation(1);
            this.m_paperSizeComboBox.setSelectedItem(this.m_currentPaperSize);
        }
    }

    private void setPaperSizeList() {
        this.m_paperSizeComboBox.setModel(new DefaultComboBoxModel<Object>(PaperSizes));
    }

    private void setPaperSize() {
        float topMargin = this.m_viewPrinter[0].getTopMargin();
        float leftMargin = this.m_viewPrinter[0].getLeftMargin();
        float bottomMargin = this.m_viewPrinter[0].getBottomMargin();
        float rightMargin = this.m_viewPrinter[0].getRightMargin();
        if (this.m_paperSizeComboBox.getSelectedItem() != null) {
            PaperSize selectedPaperSize = (PaperSize)this.m_paperSizeComboBox.getSelectedItem();
            float width = selectedPaperSize.getWidth(2);
            float height = selectedPaperSize.getHeight(2);
            Paper paper = new Paper();
            paper.setSize(width, height);
            paper.setImageableArea(topMargin, leftMargin, width - (leftMargin + rightMargin), height - (topMargin + bottomMargin));
            this.m_pageFormat.setPaper(paper);
        }
    }

    private void setSelectedPaperSize() {
        float pageWidth = (float)this.m_pageFormat.getPaper().getWidth();
        float pageHeight = (float)this.m_pageFormat.getPaper().getHeight();
        PaperSize paperSize = PaperSize.parse(pageWidth, pageHeight);
        this.m_paperSizeComboBox.setSelectedItem(paperSize);
    }

    private String getSizeString(int sizeID, String sizeText) {
        String sizeString = sizeText;
        PaperSize paperSize = PaperSize.parse(sizeID);
        float width = (float)Math.round(paperSize.getWidth(1) * 10.0f) / 10.0f;
        float height = (float)Math.round(paperSize.getHeight(1) * 10.0f) / 10.0f;
        String widthString = this.m_numberFormat.format(width);
        String heightString = this.m_numberFormat.format(height);
        sizeString = this.m_pageFormat.getOrientation() == 0 ? sizeString + " (" + heightString + " x " + widthString + ")" : sizeString + " (" + widthString + " x " + heightString + ")";
        return sizeString;
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    class CellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;

        public CellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String sizeText = null;
            String sizeString = null;
            if (value != null) {
                if (value.equals(PaperSize.LETTER)) {
                    sizeText = "Letter";
                    sizeString = PageSetupGeneralPanel.this.getSizeString(10, sizeText);
                } else if (value.equals(PaperSize.LEGAL)) {
                    sizeText = "Legal";
                    sizeString = PageSetupGeneralPanel.this.getSizeString(11, sizeText);
                } else if (value.equals(PaperSize.TABLOID)) {
                    sizeText = "Tabloid";
                    sizeString = PageSetupGeneralPanel.this.getSizeString(12, sizeText);
                } else if (value.equals(PaperSize.EXECUTIVE)) {
                    sizeText = "Executive";
                    sizeString = PageSetupGeneralPanel.this.getSizeString(13, sizeText);
                } else if (value.equals(PaperSize.BROADSHEET)) {
                    sizeText = "Broadsheet";
                    sizeString = PageSetupGeneralPanel.this.getSizeString(14, sizeText);
                } else if (value.equals(PaperSize.A1)) {
                    sizeText = "A1";
                    sizeString = PageSetupGeneralPanel.this.getSizeString(15, sizeText);
                } else if (value.equals(PaperSize.A2)) {
                    sizeText = "A2";
                    sizeString = PageSetupGeneralPanel.this.getSizeString(16, sizeText);
                } else if (value.equals(PaperSize.A3)) {
                    sizeText = "A3";
                    sizeString = PageSetupGeneralPanel.this.getSizeString(17, sizeText);
                } else if (value.equals(PaperSize.A4)) {
                    sizeText = "A4";
                    sizeString = PageSetupGeneralPanel.this.getSizeString(18, sizeText);
                } else if (value.equals(PaperSize.A5)) {
                    sizeText = "A5";
                    sizeString = PageSetupGeneralPanel.this.getSizeString(19, sizeText);
                } else if (value.equals(PaperSize.A6)) {
                    sizeText = "A6";
                    sizeString = PageSetupGeneralPanel.this.getSizeString(20, sizeText);
                } else if (value.equals(PaperSize.B3)) {
                    sizeText = "B3";
                    sizeString = PageSetupGeneralPanel.this.getSizeString(21, sizeText);
                } else if (value.equals(PaperSize.B4)) {
                    sizeText = "B4";
                    sizeString = PageSetupGeneralPanel.this.getSizeString(22, sizeText);
                } else if (value.equals(PaperSize.B5)) {
                    sizeText = "B5";
                    sizeString = PageSetupGeneralPanel.this.getSizeString(23, sizeText);
                } else if (value.equals(PaperSize.B6)) {
                    sizeText = "B6";
                    sizeString = PageSetupGeneralPanel.this.getSizeString(24, sizeText);
                } else if (value.equals(PaperSize.C1)) {
                    sizeText = "C1";
                    sizeString = PageSetupGeneralPanel.this.getSizeString(25, sizeText);
                } else if (value.equals(PaperSize.C2)) {
                    sizeText = "C2";
                    sizeString = PageSetupGeneralPanel.this.getSizeString(26, sizeText);
                } else if (value.equals(PaperSize.C3)) {
                    sizeText = "C3";
                    sizeString = PageSetupGeneralPanel.this.getSizeString(27, sizeText);
                } else if (value.equals(PaperSize.C4)) {
                    sizeText = "C4";
                    sizeString = PageSetupGeneralPanel.this.getSizeString(28, sizeText);
                } else if (value.equals(PaperSize.C5)) {
                    sizeText = "C5";
                    sizeString = PageSetupGeneralPanel.this.getSizeString(29, sizeText);
                } else if (value.equals(PaperSize.C6)) {
                    sizeText = "C6";
                    sizeString = PageSetupGeneralPanel.this.getSizeString(30, sizeText);
                }
            }
            this.setText(sizeString);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.getAccessibleContext().setAccessibleName(sizeString);
            return this;
        }
    }
}

