/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.ewt.statusBar.StatusBar;
import oracle.dss.dataView.ColumnComponentHandle;
import oracle.dss.dataView.ColumnRangeComponentHandle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerEvent;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.DataRangeComponentHandle;
import oracle.dss.dataView.GraphAttribute;
import oracle.dss.dataView.GridViewAttribute;
import oracle.dss.dataView.NonDataComponentHandle;
import oracle.dss.dataView.RowComponentHandle;
import oracle.dss.dataView.RowRangeComponentHandle;
import oracle.dss.dataView.UIView;
import oracle.dss.dataView.gui.DataviewTool;
import oracle.dss.dataView.gui.DataviewToolbarRollover;
import oracle.dss.dataView.gui.ToolBar;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.util.ColumnComponentInfo;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.RowComponentInfo;
import oracle.dss.util.gui.ShortcutIcon;

public class NumberTypeTool
extends JToggleButton
implements DataviewToolbarRollover,
DataviewTool,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_NUMBER_TYPE = "NumberType";
    protected Object m_selectedObject = null;
    protected ComponentHandle m_selectedComponentHandle = null;
    protected UIView m_currentDataview = null;
    protected ToolBar m_toolBar = null;
    private static final Insets insets0 = new Insets(0, 0, 0, 0);
    protected JToggleButton m_currency = null;
    protected JToggleButton m_number = null;
    protected JToggleButton m_percent = null;
    protected boolean m_bRolloverIconEnabled = false;
    private ResourceBundle rBundle = null;
    private boolean m_enable = true;
    private MouseListener m_mouseListener;
    private boolean m_bSuperCalled = true;
    private NumberTypePopup popup;
    private int m_numberType;
    private JToggleButton[] typeButtons = new JToggleButton[3];

    public NumberTypeTool() {
        this.setIcon(this.getArrowIcon(this.makeImage("images/NumberFormat_18t.gif")));
        this.setDisabledIcon((Icon)new ShortcutIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())), this.makeImage("images/arrow_disabled.gif")));
        this.addActionListener(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (NumberTypeTool.this.isEnabled()) {
                    NumberTypeTool.this.setBorderPainted(!NumberTypeTool.this.isBorderPainted());
                    NumberTypeTool.this.setDropDownVisible(!NumberTypeTool.this.isDropDownVisible());
                    NumberTypeTool.this.requestFocus();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                NumberTypeTool.this.setSelected(NumberTypeTool.this.isDropDownVisible());
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                NumberTypeTool.this.internalKeyPressed(e);
            }
        });
        this.setModel(new Model());
        this.updateResourceBundle(Locale.getDefault());
        this.setToolTipText(this.rBundle.getString("Number"));
        this.setEnabled(false);
        this.setBorderPainted(false);
        this.m_currency = new JToggleButton(this.makeImage("images/CurrencyFormat_18t.gif"));
        this.m_currency.setMargin(insets0);
        this.m_currency.addActionListener(this);
        this.m_number = new JToggleButton(this.makeImage("images/NumberFormat_18t.gif"));
        this.m_number.setMargin(insets0);
        this.m_number.addActionListener(this);
        this.m_percent = new JToggleButton(this.makeImage("images/PercentFormat_18t.gif"));
        this.m_percent.setMargin(insets0);
        this.m_percent.addActionListener(this);
        this.m_currency.setToolTipText(this.rBundle.getString("Currency"));
        this.m_number.setToolTipText(this.rBundle.getString("Number"));
        this.m_percent.setToolTipText(this.rBundle.getString("Percent"));
        this.typeButtons[0] = this.m_number;
        this.typeButtons[1] = this.m_currency;
        this.typeButtons[2] = this.m_percent;
        this.m_number.setBorderPainted(false);
        this.m_currency.setBorderPainted(false);
        this.m_percent.setBorderPainted(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_number);
        buttonGroup.add(this.m_currency);
        buttonGroup.add(this.m_percent);
        if (!(UIManager.getLookAndFeel() instanceof OracleLookAndFeel)) {
            this.m_mouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    if (!NumberTypeTool.this.isRolloverIconEnabled()) {
                        ((JToggleButton)e.getSource()).setBorderPainted(true);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    if (!NumberTypeTool.this.isRolloverIconEnabled()) {
                        ((JToggleButton)e.getSource()).setBorderPainted(((JToggleButton)e.getSource()).isSelected());
                    }
                }
            };
            this.m_number.setPreferredSize(new Dimension(24, 24));
            this.m_number.setMinimumSize(this.m_number.getPreferredSize());
            this.m_number.setMaximumSize(this.m_number.getPreferredSize());
            this.m_number.addMouseListener(this.m_mouseListener);
            this.m_currency.setPreferredSize(new Dimension(24, 24));
            this.m_currency.setMinimumSize(this.m_currency.getPreferredSize());
            this.m_currency.setMaximumSize(this.m_currency.getPreferredSize());
            this.m_currency.addMouseListener(this.m_mouseListener);
            this.m_percent.setPreferredSize(new Dimension(24, 24));
            this.m_percent.setMinimumSize(this.m_percent.getPreferredSize());
            this.m_percent.setMaximumSize(this.m_percent.getPreferredSize());
            this.m_percent.addMouseListener(this.m_mouseListener);
        }
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 9) {
            if (this.isDropDownVisible()) {
                e.consume();
            } else {
                super.processKeyEvent(e);
            }
        } else {
            super.processKeyEvent(e);
        }
    }

    @Override
    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(loc);
        this.m_currency.setToolTipText(this.rBundle.getString("Currency"));
        this.m_number.setToolTipText(this.rBundle.getString("Number"));
        this.m_percent.setToolTipText(this.rBundle.getString("Percent"));
    }

    @Override
    public void selectedAction(ControllerEvent e, UIView currentDataView, ToolBar toolBar) {
        if (currentDataView == null) {
            return;
        }
        this.m_currentDataview = currentDataView;
        this.m_toolBar = toolBar;
        if (e == null) {
            return;
        }
        if (e.getComponentHandle() == null) {
            this.m_selectedObject = null;
            this.m_selectedComponentHandle = null;
            this.setEnabled(false);
            return;
        }
        Object selectedObject = e.getComponentHandle().getComponent();
        this.m_enable = false;
        if (this.isEnabled(e.getComponentHandle())) {
            this.m_selectedObject = selectedObject;
            this.m_selectedComponentHandle = e.getComponentHandle();
            this.setEnabled(true);
            int numberType = this.getNumberType();
            if (numberType == 1) {
                this.m_currency.setSelected(true);
                this.setIcon(this.getArrowIcon(this.m_currency.getIcon()));
                this.setToolTipText(this.rBundle.getString("Currency"));
            } else if (numberType == 2) {
                this.m_percent.setSelected(true);
                this.setIcon(this.getArrowIcon(this.m_percent.getIcon()));
                this.setToolTipText(this.rBundle.getString("Percent"));
            } else {
                this.m_number.setSelected(true);
                this.setIcon(this.getArrowIcon(this.m_number.getIcon()));
                this.setToolTipText(this.rBundle.getString("Number"));
            }
            this.m_numberType = numberType;
            this.m_currency.setBorderPainted(this.m_currency.isSelected());
            this.m_number.setBorderPainted(this.m_number.isSelected());
            this.m_percent.setBorderPainted(this.m_percent.isSelected());
            this.setDisabledIcon((Icon)new ShortcutIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())), this.makeImage("images/arrow_disabled.gif")));
        } else {
            this.setEnabled(false);
            this.m_selectedObject = null;
        }
        this.m_enable = true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e == null) {
            return;
        }
        if (e.getSource() == this.m_currency) {
            this.setNumberType(1);
            this.setToolTipText(this.rBundle.getString("Currency"));
        } else if (e.getSource() == this.m_number) {
            this.setNumberType(0);
            this.setToolTipText(this.rBundle.getString("Number"));
        } else if (e.getSource() == this.m_percent) {
            this.setNumberType(2);
            this.setToolTipText(this.rBundle.getString("Percent"));
        }
        this.setIcon(this.getArrowIcon((ImageIcon)((JToggleButton)e.getSource()).getIcon()));
        this.setDisabledIcon((Icon)new ShortcutIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())), this.makeImage("images/arrow_disabled.gif")));
        this.setDropDownVisible(false);
        this.setSelected(false);
        this.setBorderPainted(false);
        this.m_currency.setBorderPainted(this.m_currency.isSelected());
        this.m_number.setBorderPainted(this.m_number.isSelected());
        this.m_percent.setBorderPainted(this.m_percent.isSelected());
    }

    @Override
    public void setRolloverIconEnabled(boolean bEnabled) {
        this.m_bRolloverIconEnabled = bEnabled;
    }

    @Override
    public boolean isRolloverIconEnabled() {
        return this.m_bRolloverIconEnabled;
    }

    @Override
    public void update() {
    }

    private ImageIcon makeImage(String fileName) {
        return new ImageIcon(ImageUtils.getImageResource(NumberTypeTool.class, (String)fileName));
    }

    private void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
    }

    @Override
    public void cleanUp() {
        this.removeMouseListener(this.m_mouseListener);
        this.removeActionListener(this);
        if (this.popup != null) {
            this.popup.cleanUp();
        }
    }

    private boolean isEnabled(ComponentHandle selectedComponentHandle) {
        block15: {
            if (this.m_currentDataview instanceof GridViewAttribute && ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewFormat(selectedComponentHandle) != null) {
                DataAccess dataAccess = this.m_currentDataview.getModel().getDataAccess();
                if (dataAccess == null) {
                    return false;
                }
                try {
                    if (selectedComponentHandle instanceof DataComponentHandle) {
                        int column;
                        int row = ((DataComponentHandle)selectedComponentHandle).getRow();
                        return dataAccess.getValue(row, column = ((DataComponentHandle)selectedComponentHandle).getColumn(), "dataValue") instanceof Number;
                    }
                    if (selectedComponentHandle instanceof DataRangeComponentHandle) {
                        DataComponentInfo[] ci = ((DataRangeComponentHandle)selectedComponentHandle).getLocationList();
                        for (int i = 0; i < ci.length; ++i) {
                            int column;
                            int row = ci[i].getRow();
                            if (!(dataAccess.getValue(row, column = ci[i].getColumn(), "dataValue") instanceof Number)) continue;
                            return true;
                        }
                        return false;
                    }
                    if (selectedComponentHandle instanceof RowComponentHandle) {
                        int row = ((RowComponentHandle)selectedComponentHandle).getRow();
                        return dataAccess.getValue(row, 0, "dataValue") instanceof Number;
                    }
                    if (selectedComponentHandle instanceof RowRangeComponentHandle) {
                        RowComponentInfo[] ci = ((RowRangeComponentHandle)selectedComponentHandle).getLocationList();
                        for (int i = 0; i < ci.length; ++i) {
                            int row = ci[i].getRow();
                            if (!(dataAccess.getValue(row, 0, "dataValue") instanceof Number)) continue;
                            return true;
                        }
                        return false;
                    }
                    if (selectedComponentHandle instanceof ColumnComponentHandle) {
                        int column = ((ColumnComponentHandle)selectedComponentHandle).getColumn();
                        return dataAccess.getValue(0, column, "dataValue") instanceof Number;
                    }
                    if (selectedComponentHandle instanceof ColumnRangeComponentHandle) {
                        ColumnComponentInfo[] ci = ((ColumnRangeComponentHandle)selectedComponentHandle).getLocationList();
                        for (int i = 0; i < ci.length; ++i) {
                            int column = ci[i].getColumn();
                            if (!(dataAccess.getValue(0, column, "dataValue") instanceof Number)) continue;
                            return true;
                        }
                        return false;
                    }
                    if (selectedComponentHandle instanceof NonDataComponentHandle && selectedComponentHandle.getID() == 13) {
                        return true;
                    }
                    break block15;
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (this.m_currentDataview instanceof GraphAttribute && ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewFormat(selectedComponentHandle) != null) {
                return true;
            }
        }
        return false;
    }

    private int getNumberType() {
        if (this.m_currentDataview instanceof GridViewAttribute) {
            ViewFormat viewFormat = ((GridViewAttribute)((Object)this.m_currentDataview)).getComponentViewFormat(this.m_selectedComponentHandle);
            return viewFormat.getNumberType();
        }
        if (this.m_currentDataview instanceof GraphAttribute) {
            ViewFormat viewFormat = ((GraphAttribute)((Object)this.m_currentDataview)).getComponentViewFormat(this.m_selectedComponentHandle);
            return viewFormat.getNumberType();
        }
        return -1;
    }

    private void setNumberType(int numberType) {
        if (this.m_currentDataview instanceof GridViewAttribute || this.m_currentDataview instanceof GraphAttribute) {
            ViewFormat viewFormat = new ViewFormat();
            viewFormat.setNumberType(numberType);
            viewFormat.setLocale(this.m_currentDataview.getLocale());
            if (numberType == 1) {
                viewFormat.setDecimalDigit(2);
                viewFormat.setThousandSeparatorUsed(true);
                viewFormat.setCurrencySymbolUsed(true);
            } else if (numberType == 0) {
                viewFormat.setDecimalDigit(0);
                viewFormat.setThousandSeparatorUsed(true);
            } else if (numberType == 2) {
                viewFormat.setDecimalDigit(0);
                viewFormat.setThousandSeparatorUsed(true);
                viewFormat.setScaleFactor(0);
            }
            if (this.m_currentDataview instanceof GridViewAttribute) {
                ((GridViewAttribute)((Object)this.m_currentDataview)).applyViewFormat(this.m_selectedComponentHandle, viewFormat);
                if (!this.m_toolBar.hideAlertInFuture() && !((GridViewAttribute)((Object)this.m_currentDataview)).compareComponentViewFormat(this.m_selectedComponentHandle, viewFormat)) {
                    this.m_toolBar.displayFormatAlert();
                }
            } else if (this.m_currentDataview instanceof GraphAttribute) {
                ((GraphAttribute)((Object)this.m_currentDataview)).applyViewFormat(this.m_selectedComponentHandle, viewFormat);
            }
            this.firePropertyChange(PROPERTY_NUMBER_TYPE, this.m_numberType, numberType);
            this.m_numberType = numberType;
        }
    }

    private void internalKeyPressed(KeyEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        boolean consume = false;
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 37: 
            case 38: {
                if (!this.isDropDownVisible()) break;
                for (int i = 0; i < this.typeButtons.length; ++i) {
                    if (!this.typeButtons[i].isSelected()) continue;
                    this.typeButtons[i].setBorderPainted(false);
                    this.typeButtons[i].setSelected(false);
                    if (--i < 0) {
                        i = this.typeButtons.length - 1;
                    }
                    this.typeButtons[i].setBorderPainted(true);
                    this.typeButtons[i].setSelected(true);
                    this.popup.sendAccessibleEvent(((ImageIcon)this.typeButtons[i].getIcon()).getDescription());
                    break;
                }
                consume = true;
                break;
            }
            case 39: 
            case 40: {
                if (!this.isDropDownVisible()) break;
                for (int i = 0; i < this.typeButtons.length; ++i) {
                    if (!this.typeButtons[i].isSelected()) continue;
                    this.typeButtons[i].setBorderPainted(false);
                    this.typeButtons[i].setSelected(false);
                    if (++i == this.typeButtons.length) {
                        i = 0;
                    }
                    this.typeButtons[i].setBorderPainted(true);
                    this.typeButtons[i].setSelected(true);
                    this.popup.sendAccessibleEvent(((ImageIcon)this.typeButtons[i].getIcon()).getDescription());
                    break;
                }
                consume = true;
                break;
            }
            case 10: {
                if (!this.isDropDownVisible()) break;
                this.doEnter();
                this.setDropDownVisible(false);
                this.setSelected(false);
                this.repaint();
                consume = true;
                break;
            }
            case 27: {
                if (!this.isDropDownVisible()) break;
                this.setDropDownVisible(false);
                this.setSelected(false);
                this.repaint();
                break;
            }
            case 32: {
                if (!this.isDropDownVisible()) {
                    this.setDropDownVisible(true);
                    this.setBorderPainted(true);
                    break;
                }
                this.setDropDownVisible(false);
                this.setSelected(false);
                this.repaint();
                break;
            }
        }
        if (consume) {
            e.consume();
        }
    }

    private void doEnter() {
        if (this.m_currentDataview == null) {
            return;
        }
        for (int i = 0; i < this.typeButtons.length; ++i) {
            if (!this.typeButtons[i].isSelected()) continue;
            if (i == 0) {
                this.setNumberType(0);
            } else if (i == 1) {
                this.setNumberType(1);
            } else {
                this.setNumberType(2);
            }
            this.setIcon(this.getArrowIcon(this.typeButtons[i].getIcon()));
            this.setDisabledIcon((Icon)new ShortcutIcon(new ImageIcon(ImageUtils.createDisabledImage((Image)((ImageIcon)this.getIcon()).getImage())), this.makeImage("images/arrow_disabled.gif")));
            this.setDropDownVisible(false);
            this.setBorderPainted(false);
            this.requestFocus();
            return;
        }
    }

    private ImageIcon getArrowIcon(Icon icon) {
        if (icon != null) {
            return new ShortcutIcon((ImageIcon)icon, this.makeImage("images/arrow.gif"));
        }
        return null;
    }

    private boolean isDropDownVisible() {
        return this.popup == null ? false : this.popup.isVisible();
    }

    private void setDropDownVisible(boolean visible) {
        if (this.popup == null) {
            this.popup = new NumberTypePopup();
            this.popup.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    NumberTypeTool.this.internalKeyPressed(e);
                }
            });
            this.popup.setBackground(this.getBackground());
        }
        if (visible) {
            this.popup.show(this, 0, this.getHeight());
            this.popup.requestFocus();
        } else {
            this.popup.setVisible(false);
            this.popup = null;
            this.requestFocus();
        }
        this.repaint();
    }

    class NumberTypePopup
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;
        private JToolBar toolbar;
        private JLabel _statusBarLabel;
        private StatusBar _statusBar;

        public NumberTypePopup() {
            this.setLayout(new BoxLayout(this, 1));
            this.toolbar = new JToolBar();
            for (int i = 0; i < NumberTypeTool.this.typeButtons.length; ++i) {
                this.toolbar.add(NumberTypeTool.this.typeButtons[i]);
                if (!NumberTypeTool.this.typeButtons[i].isSelected()) {
                    NumberTypeTool.this.typeButtons[i].setBorderPainted(false);
                    continue;
                }
                NumberTypeTool.this.typeButtons[i].setBorderPainted(true);
            }
            this._statusBar = new StatusBar();
            this._statusBarLabel = new JLabel(){
                private static final long serialVersionUID = 1L;

                @Override
                public void setText(String text) {
                    String oldName = this.getText();
                    super.setText(text);
                    if (this.accessibleContext != null) {
                        this.accessibleContext.firePropertyChange("AccessibleName", oldName, text);
                    }
                }
            };
            this._statusBar.add((Component)this._statusBarLabel);
            this._statusBar.setVisible(false);
            this.add((Component)this._statusBar);
            this.toolbar.setOrientation(1);
            this.toolbar.setBorderPainted(false);
            if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
                this.toolbar.setBorder(null);
            }
            this.add(this.toolbar);
        }

        public void sendAccessibleEvent(String text) {
            if (this._statusBarLabel != null) {
                this._statusBarLabel.setText(text);
            }
        }

        public void cleanUp() {
            this._statusBar.remove((Component)this._statusBarLabel);
            this._statusBarLabel = null;
        }

        @Override
        protected void firePopupMenuWillBecomeInvisible() {
            super.firePopupMenuWillBecomeInvisible();
            NumberTypeTool.this.repaint();
        }

        @Override
        protected void firePopupMenuCanceled() {
            super.firePopupMenuCanceled();
            NumberTypeTool.this.repaint();
        }
    }

    private class Model
    extends JToggleButton.ToggleButtonModel {
        private static final long serialVersionUID = 1L;

        private Model() {
        }

        @Override
        public boolean isPressed() {
            return NumberTypeTool.this.isDropDownVisible();
        }
    }
}

