/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.util.DataAccess;
import oracle.dss.util.MemberListAccess;
import oracle.dss.util.dimensionList.DataAccessDimensionModel;
import oracle.dss.util.dimensionList.DimListDataItem;
import oracle.dss.util.dimensionList.DimListDataModel;
import oracle.dss.util.dimensionList.DimensionList;

public class DimensionShuttlePanel
extends JPanel
implements ItemListener {
    private static final long serialVersionUID = 1L;
    protected boolean m_bSuperCalled = true;
    protected Window m_parent;
    protected Locale m_locale = null;
    protected ResourceBundle rBundle = null;
    protected Shuttle m_shuttle = null;
    protected String m_translatedText = "";
    protected JLabel m_applyFormatToLabel = null;
    protected ButtonGroup m_buttonGroup = null;
    protected JRadioButton m_AnyProductButton = null;
    protected JRadioButton m_SelectedProductsButton = null;
    protected DataAccess m_dataAccess = null;
    protected MemberListAccess m_memberListAccess = null;
    protected String m_strDimension;
    protected String m_labelType = "shortName";
    protected boolean m_isTable = false;
    protected DimensionList m_dimListFrom = null;
    protected JList m_dimListTo = null;
    protected DataAccessDimensionModel m_listModel = null;
    protected Vector m_initVector = null;
    protected Vector m_selectedMembersVector = new Vector();
    protected ListPicker m_ListPicker1 = null;
    protected ListPicker m_ListPicker2 = null;
    private DimListCellRenderer m_cellRenderer = null;

    public DimensionShuttlePanel(Dialog parent, DataAccess dataAccess, MemberListAccess memberAccess, String Dimension2, String type, boolean isTable, Vector v) {
        this.m_parent = parent;
        this.m_dataAccess = dataAccess;
        this.m_memberListAccess = memberAccess;
        this.m_strDimension = Dimension2;
        this.m_labelType = type;
        this.m_isTable = isTable;
        this.m_initVector = v;
        this.constructPanel();
    }

    public DimensionShuttlePanel(Frame parent, DataAccess dataAccess, MemberListAccess memberAccess, String Dimension2, String type, boolean isTable, Vector v) {
        this.m_parent = parent;
        this.m_dataAccess = dataAccess;
        this.m_memberListAccess = memberAccess;
        this.m_strDimension = Dimension2;
        this.m_labelType = type;
        this.m_isTable = isTable;
        this.m_initVector = v;
        this.constructPanel();
    }

    private void constructPanel() {
        if (this.m_locale == null) {
            this.m_locale = Locale.getDefault();
            super.setLocale(this.m_locale);
            this.updateResourceBundle(this.m_locale);
        } else {
            this.updateResourceBundle(this.m_locale);
        }
        int iWidth = Integer.parseInt(this.rBundle.getString("DimensionShuttlePanelWidth"));
        int iHeight = Integer.parseInt(this.rBundle.getString("DimensionShuttlePanelHeight"));
        this.setPreferredSize(new Dimension(iWidth, iHeight));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout(new BoxLayout(this, 1));
        this.m_translatedText = this.rBundle.getString("ApplyFormatTo");
        this.m_applyFormatToLabel = new JLabel(this.m_translatedText);
        this.m_buttonGroup = new ButtonGroup();
        Object[] formatArgs = new String[]{this.getLayerLabel(this.m_strDimension, "dimShortName")};
        this.m_translatedText = this.rBundle.getString("AnyProduct");
        this.m_AnyProductButton = new JRadioButton(MessageFormat.format(StringUtils.stripMnemonic((String)this.m_translatedText), formatArgs), false);
        this.m_AnyProductButton.setName("AnyDimension/Measure");
        this.m_AnyProductButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        this.m_AnyProductButton.addItemListener(this);
        formatArgs[0] = this.getLayerLabel(this.m_strDimension, "dimShortPluralName");
        this.m_translatedText = this.rBundle.getString("SelectedProducts");
        this.m_SelectedProductsButton = new JRadioButton(MessageFormat.format(StringUtils.stripMnemonic((String)this.m_translatedText), formatArgs), true);
        this.m_SelectedProductsButton.setName("SelectedDimensions/Measures");
        this.m_SelectedProductsButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)this.m_translatedText));
        this.m_SelectedProductsButton.addItemListener(this);
        this.m_buttonGroup.add(this.m_AnyProductButton);
        this.m_buttonGroup.add(this.m_SelectedProductsButton);
        this.m_listModel = new DataAccessDimensionModel(this.m_dataAccess, this.m_memberListAccess, this.m_strDimension, this.m_isTable);
        this.m_listModel.setLabelType("shortName");
        this.m_listModel.setHierarchical(true);
        this.m_dimListTo = new JList();
        this.m_dimListTo.setName("AvailableList");
        this.m_cellRenderer = new DimListCellRenderer();
        this.m_dimListTo.setCellRenderer(this.m_cellRenderer);
        this.m_dimListFrom = new MyDimensionList();
        this.m_dimListFrom.setName("SelectedList");
        this.m_dimListFrom.setContextIconVisible(true);
        this.m_dimListFrom.setIconVisible(false);
        this.m_dimListFrom.doExpandAll();
        this.m_ListPicker1 = new ListPicker((JList)this.m_dimListFrom);
        this.m_ListPicker2 = new ListPicker(this.m_dimListTo){

            private Object getObject(Transferable transferable) {
                DataFlavor[] dataFlavors;
                if (transferable != null && (dataFlavors = transferable.getTransferDataFlavors()) != null) {
                    for (int j = 0; j < dataFlavors.length; ++j) {
                        try {
                            return transferable.getTransferData(dataFlavors[j]);
                        }
                        catch (UnsupportedFlavorException unsupportedFlavorException) {
                            continue;
                        }
                        catch (IOException ioException) {
                            // empty catch block
                        }
                    }
                }
                return null;
            }

            private boolean contains(Object object) {
                if (object != null) {
                    ListModel listModel = this.getList().getModel();
                    for (int i = 0; i < listModel.getSize(); ++i) {
                        if (!object.equals(listModel.getElementAt(i))) continue;
                        return true;
                    }
                }
                return false;
            }

            public boolean addSelectedItems(Transferable[] selectedItems) {
                Vector<Transferable> vector = new Vector<Transferable>();
                if (selectedItems != null) {
                    for (int i = 0; i < selectedItems.length; ++i) {
                        Object object = this.getObject(selectedItems[i]);
                        if (this.contains(object)) continue;
                        vector.add(selectedItems[i]);
                    }
                }
                selectedItems = vector.toArray(new Transferable[vector.size()]);
                return super.addSelectedItems(selectedItems);
            }
        };
        this.setSelectedMembers(this.m_initVector);
        this.m_shuttle = new Shuttle();
        this.m_shuttle.setBorder((Border)new EmptyBorder(0, 20, 0, 0));
        this.m_shuttle.setMode(1);
        this.m_shuttle.setFromPicker((ItemPicker)this.m_ListPicker1);
        this.m_shuttle.setToPicker((ItemPicker)this.m_ListPicker2);
        this.m_translatedText = this.rBundle.getString("Available:");
        this.m_shuttle.add((Component)new JLabel(this.m_translatedText), (Object)"FromHeader");
        this.m_translatedText = this.rBundle.getString("Selected:");
        this.m_shuttle.add((Component)new JLabel(this.m_translatedText), (Object)"ToHeader");
        this.add(this.m_applyFormatToLabel);
        this.m_applyFormatToLabel.setAlignmentX(0.0f);
        this.add(this.m_AnyProductButton);
        this.m_AnyProductButton.setAlignmentX(0.0f);
        this.add(this.m_SelectedProductsButton);
        this.m_SelectedProductsButton.setAlignmentX(0.0f);
        this.add((Component)this.m_shuttle);
        this.m_shuttle.setAlignmentX(0.0f);
    }

    public void setSelectedMembers(Vector v) {
        this.m_initVector = v;
        DimListDataModel dm = (DimListDataModel)this.m_dimListFrom.getModel();
        DimListDataItem dsItem = null;
        if (this.m_initVector == null) {
            return;
        }
        if (this.m_dimListFrom == null) {
            return;
        }
        ListModel dimListToModel = this.m_dimListTo.getModel();
        if (dimListToModel instanceof DefaultListModel) {
            DefaultListModel model2 = (DefaultListModel)dimListToModel;
            for (int i = 0; i < this.m_dimListFrom.getModel().getSize(); ++i) {
                dsItem = (DimListDataItem)dm.elementAt(i);
                if (this.m_initVector.indexOf(dsItem.getValue()) == -1) continue;
                model2.addElement(dsItem);
            }
        }
    }

    public Vector getSelectedMembers() {
        DimListDataItem dsItem = null;
        if (this.m_AnyProductButton.isSelected()) {
            return null;
        }
        if (this.m_dimListTo.getModel().getSize() == 0) {
            return null;
        }
        this.m_selectedMembersVector = new Vector();
        ListModel dimListToModel = this.m_dimListTo.getModel();
        if (dimListToModel instanceof DefaultListModel) {
            for (int i = 0; i < this.m_dimListTo.getModel().getSize(); ++i) {
                dsItem = (DimListDataItem)dimListToModel.getElementAt(i);
                this.m_selectedMembersVector.add(dsItem.getValue());
            }
        }
        return this.m_selectedMembersVector;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.m_AnyProductButton) {
                this.m_shuttle.setEnabled(false);
                this.m_dimListFrom.setEnabled(false);
                this.m_dimListTo.setEnabled(false);
            } else if (e.getSource() == this.m_SelectedProductsButton) {
                this.m_shuttle.setEnabled(true);
                this.m_dimListFrom.setEnabled(true);
                this.m_dimListTo.setEnabled(true);
            }
        }
    }

    @Override
    public Locale getLocale() {
        return this.m_locale;
    }

    @Override
    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.m_locale = locale;
        this.rBundle = ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle", locale);
        this.updateResourceBundle(this.m_locale);
    }

    public void cleanUp() {
        this.m_dimListTo.setCellRenderer(null);
        this.m_cellRenderer = null;
    }

    protected void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle");
    }

    public boolean showErrorDialog() {
        if (this.m_SelectedProductsButton.isSelected() && this.getSelectedMembers() == null) {
            Object[] formatArgs = new String[]{this.getLayerLabel(this.m_strDimension, "dimShortPluralName")};
            String errorMsg = MessageFormat.format(this.rBundle.getString("discardmessage"), formatArgs);
            JOptionPane jpane = new JOptionPane(errorMsg, 0, -1, new ImageIcon(ImageUtils.getImageResource(DimensionShuttlePanel.class, (String)"images/stop.gif")));
            jpane.getAccessibleContext().setAccessibleName(errorMsg);
            JDialog tmpDialog = jpane.createDialog(this.getParent(), this.rBundle.getString("confirmdiscard"));
            tmpDialog.show();
            FocusManager.getCurrentManager().focusNextComponent((Component)this.m_shuttle);
            return false;
        }
        return true;
    }

    private String getLayerLabel(String dimension, String type) {
        if (dimension == null) {
            return null;
        }
        try {
            for (int i = 0; i < this.m_dataAccess.getEdgeCount(); ++i) {
                int layerCount = this.m_dataAccess.getLayerCount(i);
                for (int j = 0; j < layerCount; ++j) {
                    Object dimVal = this.m_dataAccess.getLayerMetadata(i, j, "layerName");
                    String dim = null;
                    if (dimVal != null) {
                        dim = dimVal.toString();
                    }
                    if (dim == null || !dim.equals(dimension)) continue;
                    dimVal = this.m_dataAccess.getLayerMetadata(i, j, type);
                    if (dimVal != null) {
                        dim = dimVal.toString();
                    }
                    if (dim != null) {
                        return dim;
                    }
                    return dimension;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dimension;
    }

    class MyDimensionList
    extends DimensionList {
        private static final long serialVersionUID = 1L;
        private boolean _flag = true;

        public ListModel getModel() {
            if (this._flag) {
                return DimensionShuttlePanel.this.m_listModel;
            }
            return super.getModel();
        }
    }

    class DimListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        DimListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component renderer = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof DimListDataItem) {
                this.setText(((DimListDataItem)value).getText());
            }
            return renderer;
        }
    }
}

