/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.button.PushButton;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.share.nls.StringUtils;
import oracle.dss.dataView.gui.DataviewDialogBarLayout;

public abstract class DefaultDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final int _BORDER_INSET = 6;
    private final Border _sBorder = new EmptyBorder(6, 6, 6, 6);
    private Locale m_locale = null;
    protected PushButton previewButton = null;
    protected PushButton okButton = null;
    protected PushButton cancelButton = null;
    protected PushButton helpButton = null;
    protected boolean showPrevBtn = false;
    ResourceBundle rBundle = null;

    public DefaultDialog(Frame dialogFrame, boolean showPrevBtn, Locale locale) {
        super(dialogFrame, true);
        this.setLocale(locale);
        this.showPrevBtn = showPrevBtn;
        this.setResizable(false);
        this.init();
    }

    private void init() {
        JComponent content = (JComponent)this.getContentPane();
        content.setLayout(new BorderLayout(0, 6));
        content.setBorder(this._sBorder);
        if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
            content.setBackground(UIManager.getColor(ColorScheme.DARK_LOOK));
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new DataviewDialogBarLayout(buttonPanel));
        String m_translatedText = this.rBundle.getString("help");
        this.helpButton = new PushButton(StringUtils.stripMnemonic((String)m_translatedText));
        this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)m_translatedText));
        buttonPanel.add((Component)this.helpButton, DialogButtonBar.CONSTRAINT_HELP);
        this.helpButton.addActionListener((ActionListener)this);
        this.helpButton.setLeftmost(true);
        this.helpButton.setRightmost(true);
        if (this.showPrevBtn) {
            m_translatedText = this.rBundle.getString("preview");
            this.previewButton = new PushButton(StringUtils.stripMnemonic((String)m_translatedText));
            this.previewButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)m_translatedText));
            this.previewButton.addActionListener((ActionListener)this);
            buttonPanel.add((Component)this.previewButton, null);
            this.previewButton.setLeftmost(true);
            this.previewButton.setRightmost(true);
        }
        this.okButton = new PushButton(this.rBundle.getString("OK"));
        buttonPanel.add((Component)this.okButton, DialogButtonBar.CONSTRAINT_YES);
        this.okButton.addActionListener((ActionListener)this);
        this.okButton.setLeftmost(true);
        this.okButton.setRightmost(true);
        this.cancelButton = new PushButton(this.rBundle.getString("cancel"));
        buttonPanel.add((Component)this.cancelButton, DialogButtonBar.CONSTRAINT_CANCEL);
        this.cancelButton.addActionListener((ActionListener)this);
        this.cancelButton.setLeftmost(true);
        this.cancelButton.setRightmost(true);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.getRootPane().setDefaultButton((JButton)this.okButton);
        this.cancelButton.registerKeyboardAction((ActionListener)this, KeyStroke.getKeyStroke(27, 0), 2);
        this.helpButton.registerKeyboardAction((ActionListener)this, KeyStroke.getKeyStroke(112, 0), 2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.previewButton)) {
            return;
        }
        if (e.getSource().equals(this.helpButton)) {
            return;
        }
        this.setVisible(false);
    }

    @Override
    public void setLocale(Locale loc) {
        this.m_locale = loc;
        this.updateResourceBundle();
    }

    protected void updateResourceBundle() {
        try {
            this.rBundle = this.m_locale != null ? ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle", this.m_locale) : ResourceBundle.getBundle("oracle.dss.dataView.gui.resource.DataviewGUIBundle");
        }
        catch (MissingResourceException e) {
            this.rBundle = null;
        }
    }
}

