/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.datacache;

import java.util.Enumeration;
import oracle.dss.dataView.datacache.Data;
import oracle.dss.dataView.datacache.Edge;
import oracle.dss.dataView.datacache.Map;
import oracle.dss.dataView.datacache.Member;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;

public class RelationalEdge
implements Edge {
    private int m_nLimit = -1;
    private Member[] m_members;

    public RelationalEdge(ObjectNode edgeNode, Data d, Map metadataMap) {
        int layerCount = 0;
        ContainerNode layersNode = null;
        if (edgeNode != null) {
            try {
                layerCount = edgeNode.getPropertyValueAsInteger("layerCount");
            }
            catch (NoSuchPropertyException e) {
                // empty catch block
            }
            try {
                this.m_nLimit = edgeNode.getPropertyValueAsInteger("limit");
            }
            catch (NoSuchPropertyException e) {
                // empty catch block
            }
            layersNode = edgeNode.getContainer("Layers");
            if (layersNode == null) {
                layerCount = 0;
            }
        }
        this.m_members = new Member[layerCount];
        if (layerCount > 0) {
            Enumeration entries = layersNode.getContainedObject("Member");
            for (int layer = 0; layer < layerCount; ++layer) {
                if (entries.hasMoreElements()) {
                    ObjectNode memberNode = (ObjectNode)entries.nextElement();
                    this.m_members[layer] = new Member(memberNode, metadataMap);
                    ContainerNode dataNode = memberNode.getContainer("Data");
                    if (d == null || dataNode == null) continue;
                    d.readDataFromXML(dataNode, layer);
                    continue;
                }
                this.m_members[layer] = new Member();
            }
        }
    }

    public RelationalEdge(DataAccess da, int edge, Map metadataMap, int limit) {
        int layerCount = 1;
        try {
            layerCount = da.getLayerCount(edge);
        }
        catch (EdgeOutOfRangeException e) {
            // empty catch block
        }
        if (limit != -1 && layerCount > limit) {
            layerCount = limit;
            this.m_nLimit = limit;
        }
        this.m_members = new Member[layerCount];
        for (int layer = 0; layer < layerCount; ++layer) {
            this.m_members[layer] = new Member(da, edge, layer, 0, metadataMap);
        }
    }

    @Override
    public ObjectNode addEdgeToXML(String name, Data d, Map metadataMap, Map layerMap) {
        ObjectNode edgeNode = new ObjectNode(name);
        int layerCount = this.getLayerCount();
        edgeNode.addProperty("layerCount", layerCount);
        edgeNode.addProperty("limit", this.getLimit());
        ContainerNode layersNode = new ContainerNode("Layers");
        for (int layer = 0; layer < layerCount; ++layer) {
            ObjectNode memberNode = this.m_members[layer].addMemberToXML(metadataMap);
            if (d != null) {
                ContainerNode dataNode = new ContainerNode("Data");
                d.addDataToXML(dataNode, layer);
                memberNode.addContainer(dataNode);
            }
            layersNode.addContainedObject((BaseNode)memberNode);
        }
        edgeNode.addContainer(layersNode);
        return edgeNode;
    }

    @Override
    public Object getMemberMetadata(int layer, int slice, String type) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return this.getMember(layer).getMetadata(type);
    }

    @Override
    public Object getLayerMetadata(int layer, String type) throws LayerOutOfRangeException {
        if (type.equals("dimShortName")) {
            type = "shortName";
        } else if (type.equals("dimMediumName")) {
            type = "mediumName";
        } else if (type.equals("layerLabel")) {
            type = "label";
        } else if (type.equals("layerName")) {
            type = "value";
        }
        return this.getMember(layer).getMetadata(type);
    }

    @Override
    public int getLayerCount() {
        return this.m_members.length;
    }

    @Override
    public int getExtent() {
        return this.getLayerCount();
    }

    @Override
    public int getLimit() {
        return this.m_nLimit;
    }

    @Override
    public Object getSliceLabel(int slice) throws SliceOutOfRangeException {
        try {
            return this.getMember(slice).getMetadata("label");
        }
        catch (LayerOutOfRangeException e) {
            return null;
        }
    }

    @Override
    public int getSliceMemberCount(int slice) throws SliceOutOfRangeException {
        return 0;
    }

    @Override
    public int getMemberDepth(int layer, int slice) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return 1;
    }

    @Override
    public int getSliceOutlineLayer(int slice) throws SliceOutOfRangeException {
        return 0;
    }

    @Override
    public int getMemberStartLayer(int layer, int slice) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return 0;
    }

    @Override
    public int getMemberExtent(int layer, int slice) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return 1;
    }

    @Override
    public int getMemberStartSlice(int layer, int slice) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return 0;
    }

    @Override
    public int getMemberSiblingCount(int[] hPos, int memberLayer) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return 0;
    }

    @Override
    public Object getMemberMetadata(int[] hPos, int memberLayer, int hIndex, String type) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return null;
    }

    @Override
    public int[] getMemberHPos(int layer, int slice) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return null;
    }

    @Override
    public int[] getFirstHPos() {
        return null;
    }

    @Override
    public int[] getLastHPos() {
        return null;
    }

    @Override
    public int[] getPrevHPos(int[] hPos) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return null;
    }

    @Override
    public int[] getNextHPos(int[] hPos) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return null;
    }

    @Override
    public int getCurrentSlice() {
        return 0;
    }

    @Override
    public int[] getCurrentHPos() {
        return null;
    }

    @Override
    public QDR getMemberQDR(int layer, int slice) {
        return null;
    }

    @Override
    public QDR getSliceQDR(int slice) {
        return null;
    }

    private Member getMember(int layer) throws LayerOutOfRangeException {
        if (layer >= this.m_members.length) {
            throw new LayerOutOfRangeException(layer, this.m_members.length - 1);
        }
        if (layer < 0) {
            throw new LayerOutOfRangeException(layer, 0);
        }
        return this.m_members[layer];
    }

    @Override
    public Enumeration getMemberEnumeration(int layer) {
        return null;
    }
}

