/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import oracle.dss.dataView.AdornmentLayout;
import oracle.dss.dataView.Dataview;
import oracle.dss.dataView.managers.Styleable;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.presutil.PresUtils;
import oracle.dss.util.Utility;

public class DataviewUtils {
    private static final ThreadLocal<StringBuilder> _STRINGBUILDER = new ThreadLocal();
    private static final ThreadLocal<StringBuilder> _STRINGBUILDER2 = new ThreadLocal();

    public static boolean hasBorder(int s) {
        return s != 0 && s != 7;
    }

    public static int scaleByZoom(int size, int zoomFactor) {
        return (int)((float)size * ((float)zoomFactor / 100.0f));
    }

    public static int scaleDownByZoom(int size, int zoomFactor) {
        return Math.round((float)size / ((float)zoomFactor / 100.0f));
    }

    public static int adjustForEnhancedFont(int height, boolean underline, boolean doubleunderline) {
        if (doubleunderline) {
            return height + 2 + 2 + 2;
        }
        if (underline) {
            return height + 2 + 1;
        }
        return height;
    }

    public static void copyStyleProperties(Styleable toStyleable, Styleable fromStyleable) {
        ViewStyle to = toStyleable.getViewStyle();
        ViewStyle from = fromStyleable.getViewStyle();
        to.setBackground(from.getBackground());
        to.setForeground(from.getForeground());
        to.setSelectBackground(from.getSelectBackground());
        to.setSelectForeground(from.getSelectForeground());
        to.setFont(from.getFont());
        to.setHorizontalAlignment(from.getHorizontalAlignment());
        to.setVerticalAlignment(from.getVerticalAlignment());
        to.setBorderStyle(15, from.getBorderStyle(15));
        to.setBorderStyle(1, from.getBorderStyle(1));
        to.setBorderStyle(4, from.getBorderStyle(4));
        to.setBorderStyle(2, from.getBorderStyle(2));
        to.setBorderStyle(8, from.getBorderStyle(8));
        to.setBorderColor(15, from.getBorderColor(15));
        to.setBorderColor(1, from.getBorderColor(1));
        to.setBorderColor(2, from.getBorderColor(2));
        to.setBorderColor(4, from.getBorderColor(4));
        to.setBorderColor(8, from.getBorderColor(8));
        to.setBorderWidth(15, from.getBorderWidth(15));
        to.setBorderWidth(1, from.getBorderWidth(1));
        to.setBorderWidth(2, from.getBorderWidth(2));
        to.setBorderWidth(4, from.getBorderWidth(4));
        to.setBorderWidth(8, from.getBorderWidth(8));
        to.setUnderline(from.isUnderline());
        to.setDoubleUnderline(from.isDoubleUnderline());
        to.setStrikeThrough(from.isStrikeThrough());
        to.setWordWrapEnabled(from.isWordWrapEnabled());
        to.setGraphicImageIndex(from.getGraphicImageIndex());
        to.setGraphicImageTooltip(from.getGraphicImageTooltip());
        to.setCellEditStyle(from.getCellEditStyle());
        to.setEditBackground(from.getEditBackground());
        to.setEditForeground(from.getEditForeground());
        to.setGraphicBarColor(from.getGraphicBarColor());
        to.setGraphicBarVisible(from.isGraphicBarVisible());
        to.setHPageBreak(from.isHPageBreak());
        to.setVPageBreak(from.isVPageBreak());
        to.setPropertyUsedFlags(from.getPropertyUsedFlags());
    }

    static void setFlowAlignment(LayoutManager lm, int swingAlignment) {
        if (!(lm instanceof AdornmentLayout)) {
            return;
        }
        AdornmentLayout flow = (AdornmentLayout)lm;
        switch (swingAlignment) {
            case 0: {
                flow.setAlignment(1);
                break;
            }
            case 2: {
                flow.setAlignment(0);
                break;
            }
            case 4: {
                flow.setAlignment(2);
            }
        }
    }

    public static final void selectPageItem(Dataview view, long pi) {
        if (view.getPagingControl() != null && view.getPagingControl().getPagingComponent() != null && pi >= 0L) {
            view.getPagingControl().getPagingComponent().setSelectedItem(view.getPagingControl().getPagingComponent().getItem((int)pi));
        }
    }

    public static int convertVertAlignToEWT(int align) {
        int ewtAlign = -1;
        switch (align) {
            case 3: {
                ewtAlign = 2;
                break;
            }
            case 0: {
                ewtAlign = 1;
                break;
            }
            case 1: {
                ewtAlign = 0;
            }
        }
        return ewtAlign;
    }

    public static int convertHorizAlignToEWT(int align) {
        int ewtAlign = -1;
        switch (align) {
            case 2: {
                ewtAlign = 1;
                break;
            }
            case 0: {
                ewtAlign = 3;
                break;
            }
            case 4: {
                ewtAlign = 2;
                break;
            }
            case 10: {
                ewtAlign = 0;
            }
        }
        return ewtAlign;
    }

    public static int convertVertAlignToJava(int ewtAlign) {
        int align = -1;
        switch (ewtAlign) {
            case 2: {
                align = 3;
                break;
            }
            case 1: {
                align = 0;
                break;
            }
            case 0: {
                align = 1;
            }
        }
        return align;
    }

    public static int convertHorizAlignToJava(int ewtAlign) {
        int align = -1;
        switch (ewtAlign) {
            case 1: {
                align = 2;
                break;
            }
            case 3: {
                align = 0;
                break;
            }
            case 2: {
                align = 4;
                break;
            }
            case 0: {
                align = 10;
            }
        }
        return align;
    }

    public static int compareXMLVersions(String ver1, String ver2) {
        return Utility.compareXMLVersions((String)ver1, (String)ver2);
    }

    public static String toHexString(int value) {
        return PresUtils.toHexString(value);
    }

    @Deprecated
    public static int hexStringToInt(String str) {
        String noPound = str.substring(1);
        return Integer.parseInt(noPound, 16);
    }

    public static Color hexStringToColor(String str) {
        String noPound = str.substring(1);
        try {
            if (noPound.length() == 8) {
                int a = Integer.parseInt(noPound.substring(0, 2), 16);
                int r = Integer.parseInt(noPound.substring(2, 4), 16);
                int g = Integer.parseInt(noPound.substring(4, 6), 16);
                int b = Integer.parseInt(noPound.substring(6, 8), 16);
                return new Color(r, g, b, a);
            }
            return new Color(Integer.parseInt(noPound, 16), false);
        }
        catch (NumberFormatException e) {
            System.out.println("NumberFormatException for " + noPound + " in hexStringToColor");
            return null;
        }
    }

    public static int fontStyle(boolean bold, boolean italic) {
        int s = 0;
        if (bold) {
            s |= 1;
        }
        if (italic) {
            s |= 2;
        }
        return s;
    }

    public static Double toDouble(String value, Locale locale, NumberFormat numberFormat) {
        String trimValue = value.trim();
        DecimalFormatSymbols decFmtSym = null;
        decFmtSym = locale == null ? new DecimalFormatSymbols() : new DecimalFormatSymbols(locale);
        char separator = decFmtSym.getGroupingSeparator();
        value = separator == '\u00a0' ? trimValue.replace(' ', separator) : trimValue;
        if (numberFormat == null) {
            numberFormat = locale == null ? NumberFormat.getNumberInstance() : NumberFormat.getNumberInstance(locale);
        }
        ParsePosition parsePos = new ParsePosition(0);
        Number num = numberFormat.parse(value, parsePos);
        Double doubleObj = null;
        if (parsePos.getIndex() == value.length()) {
            if (num instanceof Double) {
                doubleObj = (Double)num;
            } else if (num != null) {
                doubleObj = new Double(num.doubleValue());
            }
        }
        return doubleObj;
    }

    public static void setCursor(Component component, Cursor c) {
        component.setCursor(c);
        if (component instanceof Container) {
            Container cont = (Container)component;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                DataviewUtils.setCursor(cont.getComponent(i), c);
            }
        }
    }

    public static StringBuilder getSharedStringBuilder(ThreadLocal<StringBuilder> tl) {
        StringBuilder sb = tl.get();
        if (sb == null) {
            sb = new StringBuilder();
            tl.set(sb);
        } else {
            sb.setLength(0);
        }
        return sb;
    }

    public static StringBuilder getSharedStringBuilder() {
        return DataviewUtils.getSharedStringBuilder(_STRINGBUILDER);
    }

    public static StringBuilder getSharedStringBuilder2() {
        return DataviewUtils.getSharedStringBuilder(_STRINGBUILDER2);
    }

    public static StringBuilder getSharedStringBuilder(ThreadLocal<StringBuilder> tl, String s) {
        return DataviewUtils.getSharedStringBuilder(tl).append(s);
    }

    public static StringBuilder getSharedStringBuilder(String s) {
        return DataviewUtils.getSharedStringBuilder().append(s);
    }

    public static StringBuilder getSharedStringBuilder2(String s) {
        return DataviewUtils.getSharedStringBuilder2().append(s);
    }
}

