/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;
import java.util.Locale;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.painter.ImagePainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.painter.TextPainter;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotHeaderPainter;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.text.WrappedText;
import oracle.bali.ewt.util.ImmInsets;
import oracle.dss.crosstab.CrosstabPivotHeader;
import oracle.dss.crosstab.CrosstabUtils;
import oracle.dss.crosstab.RowHeaderCell;
import oracle.dss.dataView.BaseTitle;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.GridViewWrappingTextPainter;

public class HeaderPainter
extends PivotHeaderPainter
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected CrosstabPivotHeader header = null;
    private ImmInsets insets;

    public HeaderPainter(CrosstabPivotHeader h) {
        super((PivotHeader)h);
        this.header = h;
        this.insets = new ImmInsets(0, 1, 0, 1);
        this.setPainter((Painter)new ChoicePainter());
    }

    public Painter getWrappedPainter() {
        return super.getWrappedPainter(null);
    }

    protected void drawEnhancedFont(ViewStyle style, PaintContext context, Graphics g, FontMetrics metrics, String text, int x, int y, int availableWidth, float alignmentX) {
        boolean underline = false;
        boolean doubleunderline = false;
        boolean strikethrough = false;
        if (style != null) {
            underline = style.isUnderline();
            doubleunderline = style.isDoubleUnderline();
            strikethrough = style.isStrikeThrough();
        }
        if (underline || doubleunderline || strikethrough) {
            int stringWidth;
            Cell cell = (Cell)context.getPaintData((Object)"Cell");
            String newString = CrosstabUtils.leftTrim(text);
            int bump = (text.length() - newString.length()) * metrics.stringWidth(" ");
            if (alignmentX != 0.0f && (stringWidth = metrics.stringWidth(text)) < availableWidth) {
                x = (int)((float)x + (float)(availableWidth - stringWidth) * alignmentX);
            }
            BaseTitle.drawEnhancedAdornments(metrics, g, x + bump, y, metrics.stringWidth(newString), underline, doubleunderline, strikethrough);
        }
    }

    private class EnhancedTextPainter
    extends TextPainter {
        ChoicePainter hostPainter = null;

        public EnhancedTextPainter(ChoicePainter _host) {
            this.hostPainter = _host;
        }

        protected int paintText(PaintContext context, Graphics g, FontMetrics metrics, String text, int x, int y, int availableWidth, float alignmentX, int mnemonicIndex) {
            ViewStyle style = this.hostPainter._convertContextToStyle(context);
            if (style.getVerticalJustify() == 2) {
                --y;
            }
            int retVal = super.paintText(context, g, metrics, text, x, y, availableWidth, alignmentX, mnemonicIndex);
            HeaderPainter.this.drawEnhancedFont(style, context, g, metrics, text, x, y, availableWidth, alignmentX);
            return retVal;
        }
    }

    private class GraphicImagePainter
    extends ImagePainter {
        private Image image;

        public GraphicImagePainter() {
            super(0);
        }

        public void setImage(Image ig) {
            this.image = ig;
        }

        protected Image getImageData(PaintContext context) {
            return this.image;
        }
    }

    private class ChoicePainter
    extends GridViewWrappingTextPainter {
        private EnhancedTextPainter textPainter;
        private GraphicImagePainter imagePainter;

        public ChoicePainter() {
            this.textPainter = new EnhancedTextPainter(this);
            this.imagePainter = new GraphicImagePainter();
        }

        public Dimension getMinimumSize(PaintContext context) {
            if (this._shouldWrap(this._convertContextToStyle(context))) {
                return super.getMinimumSize(context);
            }
            return this.textPainter.getMinimumSize(context);
        }

        @Override
        public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
            ViewStyle style;
            Image im;
            int drillImageOffsetWidth;
            Cell cell = (Cell)context.getPaintData((Object)"Cell");
            boolean l2r = true;
            Image blankImage = HeaderPainter.this.header.getScaledBlankImage();
            Image drillImage = HeaderPainter.this.header.getDrillImage(cell.column, cell.row);
            if (blankImage != null && drillImage != null && !HeaderPainter.this.header.crosstab.isPrintOrPreviewMode() && (drillImageOffsetWidth = blankImage.getWidth(null) - drillImage.getWidth(null)) > 0) {
                if (l2r) {
                    x += drillImageOffsetWidth;
                    width -= drillImageOffsetWidth;
                } else {
                    width -= drillImageOffsetWidth;
                }
            }
            if ((im = HeaderPainter.this.header.getGraphicImage(cell.column, cell.row)) != null && !HeaderPainter.this.header.crosstab.isPrintOrPreviewMode()) {
                this.imagePainter.setImage(im);
                Dimension d = this.imagePainter.getPreferredSize(context);
                float align = context.getInteriorAlignmentY();
                int savedY = y;
                Appearance appearance = (Appearance)context.getPaintData((Object)"Appearance");
                Font f = appearance.getFont();
                int fontSize = 0;
                if (f == null) {
                    f = HeaderPainter.this.header.getFont();
                }
                if (f != null) {
                    fontSize = HeaderPainter.this.header.getFontMetrics(f).getHeight();
                }
                int temp = height;
                if (height < fontSize) {
                    temp = fontSize;
                }
                y = (int)((float)y + (float)(temp - fontSize) * align + (float)((fontSize - d.height) / 2));
                if (l2r) {
                    this.imagePainter.paint(context, g, x, y, d.width, height);
                    x += d.width;
                    width -= d.width;
                } else {
                    this.imagePainter.paint(context, g, x + width - d.width, y, d.width, height);
                    width -= d.width;
                }
                y = savedY;
                x += ((HeaderPainter)HeaderPainter.this).insets.right;
                width -= ((HeaderPainter)HeaderPainter.this).insets.right;
            }
            if (this._shouldWrap(style = HeaderPainter.this.header.getStyle(cell.column, cell.row))) {
                super.paint(context, g, x, y, width, height);
            } else {
                this.textPainter.paint(context, g, x, y, width, height);
            }
        }

        protected int paintText(PaintContext context, Graphics g, FontMetrics metrics, String text, int x, int y, int availableWidth, float alignmentX, int mnemonicIndex) {
            ViewStyle style = this._convertContextToStyle(context);
            if (style.getVerticalJustify() == 2) {
                --y;
            }
            int retVal = this._shouldWrap(style) ? super.paintText(context, g, metrics, text, x, y, availableWidth, alignmentX, mnemonicIndex) : this.textPainter.paintText(context, g, metrics, text, x, y, availableWidth, alignmentX, mnemonicIndex);
            if (text.trim().length() == 0) {
                return retVal;
            }
            HeaderPainter.this.drawEnhancedFont(style, context, g, metrics, text, x, y, availableWidth, alignmentX);
            return retVal;
        }

        @Override
        protected GridViewWrappingTextPainter.WrappedTextHandle getWrappedTextHandle(String text, int width, FontMetrics metrics, Locale locale, PaintContext context, int x) {
            int index;
            Object bigCellObj = context.getPaintData((Object)"BigCell");
            RowHeaderCell rowHeaderCell = null;
            if (bigCellObj != null && bigCellObj instanceof RowHeaderCell) {
                rowHeaderCell = (RowHeaderCell)bigCellObj;
            }
            String trimmedText = null;
            int paddingWidth = 0;
            if (rowHeaderCell != null && (trimmedText = text.trim()) != text && (index = text.indexOf(trimmedText)) > 0) {
                String padding = text.substring(0, index);
                paddingWidth = metrics.stringWidth(padding);
            }
            WrappedText wrappedText = null;
            if (paddingWidth > 0) {
                x += paddingWidth;
                if ((width -= paddingWidth) < 0) {
                    width = 0;
                }
                wrappedText = this._getWrappedText(trimmedText, width, metrics, context.getPaintLocale());
            } else {
                wrappedText = this._getWrappedText(text, width, metrics, context.getPaintLocale());
            }
            return new GridViewWrappingTextPainter.WrappedTextHandle(this, x, width, wrappedText);
        }

        ViewStyle _convertContextToStyle(PaintContext context) {
            if (context != null) {
                Cell c = (Cell)context.getPaintData((Object)"Cell");
                return HeaderPainter.this.header.getStyle(c.column, c.row);
            }
            return null;
        }

        private boolean _shouldWrap(ViewStyle style) {
            return style == null ? HeaderPainter.this.header.getViewStyle().isWordWrapEnabled() : style.isWordWrapEnabled();
        }
    }
}

