/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab;

import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Vector;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.pivot.PivotTableSelection;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.CellRange;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.share.collection.Range;
import oracle.dss.crosstab.Crosstab;
import oracle.dss.crosstab.CrosstabHeaderCell;
import oracle.dss.crosstab.HeaderData;
import oracle.dss.dataView.ColumnComponentHandle;
import oracle.dss.dataView.ColumnRangeComponentHandle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.EdgeComponentHandle;
import oracle.dss.dataView.EdgeRangeComponentHandle;
import oracle.dss.dataView.RowComponentHandle;
import oracle.dss.dataView.RowRangeComponentHandle;
import oracle.dss.gridView.GridViewUtils;
import oracle.dss.util.ColumnComponentInfo;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.EdgeComponentInfo;
import oracle.dss.util.RowComponentInfo;

class CrosstabUtils
extends GridViewUtils {
    private static final String m_method_unselectPivotTable = "unselectPivotTable()";

    CrosstabUtils() {
    }

    static ComponentHandle createDataComponent(Crosstab ct, int type, String name, Object source, int row, int column, CellRange[] cellList, boolean useSel) {
        return GridViewUtils.createDataComponent(ct, type, name, source, row, column, cellList, useSel);
    }

    static void selectAllCells(boolean select, Grid grid, Crosstab crosstab) {
        crosstab.getCrosstabController().setSelectingCells(true);
        try {
            if (select) {
                grid.selectAll();
            } else {
                grid.deselectAll();
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        crosstab.getCrosstabController().setSelectingCells(false);
    }

    static void selectRow(RowComponentInfo row, Grid grid, Crosstab crosstab) {
        GridSelectionManager gs = grid.getGridSelectionManager();
        if (gs == null) {
            return;
        }
        crosstab.getCrosstabController().setSelectingCells(true);
        try {
            grid.deselectAll();
            gs.addSelection(new TwoDSelection(row.getRow(), true));
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        crosstab.getCrosstabController().setSelectingCells(false);
    }

    static void selectRows(RowComponentInfo[] row, Grid grid, Crosstab crosstab) {
        GridSelectionManager gs = grid.getGridSelectionManager();
        if (gs == null) {
            return;
        }
        crosstab.getCrosstabController().setSelectingCells(true);
        try {
            OneDSelection ods = new OneDSelection();
            for (int i = 0; i < row.length; ++i) {
                ods = ods.add(row[i].getRow());
            }
            grid.deselectAll();
            grid.setSelection(new TwoDSelection(null, ods));
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        crosstab.getCrosstabController().setSelectingCells(false);
    }

    static void selectColumn(ColumnComponentInfo col, Grid grid, Crosstab crosstab) {
        GridSelectionManager gs = grid.getGridSelectionManager();
        if (gs == null) {
            return;
        }
        crosstab.getCrosstabController().setSelectingCells(true);
        try {
            grid.deselectAll();
            gs.addSelection(new TwoDSelection(col.getColumn(), false));
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        crosstab.getCrosstabController().setSelectingCells(false);
    }

    static void selectColumns(ColumnComponentInfo[] col, Grid grid, Crosstab crosstab) {
        GridSelectionManager gs = grid.getGridSelectionManager();
        if (gs == null) {
            return;
        }
        crosstab.getCrosstabController().setSelectingCells(true);
        try {
            OneDSelection ods = new OneDSelection();
            for (int i = 0; i < col.length; ++i) {
                ods = ods.add(col[i].getColumn());
            }
            grid.deselectAll();
            grid.setSelection(new TwoDSelection(ods, null));
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        crosstab.getCrosstabController().setSelectingCells(false);
    }

    static void selectCells(DataComponentInfo[] cells, Grid grid, Crosstab crosstab) {
        GridSelectionManager gs = grid.getGridSelectionManager();
        if (gs == null) {
            return;
        }
        crosstab.getCrosstabController().setSelectingCells(true);
        try {
            CellRange[] rangesArray = CrosstabUtils.convertCellsToRanges(cells);
            TwoDSelection tds = new TwoDSelection(null, null, rangesArray);
            grid.deselectAll();
            grid.setSelection(tds);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        crosstab.getCrosstabController().setSelectingCells(false);
    }

    static void selectCell(EdgeComponentInfo info, int headerEdge, Grid grid, Crosstab crosstab) {
        GridSelectionManager gs = grid.getGridSelectionManager();
        if (gs == null) {
            return;
        }
        crosstab.getCrosstabController().setSelectingCells(true);
        try {
            grid.deselectAll();
            int edge = info.getEdge();
            if (headerEdge == edge) {
                if (edge == 0) {
                    gs.addSelection(new TwoDSelection(null, null, info.getIndex(), info.getDepth()));
                } else {
                    gs.addSelection(new TwoDSelection(null, null, info.getDepth(), info.getIndex()));
                }
            }
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        crosstab.getCrosstabController().setSelectingCells(false);
    }

    static void selectCells(EdgeComponentInfo[] cells, int headerEdge, Grid grid, Crosstab crosstab) {
        GridSelectionManager gs = grid.getGridSelectionManager();
        if (gs == null) {
            return;
        }
        crosstab.getCrosstabController().setSelectingCells(true);
        HeaderData model = null;
        model = headerEdge == 0 ? crosstab.getCrosstabModel().getColumnDataSource() : crosstab.getCrosstabModel().getRowDataSource();
        try {
            CellRange[] rangesArray = CrosstabUtils.convertEdgeCellsToRanges(headerEdge, model, cells);
            TwoDSelection tds = new TwoDSelection(null, null, rangesArray);
            grid.deselectAll();
            grid.setSelection(tds);
        }
        catch (PropertyVetoException e) {
            // empty catch block
        }
        crosstab.getCrosstabController().setSelectingCells(false);
    }

    protected static CellRange[] convertEdgeCellsToRanges(int edge, HeaderData model, EdgeComponentInfo[] cells) {
        ArrayList<CellRange> singleCols = new ArrayList<CellRange>();
        ArrayList<CellRange> singleRows = new ArrayList<CellRange>();
        int minCol = -1;
        int maxCol = -1;
        int minRow = -1;
        int maxRow = -1;
        for (int cell = 0; cell < cells.length; ++cell) {
            int startCol = -1;
            int startRow = -1;
            if (edge == 0) {
                startCol = cells[cell].getIndex();
                startRow = cells[cell].getDepth();
            } else {
                startCol = cells[cell].getDepth();
                startRow = cells[cell].getIndex();
            }
            int endCol = startCol;
            int endRow = startRow;
            Object dataObj = model.getData(startCol, startRow);
            if (dataObj != null && dataObj instanceof CrosstabHeaderCell) {
                CrosstabHeaderCell chCell = (CrosstabHeaderCell)dataObj;
                endCol = startCol + chCell.getColumnCount() - 1;
                endRow = startRow + chCell.getRowCount() - 1;
            }
            for (int newCol = startCol; newCol <= endCol; ++newCol) {
                for (int newRow = startRow; newRow <= endRow; ++newRow) {
                    if (minCol < 0) {
                        minCol = newCol;
                        maxCol = newCol;
                        minRow = newRow;
                        maxRow = newRow;
                        continue;
                    }
                    if (minCol == maxCol && newCol == maxCol && (newRow == minRow - 1 || newRow == maxRow + 1)) {
                        if (newRow == minRow - 1) {
                            minRow = newRow;
                            continue;
                        }
                        if (newRow != maxRow + 1) continue;
                        maxRow = newRow;
                        continue;
                    }
                    if (minRow == maxRow && newRow == maxRow && (newCol == minCol - 1 || newCol == maxCol + 1)) {
                        if (newCol == minCol - 1) {
                            minCol = newCol;
                            continue;
                        }
                        if (newCol != maxCol + 1) continue;
                        maxCol = newCol;
                        continue;
                    }
                    CellRange range = new CellRange(minCol, minRow, maxCol, maxRow);
                    if (minCol == maxCol) {
                        singleCols.add(range);
                    } else {
                        singleRows.add(range);
                    }
                    minCol = newCol;
                    maxCol = newCol;
                    minRow = newRow;
                    maxRow = newRow;
                }
            }
        }
        CellRange lastCellRange = new CellRange(minCol, minRow, maxCol, maxRow);
        if (minCol == maxCol) {
            singleCols.add(lastCellRange);
        } else {
            singleRows.add(lastCellRange);
        }
        ArrayList<CellRange> cellRanges = new ArrayList<CellRange>();
        if (singleCols.size() > 1) {
            CellRange range = (CellRange)singleCols.get(0);
            for (int c = 1; c < singleCols.size(); ++c) {
                CellRange range2 = (CellRange)singleCols.get(c);
                boolean bIncluded = false;
                if (range2.getLowerLimit().column == range.getLowerLimit().column - 1) {
                    if (range2.getLowerLimit().row == range.getLowerLimit().row && range2.getUpperLimit().row == range.getUpperLimit().row) {
                        range = new CellRange(range.getLowerLimit().column - 1, range.getLowerLimit().row, range.getUpperLimit().column, range.getUpperLimit().row);
                        bIncluded = true;
                    }
                } else if (range2.getUpperLimit().column == range.getUpperLimit().column + 1 && range2.getLowerLimit().row == range.getLowerLimit().row && range2.getUpperLimit().row == range.getUpperLimit().row) {
                    range = new CellRange(range.getLowerLimit().column, range.getLowerLimit().row, range.getUpperLimit().column + 1, range.getUpperLimit().row);
                    bIncluded = true;
                }
                if (bIncluded) continue;
                cellRanges.add(range);
                range = range2;
            }
            cellRanges.add(range);
        } else if (singleCols.size() == 1) {
            cellRanges.add((CellRange)singleCols.get(0));
        }
        if (singleRows.size() > 1) {
            CellRange range = (CellRange)singleRows.get(0);
            for (int r = 1; r < singleRows.size(); ++r) {
                CellRange range2 = (CellRange)singleRows.get(r);
                boolean bIncluded = false;
                if (range2.getLowerLimit().row == range.getLowerLimit().row - 1) {
                    if (range2.getLowerLimit().column == range.getLowerLimit().column && range2.getUpperLimit().column == range.getUpperLimit().column) {
                        range = new CellRange(range.getLowerLimit().column, range.getLowerLimit().row - 1, range.getUpperLimit().column, range.getUpperLimit().row);
                        bIncluded = true;
                    }
                } else if (range2.getUpperLimit().row == range.getUpperLimit().row + 1 && range2.getLowerLimit().column == range.getLowerLimit().column && range2.getUpperLimit().column == range.getUpperLimit().column) {
                    range = new CellRange(range.getLowerLimit().column, range.getLowerLimit().row, range.getUpperLimit().column, range.getUpperLimit().row + 1);
                    bIncluded = true;
                }
                if (bIncluded) continue;
                cellRanges.add(range);
                range = range2;
            }
            cellRanges.add(range);
        } else if (singleRows.size() == 1) {
            cellRanges.add((CellRange)singleRows.get(0));
        }
        CellRange[] rangesArray = new CellRange[cellRanges.size()];
        rangesArray = cellRanges.toArray(rangesArray);
        return rangesArray;
    }

    public static final void unselectPivotTable(Crosstab crosstab) {
        try {
            crosstab.getPivotTable().setSelection(new PivotTableSelection(new TwoDSelection(), new TwoDSelection(), new TwoDSelection()));
        }
        catch (PropertyVetoException efg) {
            crosstab.getErrorHandler().error((Throwable)efg, "oracle.dss.crosstab.CrosstabUtils", m_method_unselectPivotTable);
        }
    }

    protected static ComponentHandle createColumnRangeComponent(Crosstab gv, int type, String name, Object source, int index, Range[] cellList, boolean useSel) {
        if (type == 14) {
            if (!CrosstabUtils.oneCellOnly(cellList) && useSel) {
                return new ColumnRangeComponentHandle(19, gv.getNameFromID(19), source, CrosstabUtils.convertDataColRangesToCells(cellList));
            }
            if (useSel && cellList != null && cellList.length == 1) {
                return new ColumnComponentHandle(type, name, source, gv.getGridViewModel().getDataFromTableCol(cellList[0].getLowerLimit()));
            }
            return new ColumnComponentHandle(type, name, source, gv.getGridViewModel().getDataFromTableCol(index));
        }
        if (type == 24) {
            if (!CrosstabUtils.oneCellOnly(cellList) && useSel) {
                return new ColumnRangeComponentHandle(26, gv.getNameFromID(26), source, CrosstabUtils.convertDataColRangesToCells(cellList));
            }
            if (useSel && cellList != null && cellList.length == 1) {
                return new ColumnComponentHandle(type, name, source, cellList[0].getLowerLimit());
            }
            return new ColumnComponentHandle(type, name, source, index);
        }
        return null;
    }

    protected static ComponentHandle createRowRangeComponent(Crosstab gv, int type, String name, Object source, int index, Range[] cellList, boolean useSel) {
        if (type == 15) {
            if (!CrosstabUtils.oneCellOnly(cellList) && useSel) {
                return new RowRangeComponentHandle(20, gv.getNameFromID(20), source, CrosstabUtils.convertDataRowRangesToCells(cellList));
            }
            if (useSel && cellList != null && cellList.length == 1) {
                return new RowComponentHandle(type, name, source, gv.getGridViewModel().getDataFromTableRow(cellList[0].getLowerLimit()));
            }
            return new RowComponentHandle(type, name, source, gv.getGridViewModel().getDataFromTableRow(index));
        }
        if (type == 25) {
            if (!CrosstabUtils.oneCellOnly(cellList) && useSel) {
                return new RowRangeComponentHandle(27, gv.getNameFromID(27), source, CrosstabUtils.convertDataRowRangesToCells(cellList));
            }
            if (useSel && cellList != null && cellList.length == 1) {
                return new RowComponentHandle(type, name, source, cellList[0].getLowerLimit());
            }
            return new RowComponentHandle(type, name, source, index);
        }
        return null;
    }

    protected static ComponentHandle createEdgeComponent(Crosstab crosstab, int type, String name, Object source, int edge, int row, int column, CellRange[] cellList, boolean useSel) {
        if (type == 10) {
            EdgeComponentInfo[] eciArray;
            if (!CrosstabUtils.oneCellOnly(cellList) && useSel && (eciArray = CrosstabUtils.convertEdgeRangesToCells(edge, crosstab.getCrosstabModel().getColumnDataSource(), cellList)) != null) {
                if (eciArray.length > 1) {
                    return new EdgeRangeComponentHandle(17, crosstab.getNameFromID(17), source, eciArray);
                }
                return new EdgeComponentHandle(10, crosstab.getNameFromID(10), source, eciArray[0]);
            }
            if (useSel && cellList != null && cellList.length == 1) {
                return new EdgeComponentHandle(type, name, source, edge, crosstab.getGridViewModel().getDataFromTableRow(cellList[0].getLowerLimit().row), crosstab.getGridViewModel().getDataFromTableCol(cellList[0].getLowerLimit().column));
            }
            return new EdgeComponentHandle(type, name, source, edge, crosstab.getGridViewModel().getDataFromTableRow(row), crosstab.getGridViewModel().getDataFromTableCol(column));
        }
        if (type == 11) {
            EdgeComponentInfo[] eciArray;
            if (!CrosstabUtils.oneCellOnly(cellList) && useSel && (eciArray = CrosstabUtils.convertEdgeRangesToCells(edge, crosstab.getCrosstabModel().getRowDataSource(), cellList)) != null) {
                if (eciArray.length > 1) {
                    return new EdgeRangeComponentHandle(18, crosstab.getNameFromID(18), source, eciArray);
                }
                return new EdgeComponentHandle(11, crosstab.getNameFromID(11), source, eciArray[0]);
            }
            if (useSel && cellList != null && cellList.length == 1) {
                return new EdgeComponentHandle(type, name, source, edge, crosstab.getGridViewModel().getDataFromTableCol(cellList[0].getLowerLimit().column), crosstab.getGridViewModel().getDataFromTableRow(cellList[0].getLowerLimit().row));
            }
            return new EdgeComponentHandle(type, name, source, edge, crosstab.getGridViewModel().getDataFromTableCol(column), crosstab.getGridViewModel().getDataFromTableRow(row));
        }
        return null;
    }

    protected static EdgeComponentInfo[] convertEdgeRangesToCells(int edge, HeaderData model, CellRange[] range) {
        int r;
        Vector<EdgeComponentInfo> tempeci = new Vector<EdgeComponentInfo>();
        for (r = 0; r < range.length; ++r) {
            EdgeComponentInfo elem;
            int i;
            boolean bFound;
            EdgeComponentInfo eci;
            int startRow;
            int startCol;
            CrosstabHeaderCell cell;
            Object dataObj;
            int col;
            int row;
            Cell ll = range[r].getLowerLimit();
            Cell ul = range[r].getUpperLimit();
            if (edge == 0) {
                for (row = ll.row; row <= ul.row; ++row) {
                    for (col = ll.column; col <= ul.column; ++col) {
                        dataObj = model.getData(col, row);
                        if (dataObj != null && dataObj instanceof CrosstabHeaderCell) {
                            cell = (CrosstabHeaderCell)dataObj;
                            startCol = cell.getColumn();
                            startRow = cell.getRow();
                            eci = new EdgeComponentInfo(edge, startRow, startCol);
                            bFound = false;
                            for (i = 0; i < tempeci.size(); ++i) {
                                elem = (EdgeComponentInfo)tempeci.elementAt(i);
                                if (!elem.equals((Object)eci)) continue;
                                bFound = true;
                                break;
                            }
                            if (bFound) continue;
                            tempeci.addElement(eci);
                            continue;
                        }
                        tempeci.addElement(new EdgeComponentInfo(edge, row, col));
                    }
                }
                continue;
            }
            if (edge != 1) continue;
            for (col = ll.column; col <= ul.column; ++col) {
                for (row = ll.row; row <= ul.row; ++row) {
                    dataObj = model.getData(col, row);
                    if (dataObj != null && dataObj instanceof CrosstabHeaderCell) {
                        cell = (CrosstabHeaderCell)dataObj;
                        startCol = cell.getColumn();
                        startRow = cell.getRow();
                        eci = new EdgeComponentInfo(edge, startCol, startRow);
                        bFound = false;
                        for (i = 0; i < tempeci.size(); ++i) {
                            elem = (EdgeComponentInfo)tempeci.elementAt(i);
                            if (!elem.equals((Object)eci)) continue;
                            bFound = true;
                            break;
                        }
                        if (bFound) continue;
                        tempeci.addElement(eci);
                        continue;
                    }
                    tempeci.addElement(new EdgeComponentInfo(edge, col, row));
                }
            }
        }
        EdgeComponentInfo[] eci = new EdgeComponentInfo[tempeci.size()];
        for (r = 0; r < eci.length; ++r) {
            eci[r] = (EdgeComponentInfo)tempeci.elementAt(r);
        }
        return eci;
    }
}

