/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import oracle.dss.dataView.ColumnComponentHandle;
import oracle.dss.dataView.ColumnRangeComponentHandle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.DataRangeComponentHandle;
import oracle.dss.dataView.EdgeComponentHandle;
import oracle.dss.dataView.EdgeRangeComponentHandle;
import oracle.dss.dataView.RowComponentHandle;
import oracle.dss.dataView.RowRangeComponentHandle;
import oracle.dss.gridView.GridViewCommon;
import oracle.dss.pagingControl.PageItemComponentHandle;
import oracle.dss.rules.discriminator.CompositeDiscriminator;
import oracle.dss.rules.discriminator.Discriminator;
import oracle.dss.rules.discriminator.QDRDiscriminator;
import oracle.dss.util.ColumnComponentInfo;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.ComponentInfo;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.DataException;
import oracle.dss.util.EdgeComponentInfo;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.PageItemComponentInfo;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRMember;
import oracle.dss.util.RowComponentInfo;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public class CrosstabFormatUtil {
    private QDRDiscriminator m_qdrDisc = null;
    private QDR m_qdr = new QDR();
    private CompositeDiscriminator m_compDisc = null;
    private DataAccess dataAccess;
    private GridViewCommon m_crosstab;
    private ComponentHandle componentHandle;
    private static final String dimNameType = "layerName";
    private static final String memberNameType = "value";

    public CrosstabFormatUtil(GridViewCommon gridview, ComponentHandle component) {
        this.m_crosstab = gridview;
        this.componentHandle = component;
        this.dataAccess = gridview.getModel().getDataAccess();
        try {
            this.setQDR();
        }
        catch (DataException dataException) {
            // empty catch block
        }
    }

    public Discriminator getDiscriminator() {
        if (this.m_qdrDisc != null) {
            return this.m_qdrDisc;
        }
        return this.m_compDisc;
    }

    private boolean setQDR() throws EdgeOutOfRangeException, LayerOutOfRangeException, ColumnOutOfRangeException, RowOutOfRangeException, SliceOutOfRangeException {
        if (this.componentHandle == null) {
            return false;
        }
        boolean success = false;
        if (this.componentHandle.getID() == 13) {
            this.m_qdrDisc = new QDRDiscriminator(new QDR(), 4);
        } else {
            if (this.componentHandle.getID() == 25 || this.componentHandle.getID() == 24 || this.componentHandle instanceof PageItemComponentHandle) {
                String header;
                ComponentInfo ci = this.componentHandle.getComponentInfo();
                if (this.componentHandle instanceof RowComponentHandle) {
                    header = this.dataAccess.getLayerMetadata(0, ((RowComponentInfo)ci).getRow(), dimNameType).toString();
                    this.m_qdr = this.dataAccess.getLayerQDR(0, ((RowComponentInfo)ci).getRow(), 0);
                } else if (this.componentHandle instanceof ColumnComponentHandle) {
                    header = this.dataAccess.getLayerMetadata(1, ((ColumnComponentInfo)ci).getColumn(), dimNameType).toString();
                    this.m_qdr = this.dataAccess.getLayerQDR(1, ((ColumnComponentInfo)ci).getColumn(), 0);
                } else {
                    header = this.dataAccess.getLayerMetadata(2, ((PageItemComponentInfo)ci).getPageItem(), dimNameType).toString();
                    this.m_qdr = ci.getQDR(this.dataAccess, 0);
                }
                this.m_qdr.setTarget(new QDRMember(header));
                if (this.m_qdr != null) {
                    this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
                    return true;
                }
                return false;
            }
            if (this.componentHandle.getID() == 27 || this.componentHandle.getID() == 26) {
                ColumnRangeComponentHandle crch;
                ColumnComponentInfo[] cci;
                String header;
                int i;
                ArrayList<QDRDiscriminator> discs = null;
                if (this.componentHandle instanceof RowRangeComponentHandle) {
                    RowRangeComponentHandle rrch = (RowRangeComponentHandle)this.componentHandle;
                    RowComponentInfo[] rci = rrch.getLocationList();
                    if (rci.length > 0) {
                        discs = new ArrayList<QDRDiscriminator>();
                        for (i = 0; i < rci.length; ++i) {
                            header = this.dataAccess.getLayerMetadata(0, rci[i].getRow(), dimNameType).toString();
                            this.m_qdr = this.dataAccess.getLayerQDR(0, rci[i].getRow(), 0);
                            this.m_qdr.setTarget(new QDRMember(header));
                            if (this.m_qdr == null) continue;
                            this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
                            discs.add(this.m_qdrDisc);
                        }
                    }
                } else if (this.componentHandle instanceof ColumnRangeComponentHandle && (cci = (crch = (ColumnRangeComponentHandle)this.componentHandle).getLocationList()).length > 0) {
                    discs = new ArrayList();
                    for (i = 0; i < cci.length; ++i) {
                        header = this.dataAccess.getLayerMetadata(1, cci[i].getColumn(), dimNameType).toString();
                        this.m_qdr = this.dataAccess.getLayerQDR(1, cci[i].getColumn(), 0);
                        this.m_qdr.setTarget(new QDRMember(header));
                        if (this.m_qdr == null) continue;
                        this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
                        discs.add(this.m_qdrDisc);
                    }
                }
                if (discs != null && discs.size() > 0) {
                    if (discs.size() > 1) {
                        this.m_qdr = null;
                        this.m_qdrDisc = null;
                        Discriminator oldDisc = (Discriminator)discs.get(0);
                        CompositeDiscriminator compDisc = null;
                        for (i = 1; i < discs.size(); ++i) {
                            compDisc = new CompositeDiscriminator(oldDisc, (Discriminator)discs.get(i), 1);
                            oldDisc = compDisc;
                        }
                        this.m_compDisc = compDisc;
                    }
                    return true;
                }
                return false;
            }
            if (this.componentHandle instanceof EdgeComponentHandle) {
                EdgeComponentInfo ci = (EdgeComponentInfo)this.componentHandle.getComponentInfo();
                this.m_qdrDisc = this.createQDRDisc(ci);
                this.m_qdr = this.m_qdrDisc.getQDR();
                return true;
            }
            if (this.componentHandle instanceof EdgeRangeComponentHandle) {
                EdgeComponentInfo[] ci = ((EdgeRangeComponentHandle)this.componentHandle).getLocationList();
                if (ci.length == 1) {
                    this.m_qdrDisc = this.createQDRDisc(ci[0]);
                    this.m_qdr = this.m_qdrDisc.getQDR();
                    return true;
                }
                if (ci.length > 1) {
                    return this.createDiscriminator(ci);
                }
                return false;
            }
            if (this.componentHandle instanceof DataComponentHandle || this.componentHandle instanceof RowComponentHandle || this.componentHandle instanceof ColumnComponentHandle) {
                ComponentInfo ci = this.componentHandle.getComponentInfo();
                this.m_qdr = ci.getQDR(this.dataAccess, 0);
                if (this.m_qdr == null) {
                    return false;
                }
                this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
            } else if (this.componentHandle instanceof DataRangeComponentHandle) {
                DataComponentInfo[] ci = ((DataRangeComponentHandle)this.componentHandle).getLocationList();
                if (ci == null) {
                    return false;
                }
                boolean mixed = false;
                int colCount = this.dataAccess.getEdgeExtent(0);
                int rowCount = this.dataAccess.getEdgeExtent(1);
                Vector<Integer> selectedRows = new Vector<Integer>();
                Vector<Integer> selectedCols = new Vector<Integer>();
                boolean[][] selected = new boolean[rowCount][colCount];
                for (int i = 0; i < ci.length; ++i) {
                    int j;
                    int row = ci[i].getRow();
                    int col = ci[i].getColumn();
                    selected[row][col] = true;
                    boolean insert = false;
                    for (j = 0; j < selectedCols.size(); ++j) {
                        if ((Integer)selectedCols.elementAt(j) > col) {
                            selectedCols.insertElementAt(new Integer(col), j);
                            insert = true;
                            break;
                        }
                        if ((Integer)selectedCols.elementAt(j) != col) continue;
                        insert = true;
                        break;
                    }
                    if (!insert) {
                        selectedCols.addElement(new Integer(col));
                    }
                    insert = false;
                    for (j = 0; j < selectedRows.size(); ++j) {
                        if ((Integer)selectedRows.elementAt(j) > row) {
                            selectedRows.insertElementAt(new Integer(row), j);
                            insert = true;
                            break;
                        }
                        if ((Integer)selectedRows.elementAt(j) != row) continue;
                        insert = true;
                        break;
                    }
                    if (insert) continue;
                    selectedRows.addElement(new Integer(row));
                }
                int[] rows = new int[selectedRows.size()];
                int[] cols = new int[selectedCols.size()];
                for (int i = 0; i < selectedRows.size(); ++i) {
                    rows[i] = (Integer)selectedRows.elementAt(i);
                    for (int j = 0; j < selectedCols.size(); ++j) {
                        if (i == 0) {
                            cols[j] = (Integer)selectedCols.elementAt(j);
                        }
                        if (selected[rows[i]][cols[j]]) continue;
                        mixed = true;
                    }
                }
                boolean col_mixed = this.MergeQDR(0, cols, mixed);
                boolean row_mixed = this.MergeQDR(1, rows, mixed);
                if (col_mixed || row_mixed || mixed) {
                    this.processMixedQDR((ComponentInfo[])ci);
                } else {
                    this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
                }
            } else if (this.componentHandle instanceof ColumnRangeComponentHandle) {
                ColumnComponentInfo[] ci = ((ColumnRangeComponentHandle)this.componentHandle).getLocationList();
                if (ci == null) {
                    return false;
                }
                int startcol = ci[0].getColumn();
                int endcol = ci[ci.length - 1].getColumn();
                int edge = 0;
                int[] selectedData = new int[ci.length];
                for (int i = 0; i < ci.length; ++i) {
                    selectedData[i] = ci[i].getColumn();
                }
                if (this.MergeQDR(edge, selectedData, false)) {
                    this.processMixedQDR((ComponentInfo[])ci);
                } else {
                    this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
                }
            } else if (this.componentHandle instanceof RowRangeComponentHandle) {
                RowComponentInfo[] ci = ((RowRangeComponentHandle)this.componentHandle).getLocationList();
                if (ci == null) {
                    return false;
                }
                int startrow = ci[0].getRow();
                int endrow = ci[ci.length - 1].getRow();
                int edge = 1;
                int[] selectedData = new int[ci.length];
                for (int i = 0; i < ci.length; ++i) {
                    selectedData[i] = ci[i].getRow();
                }
                if (this.MergeQDR(edge, selectedData, false)) {
                    this.processMixedQDR((ComponentInfo[])ci);
                } else {
                    this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
                }
            } else {
                return false;
            }
        }
        if (this.m_qdrDisc != null) {
            this.m_qdrDisc.setQDR(this.m_qdr);
        }
        return true;
    }

    private QDRDiscriminator createQDRDisc(EdgeComponentInfo ci) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        String header = this.dataAccess.getLayerMetadata(ci.getEdge(), ci.getDepth(), dimNameType).toString();
        QDR qdr = ci.getQDR(this.dataAccess, 0);
        qdr.setTarget(new QDRMember(header));
        return new QDRDiscriminator(qdr, 4);
    }

    private boolean MergeQDR(int edge, int[] selectedData, boolean mixededges) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        int layerCount = this.dataAccess.getLayerCount(edge);
        return this.MergeQDR(edge, layerCount, selectedData, mixededges);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean MergeQDR(int edge, int layerCount, int[] selectedData, boolean mixededges) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        boolean mixed = false;
        Vector[] layer = new Vector[layerCount];
        int size = selectedData.length - 1;
        int currentMixedLayer = -1;
        int i = 0;
        while (true) {
            Vector oldmembers;
            int current_selected;
            int slice;
            if (i < layerCount) {
                slice = selectedData[0];
                current_selected = 0;
                oldmembers = null;
            } else {
                if (mixed) return mixed;
                break;
            }
            while (current_selected <= size) {
                int endslice;
                block19: {
                    Object member;
                    block20: {
                        Vector members;
                        block21: {
                            int startslice = this.dataAccess.getMemberStartSlice(edge, i, slice);
                            endslice = startslice + this.dataAccess.getMemberExtent(edge, i, startslice) - 1;
                            if (this.dataAccess.getMemberStartLayer(edge, i, startslice) != i) break block19;
                            member = this.dataAccess.getMemberMetadata(edge, i, startslice, memberNameType);
                            if (selectedData[0] >= startslice && selectedData[size] <= endslice) {
                                layer[i] = new Vector();
                                layer[i].addElement(member);
                                break;
                            }
                            if (currentMixedLayer != i && layer[i] == null) {
                                layer[i] = new Vector();
                            }
                            members = null;
                            if (i == layerCount - 1) break block20;
                            members = this.getAllMembers(edge, i + 1, startslice, endslice, selectedData);
                            if (oldmembers != null) break block21;
                            oldmembers = members;
                            if (currentMixedLayer != i) {
                                layer[i].addElement(member);
                            }
                            break block19;
                        }
                        if (this.equalVector(oldmembers, members)) {
                            if (currentMixedLayer != i && layer[i].indexOf(member) == -1) {
                                layer[i].addElement(member);
                            }
                            break block19;
                        } else {
                            currentMixedLayer = i + 1;
                            if (layer[i] != null && layer[i].indexOf(member) == -1) {
                                layer[i] = null;
                            }
                            for (int j = 0; j < i; ++j) {
                                if (layer[j] == null || layer[j].size() <= 1) continue;
                                layer[j] = null;
                            }
                            mixed = true;
                            break;
                        }
                    }
                    if (layer[i] != null && layer[i].indexOf(member) == -1) {
                        layer[i].addElement(member);
                    }
                }
                int j = 0;
                for (j = current_selected + 1; j <= size; ++j) {
                    if (selectedData[j] <= endslice) continue;
                    slice = selectedData[j];
                    current_selected = j;
                    break;
                }
                if (j <= size) continue;
            }
            ++i;
        }
        for (i = 0; i < layer.length; ++i) {
            if (layer[i] == null) continue;
            boolean collapse = true;
            String dimension = this.dataAccess.getLayerMetadata(edge, i, dimNameType).toString();
            Vector<String> data = new Vector<String>();
            for (int j = 0; j < layer[i].size(); ++j) {
                String member = (String)layer[i].elementAt(j);
                if (member != " ") {
                    collapse = false;
                }
                data.addElement(member);
            }
            if (collapse) continue;
            if (data.size() > 1) {
                if (mixededges) continue;
                this.m_qdr.addDimMemberPair(dimension, new QDRMember(3, data));
                continue;
            }
            if (data.elementAt(0) == null) continue;
            this.m_qdr.addDimMemberPair(dimension, new QDRMember(data.elementAt(0).toString()));
        }
        return mixed;
    }

    private boolean createDiscriminator(EdgeComponentInfo[] infos) throws EdgeOutOfRangeException, LayerOutOfRangeException, SliceOutOfRangeException {
        int edge = infos[0].getEdge();
        int layerCount = this.dataAccess.getLayerCount(edge);
        ArrayList[] layers = new ArrayList[layerCount];
        ArrayList[] eciLists = new ArrayList[layerCount];
        for (int i = 0; i < infos.length; ++i) {
            if (layers[infos[i].getDepth()] == null) {
                layers[infos[i].getDepth()] = new ArrayList();
                eciLists[infos[i].getDepth()] = new ArrayList();
            }
            layers[infos[i].getDepth()].add(new Integer(infos[i].getIndex()));
            eciLists[infos[i].getDepth()].add(infos[i]);
        }
        ArrayList<Object> discs = new ArrayList<Object>();
        for (int i = 0; i < layers.length; ++i) {
            if (layers[i] == null) continue;
            Collections.sort(layers[i]);
            int[] slices = new int[layers[i].size()];
            for (int j = 0; j < slices.length; ++j) {
                slices[j] = (Integer)layers[i].get(j);
            }
            boolean bMixed = this.MergeQDR(edge, i + 1, slices, false);
            if (!bMixed && this.m_qdr != null) {
                this.m_qdr.setTarget(new QDRMember(this.dataAccess.getLayerMetadata(edge, i, dimNameType).toString()));
                this.m_qdrDisc = new QDRDiscriminator(this.m_qdr, 4);
                discs.add(this.m_qdrDisc);
                continue;
            }
            if (!bMixed) continue;
            EdgeComponentInfo[] eciArray = new EdgeComponentInfo[eciLists[i].size()];
            eciArray = eciLists[i].toArray(eciArray);
            this.processMixedEdgeQDR(eciArray);
            if (this.m_compDisc == null) continue;
            discs.add(this.m_compDisc);
        }
        this.m_qdrDisc = null;
        this.m_qdr = null;
        this.m_compDisc = null;
        if (discs.size() == 1) {
            Object oDisc = discs.get(0);
            if (oDisc instanceof QDRDiscriminator) {
                this.m_qdrDisc = (QDRDiscriminator)oDisc;
                this.m_qdr = this.m_qdrDisc.getQDR();
                return true;
            }
            if (oDisc instanceof CompositeDiscriminator) {
                this.m_compDisc = (CompositeDiscriminator)oDisc;
                return true;
            }
        } else if (discs.size() > 1) {
            Discriminator oldDisc = (Discriminator)discs.get(0);
            CompositeDiscriminator compDisc = null;
            for (int i = 1; i < discs.size(); ++i) {
                compDisc = new CompositeDiscriminator(oldDisc, (Discriminator)discs.get(i), 1);
                oldDisc = compDisc;
            }
            this.m_compDisc = compDisc;
            return true;
        }
        return false;
    }

    private void processMixedQDR(ComponentInfo[] info) {
        if (info == null) {
            return;
        }
        QDRDiscriminator oldDisc = new QDRDiscriminator(info[0].getQDR(this.dataAccess, 0), 4);
        CompositeDiscriminator compDisc = null;
        for (int i = 1; i < info.length; ++i) {
            compDisc = new CompositeDiscriminator((Discriminator)oldDisc, (Discriminator)new QDRDiscriminator(info[i].getQDR(this.dataAccess, 0), 4), 1);
            oldDisc = compDisc;
        }
        this.m_compDisc = compDisc;
    }

    private void processMixedEdgeQDR(EdgeComponentInfo[] info) throws EdgeOutOfRangeException, LayerOutOfRangeException {
        if (info == null) {
            return;
        }
        QDR qdr = info[0].getQDR(this.dataAccess, 0);
        qdr.setTarget(new QDRMember(this.dataAccess.getLayerMetadata(info[0].getEdge(), info[0].getDepth(), dimNameType).toString()));
        QDRDiscriminator oldDisc = new QDRDiscriminator(qdr, 4);
        CompositeDiscriminator compDisc = null;
        for (int i = 1; i < info.length; ++i) {
            qdr = info[i].getQDR(this.dataAccess, 0);
            qdr.setTarget(new QDRMember(this.dataAccess.getLayerMetadata(info[i].getEdge(), info[i].getDepth(), dimNameType).toString()));
            compDisc = new CompositeDiscriminator((Discriminator)oldDisc, (Discriminator)new QDRDiscriminator(qdr, 4), 1);
            oldDisc = compDisc;
        }
        this.m_compDisc = compDisc;
    }

    private boolean equalVector(Vector first, Vector second) {
        if (first.size() != second.size()) {
            return false;
        }
        for (int i = 0; i < first.size(); ++i) {
            Object firstelement = first.elementAt(i);
            Object secondelement = second.elementAt(i);
            if (firstelement != null && secondelement != null && firstelement.equals(secondelement)) continue;
            return false;
        }
        return true;
    }

    private Vector getAllMembers(int edge, int layer, int startslice, int endslice, int[] selectedData) throws EdgeOutOfRangeException, SliceOutOfRangeException, LayerOutOfRangeException {
        Vector<Object> members = new Vector<Object>();
        while (startslice <= endslice) {
            int start = startslice;
            int end = startslice + this.dataAccess.getMemberExtent(edge, layer, startslice) - 1;
            boolean find = false;
            for (int j = 0; j < selectedData.length; ++j) {
                if (selectedData[j] < start || selectedData[j] > end) continue;
                find = true;
                break;
            }
            if (find && this.dataAccess.getMemberStartLayer(edge, layer, startslice) == layer) {
                Object member = this.dataAccess.getMemberMetadata(edge, layer, startslice, memberNameType);
                members.addElement(member);
            }
            startslice = end + 1;
        }
        return members;
    }

    private boolean isDimensionOnEdge(String dimension, int edge) {
        try {
            for (int i = 0; i < this.dataAccess.getLayerCount(edge); ++i) {
                if (!this.dataAccess.getLayerMetadata(edge, i, dimNameType).equals(dimension)) continue;
                return true;
            }
        }
        catch (EdgeOutOfRangeException e) {
        }
        catch (LayerOutOfRangeException layerOutOfRangeException) {
            // empty catch block
        }
        return false;
    }
}

